/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import ancestris.gedcom.privacy.PrivacyPolicy;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.GedcomOptions;
import genj.gedcom.Grammar;
import genj.gedcom.Indi;
import genj.gedcom.Media;
import genj.gedcom.MetaProperty;
import genj.gedcom.Note;
import genj.gedcom.PropertyAssociation;
import genj.gedcom.PropertyComparator2;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyEvent;
import genj.gedcom.PropertyEventDetails;
import genj.gedcom.PropertyFile;
import genj.gedcom.PropertyMedia;
import genj.gedcom.PropertyNote;
import genj.gedcom.PropertyPlace;
import genj.gedcom.PropertyRepository;
import genj.gedcom.PropertySharedNote;
import genj.gedcom.PropertySimpleReadOnly;
import genj.gedcom.PropertySimpleValue;
import genj.gedcom.PropertySource;
import genj.gedcom.PropertyVisitor;
import genj.gedcom.PropertyXRef;
import genj.gedcom.Repository;
import genj.gedcom.SNote;
import genj.gedcom.Source;
import genj.gedcom.TagPath;
import genj.gedcom.time.PointInTime;
import genj.io.InputSource;
import genj.util.Resources;
import genj.util.WordBuffer;
import genj.util.swing.ImageIcon;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openide.util.NbPreferences;

public abstract class Property
implements Comparable<Property> {
    protected static final String UNSUPPORTED_TAG = "Unsupported Tag";
    private static final Pattern FORMAT_PATTERN = Pattern.compile("\\{(.*?)\\$(.)(.*?)\\}");
    private Property parent = null;
    private List<Property> children = null;
    protected ImageIcon image;
    protected ImageIcon imageErr;
    protected ImageIcon imageWarn;
    protected boolean isTransient = false;
    private boolean isPrivate = false;
    protected static final Resources resources = Gedcom.resources;
    public static final String LABEL = resources.getString("prop");
    private String tag = null;
    private final boolean specific;
    protected String invalidReason = "err.notvalid";
    public static String DELIMITER_IN_ANCHOR = "+";
    public static String DELIMITER_IN_ANCHOR_REGEX = "\\+";
    private boolean isGuessed = false;
    private boolean isReadOnly = false;

    protected Property(String tag) {
        this.tag = tag;
        this.specific = tag.startsWith("_");
    }

    public boolean isSpecific() {
        return this.specific;
    }

    void afterAddNotify() {
    }

    void beforeDelNotify() {
        this.delProperties();
    }

    void propagateXRefLinked(PropertyXRef property1, PropertyXRef property2) {
        if (this.parent != null) {
            this.parent.propagateXRefLinked(property1, property2);
        }
    }

    void propagateXRefUnlinked(PropertyXRef property1, PropertyXRef property2) {
        if (this.parent != null) {
            this.parent.propagateXRefUnlinked(property1, property2);
        }
    }

    void propagatePropertyAdded(Property container, int pos, Property added) {
        if (this.parent != null) {
            this.parent.propagatePropertyAdded(container, pos, added);
        }
    }

    void propagatePropertyDeleted(Property container, int pos, Property deleted) {
        if (this.parent != null) {
            this.parent.propagatePropertyDeleted(container, pos, deleted);
        }
    }

    void propagatePropertyChanged(Property property, String oldValue) {
        if (this.parent != null) {
            this.parent.propagatePropertyChanged(property, oldValue);
        }
    }

    void propagatePropertyMoved(Property property, Property moved, int from, int to) {
        if (this.parent != null) {
            this.parent.propagatePropertyMoved(property, moved, from, to);
        }
    }

    public boolean addFile(InputSource file) {
        return this.addFile(file, "");
    }

    public boolean addFile(InputSource file, String title) {
        if (!this.getMetaProperty().allows("FILE")) {
            if (!this.getMetaProperty().allows("OBJE")) {
                return false;
            }
            return this.addProperty("OBJE", "").addFile(file, title);
        }
        List<PropertyFile> pfiles = this.getProperties(PropertyFile.class);
        PropertyFile pfile = pfiles.isEmpty() ? (PropertyFile)this.addProperty("FILE", "") : pfiles.get(0);
        Property ptitle = this.getProperty("TITL");
        if (ptitle != null) {
            ptitle.setValue(title);
        } else if (title.length() > 0) {
            this.addProperty("TITL", title);
        }
        return pfile.addFile(file);
    }

    public boolean addNote(Note note) {
        if (!this.getMetaProperty().allows("NOTE")) {
            return false;
        }
        PropertyNote xref = new PropertyNote();
        this.addProperty(xref);
        xref.setValue(note.getId());
        try {
            xref.link();
        }
        catch (GedcomException e) {
            Gedcom.LOG.log(Level.FINE, "unexpected", e);
            this.delProperty(xref);
            return false;
        }
        return true;
    }

    public boolean addSNote(SNote note) {
        if (!this.getMetaProperty().allows("SNOTE")) {
            return false;
        }
        PropertySharedNote xref = new PropertySharedNote();
        this.addProperty(xref);
        xref.setValue(note.getId());
        try {
            xref.link();
        }
        catch (GedcomException e) {
            Gedcom.LOG.log(Level.FINE, "unexpected", e);
            this.delProperty(xref);
            return false;
        }
        return true;
    }

    public boolean addMedia(Media media) {
        if (!this.getMetaProperty().allows("OBJE")) {
            return false;
        }
        PropertyMedia xref = new PropertyMedia();
        this.addProperty(xref);
        xref.setValue(media.getId());
        try {
            xref.link();
        }
        catch (GedcomException e) {
            Gedcom.LOG.log(Level.FINE, "unexpected", e);
            this.delProperty(xref);
            return false;
        }
        return true;
    }

    public boolean addSource(Source source) {
        if (!this.getMetaProperty().allows("SOUR")) {
            return false;
        }
        PropertySource xref = new PropertySource();
        this.addProperty(xref);
        xref.setValue(source.getId());
        try {
            xref.link();
        }
        catch (GedcomException e) {
            Gedcom.LOG.log(Level.FINE, "unexpected", e);
            this.delProperty(xref);
            return false;
        }
        return true;
    }

    public boolean addRepository(Repository repository) {
        if (!this.getMetaProperty().allows("REPO")) {
            return false;
        }
        PropertyRepository xref = new PropertyRepository();
        this.addProperty(xref);
        xref.setValue(repository.getId());
        try {
            xref.link();
        }
        catch (GedcomException e) {
            Gedcom.LOG.log(Level.FINE, "unexpected", e);
            this.delProperty(xref);
            return false;
        }
        return true;
    }

    public Property addProperty(String tag, String value) {
        try {
            return this.addProperty(tag, value, -1);
        }
        catch (GedcomException e) {
            return this.addProperty(new PropertySimpleReadOnly(tag, value), -1);
        }
    }

    public Property addProperty(String tag, String value, int pos) throws GedcomException {
        MetaProperty mp = this.getMetaProperty().getNested(tag, true);
        Property p = mp.create(value);
        return this.addProperty(p, pos);
    }

    public Property addSimpleProperty(String tag, String value, int pos) {
        return this.addProperty(new PropertySimpleValue(tag, value), pos);
    }

    public Property addPropertyXref(String tag, String value, int pos) {
        PropertyAssociation myProp = new PropertyAssociation(tag);
        myProp.setValue(value);
        return this.addProperty(myProp, pos);
    }

    Property addProperty(Property prop) {
        return this.addProperty(prop, -1);
    }

    Property addProperty(Property child, int pos) {
        if (child.getParent() != null || child.getNoOfProperties() > 0) {
            throw new IllegalArgumentException("Can't add a property that is already contained or contains properties");
        }
        if (pos < 0) {
            MetaProperty meta = this.getMetaProperty();
            int index = meta.getNestedIndex(child.getTag());
            for (pos = 0; pos < this.getNoOfProperties() && meta.getNestedIndex(this.getProperty(pos).getTag()) <= index; ++pos) {
            }
        } else if (pos > this.getNoOfProperties()) {
            pos = this.getNoOfProperties();
        }
        if (this.children == null) {
            this.children = new ArrayList<Property>();
        }
        this.children.add(pos, child);
        if (this.isTransient) {
            child.isTransient = true;
        }
        child.parent = this;
        this.propagatePropertyAdded(this, pos, child);
        child.afterAddNotify();
        return child;
    }

    public void delProperties() {
        if (this.children != null) {
            Property[] cs = this.children.toArray(new Property[this.children.size()]);
            for (int c = cs.length - 1; c >= 0; --c) {
                this.delProperty(cs[c]);
            }
            if (this.children.isEmpty()) {
                this.children = null;
            }
        }
    }

    public void delProperties(String tag) {
        if (this.children != null) {
            Property[] cs;
            for (Property c : cs = this.children.toArray(new Property[this.children.size()])) {
                if (!c.getTag().equals(tag)) continue;
                this.delProperty(c);
            }
            if (this.children.isEmpty()) {
                this.children = null;
            }
        }
    }

    public void delProperty(Property deletee) {
        if (this.children == null) {
            throw new IndexOutOfBoundsException("no such child");
        }
        if (deletee == null) {
            throw new IllegalArgumentException("can't delete null property");
        }
        int pos = 0;
        while (this.children.get(pos) != deletee) {
            ++pos;
        }
        this.delProperty(pos);
    }

    public void delProperty(int pos) {
        if (this.children == null || pos < 0 || pos >= this.children.size()) {
            throw new IndexOutOfBoundsException("Trying to delete a non existing property position.\nEntity/Property is : " + this.getEntity().toString(true) + ":" + this + ", position is '" + pos + "'.");
        }
        Property removed = this.children.get(pos);
        removed.beforeDelNotify();
        this.children.remove(pos);
        removed.parent = null;
        this.propagatePropertyDeleted(this, pos, removed);
    }

    public void eraseAll() {
        if (this.children != null) {
            this.children.clear();
        }
        this.children = null;
        this.parent = null;
        this.image = null;
        this.imageErr = null;
        this.tag = null;
    }

    public void moveProperties(List<Property> properties, int pos) {
        for (int i = 0; i < properties.size(); ++i) {
            Property prop = properties.get(i);
            pos = this.moveProperty(prop, pos);
        }
    }

    public int moveProperty(Property prop, int to) {
        return this.moveProperty(this.children.indexOf(prop), to);
    }

    public int moveProperty(int from, int to) {
        Property prop = this.children.remove(from);
        if (from < to) {
            --to;
        }
        this.children.add(to, prop);
        this.propagatePropertyMoved(this, prop, from, to);
        return to + 1;
    }

    public String getDeleteVeto() {
        return null;
    }

    public Entity getEntity() {
        return this.parent == null ? null : this.parent.getEntity();
    }

    public Gedcom getGedcom() {
        return this.parent != null ? this.parent.getGedcom() : null;
    }

    public boolean isVersion55() {
        return this.getGedcom() == null || this.getGedcom().getGrammar().equals(Grammar.V55);
    }

    public ImageIcon getImage() {
        return this.getImage(false);
    }

    public ImageIcon getImage(boolean checkValid) {
        if (!checkValid || this.isValid() && !this.hasWarning()) {
            if (this.image == null) {
                this.image = this.getGedcom() != null ? this.getMetaProperty().getImage() : MetaProperty.IMG_CUSTOM;
            }
            return this.image;
        }
        if (!this.isValid()) {
            if (this.imageErr == null) {
                this.imageErr = this.getMetaProperty().getImage("err");
            }
            return this.imageErr;
        }
        if (this.imageWarn == null) {
            this.imageWarn = this.getMetaProperty().getImage("warn");
        }
        return this.imageWarn;
    }

    public int getNoOfProperties() {
        return this.children == null ? 0 : this.children.size();
    }

    public Property getParent() {
        return this.parent;
    }

    public TagPath getPathToNested(Property nested) {
        Stack<String> result = new Stack<String>();
        nested.getPathToContaining(this, result);
        return new TagPath(result);
    }

    private void getPathToContaining(Property containing, Stack<String> result) {
        result.push(this.getTag());
        if (containing == this) {
            return;
        }
        if (this.parent == null) {
            throw new IllegalArgumentException("couldn't find containing " + containing);
        }
        this.parent.getPathToContaining(containing, result);
    }

    public TagPath getPath() {
        return this.getPath(false);
    }

    public TagPath getPath(boolean unique) {
        Stack<String> stack = new Stack<String>();
        String localTag = this.getTag();
        Property child = this;
        for (Property localParent = this.getParent(); localParent != null; localParent = localParent.getParent()) {
            if (unique) {
                Property sibling;
                int qualifier = 0;
                for (int i = 0; i < localParent.getNoOfProperties() && (sibling = localParent.getProperty(i)) != child; ++i) {
                    if (!sibling.getTag().equals(localTag)) continue;
                    ++qualifier;
                }
                stack.push(localTag + '?' + qualifier);
            } else {
                stack.push(localTag);
            }
            localTag = localParent.getTag();
            child = localParent;
        }
        stack.push(localTag);
        return new TagPath(stack);
    }

    public boolean contains(Property prop) {
        if (this.children == null) {
            return false;
        }
        for (int c = 0; c < this.children.size(); ++c) {
            Property child = this.children.get(c);
            if (child != prop && !child.contains(prop)) continue;
            return true;
        }
        return false;
    }

    public boolean isContained(Property in) {
        Property locParent = this.getParent();
        if (locParent == in) {
            return true;
        }
        return locParent == null ? false : locParent.isContained(in);
    }

    public boolean hasProperties(List<Property> props) {
        return this.children == null ? false : this.children.containsAll(props);
    }

    public Property[] getProperties() {
        return this.children == null ? new Property[]{} : Property.toArray(this.children);
    }

    public List<Property> findProperties(Pattern tag, Pattern value) {
        ArrayList<Property> result = new ArrayList<Property>();
        if (value == null) {
            value = Pattern.compile(".*");
        }
        this.findPropertiesRecursively(result, tag, value, true);
        return result;
    }

    protected boolean findPropertiesRecursivelyTest(Pattern tag, Pattern value) {
        return tag.matcher(this.getTag()).matches() && value.matcher(this.getValue()).matches();
    }

    private void findPropertiesRecursively(Collection<Property> result, Pattern tag, Pattern value, boolean recursively) {
        if (this.findPropertiesRecursivelyTest(tag, value)) {
            result.add(this);
        }
        int j = this.getNoOfProperties();
        for (int i = 0; i < j; ++i) {
            if (!recursively) continue;
            this.getProperty(i).findPropertiesRecursively(result, tag, value, recursively);
        }
    }

    public Property[] getProperties(String tag) {
        return this.getProperties(tag, false);
    }

    public Property[] getProperties(String tag, boolean validOnly) {
        ArrayList<Property> result = new ArrayList<Property>(this.getNoOfProperties());
        int j = this.getNoOfProperties();
        for (int i = 0; i < j; ++i) {
            Property prop = this.getProperty(i);
            if (!prop.getTag().equals(tag) || validOnly && !prop.isValid()) continue;
            result.add(prop);
        }
        return Property.toArray(result);
    }

    public <T> List<T> getProperties(Class<T> type) {
        ArrayList props = new ArrayList(10);
        this.getPropertiesRecursively(props, type);
        return props;
    }

    private <T> void getPropertiesRecursively(List<T> props, Class<T> type) {
        for (int c = 0; c < this.getNoOfProperties(); ++c) {
            Property child = this.getProperty(c);
            if (type.isAssignableFrom(child.getClass())) {
                props.add(child);
            }
            child.getPropertiesRecursively(props, type);
        }
    }

    public List<Property> getAllProperties(String tag) {
        ArrayList<Property> props = new ArrayList<Property>();
        this.getAllPropertiesRecursively(props, tag);
        return props;
    }

    private void getAllPropertiesRecursively(List<Property> props, String tag) {
        for (int c = 0; c < this.getNoOfProperties(); ++c) {
            Property child = this.getProperty(c);
            if (tag == null || tag.isEmpty() || child.getTag().equals(tag) || child.getPath().compareTo(TagPath.valueOf(tag)) == 0) {
                props.add(child);
            }
            child.getAllPropertiesRecursively(props, tag);
        }
    }

    public List<Property> getAllSpecificProperties() {
        ArrayList<Property> props = new ArrayList<Property>(10);
        this.getAllSpecificPropertiesRecursively(props);
        return props;
    }

    private void getAllSpecificPropertiesRecursively(List<Property> props) {
        for (int c = 0; c < this.getNoOfProperties(); ++c) {
            Property child = this.getProperty(c);
            if (child.isSpecific()) {
                props.add(child);
            }
            child.getAllSpecificPropertiesRecursively(props);
        }
    }

    public int getPropertyPosition(Property prop) {
        if (this.children == null) {
            throw new IllegalArgumentException("no such property");
        }
        for (int i = 0; i < this.children.size(); ++i) {
            if (this.children.get(i) != prop) continue;
            return i;
        }
        throw new IllegalArgumentException("no such property");
    }

    public Property getProperty(int n) {
        if (this.children == null) {
            throw new IndexOutOfBoundsException("no property " + n);
        }
        return this.children.get(n);
    }

    public Property getProperty(String tag) {
        return this.getProperty(tag, false);
    }

    public Property getProperty(String tag, boolean validOnly) {
        if (tag.indexOf(58) > 0) {
            throw new IllegalArgumentException("Path not allowed");
        }
        if (this.children != null) {
            for (Property child : this.children) {
                if (!child.getTag().equals(tag) || validOnly && !child.isValid()) continue;
                return child;
            }
        }
        return null;
    }

    public Property getPropertyByPath(String path) {
        return this.getProperty(new TagPath(path));
    }

    public Property getPropertyAtDate(String tag, PropertyDate pDate) {
        return this.getPropertyAtDate(new TagPath(tag), pDate);
    }

    public Property getPropertyAtDate(TagPath tagPath, PropertyDate pDate) {
        Property[] props = this.getProperties(tagPath);
        Property ret = null;
        if (props.length == 0) {
            return null;
        }
        if (props.length == 1) {
            return props[0];
        }
        List<Property> events = Arrays.asList(props);
        Collections.sort(events, (o1, o2) -> {
            PropertyDate d1 = (PropertyDate)((Property)o1).getProperty("DATE");
            PropertyDate d2 = (PropertyDate)((Property)o2).getProperty("DATE");
            if (d1 == null && d2 == null) {
                return 0;
            }
            if (d1 != null && d2 == null) {
                return -1;
            }
            if (d1 == null && d2 != null) {
                return 1;
            }
            return d2.compareTo(d1);
        });
        ret = events.get(0);
        PointInTime sourcePIT = null;
        PointInTime pointInTime = sourcePIT = pDate != null ? pDate.getStart() : null;
        if (sourcePIT == null) {
            return ret;
        }
        for (Property prop : events) {
            Property date = prop.getProperty("DATE");
            if (date != null) {
                PropertyDate pdate = (PropertyDate)date;
                PointInTime pitStart = pdate.getStart();
                if (sourcePIT.compareTo(pitStart) < 0) continue;
                ret = prop;
                break;
            }
            ret = prop;
            break;
        }
        return ret;
    }

    public Property getProperty(TagPath path) {
        return this.getProperty(path, true);
    }

    public Property getProperty(TagPath path, boolean backtrack) {
        final Property[] result = new Property[1];
        PropertyVisitor visitor = new PropertyVisitor(){

            @Override
            protected boolean leaf(Property prop) {
                result[0] = prop;
                return false;
            }
        };
        path.iterate(this, visitor, backtrack);
        return result[0];
    }

    public Property[] getProperties(TagPath path) {
        final ArrayList<Property> result = new ArrayList<Property>(10);
        PropertyVisitor visitor = new PropertyVisitor(){

            @Override
            protected boolean leaf(Property prop) {
                result.add(prop);
                return true;
            }
        };
        path.iterate(this, visitor);
        return Property.toArray(result);
    }

    public final String getTag() {
        return this.tag;
    }

    public abstract String getValue();

    public String getDisplayValue() {
        return this.getValue();
    }

    public String getReportValue() {
        return this.getDisplayValue();
    }

    public boolean isDisplayValueNull() {
        String theValue = this.getDisplayValue();
        return theValue == null || "".equals(theValue.trim());
    }

    public String getDisplayTitle() {
        Entity entity = this.getEntity();
        return entity.getDisplayTitle() + " - " + this.getPath().getName();
    }

    public String getDisplayDescription(int maxLen) {
        int cut;
        int len;
        String str = this.getDisplayValue().trim();
        if (!str.isEmpty() && maxLen != 0 && (len = str.length()) > maxLen && (cut = str.indexOf(" ", maxLen)) != -1) {
            str = str.substring(0, cut) + "...";
        }
        return str;
    }

    public String getPropertyValue(String tag) {
        Property child = this.getProperty(tag);
        return child != null ? child.getValue() : "";
    }

    public String getPropertyDisplayValue(String tag) {
        Property child = this.getProperty(tag);
        return child != null ? child.getDisplayValue() : "";
    }

    public String toString() {
        Property plac;
        Property date;
        WordBuffer result = new WordBuffer(" ");
        result.append(this.getPropertyName());
        result.append(":");
        String val = this.getDisplayValue();
        if (val.length() > 0) {
            result.append(val);
        }
        if ((date = this.getProperty("DATE")) instanceof PropertyDate && date.isValid()) {
            result.append(date.getDisplayValue());
        }
        if ((plac = this.getProperty("PLAC")) != null) {
            String s = plac.getDisplayValue();
            if (s.length() > 0) {
                result.append(plac.getDisplayValue());
            }
        } else {
            String s;
            Property city;
            Property addr = this.getProperty("ADDR");
            if (addr != null && (city = addr.getProperty("CITY")) != null && (s = city.getDisplayValue()).length() > 0) {
                result.append(s);
            }
        }
        return result.toString();
    }

    public String getValue(TagPath path, String fallback) {
        Property prop = this.getProperty(path);
        return prop == null ? fallback : prop.getValue();
    }

    public Property setValue(TagPath path, final String value) {
        final Property[] result = new Property[1];
        PropertyVisitor visitor = new PropertyVisitor(){

            @Override
            protected boolean leaf(Property prop) {
                if (prop instanceof PropertyXRef && ((PropertyXRef)prop).getTarget() != null) {
                    prop = prop.getParent().addProperty(prop.getTag(), "");
                }
                prop.setValue(value);
                result[0] = prop;
                return false;
            }

            @Override
            protected boolean recursion(Property parent, String child) {
                if (parent.getProperty(child, false) == null) {
                    parent.addProperty(child, "");
                }
                return true;
            }
        };
        path.iterate(this, visitor);
        return result[0];
    }

    public abstract void setValue(String var1);

    public boolean isValid() {
        boolean isUnderscoreValid = NbPreferences.forModule(Gedcom.class).getBoolean("isUnderscoreValid", true);
        if (!isUnderscoreValid && this.getTag().startsWith("_")) {
            this.invalidReason = "err.underscoreinvalid";
            return false;
        }
        boolean isEmptyValueValid = NbPreferences.forModule(Gedcom.class).getBoolean("isEmptyValueValid", false);
        if (!isEmptyValueValid && this.getValue().isEmpty() && this.getNoOfProperties() == 0) {
            this.invalidReason = "err.nullValue";
            return false;
        }
        return true;
    }

    public String getInvalidReason() {
        return this.isValid() ? "" : this.invalidReason;
    }

    public boolean hasWarning() {
        return false;
    }

    @Override
    public int compareTo(Property that) {
        if (this.getClass() != that.getClass()) {
            return this.compare(this.toString(), that.toString());
        }
        return this.getComparator().compare(this, that);
    }

    public PropertyComparator2 getComparator() {
        return this.getDisplayComparator();
    }

    public PropertyComparator2 getDisplayComparator() {
        return PropertyComparator2.Default.getInstance();
    }

    protected int compare(String s1, String s2) {
        Gedcom ged = this.getGedcom();
        if (ged != null) {
            return ged.getCollator().compare(s1, s2);
        }
        return s1.compareTo(s2);
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public boolean isGuessed() {
        return this.isGuessed;
    }

    public void setGuessed(boolean value) {
        this.isGuessed = value;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public void setReadOnly(boolean value) {
        this.isReadOnly = value;
    }

    public final Property addDefaultProperties() {
        MetaProperty[] subs;
        if (this.getEntity() == null) {
            throw new IllegalArgumentException("addDefaultProperties() while getEntity()==null!");
        }
        for (MetaProperty sub : subs = this.getNestedMetaProperties(2)) {
            if (this.getProperty(sub.getTag()) != null) continue;
            this.addProperty(sub.getTag(), "").addDefaultProperties();
        }
        return this;
    }

    public MetaProperty getMetaProperty() {
        return this.getGedcom().getGrammar().getMeta(this.getPath());
    }

    public MetaProperty[] getNestedMetaProperties(int filter) {
        return this.getMetaProperty().getAllNested(this, filter);
    }

    public static Property[] toArray(Collection<Property> ps) {
        return ps.toArray(new Property[ps.size()]);
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }

    public boolean isSecret() {
        return this.isPrivate && "unknown".equals(this.getGedcom().getPassword());
    }

    public void setPrivate(boolean set, boolean recursively) {
        if (recursively) {
            for (int c = 0; c < this.getNoOfProperties(); ++c) {
                Property child = this.getProperty(c);
                child.setPrivate(set, recursively);
            }
        }
        this.isPrivate = set;
        this.propagatePropertyChanged(this, this.getValue());
    }

    public boolean isEvent() {
        if (this.getGedcom() == null || this.getGedcom().getGrammar() == null) {
            return false;
        }
        Entity ent = this.getEntity();
        if (ent != null && ent instanceof Fam && this != ent) {
            return this.getMetaProperty().allows("HUSB");
        }
        return this.getMetaProperty().allows("AGE");
    }

    public String getPropertyInfo() {
        return this.getMetaProperty().getInfo();
    }

    public String getPropertyName() {
        return Gedcom.getName(this.getTag());
    }

    public static String getPropertyNames(Iterable<? extends Property> properties, int limit) {
        WordBuffer result = new WordBuffer(", ");
        int i = 0;
        for (Property property : properties) {
            if (i == limit) {
                result.append("...");
                break;
            }
            result.append(property.getPropertyName());
        }
        return result.toString();
    }

    public static List<Property> normalize(List<? extends Property> properties) {
        ArrayList<Property> result = new ArrayList<Property>(properties.size());
        for (Property property : properties) {
            Property parent;
            if (property.isTransient()) continue;
            for (parent = property.getParent(); parent != null && !properties.contains(parent); parent = parent.getParent()) {
            }
            if (parent != null) continue;
            result.add(property);
        }
        return result;
    }

    public String format(String format) {
        return this.format(format, PrivacyPolicy.getDefault().getAllPublic());
    }

    public String format(String format, PrivacyPolicy policy) {
        return this.format(format, policy, false, false);
    }

    public String format(String format, PrivacyPolicy policy, boolean isReport) {
        return this.format(format, policy, isReport, false);
    }

    public String format(String format, PrivacyPolicy policy, boolean isReport, boolean isValue) {
        if (format == null) {
            return "";
        }
        Matcher matcher = FORMAT_PATTERN.matcher(format);
        StringBuilder result = new StringBuilder(format.length() + 20);
        int masked = 0;
        int matches = 0;
        int cursor = 0;
        while (matcher.find()) {
            result.append(format.substring(cursor, matcher.start()));
            String prefix = matcher.group(1);
            char marker = format.charAt(matcher.start(2));
            String suffix = matcher.group(3);
            PropertyFormatter formatter = this.formatImpl(marker, isReport);
            Property prop = formatter.getProp();
            String value = formatter.getValue();
            if (prop != null && policy.isPrivate(prop)) {
                String string = value = masked++ == 0 || prefix.trim().length() > 0 ? GedcomOptions.getInstance().getMaskPrivate() : "";
            }
            if (value != null) {
                result.append(prefix);
                result.append(value);
                result.append(suffix);
                if (prop != null) {
                    ++matches;
                }
            }
            cursor = matcher.end();
        }
        result.append(format.substring(cursor));
        if (isValue) {
            return result.toString();
        }
        return matches > 0 ? result.toString() : "";
    }

    PropertyFormatter formatImpl(char marker) {
        return this.formatImpl(marker, false);
    }

    PropertyFormatter formatImpl(char marker, boolean isReport) {
        Property property = this;
        Property prop = null;
        String value = "";
        switch (marker) {
            case 'D': {
                prop = property.getProperty("DATE");
                if (prop instanceof PropertyDate && prop.isValid()) {
                    value = isReport ? prop.getReportValue() : prop.getDisplayValue();
                    break;
                }
                if (property instanceof PropertyEvent) {
                    Boolean kthh = ((PropertyEvent)property).isKnownToHaveHappened();
                    if (kthh != null && kthh.booleanValue()) {
                        prop = property;
                        value = isReport ? property.getReportValue() : property.getDisplayValue();
                        break;
                    }
                    value = "";
                    break;
                }
                value = "";
                break;
            }
            case 'y': {
                prop = property.getProperty("DATE");
                value = prop instanceof PropertyDate && prop.isValid() ? Integer.toString(((PropertyDate)prop).getStart().getYear()) : null;
                break;
            }
            case 'p': {
                prop = property.getProperty("PLAC");
                value = prop instanceof PropertyPlace ? ((PropertyPlace)prop).getCity() : null;
                break;
            }
            case 'P': {
                prop = property.getProperty("PLAC");
                value = prop instanceof PropertyPlace ? (isReport ? prop.getReportValue() : prop.getDisplayValue()) : null;
                break;
            }
            case 'n': {
                prop = property;
                if (prop instanceof PropertyXRef) {
                    Entity entity = ((PropertyXRef)prop).getTargetEntity();
                    if (entity instanceof Indi) {
                        value = ((Indi)entity).getName();
                        break;
                    }
                    if (entity instanceof Fam) {
                        value = ((Fam)entity).getNames();
                        break;
                    }
                    value = entity.toString();
                    break;
                }
                if (prop instanceof Entity) {
                    Entity entity = (Entity)prop;
                    if (entity instanceof Indi) {
                        value = ((Indi)entity).getName();
                        break;
                    }
                    if (entity instanceof Fam) {
                        value = ((Fam)entity).getNames();
                        break;
                    }
                    value = entity.toString();
                    break;
                }
                value = isReport ? prop.getReportValue() : prop.getDisplayValue();
                break;
            }
            case 'N': {
                prop = property;
                value = prop instanceof PropertyXRef ? ((PropertyXRef)prop).getTargetEntity().toString(true) : (isReport ? prop.getReportValue() : prop.getDisplayValue());
                break;
            }
            case 'v': {
                prop = property;
                value = isReport ? property.getReportValue() : property.getDisplayValue();
                break;
            }
            case 'V': {
                prop = property;
                value = property.getValue();
                if (!(prop instanceof PropertyXRef) || !value.startsWith("@") || !value.endsWith("@")) break;
                value = value.substring(1, value.length() - 1);
                break;
            }
            case 't': {
                prop = null;
                value = property.getTag();
                break;
            }
            case 'T': {
                prop = null;
                value = isReport ? Gedcom.getReportName(property.getTag()) : Gedcom.getName(property.getTag());
                break;
            }
            case 'e': {
                prop = property;
                value = "";
                break;
            }
            default: {
                if (!Character.isDigit(marker)) break;
                value = "";
                prop = property;
                String[] splitValues = prop.getValue().split(", *");
                int i = Character.digit(marker, 10) - 1;
                if (i < 0) {
                    value = prop.getValue();
                    break;
                }
                if (i >= splitValues.length) break;
                value = splitValues[i];
                break;
            }
        }
        return new PropertyFormatter(prop, value);
    }

    public PropertyDate getWhen() {
        for (Property cursor = this; cursor != null; cursor = cursor.getParent()) {
            if (this instanceof PropertyDate) {
                return (PropertyDate)this;
            }
            if (!(this instanceof PropertyEventDetails)) continue;
            return ((PropertyEventDetails)this).getDate();
        }
        return null;
    }

    public void copyProperties(Property[] roots, boolean useValues) throws GedcomException {
        for (Property property : roots) {
            this.copyProperties(property, useValues);
        }
    }

    public void copyProperties(Property root, boolean useValues) throws GedcomException {
        Property copy = this.getProperty(root.getTag(), false);
        if (copy == null) {
            copy = this.addProperty(root.getTag(), useValues ? root.getValue() : "");
            if (useValues && copy instanceof PropertyXRef) {
                try {
                    ((PropertyXRef)copy).link();
                }
                catch (GedcomException e) {
                    throw new GedcomException("Can't copy '" + root.getTag() + " " + root.getDisplayValue() + "' to " + this.getPath() + ": " + e.getMessage());
                }
            }
        }
        for (int i = 0; i < root.getNoOfProperties(); ++i) {
            Property child = root.getProperty(i);
            if (child.isTransient()) continue;
            copy.copyProperties(child, useValues);
        }
    }

    protected final void assertTag(String tag) {
        if (!this.tag.equals(tag)) {
            throw new Error("Tag should be " + tag + " but is " + this.tag);
        }
    }

    public String getLinkAnchor() {
        Entity entity = this.getEntity();
        if (entity != null) {
            return entity.getTag() + DELIMITER_IN_ANCHOR + entity.getId() + DELIMITER_IN_ANCHOR + this.getPath(true).toString();
        }
        return "XXXX" + DELIMITER_IN_ANCHOR + "XXXX" + DELIMITER_IN_ANCHOR + this.getPath(true).toString();
    }

    static class PropertyFormatter {
        private final Property prop;
        private final String value;

        public Property getProp() {
            return this.prop;
        }

        public String getValue() {
            return this.value;
        }

        PropertyFormatter(Property property, String value) {
            this.prop = property;
            this.value = value;
        }
    }
}

