/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom.time;

import ancestris.core.TextOptions;
import genj.gedcom.time.Calendar;
import genj.gedcom.time.PointInTime;
import genj.util.Resources;
import genj.util.WordBuffer;
import java.util.Locale;
import java.util.StringTokenizer;

public class Delta
implements Comparable<Delta> {
    public static final String TXT_DAY = PointInTime.resources.getString("time.day");
    public static final String TXT_DAYS = PointInTime.resources.getString("time.days");
    public static final String TXT_DAYSS;
    public static final String TXT_MONTH;
    public static final String TXT_MONTHS;
    public static final String TXT_MONTHSS;
    public static final String TXT_YEAR;
    public static final String TXT_YEARS;
    public static final String TXT_YEARSS;
    private int years;
    private int months;
    private int days;
    private Calendar calendar;

    public Delta(int d, int m, int y) {
        this(d, m, y, PointInTime.GREGORIAN);
    }

    public Delta(int d, int m, int y, Calendar c) {
        this.years = y;
        this.months = m;
        this.days = d;
        this.calendar = c;
    }

    private static String getSecondPlural(Resources resource, String key) {
        String ss = resource.getString(key + "s");
        if (ss.equals(key + "s")) {
            return resource.getString(key);
        }
        return ss;
    }

    public int getYears() {
        return this.years;
    }

    public int getMonths() {
        return this.months;
    }

    public int getDays() {
        return this.days;
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public static Delta get(PointInTime earlier, PointInTime later, Calendar calendar) {
        try {
            earlier = earlier.getPointInTime(calendar);
            later = later.getPointInTime(calendar);
        }
        catch (Throwable t) {
            return null;
        }
        if (earlier.compareTo(later) > 0) {
            PointInTime p = earlier;
            earlier = later;
            later = p;
        }
        int yearlier = earlier.getYear();
        int mearlier = earlier.getMonth();
        int dearlier = earlier.getDay();
        if (earlier.getCalendar() == PointInTime.GREGORIAN && yearlier < 0) {
            ++yearlier;
        }
        int ylater = later.getYear();
        int mlater = later.getMonth();
        int dlater = later.getDay();
        if (later.getCalendar() == PointInTime.GREGORIAN && ylater < 0) {
            ++ylater;
        }
        if (yearlier == Integer.MAX_VALUE || ylater == Integer.MAX_VALUE) {
            return null;
        }
        int years = ylater - yearlier;
        int months = 0;
        int days = 0;
        if (mearlier != Integer.MAX_VALUE && mlater != Integer.MAX_VALUE) {
            months = mlater - mearlier;
            if (dearlier != Integer.MAX_VALUE && dlater != Integer.MAX_VALUE && (days = dlater - dearlier) < 0) {
                --months;
                int previousMonth = mlater - 1;
                int previousYear = ylater;
                if (previousMonth < 0) {
                    previousMonth += calendar.getMonths();
                    --previousYear;
                }
                days += calendar.getDays(previousMonth, previousYear);
            }
            if (months < 0) {
                --years;
                months += calendar.getMonths();
            }
        }
        return new Delta(days, months, years, calendar);
    }

    public static Delta get(PointInTime earlier, PointInTime later) {
        return Delta.get(earlier, later, PointInTime.GREGORIAN);
    }

    @Override
    public int compareTo(Delta other) {
        int delta = this.years - other.years;
        if (delta != 0) {
            return delta;
        }
        delta = this.months - other.months;
        if (delta != 0) {
            return delta;
        }
        delta = this.days - other.days;
        return delta;
    }

    public boolean isZero() {
        return 0 == this.days && 0 == this.months && 0 == this.years;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Delta)) {
            return false;
        }
        Delta d = (Delta)obj;
        return d.calendar == this.calendar && d.days == this.days && d.months == this.months && d.years == this.years;
    }

    public int hashCode() {
        return this.calendar.hashCode() + this.days + this.months + this.years;
    }

    public String toReportString() {
        return this.toString(TextOptions.getInstance().getOutputLocale());
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(Locale locale) {
        int form;
        String textYearss;
        boolean isLocale = locale != null;
        Resources localResources = null;
        if (isLocale) {
            localResources = Resources.get(PointInTime.class, locale);
        }
        String textDay = isLocale ? localResources.getString("time.day") : TXT_DAY;
        String textDays = isLocale ? localResources.getString("time.days") : TXT_DAYS;
        String textDayss = isLocale ? Delta.getSecondPlural(localResources, "time.days") : TXT_DAYSS;
        String textMonth = isLocale ? localResources.getString("time.month") : TXT_MONTH;
        String textMonths = isLocale ? localResources.getString("time.months") : TXT_MONTHS;
        String textMonthss = isLocale ? Delta.getSecondPlural(localResources, "time.months") : TXT_MONTHSS;
        String textYear = isLocale ? localResources.getString("time.year") : TXT_YEAR;
        String textYears = isLocale ? localResources.getString("time.years") : TXT_YEARS;
        String string = textYearss = isLocale ? Delta.getSecondPlural(localResources, "time.years") : TXT_YEARSS;
        if (this.years == 0 && this.months == 0 && this.days == 0) {
            return "<1 " + textDay;
        }
        WordBuffer buffer = new WordBuffer();
        if (this.years > 0) {
            buffer.append(this.years);
            form = this.getPluralForm(this.years);
            switch (form) {
                case 1: {
                    buffer.append(textYear);
                    break;
                }
                case 2: {
                    buffer.append(textYears);
                    break;
                }
                default: {
                    buffer.append(textYearss);
                }
            }
        }
        if (this.months > 0) {
            buffer.append(this.months);
            form = this.getPluralForm(this.months);
            switch (form) {
                case 1: {
                    buffer.append(textMonth);
                    break;
                }
                case 2: {
                    buffer.append(textMonths);
                    break;
                }
                default: {
                    buffer.append(textMonthss);
                }
            }
        }
        if (this.days > 0) {
            buffer.append(this.days);
            form = this.getPluralForm(this.days);
            switch (form) {
                case 1: {
                    buffer.append(textDay);
                    break;
                }
                case 2: {
                    buffer.append(textDays);
                    break;
                }
                default: {
                    buffer.append(textDayss);
                }
            }
        }
        return buffer.toString();
    }

    private int getPluralForm(int number) {
        if ((number = Math.abs(number)) == 1) {
            return 1;
        }
        if (number % 100 / 10 != 1 && number % 10 >= 2 && number % 10 <= 4) {
            return 2;
        }
        return 3;
    }

    public String getValue() {
        WordBuffer buffer = new WordBuffer();
        if (this.years > 0) {
            buffer.append(this.years + "y");
        }
        if (this.months > 0) {
            buffer.append(this.months + "m");
        }
        if (this.years == 0 && this.months == 0 || this.years > 0 && this.months > 0 || this.days > 0) {
            buffer.append(this.days + "d");
        }
        return buffer.toString();
    }

    public void setValue(Delta other) {
        this.years = other.years;
        this.months = other.months;
        this.days = other.days;
        this.calendar = other.calendar;
    }

    public boolean setValue(String value) {
        this.years = 0;
        this.months = 0;
        this.days = 0;
        StringTokenizer tokens = new StringTokenizer(value);
        block7: while (tokens.hasMoreTokens()) {
            int i;
            String token = tokens.nextToken();
            int len = token.length();
            if (len < 2) {
                return false;
            }
            for (i = 0; i < len - 1; ++i) {
                if (Character.isDigit(token.charAt(i))) continue;
                return false;
            }
            try {
                i = Integer.parseInt(token.substring(0, token.length() - 1));
            }
            catch (NumberFormatException e) {
                return false;
            }
            switch (token.charAt(len - 1)) {
                case 'y': {
                    this.years = i;
                    continue block7;
                }
                case 'm': {
                    this.months = i;
                    continue block7;
                }
                case 'd': {
                    this.days = i;
                    continue block7;
                }
            }
            return false;
        }
        return true;
    }

    static {
        TXT_MONTH = PointInTime.resources.getString("time.month");
        TXT_MONTHS = PointInTime.resources.getString("time.months");
        TXT_YEAR = PointInTime.resources.getString("time.year");
        TXT_YEARS = PointInTime.resources.getString("time.years");
        TXT_DAYSS = Delta.getSecondPlural(PointInTime.resources, "time.days");
        TXT_MONTHSS = Delta.getSecondPlural(PointInTime.resources, "time.months");
        TXT_YEARSS = Delta.getSecondPlural(PointInTime.resources, "time.years");
    }
}

