/*
 * Decompiled with CFR 0.152.
 */
package genj.print;

import genj.print.PrintTask;
import genj.util.Registry;
import genj.util.WordBuffer;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.Attribute;
import javax.print.attribute.AttributeSet;
import javax.print.attribute.EnumSyntax;
import javax.print.attribute.IntegerSyntax;
import javax.print.attribute.TextSyntax;
import javax.print.attribute.URISyntax;
import javax.print.attribute.standard.MediaPrintableArea;

public class PrintRegistry
extends Registry {
    public static PrintRegistry get(Object source) {
        Registry r = Registry.get(source);
        return new PrintRegistry(r);
    }

    private PrintRegistry(Registry registry) {
        super(registry, "");
    }

    public void put(PrintService service) {
        super.put("service", service.getName());
    }

    public PrintService get(PrintService def) {
        String name = super.get("service", "");
        PrintService[] services = PrintServiceLookup.lookupPrintServices(null, null);
        for (int i = 0; i < services.length; ++i) {
            if (!services[i].getName().equals(name)) continue;
            return services[i];
        }
        return def;
    }

    public void put(AttributeSet set) {
        WordBuffer track = new WordBuffer();
        Attribute[] attrs = set.toArray();
        for (int i = 0; i < attrs.length; ++i) {
            String key = this.put(attrs[i]);
            if (key == null) continue;
            track.append(key);
        }
        super.put("attributes", track.toString());
    }

    public void get(AttributeSet set) {
        StringTokenizer attributes = new StringTokenizer(super.get("attributes", ""));
        while (attributes.hasMoreTokens()) {
            String attribute = attributes.nextToken();
            try {
                Attribute a = this.get(Class.forName(attribute), null);
                if (a != null) {
                    set.add(a);
                    continue;
                }
                PrintTask.LOG.log(Level.INFO, "Couldn't restore print attribute " + attribute);
            }
            catch (Throwable t) {
                PrintTask.LOG.log(Level.WARNING, "Error restoring print attribute " + attribute, t);
            }
        }
    }

    public String put(Attribute attr) {
        if (attr instanceof EnumSyntax) {
            return this.put((EnumSyntax)((Object)attr));
        }
        if (attr instanceof IntegerSyntax) {
            return this.put((IntegerSyntax)((Object)attr));
        }
        if (attr instanceof URISyntax) {
            return this.put((URISyntax)((Object)attr));
        }
        if (attr instanceof MediaPrintableArea) {
            return this.put((MediaPrintableArea)attr);
        }
        if (attr instanceof TextSyntax) {
            return this.put((TextSyntax)((Object)attr));
        }
        return null;
    }

    public Attribute get(Class<Attribute> type, Attribute def) {
        if (!Attribute.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException("only Attribute types allowed");
        }
        if (def != null && !type.isAssignableFrom(def.getClass())) {
            throw new IllegalArgumentException("def/Attribute types mismatch");
        }
        if (EnumSyntax.class.isAssignableFrom(type)) {
            return this.getEnumSyntax(type, def);
        }
        if (IntegerSyntax.class.isAssignableFrom(type)) {
            return this.getIntegerSyntax(type, def);
        }
        if (URISyntax.class.isAssignableFrom(type)) {
            return this.getURISyntax(type, def);
        }
        if (MediaPrintableArea.class.isAssignableFrom(type)) {
            return this.getMediaPrintableArea(def);
        }
        if (TextSyntax.class.isAssignableFrom(type)) {
            return this.getTextSyntax(type, def);
        }
        return null;
    }

    private String put(TextSyntax syntax) {
        String key = syntax.getClass().getName();
        super.put(key, syntax.getValue());
        return key;
    }

    private Attribute getTextSyntax(Class<Attribute> type, Attribute def) {
        String txt = super.get(type.getName(), (String)null);
        if (txt == null) {
            return def;
        }
        try {
            return type.getConstructor(String.class, Locale.class).newInstance(txt, null);
        }
        catch (Throwable t) {
            return def;
        }
    }

    private String put(URISyntax syntax) {
        String key = syntax.getClass().getName();
        super.put(key, "" + syntax.getURI());
        return key;
    }

    private Attribute getURISyntax(Class<Attribute> type, Attribute def) {
        String uri = super.get(type.getName(), (String)null);
        if (uri == null) {
            return def;
        }
        try {
            return type.getConstructor(URI.class).newInstance(new URI(uri));
        }
        catch (Throwable t) {
            return def;
        }
    }

    private String put(IntegerSyntax syntax) {
        String key = syntax.getClass().getName();
        super.put(key, syntax.getValue());
        return key;
    }

    private Attribute getIntegerSyntax(Class<Attribute> type, Attribute def) {
        int i = super.get(type.getName(), -1);
        if (i < 0) {
            return def;
        }
        try {
            return type.getConstructor(Integer.TYPE).newInstance(new Integer(i));
        }
        catch (Throwable t) {
            return def;
        }
    }

    private String put(EnumSyntax syntax) {
        String key = syntax.getClass().getName();
        super.put(key, syntax.getValue());
        return key;
    }

    private Attribute getEnumSyntax(Class<Attribute> type, Attribute def) {
        int i = super.get(type.getName(), -1);
        if (i < 0) {
            return def;
        }
        try {
            Field[] fields = type.getFields();
            for (int f = 0; f < fields.length; ++f) {
                EnumSyntax e;
                Field field = fields[f];
                if (!Modifier.isPublic(field.getModifiers()) || !Modifier.isStatic(field.getModifiers()) || field.getType() != type || (e = (EnumSyntax)field.get(null)).getValue() != i) continue;
                return (Attribute)((Object)e);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return def;
    }

    private String put(MediaPrintableArea area) {
        String key = area.getClass().getName();
        super.put(key + ".x", area.getX(25400));
        super.put(key + ".y", area.getY(25400));
        super.put(key + ".w", area.getWidth(25400));
        super.put(key + ".h", area.getHeight(25400));
        return key;
    }

    private Attribute getMediaPrintableArea(Attribute def) {
        String prefix = MediaPrintableArea.class.getName() + ".";
        float x = super.get(prefix + 'x', -1.0f);
        float y = super.get(prefix + 'y', -1.0f);
        float w = super.get(prefix + 'w', -1.0f);
        float h = super.get(prefix + 'h', -1.0f);
        if (x < 0.0f || y < 0.0f || w < 0.0f || h < 0.0f) {
            return def;
        }
        try {
            return new MediaPrintableArea(x, y, w, h, 25400);
        }
        catch (IllegalArgumentException e) {
            return def;
        }
    }
}

