/*
 * Decompiled with CFR 0.152.
 */
package swingx.dnd.tree;

import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import swingx.dnd.ObjectTransferable;
import swingx.dnd.tree.DnDTreeModel;

public class DefaultDnDTreeModel
extends DefaultTreeModel
implements DnDTreeModel {
    private static DefaultDnDTreeModel currentDrag;
    private static boolean dragYielded;

    public DefaultDnDTreeModel(TreeNode root) {
        super(root);
    }

    @Override
    public Transferable createTransferable(Object[] nodes) {
        currentDrag = this;
        dragYielded = false;
        return new ObjectTransferable((Object)nodes);
    }

    protected Object[] getNodes(Transferable transferable) throws UnsupportedFlavorException, IOException {
        return (Object[])ObjectTransferable.getObject((Transferable)transferable);
    }

    @Override
    public int getDragActions(Transferable transferable) {
        try {
            Object[] nodes = this.getNodes(transferable);
            for (int c = 0; c < nodes.length; ++c) {
                if (((MutableTreeNode)nodes[c]).getParent() != null) continue;
                return 0;
            }
            return 2;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    @Override
    public int getDropActions(Transferable transferable, Object parent, int index) {
        try {
            Object[] nodes = (Object[])ObjectTransferable.getObject((Transferable)transferable);
            for (int c = 0; c < nodes.length; ++c) {
                if (!DefaultDnDTreeModel.isNodeAncestor((MutableTreeNode)nodes[c], (MutableTreeNode)parent)) continue;
                return 0;
            }
            return 2;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    @Override
    public void drag(Transferable transferable, int action) throws UnsupportedFlavorException, IOException {
        if (!dragYielded && action == 2) {
            Object[] nodes = this.getNodes(transferable);
            for (int n = nodes.length - 1; n >= 0; --n) {
                this.removeNodeFromParent((MutableTreeNode)nodes[n]);
            }
        }
        currentDrag = null;
    }

    @Override
    public void drop(Transferable transferable, Object parent, int index, int action) throws UnsupportedFlavorException, IOException {
        if (action != 2) {
            throw new IllegalArgumentException("action not supported: " + action);
        }
        if (currentDrag != null) {
            index = this.yieldDrag(transferable, parent, index, action);
        }
        Object[] nodes = this.getNodes(transferable);
        for (int n = 0; n < nodes.length; ++n) {
            this.insertNodeInto((MutableTreeNode)nodes[n], (MutableTreeNode)parent, index + n);
        }
    }

    protected int yieldDrag(Transferable transferable, Object parent, int index, int action) throws UnsupportedFlavorException, IOException {
        Object[] nodes = this.getNodes(transferable);
        for (int n = 0; n < nodes.length; ++n) {
            TreeNode node = (TreeNode)nodes[n];
            if (node.getParent() != parent || node.getParent().getIndex(node) >= index) continue;
            --index;
        }
        currentDrag.drag(transferable, action);
        dragYielded = true;
        return index;
    }

    @Override
    public void releaseTransferable(Transferable transferable) {
        currentDrag = null;
        dragYielded = false;
    }

    private static boolean isNodeAncestor(TreeNode ancestoreCandidate, TreeNode node) {
        do {
            if (ancestoreCandidate != node) continue;
            return true;
        } while ((node = node.getParent()) != null);
        return false;
    }
}

