/*
 * Decompiled with CFR 0.152.
 */
package genj.search;

import ancestris.api.search.SearchCommunicator;
import ancestris.awt.FilteredMouseAdapter;
import ancestris.core.actions.AbstractAncestrisAction;
import ancestris.core.pluginservice.AncestrisPlugin;
import ancestris.gedcom.ActionSaveViewAsGedcom;
import ancestris.swing.ToolBar;
import ancestris.util.Utilities;
import ancestris.util.swing.DialogManager;
import ancestris.util.swing.FileChooserBuilder;
import ancestris.view.SelectionDispatcher;
import genj.edit.beans.DateBean;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomListener;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyXRef;
import genj.io.Filter;
import genj.report.ReportSubMenu;
import genj.search.Hit;
import genj.search.SettingsPanel;
import genj.search.Worker;
import genj.search.WorkerListener;
import genj.search.WorkerMulti;
import genj.search.WorkerTag;
import genj.util.Registry;
import genj.util.Resources;
import genj.util.WordBuffer;
import genj.util.swing.ChoiceWidget;
import genj.util.swing.PopupWidget;
import genj.view.Images;
import genj.view.View;
import genj.view.ViewContext;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;
import spin.Spin;

public class SearchView
extends View
implements Filter {
    private int max_hits;
    private boolean case_sensitive;
    private static final String[] DEFAULT_VALUES = new String[]{"L(a|e)pe(i|y)re", "Paris.+France", "^(M|F)"};
    private static final String[] DEFAULT_TAGS = new String[]{"NAME", "BIRT", "SEX", "DATE", "BIRT, PLAC", "OCCU", "NOTE", "BIRT, NOTE", "RESI", "PLAC", "AGE", "HUSB", "WIFE", "CHIL", "FAMC", "ADDR", "CITY", "POST", "CTRY"};
    private static final String[] DEFAULT_STR = new String[0];
    private static final genj.util.swing.ImageIcon IMG_START = new genj.util.swing.ImageIcon(SearchView.class, "images/Start");
    private static final genj.util.swing.ImageIcon IMG_STOP = new genj.util.swing.ImageIcon(SearchView.class, "images/Stop");
    private static final genj.util.swing.ImageIcon IMG_CLEAN = new genj.util.swing.ImageIcon(SearchView.class, "images/Clean");
    private static final genj.util.swing.ImageIcon IMG_CLEAR = new genj.util.swing.ImageIcon(SearchView.class, "images/ClearHistory");
    private static final genj.util.swing.ImageIcon IMG_SETTINGS = Images.imgSettings;
    private static final genj.util.swing.ImageIcon IMG_DOWNLOAD = ancestris.core.resources.Images.imgDownload;
    private static final int MAX_OLD = 16;
    static final Resources RESOURCES = Resources.get(SearchView.class);
    private static final Registry REGISTRY = Registry.get(SearchView.class);
    private Context context = null;
    private Results results1 = new Results();
    private Results results2 = new Results();
    private ResultWidget listResults1 = new ResultWidget(this.results1);
    private ResultWidget listResults2 = new ResultWidget(this.results2);
    private ChoiceWidget choiceLastname;
    private ChoiceWidget choiceSpouseLastname;
    private ChoiceWidget choiceFirstname;
    private ChoiceWidget choiceSpouseFirstname;
    private ChoiceWidget choicePlace;
    private ChoiceWidget choiceOccu;
    private ChoiceWidget choiceTag;
    private ChoiceWidget choiceValue;
    private LinkedList<String> oldLastnames;
    private LinkedList<String> oldSpouseLastnames;
    private LinkedList<String> oldFirstnames;
    private LinkedList<String> oldSpouseFirstnames;
    private LinkedList<String> oldPlaces;
    private LinkedList<String> oldOccupations;
    private LinkedList<String> oldTags;
    private LinkedList<String> oldValues;
    private PopupWidget popupPatterns;
    private PopupWidget popupTags;
    private AbstractAncestrisAction actionStart = new ActionStart();
    private AbstractAncestrisAction actionStop = new ActionStop();
    private AbstractAncestrisAction actionClean = new ActionClean();
    private AbstractAncestrisAction actionClearHistory = new ActionClearHistory();
    private AbstractAncestrisAction actionSettings = new ActionSettings();
    private AbstractAncestrisAction actionDownload = new Download();
    private WorkerMulti worker1;
    private WorkerTag worker2;
    private SearchCommunicator searchCommunicator = null;
    private Set<Indi> filteredIndis = new HashSet<Indi>();
    private Set<Entity> connectedEntities = new HashSet<Entity>();
    private JCheckBox allButCb;
    private DateBean birthDateBean;
    private JLabel birthLabel;
    private DateBean deathDateBean;
    private JLabel deathLabel;
    private JCheckBox divCb;
    private JCheckBox femaleCb;
    private JComboBox firstnameText;
    private JScrollPane jScrollPane1;
    private JTabbedPane jTabbedPane1;
    private JLabel labelCount1;
    private JLabel labelCount1label;
    private JLabel labelCount2;
    private JLabel labelCount2label;
    private JComboBox lastnameText;
    private JCheckBox maleCb;
    private JCheckBox marrCb;
    private JCheckBox multimarrCb;
    private JLabel occuLabel;
    private JComboBox occuText;
    private JLabel personNameLabel;
    private JLabel placeLabel;
    private JComboBox placetext;
    private JButton propertyButton;
    private JLabel propertyLabel;
    private JComboBox<String> propertyList;
    private JCheckBox regexpCheckBox;
    private JPanel result1Panel;
    private JPanel result2Panel;
    private JCheckBox singleCb;
    private JLabel spouseNameLabel;
    private JComboBox spousefirstnameText;
    private JComboBox<String> spouselastnametext;
    private JCheckBox subpropCheckBox;
    private JPanel tabMulti;
    private JPanel tabTag;
    private JCheckBox unknownCb;
    private JCheckBox useResult1CheckBox1;
    private JCheckBox useResult1CheckBox2;
    private JCheckBox useResult2CheckBox1;
    private JCheckBox useResult2CheckBox2;
    private JButton valueButton;
    private JLabel valueLabel;
    private JComboBox<String> valueList;

    public SearchView() {
        ActionListener aclick = e -> {
            if (this.actionStop.isEnabled()) {
                this.stop();
            }
            if (this.actionStart.isEnabled()) {
                this.start();
            }
        };
        SettingsPanel settingsPanel = new SettingsPanel(REGISTRY);
        this.max_hits = settingsPanel.getMaxHits();
        this.case_sensitive = settingsPanel.getCaseSensitive();
        this.oldLastnames = new LinkedList<String>(Arrays.asList(REGISTRY.get("old.lastnames", DEFAULT_STR)));
        this.choiceLastname = new ChoiceWidget(this.oldLastnames);
        this.choiceLastname.addActionListener(aclick);
        this.oldSpouseLastnames = new LinkedList<String>(Arrays.asList(REGISTRY.get("old.spouselastnames", DEFAULT_STR)));
        this.choiceSpouseLastname = new ChoiceWidget(this.oldSpouseLastnames);
        this.choiceSpouseLastname.addActionListener(aclick);
        this.oldFirstnames = new LinkedList<String>(Arrays.asList(REGISTRY.get("old.firstnames", DEFAULT_STR)));
        this.choiceFirstname = new ChoiceWidget(this.oldFirstnames);
        this.choiceFirstname.addActionListener(aclick);
        this.oldSpouseFirstnames = new LinkedList<String>(Arrays.asList(REGISTRY.get("old.spousefirstnames", DEFAULT_STR)));
        this.choiceSpouseFirstname = new ChoiceWidget(this.oldSpouseFirstnames);
        this.choiceSpouseFirstname.addActionListener(aclick);
        this.oldPlaces = new LinkedList<String>(Arrays.asList(REGISTRY.get("old.places", DEFAULT_STR)));
        this.choicePlace = new ChoiceWidget(this.oldPlaces);
        this.choicePlace.addActionListener(aclick);
        this.oldOccupations = new LinkedList<String>(Arrays.asList(REGISTRY.get("old.occupations", DEFAULT_STR)));
        this.choiceOccu = new ChoiceWidget(this.oldOccupations);
        this.choiceOccu.addActionListener(aclick);
        this.oldTags = new LinkedList<String>(Arrays.asList(REGISTRY.get("old.tags", DEFAULT_TAGS)));
        this.oldValues = new LinkedList<String>(Arrays.asList(REGISTRY.get("old.values", DEFAULT_VALUES)));
        this.choiceValue = new ChoiceWidget(this.oldValues);
        this.choiceValue.addActionListener(aclick);
        this.popupPatterns = new PopupWidget("...", null);
        this.popupPatterns.addItems(this.createPatternActions());
        this.choiceTag = new ChoiceWidget(this.oldTags);
        this.choiceTag.addActionListener(aclick);
        this.popupTags = new PopupWidget("...", null);
        this.popupTags.addItems(this.createTagActions());
        this.initComponents();
        this.worker1 = new WorkerMulti((WorkerListener)Spin.over((Object)new WorkerListener(){

            @Override
            public void more(List<Hit> hits) {
                SearchView.this.results1.add(hits);
                SearchView.this.labelCount1.setText("" + SearchView.this.results1.getSize());
                SearchView.this.labelCount1label.setVisible(true);
                SearchView.this.useResult1CheckBox1.setEnabled(true);
                SearchView.this.useResult1CheckBox2.setEnabled(true);
                SearchView.this.notifyResults();
            }

            @Override
            public void started() {
                SearchView.this.results1.clear();
                SearchView.this.labelCount1.setText("");
                SearchView.this.labelCount1label.setVisible(false);
                SearchView.this.useResult1CheckBox1.setEnabled(false);
                SearchView.this.useResult1CheckBox2.setEnabled(false);
                SearchView.this.actionStart.setEnabled(false);
                SearchView.this.actionStop.setEnabled(true);
            }

            @Override
            public void stopped() {
                SearchView.this.actionStop.setEnabled(false);
                SearchView.this.actionStart.setEnabled(SearchView.this.context.getGedcom() != null);
            }
        }));
        this.worker2 = new WorkerTag((WorkerListener)Spin.over((Object)new WorkerListener(){

            @Override
            public void more(List<Hit> hits) {
                SearchView.this.results2.add(hits);
                SearchView.this.labelCount2.setText("" + SearchView.this.results2.getSize());
                SearchView.this.labelCount2label.setVisible(true);
                SearchView.this.useResult2CheckBox1.setEnabled(true);
                SearchView.this.useResult2CheckBox2.setEnabled(true);
                SearchView.this.notifyResults();
            }

            @Override
            public void started() {
                SearchView.this.results2.clear();
                SearchView.this.labelCount2.setText("");
                SearchView.this.labelCount2label.setVisible(false);
                SearchView.this.useResult2CheckBox1.setEnabled(false);
                SearchView.this.useResult2CheckBox2.setEnabled(false);
                SearchView.this.actionStart.setEnabled(false);
                SearchView.this.actionStop.setEnabled(true);
            }

            @Override
            public void stopped() {
                SearchView.this.actionStop.setEnabled(false);
                SearchView.this.actionStart.setEnabled(SearchView.this.context.getGedcom() != null);
            }
        }));
        this.birthDateBean.addActionListener(aclick);
        this.deathDateBean.addActionListener(aclick);
        this.birthDateBean.setPropertyImpl(null);
        this.deathDateBean.setPropertyImpl(null);
        this.birthDateBean.setFormat(PropertyDate.BETWEEN_AND);
        this.deathDateBean.setFormat(PropertyDate.BETWEEN_AND);
        this.result1Panel.setLayout(new BorderLayout());
        this.result1Panel.add("Center", new JScrollPane(this.listResults1));
        this.labelCount1.setText("");
        this.labelCount1label.setVisible(false);
        this.regexpCheckBox.setSelected(REGISTRY.get("regexp", false));
        this.subpropCheckBox.setSelected(REGISTRY.get("subprop", false));
        this.result2Panel.setLayout(new BorderLayout());
        this.result2Panel.add("Center", new JScrollPane(this.listResults2));
        this.labelCount2.setText("");
        this.labelCount2label.setVisible(false);
        this.connectedEntities = new HashSet<Entity>();
        this.setPrintableArea(this.jTabbedPane1);
        this.setPrintableArea(this.listResults1);
        this.setPrintableArea(this.listResults2);
        WindowManager.getDefault().invokeWhenUIReady(() -> {
            this.notifyResults();
            this.choiceLastname.requestFocusInWindow();
        });
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTabbedPane1 = new JTabbedPane();
        this.tabMulti = new JPanel();
        this.labelCount1label = new JLabel();
        this.labelCount1 = new JLabel();
        this.useResult1CheckBox1 = new JCheckBox();
        this.useResult2CheckBox1 = new JCheckBox();
        this.personNameLabel = new JLabel();
        this.lastnameText = this.choiceLastname;
        this.firstnameText = this.choiceFirstname;
        this.spouseNameLabel = new JLabel();
        this.spouselastnametext = this.choiceSpouseLastname;
        this.spousefirstnameText = this.choiceSpouseFirstname;
        this.birthLabel = new JLabel();
        this.birthDateBean = new DateBean();
        this.deathLabel = new JLabel();
        this.deathDateBean = new DateBean();
        this.placeLabel = new JLabel();
        this.placetext = this.choicePlace;
        this.occuLabel = new JLabel();
        this.occuText = this.choiceOccu;
        this.maleCb = new JCheckBox();
        this.femaleCb = new JCheckBox();
        this.unknownCb = new JCheckBox();
        this.marrCb = new JCheckBox();
        this.multimarrCb = new JCheckBox();
        this.singleCb = new JCheckBox();
        this.divCb = new JCheckBox();
        this.allButCb = new JCheckBox();
        this.result1Panel = new JPanel();
        this.tabTag = new JPanel();
        this.labelCount2label = new JLabel();
        this.labelCount2 = new JLabel();
        this.useResult1CheckBox2 = new JCheckBox();
        this.useResult2CheckBox2 = new JCheckBox();
        this.valueLabel = new JLabel();
        this.regexpCheckBox = new JCheckBox();
        this.valueButton = this.popupPatterns;
        this.valueList = this.choiceValue;
        this.propertyLabel = new JLabel();
        this.propertyButton = this.popupTags;
        this.subpropCheckBox = new JCheckBox();
        this.propertyList = this.choiceTag;
        this.result2Panel = new JPanel();
        this.jTabbedPane1.setRequestFocusEnabled(false);
        this.labelCount1label.setHorizontalAlignment(11);
        Mnemonics.setLocalizedText((JLabel)this.labelCount1label, (String)NbBundle.getMessage(SearchView.class, (String)"SearchView.labelCount1label.text"));
        this.labelCount1.setFont(new Font("DejaVu Sans", 1, 12));
        this.labelCount1.setHorizontalAlignment(4);
        Mnemonics.setLocalizedText((JLabel)this.labelCount1, (String)NbBundle.getMessage(SearchView.class, (String)"SearchView.labelCount1.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.useResult1CheckBox1, (String)NbBundle.getMessage(SearchView.class, (String)"SearchView.useResult1CheckBox1.text"));
        this.useResult1CheckBox1.setEnabled(false);
        Mnemonics.setLocalizedText((AbstractButton)this.useResult2CheckBox1, (String)NbBundle.getMessage(SearchView.class, (String)"SearchView.useResult2CheckBox1.text"));
        this.useResult2CheckBox1.setEnabled(false);
        Mnemonics.setLocalizedText((JLabel)this.personNameLabel, (String)NbBundle.getMessage(SearchView.class, (String)"SearchView.personNameLabel.text"));
        this.personNameLabel.setToolTipText(NbBundle.getMessage(SearchView.class, (String)"SearchView.personNameLabel.toolTipText"));
        this.lastnameText.setToolTipText(NbBundle.getMessage(SearchView.class, (String)"SearchView.lastnameText.toolTipText"));
        this.firstnameText.setToolTipText(NbBundle.getMessage(SearchView.class, (String)"SearchView.firstnameText.toolTipText"));
        Mnemonics.setLocalizedText((JLabel)this.spouseNameLabel, (String)NbBundle.getMessage(SearchView.class, (String)"SearchView.spouseNameLabel.text"));
        this.spouselastnametext.setToolTipText(NbBundle.getMessage(SearchView.class, (String)"SearchView.spouselastnametext.toolTipText"));
        this.spousefirstnameText.setToolTipText(NbBundle.getMessage(SearchView.class, (String)"SearchView.spousefirstnameText.toolTipText"));
        Mnemonics.setLocalizedText((JLabel)this.birthLabel, (String)NbBundle.getMessage(SearchView.class, (String)"SearchView.birthLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.deathLabel, (String)NbBundle.getMessage(SearchView.class, (String)"SearchView.deathLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.placeLabel, (String)NbBundle.getMessage(SearchView.class, (String)"SearchView.placeLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.occuLabel, (String)NbBundle.getMessage(SearchView.class, (String)"SearchView.occuLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.maleCb, (String)NbBundle.getMessage(SearchView.class, (String)"SearchView.maleCb.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.femaleCb, (String)NbBundle.getMessage(SearchView.class, (String)"SearchView.femaleCb.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.unknownCb, (String)NbBundle.getMessage(SearchView.class, (String)"SearchView.unknownCb.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.marrCb, (String)NbBundle.getMessage(SearchView.class, (String)"SearchView.marrCb.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.multimarrCb, (String)NbBundle.getMessage(SearchView.class, (String)"SearchView.multimarrCb.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.singleCb, (String)NbBundle.getMessage(SearchView.class, (String)"SearchView.singleCb.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.divCb, (String)NbBundle.getMessage(SearchView.class, (String)"SearchView.divCb.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.allButCb, (String)NbBundle.getMessage(SearchView.class, (String)"SearchView.allButCb.text"));
        GroupLayout result1PanelLayout = new GroupLayout(this.result1Panel);
        this.result1Panel.setLayout(result1PanelLayout);
        result1PanelLayout.setHorizontalGroup(result1PanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 426, Short.MAX_VALUE));
        result1PanelLayout.setVerticalGroup(result1PanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 174, Short.MAX_VALUE));
        GroupLayout tabMultiLayout = new GroupLayout(this.tabMulti);
        this.tabMulti.setLayout(tabMultiLayout);
        tabMultiLayout.setHorizontalGroup(tabMultiLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.result1Panel, -1, -1, Short.MAX_VALUE).addGroup(tabMultiLayout.createSequentialGroup().addContainerGap().addGroup(tabMultiLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(tabMultiLayout.createSequentialGroup().addGroup(tabMultiLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.personNameLabel).addComponent(this.spouseNameLabel).addComponent(this.birthLabel).addComponent(this.deathLabel).addComponent(this.placeLabel).addComponent(this.occuLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(tabMultiLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.occuText, 0, -1, Short.MAX_VALUE).addComponent(this.placetext, 0, -1, Short.MAX_VALUE).addComponent((Component)this.deathDateBean, -1, -1, Short.MAX_VALUE).addComponent((Component)this.birthDateBean, -1, -1, Short.MAX_VALUE).addGroup(tabMultiLayout.createSequentialGroup().addGroup(tabMultiLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lastnameText, 0, -1, Short.MAX_VALUE).addComponent(this.spouselastnametext, 0, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(tabMultiLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.spousefirstnameText, 0, -1, Short.MAX_VALUE).addComponent(this.firstnameText, 0, -1, Short.MAX_VALUE))))).addGroup(tabMultiLayout.createSequentialGroup().addGroup(tabMultiLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.marrCb).addComponent(this.maleCb)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(tabMultiLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.femaleCb).addComponent(this.multimarrCb)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(tabMultiLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(tabMultiLayout.createSequentialGroup().addComponent(this.unknownCb).addGap(0, 0, Short.MAX_VALUE)).addGroup(tabMultiLayout.createSequentialGroup().addComponent(this.singleCb).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.divCb).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.allButCb)))).addGroup(tabMultiLayout.createSequentialGroup().addComponent(this.labelCount1label).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelCount1)).addGroup(tabMultiLayout.createSequentialGroup().addComponent(this.useResult1CheckBox1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.useResult2CheckBox1))).addContainerGap()));
        tabMultiLayout.setVerticalGroup(tabMultiLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(tabMultiLayout.createSequentialGroup().addContainerGap().addGroup(tabMultiLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelCount1label).addComponent(this.labelCount1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(tabMultiLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.useResult1CheckBox1).addComponent(this.useResult2CheckBox1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(tabMultiLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.personNameLabel).addComponent(this.lastnameText, -2, -1, -2).addComponent(this.firstnameText, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(tabMultiLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.spouseNameLabel).addComponent(this.spousefirstnameText, -2, -1, -2).addComponent(this.spouselastnametext, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(tabMultiLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.birthLabel).addComponent((Component)this.birthDateBean, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(tabMultiLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.deathLabel).addComponent((Component)this.deathDateBean, -2, -1, -2)).addGap(8, 8, 8).addGroup(tabMultiLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.placeLabel).addComponent(this.placetext, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(tabMultiLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.occuLabel).addComponent(this.occuText, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(tabMultiLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.maleCb).addComponent(this.femaleCb).addComponent(this.unknownCb)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(tabMultiLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.marrCb).addGroup(tabMultiLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.singleCb).addComponent(this.multimarrCb).addComponent(this.allButCb).addComponent(this.divCb))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.result1Panel, -1, -1, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab(NbBundle.getMessage(SearchView.class, (String)"SearchView.tabMulti.TabConstraints.tabTitle"), new ImageIcon(((Object)((Object)this)).getClass().getResource("/genj/search/images/multiSearch.png")), this.tabMulti, NbBundle.getMessage(SearchView.class, (String)"SearchView.tabMulti.TabConstraints.tabToolTip"));
        this.tabTag.setPreferredSize(new Dimension(150, 354));
        Mnemonics.setLocalizedText((JLabel)this.labelCount2label, (String)NbBundle.getMessage(SearchView.class, (String)"SearchView.labelCount2label.text"));
        this.labelCount2.setFont(new Font("DejaVu Sans", 1, 12));
        Mnemonics.setLocalizedText((JLabel)this.labelCount2, (String)NbBundle.getMessage(SearchView.class, (String)"SearchView.labelCount2.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.useResult1CheckBox2, (String)NbBundle.getMessage(SearchView.class, (String)"SearchView.useResult1CheckBox2.text"));
        this.useResult1CheckBox2.setEnabled(false);
        Mnemonics.setLocalizedText((AbstractButton)this.useResult2CheckBox2, (String)NbBundle.getMessage(SearchView.class, (String)"SearchView.useResult2CheckBox2.text"));
        this.useResult2CheckBox2.setEnabled(false);
        Mnemonics.setLocalizedText((JLabel)this.valueLabel, (String)NbBundle.getMessage(SearchView.class, (String)"SearchView.valueLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.regexpCheckBox, (String)NbBundle.getMessage(SearchView.class, (String)"SearchView.regexpCheckBox.text"));
        this.regexpCheckBox.setToolTipText(NbBundle.getMessage(SearchView.class, (String)"SearchView.regexpCheckBox.toolTipText"));
        Mnemonics.setLocalizedText((AbstractButton)this.valueButton, (String)NbBundle.getMessage(SearchView.class, (String)"SearchView.valueButton.text"));
        Mnemonics.setLocalizedText((JLabel)this.propertyLabel, (String)NbBundle.getMessage(SearchView.class, (String)"SearchView.propertyLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.propertyButton, (String)NbBundle.getMessage(SearchView.class, (String)"SearchView.propertyButton.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.subpropCheckBox, (String)NbBundle.getMessage(SearchView.class, (String)"SearchView.subpropCheckBox.text"));
        this.subpropCheckBox.setToolTipText(NbBundle.getMessage(SearchView.class, (String)"SearchView.subpropCheckBox.toolTipText"));
        GroupLayout result2PanelLayout = new GroupLayout(this.result2Panel);
        this.result2Panel.setLayout(result2PanelLayout);
        result2PanelLayout.setHorizontalGroup(result2PanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        result2PanelLayout.setVerticalGroup(result2PanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 316, Short.MAX_VALUE));
        GroupLayout tabTagLayout = new GroupLayout(this.tabTag);
        this.tabTag.setLayout(tabTagLayout);
        tabTagLayout.setHorizontalGroup(tabTagLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, tabTagLayout.createSequentialGroup().addContainerGap().addGroup(tabTagLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(tabTagLayout.createSequentialGroup().addComponent(this.valueButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.valueList, 0, -1, Short.MAX_VALUE)).addGroup(tabTagLayout.createSequentialGroup().addComponent(this.propertyButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.propertyList, 0, -1, Short.MAX_VALUE)).addGroup(tabTagLayout.createSequentialGroup().addGroup(tabTagLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(tabTagLayout.createSequentialGroup().addComponent(this.useResult1CheckBox2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.useResult2CheckBox2)).addGroup(tabTagLayout.createSequentialGroup().addComponent(this.labelCount2label).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelCount2)).addGroup(tabTagLayout.createSequentialGroup().addComponent(this.propertyLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.subpropCheckBox)).addGroup(tabTagLayout.createSequentialGroup().addComponent(this.valueLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.regexpCheckBox))).addGap(0, 118, Short.MAX_VALUE))).addContainerGap()).addComponent(this.result2Panel, -1, -1, Short.MAX_VALUE));
        tabTagLayout.setVerticalGroup(tabTagLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(tabTagLayout.createSequentialGroup().addContainerGap().addGroup(tabTagLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelCount2).addComponent(this.labelCount2label)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(tabTagLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.useResult1CheckBox2).addComponent(this.useResult2CheckBox2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(tabTagLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.valueLabel).addComponent(this.regexpCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(tabTagLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.valueButton).addComponent(this.valueList, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(tabTagLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.propertyLabel).addComponent(this.subpropCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(tabTagLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.propertyButton).addComponent(this.propertyList, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.result2Panel, -1, -1, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab(NbBundle.getMessage(SearchView.class, (String)"SearchView.tabTag.TabConstraints.tabTitle"), new ImageIcon(((Object)((Object)this)).getClass().getResource("/genj/search/images/tagSearch.png")), this.tabTag, NbBundle.getMessage(SearchView.class, (String)"SearchView.tabTag.TabConstraints.tabToolTip"));
        this.jScrollPane1.setViewportView(this.jTabbedPane1);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1));
    }

    public void closing() {
        super.closing();
        if (this.results1 != null && this.results2 != null) {
            this.context.getGedcom().removeGedcomListener((GedcomListener)Spin.over((Object)this.results1));
            this.context.getGedcom().removeGedcomListener((GedcomListener)Spin.over((Object)this.results2));
        }
        SearchCommunicator.unregister((SearchCommunicator)this.searchCommunicator);
    }

    public void start() {
        if (this.context == null) {
            return;
        }
        this.getSelectedWorker().stop();
        Worker worker = this.getSelectedWorker();
        HashSet<Entity> preResult = new HashSet<Entity>();
        if (worker instanceof WorkerMulti) {
            this.remember(this.choiceLastname, this.oldLastnames, this.choiceLastname.getText());
            this.remember(this.choiceSpouseLastname, this.oldSpouseLastnames, this.choiceSpouseLastname.getText());
            this.remember(this.choiceFirstname, this.oldFirstnames, this.choiceFirstname.getText());
            this.remember(this.choiceSpouseFirstname, this.oldSpouseFirstnames, this.choiceSpouseFirstname.getText());
            this.remember(this.choicePlace, this.oldPlaces, this.choicePlace.getText());
            this.remember(this.choiceOccu, this.oldOccupations, this.choiceOccu.getText());
            if (this.useResult1CheckBox1.isSelected()) {
                preResult.addAll(this.getEntitiesFromResult(this.results1));
            }
            if (this.useResult2CheckBox1.isSelected()) {
                preResult.addAll(this.getEntitiesFromResult(this.results2));
            }
            worker.start(this.context.getGedcom(), this.max_hits, this.case_sensitive, preResult, this.choiceLastname.getText(), this.choiceSpouseLastname.getText(), this.choiceFirstname.getText(), this.choiceSpouseFirstname.getText(), this.birthDateBean, this.deathDateBean, this.choicePlace.getText(), this.choiceOccu.getText(), this.maleCb.isSelected(), this.femaleCb.isSelected(), this.unknownCb.isSelected(), this.marrCb.isSelected(), this.multimarrCb.isSelected(), this.singleCb.isSelected(), this.divCb.isSelected(), this.allButCb.isSelected());
        } else if (worker instanceof WorkerTag) {
            String value = this.choiceValue.getText();
            String tags = this.choiceTag.getText();
            this.remember(this.choiceValue, this.oldValues, value);
            this.remember(this.choiceTag, this.oldTags, tags);
            if (this.useResult1CheckBox2.isSelected()) {
                preResult.addAll(this.getEntitiesFromResult(this.results1));
            }
            if (this.useResult2CheckBox2.isSelected()) {
                preResult.addAll(this.getEntitiesFromResult(this.results2));
            }
            worker.start(this.context.getGedcom(), this.max_hits, this.case_sensitive, preResult, tags, value, this.regexpCheckBox.isSelected(), this.subpropCheckBox.isSelected());
        }
        this.filteredIndis.clear();
        this.connectedEntities.clear();
    }

    public void stop() {
        this.getSelectedWorker().stop();
    }

    public void clean() {
        if (this.jTabbedPane1.getSelectedComponent() == this.tabMulti) {
            this.choiceLastname.setText("");
            this.choiceSpouseLastname.setText("");
            this.choiceFirstname.setText("");
            this.choiceSpouseFirstname.setText("");
            this.choicePlace.setText("");
            this.choiceOccu.setText("");
            this.birthDateBean.setPropertyImpl(null);
            this.birthDateBean.setFormat(PropertyDate.BETWEEN_AND);
            this.deathDateBean.setPropertyImpl(null);
            this.deathDateBean.setFormat(PropertyDate.BETWEEN_AND);
            this.maleCb.setSelected(false);
            this.femaleCb.setSelected(false);
            this.unknownCb.setSelected(false);
            this.marrCb.setSelected(false);
            this.multimarrCb.setSelected(false);
            this.singleCb.setSelected(false);
            this.divCb.setSelected(false);
            this.choiceLastname.requestFocusInWindow();
            this.labelCount1.setText("");
            this.labelCount1label.setVisible(false);
            this.useResult1CheckBox1.setEnabled(false);
            this.useResult2CheckBox1.setEnabled(!this.results2.hits.isEmpty());
            this.useResult1CheckBox1.setSelected(false);
            this.useResult2CheckBox1.setSelected(false);
        } else {
            this.choiceTag.setText("");
            this.choiceValue.setText("");
            this.choiceValue.requestFocusInWindow();
            this.labelCount2.setText("");
            this.labelCount2label.setVisible(false);
            this.useResult1CheckBox2.setEnabled(!this.results1.hits.isEmpty());
            this.useResult2CheckBox2.setEnabled(false);
            this.useResult1CheckBox2.setSelected(false);
            this.useResult2CheckBox2.setSelected(false);
        }
        this.jTabbedPane1.setPreferredSize(new Dimension(435, 476));
        this.getSelectedResults().clear();
        this.notifyResults();
    }

    private void notifyResults() {
        int h = this.jTabbedPane1.getHeight();
        int w = Math.max(this.result1Panel.getPreferredSize().width, this.result2Panel.getPreferredSize().width);
        w = Math.max(w, this.jTabbedPane1.getPreferredSize().width);
        this.jTabbedPane1.setPreferredSize(new Dimension(w, h));
        WindowManager.getDefault().invokeWhenUIReady(() -> {
            if (this.searchCommunicator != null) {
                this.searchCommunicator.fireNewResults();
            }
        });
    }

    public void clearHistory() {
        if (DialogManager.YES_OPTION != DialogManager.create((String)NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"TITL_ConfirmClear"), (String)NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"MSG_ConfirmClear")).setMessageType(0).setOptionType(0).show()) {
            return;
        }
        if (this.jTabbedPane1.getSelectedComponent() == this.tabMulti) {
            REGISTRY.remove("old.lastnames");
            REGISTRY.remove("old.spouselastnames");
            REGISTRY.remove("old.firstnames");
            REGISTRY.remove("old.spousefirstnames");
            REGISTRY.remove("old.places");
            this.oldLastnames = new LinkedList<String>(Arrays.asList(REGISTRY.get("old.lastnames", DEFAULT_STR)));
            this.oldSpouseLastnames = new LinkedList<String>(Arrays.asList(REGISTRY.get("old.spouselastnames", DEFAULT_STR)));
            this.oldFirstnames = new LinkedList<String>(Arrays.asList(REGISTRY.get("old.firstnames", DEFAULT_STR)));
            this.oldSpouseFirstnames = new LinkedList<String>(Arrays.asList(REGISTRY.get("old.spousefirstnames", DEFAULT_STR)));
            this.oldPlaces = new LinkedList<String>(Arrays.asList(REGISTRY.get("old.places", DEFAULT_STR)));
            this.oldOccupations = new LinkedList<String>(Arrays.asList(REGISTRY.get("old.occupations", DEFAULT_STR)));
            this.choiceLastname.setValues(this.oldLastnames);
            this.choiceSpouseLastname.setValues(this.oldSpouseLastnames);
            this.choiceFirstname.setValues(this.oldFirstnames);
            this.choiceSpouseFirstname.setValues(this.oldSpouseFirstnames);
            this.choicePlace.setValues(this.oldPlaces);
            this.choiceOccu.setValues(this.oldOccupations);
        } else {
            REGISTRY.remove("regexp");
            REGISTRY.remove("old.values");
            REGISTRY.remove("old.tags");
            this.oldTags = new LinkedList<String>(Arrays.asList(REGISTRY.get("old.tags", DEFAULT_TAGS)));
            this.oldValues = new LinkedList<String>(Arrays.asList(REGISTRY.get("old.values", DEFAULT_VALUES)));
            this.choiceTag.setValues(this.oldValues);
            this.choiceValue.setValues(this.oldTags);
        }
        this.notifyResults();
    }

    public void addNotify() {
        super.addNotify();
        AncestrisPlugin.register((Object)((Object)this));
    }

    public void removeNotify() {
        REGISTRY.put("old.lastnames", this.oldLastnames);
        REGISTRY.put("old.spouselastnames", this.oldSpouseLastnames);
        REGISTRY.put("old.firstnames", this.oldFirstnames);
        REGISTRY.put("old.spousefirstnames", this.oldSpouseFirstnames);
        REGISTRY.put("old.places", this.oldPlaces);
        REGISTRY.put("old.occupations", this.oldOccupations);
        REGISTRY.put("regexp", Boolean.valueOf(this.regexpCheckBox.isSelected()));
        REGISTRY.put("old.values", this.oldValues);
        REGISTRY.put("subprop", Boolean.valueOf(this.subpropCheckBox.isSelected()));
        REGISTRY.put("old.tags", this.oldTags);
        AncestrisPlugin.unregister((Object)((Object)this));
        super.removeNotify();
    }

    public void setContext(Context newContext) {
        if (newContext == null || this.context != null) {
            return;
        }
        Gedcom newGedcom = newContext.getGedcom();
        this.stop();
        this.results1.clear();
        this.results2.clear();
        this.labelCount1label.setVisible(false);
        this.labelCount1.setText("");
        this.labelCount2label.setVisible(false);
        this.labelCount2.setText("");
        this.useResult1CheckBox1.setEnabled(false);
        this.useResult2CheckBox1.setEnabled(false);
        this.useResult1CheckBox2.setEnabled(false);
        this.useResult2CheckBox2.setEnabled(false);
        this.actionStart.setEnabled(false);
        newGedcom.addGedcomListener((GedcomListener)Spin.over((Object)this.results1));
        newGedcom.addGedcomListener((GedcomListener)Spin.over((Object)this.results2));
        this.context = newContext;
        this.actionStart.setEnabled(true);
        if (this.searchCommunicator == null) {
            this.searchCommunicator = new SearchCommunicator(){

                public List<Property> getResults() {
                    ArrayList<Property> props = new ArrayList<Property>();
                    for (Hit hit : SearchView.this.getSelectedResults().hits) {
                        props.add(hit.getProperty());
                    }
                    return props;
                }
            };
        }
        this.searchCommunicator.setGedcom(newGedcom);
    }

    public void populate(ToolBar toolbar) {
        toolbar.add((Action)this.actionStart);
        toolbar.add((Action)this.actionStop);
        toolbar.add((Action)this.actionClean);
        toolbar.add((Action)this.actionClearHistory);
        toolbar.addGlue();
        toolbar.addSeparator();
        toolbar.add((Action)new ReportSubMenu(this.context.getGedcom(), (Filter)this));
        toolbar.add((Action)this.actionDownload);
        toolbar.add((Action)new ActionSaveViewAsGedcom(this.context.getGedcom(), (Filter)this));
        toolbar.add((Action)this.actionSettings);
    }

    private void remember(ChoiceWidget choice, LinkedList<String> old, String value) {
        if (value.trim().length() == 0) {
            return;
        }
        old.remove(value);
        old.addFirst(value);
        if (old.size() > 16) {
            old.removeLast();
        }
        choice.setValues(old);
        choice.setText(value);
    }

    private List<AbstractAncestrisAction> createTagActions() {
        ArrayList<AbstractAncestrisAction> result = new ArrayList<AbstractAncestrisAction>();
        for (String tag : DEFAULT_TAGS) {
            result.add(new ActionTag(tag));
        }
        return result;
    }

    private List<AbstractAncestrisAction> createPatternActions() {
        ArrayList<AbstractAncestrisAction> result = new ArrayList<AbstractAncestrisAction>();
        int i = 0;
        while (true) {
            String key = "regexp." + i;
            String txt = RESOURCES.getString(key + ".txt", false);
            String pat = RESOURCES.getString(key + ".pat", false);
            if (txt == null) break;
            if (pat != null) {
                result.add(new ActionPattern(txt, pat));
            }
            ++i;
        }
        return result;
    }

    private Worker getSelectedWorker() {
        Worker worker = this.jTabbedPane1.getSelectedComponent() == this.tabMulti ? this.worker1 : this.worker2;
        return worker;
    }

    private Results getSelectedResults() {
        Results results = this.jTabbedPane1.getSelectedComponent() == this.tabMulti ? this.results1 : this.results2;
        return results;
    }

    private void displaySettings() {
        SettingsPanel settingsPanel = new SettingsPanel(REGISTRY);
        DialogManager.create((String)NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"TITL_ChangeSettings"), (JComponent)settingsPanel).setMessageType(-1).setOptionType(10).show();
        settingsPanel.setSettings();
        this.max_hits = settingsPanel.getMaxHits();
        this.case_sensitive = settingsPanel.getCaseSensitive();
    }

    public String getFilterName() {
        return NbBundle.getMessage(SearchView.class, (String)"TTL_Filter", (Object)this.getIndividualsCount(), (Object)RESOURCES.getString("title"));
    }

    public String getSelectionName() {
        return "";
    }

    public boolean veto(Entity entity) {
        if (entity == entity.getGedcom().getSubmitter()) {
            return false;
        }
        this.calculateIndis();
        return !this.connectedEntities.contains(entity);
    }

    public boolean veto(Property property) {
        PropertyXRef xref;
        return property instanceof PropertyXRef && (xref = (PropertyXRef)property).isValid() && !this.connectedEntities.contains(xref.getTargetEntity());
    }

    public boolean canApplyTo(Gedcom gedcom) {
        return gedcom != null && gedcom.equals(this.context.getGedcom());
    }

    private void calculateIndis() {
        this.filteredIndis.clear();
        for (Entity entity : this.getEntitiesFromResult(this.getSelectedResults())) {
            if (!(entity instanceof Indi)) continue;
            this.filteredIndis.add((Indi)entity);
        }
        this.connectedEntities.clear();
        for (Indi indi : this.filteredIndis) {
            this.connectedEntities.addAll(Utilities.getDependingEntitiesRecursively((Entity)indi, this.filteredIndis));
        }
    }

    public int getIndividualsCount() {
        this.calculateIndis();
        int sum = 0;
        for (Entity ent : this.connectedEntities) {
            if (!(ent instanceof Indi)) continue;
            ++sum;
        }
        return sum;
    }

    private Collection<? extends Entity> getEntitiesFromResult(Results results) {
        HashSet<Object> set = new HashSet<Object>();
        for (Hit hit : results.hits) {
            Entity ent = hit.getProperty().getEntity();
            set.add(ent);
            if (!(ent instanceof Fam)) continue;
            Fam fam = (Fam)ent;
            Indi indi = fam.getHusband();
            if (indi != null) {
                set.add(indi);
            }
            if ((indi = fam.getWife()) == null) continue;
            set.add(indi);
        }
        return set;
    }

    private class ResultWidget
    extends JList
    implements ListSelectionListener,
    ListCellRenderer {
        private final Results results;
        private final JTextPane text;
        private final int BS = 2;

        private ResultWidget(Results results) {
            super(results);
            this.text = new JTextPane();
            this.BS = 2;
            this.results = results;
            this.init();
        }

        private void init() {
            this.setCellRenderer(this);
            float defaultSize = (this.getFont().getSize2D() + 2.0f) * 3.0f / 2.0f;
            int defaultCellSize = Math.round(defaultSize) + 1;
            defaultCellSize = Math.max(18, defaultCellSize);
            this.setFixedCellHeight(defaultCellSize);
            this.addListSelectionListener(this);
            this.text.setOpaque(true);
            this.addMouseListener((MouseListener)new FilteredMouseAdapter(){

                public void mouseClickedFiltered(MouseEvent e) {
                    Property cell;
                    int row = ResultWidget.this.getSelectedIndex();
                    if (row >= 0 && (cell = ResultWidget.this.results.getHit(row).getProperty()) != null && cell instanceof Property) {
                        SelectionDispatcher.fireSelection((AWTEvent)e, (Context)new Context(cell));
                    }
                }
            });
        }

        public ViewContext getContext() {
            if (SearchView.this.context == null) {
                return null;
            }
            ArrayList<Property> properties = new ArrayList<Property>();
            for (Object selection1 : this.getSelectedValuesList()) {
                Hit hit = (Hit)selection1;
                properties.add(hit.getProperty());
            }
            return new ViewContext(SearchView.this.context.getGedcom(), null, properties);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Hit hit = (Hit)value;
            this.text.setBorder(isSelected ? BorderFactory.createLineBorder(this.getSelectionBackground(), 2, false) : BorderFactory.createEmptyBorder(2, 2, 2, 2));
            this.text.setDocument(hit.getDocument());
            return this.text;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int row = this.getSelectedIndex();
            if (row >= 0) {
                SelectionDispatcher.fireSelection((Context)new Context(this.results.getHit(row).getProperty()));
            }
        }
    }

    private static class Results
    extends AbstractListModel
    implements GedcomListener {
        private List<Hit> hits = new ArrayList<Hit>();

        private Results() {
        }

        private void clear() {
            if (this.hits.isEmpty()) {
                return;
            }
            int size = this.hits.size();
            this.hits.clear();
            this.fireIntervalRemoved(this, 0, size - 1);
        }

        private void add(List<Hit> list) {
            if (list.isEmpty()) {
                return;
            }
            int size = this.hits.size();
            this.hits.addAll(list);
            this.fireIntervalAdded(this, size, this.hits.size() - 1);
        }

        @Override
        public Object getElementAt(int index) {
            return this.hits.get(index);
        }

        @Override
        public int getSize() {
            return this.hits.size();
        }

        private Hit getHit(int i) {
            return this.hits.get(i);
        }

        public void gedcomEntityAdded(Gedcom gedcom, Entity entity) {
        }

        public void gedcomEntityDeleted(Gedcom gedcom, Entity entity) {
        }

        public void gedcomPropertyAdded(Gedcom gedcom, Property property, int pos, Property added) {
        }

        public void gedcomPropertyChanged(Gedcom gedcom, Property property) {
            for (int i = 0; i < this.hits.size(); ++i) {
                Hit hit = this.hits.get(i);
                if (hit.getProperty() != property) continue;
                this.fireContentsChanged(this, i, i);
            }
        }

        public void gedcomPropertyDeleted(Gedcom gedcom, Property property, int pos, Property removed) {
            int i = 0;
            while (i < this.hits.size()) {
                Hit hit = this.hits.get(i);
                if (hit.getProperty() == removed) {
                    this.hits.remove(i);
                    this.fireIntervalRemoved(this, i, i);
                    continue;
                }
                ++i;
            }
        }
    }

    private class Download
    extends AbstractAncestrisAction {
        protected Download() {
            this.setImage((Icon)IMG_DOWNLOAD);
            this.setTip(RESOURCES.getString("SearchView.export.tip"));
        }

        public void actionPerformed(ActionEvent event) {
            String action = NbBundle.getMessage(SearchView.class, (String)"SearchView.export.action");
            if (SearchView.this.getSelectedResults().hits.isEmpty()) {
                DialogManager.createError((String)action, (String)NbBundle.getMessage(SearchView.class, (String)"SearchView.export.empty")).show();
                return;
            }
            String title = NbBundle.getMessage(SearchView.class, (String)"SearchView.export.title");
            File file = new FileChooserBuilder(SearchView.class).setTitle(title).setApproveText(action).setFileHiding(true).setParent((Component)event.getSource()).setFileFilter((FileFilter)new FileNameExtensionFilter(NbBundle.getMessage(SearchView.class, (String)"SearchView.export.formats"), "txt", "csv")).setDefaultExtension(FileChooserBuilder.getTextFilter().getExtensions()[0]).setDefaultBadgeProvider().setDefaultWorkingDirectory(new File(System.getProperty("user.home"))).showSaveDialog(true);
            if (file == null) {
                return;
            }
            try {
                this.csvExport(file, SearchView.this.getSelectedResults());
                DialogManager.create((String)action, (String)NbBundle.getMessage(SearchView.class, (String)"SearchView.export.success", (Object)file.getAbsolutePath())).show();
            }
            catch (IOException e) {
                DialogManager.createError((String)action, (String)NbBundle.getMessage(SearchView.class, (String)"SearchView.export.error", (Object)file.getAbsolutePath())).show();
            }
        }

        public void csvExport(File file, Results results) throws IOException {
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
                writer.write("\"");
                writer.write(NbBundle.getMessage(SearchView.class, (String)"SearchView.export.entityType"));
                writer.write("\";");
                writer.write("\"");
                writer.write(NbBundle.getMessage(SearchView.class, (String)"SearchView.export.entityID"));
                writer.write("\";");
                writer.write("\"");
                writer.write(NbBundle.getMessage(SearchView.class, (String)"SearchView.export.entityValue"));
                writer.write("\";");
                writer.write("\"");
                writer.write(NbBundle.getMessage(SearchView.class, (String)"SearchView.export.propertyName"));
                writer.write("\";");
                writer.write("\"");
                writer.write(NbBundle.getMessage(SearchView.class, (String)"SearchView.export.propertyValue"));
                writer.write("\";");
                writer.write("\"");
                writer.write(NbBundle.getMessage(SearchView.class, (String)"SearchView.export.propertyDate"));
                writer.write("\";");
                writer.write("\"");
                writer.write(NbBundle.getMessage(SearchView.class, (String)"SearchView.export.propertyPlace"));
                writer.write("\"");
                writer.write("\n");
                for (Hit hit : results.hits) {
                    Property property = hit.getProperty();
                    Entity ent = property.getEntity();
                    writer.write("\"");
                    writer.write(ent.getPropertyName());
                    writer.write("\";");
                    writer.write("\"");
                    writer.write(ent.getId());
                    writer.write("\";");
                    writer.write("\"");
                    if (ent instanceof Indi) {
                        writer.write(ent.getDisplayTitle(false));
                    } else if (ent instanceof Fam) {
                        writer.write(((Fam)ent).getDisplayFullNames(false));
                    } else {
                        writer.write(ent.getDisplayTitle(false));
                    }
                    writer.write("\";");
                    writer.write("\"");
                    writer.write(property.getPropertyName());
                    writer.write("\";");
                    writer.write("\"");
                    writer.write(property.getDisplayValue());
                    writer.write("\";");
                    writer.write("\"");
                    writer.write(property.format("{$D}"));
                    writer.write("\";");
                    writer.write("\"");
                    writer.write(property.format("{$P}"));
                    writer.write("\"");
                    writer.write("\n");
                }
            }
        }
    }

    private class ActionSettings
    extends AbstractAncestrisAction {
        private ActionSettings() {
            this.setImage((Icon)IMG_SETTINGS);
            this.setTip(RESOURCES.getString("settings.tip"));
        }

        public void actionPerformed(ActionEvent event) {
            SearchView.this.displaySettings();
        }
    }

    private class ActionClearHistory
    extends AbstractAncestrisAction {
        private ActionClearHistory() {
            this.setImage((Icon)IMG_CLEAR);
            this.setTip(RESOURCES.getString("clearHistory.tip"));
        }

        public void actionPerformed(ActionEvent event) {
            SearchView.this.clearHistory();
            SearchView.this.clean();
        }
    }

    private class ActionClean
    extends AbstractAncestrisAction {
        private ActionClean() {
            this.setImage((Icon)IMG_CLEAN);
            this.setTip(RESOURCES.getString("clean.tip"));
        }

        public void actionPerformed(ActionEvent event) {
            SearchView.this.clean();
        }
    }

    private class ActionStop
    extends AbstractAncestrisAction {
        private ActionStop() {
            this.setImage((Icon)IMG_STOP);
            this.setTip(RESOURCES.getString("stop.tip"));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent event) {
            SearchView.this.stop();
        }
    }

    private class ActionStart
    extends AbstractAncestrisAction {
        private ActionStart() {
            this.setImage((Icon)IMG_START);
            this.setTip(RESOURCES.getString("start.tip"));
        }

        public void actionPerformed(ActionEvent e) {
            SearchView.this.stop();
            SearchView.this.start();
        }
    }

    private class ActionPattern
    extends AbstractAncestrisAction {
        private final String pattern;

        private ActionPattern(String txt, String pat) {
            int i = txt.indexOf(32);
            if (i > 0) {
                txt = "<html><b>" + txt.substring(0, i) + "</b>&nbsp;&nbsp;&nbsp;" + txt.substring(i) + "</html>";
            }
            this.setText(txt);
            this.pattern = pat;
        }

        public void actionPerformed(ActionEvent event) {
            JTextField field = SearchView.this.choiceValue.getTextEditor();
            int selStart = field.getSelectionStart();
            int selEnd = field.getSelectionEnd();
            if (selEnd <= selStart) {
                selEnd = selStart = field.getCaretPosition();
            }
            String all = field.getText();
            String before = all.substring(0, selStart);
            String selection = selEnd > selStart ? '(' + all.substring(selStart, selEnd) + ')' : "";
            String after = all.substring(selEnd);
            String result = MessageFormat.format(this.pattern, all, before, selection, after);
            SwingUtilities.invokeLater(() -> {
                int pos = result.indexOf(35);
                field.setText(result.substring(0, pos) + result.substring(pos + 1));
                field.select(0, 0);
                field.setCaretPosition(pos);
                SearchView.this.regexpCheckBox.setSelected(true);
            });
        }
    }

    private class ActionTag
    extends AbstractAncestrisAction {
        private final String tags;

        private ActionTag(String tags) {
            this.tags = tags;
            WordBuffer txt = new WordBuffer(", ");
            for (String t : tags.split(",")) {
                txt.append(Gedcom.getName((String)t.trim()));
            }
            this.setText(txt.toString());
        }

        public void actionPerformed(ActionEvent event) {
            SearchView.this.choiceTag.setText(this.tags);
        }
    }
}

