/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.media;

import ancestris.modules.editors.media.BackgroundTask;
import ancestris.modules.editors.media.FileStats;
import ancestris.modules.editors.media.MediaManagerActionPanel;
import ancestris.modules.editors.media.PathData;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.Media;
import genj.gedcom.Property;
import genj.gedcom.PropertyFile;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FilesAnalysisTaskFactory {
    public static BackgroundTask create(Gedcom gedcom, Set<String> filesFullnames, Set<PathData> pathDataList, FileStats fileStats, boolean mediaTestRemoteExistence) {
        return new Impl(gedcom, filesFullnames, pathDataList, fileStats, mediaTestRemoteExistence);
    }

    private static class Impl
    implements BackgroundTask {
        private static final Logger LOG = Logger.getLogger("ancestris.app");
        private boolean cancel = false;
        private int nbSuccesses = 0;
        private int nbErrors = 0;
        private int counter = 0;
        private int nbIterations;
        private int progress = 0;
        private String taskName = "";
        private String stateName = "";
        private Gedcom gedcom;
        private Set<String> filesFullnames;
        private Set<PathData> pathDataList;
        private FileStats fileStats;
        private boolean mediaTestRemoteExistence;

        public Impl(Gedcom gedcom, Set<String> filesFullnames, Set<PathData> pathDataList, FileStats fileStats, boolean mediaTestRemoteExistence) {
            this.gedcom = gedcom;
            this.filesFullnames = filesFullnames;
            this.pathDataList = pathDataList;
            this.fileStats = fileStats;
            this.mediaTestRemoteExistence = mediaTestRemoteExistence;
        }

        @Override
        public long getSuccesses() {
            return this.nbSuccesses;
        }

        @Override
        public long getErrors() {
            return this.nbErrors;
        }

        @Override
        public void run() {
            List filesList = this.gedcom.getPropertiesByClass(PropertyFile.class);
            this.nbIterations = this.fileStats.totalNumber = filesList.size();
            for (Property file : filesList) {
                if (!(file instanceof PropertyFile)) continue;
                if (this.cancel) break;
                PropertyFile pFile = (PropertyFile)file;
                this.stateName = pFile.getValue();
                ++this.counter;
                String value = pFile.getValue().trim();
                if (value == null) continue;
                this.filesFullnames.add(value);
                String path = MediaManagerActionPanel.getPathFromFileValue(pFile);
                boolean found = false;
                boolean rel = true;
                boolean local = true;
                if (pFile.isIsRemote()) {
                    rel = false;
                    local = false;
                    ++this.fileStats.remoteFilesNumber;
                    if (pFile.isFound(this.mediaTestRemoteExistence)) {
                        found = true;
                    } else {
                        ++this.fileStats.remoteFilesUnfoundNumber;
                        LOG.log(Level.INFO, "Analysing media files: remote file not found: " + value);
                    }
                } else {
                    ++this.fileStats.localFilesNumber;
                    Path pPath = Paths.get(path, new String[0]);
                    if (pPath.isAbsolute()) {
                        rel = false;
                        ++this.fileStats.absolutePathFilesNumber;
                    } else {
                        ++this.fileStats.relativePathFilesNumber;
                    }
                    if (pFile.isFound(false)) {
                        found = true;
                    } else {
                        ++this.fileStats.localFilesUnfoundNumber;
                        LOG.log(Level.INFO, "Analysing media files: local file not found: " + value);
                    }
                }
                boolean ent = true;
                Entity entity = pFile.getEntity();
                if (entity instanceof Media) {
                    ++this.fileStats.entityFilesNumber;
                } else {
                    ent = false;
                    ++this.fileStats.propertyFilesNumber;
                }
                PathData pd = MediaManagerActionPanel.getPathDataFromKey(this.pathDataList, path, found, ent);
                if (pd == null) {
                    pd = new PathData(pFile, found, path, local, ent, rel);
                    this.pathDataList.add(pd);
                    continue;
                }
                pd.addFile(pFile);
            }
            this.fileStats.distinctNumber = this.filesFullnames.size();
        }

        public void cancelTrackable() {
            this.cancel = true;
        }

        public int getProgress() {
            this.progress = this.counter * 100 / this.nbIterations;
            return this.progress;
        }

        public String getState() {
            return this.stateName;
        }

        public String getTaskName() {
            return this.taskName;
        }
    }
}

