/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.viewers.media;

import ancestris.modules.viewers.media.MediaChooser;
import genj.gedcom.Entity;
import genj.gedcom.Property;
import genj.gedcom.PropertyFile;
import java.awt.Color;
import java.awt.Font;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class MediaDescription
extends JPanel {
    private static Color RED = new Color(255, 0, 0);
    private static Color BLACK = new Color(0, 0, 0);
    private static Color GREEN = new Color(0, 80, 0);
    private JLabel fileFoundLabel;
    private JLabel fileLocalLabel;
    private JLabel filePathLabel;
    private JLabel filePositionLabel;
    private JLabel fileUsageLabel;
    private JLabel fileValueLabel;
    private JLabel hostLabel;
    private JLabel mediaEntityLabel;
    private JLabel mediaUsageLabel;
    private JComboBox<String> usingEntitiesComboBox;
    private JLabel usingEntitiesLabel;
    private JComboBox<String> usingMediaComboBox;
    private JLabel usingMediasLabel;

    public MediaDescription() {
        this.initComponents();
        this.setVisible(false);
    }

    private void initComponents() {
        this.hostLabel = new JLabel();
        this.mediaEntityLabel = new JLabel();
        this.mediaUsageLabel = new JLabel();
        this.usingEntitiesLabel = new JLabel();
        this.usingEntitiesComboBox = new JComboBox();
        this.fileValueLabel = new JLabel();
        this.fileFoundLabel = new JLabel();
        this.fileLocalLabel = new JLabel();
        this.filePathLabel = new JLabel();
        this.fileUsageLabel = new JLabel();
        this.usingMediasLabel = new JLabel();
        this.usingMediaComboBox = new JComboBox();
        this.filePositionLabel = new JLabel();
        this.hostLabel.setFont(new Font("Noto Sans", 1, 12));
        Mnemonics.setLocalizedText((JLabel)this.hostLabel, (String)NbBundle.getMessage(MediaDescription.class, (String)"MediaDescription.hostLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.mediaEntityLabel, (String)NbBundle.getMessage(MediaDescription.class, (String)"MediaDescription.mediaEntityLabel.text"));
        this.mediaUsageLabel.setFont(new Font("Noto Sans", 1, 12));
        Mnemonics.setLocalizedText((JLabel)this.mediaUsageLabel, (String)NbBundle.getMessage(MediaDescription.class, (String)"MediaDescription.mediaUsageLabel.text"));
        this.mediaUsageLabel.setToolTipText(NbBundle.getMessage(MediaDescription.class, (String)"MediaDescription.mediaUsageLabel.toolTipText"));
        Mnemonics.setLocalizedText((JLabel)this.usingEntitiesLabel, (String)NbBundle.getMessage(MediaDescription.class, (String)"MediaDescription.usingEntitiesLabel.text"));
        this.usingEntitiesComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.fileValueLabel.setFont(new Font("Noto Sans", 1, 12));
        Mnemonics.setLocalizedText((JLabel)this.fileValueLabel, (String)NbBundle.getMessage(MediaDescription.class, (String)"MediaDescription.fileValueLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.fileFoundLabel, (String)NbBundle.getMessage(MediaDescription.class, (String)"MediaDescription.fileFoundLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.fileLocalLabel, (String)NbBundle.getMessage(MediaDescription.class, (String)"MediaDescription.fileLocalLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.filePathLabel, (String)NbBundle.getMessage(MediaDescription.class, (String)"MediaDescription.filePathLabel.text"));
        this.fileUsageLabel.setFont(new Font("Noto Sans", 1, 12));
        Mnemonics.setLocalizedText((JLabel)this.fileUsageLabel, (String)NbBundle.getMessage(MediaDescription.class, (String)"MediaDescription.fileUsageLabel.text"));
        this.fileUsageLabel.setToolTipText(NbBundle.getMessage(MediaDescription.class, (String)"MediaDescription.fileUsageLabel.toolTipText"));
        Mnemonics.setLocalizedText((JLabel)this.usingMediasLabel, (String)NbBundle.getMessage(MediaDescription.class, (String)"MediaDescription.usingMediasLabel.text"));
        this.usingMediaComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        Mnemonics.setLocalizedText((JLabel)this.filePositionLabel, (String)NbBundle.getMessage(MediaDescription.class, (String)"MediaDescription.filePositionLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.usingEntitiesLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.usingEntitiesComboBox, 0, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.mediaUsageLabel)).addGroup(layout.createSequentialGroup().addComponent(this.usingMediasLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.usingMediaComboBox, 0, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fileUsageLabel)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.filePathLabel).addComponent(this.hostLabel).addComponent(this.fileValueLabel).addComponent(this.mediaEntityLabel).addGroup(layout.createSequentialGroup().addComponent(this.fileFoundLabel).addGap(18, 18, 18).addComponent(this.fileLocalLabel)).addComponent(this.filePositionLabel)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.hostLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.mediaEntityLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.usingEntitiesLabel).addComponent(this.usingEntitiesComboBox, -2, -1, -2).addComponent(this.mediaUsageLabel)).addGap(18, 18, 18).addComponent(this.fileValueLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fileFoundLabel).addComponent(this.fileLocalLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.filePathLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.usingMediasLabel).addComponent(this.usingMediaComboBox, -2, -1, -2).addComponent(this.fileUsageLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.filePositionLabel).addContainerGap(-1, Short.MAX_VALUE)));
    }

    public void setValues(MediaChooser.MediaThumb media, List<Property> list) {
        this.setVisible(true);
        this.hostLabel.setText("<html>" + NbBundle.getMessage(MediaDescription.class, (String)"MediaDescription.hostLabel.text", (Object)media.entity.getDisplayTitle()) + "<html>");
        this.hostLabel.setIcon((Icon)media.entity.getImage());
        this.mediaEntityLabel.setText(NbBundle.getMessage(MediaDescription.class, (String)(media.isMedia ? "MediaDescription.mediaEntityLabel.text" : "MediaDescription.mediaEntityLabel.text.not")));
        this.mediaEntityLabel.setForeground(media.isMedia ? BLACK : RED);
        this.mediaUsageLabel.setVisible(media.isMedia && media.entities.length > 1);
        this.usingEntitiesLabel.setVisible(media.isMedia);
        this.usingEntitiesComboBox.setVisible(media.isMedia);
        if (media.isMedia) {
            this.mediaUsageLabel.setText(NbBundle.getMessage(MediaDescription.class, (String)"MediaDescription.mediaUsageLabel.text", (Object)String.valueOf(media.entities.length)));
            this.usingEntitiesLabel.setForeground(media.entities.length > 1 ? GREEN : (media.entities.length > 0 ? BLACK : RED));
            this.usingEntitiesLabel.setText(NbBundle.getMessage(MediaDescription.class, (String)(media.entities.length > 0 ? "MediaDescription.usingEntitiesLabel.text" : "MediaDescription.usingEntitiesLabel.text.not")));
            this.usingEntitiesComboBox.setVisible(media.entities.length > 0);
            this.usingEntitiesComboBox.setModel(new DefaultComboBoxModel<Entity>(media.entities));
        }
        this.fileValueLabel.setIcon((Icon)PropertyFile.DEFAULT_IMAGE);
        this.fileValueLabel.setText("<html>" + NbBundle.getMessage(MediaDescription.class, (String)"MediaDescription.fileValueLabel.text", (Object)this.formatString(media.fileValue)) + "</html>");
        this.fileFoundLabel.setText(NbBundle.getMessage(MediaDescription.class, (String)(media.isFound() ? "MediaDescription.fileFoundLabel.text" : "MediaDescription.fileFoundLabel.text.not")));
        this.fileFoundLabel.setForeground(media.isFound() ? BLACK : RED);
        String localStr = "";
        if (media.isFileLocal) {
            localStr = NbBundle.getMessage(MediaDescription.class, (String)"MediaDescription.fileLocalLabel.text");
        }
        if (media.isFileRemote) {
            localStr = NbBundle.getMessage(MediaDescription.class, (String)"MediaDescription.fileLocalLabel.text.remote");
        }
        this.fileLocalLabel.setText(localStr);
        this.filePathLabel.setVisible(media.isFound());
        if (media.isFound() && media.inputSource != null) {
            this.filePathLabel.setText("<html>" + NbBundle.getMessage(MediaDescription.class, (String)"MediaDescription.filePathLabel.text", (Object)this.formatString(media.fileLocation)) + "</html>");
        }
        this.fileUsageLabel.setVisible(list != null && list.size() > 1);
        this.usingMediasLabel.setForeground(media.nbFileUsed > 1 ? RED : BLACK);
        this.fileUsageLabel.setForeground(media.nbFileUsed > 1 ? RED : BLACK);
        this.usingMediaComboBox.setVisible(list != null);
        if (list != null) {
            this.fileUsageLabel.setText(NbBundle.getMessage(MediaDescription.class, (String)"MediaDescription.fileUsageLabel.text", (Object)String.valueOf(list.size())));
            this.usingMediaComboBox.setModel(new DefaultComboBoxModel<Object>(list.toArray()));
        } else {
            this.fileUsageLabel.setText(NbBundle.getMessage(MediaDescription.class, (String)"MediaDescription.fileUsageLabel.text", (Object)0));
        }
        this.filePositionLabel.setText(NbBundle.getMessage(MediaDescription.class, (String)"MediaDescription.filePositionLabel.text", (Object)media.position));
    }

    private String formatString(String str) {
        String ret = "";
        int i = str.indexOf("://");
        ret = i == -1 ? str.replaceAll("/", " /").replaceAll("\\\\", " \\\\") : str.substring(0, i + 3) + str.substring(i + 3).replaceAll("/", " /").replaceAll("\\\\", " \\\\");
        return ret;
    }
}

