/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcom.removetag;

import ancestris.core.actions.AbstractAncestrisContextAction;
import ancestris.modules.gedcom.removetag.RemoveTagPanel;
import ancestris.util.GedcomUtilities;
import ancestris.util.swing.DialogManager;
import genj.gedcom.Context;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.UnitOfWork;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class RemoveTagAction
extends AbstractAncestrisContextAction {
    private Gedcom gedcom = null;
    private int nbTagsRemoved = 0;

    public RemoveTagAction() {
        this.setIconBase("ancestris/modules/gedcom/removetag/RemoveTagIcon.png");
        this.setText(NbBundle.getMessage(RemoveTagAction.class, (String)"CTL_RemoveTagAction"));
    }

    protected void contextChanged() {
        this.setEnabled(!this.contextProperties.isEmpty());
        super.contextChanged();
    }

    protected void actionPerformedImpl(ActionEvent event) {
        Context contextToOpen = this.getContext();
        if (contextToOpen != null) {
            this.gedcom = contextToOpen.getGedcom();
            final RemoveTagPanel removeTagPanel = new RemoveTagPanel(this.gedcom);
            JButton deleteButton = new JButton(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"Button_Delete"));
            deleteButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    removeTagPanel.savePreferences();
                    if (RemoveTagAction.this.deleteTags(removeTagPanel.getSettings())) {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(RemoveTagAction.class, (String)"RemoveTagAction.done", (Object)RemoveTagAction.this.nbTagsRemoved, (Object)removeTagPanel.getSettings().tag), 1));
                    }
                }
            });
            JButton cancelButton = new JButton(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"Button_Cancel"));
            Object[] options = new Object[]{deleteButton, cancelButton};
            DialogManager.create((String)NbBundle.getMessage(RemoveTagAction.class, (String)"CTL_RemoveTagTitle"), (JComponent)removeTagPanel, (boolean)false).setMessageType(3).setOptionType(2).setOptions(options).setDialogId("removeTagPanel").show();
        }
    }

    private boolean deleteTags(final RemoveTagPanel.Settings settings) {
        if (settings.tag.isEmpty()) {
            return false;
        }
        try {
            this.gedcom.doUnitOfWork(new UnitOfWork(){

                public void perform(Gedcom gedcom) throws GedcomException {
                    RemoveTagAction.this.nbTagsRemoved = 0;
                    for (String entTag : settings.entsTags) {
                        if (entTag.isEmpty()) continue;
                        RemoveTagAction.this.nbTagsRemoved = RemoveTagAction.this.nbTagsRemoved + GedcomUtilities.deleteTags((Gedcom)gedcom, (String)settings.tag, (String)entTag, (boolean)settings.emptyOnly);
                    }
                }
            });
        }
        catch (GedcomException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return true;
    }
}

