/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcom.removetag;

import ancestris.view.SelectionDispatcher;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.Property;
import genj.util.Registry;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openide.util.NbBundle;

public class RemoveTagPanel
extends JPanel {
    private Gedcom gedcom = null;
    private Registry registry = null;
    private Settings settings = new Settings();
    private JComponent[] cats = null;
    private String[] entTags = null;
    private Map<String, Integer> propertiesMap;
    private JCheckBox jCheckBoxAllCat;
    private JCheckBox jCheckBoxEmpty;
    private JCheckBox jCheckBoxFam;
    private JCheckBox jCheckBoxIndi;
    private JCheckBox jCheckBoxNote;
    private JCheckBox jCheckBoxObje;
    private JCheckBox jCheckBoxRepo;
    private JCheckBox jCheckBoxSour;
    private JCheckBox jCheckBoxSubm;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSeparator jSeparator1;
    private JLabel selectedEntityLabel;
    private JLabel tagLabel;
    private JLabel tagListLabel;
    private JTextField tagTextField;
    private JLabel tagValuesLabel;
    private JList<Property> tagValuesList;
    private JList<String> tagsList;

    public RemoveTagPanel(Gedcom gedcom) {
        this.gedcom = gedcom;
        this.registry = gedcom.getRegistry();
        this.initComponents();
        this.cats = new JComponent[]{this.jCheckBoxIndi, this.jCheckBoxFam, this.jCheckBoxNote, this.jCheckBoxObje, this.jCheckBoxSour, this.jCheckBoxRepo, this.jCheckBoxSubm, this.jCheckBoxAllCat};
        this.entTags = new String[]{"INDI", "FAM", "NOTE", "OBJE", "SOUR", "REPO", "SUBM", ""};
        this.initNames();
        this.loadPreferences();
        if (this.tagsList.getModel().getSize() > 0) {
            this.tagsList.setSelectedIndex(0);
        }
    }

    private void initNames() {
        for (int i = 0; i < 7; ++i) {
            ((JCheckBox)this.cats[i]).setText(Gedcom.getName((String)this.entTags[i]));
        }
        ((JCheckBox)this.cats[7]).setText(NbBundle.getMessage(this.getClass(), (String)"RemoveTagPanel.jCheckBoxAllCat.text"));
    }

    private void initComponents() {
        this.tagLabel = new JLabel();
        this.tagTextField = new JTextField();
        this.selectedEntityLabel = new JLabel();
        this.jCheckBoxIndi = new JCheckBox();
        this.jCheckBoxFam = new JCheckBox();
        this.jCheckBoxObje = new JCheckBox();
        this.jCheckBoxNote = new JCheckBox();
        this.jCheckBoxSour = new JCheckBox();
        this.jCheckBoxRepo = new JCheckBox();
        this.jCheckBoxSubm = new JCheckBox();
        this.jCheckBoxAllCat = new JCheckBox();
        this.jCheckBoxEmpty = new JCheckBox();
        this.jSeparator1 = new JSeparator();
        this.tagListLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.tagsList = new JList<String>(this.getTagsList());
        this.tagValuesLabel = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.tagValuesList = new JList();
        this.setMinimumSize(new Dimension(481, 368));
        this.setName("");
        this.tagLabel.setText(NbBundle.getMessage(RemoveTagPanel.class, (String)"RemoveTagPanel.tagLabel.text"));
        this.tagTextField.setToolTipText(NbBundle.getMessage(RemoveTagPanel.class, (String)"RemoveTagPanel.tagTextField.toolTipText"));
        this.selectedEntityLabel.setText(NbBundle.getMessage(RemoveTagPanel.class, (String)"RemoveTagPanel.selectedEntityLabel.text"));
        this.jCheckBoxIndi.setText(NbBundle.getMessage(RemoveTagPanel.class, (String)"RemoveTagPanel.jCheckBoxIndi.text"));
        this.jCheckBoxIndi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RemoveTagPanel.this.jCheckBoxIndiActionPerformed(evt);
            }
        });
        this.jCheckBoxFam.setText(NbBundle.getMessage(RemoveTagPanel.class, (String)"RemoveTagPanel.jCheckBoxFam.text"));
        this.jCheckBoxFam.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RemoveTagPanel.this.jCheckBoxFamActionPerformed(evt);
            }
        });
        this.jCheckBoxObje.setText(NbBundle.getMessage(RemoveTagPanel.class, (String)"RemoveTagPanel.jCheckBoxObje.text"));
        this.jCheckBoxObje.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RemoveTagPanel.this.jCheckBoxObjeActionPerformed(evt);
            }
        });
        this.jCheckBoxNote.setText(NbBundle.getMessage(RemoveTagPanel.class, (String)"RemoveTagPanel.jCheckBoxNote.text"));
        this.jCheckBoxNote.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RemoveTagPanel.this.jCheckBoxNoteActionPerformed(evt);
            }
        });
        this.jCheckBoxSour.setText(NbBundle.getMessage(RemoveTagPanel.class, (String)"RemoveTagPanel.jCheckBoxSour.text"));
        this.jCheckBoxSour.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RemoveTagPanel.this.jCheckBoxSourActionPerformed(evt);
            }
        });
        this.jCheckBoxRepo.setText(NbBundle.getMessage(RemoveTagPanel.class, (String)"RemoveTagPanel.jCheckBoxRepo.text"));
        this.jCheckBoxRepo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RemoveTagPanel.this.jCheckBoxRepoActionPerformed(evt);
            }
        });
        this.jCheckBoxSubm.setText(NbBundle.getMessage(RemoveTagPanel.class, (String)"RemoveTagPanel.jCheckBoxSubm.text"));
        this.jCheckBoxSubm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RemoveTagPanel.this.jCheckBoxSubmActionPerformed(evt);
            }
        });
        this.jCheckBoxAllCat.setText(NbBundle.getMessage(RemoveTagPanel.class, (String)"RemoveTagPanel.jCheckBoxAllCat.text"));
        this.jCheckBoxAllCat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RemoveTagPanel.this.jCheckBoxAllCatActionPerformed(evt);
            }
        });
        this.jCheckBoxEmpty.setText(NbBundle.getMessage(RemoveTagPanel.class, (String)"RemoveTagPanel.jCheckBoxEmpty.text"));
        this.jCheckBoxEmpty.setHorizontalTextPosition(2);
        this.jCheckBoxEmpty.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RemoveTagPanel.this.jCheckBoxEmptyActionPerformed(evt);
            }
        });
        this.tagListLabel.setText(NbBundle.getMessage(RemoveTagPanel.class, (String)"RemoveTagPanel.tagListLabel.text"));
        this.tagsList.setSelectionMode(0);
        this.tagsList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                RemoveTagPanel.this.tagsListMouseClicked(evt);
            }
        });
        this.tagsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                RemoveTagPanel.this.tagsListValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.tagsList);
        this.tagValuesLabel.setText(NbBundle.getMessage(RemoveTagPanel.class, (String)"RemoveTagPanel.tagValuesLabel.text"));
        this.tagValuesList.setSelectionMode(0);
        this.tagValuesList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                RemoveTagPanel.this.tagValuesListMouseClicked(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.tagValuesList);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.tagTextField)).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.tagListLabel).addComponent(this.jScrollPane1, -2, 220, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.tagValuesLabel).addComponent(this.jScrollPane2, -2, 0, Short.MAX_VALUE)))).addContainerGap()).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jSeparator1).addContainerGap()).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tagLabel).addComponent(this.jCheckBoxEmpty).addComponent(this.selectedEntityLabel).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxIndi).addComponent(this.jCheckBoxFam)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxObje).addComponent(this.jCheckBoxNote)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxSour).addComponent(this.jCheckBoxRepo)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxAllCat).addComponent(this.jCheckBoxSubm)))).addGap(0, 92, Short.MAX_VALUE)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.tagLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tagTextField, -2, -1, -2).addGap(18, 18, 18).addComponent(this.selectedEntityLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jCheckBoxIndi).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxFam)).addGroup(layout.createSequentialGroup().addComponent(this.jCheckBoxObje).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxNote)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBoxSubm).addComponent(this.jCheckBoxSour)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBoxRepo).addComponent(this.jCheckBoxAllCat)))).addGap(18, 18, 18).addComponent(this.jCheckBoxEmpty).addGap(18, 18, 18).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tagListLabel).addComponent(this.tagValuesLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -1, 142, Short.MAX_VALUE).addComponent(this.jScrollPane1)).addContainerGap()));
    }

    private void jCheckBoxAllCatActionPerformed(ActionEvent evt) {
        for (int i = 0; i < 7; ++i) {
            ((JCheckBox)this.cats[i]).setSelected(this.jCheckBoxAllCat.isSelected());
        }
        this.updateValuesList();
    }

    private void jCheckBoxIndiActionPerformed(ActionEvent evt) {
        this.checkAllCat();
    }

    private void jCheckBoxFamActionPerformed(ActionEvent evt) {
        this.checkAllCat();
    }

    private void jCheckBoxObjeActionPerformed(ActionEvent evt) {
        this.checkAllCat();
    }

    private void jCheckBoxNoteActionPerformed(ActionEvent evt) {
        this.checkAllCat();
    }

    private void jCheckBoxSourActionPerformed(ActionEvent evt) {
        this.checkAllCat();
    }

    private void jCheckBoxRepoActionPerformed(ActionEvent evt) {
        this.checkAllCat();
    }

    private void jCheckBoxSubmActionPerformed(ActionEvent evt) {
        this.checkAllCat();
    }

    private void tagsListValueChanged(ListSelectionEvent evt) {
        this.updateValuesList();
    }

    private void tagValuesListMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            this.selectProperty();
        }
    }

    private void jCheckBoxEmptyActionPerformed(ActionEvent evt) {
        this.updateValuesList();
    }

    private void tagsListMouseClicked(MouseEvent evt) {
        String selectedTag;
        if (evt.getClickCount() == 2 && (selectedTag = this.tagsList.getSelectedValue()) != null && !selectedTag.isEmpty()) {
            selectedTag = selectedTag.split(" ")[0];
            this.tagTextField.setText(selectedTag);
        }
    }

    private void checkAllCat() {
        boolean all = true;
        for (int i = 0; i < 7; ++i) {
            all &= ((JCheckBox)this.cats[i]).isSelected();
        }
        this.jCheckBoxAllCat.setSelected(all);
        this.updateValuesList();
    }

    private void loadPreferences() {
        this.tagTextField.setText(this.registry.get("DeleteTagName", "_XXXX"));
        for (int i = 0; i < 8; ++i) {
            ((JCheckBox)this.cats[i]).setSelected(this.registry.get("DeleteTagCategory" + i, i == 0));
        }
        this.jCheckBoxEmpty.setSelected(this.registry.get("DeleteTagEmptyOnly", false));
    }

    public void savePreferences() {
        this.settings.tag = this.tagTextField.getText().trim().toUpperCase();
        this.registry.put("DeleteTagName", this.settings.tag);
        for (int i = 0; i < 8; ++i) {
            this.registry.put("DeleteTagCategory" + i, Boolean.valueOf(((JCheckBox)this.cats[i]).isSelected()));
        }
        this.settings.entsTags[0] = this.jCheckBoxIndi.isSelected() ? "INDI" : "";
        this.settings.entsTags[1] = this.jCheckBoxFam.isSelected() ? "FAM" : "";
        this.settings.entsTags[2] = this.jCheckBoxNote.isSelected() ? "NOTE" : "";
        this.settings.entsTags[3] = this.jCheckBoxObje.isSelected() ? "OBJE" : "";
        this.settings.entsTags[4] = this.jCheckBoxSour.isSelected() ? "SOUR" : "";
        this.settings.entsTags[5] = this.jCheckBoxRepo.isSelected() ? "REPO" : "";
        this.settings.entsTags[6] = this.jCheckBoxSubm.isSelected() ? "SUBM" : "";
        this.settings.emptyOnly = this.jCheckBoxEmpty.isSelected();
        this.registry.put("DeleteTagEmptyOnly", Boolean.valueOf(this.settings.emptyOnly));
    }

    private String[] getTagsList() {
        ArrayList ret = new ArrayList();
        this.propertiesMap = new HashMap<String, Integer>();
        ArrayList properties = new ArrayList();
        for (Entity entity : this.gedcom.getEntities()) {
            properties.addAll(entity.getAllProperties(null));
        }
        for (Property prop : properties) {
            String tag = prop.getTag();
            Integer nb = this.propertiesMap.get(tag);
            if (nb == null) {
                nb = 0;
            }
            Integer n = nb;
            Integer n2 = nb = Integer.valueOf(nb + 1);
            this.propertiesMap.put(tag, nb);
        }
        this.propertiesMap.keySet().forEach(key -> ret.add(key + " (" + this.propertiesMap.get(key) + ")"));
        Collections.sort(ret);
        return ret.toArray(new String[ret.size()]);
    }

    private Property[] getTagValues() {
        ArrayList ret = new ArrayList();
        this.initNames();
        String selectedTag = this.tagsList.getSelectedValue();
        if (selectedTag != null && !selectedTag.isEmpty()) {
            selectedTag = selectedTag.split(" ")[0];
            int total = this.propertiesMap.get(selectedTag);
            for (int i = 0; i < 7; ++i) {
                int subTotal = 0;
                for (Entity ent : this.gedcom.getEntities(this.entTags[i])) {
                    List c = ent.getAllProperties(selectedTag);
                    subTotal += c.size();
                    if (!((JCheckBox)this.cats[i]).isSelected()) continue;
                    ret.addAll(c);
                }
                ((JCheckBox)this.cats[i]).setText(Gedcom.getName((String)this.entTags[i]) + " (" + subTotal + ")");
                total -= subTotal;
            }
            ((JCheckBox)this.cats[7]).setText(NbBundle.getMessage(this.getClass(), (String)"RemoveTagPanel.jCheckBoxAllCat.text") + " (" + total + ")");
            if (total > 0 && this.jCheckBoxAllCat.isSelected()) {
                HashSet<String> hSet = new HashSet<String>(Arrays.asList(this.entTags));
                for (Entity ent : this.gedcom.getEntities()) {
                    if (hSet.contains(ent.getTag())) continue;
                    ret.addAll(ent.getAllProperties(selectedTag));
                }
            }
        }
        if (this.jCheckBoxEmpty.isSelected()) {
            Iterator i = ret.iterator();
            while (i.hasNext()) {
                Property p = (Property)i.next();
                if (p.getValue().isEmpty() && p.getNoOfProperties() <= 0) continue;
                i.remove();
            }
        }
        Collections.sort(ret, (o1, o2) -> o1.toString().compareTo(o2.toString()));
        return ret.toArray(new Property[ret.size()]);
    }

    private void updateValuesList() {
        DefaultListModel<Property> lm = new DefaultListModel<Property>();
        for (Property value : this.getTagValues()) {
            lm.addElement(value);
        }
        this.tagValuesList.setModel(lm);
        this.tagValuesLabel.setText(NbBundle.getMessage(this.getClass(), (String)"RemoveTagPanel.tagValuesLabel.text", (Object)lm.size()));
    }

    private void selectProperty() {
        int index = this.tagValuesList.getSelectedIndex();
        Property selectedProperty = this.tagValuesList.getModel().getElementAt(index);
        if (selectedProperty != null) {
            SelectionDispatcher.fireSelection(null, (Context)new Context(selectedProperty));
        }
    }

    public Settings getSettings() {
        return this.settings;
    }

    public static class Settings {
        public String tag = "";
        public String[] entsTags = new String[7];
        public boolean emptyOnly = false;
    }
}

