#include "xincs.h"
#include "fxver.h"
#include "fxdefs.h"
#include "FXArray.h"
#include "FXHash.h"
#include "FXStream.h"
#include "FXTextCodec.h"
#include "FXCP855Codec.h"

namespace FX {

FXIMPLEMENT(FXCP855Codec,FXTextCodec,NULL,0)


//// Created by codec tool on 03/25/2005 from: CP855.TXT ////
static const unsigned short forward_data[256]={
   0,    1,    2,    3,    4,    5,    6,    7,    8,    9,    10,   11,   12,   13,   14,   15,
   16,   17,   18,   19,   20,   21,   22,   23,   24,   25,   26,   27,   28,   29,   30,   31,
   32,   33,   34,   35,   36,   37,   38,   39,   40,   41,   42,   43,   44,   45,   46,   47,
   48,   49,   50,   51,   52,   53,   54,   55,   56,   57,   58,   59,   60,   61,   62,   63,
   64,   65,   66,   67,   68,   69,   70,   71,   72,   73,   74,   75,   76,   77,   78,   79,
   80,   81,   82,   83,   84,   85,   86,   87,   88,   89,   90,   91,   92,   93,   94,   95,
   96,   97,   98,   99,   100,  101,  102,  103,  104,  105,  106,  107,  108,  109,  110,  111,
   112,  113,  114,  115,  116,  117,  118,  119,  120,  121,  122,  123,  124,  125,  126,  127,
   1106, 1026, 1107, 1027, 1105, 1025, 1108, 1028, 1109, 1029, 1110, 1030, 1111, 1031, 1112, 1032,
   1113, 1033, 1114, 1034, 1115, 1035, 1116, 1036, 1118, 1038, 1119, 1039, 1102, 1070, 1098, 1066,
   1072, 1040, 1073, 1041, 1094, 1062, 1076, 1044, 1077, 1045, 1092, 1060, 1075, 1043, 171,  187,
   9617, 9618, 9619, 9474, 9508, 1093, 1061, 1080, 1048, 9571, 9553, 9559, 9565, 1081, 1049, 9488,
   9492, 9524, 9516, 9500, 9472, 9532, 1082, 1050, 9562, 9556, 9577, 9574, 9568, 9552, 9580, 164,
   1083, 1051, 1084, 1052, 1085, 1053, 1086, 1054, 1087, 9496, 9484, 9608, 9604, 1055, 1103, 9600,
   1071, 1088, 1056, 1089, 1057, 1090, 1058, 1091, 1059, 1078, 1046, 1074, 1042, 1100, 1068, 8470,
   173,  1099, 1067, 1079, 1047, 1096, 1064, 1101, 1069, 1097, 1065, 1095, 1063, 167,  9632, 160,
  };


static const unsigned char reverse_plane[17]={
  0, 10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
  };

static const unsigned char reverse_pages[74]={
  0,  64, 70, 70, 70, 70, 70, 70, 117,165,70, 70, 70, 70, 70, 70,
  70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70,
  70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70,
  70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70,
  70, 70, 70, 70, 70, 70, 70, 70, 70, 70,
  };

static const unsigned short reverse_block[229]={
  0,   16,  32,  48,  64,  80,  96,  112, 128, 128, 144, 158, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  173, 189, 205, 221, 237, 253, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 269, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 285, 301, 314, 327, 128, 343, 359, 128, 375, 390, 406,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128,
  128, 128, 128, 128, 128,
  };

static const unsigned char reverse_data[422]={
   0,    1,    2,    3,    4,    5,    6,    7,    8,    9,    10,   11,   12,   13,   14,   15,
   16,   17,   18,   19,   20,   21,   22,   23,   24,   25,   26,   27,   28,   29,   30,   31,
   32,   33,   34,   35,   36,   37,   38,   39,   40,   41,   42,   43,   44,   45,   46,   47,
   48,   49,   50,   51,   52,   53,   54,   55,   56,   57,   58,   59,   60,   61,   62,   63,
   64,   65,   66,   67,   68,   69,   70,   71,   72,   73,   74,   75,   76,   77,   78,   79,
   80,   81,   82,   83,   84,   85,   86,   87,   88,   89,   90,   91,   92,   93,   94,   95,
   96,   97,   98,   99,   100,  101,  102,  103,  104,  105,  106,  107,  108,  109,  110,  111,
   112,  113,  114,  115,  116,  117,  118,  119,  120,  121,  122,  123,  124,  125,  126,  127,
   26,   26,   26,   26,   26,   26,   26,   26,   26,   26,   26,   26,   26,   26,   26,   26,
   255,  26,   26,   26,   207,  26,   26,   253,  26,   26,   26,   174,  26,   240,  26,   26,
   26,   26,   26,   26,   26,   26,   26,   26,   26,   175,  26,   26,   26,   26,   133,  129,
   131,  135,  137,  139,  141,  143,  145,  147,  149,  151,  26,   153,  155,  161,  163,  236,
   173,  167,  169,  234,  244,  184,  190,  199,  209,  211,  213,  215,  221,  226,  228,  230,
   232,  171,  182,  165,  252,  246,  250,  159,  242,  238,  248,  157,  224,  160,  162,  235,
   172,  166,  168,  233,  243,  183,  189,  198,  208,  210,  212,  214,  216,  225,  227,  229,
   231,  170,  181,  164,  251,  245,  249,  158,  241,  237,  247,  156,  222,  26,   132,  128,
   130,  134,  136,  138,  140,  142,  144,  146,  148,  150,  26,   152,  154,  26,   26,   26,
   26,   26,   26,   239,  26,   26,   26,   26,   26,   26,   26,   26,   26,   196,  26,   179,
   26,   26,   26,   26,   26,   26,   26,   26,   26,   218,  26,   26,   26,   191,  26,   26,
   26,   192,  26,   26,   26,   217,  26,   26,   26,   195,  26,   26,   26,   26,   180,  26,
   26,   26,   26,   26,   26,   26,   194,  26,   26,   26,   26,   193,  26,   26,   26,   26,
   26,   26,   26,   197,  26,   26,   26,   205,  186,  26,   26,   201,  26,   26,   187,  26,
   26,   200,  26,   26,   188,  26,   26,   204,  26,   26,   185,  26,   26,   203,  26,   26,
   202,  26,   26,   206,  26,   26,   26,   223,  26,   26,   26,   220,  26,   26,   26,   219,
   26,   26,   26,   26,   26,   26,   26,   176,  177,  178,  26,   26,   26,   26,   26,   26,
   26,   26,   26,   26,   26,   26,   254,  26,   26,   26,   26,   26,   26,   26,   26,   26,
   26,   26,   26,   26,   26,   26,
  };


FXint FXCP855Codec::mb2wc(FXwchar& wc,const FXchar* src,FXint nsrc) const {
  if(nsrc<1) return -1;
  wc=forward_data[(FXuchar)src[0]];
  return 1;
  }


FXint FXCP855Codec::wc2mb(FXchar* dst,FXint ndst,FXwchar wc) const {
  if(ndst<1) return -1;
  dst[0]=reverse_data[reverse_block[reverse_pages[reverse_plane[wc>>16]+((wc>>10)&63)]+((wc>>4)&63)]+(wc&15)];
  return 1;
  }

FXint FXCP855Codec::mibEnum() const {
  return 2046;
  }


const FXchar* FXCP855Codec::name() const {
  return "IBM855";
  }


const FXchar* FXCP855Codec::mimeName() const {
  return "IBM855";
  }


const FXchar* const* FXCP855Codec::aliases() const {
  static const FXchar *const list[]={"microsoft-cp855","IBM855","cp855","855","csIBM855",NULL};
  return list;
  }

}

