#ifndef _BIGCHUMPPRE2_H_
#define _BIGCHUMPPRE2_H_

// bigchumppre2_table generated by DK/circ_table_gen.py -- do not modify manually

 // variables used
 // --sig_max  5.000000
 // --table_div  103.329115
 // --table_op  0.100000

struct tablebigchumppre2 { // 1-dimensional function table
    float low;
    float high;
    float istep;
    int size;
    float data[];
};

template <int tab_size>
struct tablebigchumppre2_imp {
    float low;
    float high;
    float istep;
    int size;
    float data[tab_size];
    operator tablebigchumppre2&() const { return *(tablebigchumppre2*)this; }
};

 static tablebigchumppre2_imp<2048> bigchumppre2_table __rt_data = {
	0,-0.833333,40.94,2048, {
	0.000000000000,-0.001389398516,-0.002778634193,-0.004167704815,-0.005556608173,
	-0.006945342060,-0.008333904279,-0.009722292634,-0.011110504938,-0.012498539008,
	-0.013886392665,-0.015274063738,-0.016661550059,-0.018048849468,-0.019435959807,
	-0.020822878927,-0.022209604681,-0.023596134930,-0.024982467538,-0.026368600376,
	-0.027754531319,-0.029140258249,-0.030525779051,-0.031911091616,-0.033296193842,
	-0.034681083629,-0.036065758885,-0.037450217521,-0.038834457456,-0.040218476610,
	-0.041602272912,-0.042985844294,-0.044369188694,-0.045752304054,-0.047135188322,
	-0.048517839451,-0.049900255398,-0.051282434127,-0.052664373606,-0.054046071807,
	-0.055427526708,-0.056808736292,-0.058189698546,-0.059570411464,-0.060950873043,
	-0.062331081285,-0.063711034199,-0.065090729795,-0.066470166092,-0.067849341112,
	-0.069228252881,-0.070606899431,-0.071985278798,-0.073363389025,-0.074741228157,
	-0.076118794245,-0.077496085344,-0.078873099516,-0.080249834825,-0.081626289342,
	-0.083002461140,-0.084378348300,-0.085753948905,-0.087129261044,-0.088504282811,
	-0.089879012302,-0.091253447622,-0.092627586877,-0.094001428179,-0.095374969644,
	-0.096748209395,-0.098121145555,-0.099493776256,-0.100866099633,-0.102238113824,
	-0.103609816973,-0.104981207229,-0.106352282745,-0.107723041677,-0.109093482189,
	-0.110463602445,-0.111833400616,-0.113202874879,-0.114572023412,-0.115940844399,
	-0.117309336029,-0.118677496494,-0.120045323992,-0.121412816724,-0.122779972896,
	-0.124146790719,-0.125513268407,-0.126879404178,-0.128245196256,-0.129610642868,
	-0.130975742247,-0.132340492628,-0.133704892252,-0.135068939362,-0.136432632209,
	-0.137795969044,-0.139158948125,-0.140521567714,-0.141883826077,-0.143245721482,
	-0.144607252204,-0.145968416522,-0.147329212716,-0.148689639075,-0.150049693888,
	-0.151409375451,-0.152768682061,-0.154127612021,-0.155486163640,-0.156844335227,
	-0.158202125098,-0.159559531572,-0.160916552972,-0.162273187626,-0.163629433863,
	-0.164985290021,-0.166340754437,-0.167695825456,-0.169050501424,-0.170404780692,
	-0.171758661615,-0.173112142554,-0.174465221869,-0.175817897930,-0.177170169105,
	-0.178522033770,-0.179873490304,-0.181224537088,-0.182575172510,-0.183925394959,
	-0.185275202830,-0.186624594521,-0.187973568432,-0.189322122970,-0.190670256544,
	-0.192017967567,-0.193365254456,-0.194712115632,-0.196058549519,-0.197404554546,
	-0.198750129145,-0.200095271750,-0.201439980802,-0.202784254745,-0.204128092024,
	-0.205471491090,-0.206814450398,-0.208156968406,-0.209499043575,-0.210840674370,
	-0.212181859262,-0.213522596721,-0.214862885225,-0.216202723253,-0.217542109289,
	-0.218881041820,-0.220219519336,-0.221557540333,-0.222895103307,-0.224232206760,
	-0.225568849197,-0.226905029127,-0.228240745061,-0.229575995516,-0.230910779011,
	-0.232245094068,-0.233578939213,-0.234912312976,-0.236245213890,-0.237577640492,
	-0.238909591321,-0.240241064923,-0.241572059842,-0.242902574631,-0.244232607843,
	-0.245562158034,-0.246891223767,-0.248219803604,-0.249547896115,-0.250875499868,
	-0.252202613440,-0.253529235408,-0.254855364352,-0.256180998857,-0.257506137511,
	-0.258830778905,-0.260154921634,-0.261478564295,-0.262801705490,-0.264124343822,
	-0.265446477900,-0.266768106335,-0.268089227740,-0.269409840734,-0.270729943938,
	-0.272049535974,-0.273368615472,-0.274687181061,-0.276005231375,-0.277322765051,
	-0.278639780730,-0.279956277055,-0.281272252672,-0.282587706233,-0.283902636389,
	-0.285217041796,-0.286530921116,-0.287844273009,-0.289157096142,-0.290469389183,
	-0.291781150805,-0.293092379683,-0.294403074495,-0.295713233923,-0.297022856651,
	-0.298331941366,-0.299640486760,-0.300948491526,-0.302255954361,-0.303562873965,
	-0.304869249041,-0.306175078296,-0.307480360437,-0.308785094179,-0.310089278234,
	-0.311392911323,-0.312695992166,-0.313998519487,-0.315300492014,-0.316601908477,
	-0.317902767609,-0.319203068146,-0.320502808828,-0.321801988396,-0.323100605597,
	-0.324398659177,-0.325696147889,-0.326993070485,-0.328289425723,-0.329585212363,
	-0.330880429167,-0.332175074901,-0.333469148334,-0.334762648237,-0.336055573384,
	-0.337347922553,-0.338639694523,-0.339930888077,-0.341221502002,-0.342511535086,
	-0.343800986121,-0.345089853900,-0.346378137221,-0.347665834883,-0.348952945691,
	-0.350239468448,-0.351525401965,-0.352810745051,-0.354095496520,-0.355379655191,
	-0.356663219881,-0.357946189414,-0.359228562614,-0.360510338309,-0.361791515330,
	-0.363072092509,-0.364352068684,-0.365631442692,-0.366910213376,-0.368188379578,
	-0.369465940147,-0.370742893931,-0.372019239783,-0.373294976558,-0.374570103113,
	-0.375844618308,-0.377118521007,-0.378391810074,-0.379664484379,-0.380936542792,
	-0.382207984185,-0.383478807437,-0.384749011424,-0.386018595028,-0.387287557134,
	-0.388555896628,-0.389823612398,-0.391090703336,-0.392357168337,-0.393623006298,
	-0.394888216117,-0.396152796696,-0.397416746941,-0.398680065757,-0.399942752055,
	-0.401204804745,-0.402466222744,-0.403727004968,-0.404987150336,-0.406246657770,
	-0.407505526195,-0.408763754538,-0.410021341728,-0.411278286697,-0.412534588379,
	-0.413790245712,-0.415045257633,-0.416299623086,-0.417553341014,-0.418806410363,
	-0.420058830083,-0.421310599124,-0.422561716441,-0.423812180988,-0.425061991726,
	-0.426311147615,-0.427559647617,-0.428807490698,-0.430054675826,-0.431301201972,
	-0.432547068107,-0.433792273208,-0.435036816249,-0.436280696213,-0.437523912079,
	-0.438766462832,-0.440008347458,-0.441249564946,-0.442490114287,-0.443729994474,
	-0.444969204502,-0.446207743369,-0.447445610075,-0.448682803621,-0.449919323012,
	-0.451155167255,-0.452390335357,-0.453624826331,-0.454858639188,-0.456091772944,
	-0.457324226617,-0.458555999226,-0.459787089793,-0.461017497340,-0.462247220896,
	-0.463476259486,-0.464704612142,-0.465932277896,-0.467159255781,-0.468385544836,
	-0.469611144097,-0.470836052605,-0.472060269404,-0.473283793537,-0.474506624052,
	-0.475728759996,-0.476950200422,-0.478170944381,-0.479390990928,-0.480610339120,
	-0.481828988016,-0.483046936676,-0.484264184162,-0.485480729540,-0.486696571876,
	-0.487911710238,-0.489126143696,-0.490339871323,-0.491552892193,-0.492765205382,
	-0.493976809967,-0.495187705029,-0.496397889649,-0.497607362911,-0.498816123899,
	-0.500024171700,-0.501231505405,-0.502438124102,-0.503644026886,-0.504849212849,
	-0.506053681089,-0.507257430702,-0.508460460788,-0.509662770449,-0.510864358788,
	-0.512065224908,-0.513265367917,-0.514464786922,-0.515663481033,-0.516861449361,
	-0.518058691020,-0.519255205124,-0.520450990789,-0.521646047134,-0.522840373276,
	-0.524033968338,-0.525226831443,-0.526418961713,-0.527610358275,-0.528801020257,
	-0.529990946786,-0.531180136994,-0.532368590011,-0.533556304971,-0.534743281009,
	-0.535929517260,-0.537115012863,-0.538299766955,-0.539483778679,-0.540667047174,
	-0.541849571585,-0.543031351056,-0.544212384732,-0.545392671761,-0.546572211292,
	-0.547751002473,-0.548929044457,-0.550106336395,-0.551282877441,-0.552458666750,
	-0.553633703477,-0.554807986781,-0.555981515820,-0.557154289752,-0.558326307740,
	-0.559497568944,-0.560668072528,-0.561837817656,-0.563006803494,-0.564175029207,
	-0.565342493963,-0.566509196930,-0.567675137278,-0.568840314178,-0.570004726800,
	-0.571168374317,-0.572331255902,-0.573493370730,-0.574654717976,-0.575815296816,
	-0.576975106426,-0.578134145986,-0.579292414672,-0.580449911665,-0.581606636146,
	-0.582762587294,-0.583917764292,-0.585072166323,-0.586225792569,-0.587378642215,
	-0.588530714445,-0.589682008444,-0.590832523399,-0.591982258433,-0.593131212516,
	-0.594279384601,-0.595426773724,-0.596573378956,-0.597719199382,-0.598864234100,
	-0.600008482217,-0.601151942847,-0.602294615108,-0.603436498124,-0.604577591023,
	-0.605717892936,-0.606857402998,-0.607996120345,-0.609134044116,-0.610271173455,
	-0.611407507503,-0.612543045407,-0.613677786314,-0.614811729372,-0.615944873732,
	-0.617077218544,-0.618208762961,-0.619339506137,-0.620469447227,-0.621598585386,
	-0.622726919769,-0.623854449535,-0.624981173841,-0.626107091845,-0.627232202707,
	-0.628356505585,-0.629479999640,-0.630602684032,-0.631724557921,-0.632845620469,
	-0.633965870836,-0.635085308184,-0.636203931675,-0.637321740469,-0.638438733728,
	-0.639554910614,-0.640670270288,-0.641784811912,-0.642898534647,-0.644011437653,
	-0.645123520092,-0.646234781123,-0.647345219908,-0.648454835606,-0.649563627376,
	-0.650671594377,-0.651778735768,-0.652885050706,-0.653990538349,-0.655095197854,
	-0.656199028376,-0.657302029071,-0.658404199093,-0.659505537596,-0.660606043733,
	-0.661705716657,-0.662804555517,-0.663902559464,-0.664999727648,-0.666096059217,
	-0.667191553317,-0.668286209094,-0.669380025693,-0.670473002258,-0.671565137930,
	-0.672656431851,-0.673746883160,-0.674836490995,-0.675925254493,-0.677013172788,
	-0.678100245016,-0.679186470307,-0.680271847792,-0.681356376601,-0.682440055859,
	-0.683522884692,-0.684604862224,-0.685685987577,-0.686766259869,-0.687845678219,
	-0.688924241743,-0.690001949554,-0.691078800764,-0.692154794478,-0.693229929815,
	-0.694304205866,-0.695377621744,-0.696450176546,-0.697521869369,-0.698592699304,
	-0.699662665455,-0.700731766905,-0.701800002744,-0.702867372056,-0.703933873924,
	-0.704999507428,-0.706064271644,-0.707128165647,-0.708191188507,-0.709253339294,
	-0.710314617072,-0.711375020902,-0.712434549841,-0.713493202950,-0.714550979280,
	-0.715607877878,-0.716663897791,-0.717719038061,-0.718773297727,-0.719826675823,
	-0.720879171382,-0.721930783431,-0.722981510995,-0.724031353094,-0.725080308745,
	-0.726128376960,-0.727175556747,-0.728221847113,-0.729267247056,-0.730311755573,
	-0.731355371657,-0.732398094295,-0.733439922471,-0.734480855164,-0.735520891348,
	-0.736560029993,-0.737598270065,-0.738635610524,-0.739672050326,-0.740707588422,
	-0.741742223759,-0.742775955277,-0.743808781913,-0.744840702597,-0.745871716257,
	-0.746901821811,-0.747931018176,-0.748959304261,-0.749986678970,-0.751013141203,
	-0.752038689853,-0.753063323808,-0.754087041948,-0.755109843150,-0.756131726284,
	-0.757152690214,-0.758172733798,-0.759191855887,-0.760210055328,-0.761227330959,
	-0.762243681612,-0.763259106115,-0.764273603288,-0.765287171942,-0.766299810885,
	-0.767311518917,-0.768322294829,-0.769332137408,-0.770341045432,-0.771349017673,
	-0.772356052895,-0.773362149855,-0.774367307303,-0.775371523980,-0.776374798622,
	-0.777377129954,-0.778378516697,-0.779378957561,-0.780378451249,-0.781376996458,
	-0.782374591873,-0.783371236174,-0.784366928032,-0.785361666108,-0.786355449056,
	-0.787348275522,-0.788340144141,-0.789331053542,-0.790321002343,-0.791309989154,
	-0.792298012575,-0.793285071198,-0.794271163605,-0.795256288369,-0.796240444053,
	-0.797223629211,-0.798205842388,-0.799187082116,-0.800167346921,-0.801146635317,
	-0.802124945809,-0.803102276890,-0.804078627043,-0.805053994744,-0.806028378453,
	-0.807001776623,-0.807974187696,-0.808945610102,-0.809916042261,-0.810885482581,
	-0.811853929459,-0.812821381282,-0.813787836423,-0.814753293246,-0.815717750103,
	-0.816681205332,-0.817643657262,-0.818605104208,-0.819565544473,-0.820524976350,
	-0.821483398117,-0.822440808040,-0.823397204375,-0.824352585360,-0.825306949227,
	-0.826260294188,-0.827212618448,-0.828163920195,-0.829114197605,-0.830063448840,
	-0.831011672049,-0.831958865368,-0.832905026917,-0.833850154803,-0.834794247121,
	-0.835737301949,-0.836679317351,-0.837620291379,-0.838560222066,-0.839499107435,
	-0.840436945492,-0.841373734226,-0.842309471615,-0.843244155619,-0.844177784182,
	-0.845110355235,-0.846041866692,-0.846972316450,-0.847901702392,-0.848830022385,
	-0.849757274277,-0.850683455903,-0.851608565080,-0.852532599608,-0.853455557271,
	-0.854377435836,-0.855298233051,-0.856217946651,-0.857136574350,-0.858054113845,
	-0.858970562817,-0.859885918929,-0.860800179823,-0.861713343128,-0.862625406450,
	-0.863536367379,-0.864446223488,-0.865354972328,-0.866262611434,-0.867169138320,
	-0.868074550482,-0.868978845396,-0.869882020521,-0.870784073293,-0.871685001131,
	-0.872584801432,-0.873483471576,-0.874381008920,-0.875277410801,-0.876172674538,
	-0.877066797428,-0.877959776745,-0.878851609746,-0.879742293665,-0.880631825715,
	-0.881520203087,-0.882407422952,-0.883293482458,-0.884178378731,-0.885062108878,
	-0.885944669981,-0.886826059099,-0.887706273272,-0.888585309515,-0.889463164820,
	-0.890339836159,-0.891215320477,-0.892089614699,-0.892962715726,-0.893834620434,
	-0.894705325677,-0.895574828285,-0.896443125064,-0.897310212795,-0.898176088237,
	-0.899040748122,-0.899904189159,-0.900766408033,-0.901627401403,-0.902487165902,
	-0.903345698141,-0.904202994703,-0.905059052148,-0.905913867008,-0.906767435790,
	-0.907619754977,-0.908470821023,-0.909320630359,-0.910169179388,-0.911016464487,
	-0.911862482005,-0.912707228268,-0.913550699571,-0.914392892185,-0.915233802353,
	-0.916073426290,-0.916911760184,-0.917748800197,-0.918584542462,-0.919418983085,
	-0.920252118142,-0.921083943684,-0.921914455732,-0.922743650279,-0.923571523291,
	-0.924398070703,-0.925223288425,-0.926047172334,-0.926869718281,-0.927690922087,
	-0.928510779545,-0.929329286417,-0.930146438438,-0.930962231312,-0.931776660714,
	-0.932589722289,-0.933401411653,-0.934211724392,-0.935020656061,-0.935828202187,
	-0.936634358266,-0.937439119763,-0.938242482114,-0.939044440724,-0.939844990969,
	-0.940644128193,-0.941441847709,-0.942238144800,-0.943033014720,-0.943826452691,
	-0.944618453903,-0.945409013516,-0.946198126661,-0.946985788435,-0.947771993905,
	-0.948556738109,-0.949340016052,-0.950121822707,-0.950902153017,-0.951681001896,
	-0.952458364222,-0.953234234847,-0.954008608587,-0.954781480231,-0.955552844534,
	-0.956322696221,-0.957091029985,-0.957857840488,-0.958623122362,-0.959386870206,
	-0.960149078589,-0.960909742049,-0.961668855091,-0.962426412192,-0.963182407797,
	-0.963936836317,-0.964689692137,-0.965440969608,-0.966190663051,-0.966938766757,
	-0.967685274985,-0.968430181964,-0.969173481894,-0.969915168943,-0.970655237250,
	-0.971393680922,-0.972130494038,-0.972865670647,-0.973599204768,-0.974331090388,
	-0.975061321470,-0.975789891941,-0.976516795705,-0.977242026634,-0.977965578571,
	-0.978687445331,-0.979407620702,-0.980126098441,-0.980842872280,-0.981557935921,
	-0.982271283040,-0.982982907284,-0.983692802275,-0.984400961606,-0.985107378846,
	-0.985812047535,-0.986514961190,-0.987216113299,-0.987915497326,-0.988613106712,
	-0.989308934870,-0.990002975189,-0.990695221036,-0.991385665752,-0.992074302655,
	-0.992761125041,-0.993446126182,-0.994129299327,-0.994810637706,-0.995490134524,
	-0.996167782967,-0.996843576200,-0.997517507365,-0.998189569589,-0.998859755974,
	-0.999528059609,-1.000194473558,-1.000858990873,-1.001521604584,-1.002182307706,
	-1.002841093238,-1.003497954160,-1.004152883441,-1.004805874030,-1.005456918866,
	-1.006106010872,-1.006753142957,-1.007398308020,-1.008041498945,-1.008682708606,
	-1.009321929866,-1.009959155578,-1.010594378584,-1.011227591720,-1.011858787809,
	-1.012487959672,-1.013115100119,-1.013740201955,-1.014363257979,-1.014984260987,
	-1.015603203768,-1.016220079110,-1.016834879797,-1.017447598613,-1.018058228338,
	-1.018666761753,-1.019273191641,-1.019877510784,-1.020479711968,-1.021079787980,
	-1.021677731612,-1.022273535661,-1.022867192927,-1.023458696219,-1.024048038351,
	-1.024635212147,-1.025220210439,-1.025803026068,-1.026383651886,-1.026962080759,
	-1.027538305561,-1.028112319184,-1.028684114531,-1.029253684523,-1.029821022096,
	-1.030386120203,-1.030948971815,-1.031509569923,-1.032067907539,-1.032623977695,
	-1.033177773446,-1.033729287868,-1.034278514064,-1.034825445162,-1.035370074315,
	-1.035912394703,-1.036452399536,-1.036990082053,-1.037525435522,-1.038058453244,
	-1.038589128553,-1.039117454815,-1.039643425432,-1.040167033840,-1.040688273514,
	-1.041207137966,-1.041723620747,-1.042237715448,-1.042749415702,-1.043258715182,
	-1.043765607606,-1.044270086738,-1.044772146384,-1.045271780398,-1.045768982684,
	-1.046263747191,-1.046756067921,-1.047245938925,-1.047733354307,-1.048218308223,
	-1.048700794884,-1.049180808557,-1.049658343565,-1.050133394286,-1.050605955161,
	-1.051076020687,-1.051543585422,-1.052008643988,-1.052471191067,-1.052931221406,
	-1.053388729816,-1.053843711177,-1.054296160431,-1.054746072591,-1.055193442738,
	-1.055638266024,-1.056080537670,-1.056520252971,-1.056957407292,-1.057391996075,
	-1.057824014834,-1.058253459162,-1.058680324724,-1.059104607268,-1.059526302615,
	-1.059945406671,-1.060361915417,-1.060775824919,-1.061187131323,-1.061595830858,
	-1.062001919838,-1.062405394661,-1.062806251808,-1.063204487850,-1.063600099443,
	-1.063993083329,-1.064383436342,-1.064771155402,-1.065156237520,-1.065538679798,
	-1.065918479428,-1.066295633696,-1.066670139979,-1.067041995746,-1.067411198562,
	-1.067777746086,-1.068141636070,-1.068502866364,-1.068861434912,-1.069217339756,
	-1.069570579034,-1.069921150982,-1.070269053933,-1.070614286321,-1.070956846674,
	-1.071296733625,-1.071633945902,-1.071968482335,-1.072300341853,-1.072629523488,
	-1.072956026369,-1.073279849729,-1.073600992902,-1.073919455323,-1.074235236528,
	-1.074548336157,-1.074858753949,-1.075166489749,-1.075471543501,-1.075773915253,
	-1.076073605156,-1.076370613462,-1.076664940527,-1.076956586809,-1.077245552868,
	-1.077531839368,-1.077815447073,-1.078096376853,-1.078374629676,-1.078650206616,
	-1.078923108846,-1.079193337643,-1.079460894384,-1.079725780549,-1.079987997718,
	-1.080247547572,-1.080504431893,-1.080758652563,-1.081010211566,-1.081259110982,
	-1.081505352993,-1.081748939880,-1.081989874022,-1.082228157895,-1.082463794075,
	-1.082696785234,-1.082927134141,-1.083154843661,-1.083379916755,-1.083602356480,
	-1.083822165987,-1.084039348522,-1.084253907422,-1.084465846121,-1.084675168143,
	-1.084881877104,-1.085085976711,-1.085287470762,-1.085486363145,-1.085682657836,
	-1.085876358900,-1.086067470491,-1.086255996848,-1.086441942298,-1.086625311251,
	-1.086806108203,-1.086984337736,-1.087160004512,-1.087333113275,-1.087503668855,
	-1.087671676157,-1.087837140170,-1.088000065959,-1.088160458670,-1.088318323523,
	-1.088473665817,-1.088626490925,-1.088776804295,-1.088924611449,-1.089069917981,
	-1.089212729557,-1.089353051914,-1.089490890860,-1.089626252269,-1.089759142087,
	-1.089889566323,-1.090017531056,-1.090143042427,-1.090266106643,-1.090386729975,
	-1.090504918752,-1.090620679370,-1.090734018281,-1.090844941999,-1.090953457093,
	-1.091059570193,-1.091163287983,-1.091264617203,-1.091363564647,-1.091460137163,
	-1.091554341650,-1.091646185060,-1.091735674393,-1.091822816701,-1.091907619083,
	-1.091990088684,-1.092070232698,-1.092148058362,-1.092223572957,-1.092296783811,
	-1.092367698290,-1.092436323803,-1.092502667800,-1.092566737770,-1.092628541239,
	-1.092688085773,-1.092745378971,-1.092800428472,-1.092853241944,-1.092903827093,
	-1.092952191656,-1.092998343402,-1.093042290129,-1.093084039666,-1.093123599871,
	-1.093160978631,-1.093196183856,-1.093229223487,-1.093260105486,-1.093288837842,
	-1.093315428565,-1.093339885690,-1.093362217270,-1.093382431383,-1.093400536123,
	-1.093416539604,-1.093430449959,-1.093442275338,-1.093452023906,-1.093459703845,
	-1.093465323350,-1.093468890632,-1.093470413914,-1.093469901430,-1.093467361427,
	-1.093462802163,-1.093456231904,-1.093447658927,-1.093437091516,-1.093424537962,
	-1.093410006566,-1.093393505632,-1.093375043469,-1.093354628394,-1.093332268724,
	-1.093307972782,-1.093281748892,-1.093253605381,-1.093223550576,-1.093191592806,
	-1.093157740397,-1.093122001677,-1.093084384972,-1.093044898604,-1.093003550895,
	-1.092960350162,-1.092915304717,-1.092868422871,-1.092819712926,-1.092769183181,
	-1.092716841927,-1.092662697448,-1.092606758024,-1.092549031922,-1.092489527403,
	-1.092428252721,-1.092365216116,-1.092300425822,-1.092233890060,-1.092165617041,
	-1.092095614964,-1.092023892017,-1.091950456374,-1.091875316197,-1.091798479635,
	-1.091719954822,-1.091639749879,-1.091557872912,-1.091474332011,-1.091389135251,
	-1.091302290693,-1.091213806378,-1.091123690333,-1.091031950568,-1.090938595075,
	-1.090843631826,-1.090747068780,-1.090648913873,-1.090549175023,-1.090447860130,
	-1.090344977076,-1.090240533718,-1.090134537899,-1.090026997438,-1.089917920134,
	-1.089807313765,-1.089695186088,-1.089581544839,-1.089466397731,-1.089349752456,
	-1.089231616683,-1.089111998060,-1.088990904209,-1.088868342732,-1.088744321207,
	-1.088618847188,-1.088491928205,-1.088363571766,-1.088233785353,-1.088102576425,
	-1.087969952415,-1.087835920732,-1.087700488762,-1.087563663864,-1.087425453371,
	-1.087285864594,-1.087144904815,-1.087002581293,-1.086858901259,-1.086713871921,
	-1.086567500457,-1.086419794023,-1.086270759746,-1.086120404727,-1.085968736042,
	-1.085815760738,-1.085661485838,-1.085505918335,-1.085349065198,-1.085190933367,
	-1.085031529756,-1.084870861252,-1.084708934713,-1.084545756972,-1.084381334834,
	-1.084215675075,-1.084048784444,-1.083880669665,-1.083711337430,-1.083540794408,
	-1.083369047237,-1.083196102527,-1.083021966864,-1.082846646802,-1.082670148869,
	-1.082492479564,-1.082313645361,-1.082133652703,-1.081952508006,-1.081770217658,
	-1.081586788020,-1.081402225424,-1.081216536174,-1.081029726546,-1.080841802790,
	-1.080652771124,-1.080462637742,-1.080271408808,-1.080079090459,-1.079885688803,
	-1.079691209921,-1.079495659866,-1.079299044663,-1.079101370309,-1.078902642773,
	-1.078702867997,-1.078502051896,-1.078300200354,-1.078097319231,-1.077893414358,
	-1.077688491537,-1.077482556545,-1.077275615129,-1.077067673011,-1.076858735885,
	-1.076648809415,-1.076437899241,-1.076226010975,-1.076013150200,-1.075799322474,
	-1.075584533328,-1.075368788263,-1.075152092757,-1.074934452259,-1.074715872191,
	-1.074496357949,-1.074275914903,-1.074054548393,-1.073832263738,-1.073609066225,
	-1.073384961118,-1.073159953654,-1.072934049043,-1.072707252470,-1.072479569093,
	-1.072251004044,-1.072021562429,-1.071791249330,-1.071560069800,-1.071328028868,
	-1.071095131539,-1.070861382789,-1.070626787572,-1.070391350815,-1.070155077419,
	-1.069917972262,-1.069680040194,-1.069441286043,-1.069201714610,-1.068961330672,
	-1.068720138982,-1.068478144266,-1.068235351229,-1.067991764549,-1.067747388880,
	-1.067502228852,-1.067256289071,-1.067009574120,-1.066762088554,-1.066513836910,
	-1.066264823697,-1.066015053401,-1.065764530486,-1.065513259391,-1.065261244533,
	-1.065008490303,-1.064755001073,-1.064500781187,-1.064245834971,-1.063990166724,
	-1.063733780725,-1.063476681228,-1.063218872467,-1.062960358652,-1.062701143970,
	-1.062441232587,-1.062180628646,-1.061919336268,-1.061657359553,-1.061394702578,
	-1.061131369398,-1.060867364048,-1.060602690539,-1.060337352862,-1.060071354988,
	-1.059804700863,-1.059537394416,-1.059269439551,-1.059000840154,-1.058731600089,
	-1.058461723199,-1.058191213307,-1.057920074214,-1.057648309702,-1.057375923533,
	-1.057102919448,-1.056829301166,-1.056555072389,-1.056280236797,-1.056004798051,
	-1.055728759793,-1.055452125643,-1.055174899203,-1.054897084057,-1.054618683765,
	-1.054339701873,-1.054060141905,-1.053780007366,-1.053499301742,-1.053218028501,
	-1.052936191093,-1.052653792946,-1.052370837472,-1.052087328065,-1.051803268099,
	-1.051518660930,-1.051233509896,-1.050947818317,-1.050661589496,-1.050374826715,
	-1.050087533242,-1.049799712325,-1.049511367195,-1.049222501064,-1.048933117130,
	-1.048643218569,-1.048352808544,-1.048061890199,-1.047770466661,-1.047478541039,
	-1.047186116427,-1.046893195901,-1.046599782520,-1.046305879329,-1.046011489352,
	-1.045716615601,-1.045421261069,-1.045125428734,-1.044829121556,-1.044532342481,
	-1.044235094438,-1.043937380341,-1.043639203087,-1.043340565557,-1.043041470618,
	-1.042741921121,-1.042441919901,-1.042141469777,-1.041840573554,-1.041539234021,
	-1.041237453953,-1.040935236108,-1.040632583230,-1.040329498049,-1.040025983280,
	-1.039722041622,-1.039417675760,-1.039112888365,-1.038807682093,-1.038502059586,
	-1.038196023472,-1.037889576363,-1.037582720860,-1.037275459546,-1.036967794994,
	-1.036659729760,-1.036351266388,-1.036042407408,-1.035733155335,-1.035423512673,
	-1.035113481909,-1.034803065521,-1.034492265969,-1.034181085704,-1.033869527159,
	-1.033557592760,-1.033245284913,-1.032932606018,-1.032619558456,-1.032306144599,
	-1.031992366806,-1.031678227421,-1.031363728778,-1.031048873196,-1.030733662984,
	-1.030418100437,-1.030102187838,-1.029785927459,-1.029469321557,-1.029152372380,
	-1.028835082163,-1.028517453127,-1.028199487484,-1.027881187433,-1.027562555160,
	-1.027243592842,-1.026924302641,-1.026604686711,-1.026284747192,-1.025964486214,
	-1.025643905895,-1.025323008340,-1.025001795647,-1.024680269899,-1.024358433169,
	-1.024036287521,-1.023713835004,-1.023391077659,-1.023068017516,-1.022744656594,
	-1.022420996901,-1.022097040434,-1.021772789179,-1.021448245113,-1.021123410202,
	-1.020798286402,-1.020472875656,-1.020147179901,-1.019821201060,-1.019494941047,
	-1.019168401768,-1.018841585116,-1.018514492975,-1.018187127219,-1.017859489714,
	-1.017531582313,-1.017203406861,-1.016874965194,-1.016546259136,-1.016217290504,
	-1.015888061104,-1.015558572733,-1.015228827178,-1.014898826216,-1.014568571618,
	-1.014238065141,-1.013907308537,-1.013576303547,-1.013245051902,-1.012913555325,
	-1.012581815530,-1.012249834222,-1.011917613097,-1.011585153843,-1.011252458137,
	-1.010919527650,-1.010586364042,-1.010252968966,-1.009919344065,-1.009585490974,
	-1.009251411321,-1.008917106724,-1.008582578792,-1.008247829126,-1.007912859321,
	-1.007577670961,-1.007242265623,-1.006906644875,-1.006570810278,-1.006234763385,
	-1.005898505739,-1.005562038877,-1.005225364329,-1.004888483613,-1.004551398244,
	-1.004214109726,-1.003876619556,-1.003538929225,-1.003201040214,-1.002862953996,
	-1.002524672040,-1.002186195805,-1.001847526741,-1.001508666294,-1.001169615900,
	-1.000830376989,-1.000490950983,-1.000151339297,-0.999811543339,-0.999471564510,
	-0.999131404202,-0.998791063803,-0.998450544691,-0.998109848240,-0.997768975813,
	-0.997427928769,-0.997086708460,-0.996745316231,-0.996403753419,-0.996062021355,
	-0.995720121363,-0.995378054761,-0.995035822859,-0.994693426962,-0.994350868368,
	-0.994008148367,-0.993665268245,-0.993322229278,-0.992979032739,-0.992635679892,
	-0.992292171998,-0.991948510307,-0.991604696067,-0.991260730518,-0.990916614892,
	-0.990572350417,-0.990227938316,-0.989883379802,-0.989538676086,-0.989193828370,
	-0.988848837851,-0.988503705720,-0.988158433163,-0.987813021359,-0.987467471480,
	-0.987121784695,-0.986775962165,-0.986430005045,-0.986083914487,-0.985737691634,
	-0.985391337624,-0.985044853592,-0.984698240664,-0.984351499962,-0.984004632603,
	-0.983657639697,-0.983310522348,-0.982963281658,-0.982615918720,-0.982268434623,
	-0.981920830451,-0.981573107281,-0.981225266187,-0.980877308235,-0.980529234489,
	-0.980181046005,-0.979832743836,-0.979484329027,-0.979135802620,-0.978787165652,
	-0.978438419154,-0.978089564152,-0.977740601667,-0.977391532715,-0.977042358309,
	-0.976693079453,-0.976343697150,-0.975994212395,-0.975644626181,-0.975294939494,
	-0.974945153315,-0.974595268623,-0.974245286389,-0.973895207582,-0.973545033163,
	-0.973194764092,-0.972844401321,-0.972493945800,-0.972143398473,-0.971792760280,
	-0.971442032156,-0.971091215032,-0.970740309833,-0.970389317482,-0.970038238896,
	-0.969687074987,-0.969335826664,-0.968984494831,-0.968633080387,-0.968281584227,
	-0.967930007244,-0.967578350323,-0.967226614346,-0.966874800192,-0.966522908736,
	-0.966170940845,-0.965818897387,-0.965466779222,-0.965114587208,-0.964762322198,
	-0.964409985040,-0.964057576581,-0.963705097660,-0.963352549116,-0.962999931780,
	-0.962647246482,-0.962294494046,-0.961941675295,-0.961588791044,-0.961235842107,
	-0.960882829294,-0.960529753410,-0.960176615257,-0.959823415633,-0.959470155331,
	-0.959116835142,-0.958763455853,-0.958410018247,-0.958056523102,-0.957702971194,
	-0.957349363294,-0.956995700172,-0.956641982591,-0.956288211312,-0.955934387093,
	-0.955580510687,-0.955226582844,-0.954872604312,-0.954518575832,-0.954164498145,
	-0.953810371986,-0.953456198089,-0.953101977182,-0.952747709992,-0.952393397240,
	-0.952039039645,-0.951684637924,-0.951330192788,-0.950975704947,-0.950621175105,
	-0.950266603965,-0.949911992227,-0.949557340585,-0.949202649732,-0.948847920358,
	-0.948493153148,-0.948138348786,-0.947783507950,-0.947428631318,-0.947073719562,
	-0.946718773353,-0.946363793358,-0.946008780240,-0.945653734661,-0.945298657279,
	-0.944943548748,-0.944588409719,-0.944233240842,-0.943878042762,-0.943522816122,
	-0.943167561561,-0.942812279716,-0.942456971222,-0.942101636708,-0.941746276803,
	-0.941390892132,-0.941035483316,-0.940680050976,-0.940324595727,-0.939969118184,
	-0.939613618956,-0.939258098652,-0.938902557878,-0.938546997234,-0.938191417322,
	-0.937835818737,-0.937480202074,-0.937124567924,-0.936768916875,-0.936413249515,
	-0.936057566425,-0.935701868187,-0.935346155379,-0.934990428575,-0.934634688348,
	-0.934278935269,-0.933923169905,-0.933567392820,-0.933211604577,-0.932855805735,
	-0.932499996852,-0.932144178482,-0.931788351178,-0.931432515488,-0.931076671960,
	-0.930720821138,-0.930364963564,-0.930009099779,-0.929653230318,-0.929297355717,
	-0.928941476508,-0.928585593222,-0.928229706384,-0.927873816521,-0.927517924155,
	-0.927162029806,-0.926806133992,-0.926450237229,-0.926094340031,-0.925738442907,
	-0.925382546367,-0.925026650917,-0.924670757062,-0.924314865302,-0.923958976137,
	-0.923603090065,-0.923247207580,-0.922891329176,-0.922535455343,-0.922179586568,
	-0.921823723340,-0.921467866140,-0.921112015452,-0.920756171754,-0.920400335524,
	-0.920044507238,-0.919688687368,-0.919332876386,-0.918977074761,-0.918621282959,
	-0.918265501445,-0.917909730681,-0.917553971129,-0.917198223247,-0.916842487491,
	-0.916486764316,-0.916131054173,-0.915775357514,-0.915419674787,-0.915064006438,
	-0.914708352911,-0.914352714649,-0.913997092092,-0.913641485678,-0.913285895845,
	-0.912930323026,-0.912574767654,-0.912219230159,-0.911863710971,-0.911508210516,
	-0.911152729220,-0.910797267504,-0.910441825791,-0.910086404499,-0.909731004046,
	-0.909375624848,-0.909020267318,-0.908664931867,-0.908309618907,-0.907954328845,
	-0.907599062088,-0.907243819040,-0.906888600104,-0.906533405682,-0.906178236171,
	-0.905823091970,-0.905467973475,-0.905112881079,-0.904757815175,-0.904402776153,
	-0.904047764401,-0.903692780308,-0.903337824258,-0.902982896634,-0.902627997820,
	-0.902273128194,-0.901918288136,-0.901563478022,-0.901208698227,-0.900853949126,
	-0.900499231090,-0.900144544490,-0.899789889693,-0.899435267067,-0.899080676978,
	-0.898726119788,-0.898371595861,-0.898017105558,-0.897662649236,-0.897308227253,
	-0.896953839965,-0.896599487727,-0.896245170892,-0.895890889809,-0.895536644830,
	-0.895182436302,-0.894828264571,-0.894474129984,-0.894120032882,-0.893765973609,
	-0.893411952504,-0.893057969907,-0.892704026156,-0.892350121586,-0.891996256532,
	-0.891642431327,-0.891288646303,-0.890934901790,-0.890581198116,-0.890227535610,
	-0.889873914596,-0.889520335400,-0.889166798344,-0.888813303750,-0.888459851938,
	-0.888106443227,-0.887753077935,-0.887399756377,-0.887046478868,-0.886693245722,
	-0.886340057249,-0.885986913762,-0.885633815568,-0.885280762977,-0.884927756293,
	-0.884574795823,-0.884221881870,-0.883869014737,-0.883516194725,-0.883163422133,
	-0.882810697261,-0.882458020405,-0.882105391861,-0.881752811924,-0.881400280888,
	-0.881047799045,-0.880695366684,-0.880342984097,-0.879990651570,-0.879638369392,
	-0.879286137848,-0.878933957222,-0.878581827797,-0.878229749857,-0.877877723681,
	-0.877525749549,-0.877173827739,-0.876821958530,-0.876470142196,-0.876118379012,
	-0.875766669252,-0.875415013189,-0.875063411093,-0.874711863235,-0.874360369883,
	-0.874008931305,-0.873657547767,-0.873306219535,-0.872954946874,-0.872603730045,
	-0.872252569311,-0.871901464933,-0.871550417169,-0.871199426280,-0.870848492522,
	-0.870497616151,-0.870146797422,-0.869796036589,-0.869445333906,-0.869094689624,
	-0.868744103994,-0.868393577266,-0.868043109687,-0.867692701505,-0.867342352968,
	-0.866992064319,-0.866641835804,-0.866291667665,-0.865941560145,-0.865591513485,
	-0.865241527924,-0.864891603701,-0.864541741056,-0.864191940223,-0.863842201440,
	-0.863492524941,-0.863142910961,-0.862793359730,-0.862443871483,-0.862094446448,
	-0.861745084857,-0.861395786938,-0.861046552918,-0.860697383025,-0.860348277484,
	-0.859999236520,-0.859650260356,-0.859301349217,-0.858952503323,-0.858603722896,
	-0.858255008155,-0.857906359320,-0.857557776608,-0.857209260237,-0.856860810423,
	-0.856512427381,-0.856164111326,-0.855815862470,-0.855467681026,-0.855119567206,
	-0.854771521220,-0.854423543278,-0.854075633588,-0.853727792359,-0.853380019797,
	-0.853032316108,-0.852684681498,-0.852337116171,-0.851989620330,-0.851642194177,
	-0.851294837915,-0.850947551743,-0.850600335862,-0.850253190470,-0.849906115766,
	-0.849559111946,-0.849212179208,-0.848865317747,-0.848518527756,-0.848171809431,
	-0.847825162964,-0.847478588547,-0.847132086371,-0.846785656627,-0.846439299505,
	-0.846093015192,-0.845746803878,-0.845400665749,-0.845054600991,-0.844708609790,
	-0.844362692331,-0.844016848798,-0.843671079373,-0.843325384238,-0.842979763576,
	-0.842634217567,-0.842288746390,-0.841943350225,-0.841598029251,-0.841252783644,
	-0.840907613581,-0.840562519238,-0.840217500791,-0.839872558414,-0.839527692281,
	-0.839182902563,-0.838838189435,-0.838493553066,-0.838148993628,-0.837804511290,
	-0.837460106221,-0.837115778590,-0.836771528565,-0.836427356312,-0.836083261998,
	-0.835739245788,-0.835395307846,-0.835051448337,-0.834707667423,-0.834363965268,
	-0.834020342033,-0.833676797880,-0.833333332968
	}
};

double always_inline bigchumppre2clip(double x) {
    double f = fabs(x);
    f = f * bigchumppre2_table.istep;
    int i = static_cast<int>(f);
    if (i < 0) {
        f = bigchumppre2_table.data[0];
    } else if (i >= bigchumppre2_table.size-1) {
        f = bigchumppre2_table.data[bigchumppre2_table.size-1];
    } else {
    f -= i;
    f = bigchumppre2_table.data[i]*(1-f) + bigchumppre2_table.data[i+1]*f;
    }
    return copysign(f, x);
}

#endif //_BIGCHUMPPRE2_H_
