(define size 100000)
(define int-limit 1000000)
(define float-limit 1000.0)


(define (make-ivals)
  (let ((v (make-int-vector size))
	(lim (* 2 int-limit)))
    (do ((i 0 (+ i 1)))
	((= i size) v)
      (int-vector-set! v i (- (random lim) int-limit)))))
(define ivals (make-ivals))

(define (make-ivals1)
  (let ((v (make-vector size))
	(lim (* 2 int-limit)))
    (do ((i 0 (+ i 1)))
	((= i size) v)
      (vector-set! v i (- (random lim) int-limit)))))
(define ivals1 (make-ivals1))


(define (make-fvals)
  (let ((v (make-float-vector size))
	(lim (* 2.0 float-limit)))
    (do ((i 0 (+ i 1)))
	((= i size) v)
      (float-vector-set! v i (- (random lim) float-limit)))))
(define fvals (make-fvals))

(define (make-fvals1)
  (let ((v (make-vector size))
	(lim (* 2.0 float-limit)))
    (do ((i 0 (+ i 1)))
	((= i size) v)
      (vector-set! v i (- (random lim) float-limit)))))
(define fvals1 (make-fvals1))


(define (make-ratvals)
  (let ((v (make-vector size))
	(lim (* 2 int-limit)))
    (do ((i 0 (+ i 1)))
	((= i size) v)
      (vector-set! v i (/ (- (random lim) int-limit) (+ 1 (random int-limit)))))))
(define ratvals (make-ratvals))


(define (make-cvals)
  (let ((v (make-vector size))
	(lim (* 2 float-limit)))
    (do ((i 0 (+ i 1)))
	((= i size) v)
      (vector-set! v i (complex (- (random lim) float-limit) (- (random lim) float-limit))))))
(define cvals (make-cvals))


#|
;;; -------- min max --------
(define (minmax v)
  (let ((lo (v 0))
	(hi (v 0)))
    (do ((i 0 (+ i 1)))
	((= i size) (list lo hi))
      (set! lo (min lo (v i)))
      (set! hi (max hi (v i))))))

(define (minmax1 v)
  (let ((lo (v 0))
	(hi (v 0)))
    (do ((i 0 (+ i 1)))
	((= i size) (list lo hi))
      (set! lo (min lo (v i) hi))
      (set! hi (max hi lo (v i))))))

(format *stderr* "int-minmax ~S~%" (minmax ivals))     ; min/max_i_ii
(format *stderr* "int-minmax ~S~%" (minmax ivals1))    ; min/max_p_pp
(format *stderr* "int-minmax1 ~S~%" (minmax1 ivals))   ; min/max_i_iii
(format *stderr* "int-minmax1 ~S~%" (minmax1 ivals1))  ; g_min/max -> min/max_p_pp [perhaps min/max_3?]
(format *stderr* "float-minmax ~S~%" (minmax fvals))   
(format *stderr* "float-minmax ~S~%" (minmax fvals1))  
(format *stderr* "float-minmax1 ~S~%" (minmax1 fvals)) 
(format *stderr* "float-minmax1 ~S~%" (minmax1 fvals1))
(format *stderr* "ratio-minmax ~S~%" (minmax ratvals)) 


;;; -------- real-part imag-part --------

(define (complex-minmax v)
  (let ((rlo (real-part (v 0)))
	(rhi (real-part (v 0)))
	(ilo (imag-part (v 0)))
	(ihi (imag-part (v 0))))
    (do ((i 0 (+ i 1)))
	((= i size) (list rlo ilo rhi ihi))
      (set! rlo (min rlo (real-part (v i))))
      (set! rhi (max rhi (real-part (v i))))
      (set! ilo (min ilo (imag-part (v i))))
      (set! ihi (max ihi (imag-part (v i)))))))

(format *stderr* "complex-minmax ~S~%" (complex-minmax cvals))


;;; -------- numerator denominator --------

(define (numden-minmax v)
  (let ((numlo (numerator (v 0)))
	(numhi (numerator (v 0)))
	(denlo (denominator (v 0)))
	(denhi (denominator (v 0))))
    (do ((i 0 (+ i 1)))
	((= i size) (list numlo denlo numhi denhi))
      (set! numlo (min numlo (numerator (v i))))
      (set! numhi (max numhi (numerator (v i))))
      (set! denlo (min denlo (denominator (v i))))
      (set! denhi (max denhi (denominator (v i)))))))

(format *stderr* "numden-minmax ~S~%" (numden-minmax ratvals))


;;; -------- even? odd? --------

(define (count-evens v)
  (let ((even 0)
	(odd 0))
    (do ((i 0 (+ i 1)))
	((= i size) (list even odd size (+ even odd)))
      (if (even? (v i)) (set! even (+ even 1)))
      (if (odd? (v i)) (set! odd (+ odd 1))))))

(format *stderr* "evens: ~S~%" (count-evens ivals))
(format *stderr* "evens1: ~S~%" (count-evens ivals1))


;;; -------- zero? positive? negative? --------

(define (count-zeros v)
  (let ((zero 0)
	(pos 0)
	(neg 0))
    (do ((i 0 (+ i 1)))
	((= i size) (list zero pos neg size (+ zero pos neg)))
      (if (zero? (v i)) (set! zero (+ zero 1)))
      (if (positive? (v i)) (set! pos (+ pos 1)))
      (if (negative? (v i)) (set! neg (+ neg 1))))))

(format *stderr* "zeros: ~S~%" (count-zeros ivals))
(format *stderr* "zeros1: ~S~%" (count-zeros ivals1))
(format *stderr* "zerosf: ~S~%" (count-zeros fvals))
(format *stderr* "zerosrat: ~S~%" (count-zeros ratvals))


;;; -------- exact->inexact inexact->exact rationalize --------

(define (inex v1 v2)
  (do ((i 0 (+ i 1)))
      ((= i size))
    (exact->inexact (v1 i))
    (inexact->exact (v2 i))
    (rationalize (v2 i))))

(inex ivals fvals)

(define (inex? v1 v2)
  (do ((i 0 (+ i 1)))
      ((= i size))
    (if (inexact? (v1 i)) (display "oops: inexact?"))
    (if (exact? (v2 i)) (display "oops: exact"))))

(inex? ivals fvals)


;;; -------- integer? byte? number? real? float? complex? rational? infinite? nan? --------

(define (bools)
  (do ((i 0 (+ i 1)))
      ((= i size))
    (if (infinite? (fvals i)) (display "oops inf"))
    (if (nan? (fvals i)) (display "oops nan"))
    (if (integer? (fvals i)) (display "oops int"))
    (if (byte? (cvals i)) (display "oops byte"))
    (if (and (real? (cvals i)) (not (zero? (imag-part (cvals i))))) (display "oops real"))
    (if (or (not (complex? (cvals i))) (not (number? (cvals i)))) (display "oops complex"))
    (if (rational? (cvals i)) (display "oops rational"))
    (if (float? (ivals1 i)) (display "oops float"))))

(bools)


;;; -------- ceiling truncate round floor --------

(define (ceil/floor)
  (let ((ints (make-int-vector 1)))
    (do ((i 0 (+ i 1)))
	((= i size))
      (unless (integer? (ceiling (fvals i))) (display "oops: ceiling"))
      (unless (integer? (floor (fvals i))) (display "oops: floor"))
      (unless (integer? (truncate (fvals i))) (display "oops: truncate"))
      (unless (integer? (round (fvals i))) (display "oops: round"))
      (int-vector-set! ints 0 (ceiling (ratvals i)))
      (int-vector-set! ints 0 (ceiling (fvals i)))
      (int-vector-set! ints 0 (floor (fvals i)))
      (int-vector-set! ints 0 (floor (ratvals i)))
      (int-vector-set! ints 0 (round (fvals i)))
      (int-vector-set! ints 0 (truncate (fvals i))))))

(ceil/floor)


;;; -------- abs magnitude --------

(define (absmag)
  (let ((fv (make-float-vector 1))
	(iv (make-int-vector 1)))
    (do ((i 0 (+ i 1)))
	((= i size))
      (if (not (= (abs (fvals i)) (magnitude (fvals i)))) (display "oops: abs"))
      (if (not (real? (magnitude (cvals i)))) (display "oops: magnitude"))
      (if (negative? (abs (ivals1 i))) (display "oops: abs neg"))
      (if (negative? (abs (ratvals i))) (display "oops: abs neg rat"))
      (int-vector-set! iv 0 (abs (ivals i)))
      (float-vector-set! fv 0 (abs (fvals i))))))

(absmag)
|#



;;; quotient remainder modulo
;;; + - * / 
;;; = < > <= >=
;;; gcd lcm
;;; expt log    exp sqrt
;;; ash logand logior logxor lognot logbit?
;;; sin cos tan sinh cosh tanh asin acos atan asinh acosh atanh angle



(newline)
(exit)
