/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptolib.common;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.cryptomator.cryptolib.api.Cryptor;
import org.cryptomator.cryptolib.api.FileHeader;
import org.cryptomator.cryptolib.common.ByteBuffers;

public class EncryptingReadableByteChannel
implements ReadableByteChannel {
    private final ReadableByteChannel delegate;
    private final Cryptor cryptor;
    private final FileHeader header;
    private ByteBuffer ciphertextBuffer;
    private long chunk = 0L;
    private boolean reachedEof;

    public EncryptingReadableByteChannel(ReadableByteChannel src, Cryptor cryptor) {
        this.delegate = src;
        this.cryptor = cryptor;
        this.header = cryptor.fileHeaderCryptor().create();
        this.ciphertextBuffer = cryptor.fileHeaderCryptor().encryptHeader(this.header);
    }

    @Override
    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public synchronized int read(ByteBuffer dst) throws IOException {
        if (this.reachedEof) {
            return -1;
        }
        return this.readInternal(dst);
    }

    private int readInternal(ByteBuffer dst) throws IOException {
        int result = 0;
        while (dst.hasRemaining() && !this.reachedEof) {
            if (this.ciphertextBuffer.hasRemaining() || this.loadNextCiphertextChunk()) {
                result += ByteBuffers.copy(this.ciphertextBuffer, dst);
                continue;
            }
            assert (this.reachedEof) : "no further ciphertext available";
        }
        return result;
    }

    private boolean loadNextCiphertextChunk() throws IOException {
        ByteBuffer cleartextChunk = ByteBuffer.allocate(this.cryptor.fileContentCryptor().cleartextChunkSize());
        int read = ByteBuffers.fill(this.delegate, cleartextChunk);
        if (read == 0) {
            this.reachedEof = true;
            return false;
        }
        cleartextChunk.flip();
        this.ciphertextBuffer = this.cryptor.fileContentCryptor().encryptChunk(cleartextChunk, this.chunk++, this.header);
        return true;
    }
}

