/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.logging;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.helpers.NOPAppender;
import ch.qos.logback.core.rolling.FixedWindowRollingPolicy;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.util.FileSize;
import dagger.Module;
import dagger.Provides;
import java.nio.file.Path;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.cryptomator.common.Environment;
import org.cryptomator.logging.LaunchAndSizeBasedTriggeringPolicy;
import org.slf4j.ILoggerFactory;
import org.slf4j.LoggerFactory;

@Module
public class LoggerModule {
    private static final String UPGRADE_FILENAME = "upgrade.log";
    private static final String LOGFILE_NAME = "cryptomator0.log";
    private static final String LOGFILE_ROLLING_PATTERN = "cryptomator%i.log";
    private static final int LOGFILE_ROLLING_MIN = 1;
    private static final int LOGFILE_ROLLING_MAX = 9;
    private static final String LOG_PATTERN = "%d{HH:mm:ss.SSS} [%thread] %-5level %logger{36} - %msg%n";
    private static final String LOG_MAX_SIZE = "100mb";
    static final Map<String, Level> DEFAULT_LOG_LEVELS = Map.of("ROOT", Level.INFO, "org.cryptomator", Level.INFO);
    static final Map<String, Level> DEBUG_LOG_LEVELS = Map.of("ROOT", Level.INFO, "org.cryptomator", Level.TRACE);

    @Provides
    @Singleton
    static LoggerContext provideLoggerContext() {
        ILoggerFactory loggerFactory = LoggerFactory.getILoggerFactory();
        if (loggerFactory instanceof LoggerContext) {
            LoggerContext context = (LoggerContext)loggerFactory;
            return context;
        }
        throw new IllegalStateException("SLF4J not bound to Logback.");
    }

    @Provides
    @Singleton
    static PatternLayoutEncoder provideLayoutEncoder(LoggerContext context) {
        PatternLayoutEncoder ple = new PatternLayoutEncoder();
        ple.setPattern(LOG_PATTERN);
        ple.setContext((Context)context);
        ple.start();
        return ple;
    }

    @Provides
    @Singleton
    @Named(value="stdoutAppender")
    static Appender<ILoggingEvent> provideStdoutAppender(LoggerContext context, PatternLayoutEncoder encoder) {
        ConsoleAppender appender = new ConsoleAppender();
        appender.setContext((Context)context);
        appender.setEncoder((Encoder)encoder);
        appender.start();
        return appender;
    }

    @Provides
    @Singleton
    @Named(value="fileAppender")
    static Appender<ILoggingEvent> provideFileAppender(LoggerContext context, PatternLayoutEncoder encoder, Environment environment) {
        if (environment.getLogDir().isPresent()) {
            Path logDir = environment.getLogDir().get();
            RollingFileAppender appender = new RollingFileAppender();
            appender.setContext((Context)context);
            appender.setFile(logDir.resolve(LOGFILE_NAME).toString());
            appender.setEncoder((Encoder)encoder);
            LaunchAndSizeBasedTriggeringPolicy triggeringPolicy = new LaunchAndSizeBasedTriggeringPolicy(FileSize.valueOf((String)LOG_MAX_SIZE));
            triggeringPolicy.setContext((Context)context);
            triggeringPolicy.start();
            appender.setTriggeringPolicy(triggeringPolicy);
            FixedWindowRollingPolicy rollingPolicy = new FixedWindowRollingPolicy();
            rollingPolicy.setContext((Context)context);
            rollingPolicy.setFileNamePattern(logDir.resolve(LOGFILE_ROLLING_PATTERN).toString());
            rollingPolicy.setMinIndex(1);
            rollingPolicy.setMaxIndex(9);
            rollingPolicy.setParent((FileAppender)appender);
            rollingPolicy.start();
            appender.setRollingPolicy((RollingPolicy)rollingPolicy);
            appender.start();
            return appender;
        }
        NOPAppender appender = new NOPAppender();
        appender.setContext((Context)context);
        return appender;
    }

    @Provides
    @Singleton
    @Named(value="upgradeAppender")
    static Appender<ILoggingEvent> provideUpgradeAppender(LoggerContext context, PatternLayoutEncoder encoder, Environment environment) {
        if (environment.getLogDir().isPresent()) {
            FileAppender appender = new FileAppender();
            appender.setFile(environment.getLogDir().get().resolve(UPGRADE_FILENAME).toString());
            appender.setContext((Context)context);
            appender.setEncoder((Encoder)encoder);
            appender.start();
            return appender;
        }
        NOPAppender appender = new NOPAppender();
        appender.setContext((Context)context);
        return appender;
    }
}

