/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.addvaultwizard;

import dagger.Lazy;
import java.io.File;
import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ResourceBundle;
import java.util.UUID;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.stage.DirectoryChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.inject.Inject;
import javax.inject.Named;
import org.cryptomator.ui.addvaultwizard.AddVaultWizardScoped;
import org.cryptomator.ui.addvaultwizard.AddVaultWizardWindow;
import org.cryptomator.ui.addvaultwizard.LocationPresets;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.common.FxmlFile;
import org.cryptomator.ui.common.FxmlScene;
import org.cryptomator.ui.controls.FontAwesome5IconView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AddVaultWizardScoped
public class CreateNewVaultLocationController
implements FxController {
    private static final Logger LOG = LoggerFactory.getLogger(CreateNewVaultLocationController.class);
    private static final Path DEFAULT_CUSTOM_VAULT_PATH = Paths.get(System.getProperty("user.home"), new String[0]);
    private static final String TEMP_FILE_FORMAT = "cryptomator-%s.tmp";
    private final Stage window;
    private final Lazy<Scene> chooseNameScene;
    private final Lazy<Scene> choosePasswordScene;
    private final LocationPresets locationPresets;
    private final ObjectProperty<Path> vaultPath;
    private final StringProperty vaultName;
    private final ResourceBundle resourceBundle;
    private final BooleanBinding validVaultPath;
    private final BooleanProperty usePresetPath;
    private final StringProperty statusText;
    private final ObjectProperty<Node> statusGraphic;
    private Path customVaultPath = DEFAULT_CUSTOM_VAULT_PATH;
    public ToggleGroup predefinedLocationToggler;
    public RadioButton iclouddriveRadioButton;
    public RadioButton dropboxRadioButton;
    public RadioButton gdriveRadioButton;
    public RadioButton onedriveRadioButton;
    public RadioButton megaRadioButton;
    public RadioButton pcloudRadioButton;
    public RadioButton customRadioButton;
    public Label vaultPathStatus;
    public FontAwesome5IconView goodLocation;
    public FontAwesome5IconView badLocation;

    @Inject
    CreateNewVaultLocationController(@AddVaultWizardWindow Stage window, @FxmlScene(value=FxmlFile.ADDVAULT_NEW_NAME) Lazy<Scene> chooseNameScene, @FxmlScene(value=FxmlFile.ADDVAULT_NEW_PASSWORD) Lazy<Scene> choosePasswordScene, LocationPresets locationPresets, ObjectProperty<Path> vaultPath, @Named(value="vaultName") StringProperty vaultName, ResourceBundle resourceBundle) {
        this.window = window;
        this.chooseNameScene = chooseNameScene;
        this.choosePasswordScene = choosePasswordScene;
        this.locationPresets = locationPresets;
        this.vaultPath = vaultPath;
        this.vaultName = vaultName;
        this.resourceBundle = resourceBundle;
        this.validVaultPath = Bindings.createBooleanBinding(this::validateVaultPathAndSetStatus, (Observable[])new Observable[]{this.vaultPath});
        this.usePresetPath = new SimpleBooleanProperty();
        this.statusText = new SimpleStringProperty();
        this.statusGraphic = new SimpleObjectProperty();
    }

    private boolean validateVaultPathAndSetStatus() {
        Path p = (Path)this.vaultPath.get();
        if (p == null) {
            this.statusText.set((Object)"Error: Path is NULL.");
            this.statusGraphic.set((Object)this.badLocation);
            return false;
        }
        if (!Files.exists(p.getParent(), new LinkOption[0])) {
            this.statusText.set((Object)this.resourceBundle.getString("addvaultwizard.new.locationDoesNotExist"));
            this.statusGraphic.set((Object)this.badLocation);
            return false;
        }
        if (!this.isActuallyWritable(p.getParent())) {
            this.statusText.set((Object)this.resourceBundle.getString("addvaultwizard.new.locationIsNotWritable"));
            this.statusGraphic.set((Object)this.badLocation);
            return false;
        }
        if (!Files.notExists(p, new LinkOption[0])) {
            this.statusText.set((Object)this.resourceBundle.getString("addvaultwizard.new.fileAlreadyExists"));
            this.statusGraphic.set((Object)this.badLocation);
            return false;
        }
        this.statusText.set((Object)this.resourceBundle.getString("addvaultwizard.new.locationIsOk"));
        this.statusGraphic.set((Object)this.goodLocation);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isActuallyWritable(Path p) {
        Path tmpFile = p.resolve(String.format(TEMP_FILE_FORMAT, UUID.randomUUID()));
        try {
            boolean bl;
            block17: {
                SeekableByteChannel chan = Files.newByteChannel(tmpFile, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE, StandardOpenOption.DELETE_ON_CLOSE);
                try {
                    bl = true;
                    if (chan == null) break block17;
                }
                catch (Throwable throwable) {
                    try {
                        if (chan != null) {
                            try {
                                chan.close();
                            }
                            catch (Throwable e) {
                                throwable.addSuppressed(e);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        boolean bl2 = false;
                        return bl2;
                    }
                }
                chan.close();
            }
            return bl;
        }
        finally {
            try {
                Files.deleteIfExists(tmpFile);
            }
            catch (IOException e) {
                LOG.warn("Unable to delete temporary file {}. Needs to be deleted manually.", (Object)tmpFile);
            }
        }
    }

    @FXML
    public void initialize() {
        this.predefinedLocationToggler.selectedToggleProperty().addListener(this::togglePredefinedLocation);
        this.usePresetPath.bind((ObservableValue)this.predefinedLocationToggler.selectedToggleProperty().isNotEqualTo((Object)this.customRadioButton));
    }

    private void togglePredefinedLocation(ObservableValue<? extends Toggle> observable, Toggle oldValue, Toggle newValue) {
        if (this.iclouddriveRadioButton.equals(newValue)) {
            this.vaultPath.set((Object)this.locationPresets.getIclouddriveLocation().resolve((String)this.vaultName.get()));
        } else if (this.dropboxRadioButton.equals(newValue)) {
            this.vaultPath.set((Object)this.locationPresets.getDropboxLocation().resolve((String)this.vaultName.get()));
        } else if (this.gdriveRadioButton.equals(newValue)) {
            this.vaultPath.set((Object)this.locationPresets.getGdriveLocation().resolve((String)this.vaultName.get()));
        } else if (this.onedriveRadioButton.equals(newValue)) {
            this.vaultPath.set((Object)this.locationPresets.getOnedriveLocation().resolve((String)this.vaultName.get()));
        } else if (this.megaRadioButton.equals(newValue)) {
            this.vaultPath.set((Object)this.locationPresets.getMegaLocation().resolve((String)this.vaultName.get()));
        } else if (this.pcloudRadioButton.equals(newValue)) {
            this.vaultPath.set((Object)this.locationPresets.getPcloudLocation().resolve((String)this.vaultName.get()));
        } else if (this.customRadioButton.equals(newValue)) {
            this.vaultPath.set((Object)this.customVaultPath.resolve((String)this.vaultName.get()));
        }
    }

    @FXML
    public void back() {
        this.window.setScene((Scene)this.chooseNameScene.get());
    }

    @FXML
    public void next() {
        if (this.validateVaultPathAndSetStatus()) {
            this.window.setScene((Scene)this.choosePasswordScene.get());
        } else {
            this.validVaultPath.invalidate();
        }
    }

    @FXML
    public void chooseCustomVaultPath() {
        DirectoryChooser directoryChooser = new DirectoryChooser();
        directoryChooser.setTitle(this.resourceBundle.getString("addvaultwizard.new.directoryPickerTitle"));
        if (Files.exists(this.customVaultPath, new LinkOption[0])) {
            directoryChooser.setInitialDirectory(this.customVaultPath.toFile());
        } else {
            directoryChooser.setInitialDirectory(DEFAULT_CUSTOM_VAULT_PATH.toFile());
        }
        File file = directoryChooser.showDialog((Window)this.window);
        if (file != null) {
            this.customVaultPath = file.toPath().toAbsolutePath();
            this.vaultPath.set((Object)this.customVaultPath.resolve((String)this.vaultName.get()));
        }
    }

    public Path getVaultPath() {
        return (Path)this.vaultPath.get();
    }

    public ObjectProperty<Path> vaultPathProperty() {
        return this.vaultPath;
    }

    public BooleanBinding validVaultPathProperty() {
        return this.validVaultPath;
    }

    public Boolean getValidVaultPath() {
        return this.validVaultPath.get();
    }

    public LocationPresets getLocationPresets() {
        return this.locationPresets;
    }

    public BooleanProperty usePresetPathProperty() {
        return this.usePresetPath;
    }

    public boolean getUsePresetPath() {
        return this.usePresetPath.get();
    }

    public BooleanBinding anyRadioButtonSelectedProperty() {
        return this.predefinedLocationToggler.selectedToggleProperty().isNotNull();
    }

    public boolean isAnyRadioButtonSelected() {
        return this.anyRadioButtonSelectedProperty().get();
    }

    public StringProperty statusTextProperty() {
        return this.statusText;
    }

    public String getStatusText() {
        return (String)this.statusText.get();
    }

    public ObjectProperty<Node> statusGraphicProperty() {
        return this.statusGraphic;
    }

    public Node getStatusGraphic() {
        return (Node)this.statusGraphic.get();
    }
}

