/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.addvaultwizard;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javax.inject.Inject;
import org.cryptomator.ui.addvaultwizard.AddVaultWizardScoped;

@AddVaultWizardScoped
public class LocationPresets {
    private static final String USER_HOME = System.getProperty("user.home");
    private static final String[] ICLOUDDRIVE_LOCATIONS = new String[]{"~/Library/Mobile Documents/iCloud~com~setolabs~Cryptomator/Documents", "~/iCloudDrive/iCloud~com~setolabs~Cryptomator"};
    private static final String[] DROPBOX_LOCATIONS = new String[]{"~/Dropbox"};
    private static final String[] GDRIVE_LOCATIONS = new String[]{"~/Google Drive/My Drive", "~/Google Drive"};
    private static final String[] ONEDRIVE_LOCATIONS = new String[]{"~/OneDrive"};
    private static final String[] MEGA_LOCATIONS = new String[]{"~/MEGA"};
    private static final String[] PCLOUD_LOCATIONS = new String[]{"~/pCloudDrive"};
    private final ReadOnlyObjectProperty<Path> iclouddriveLocation = new SimpleObjectProperty((Object)LocationPresets.existingWritablePath(ICLOUDDRIVE_LOCATIONS));
    private final ReadOnlyObjectProperty<Path> dropboxLocation = new SimpleObjectProperty((Object)LocationPresets.existingWritablePath(DROPBOX_LOCATIONS));
    private final ReadOnlyObjectProperty<Path> gdriveLocation = new SimpleObjectProperty((Object)LocationPresets.existingWritablePath(GDRIVE_LOCATIONS));
    private final ReadOnlyObjectProperty<Path> onedriveLocation = new SimpleObjectProperty((Object)LocationPresets.existingWritablePath(ONEDRIVE_LOCATIONS));
    private final ReadOnlyObjectProperty<Path> megaLocation = new SimpleObjectProperty((Object)LocationPresets.existingWritablePath(MEGA_LOCATIONS));
    private final ReadOnlyObjectProperty<Path> pcloudLocation = new SimpleObjectProperty((Object)LocationPresets.existingWritablePath(PCLOUD_LOCATIONS));
    private final BooleanBinding foundIclouddrive = this.iclouddriveLocation.isNotNull();
    private final BooleanBinding foundDropbox = this.dropboxLocation.isNotNull();
    private final BooleanBinding foundGdrive = this.gdriveLocation.isNotNull();
    private final BooleanBinding foundOnedrive = this.onedriveLocation.isNotNull();
    private final BooleanBinding foundMega = this.megaLocation.isNotNull();
    private final BooleanBinding foundPcloud = this.pcloudLocation.isNotNull();

    @Inject
    public LocationPresets() {
    }

    private static Path existingWritablePath(String ... candidates) {
        for (String candidate : candidates) {
            Path path = Paths.get(LocationPresets.resolveHomePath(candidate), new String[0]);
            if (!Files.isDirectory(path, new LinkOption[0])) continue;
            return path;
        }
        return null;
    }

    private static String resolveHomePath(String path) {
        if (path.startsWith("~/")) {
            return USER_HOME + path.substring(1);
        }
        return path;
    }

    public ReadOnlyObjectProperty<Path> iclouddriveLocationProperty() {
        return this.iclouddriveLocation;
    }

    public Path getIclouddriveLocation() {
        return (Path)this.iclouddriveLocation.get();
    }

    public BooleanBinding foundIclouddriveProperty() {
        return this.foundIclouddrive;
    }

    public boolean isFoundIclouddrive() {
        return this.foundIclouddrive.get();
    }

    public ReadOnlyObjectProperty<Path> dropboxLocationProperty() {
        return this.dropboxLocation;
    }

    public Path getDropboxLocation() {
        return (Path)this.dropboxLocation.get();
    }

    public BooleanBinding foundDropboxProperty() {
        return this.foundDropbox;
    }

    public boolean isFoundDropbox() {
        return this.foundDropbox.get();
    }

    public ReadOnlyObjectProperty<Path> gdriveLocationProperty() {
        return this.gdriveLocation;
    }

    public Path getGdriveLocation() {
        return (Path)this.gdriveLocation.get();
    }

    public BooleanBinding foundGdriveProperty() {
        return this.foundGdrive;
    }

    public boolean isFoundGdrive() {
        return this.foundGdrive.get();
    }

    public ReadOnlyObjectProperty<Path> onedriveLocationProperty() {
        return this.onedriveLocation;
    }

    public Path getOnedriveLocation() {
        return (Path)this.onedriveLocation.get();
    }

    public BooleanBinding foundOnedriveProperty() {
        return this.foundOnedrive;
    }

    public boolean isFoundOnedrive() {
        return this.foundOnedrive.get();
    }

    public ReadOnlyObjectProperty<Path> megaLocationProperty() {
        return this.megaLocation;
    }

    public Path getMegaLocation() {
        return (Path)this.megaLocation.get();
    }

    public BooleanBinding foundMegaProperty() {
        return this.foundMega;
    }

    public boolean isFoundMega() {
        return this.foundMega.get();
    }

    public ReadOnlyObjectProperty<Path> pcloudLocationProperty() {
        return this.pcloudLocation;
    }

    public Path getPcloudLocation() {
        return (Path)this.pcloudLocation.get();
    }

    public BooleanBinding foundPcloudProperty() {
        return this.foundPcloud;
    }

    public boolean isFoundPcloud() {
        return this.foundPcloud.get();
    }
}

