/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.changepassword;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.security.SecureRandom;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.inject.Inject;
import org.cryptomator.common.keychain.KeychainManager;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.cryptofs.common.MasterkeyBackupHelper;
import org.cryptomator.cryptolib.api.CryptoException;
import org.cryptomator.cryptolib.api.InvalidPassphraseException;
import org.cryptomator.cryptolib.common.MasterkeyFileAccess;
import org.cryptomator.integrations.keychain.KeychainAccessException;
import org.cryptomator.ui.changepassword.ChangePasswordScoped;
import org.cryptomator.ui.changepassword.ChangePasswordWindow;
import org.cryptomator.ui.common.Animations;
import org.cryptomator.ui.common.ErrorComponent;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.common.NewPasswordController;
import org.cryptomator.ui.controls.NiceSecurePasswordField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChangePasswordScoped
public class ChangePasswordController
implements FxController {
    private static final Logger LOG = LoggerFactory.getLogger(ChangePasswordController.class);
    private final Stage window;
    private final Vault vault;
    private final ErrorComponent.Builder errorComponent;
    private final KeychainManager keychain;
    private final SecureRandom csprng;
    private final MasterkeyFileAccess masterkeyFileAccess;
    public NiceSecurePasswordField oldPasswordField;
    public CheckBox finalConfirmationCheckbox;
    public Button finishButton;
    public NewPasswordController newPasswordController;

    @Inject
    public ChangePasswordController(@ChangePasswordWindow Stage window, @ChangePasswordWindow Vault vault, ErrorComponent.Builder errorComponent, KeychainManager keychain, SecureRandom csprng, MasterkeyFileAccess masterkeyFileAccess) {
        this.window = window;
        this.vault = vault;
        this.errorComponent = errorComponent;
        this.keychain = keychain;
        this.csprng = csprng;
        this.masterkeyFileAccess = masterkeyFileAccess;
    }

    @FXML
    public void initialize() {
        BooleanBinding checkboxNotConfirmed = this.finalConfirmationCheckbox.selectedProperty().not();
        BooleanBinding oldPasswordFieldEmpty = this.oldPasswordField.textProperty().isEmpty();
        this.finishButton.disableProperty().bind((ObservableValue)checkboxNotConfirmed.or((ObservableBooleanValue)oldPasswordFieldEmpty).or((ObservableBooleanValue)this.newPasswordController.goodPasswordProperty().not()));
        this.window.setOnHiding(event -> {
            this.oldPasswordField.wipe();
            this.newPasswordController.passwordField.wipe();
            this.newPasswordController.reenterField.wipe();
        });
    }

    @FXML
    public void cancel() {
        this.window.close();
    }

    @FXML
    public void finish() {
        try {
            CharSequence oldPassphrase = this.oldPasswordField.getCharacters();
            CharSequence newPassphrase = this.newPasswordController.passwordField.getCharacters();
            Path masterkeyPath = this.vault.getPath().resolve("masterkey.cryptomator");
            byte[] oldMasterkeyBytes = Files.readAllBytes(masterkeyPath);
            byte[] newMasterkeyBytes = this.masterkeyFileAccess.changePassphrase(oldMasterkeyBytes, oldPassphrase, newPassphrase);
            Path backupKeyPath = this.vault.getPath().resolve("masterkey.cryptomator" + MasterkeyBackupHelper.generateFileIdSuffix((byte[])oldMasterkeyBytes) + ".bkup");
            Files.move(masterkeyPath, backupKeyPath, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
            Files.write(masterkeyPath, newMasterkeyBytes, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
            LOG.info("Successfully changed password for {}", (Object)this.vault.getDisplayName());
            this.updatePasswordInSystemkeychain();
            this.window.close();
        }
        catch (InvalidPassphraseException e) {
            Animations.createShakeWindowAnimation((Window)this.window).play();
            this.oldPasswordField.selectAll();
            this.oldPasswordField.requestFocus();
        }
        catch (IOException | CryptoException e) {
            LOG.error("Password change failed. Unable to perform operation.", e);
            this.errorComponent.cause(e).window(this.window).returnToScene(this.window.getScene()).build().showErrorScene();
        }
    }

    private void updatePasswordInSystemkeychain() {
        if (this.keychain.isSupported() && !this.keychain.isLocked()) {
            try {
                this.keychain.changePassphrase(this.vault.getId(), this.newPasswordController.passwordField.getCharacters());
                LOG.info("Successfully updated password in system keychain for {}", (Object)this.vault.getDisplayName());
            }
            catch (KeychainAccessException e) {
                LOG.error("Failed to update password in system keychain.", (Throwable)e);
            }
        }
    }

    public Vault getVault() {
        return this.vault;
    }
}

