/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.fxapp;

import java.util.Comparator;
import java.util.Optional;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.concurrent.ScheduledService;
import javafx.concurrent.Worker;
import javafx.concurrent.WorkerStateEvent;
import javafx.util.Duration;
import javax.inject.Inject;
import javax.inject.Named;
import org.cryptomator.common.Environment;
import org.cryptomator.common.settings.Settings;
import org.cryptomator.ui.fxapp.FxApplicationScoped;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FxApplicationScoped
public class UpdateChecker {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateChecker.class);
    private static final Duration AUTOCHECK_DELAY = Duration.seconds((double)5.0);
    private final Settings settings;
    private final Optional<String> applicationVersion;
    private final StringProperty currentVersionProperty;
    private final StringProperty latestVersionProperty;
    private final Comparator<String> semVerComparator;
    private final ScheduledService<String> updateCheckerService;

    @Inject
    UpdateChecker(Settings settings, Environment env, @Named(value="latestVersion") StringProperty latestVersionProperty, @Named(value="SemVer") Comparator<String> semVerComparator, ScheduledService<String> updateCheckerService) {
        this.settings = settings;
        this.applicationVersion = env.getAppVersion();
        this.latestVersionProperty = latestVersionProperty;
        this.semVerComparator = semVerComparator;
        this.updateCheckerService = updateCheckerService;
        this.currentVersionProperty = new SimpleStringProperty(this.applicationVersion.orElse("SNAPSHOT"));
    }

    public void automaticallyCheckForUpdatesIfEnabled() {
        if (this.settings.checkForUpdates().get()) {
            this.startCheckingForUpdates(AUTOCHECK_DELAY);
        }
    }

    public void checkForUpdatesNow() {
        this.startCheckingForUpdates(Duration.ZERO);
    }

    private void startCheckingForUpdates(Duration initialDelay) {
        this.updateCheckerService.cancel();
        this.updateCheckerService.reset();
        this.updateCheckerService.setDelay(initialDelay);
        this.updateCheckerService.setOnRunning(this::checkStarted);
        this.updateCheckerService.setOnSucceeded(this::checkSucceeded);
        this.updateCheckerService.setOnFailed(this::checkFailed);
        this.updateCheckerService.start();
    }

    private void checkStarted(WorkerStateEvent event) {
        LOG.debug("Checking for updates...");
    }

    private void checkSucceeded(WorkerStateEvent event) {
        String currentVersion = this.applicationVersion.orElse(null);
        String latestVersion = (String)this.updateCheckerService.getValue();
        LOG.info("Current version: {}, lastest version: {}", (Object)currentVersion, (Object)latestVersion);
        if (currentVersion == null || this.semVerComparator.compare(currentVersion, latestVersion) < 0) {
            this.latestVersionProperty.set((Object)latestVersion);
        } else {
            this.latestVersionProperty.set(null);
        }
    }

    private void checkFailed(WorkerStateEvent event) {
        LOG.warn("Error checking for updates", event.getSource().getException());
    }

    public BooleanBinding checkingForUpdatesProperty() {
        return this.updateCheckerService.stateProperty().isEqualTo((Object)Worker.State.RUNNING);
    }

    public ReadOnlyStringProperty latestVersionProperty() {
        return this.latestVersionProperty;
    }

    public ReadOnlyStringProperty currentVersionProperty() {
        return this.currentVersionProperty;
    }
}

