/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.health;

import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.cryptomator.cryptofs.health.api.DiagnosticResult;
import org.cryptomator.cryptofs.health.api.HealthCheck;
import org.cryptomator.ui.health.Result;

public class Check {
    private final HealthCheck check;
    private final BooleanProperty chosenForExecution = new SimpleBooleanProperty(false);
    private final ObjectProperty<CheckState> state = new SimpleObjectProperty((Object)CheckState.RUNNABLE);
    private final ObservableList<Result> results = FXCollections.observableArrayList(Result::observables);
    private final ObjectProperty<DiagnosticResult.Severity> highestResultSeverity = new SimpleObjectProperty(null);
    private final ObjectProperty<Throwable> error = new SimpleObjectProperty(null);
    private final BooleanBinding isInReRunState = this.state.isNotEqualTo((Object)CheckState.RUNNING).or((ObservableBooleanValue)this.state.isNotEqualTo((Object)CheckState.SCHEDULED));

    Check(HealthCheck check) {
        this.check = check;
    }

    String getName() {
        return this.check.name();
    }

    HealthCheck getHealthCheck() {
        return this.check;
    }

    BooleanProperty chosenForExecutionProperty() {
        return this.chosenForExecution;
    }

    boolean isChosenForExecution() {
        return this.chosenForExecution.get();
    }

    ObjectProperty<CheckState> stateProperty() {
        return this.state;
    }

    CheckState getState() {
        return (CheckState)((Object)this.state.get());
    }

    void setState(CheckState newState) {
        this.state.set((Object)newState);
    }

    ObjectProperty<Throwable> errorProperty() {
        return this.error;
    }

    Throwable getError() {
        return (Throwable)this.error.get();
    }

    void setError(Throwable t) {
        this.error.set((Object)t);
    }

    ObjectProperty<DiagnosticResult.Severity> highestResultSeverityProperty() {
        return this.highestResultSeverity;
    }

    DiagnosticResult.Severity getHighestResultSeverity() {
        return (DiagnosticResult.Severity)this.highestResultSeverity.get();
    }

    void setHighestResultSeverity(DiagnosticResult.Severity severity) {
        this.highestResultSeverity.set((Object)severity);
    }

    boolean isInReRunState() {
        return this.isInReRunState.get();
    }

    ObservableList<Result> getResults() {
        return this.results;
    }

    Observable[] observables() {
        return new Observable[]{this.chosenForExecution, this.state, this.results, this.error};
    }

    static enum CheckState {
        RUNNABLE,
        SCHEDULED,
        RUNNING,
        SUCCEEDED,
        SKIPPED,
        ERROR,
        CANCELLED;

    }
}

