/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.migration;

import dagger.Lazy;
import java.util.ResourceBundle;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.fxml.FXML;
import javafx.scene.Scene;
import javafx.stage.Stage;
import javax.inject.Inject;
import javax.inject.Named;
import org.cryptomator.cryptofs.common.FileSystemCapabilityChecker;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.common.FxmlFile;
import org.cryptomator.ui.common.FxmlScene;
import org.cryptomator.ui.migration.MigrationScoped;
import org.cryptomator.ui.migration.MigrationWindow;

@MigrationScoped
public class MigrationCapabilityErrorController
implements FxController {
    private final Stage window;
    private final ResourceBundle localization;
    private final Lazy<Scene> startScene;
    private final StringBinding missingCapabilityDescription;
    private final ReadOnlyObjectProperty<FileSystemCapabilityChecker.Capability> missingCapability;

    @Inject
    MigrationCapabilityErrorController(@MigrationWindow Stage window, @Named(value="capabilityErrorCause") ObjectProperty<FileSystemCapabilityChecker.Capability> missingCapability, ResourceBundle localization, @FxmlScene(value=FxmlFile.MIGRATION_START) Lazy<Scene> startScene) {
        this.window = window;
        this.missingCapability = missingCapability;
        this.localization = localization;
        this.startScene = startScene;
        this.missingCapabilityDescription = Bindings.createStringBinding(this::getMissingCapabilityDescription, (Observable[])new Observable[]{missingCapability});
    }

    @FXML
    public void back() {
        this.window.setScene((Scene)this.startScene.get());
    }

    public StringBinding missingCapabilityDescriptionProperty() {
        return this.missingCapabilityDescription;
    }

    public String getMissingCapabilityDescription() {
        FileSystemCapabilityChecker.Capability c = (FileSystemCapabilityChecker.Capability)this.missingCapability.get();
        if (c != null) {
            return this.localization.getString("migration.error.missingFileSystemCapabilities.reason." + c.name());
        }
        return null;
    }
}

