/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.quit;

import java.awt.desktop.QuitResponse;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ContentDisplay;
import javafx.stage.Stage;
import javax.inject.Inject;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.common.VaultService;
import org.cryptomator.ui.quit.QuitScoped;
import org.cryptomator.ui.quit.QuitWindow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@QuitScoped
public class QuitController
implements FxController {
    private static final Logger LOG = LoggerFactory.getLogger(QuitController.class);
    private final Stage window;
    private final ObservableList<Vault> unlockedVaults;
    private final ExecutorService executorService;
    private final VaultService vaultService;
    private final AtomicReference<QuitResponse> quitResponse = new AtomicReference();
    public Button lockAndQuitButton;

    @Inject
    QuitController(@QuitWindow Stage window, ObservableList<Vault> vaults, ExecutorService executorService, VaultService vaultService) {
        this.window = window;
        this.unlockedVaults = vaults.filtered(Vault::isUnlocked);
        this.executorService = executorService;
        this.vaultService = vaultService;
        window.setOnCloseRequest(windowEvent -> this.cancel());
    }

    public void updateQuitRequest(QuitResponse newResponse) {
        QuitResponse oldResponse = this.quitResponse.getAndSet(newResponse);
        if (oldResponse != null) {
            oldResponse.cancelQuit();
        }
    }

    private void respondToQuitRequest(Consumer<QuitResponse> action) {
        QuitResponse response = this.quitResponse.getAndSet(null);
        if (response != null) {
            action.accept(response);
        }
    }

    @FXML
    public void cancel() {
        LOG.info("Quitting application canceled by user.");
        this.window.close();
        this.respondToQuitRequest(QuitResponse::cancelQuit);
    }

    @FXML
    public void lockAndQuit() {
        this.lockAndQuitButton.setDisable(true);
        this.lockAndQuitButton.setContentDisplay(ContentDisplay.LEFT);
        Task<Collection<Vault>> lockAllTask = this.vaultService.createLockAllTask((Collection<Vault>)this.unlockedVaults, false);
        lockAllTask.setOnSucceeded(evt -> {
            LOG.info("Locked {}", (Object)((Collection)lockAllTask.getValue()).stream().map(Vault::getDisplayName).collect(Collectors.joining(", ")));
            if (this.unlockedVaults.isEmpty()) {
                this.window.close();
                this.respondToQuitRequest(QuitResponse::performQuit);
            }
        });
        lockAllTask.setOnFailed(evt -> {
            LOG.warn("Locking failed", lockAllTask.getException());
            this.lockAndQuitButton.setDisable(false);
            this.lockAndQuitButton.setContentDisplay(ContentDisplay.TEXT_ONLY);
            this.window.close();
            this.respondToQuitRequest(QuitResponse::cancelQuit);
        });
        this.executorService.execute((Runnable)lockAllTask);
    }
}

