/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.traymenu;

import java.awt.Image;
import java.awt.Toolkit;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.commons.lang3.SystemUtils;
import org.cryptomator.integrations.uiappearance.UiAppearanceProvider;
import org.cryptomator.ui.traymenu.TrayMenuScoped;

@TrayMenuScoped
class TrayImageFactory {
    private final Optional<UiAppearanceProvider> appearanceProvider;

    @Inject
    TrayImageFactory(Optional<UiAppearanceProvider> appearanceProvider) {
        this.appearanceProvider = appearanceProvider;
    }

    public Image loadImage() {
        String resourceName = SystemUtils.IS_OS_MAC_OSX ? this.getMacResourceName() : this.getWinOrLinuxResourceName();
        return Toolkit.getDefaultToolkit().getImage(this.getClass().getResource(resourceName));
    }

    private String getMacResourceName() {
        return "/img/tray_icon_mac.png";
    }

    private String getWinOrLinuxResourceName() {
        return "/img/tray_icon.png";
    }
}

