/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.frontend.webdav;

import java.nio.file.Path;
import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.cryptomator.frontend.webdav.WebDavServerComponent;
import org.cryptomator.frontend.webdav.WebDavServerModule;
import org.cryptomator.frontend.webdav.servlet.WebDavServletComponent;
import org.cryptomator.frontend.webdav.servlet.WebDavServletModule;

@Singleton
class WebDavServletFactory {
    private final WebDavServerComponent component;
    private final Collection<String> contextPaths;

    @Inject
    public WebDavServletFactory(WebDavServerComponent component, @WebDavServerModule.ContextPaths Collection<String> contextPaths) {
        this.component = component;
        this.contextPaths = contextPaths;
    }

    public WebDavServletComponent create(Path rootPath, String contextPath) {
        WebDavServletModule webDavServletModule = new WebDavServletModule(rootPath, contextPath);
        this.contextPaths.add(contextPath);
        return this.component.newWebDavServletComponent(webDavServletModule);
    }
}

