/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.frontend.webdav.mount;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cryptomator.frontend.webdav.mount.MountParam;
import org.cryptomator.frontend.webdav.mount.MountParams;
import org.cryptomator.frontend.webdav.mount.Mounter;
import org.cryptomator.frontend.webdav.mount.MounterStrategy;
import org.cryptomator.frontend.webdav.mount.ProcessUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WindowsMounter
implements MounterStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(WindowsMounter.class);
    private static final boolean IS_OS_WINDOWS = System.getProperty("os.name").contains("Windows");
    private static final Pattern WIN_MOUNT_DRIVELETTER_PATTERN = Pattern.compile("\\s*([A-Z]:)\\s*");
    private static final Pattern REG_QUERY_PROXY_OVERRIDES_PATTERN = Pattern.compile("\\s*ProxyOverride\\s+REG_SZ\\s+(.*)\\s*");
    private static final String AUTOASSIGN_DRRIVE_LETTER = "*";

    WindowsMounter() {
    }

    @Override
    public boolean isApplicable() {
        return IS_OS_WINDOWS;
    }

    @Override
    public Mounter.Mount mount(URI uri, MountParams mountParams) throws Mounter.CommandFailedException {
        try {
            this.tuneProxyConfigSilently(uri);
            String preferredDriveLetter = mountParams.getOrDefault((Object)MountParam.WIN_DRIVE_LETTER, AUTOASSIGN_DRRIVE_LETTER);
            String uncPath = "\\\\" + uri.getHost() + "@" + uri.getPort() + "\\DavWWWRoot" + uri.getRawPath().replace('/', '\\');
            ProcessBuilder mount = new ProcessBuilder("net", "use", preferredDriveLetter, uncPath, "/persistent:no");
            Process mountProcess = mount.start();
            String stdout = ProcessUtil.toString(mountProcess.getInputStream(), StandardCharsets.UTF_8);
            ProcessUtil.waitFor(mountProcess, 30L, TimeUnit.SECONDS);
            ProcessUtil.assertExitValue(mountProcess, 0);
            String driveLetter = AUTOASSIGN_DRRIVE_LETTER.equals(preferredDriveLetter) ? this.getDriveLetter(stdout) : preferredDriveLetter;
            LOG.debug("Mounted {} on drive {}", (Object)uncPath, (Object)driveLetter);
            return new MountImpl(uri, driveLetter);
        }
        catch (IOException e) {
            throw new Mounter.CommandFailedException(e);
        }
    }

    private String getDriveLetter(String result) throws Mounter.CommandFailedException {
        Matcher matcher = WIN_MOUNT_DRIVELETTER_PATTERN.matcher(result);
        if (matcher.find()) {
            return matcher.group(1);
        }
        throw new Mounter.CommandFailedException("Failed to get a drive letter from net use output.");
    }

    private void tuneProxyConfigSilently(URI uri) {
        try {
            this.tuneProxyConfig(uri);
        }
        catch (Mounter.CommandFailedException e) {
            LOG.warn("Tuning proxy config failed.", (Object)e.getMessage());
        }
    }

    @Deprecated
    private void tuneProxyConfig(URI uri) throws Mounter.CommandFailedException {
        try {
            ProcessBuilder regQuery = new ProcessBuilder("reg", "query", "\"HKCU\\Software\\Microsoft\\Windows\\CurrentVersion\\Internet Settings\"", "/v", "ProxyOverride");
            Process regQueryProcess = ProcessUtil.startAndWaitFor(regQuery, 5L, TimeUnit.SECONDS);
            String regQueryResult = ProcessUtil.toString(regQueryProcess.getInputStream(), StandardCharsets.UTF_8);
            HashSet<Object> overrides = new HashSet<Object>();
            Matcher matcher = REG_QUERY_PROXY_OVERRIDES_PATTERN.matcher(regQueryResult);
            if (regQueryProcess.exitValue() == 0 && matcher.find()) {
                String originalOverrides = matcher.group(1);
                LOG.debug("Original Registry value for ProxyOverride is: {}", (Object)originalOverrides);
                Splitter.on((char)';').split((CharSequence)originalOverrides).forEach(overrides::add);
            }
            overrides.removeIf(s -> s.startsWith(uri.getHost() + ":"));
            overrides.add("<local>");
            overrides.add(uri.getHost());
            overrides.add(uri.getHost() + ":" + uri.getPort());
            String adjustedOverrides = Joiner.on((char)';').join(overrides);
            ProcessBuilder regAdd = new ProcessBuilder("reg", "add", "\"HKCU\\Software\\Microsoft\\Windows\\CurrentVersion\\Internet Settings\"", "/v", "ProxyOverride", "/d", "\"" + adjustedOverrides + "\"", "/f");
            LOG.debug("Setting Registry value for ProxyOverride to: {}", (Object)adjustedOverrides);
            Process regAddProcess = ProcessUtil.startAndWaitFor(regAdd, 5L, TimeUnit.SECONDS);
            ProcessUtil.assertExitValue(regAddProcess, 0);
        }
        catch (IOException e) {
            throw new Mounter.CommandFailedException(e);
        }
    }

    private static class MountImpl
    implements Mounter.Mount {
        private final ProcessBuilder unmountCommand;
        private final ProcessBuilder forcedUnmountCommand;
        private final ProcessBuilder revealCommand;
        private final URI accessURI;
        private final Path mountpoint;

        public MountImpl(URI uri, String driveLetter) {
            this.unmountCommand = new ProcessBuilder("net", "use", driveLetter, "/delete", "/no");
            this.forcedUnmountCommand = new ProcessBuilder("net", "use", driveLetter, "/delete", "/yes");
            this.revealCommand = new ProcessBuilder("explorer.exe", "/root," + driveLetter);
            this.mountpoint = Paths.get(driveLetter, new String[0]);
            this.accessURI = uri;
        }

        @Override
        public Optional<Path> getMountPoint() {
            return Optional.of(this.mountpoint);
        }

        @Override
        public URI getWebDavUri() {
            return this.accessURI;
        }

        @Override
        public Optional<Mounter.UnmountOperation> forced() {
            return Optional.of(() -> this.run(this.forcedUnmountCommand));
        }

        @Override
        public void unmount() throws Mounter.CommandFailedException {
            this.run(this.unmountCommand);
        }

        private void run(ProcessBuilder command) throws Mounter.CommandFailedException {
            ProcessUtil.assertExitValue(ProcessUtil.startAndWaitFor(command, 5L, TimeUnit.SECONDS), 0);
        }

        @Override
        public void reveal() throws Mounter.CommandFailedException {
            ProcessUtil.startAndWaitFor(this.revealCommand, 5L, TimeUnit.SECONDS);
        }

        @Override
        public void reveal(Mounter.Revealer revealer) throws Exception {
            revealer.reveal(this.mountpoint);
        }
    }
}

