/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs.fh;

import java.io.IOException;
import java.nio.ByteBuffer;
import javax.inject.Inject;
import org.cryptomator.cryptofs.CryptoFileSystemStats;
import org.cryptomator.cryptofs.fh.ChunkData;
import org.cryptomator.cryptofs.fh.ChunkIO;
import org.cryptomator.cryptofs.fh.FileHeaderHolder;
import org.cryptomator.cryptofs.fh.OpenFileScoped;
import org.cryptomator.cryptolib.api.AuthenticationFailedException;
import org.cryptomator.cryptolib.api.Cryptor;

@OpenFileScoped
class ChunkLoader {
    private final Cryptor cryptor;
    private final ChunkIO ciphertext;
    private final FileHeaderHolder headerHolder;
    private final CryptoFileSystemStats stats;

    @Inject
    public ChunkLoader(Cryptor cryptor, ChunkIO ciphertext, FileHeaderHolder headerHolder, CryptoFileSystemStats stats) {
        this.cryptor = cryptor;
        this.ciphertext = ciphertext;
        this.headerHolder = headerHolder;
        this.stats = stats;
    }

    public ChunkData load(Long chunkIndex) throws IOException, AuthenticationFailedException {
        ByteBuffer cleartextBufWhichCanHoldFullChunk;
        this.stats.addChunkCacheMiss();
        int payloadSize = this.cryptor.fileContentCryptor().cleartextChunkSize();
        int chunkSize = this.cryptor.fileContentCryptor().ciphertextChunkSize();
        long ciphertextPos = chunkIndex * (long)chunkSize + (long)this.cryptor.fileHeaderCryptor().headerSize();
        ByteBuffer ciphertextBuf = ByteBuffer.allocate(chunkSize);
        int read = this.ciphertext.read(ciphertextBuf, ciphertextPos);
        if (read == -1) {
            return ChunkData.emptyWithSize(payloadSize);
        }
        ciphertextBuf.flip();
        ByteBuffer cleartextBuf = this.cryptor.fileContentCryptor().decryptChunk(ciphertextBuf, chunkIndex.longValue(), this.headerHolder.get(), true);
        this.stats.addBytesDecrypted(cleartextBuf.remaining());
        if (cleartextBuf.capacity() < payloadSize) {
            cleartextBufWhichCanHoldFullChunk = ByteBuffer.allocate(payloadSize);
            cleartextBufWhichCanHoldFullChunk.put(cleartextBuf);
            cleartextBufWhichCanHoldFullChunk.flip();
        } else {
            cleartextBufWhichCanHoldFullChunk = cleartextBuf;
        }
        return ChunkData.wrap(cleartextBufWhichCanHoldFullChunk);
    }
}

