/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs.health.api;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Spliterators;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.TransferQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;

class TransferSpliterator<T>
extends Spliterators.AbstractSpliterator<T>
implements Consumer<T>,
AutoCloseable {
    private final TransferQueue<T> queue = new LinkedTransferQueue<T>();
    private final AtomicBoolean poisoned = new AtomicBoolean();
    private final T poison;

    public TransferSpliterator(T poison) {
        super(Long.MAX_VALUE, 1281);
        this.poison = Objects.requireNonNull(poison);
    }

    @Override
    public boolean tryAdvance(Consumer<? super T> action) {
        try {
            Object element = this.queue.take();
            if (element == this.poison) {
                return false;
            }
            action.accept(element);
            return true;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    @Override
    public void accept(T value) throws TransferClosedException {
        Preconditions.checkArgument((value != this.poison ? 1 : 0) != 0, (Object)"must not feed poison");
        if (this.poisoned.get()) {
            throw new TransferClosedException();
        }
        try {
            this.queue.transfer(value);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new TransferClosedException();
        }
    }

    @Override
    public void close() {
        this.poisoned.set(true);
        this.queue.offer(this.poison);
    }

    public static class TransferClosedException
    extends IllegalStateException {
    }
}

