/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.frontend.fuse.locks;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalNotification;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.inject.Inject;
import org.cryptomator.frontend.fuse.PerAdapter;
import org.cryptomator.frontend.fuse.locks.FilePaths;
import org.cryptomator.frontend.fuse.locks.PathLockBuilder;
import org.cryptomator.frontend.fuse.locks.PathLockBuilderImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PerAdapter
public class LockManager {
    private static final Logger LOG = LoggerFactory.getLogger(LockManager.class);
    private final LoadingCache<List<String>, ReadWriteLock> pathLocks;
    private final LoadingCache<List<String>, ReadWriteLock> dataLocks;

    @Inject
    public LockManager() {
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder().weakValues();
        if (LOG.isDebugEnabled()) {
            cacheBuilder.removalListener(this::removedReadWriteLock);
        }
        this.pathLocks = cacheBuilder.build(CacheLoader.from(this::createReadWriteLock));
        this.dataLocks = cacheBuilder.build(CacheLoader.from(this::createReadWriteLock));
    }

    public PathLockBuilder createPathLock(String path) {
        List<String> pathComponents = FilePaths.toComponents(path);
        assert (!pathComponents.isEmpty());
        return this.createPathLock(pathComponents);
    }

    private PathLockBuilder createPathLock(List<String> pathComponents) {
        if (pathComponents.isEmpty()) {
            return null;
        }
        List<String> parentPathComponents = FilePaths.parentPathComponents(pathComponents);
        PathLockBuilder parentLockBuilder = this.createPathLock(parentPathComponents);
        ReadWriteLock lock = (ReadWriteLock)this.pathLocks.getUnchecked(pathComponents);
        return new PathLockBuilderImpl(pathComponents, Optional.ofNullable(parentLockBuilder), lock, arg_0 -> this.dataLocks.getUnchecked(arg_0));
    }

    private ReadWriteLock createReadWriteLock(List<String> key) {
        LOG.trace("Creating ReadWriteLock for {}", key);
        return new ReentrantReadWriteLock();
    }

    private void removedReadWriteLock(RemovalNotification<List<String>, ReentrantReadWriteLock> notification) {
        LOG.trace("Deleting ReadWriteLock for {}", notification.getKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isPathLocked(String path) {
        ReadWriteLock lock = (ReadWriteLock)this.pathLocks.getIfPresent(FilePaths.toComponents(path));
        if (lock == null) {
            return false;
        }
        if (lock.writeLock().tryLock()) {
            try {
                boolean bl = false;
                return bl;
            }
            finally {
                lock.writeLock().unlock();
            }
        }
        return true;
    }
}

