// Copyright 2022 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_CHROMEOS_LOGIN_THEME_SELECTION_SCREEN_HANDLER_H_
#define CHROME_BROWSER_UI_WEBUI_CHROMEOS_LOGIN_THEME_SELECTION_SCREEN_HANDLER_H_

#include "base/memory/weak_ptr.h"
#include "chrome/browser/ash/login/oobe_screen.h"
#include "chrome/browser/ui/webui/chromeos/login/base_screen_handler.h"
#include "components/login/localized_values_builder.h"

namespace ash {
class ThemeSelectionScreen;
}

namespace chromeos {

// Interface between ThemeSelection screen and its representation,
// either WebUI or Views one.
class ThemeSelectionScreenView
    : public base::SupportsWeakPtr<ThemeSelectionScreenView> {
 public:
  constexpr static StaticOobeScreenId kScreenId{"theme-selection",
                                                "ThemeSelectionScreen"};

  virtual ~ThemeSelectionScreenView() = default;

  virtual void Show() = 0;
};

class ThemeSelectionScreenHandler : public ThemeSelectionScreenView,
                                    public BaseScreenHandler {
 public:
  using TView = ThemeSelectionScreenView;

  ThemeSelectionScreenHandler();

  ThemeSelectionScreenHandler(const ThemeSelectionScreenHandler&) = delete;
  ThemeSelectionScreenHandler& operator=(const ThemeSelectionScreenHandler&) =
      delete;

  ~ThemeSelectionScreenHandler() override;

  // ThemeSelectionScreenView implementation
  void Show() override;

  // BaseScreenHandler implementation
  void DeclareLocalizedValues(
      ::login::LocalizedValuesBuilder* builder) override;
};
}  // namespace chromeos

// TODO(https://crbug.com/1164001): remove after the //chrome/browser/chromeos
// source migration is finished.
namespace ash {
using ::chromeos::ThemeSelectionScreenHandler;
using ::chromeos::ThemeSelectionScreenView;
}  // namespace ash

#endif  // CHROME_BROWSER_UI_WEBUI_CHROMEOS_LOGIN_THEME_SELECTION_SCREEN_HANDLER_H_
