/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or https://opensource.org/licenses/CDDL-1.0.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */

/*
 * Copyright 2007 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

#ifndef FILE_COMMON_H
#define	FILE_COMMON_H

/*
 * header file for file_* utilities. These utilities
 * are used by the test cases to perform various file
 * operations (append writes, for example).
 */

#ifdef __cplusplus
extern "C" {
#endif

#ifndef _FILE_OFFSET_BITS
#define	_FILE_OFFSET_BITS 64
#endif

#ifndef _LARGEFILE64_SOURCE
#define	_LARGEFILE64_SOURCE
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include <fcntl.h>
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>

#define	BLOCKSZ		8192
#define	DATA		0xa5
#define	DATA_RANGE	120
#define	BIGBUFFERSIZE	0x800000
#define	BIGFILESIZE	20

extern char *optarg;
extern int optind, opterr, optopt;

#ifdef __cplusplus
}
#endif

#endif /* FILE_COMMON_H */
