require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&__ARM_KVM_H__)) {
    eval 'sub __ARM_KVM_H__ () {1;}' unless defined(&__ARM_KVM_H__);
    eval 'sub KVM_SPSR_EL1 () {0;}' unless defined(&KVM_SPSR_EL1);
    eval 'sub KVM_SPSR_SVC () { &KVM_SPSR_EL1;}' unless defined(&KVM_SPSR_SVC);
    eval 'sub KVM_SPSR_ABT () {1;}' unless defined(&KVM_SPSR_ABT);
    eval 'sub KVM_SPSR_UND () {2;}' unless defined(&KVM_SPSR_UND);
    eval 'sub KVM_SPSR_IRQ () {3;}' unless defined(&KVM_SPSR_IRQ);
    eval 'sub KVM_SPSR_FIQ () {4;}' unless defined(&KVM_SPSR_FIQ);
    eval 'sub KVM_NR_SPSR () {5;}' unless defined(&KVM_NR_SPSR);
    unless(defined(&__ASSEMBLY__)) {
	require 'linux/psci.ph';
	require 'linux/types.ph';
	require 'asm/ptrace.ph';
	require 'asm/sve_context.ph';
	eval 'sub __KVM_HAVE_GUEST_DEBUG () {1;}' unless defined(&__KVM_HAVE_GUEST_DEBUG);
	eval 'sub __KVM_HAVE_IRQ_LINE () {1;}' unless defined(&__KVM_HAVE_IRQ_LINE);
	eval 'sub __KVM_HAVE_READONLY_MEM () {1;}' unless defined(&__KVM_HAVE_READONLY_MEM);
	eval 'sub __KVM_HAVE_VCPU_EVENTS () {1;}' unless defined(&__KVM_HAVE_VCPU_EVENTS);
	eval 'sub KVM_COALESCED_MMIO_PAGE_OFFSET () {1;}' unless defined(&KVM_COALESCED_MMIO_PAGE_OFFSET);
	eval 'sub KVM_REG_SIZE {
	    my($id) = @_;
    	    eval q((1 << ((($id) &  &KVM_REG_SIZE_MASK) >>  &KVM_REG_SIZE_SHIFT)));
	}' unless defined(&KVM_REG_SIZE);
	eval 'sub KVM_ARM_TARGET_AEM_V8 () {0;}' unless defined(&KVM_ARM_TARGET_AEM_V8);
	eval 'sub KVM_ARM_TARGET_FOUNDATION_V8 () {1;}' unless defined(&KVM_ARM_TARGET_FOUNDATION_V8);
	eval 'sub KVM_ARM_TARGET_CORTEX_A57 () {2;}' unless defined(&KVM_ARM_TARGET_CORTEX_A57);
	eval 'sub KVM_ARM_TARGET_XGENE_POTENZA () {3;}' unless defined(&KVM_ARM_TARGET_XGENE_POTENZA);
	eval 'sub KVM_ARM_TARGET_CORTEX_A53 () {4;}' unless defined(&KVM_ARM_TARGET_CORTEX_A53);
	eval 'sub KVM_ARM_TARGET_GENERIC_V8 () {5;}' unless defined(&KVM_ARM_TARGET_GENERIC_V8);
	eval 'sub KVM_ARM_NUM_TARGETS () {6;}' unless defined(&KVM_ARM_NUM_TARGETS);
	eval 'sub KVM_ARM_DEVICE_TYPE_SHIFT () {0;}' unless defined(&KVM_ARM_DEVICE_TYPE_SHIFT);
	eval 'sub KVM_ARM_DEVICE_TYPE_MASK () {(0xffff <<  &KVM_ARM_DEVICE_TYPE_SHIFT);}' unless defined(&KVM_ARM_DEVICE_TYPE_MASK);
	eval 'sub KVM_ARM_DEVICE_ID_SHIFT () {16;}' unless defined(&KVM_ARM_DEVICE_ID_SHIFT);
	eval 'sub KVM_ARM_DEVICE_ID_MASK () {(0xffff <<  &KVM_ARM_DEVICE_ID_SHIFT);}' unless defined(&KVM_ARM_DEVICE_ID_MASK);
	eval 'sub KVM_ARM_DEVICE_VGIC_V2 () {0;}' unless defined(&KVM_ARM_DEVICE_VGIC_V2);
	eval 'sub KVM_VGIC_V2_ADDR_TYPE_DIST () {0;}' unless defined(&KVM_VGIC_V2_ADDR_TYPE_DIST);
	eval 'sub KVM_VGIC_V2_ADDR_TYPE_CPU () {1;}' unless defined(&KVM_VGIC_V2_ADDR_TYPE_CPU);
	eval 'sub KVM_VGIC_V2_DIST_SIZE () {0x1000;}' unless defined(&KVM_VGIC_V2_DIST_SIZE);
	eval 'sub KVM_VGIC_V2_CPU_SIZE () {0x2000;}' unless defined(&KVM_VGIC_V2_CPU_SIZE);
	eval 'sub KVM_VGIC_V3_ADDR_TYPE_DIST () {2;}' unless defined(&KVM_VGIC_V3_ADDR_TYPE_DIST);
	eval 'sub KVM_VGIC_V3_ADDR_TYPE_REDIST () {3;}' unless defined(&KVM_VGIC_V3_ADDR_TYPE_REDIST);
	eval 'sub KVM_VGIC_ITS_ADDR_TYPE () {4;}' unless defined(&KVM_VGIC_ITS_ADDR_TYPE);
	eval 'sub KVM_VGIC_V3_ADDR_TYPE_REDIST_REGION () {5;}' unless defined(&KVM_VGIC_V3_ADDR_TYPE_REDIST_REGION);
	eval 'sub KVM_VGIC_V3_DIST_SIZE () { &SZ_64K;}' unless defined(&KVM_VGIC_V3_DIST_SIZE);
	eval 'sub KVM_VGIC_V3_REDIST_SIZE () {(2*  &SZ_64K);}' unless defined(&KVM_VGIC_V3_REDIST_SIZE);
	eval 'sub KVM_VGIC_V3_ITS_SIZE () {(2*  &SZ_64K);}' unless defined(&KVM_VGIC_V3_ITS_SIZE);
	eval 'sub KVM_ARM_VCPU_POWER_OFF () {0;}' unless defined(&KVM_ARM_VCPU_POWER_OFF);
	eval 'sub KVM_ARM_VCPU_EL1_32BIT () {1;}' unless defined(&KVM_ARM_VCPU_EL1_32BIT);
	eval 'sub KVM_ARM_VCPU_PSCI_0_2 () {2;}' unless defined(&KVM_ARM_VCPU_PSCI_0_2);
	eval 'sub KVM_ARM_VCPU_PMU_V3 () {3;}' unless defined(&KVM_ARM_VCPU_PMU_V3);
	eval 'sub KVM_ARM_VCPU_SVE () {4;}' unless defined(&KVM_ARM_VCPU_SVE);
	eval 'sub KVM_ARM_VCPU_PTRAUTH_ADDRESS () {5;}' unless defined(&KVM_ARM_VCPU_PTRAUTH_ADDRESS);
	eval 'sub KVM_ARM_VCPU_PTRAUTH_GENERIC () {6;}' unless defined(&KVM_ARM_VCPU_PTRAUTH_GENERIC);
	eval 'sub KVM_ARM_MAX_DBG_REGS () {16;}' unless defined(&KVM_ARM_MAX_DBG_REGS);
	eval 'sub KVM_GUESTDBG_USE_SW_BP () {(1<< 16);}' unless defined(&KVM_GUESTDBG_USE_SW_BP);
	eval 'sub KVM_GUESTDBG_USE_HW () {(1<< 17);}' unless defined(&KVM_GUESTDBG_USE_HW);
	eval 'sub KVM_REG_ARM_COPROC_MASK () {0xfff0000;}' unless defined(&KVM_REG_ARM_COPROC_MASK);
	eval 'sub KVM_REG_ARM_COPROC_SHIFT () {16;}' unless defined(&KVM_REG_ARM_COPROC_SHIFT);
	eval 'sub KVM_REG_ARM_CORE () {(0x10 <<  &KVM_REG_ARM_COPROC_SHIFT);}' unless defined(&KVM_REG_ARM_CORE);
	eval 'sub KVM_REG_ARM_CORE_REG {
	    my($name) = @_;
    	    eval q(( &offsetof(\'struct kvm_regs\', $name) / $sizeof{ &__u32}));
	}' unless defined(&KVM_REG_ARM_CORE_REG);
	eval 'sub KVM_REG_ARM_DEMUX () {(0x11 <<  &KVM_REG_ARM_COPROC_SHIFT);}' unless defined(&KVM_REG_ARM_DEMUX);
	eval 'sub KVM_REG_ARM_DEMUX_ID_MASK () {0xff00;}' unless defined(&KVM_REG_ARM_DEMUX_ID_MASK);
	eval 'sub KVM_REG_ARM_DEMUX_ID_SHIFT () {8;}' unless defined(&KVM_REG_ARM_DEMUX_ID_SHIFT);
	eval 'sub KVM_REG_ARM_DEMUX_ID_CCSIDR () {(0x <<  &KVM_REG_ARM_DEMUX_ID_SHIFT);}' unless defined(&KVM_REG_ARM_DEMUX_ID_CCSIDR);
	eval 'sub KVM_REG_ARM_DEMUX_VAL_MASK () {0xff;}' unless defined(&KVM_REG_ARM_DEMUX_VAL_MASK);
	eval 'sub KVM_REG_ARM_DEMUX_VAL_SHIFT () {0;}' unless defined(&KVM_REG_ARM_DEMUX_VAL_SHIFT);
	eval 'sub KVM_REG_ARM64_SYSREG () {(0x13 <<  &KVM_REG_ARM_COPROC_SHIFT);}' unless defined(&KVM_REG_ARM64_SYSREG);
	eval 'sub KVM_REG_ARM64_SYSREG_OP0_MASK () {0xc000;}' unless defined(&KVM_REG_ARM64_SYSREG_OP0_MASK);
	eval 'sub KVM_REG_ARM64_SYSREG_OP0_SHIFT () {14;}' unless defined(&KVM_REG_ARM64_SYSREG_OP0_SHIFT);
	eval 'sub KVM_REG_ARM64_SYSREG_OP1_MASK () {0x3800;}' unless defined(&KVM_REG_ARM64_SYSREG_OP1_MASK);
	eval 'sub KVM_REG_ARM64_SYSREG_OP1_SHIFT () {11;}' unless defined(&KVM_REG_ARM64_SYSREG_OP1_SHIFT);
	eval 'sub KVM_REG_ARM64_SYSREG_CRN_MASK () {0x780;}' unless defined(&KVM_REG_ARM64_SYSREG_CRN_MASK);
	eval 'sub KVM_REG_ARM64_SYSREG_CRN_SHIFT () {7;}' unless defined(&KVM_REG_ARM64_SYSREG_CRN_SHIFT);
	eval 'sub KVM_REG_ARM64_SYSREG_CRM_MASK () {0x78;}' unless defined(&KVM_REG_ARM64_SYSREG_CRM_MASK);
	eval 'sub KVM_REG_ARM64_SYSREG_CRM_SHIFT () {3;}' unless defined(&KVM_REG_ARM64_SYSREG_CRM_SHIFT);
	eval 'sub KVM_REG_ARM64_SYSREG_OP2_MASK () {0x7;}' unless defined(&KVM_REG_ARM64_SYSREG_OP2_MASK);
	eval 'sub KVM_REG_ARM64_SYSREG_OP2_SHIFT () {0;}' unless defined(&KVM_REG_ARM64_SYSREG_OP2_SHIFT);
	eval 'sub ARM64_SYS_REG_SHIFT_MASK {
	    my($x,$n) = @_;
    	    eval q(((($x) <<  &KVM_REG_ARM64_SYSREG_  $n   &_SHIFT) &  &KVM_REG_ARM64_SYSREG_  $n   &_MASK));
	}' unless defined(&ARM64_SYS_REG_SHIFT_MASK);
	eval 'sub __ARM64_SYS_REG {
	    my($op0,$op1,$crn,$crm,$op2) = @_;
    	    eval q(( &KVM_REG_ARM64 |  &KVM_REG_ARM64_SYSREG |  &ARM64_SYS_REG_SHIFT_MASK($op0,  &OP0) |  &ARM64_SYS_REG_SHIFT_MASK($op1,  &OP1) |  &ARM64_SYS_REG_SHIFT_MASK($crn,  &CRN) |  &ARM64_SYS_REG_SHIFT_MASK($crm,  &CRM) |  &ARM64_SYS_REG_SHIFT_MASK($op2,  &OP2)));
	}' unless defined(&__ARM64_SYS_REG);
	eval 'sub ARM64_SYS_REG () {(...) ( &__ARM64_SYS_REG( &__VA_ARGS__) |  &KVM_REG_SIZE_U64);}' unless defined(&ARM64_SYS_REG);
	eval 'sub KVM_REG_ARM_PTIMER_CTL () { &ARM64_SYS_REG(3, 3, 14, 2, 1);}' unless defined(&KVM_REG_ARM_PTIMER_CTL);
	eval 'sub KVM_REG_ARM_PTIMER_CVAL () { &ARM64_SYS_REG(3, 3, 14, 2, 2);}' unless defined(&KVM_REG_ARM_PTIMER_CVAL);
	eval 'sub KVM_REG_ARM_PTIMER_CNT () { &ARM64_SYS_REG(3, 3, 14, 0, 1);}' unless defined(&KVM_REG_ARM_PTIMER_CNT);
	eval 'sub KVM_REG_ARM_TIMER_CTL () { &ARM64_SYS_REG(3, 3, 14, 3, 1);}' unless defined(&KVM_REG_ARM_TIMER_CTL);
	eval 'sub KVM_REG_ARM_TIMER_CVAL () { &ARM64_SYS_REG(3, 3, 14, 0, 2);}' unless defined(&KVM_REG_ARM_TIMER_CVAL);
	eval 'sub KVM_REG_ARM_TIMER_CNT () { &ARM64_SYS_REG(3, 3, 14, 3, 2);}' unless defined(&KVM_REG_ARM_TIMER_CNT);
	eval 'sub KVM_REG_ARM_FW () {(0x14 <<  &KVM_REG_ARM_COPROC_SHIFT);}' unless defined(&KVM_REG_ARM_FW);
	eval 'sub KVM_REG_ARM_FW_REG {
	    my($r) = @_;
    	    eval q(( &KVM_REG_ARM64 |  &KVM_REG_SIZE_U64 |  &KVM_REG_ARM_FW | (($r) & 0xffff)));
	}' unless defined(&KVM_REG_ARM_FW_REG);
	eval 'sub KVM_REG_ARM_PSCI_VERSION () { &KVM_REG_ARM_FW_REG(0);}' unless defined(&KVM_REG_ARM_PSCI_VERSION);
	eval 'sub KVM_REG_ARM_SMCCC_ARCH_WORKAROUND_1 () { &KVM_REG_ARM_FW_REG(1);}' unless defined(&KVM_REG_ARM_SMCCC_ARCH_WORKAROUND_1);
	eval 'sub KVM_REG_ARM_SMCCC_ARCH_WORKAROUND_1_NOT_AVAIL () {0;}' unless defined(&KVM_REG_ARM_SMCCC_ARCH_WORKAROUND_1_NOT_AVAIL);
	eval 'sub KVM_REG_ARM_SMCCC_ARCH_WORKAROUND_1_AVAIL () {1;}' unless defined(&KVM_REG_ARM_SMCCC_ARCH_WORKAROUND_1_AVAIL);
	eval 'sub KVM_REG_ARM_SMCCC_ARCH_WORKAROUND_1_NOT_REQUIRED () {2;}' unless defined(&KVM_REG_ARM_SMCCC_ARCH_WORKAROUND_1_NOT_REQUIRED);
	eval 'sub KVM_REG_ARM_SMCCC_ARCH_WORKAROUND_2 () { &KVM_REG_ARM_FW_REG(2);}' unless defined(&KVM_REG_ARM_SMCCC_ARCH_WORKAROUND_2);
	eval 'sub KVM_REG_ARM_SMCCC_ARCH_WORKAROUND_2_NOT_AVAIL () {0;}' unless defined(&KVM_REG_ARM_SMCCC_ARCH_WORKAROUND_2_NOT_AVAIL);
	eval 'sub KVM_REG_ARM_SMCCC_ARCH_WORKAROUND_2_UNKNOWN () {1;}' unless defined(&KVM_REG_ARM_SMCCC_ARCH_WORKAROUND_2_UNKNOWN);
	eval 'sub KVM_REG_ARM_SMCCC_ARCH_WORKAROUND_2_AVAIL () {2;}' unless defined(&KVM_REG_ARM_SMCCC_ARCH_WORKAROUND_2_AVAIL);
	eval 'sub KVM_REG_ARM_SMCCC_ARCH_WORKAROUND_2_NOT_REQUIRED () {3;}' unless defined(&KVM_REG_ARM_SMCCC_ARCH_WORKAROUND_2_NOT_REQUIRED);
	eval 'sub KVM_REG_ARM_SMCCC_ARCH_WORKAROUND_2_ENABLED () {(1 << 4);}' unless defined(&KVM_REG_ARM_SMCCC_ARCH_WORKAROUND_2_ENABLED);
	eval 'sub KVM_REG_ARM64_SVE () {(0x15 <<  &KVM_REG_ARM_COPROC_SHIFT);}' unless defined(&KVM_REG_ARM64_SVE);
	eval 'sub KVM_REG_ARM64_SVE_ZREG_BASE () {0;}' unless defined(&KVM_REG_ARM64_SVE_ZREG_BASE);
	eval 'sub KVM_REG_ARM64_SVE_PREG_BASE () {0x400;}' unless defined(&KVM_REG_ARM64_SVE_PREG_BASE);
	eval 'sub KVM_REG_ARM64_SVE_FFR_BASE () {0x600;}' unless defined(&KVM_REG_ARM64_SVE_FFR_BASE);
	eval 'sub KVM_ARM64_SVE_NUM_ZREGS () { &__SVE_NUM_ZREGS;}' unless defined(&KVM_ARM64_SVE_NUM_ZREGS);
	eval 'sub KVM_ARM64_SVE_NUM_PREGS () { &__SVE_NUM_PREGS;}' unless defined(&KVM_ARM64_SVE_NUM_PREGS);
	eval 'sub KVM_ARM64_SVE_MAX_SLICES () {32;}' unless defined(&KVM_ARM64_SVE_MAX_SLICES);
	eval 'sub KVM_REG_ARM64_SVE_ZREG {
	    my($n, $i) = @_;
    	    eval q(( &KVM_REG_ARM64 |  &KVM_REG_ARM64_SVE |  &KVM_REG_ARM64_SVE_ZREG_BASE |  &KVM_REG_SIZE_U2048 | ((($n) & ( &KVM_ARM64_SVE_NUM_ZREGS - 1)) << 5) | (($i) & ( &KVM_ARM64_SVE_MAX_SLICES - 1))));
	}' unless defined(&KVM_REG_ARM64_SVE_ZREG);
	eval 'sub KVM_REG_ARM64_SVE_PREG {
	    my($n, $i) = @_;
    	    eval q(( &KVM_REG_ARM64 |  &KVM_REG_ARM64_SVE |  &KVM_REG_ARM64_SVE_PREG_BASE |  &KVM_REG_SIZE_U256 | ((($n) & ( &KVM_ARM64_SVE_NUM_PREGS - 1)) << 5) | (($i) & ( &KVM_ARM64_SVE_MAX_SLICES - 1))));
	}' unless defined(&KVM_REG_ARM64_SVE_PREG);
	eval 'sub KVM_REG_ARM64_SVE_FFR {
	    my($i) = @_;
    	    eval q(( &KVM_REG_ARM64 |  &KVM_REG_ARM64_SVE |  &KVM_REG_ARM64_SVE_FFR_BASE |  &KVM_REG_SIZE_U256 | (($i) & ( &KVM_ARM64_SVE_MAX_SLICES - 1))));
	}' unless defined(&KVM_REG_ARM64_SVE_FFR);
	eval 'sub KVM_ARM64_SVE_VQ_MIN () { &__SVE_VQ_MIN;}' unless defined(&KVM_ARM64_SVE_VQ_MIN);
	eval 'sub KVM_ARM64_SVE_VQ_MAX () { &__SVE_VQ_MAX;}' unless defined(&KVM_ARM64_SVE_VQ_MAX);
	eval 'sub KVM_REG_ARM64_SVE_VLS () {( &KVM_REG_ARM64 |  &KVM_REG_ARM64_SVE |  &KVM_REG_SIZE_U512 | 0xffff);}' unless defined(&KVM_REG_ARM64_SVE_VLS);
	eval 'sub KVM_ARM64_SVE_VLS_WORDS () {(( &KVM_ARM64_SVE_VQ_MAX -  &KVM_ARM64_SVE_VQ_MIN) / 64+ 1);}' unless defined(&KVM_ARM64_SVE_VLS_WORDS);
	eval 'sub KVM_DEV_ARM_VGIC_GRP_ADDR () {0;}' unless defined(&KVM_DEV_ARM_VGIC_GRP_ADDR);
	eval 'sub KVM_DEV_ARM_VGIC_GRP_DIST_REGS () {1;}' unless defined(&KVM_DEV_ARM_VGIC_GRP_DIST_REGS);
	eval 'sub KVM_DEV_ARM_VGIC_GRP_CPU_REGS () {2;}' unless defined(&KVM_DEV_ARM_VGIC_GRP_CPU_REGS);
	eval 'sub KVM_DEV_ARM_VGIC_CPUID_SHIFT () {32;}' unless defined(&KVM_DEV_ARM_VGIC_CPUID_SHIFT);
	eval 'sub KVM_DEV_ARM_VGIC_CPUID_MASK () {(0xff <<  &KVM_DEV_ARM_VGIC_CPUID_SHIFT);}' unless defined(&KVM_DEV_ARM_VGIC_CPUID_MASK);
	eval 'sub KVM_DEV_ARM_VGIC_V3_MPIDR_SHIFT () {32;}' unless defined(&KVM_DEV_ARM_VGIC_V3_MPIDR_SHIFT);
	eval 'sub KVM_DEV_ARM_VGIC_V3_MPIDR_MASK () {(0xffffffff <<  &KVM_DEV_ARM_VGIC_V3_MPIDR_SHIFT);}' unless defined(&KVM_DEV_ARM_VGIC_V3_MPIDR_MASK);
	eval 'sub KVM_DEV_ARM_VGIC_OFFSET_SHIFT () {0;}' unless defined(&KVM_DEV_ARM_VGIC_OFFSET_SHIFT);
	eval 'sub KVM_DEV_ARM_VGIC_OFFSET_MASK () {(0xffffffff <<  &KVM_DEV_ARM_VGIC_OFFSET_SHIFT);}' unless defined(&KVM_DEV_ARM_VGIC_OFFSET_MASK);
	eval 'sub KVM_DEV_ARM_VGIC_SYSREG_INSTR_MASK () {(0xffff);}' unless defined(&KVM_DEV_ARM_VGIC_SYSREG_INSTR_MASK);
	eval 'sub KVM_DEV_ARM_VGIC_GRP_NR_IRQS () {3;}' unless defined(&KVM_DEV_ARM_VGIC_GRP_NR_IRQS);
	eval 'sub KVM_DEV_ARM_VGIC_GRP_CTRL () {4;}' unless defined(&KVM_DEV_ARM_VGIC_GRP_CTRL);
	eval 'sub KVM_DEV_ARM_VGIC_GRP_REDIST_REGS () {5;}' unless defined(&KVM_DEV_ARM_VGIC_GRP_REDIST_REGS);
	eval 'sub KVM_DEV_ARM_VGIC_GRP_CPU_SYSREGS () {6;}' unless defined(&KVM_DEV_ARM_VGIC_GRP_CPU_SYSREGS);
	eval 'sub KVM_DEV_ARM_VGIC_GRP_LEVEL_INFO () {7;}' unless defined(&KVM_DEV_ARM_VGIC_GRP_LEVEL_INFO);
	eval 'sub KVM_DEV_ARM_VGIC_GRP_ITS_REGS () {8;}' unless defined(&KVM_DEV_ARM_VGIC_GRP_ITS_REGS);
	eval 'sub KVM_DEV_ARM_VGIC_LINE_LEVEL_INFO_SHIFT () {10;}' unless defined(&KVM_DEV_ARM_VGIC_LINE_LEVEL_INFO_SHIFT);
	eval 'sub KVM_DEV_ARM_VGIC_LINE_LEVEL_INFO_MASK () {(0x3fffff <<  &KVM_DEV_ARM_VGIC_LINE_LEVEL_INFO_SHIFT);}' unless defined(&KVM_DEV_ARM_VGIC_LINE_LEVEL_INFO_MASK);
	eval 'sub KVM_DEV_ARM_VGIC_LINE_LEVEL_INTID_MASK () {0x3ff;}' unless defined(&KVM_DEV_ARM_VGIC_LINE_LEVEL_INTID_MASK);
	eval 'sub VGIC_LEVEL_INFO_LINE_LEVEL () {0;}' unless defined(&VGIC_LEVEL_INFO_LINE_LEVEL);
	eval 'sub KVM_DEV_ARM_VGIC_CTRL_INIT () {0;}' unless defined(&KVM_DEV_ARM_VGIC_CTRL_INIT);
	eval 'sub KVM_DEV_ARM_ITS_SAVE_TABLES () {1;}' unless defined(&KVM_DEV_ARM_ITS_SAVE_TABLES);
	eval 'sub KVM_DEV_ARM_ITS_RESTORE_TABLES () {2;}' unless defined(&KVM_DEV_ARM_ITS_RESTORE_TABLES);
	eval 'sub KVM_DEV_ARM_VGIC_SAVE_PENDING_TABLES () {3;}' unless defined(&KVM_DEV_ARM_VGIC_SAVE_PENDING_TABLES);
	eval 'sub KVM_DEV_ARM_ITS_CTRL_RESET () {4;}' unless defined(&KVM_DEV_ARM_ITS_CTRL_RESET);
	eval 'sub KVM_ARM_VCPU_PMU_V3_CTRL () {0;}' unless defined(&KVM_ARM_VCPU_PMU_V3_CTRL);
	eval 'sub KVM_ARM_VCPU_PMU_V3_IRQ () {0;}' unless defined(&KVM_ARM_VCPU_PMU_V3_IRQ);
	eval 'sub KVM_ARM_VCPU_PMU_V3_INIT () {1;}' unless defined(&KVM_ARM_VCPU_PMU_V3_INIT);
	eval 'sub KVM_ARM_VCPU_TIMER_CTRL () {1;}' unless defined(&KVM_ARM_VCPU_TIMER_CTRL);
	eval 'sub KVM_ARM_VCPU_TIMER_IRQ_VTIMER () {0;}' unless defined(&KVM_ARM_VCPU_TIMER_IRQ_VTIMER);
	eval 'sub KVM_ARM_VCPU_TIMER_IRQ_PTIMER () {1;}' unless defined(&KVM_ARM_VCPU_TIMER_IRQ_PTIMER);
	eval 'sub KVM_ARM_VCPU_PVTIME_CTRL () {2;}' unless defined(&KVM_ARM_VCPU_PVTIME_CTRL);
	eval 'sub KVM_ARM_VCPU_PVTIME_IPA () {0;}' unless defined(&KVM_ARM_VCPU_PVTIME_IPA);
	eval 'sub KVM_ARM_IRQ_VCPU2_SHIFT () {28;}' unless defined(&KVM_ARM_IRQ_VCPU2_SHIFT);
	eval 'sub KVM_ARM_IRQ_VCPU2_MASK () {0xf;}' unless defined(&KVM_ARM_IRQ_VCPU2_MASK);
	eval 'sub KVM_ARM_IRQ_TYPE_SHIFT () {24;}' unless defined(&KVM_ARM_IRQ_TYPE_SHIFT);
	eval 'sub KVM_ARM_IRQ_TYPE_MASK () {0xf;}' unless defined(&KVM_ARM_IRQ_TYPE_MASK);
	eval 'sub KVM_ARM_IRQ_VCPU_SHIFT () {16;}' unless defined(&KVM_ARM_IRQ_VCPU_SHIFT);
	eval 'sub KVM_ARM_IRQ_VCPU_MASK () {0xff;}' unless defined(&KVM_ARM_IRQ_VCPU_MASK);
	eval 'sub KVM_ARM_IRQ_NUM_SHIFT () {0;}' unless defined(&KVM_ARM_IRQ_NUM_SHIFT);
	eval 'sub KVM_ARM_IRQ_NUM_MASK () {0xffff;}' unless defined(&KVM_ARM_IRQ_NUM_MASK);
	eval 'sub KVM_ARM_IRQ_TYPE_CPU () {0;}' unless defined(&KVM_ARM_IRQ_TYPE_CPU);
	eval 'sub KVM_ARM_IRQ_TYPE_SPI () {1;}' unless defined(&KVM_ARM_IRQ_TYPE_SPI);
	eval 'sub KVM_ARM_IRQ_TYPE_PPI () {2;}' unless defined(&KVM_ARM_IRQ_TYPE_PPI);
	eval 'sub KVM_ARM_IRQ_CPU_IRQ () {0;}' unless defined(&KVM_ARM_IRQ_CPU_IRQ);
	eval 'sub KVM_ARM_IRQ_CPU_FIQ () {1;}' unless defined(&KVM_ARM_IRQ_CPU_FIQ);
	eval 'sub KVM_ARM_IRQ_GIC_MAX () {127;}' unless defined(&KVM_ARM_IRQ_GIC_MAX);
	eval 'sub KVM_NR_IRQCHIPS () {1;}' unless defined(&KVM_NR_IRQCHIPS);
	eval 'sub KVM_PSCI_FN_BASE () {0x95c1ba5e;}' unless defined(&KVM_PSCI_FN_BASE);
	eval 'sub KVM_PSCI_FN {
	    my($n) = @_;
    	    eval q(( &KVM_PSCI_FN_BASE + ($n)));
	}' unless defined(&KVM_PSCI_FN);
	eval 'sub KVM_PSCI_FN_CPU_SUSPEND () { &KVM_PSCI_FN(0);}' unless defined(&KVM_PSCI_FN_CPU_SUSPEND);
	eval 'sub KVM_PSCI_FN_CPU_OFF () { &KVM_PSCI_FN(1);}' unless defined(&KVM_PSCI_FN_CPU_OFF);
	eval 'sub KVM_PSCI_FN_CPU_ON () { &KVM_PSCI_FN(2);}' unless defined(&KVM_PSCI_FN_CPU_ON);
	eval 'sub KVM_PSCI_FN_MIGRATE () { &KVM_PSCI_FN(3);}' unless defined(&KVM_PSCI_FN_MIGRATE);
	eval 'sub KVM_PSCI_RET_SUCCESS () { &PSCI_RET_SUCCESS;}' unless defined(&KVM_PSCI_RET_SUCCESS);
	eval 'sub KVM_PSCI_RET_NI () { &PSCI_RET_NOT_SUPPORTED;}' unless defined(&KVM_PSCI_RET_NI);
	eval 'sub KVM_PSCI_RET_INVAL () { &PSCI_RET_INVALID_PARAMS;}' unless defined(&KVM_PSCI_RET_INVAL);
	eval 'sub KVM_PSCI_RET_DENIED () { &PSCI_RET_DENIED;}' unless defined(&KVM_PSCI_RET_DENIED);
    }
}
1;
