/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.javahl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.tigris.subversion.javahl.CommitItem;
import org.tigris.subversion.javahl.CommitMessage;
import org.tigris.subversion.javahl.InputInterface;
import org.tigris.subversion.javahl.Notify2;
import org.tigris.subversion.javahl.NotifyInformation;
import org.tigris.subversion.javahl.OutputInterface;
import org.tigris.subversion.javahl.ProgressEvent;
import org.tigris.subversion.javahl.ProgressListener;
import org.tigris.subversion.javahl.PromptUserPassword3;
import org.tigris.subversion.javahl.SVNAdmin;
import org.tigris.subversion.javahl.SVNClientInterface;
import org.tigris.subversion.javahl.SVNClientSynchronized;
import org.tigris.subversion.javahl.Status;
import org.tigris.subversion.javahl.SubversionException;
import org.tigris.subversion.javahl.WC;

class SVNTests
extends TestCase {
    protected SVNAdmin admin;
    protected SVNClientInterface client;
    protected File rootDir;
    private String fsType;
    protected String testBaseName;
    protected static int testCounter;
    protected File greekDump;
    protected File greekRepos;
    protected WC greekWC;
    protected File localTmp;
    protected File repositories;
    protected File workingCopies;
    protected File conf;
    protected String logMessage = "Log Message";
    protected Map expectedCommitItems;
    protected static String rootDirectoryName;
    protected static String rootUrl;

    protected SVNTests() {
        this.init();
    }

    protected SVNTests(String string) {
        super(string);
        this.init();
    }

    private void init() {
        if (rootDirectoryName == null) {
            rootDirectoryName = System.getProperty("test.rootdir");
        }
        if (rootDirectoryName == null) {
            rootDirectoryName = System.getProperty("user.dir");
        }
        this.rootDir = new File(rootDirectoryName);
        if (rootUrl == null) {
            rootUrl = System.getProperty("test.rooturl");
        }
        if (rootUrl == null || rootUrl.trim().length() == 0) {
            rootUrl = this.rootDir.toURI().toString();
            if (!rootUrl.startsWith("file:///")) {
                if (rootUrl.startsWith("file://")) {
                    rootUrl = rootUrl.replaceFirst("file://", "file:///");
                } else if (rootUrl.startsWith("file:/")) {
                    rootUrl = rootUrl.replaceFirst("file:/", "file:///");
                }
            }
            if (!rootUrl.endsWith("/")) {
                rootUrl = rootUrl + '/';
            }
        }
        if (this.fsType == null) {
            this.fsType = System.getProperty("test.fstype", "fsfs").toLowerCase();
            if (!"fsfs".equals(this.fsType) && !"bdb".equals(this.fsType)) {
                this.fsType = "fsfs";
            }
        }
        this.localTmp = new File(this.rootDir, "local_tmp");
        this.conf = new File(this.localTmp, "config");
        this.repositories = new File(this.rootDir, "repositories");
        this.workingCopies = new File(this.rootDir, "working_copies");
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.createDirectories();
        this.admin = new SVNAdmin();
        this.initClient();
        File file = this.buildGreekFiles();
        this.greekRepos = new File(this.localTmp, "repos");
        this.greekDump = new File(this.localTmp, "greek_dump");
        this.admin.create(this.greekRepos.getAbsolutePath(), true, false, null, this.fsType);
        this.addExpectedCommitItem(file.getAbsolutePath(), null, null, 0, 1);
        this.client.doImport(file.getAbsolutePath(), this.makeReposUrl(this.greekRepos), null, true);
        this.admin.dump(this.greekRepos.getAbsolutePath(), new FileOutputer(this.greekDump), new IgnoreOutputer(), null, null, false);
    }

    private void createDirectories() {
        this.rootDir.mkdirs();
        if (this.localTmp.exists()) {
            SVNTests.removeDirOrFile(this.localTmp);
        }
        this.localTmp.mkdir();
        this.conf.mkdir();
        this.repositories.mkdir();
        this.workingCopies.mkdir();
    }

    private void initClient() throws SubversionException {
        this.client = new SVNClientSynchronized();
        this.client.notification2(new MyNotifier());
        this.client.commitMessageHandler(new MyCommitMessage());
        this.client.setPrompt(new DefaultPromptUserPassword());
        this.client.username("jrandom");
        this.client.setProgressListener(new DefaultProgressListener());
        this.client.setConfigDirectory(this.conf.getAbsolutePath());
        this.expectedCommitItems = new HashMap();
    }

    private File buildGreekFiles() throws IOException {
        File file = new File(this.localTmp, "greek_files");
        file.mkdir();
        this.greekWC = new WC();
        this.greekWC.addItem("", null);
        this.greekWC.addItem("iota", "This is the file 'iota'.");
        this.greekWC.addItem("A", null);
        this.greekWC.addItem("A/mu", "This is the file 'mu'.");
        this.greekWC.addItem("A/B", null);
        this.greekWC.addItem("A/B/lambda", "This is the file 'lambda'.");
        this.greekWC.addItem("A/B/E", null);
        this.greekWC.addItem("A/B/E/alpha", "This is the file 'alpha'.");
        this.greekWC.addItem("A/B/E/beta", "This is the file 'beta'.");
        this.greekWC.addItem("A/B/F", null);
        this.greekWC.addItem("A/C", null);
        this.greekWC.addItem("A/D", null);
        this.greekWC.addItem("A/D/gamma", "This is the file 'gamma'.");
        this.greekWC.addItem("A/D/H", null);
        this.greekWC.addItem("A/D/H/chi", "This is the file 'chi'.");
        this.greekWC.addItem("A/D/H/psi", "This is the file 'psi'.");
        this.greekWC.addItem("A/D/H/omega", "This is the file 'omega'.");
        this.greekWC.addItem("A/D/G", null);
        this.greekWC.addItem("A/D/G/pi", "This is the file 'pi'.");
        this.greekWC.addItem("A/D/G/rho", "This is the file 'rho'.");
        this.greekWC.addItem("A/D/G/tau", "This is the file 'tau'.");
        this.greekWC.materialize(file);
        return file;
    }

    static final void removeDirOrFile(File file) {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                SVNTests.removeDirOrFile(fileArray[i]);
            }
        }
        file.delete();
    }

    protected void tearDown() throws Exception {
        this.admin.dispose();
        this.client.dispose();
        SVNTests.removeDirOrFile(this.localTmp);
        super.tearDown();
    }

    protected String makeReposUrl(File file) {
        String string = file.getAbsolutePath().substring(this.rootDir.getAbsolutePath().length() + 1);
        return rootUrl + string.replace(File.separatorChar, '/');
    }

    protected void addExpectedCommitItem(String string, String string2, String string3, int n, int n2) {
        String string4 = null;
        if (string != null) {
            string4 = string3 != null ? string.replace(File.separatorChar, '/') + '/' + string3 : string.replace(File.separatorChar, '/');
        }
        String string5 = null;
        if (string2 != null) {
            string5 = string3 != null ? string2 + '/' + string3 : string2;
        }
        String string6 = string5 != null ? string5 : string4;
        this.expectedCommitItems.put(string6, new MyCommitItem(string4, n, n2, string5));
    }

    protected String getAdminDirectoryName() {
        String string = null;
        if (this.client != null) {
            string = this.client.getAdminDirectoryName();
        }
        if (string == null) {
            SVNTests.fail((String)"Unable to determine the WC admin directory name");
        }
        return string;
    }

    class MyNotifier
    implements Notify2 {
        MyNotifier() {
        }

        @Override
        public void onNotify(NotifyInformation notifyInformation) {
        }
    }

    class MyCommitItem {
        String myPath;
        int myNodeKind;
        int myStateFlags;
        String myUrl;

        private MyCommitItem(String string, int n, int n2, String string2) {
            this.myPath = string;
            this.myNodeKind = n;
            this.myStateFlags = n2;
            this.myUrl = string2;
        }

        private void test(CommitItem commitItem, String string) {
            TestCase.assertEquals((String)"commit item path", (String)this.myPath, (String)commitItem.getPath());
            TestCase.assertEquals((String)"commit item node kind", (int)this.myNodeKind, (int)commitItem.getNodeKind());
            TestCase.assertEquals((String)"commit item state flags", (int)this.myStateFlags, (int)commitItem.getStateFlags());
            TestCase.assertEquals((String)"commit item url", (String)this.myUrl, (String)commitItem.getUrl());
            SVNTests.this.expectedCommitItems.remove(string);
        }
    }

    class MyCommitMessage
    implements CommitMessage {
        MyCommitMessage() {
        }

        @Override
        public String getLogMessage(CommitItem[] commitItemArray) {
            for (int i = 0; i < commitItemArray.length; ++i) {
                Object object = commitItemArray[i];
                String string = ((CommitItem)object).getUrl() != null ? ((CommitItem)object).getUrl() : ((CommitItem)object).getPath();
                MyCommitItem myCommitItem = (MyCommitItem)SVNTests.this.expectedCommitItems.get(string);
                TestCase.assertNotNull((String)("commit item for " + string + " not expected"), (Object)myCommitItem);
                myCommitItem.test((CommitItem)object, string);
            }
            for (Object object : SVNTests.this.expectedCommitItems.keySet()) {
                TestCase.fail((String)("commit item for " + (String)object + " not found"));
            }
            return SVNTests.this.logMessage;
        }
    }

    protected class OneTest {
        protected File repository;
        protected File workingCopy;
        protected String url;
        protected WC wc;
        String testName;

        protected OneTest(boolean bl, boolean bl2) throws SubversionException, IOException {
            this.testName = SVNTests.this.testBaseName + ++testCounter;
            this.wc = SVNTests.this.greekWC.copy();
            this.repository = this.createInitialRepository(bl2);
            this.url = SVNTests.this.makeReposUrl(this.repository);
            if (bl) {
                this.workingCopy = this.createInitialWorkingCopy(this.repository);
            }
        }

        protected OneTest(boolean bl) throws SubversionException, IOException {
            this(bl, true);
        }

        protected OneTest() throws SubversionException, IOException {
            this(true);
        }

        protected OneTest copy(String string) throws SubversionException, IOException {
            return new OneTest(this, string);
        }

        private OneTest(OneTest oneTest, String string) throws SubversionException, IOException {
            this.testName = SVNTests.this.testBaseName + testCounter + string;
            this.repository = oneTest.getRepository();
            this.url = oneTest.getUrl();
            this.wc = oneTest.wc.copy();
            this.workingCopy = this.createInitialWorkingCopy(this.repository);
        }

        public File getRepository() {
            return this.repository;
        }

        public String getRepositoryPath() {
            return this.repository.getAbsolutePath();
        }

        public File getWorkingCopy() {
            return this.workingCopy;
        }

        public String getWCPath() {
            return this.workingCopy.getAbsolutePath();
        }

        public String getUrl() {
            return this.url;
        }

        public WC getWc() {
            return this.wc;
        }

        protected File createInitialRepository(boolean bl) throws SubversionException, IOException {
            File file = new File(SVNTests.this.repositories, this.testName);
            SVNTests.removeDirOrFile(file);
            SVNTests.this.admin.create(file.getAbsolutePath(), true, false, SVNTests.this.conf.getAbsolutePath(), SVNTests.this.fsType);
            if (bl) {
                SVNTests.this.admin.load(file.getAbsolutePath(), new FileInputer(SVNTests.this.greekDump), new IgnoreOutputer(), false, false, null);
            }
            return file;
        }

        protected File createInitialWorkingCopy(File file) throws SubversionException, IOException {
            String string = SVNTests.this.makeReposUrl(file);
            this.workingCopy = new File(SVNTests.this.workingCopies, this.testName);
            SVNTests.removeDirOrFile(this.workingCopy);
            SVNTests.this.client.checkout(string, this.workingCopy.getAbsolutePath(), null, true);
            this.checkStatus();
            return this.workingCopy;
        }

        public void checkStatus() throws SubversionException, IOException {
            this.checkStatus(false);
        }

        public void checkStatus(boolean bl) throws SubversionException, IOException {
            Status[] statusArray = SVNTests.this.client.status(this.workingCopy.getAbsolutePath(), true, bl, true, true);
            this.wc.check(statusArray, this.workingCopy.getAbsolutePath(), bl);
        }

        public String toString() {
            return this.testName;
        }
    }

    public class FileInputer
    implements InputInterface {
        FileInputStream myStream;

        public FileInputer(File file) throws IOException {
            this.myStream = new FileInputStream(file);
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            return this.myStream.read(byArray);
        }

        @Override
        public void close() throws IOException {
            this.myStream.close();
        }
    }

    public class IgnoreOutputer
    implements OutputInterface {
        @Override
        public int write(byte[] byArray) throws IOException {
            return byArray.length;
        }

        @Override
        public void close() throws IOException {
        }
    }

    public class FileOutputer
    implements OutputInterface {
        FileOutputStream myStream;

        public FileOutputer(File file) throws IOException {
            this.myStream = new FileOutputStream(file);
        }

        @Override
        public int write(byte[] byArray) throws IOException {
            this.myStream.write(byArray);
            return byArray.length;
        }

        @Override
        public void close() throws IOException {
            this.myStream.close();
        }
    }

    private static class DefaultProgressListener
    implements ProgressListener {
        private DefaultProgressListener() {
        }

        @Override
        public void onProgress(ProgressEvent progressEvent) {
        }
    }

    private static class DefaultPromptUserPassword
    implements PromptUserPassword3 {
        private DefaultPromptUserPassword() {
        }

        @Override
        public int askTrustSSLServer(String string, boolean bl) {
            return 1;
        }

        @Override
        public String askQuestion(String string, String string2, boolean bl) {
            return "";
        }

        @Override
        public boolean askYesNo(String string, String string2, boolean bl) {
            return bl;
        }

        @Override
        public String getPassword() {
            return "rayjandom";
        }

        @Override
        public String getUsername() {
            return "jrandom";
        }

        @Override
        public boolean prompt(String string, String string2) {
            return false;
        }

        @Override
        public boolean prompt(String string, String string2, boolean bl) {
            return false;
        }

        @Override
        public String askQuestion(String string, String string2, boolean bl, boolean bl2) {
            return "";
        }

        @Override
        public boolean userAllowedSave() {
            return false;
        }
    }
}

