require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&__LINUX_KVM_H)) {
    eval 'sub __LINUX_KVM_H () {1;}' unless defined(&__LINUX_KVM_H);
    require 'linux/types.ph';
    require 'linux/ioctl.ph';
    require 'asm/kvm.ph';
    eval 'sub KVM_API_VERSION () {12;}' unless defined(&KVM_API_VERSION);
    eval 'sub KVM_TRC_SHIFT () {16;}' unless defined(&KVM_TRC_SHIFT);
    eval 'sub KVM_TRC_ENTRYEXIT () {(1<<  &KVM_TRC_SHIFT);}' unless defined(&KVM_TRC_ENTRYEXIT);
    eval 'sub KVM_TRC_HANDLER () {(1<< ( &KVM_TRC_SHIFT + 1));}' unless defined(&KVM_TRC_HANDLER);
    eval 'sub KVM_TRC_VMENTRY () {( &KVM_TRC_ENTRYEXIT + 0x1);}' unless defined(&KVM_TRC_VMENTRY);
    eval 'sub KVM_TRC_VMEXIT () {( &KVM_TRC_ENTRYEXIT + 0x2);}' unless defined(&KVM_TRC_VMEXIT);
    eval 'sub KVM_TRC_PAGE_FAULT () {( &KVM_TRC_HANDLER + 0x1);}' unless defined(&KVM_TRC_PAGE_FAULT);
    eval 'sub KVM_TRC_HEAD_SIZE () {12;}' unless defined(&KVM_TRC_HEAD_SIZE);
    eval 'sub KVM_TRC_CYCLE_SIZE () {8;}' unless defined(&KVM_TRC_CYCLE_SIZE);
    eval 'sub KVM_TRC_EXTRA_MAX () {7;}' unless defined(&KVM_TRC_EXTRA_MAX);
    eval 'sub KVM_TRC_INJ_VIRQ () {( &KVM_TRC_HANDLER + 0x2);}' unless defined(&KVM_TRC_INJ_VIRQ);
    eval 'sub KVM_TRC_REDELIVER_EVT () {( &KVM_TRC_HANDLER + 0x3);}' unless defined(&KVM_TRC_REDELIVER_EVT);
    eval 'sub KVM_TRC_PEND_INTR () {( &KVM_TRC_HANDLER + 0x4);}' unless defined(&KVM_TRC_PEND_INTR);
    eval 'sub KVM_TRC_IO_READ () {( &KVM_TRC_HANDLER + 0x5);}' unless defined(&KVM_TRC_IO_READ);
    eval 'sub KVM_TRC_IO_WRITE () {( &KVM_TRC_HANDLER + 0x6);}' unless defined(&KVM_TRC_IO_WRITE);
    eval 'sub KVM_TRC_CR_READ () {( &KVM_TRC_HANDLER + 0x7);}' unless defined(&KVM_TRC_CR_READ);
    eval 'sub KVM_TRC_CR_WRITE () {( &KVM_TRC_HANDLER + 0x8);}' unless defined(&KVM_TRC_CR_WRITE);
    eval 'sub KVM_TRC_DR_READ () {( &KVM_TRC_HANDLER + 0x9);}' unless defined(&KVM_TRC_DR_READ);
    eval 'sub KVM_TRC_DR_WRITE () {( &KVM_TRC_HANDLER + 0xa);}' unless defined(&KVM_TRC_DR_WRITE);
    eval 'sub KVM_TRC_MSR_READ () {( &KVM_TRC_HANDLER + 0xb);}' unless defined(&KVM_TRC_MSR_READ);
    eval 'sub KVM_TRC_MSR_WRITE () {( &KVM_TRC_HANDLER + 0xc);}' unless defined(&KVM_TRC_MSR_WRITE);
    eval 'sub KVM_TRC_CPUID () {( &KVM_TRC_HANDLER + 0xd);}' unless defined(&KVM_TRC_CPUID);
    eval 'sub KVM_TRC_INTR () {( &KVM_TRC_HANDLER + 0xe);}' unless defined(&KVM_TRC_INTR);
    eval 'sub KVM_TRC_NMI () {( &KVM_TRC_HANDLER + 0xf);}' unless defined(&KVM_TRC_NMI);
    eval 'sub KVM_TRC_VMMCALL () {( &KVM_TRC_HANDLER + 0x10);}' unless defined(&KVM_TRC_VMMCALL);
    eval 'sub KVM_TRC_HLT () {( &KVM_TRC_HANDLER + 0x11);}' unless defined(&KVM_TRC_HLT);
    eval 'sub KVM_TRC_CLTS () {( &KVM_TRC_HANDLER + 0x12);}' unless defined(&KVM_TRC_CLTS);
    eval 'sub KVM_TRC_LMSW () {( &KVM_TRC_HANDLER + 0x13);}' unless defined(&KVM_TRC_LMSW);
    eval 'sub KVM_TRC_APIC_ACCESS () {( &KVM_TRC_HANDLER + 0x14);}' unless defined(&KVM_TRC_APIC_ACCESS);
    eval 'sub KVM_TRC_TDP_FAULT () {( &KVM_TRC_HANDLER + 0x15);}' unless defined(&KVM_TRC_TDP_FAULT);
    eval 'sub KVM_TRC_GTLB_WRITE () {( &KVM_TRC_HANDLER + 0x16);}' unless defined(&KVM_TRC_GTLB_WRITE);
    eval 'sub KVM_TRC_STLB_WRITE () {( &KVM_TRC_HANDLER + 0x17);}' unless defined(&KVM_TRC_STLB_WRITE);
    eval 'sub KVM_TRC_STLB_INVAL () {( &KVM_TRC_HANDLER + 0x18);}' unless defined(&KVM_TRC_STLB_INVAL);
    eval 'sub KVM_TRC_PPC_INSTR () {( &KVM_TRC_HANDLER + 0x19);}' unless defined(&KVM_TRC_PPC_INSTR);
    eval 'sub __KVM_DEPRECATED_MAIN_W_0x06 () { &_IOW( &KVMIO, 0x6, \'struct kvm_user_trace_setup\');}' unless defined(&__KVM_DEPRECATED_MAIN_W_0x06);
    eval 'sub __KVM_DEPRECATED_MAIN_0x07 () { &_IO( &KVMIO, 0x7);}' unless defined(&__KVM_DEPRECATED_MAIN_0x07);
    eval 'sub __KVM_DEPRECATED_MAIN_0x08 () { &_IO( &KVMIO, 0x8);}' unless defined(&__KVM_DEPRECATED_MAIN_0x08);
    eval 'sub __KVM_DEPRECATED_VM_R_0x70 () { &_IOR( &KVMIO, 0x70, \'struct kvm_assigned_irq\');}' unless defined(&__KVM_DEPRECATED_VM_R_0x70);
    eval 'sub __KVM_DEPRECATED_VCPU_W_0x87 () { &_IOW( &KVMIO, 0x87, \'struct kvm_debug_guest\');}' unless defined(&__KVM_DEPRECATED_VCPU_W_0x87);
    eval 'sub KVM_MEM_LOG_DIRTY_PAGES () {(1 << 0);}' unless defined(&KVM_MEM_LOG_DIRTY_PAGES);
    eval 'sub KVM_MEM_READONLY () {(1 << 1);}' unless defined(&KVM_MEM_READONLY);
    if(defined(&__KVM_HAVE_PIT)) {
    }
    if(defined(&__KVM_HAVE_IOAPIC)) {
    }
    eval 'sub KVM_PIT_SPEAKER_DUMMY () {1;}' unless defined(&KVM_PIT_SPEAKER_DUMMY);
    eval 'sub KVM_EXIT_UNKNOWN () {0;}' unless defined(&KVM_EXIT_UNKNOWN);
    eval 'sub KVM_EXIT_EXCEPTION () {1;}' unless defined(&KVM_EXIT_EXCEPTION);
    eval 'sub KVM_EXIT_IO () {2;}' unless defined(&KVM_EXIT_IO);
    eval 'sub KVM_EXIT_HYPERCALL () {3;}' unless defined(&KVM_EXIT_HYPERCALL);
    eval 'sub KVM_EXIT_DEBUG () {4;}' unless defined(&KVM_EXIT_DEBUG);
    eval 'sub KVM_EXIT_HLT () {5;}' unless defined(&KVM_EXIT_HLT);
    eval 'sub KVM_EXIT_MMIO () {6;}' unless defined(&KVM_EXIT_MMIO);
    eval 'sub KVM_EXIT_IRQ_WINDOW_OPEN () {7;}' unless defined(&KVM_EXIT_IRQ_WINDOW_OPEN);
    eval 'sub KVM_EXIT_SHUTDOWN () {8;}' unless defined(&KVM_EXIT_SHUTDOWN);
    eval 'sub KVM_EXIT_FAIL_ENTRY () {9;}' unless defined(&KVM_EXIT_FAIL_ENTRY);
    eval 'sub KVM_EXIT_INTR () {10;}' unless defined(&KVM_EXIT_INTR);
    eval 'sub KVM_EXIT_SET_TPR () {11;}' unless defined(&KVM_EXIT_SET_TPR);
    eval 'sub KVM_EXIT_TPR_ACCESS () {12;}' unless defined(&KVM_EXIT_TPR_ACCESS);
    eval 'sub KVM_EXIT_S390_SIEIC () {13;}' unless defined(&KVM_EXIT_S390_SIEIC);
    eval 'sub KVM_EXIT_S390_RESET () {14;}' unless defined(&KVM_EXIT_S390_RESET);
    eval 'sub KVM_EXIT_DCR () {15;}' unless defined(&KVM_EXIT_DCR);
    eval 'sub KVM_EXIT_NMI () {16;}' unless defined(&KVM_EXIT_NMI);
    eval 'sub KVM_EXIT_INTERNAL_ERROR () {17;}' unless defined(&KVM_EXIT_INTERNAL_ERROR);
    eval 'sub KVM_EXIT_OSI () {18;}' unless defined(&KVM_EXIT_OSI);
    eval 'sub KVM_EXIT_PAPR_HCALL () {19;}' unless defined(&KVM_EXIT_PAPR_HCALL);
    eval 'sub KVM_EXIT_S390_UCONTROL () {20;}' unless defined(&KVM_EXIT_S390_UCONTROL);
    eval 'sub KVM_EXIT_WATCHDOG () {21;}' unless defined(&KVM_EXIT_WATCHDOG);
    eval 'sub KVM_EXIT_S390_TSCH () {22;}' unless defined(&KVM_EXIT_S390_TSCH);
    eval 'sub KVM_EXIT_EPR () {23;}' unless defined(&KVM_EXIT_EPR);
    eval 'sub KVM_INTERNAL_ERROR_EMULATION () {1;}' unless defined(&KVM_INTERNAL_ERROR_EMULATION);
    eval 'sub KVM_INTERNAL_ERROR_SIMUL_EX () {2;}' unless defined(&KVM_INTERNAL_ERROR_SIMUL_EX);
    eval 'sub KVM_INTERNAL_ERROR_DELIVERY_EV () {3;}' unless defined(&KVM_INTERNAL_ERROR_DELIVERY_EV);
    if(defined(&__KVM_S390)) {
    }
    eval 'sub KVM_EXIT_IO_IN () {0;}' unless defined(&KVM_EXIT_IO_IN);
    eval 'sub KVM_EXIT_IO_OUT () {1;}' unless defined(&KVM_EXIT_IO_OUT);
    eval 'sub KVM_S390_RESET_POR () {1;}' unless defined(&KVM_S390_RESET_POR);
    eval 'sub KVM_S390_RESET_CLEAR () {2;}' unless defined(&KVM_S390_RESET_CLEAR);
    eval 'sub KVM_S390_RESET_SUBSYSTEM () {4;}' unless defined(&KVM_S390_RESET_SUBSYSTEM);
    eval 'sub KVM_S390_RESET_CPU_INIT () {8;}' unless defined(&KVM_S390_RESET_CPU_INIT);
    eval 'sub KVM_S390_RESET_IPL () {16;}' unless defined(&KVM_S390_RESET_IPL);
    eval 'sub KVM_COALESCED_MMIO_MAX () {(( &PAGE_SIZE - $sizeof{\'struct kvm_coalesced_mmio_ring\'}) / $sizeof{\'struct kvm_coalesced_mmio\'});}' unless defined(&KVM_COALESCED_MMIO_MAX);
    eval 'sub KVM_MP_STATE_RUNNABLE () {0;}' unless defined(&KVM_MP_STATE_RUNNABLE);
    eval 'sub KVM_MP_STATE_UNINITIALIZED () {1;}' unless defined(&KVM_MP_STATE_UNINITIALIZED);
    eval 'sub KVM_MP_STATE_INIT_RECEIVED () {2;}' unless defined(&KVM_MP_STATE_INIT_RECEIVED);
    eval 'sub KVM_MP_STATE_HALTED () {3;}' unless defined(&KVM_MP_STATE_HALTED);
    eval 'sub KVM_MP_STATE_SIPI_RECEIVED () {4;}' unless defined(&KVM_MP_STATE_SIPI_RECEIVED);
    eval 'sub KVM_S390_SIGP_STOP () {0xfffe0000;}' unless defined(&KVM_S390_SIGP_STOP);
    eval 'sub KVM_S390_PROGRAM_INT () {0xfffe0001;}' unless defined(&KVM_S390_PROGRAM_INT);
    eval 'sub KVM_S390_SIGP_SET_PREFIX () {0xfffe0002;}' unless defined(&KVM_S390_SIGP_SET_PREFIX);
    eval 'sub KVM_S390_RESTART () {0xfffe0003;}' unless defined(&KVM_S390_RESTART);
    eval 'sub KVM_S390_MCHK () {0xfffe1000;}' unless defined(&KVM_S390_MCHK);
    eval 'sub KVM_S390_INT_VIRTIO () {0xffff2603;}' unless defined(&KVM_S390_INT_VIRTIO);
    eval 'sub KVM_S390_INT_SERVICE () {0xffff2401;}' unless defined(&KVM_S390_INT_SERVICE);
    eval 'sub KVM_S390_INT_EMERGENCY () {0xffff1201;}' unless defined(&KVM_S390_INT_EMERGENCY);
    eval 'sub KVM_S390_INT_EXTERNAL_CALL () {0xffff1202;}' unless defined(&KVM_S390_INT_EXTERNAL_CALL);
    eval 'sub KVM_S390_INT_IO {
        my($ai,$cssid,$ssid,$schid) = @_;
	    eval q(((($schid)) | (($ssid) << 16) | (($cssid) << 18) | (($ai) << 26)));
    }' unless defined(&KVM_S390_INT_IO);
    eval 'sub KVM_S390_INT_IO_MIN () {0x;}' unless defined(&KVM_S390_INT_IO_MIN);
    eval 'sub KVM_S390_INT_IO_MAX () {0xfffdffff;}' unless defined(&KVM_S390_INT_IO_MAX);
    eval 'sub KVM_GUESTDBG_ENABLE () {0x1;}' unless defined(&KVM_GUESTDBG_ENABLE);
    eval 'sub KVM_GUESTDBG_SINGLESTEP () {0x2;}' unless defined(&KVM_GUESTDBG_SINGLESTEP);
    eval("sub kvm_ioeventfd_flag_nr_datamatch () { 0; }") unless defined(&kvm_ioeventfd_flag_nr_datamatch);
    eval("sub kvm_ioeventfd_flag_nr_pio () { 1; }") unless defined(&kvm_ioeventfd_flag_nr_pio);
    eval("sub kvm_ioeventfd_flag_nr_deassign () { 2; }") unless defined(&kvm_ioeventfd_flag_nr_deassign);
    eval("sub kvm_ioeventfd_flag_nr_virtio_ccw_notify () { 3; }") unless defined(&kvm_ioeventfd_flag_nr_virtio_ccw_notify);
    eval("sub kvm_ioeventfd_flag_nr_max () { 4; }") unless defined(&kvm_ioeventfd_flag_nr_max);
    eval 'sub KVM_IOEVENTFD_FLAG_DATAMATCH () {(1<<  &kvm_ioeventfd_flag_nr_datamatch);}' unless defined(&KVM_IOEVENTFD_FLAG_DATAMATCH);
    eval 'sub KVM_IOEVENTFD_FLAG_PIO () {(1<<  &kvm_ioeventfd_flag_nr_pio);}' unless defined(&KVM_IOEVENTFD_FLAG_PIO);
    eval 'sub KVM_IOEVENTFD_FLAG_DEASSIGN () {(1<<  &kvm_ioeventfd_flag_nr_deassign);}' unless defined(&KVM_IOEVENTFD_FLAG_DEASSIGN);
    eval 'sub KVM_IOEVENTFD_FLAG_VIRTIO_CCW_NOTIFY () {(1<<  &kvm_ioeventfd_flag_nr_virtio_ccw_notify);}' unless defined(&KVM_IOEVENTFD_FLAG_VIRTIO_CCW_NOTIFY);
    eval 'sub KVM_IOEVENTFD_VALID_FLAG_MASK () {((1<<  &kvm_ioeventfd_flag_nr_max) - 1);}' unless defined(&KVM_IOEVENTFD_VALID_FLAG_MASK);
    eval 'sub KVM_PPC_PAGE_SIZES_MAX_SZ () {8;}' unless defined(&KVM_PPC_PAGE_SIZES_MAX_SZ);
    eval 'sub KVM_PPC_PAGE_SIZES_REAL () {0x1;}' unless defined(&KVM_PPC_PAGE_SIZES_REAL);
    eval 'sub KVM_PPC_1T_SEGMENTS () {0x2;}' unless defined(&KVM_PPC_1T_SEGMENTS);
    eval 'sub KVM_PPC_PVINFO_FLAGS_EV_IDLE () {(1<<0);}' unless defined(&KVM_PPC_PVINFO_FLAGS_EV_IDLE);
    eval 'sub KVMIO () {0xae;}' unless defined(&KVMIO);
    eval 'sub KVM_VM_S390_UCONTROL () {1;}' unless defined(&KVM_VM_S390_UCONTROL);
    eval 'sub KVM_S390_SIE_PAGE_OFFSET () {1;}' unless defined(&KVM_S390_SIE_PAGE_OFFSET);
    eval 'sub KVM_GET_API_VERSION () { &_IO( &KVMIO, 0x);}' unless defined(&KVM_GET_API_VERSION);
    eval 'sub KVM_CREATE_VM () { &_IO( &KVMIO, 0x1);}' unless defined(&KVM_CREATE_VM);
    eval 'sub KVM_GET_MSR_INDEX_LIST () { &_IOWR( &KVMIO, 0x2, \'struct kvm_msr_list\');}' unless defined(&KVM_GET_MSR_INDEX_LIST);
    eval 'sub KVM_S390_ENABLE_SIE () { &_IO( &KVMIO, 0x6);}' unless defined(&KVM_S390_ENABLE_SIE);
    eval 'sub KVM_CHECK_EXTENSION () { &_IO( &KVMIO, 0x3);}' unless defined(&KVM_CHECK_EXTENSION);
    eval 'sub KVM_GET_VCPU_MMAP_SIZE () { &_IO( &KVMIO, 0x4);}' unless defined(&KVM_GET_VCPU_MMAP_SIZE);
    eval 'sub KVM_GET_SUPPORTED_CPUID () { &_IOWR( &KVMIO, 0x5, \'struct kvm_cpuid2\');}' unless defined(&KVM_GET_SUPPORTED_CPUID);
    eval 'sub KVM_TRACE_ENABLE () { &__KVM_DEPRECATED_MAIN_W_0x06;}' unless defined(&KVM_TRACE_ENABLE);
    eval 'sub KVM_TRACE_PAUSE () { &__KVM_DEPRECATED_MAIN_0x07;}' unless defined(&KVM_TRACE_PAUSE);
    eval 'sub KVM_TRACE_DISABLE () { &__KVM_DEPRECATED_MAIN_0x08;}' unless defined(&KVM_TRACE_DISABLE);
    eval 'sub KVM_CAP_IRQCHIP () {0;}' unless defined(&KVM_CAP_IRQCHIP);
    eval 'sub KVM_CAP_HLT () {1;}' unless defined(&KVM_CAP_HLT);
    eval 'sub KVM_CAP_MMU_SHADOW_CACHE_CONTROL () {2;}' unless defined(&KVM_CAP_MMU_SHADOW_CACHE_CONTROL);
    eval 'sub KVM_CAP_USER_MEMORY () {3;}' unless defined(&KVM_CAP_USER_MEMORY);
    eval 'sub KVM_CAP_SET_TSS_ADDR () {4;}' unless defined(&KVM_CAP_SET_TSS_ADDR);
    eval 'sub KVM_CAP_VAPIC () {6;}' unless defined(&KVM_CAP_VAPIC);
    eval 'sub KVM_CAP_EXT_CPUID () {7;}' unless defined(&KVM_CAP_EXT_CPUID);
    eval 'sub KVM_CAP_CLOCKSOURCE () {8;}' unless defined(&KVM_CAP_CLOCKSOURCE);
    eval 'sub KVM_CAP_NR_VCPUS () {9;}' unless defined(&KVM_CAP_NR_VCPUS);
    eval 'sub KVM_CAP_NR_MEMSLOTS () {10;}' unless defined(&KVM_CAP_NR_MEMSLOTS);
    eval 'sub KVM_CAP_PIT () {11;}' unless defined(&KVM_CAP_PIT);
    eval 'sub KVM_CAP_NOP_IO_DELAY () {12;}' unless defined(&KVM_CAP_NOP_IO_DELAY);
    eval 'sub KVM_CAP_PV_MMU () {13;}' unless defined(&KVM_CAP_PV_MMU);
    eval 'sub KVM_CAP_MP_STATE () {14;}' unless defined(&KVM_CAP_MP_STATE);
    eval 'sub KVM_CAP_COALESCED_MMIO () {15;}' unless defined(&KVM_CAP_COALESCED_MMIO);
    eval 'sub KVM_CAP_SYNC_MMU () {16;}' unless defined(&KVM_CAP_SYNC_MMU);
    eval 'sub KVM_CAP_DEVICE_ASSIGNMENT () {17;}' unless defined(&KVM_CAP_DEVICE_ASSIGNMENT);
    eval 'sub KVM_CAP_IOMMU () {18;}' unless defined(&KVM_CAP_IOMMU);
    if(defined(&__KVM_HAVE_MSI)) {
	eval 'sub KVM_CAP_DEVICE_MSI () {20;}' unless defined(&KVM_CAP_DEVICE_MSI);
    }
    eval 'sub KVM_CAP_DESTROY_MEMORY_REGION_WORKS () {21;}' unless defined(&KVM_CAP_DESTROY_MEMORY_REGION_WORKS);
    if(defined(&__KVM_HAVE_USER_NMI)) {
	eval 'sub KVM_CAP_USER_NMI () {22;}' unless defined(&KVM_CAP_USER_NMI);
    }
    if(defined(&__KVM_HAVE_GUEST_DEBUG)) {
	eval 'sub KVM_CAP_SET_GUEST_DEBUG () {23;}' unless defined(&KVM_CAP_SET_GUEST_DEBUG);
    }
    if(defined(&__KVM_HAVE_PIT)) {
	eval 'sub KVM_CAP_REINJECT_CONTROL () {24;}' unless defined(&KVM_CAP_REINJECT_CONTROL);
    }
    eval 'sub KVM_CAP_IRQ_ROUTING () {25;}' unless defined(&KVM_CAP_IRQ_ROUTING);
    eval 'sub KVM_CAP_IRQ_INJECT_STATUS () {26;}' unless defined(&KVM_CAP_IRQ_INJECT_STATUS);
    eval 'sub KVM_CAP_DEVICE_DEASSIGNMENT () {27;}' unless defined(&KVM_CAP_DEVICE_DEASSIGNMENT);
    if(defined(&__KVM_HAVE_MSIX)) {
	eval 'sub KVM_CAP_DEVICE_MSIX () {28;}' unless defined(&KVM_CAP_DEVICE_MSIX);
    }
    eval 'sub KVM_CAP_ASSIGN_DEV_IRQ () {29;}' unless defined(&KVM_CAP_ASSIGN_DEV_IRQ);
    eval 'sub KVM_CAP_JOIN_MEMORY_REGIONS_WORKS () {30;}' unless defined(&KVM_CAP_JOIN_MEMORY_REGIONS_WORKS);
    if(defined(&__KVM_HAVE_MCE)) {
	eval 'sub KVM_CAP_MCE () {31;}' unless defined(&KVM_CAP_MCE);
    }
    eval 'sub KVM_CAP_IRQFD () {32;}' unless defined(&KVM_CAP_IRQFD);
    if(defined(&__KVM_HAVE_PIT)) {
	eval 'sub KVM_CAP_PIT2 () {33;}' unless defined(&KVM_CAP_PIT2);
    }
    eval 'sub KVM_CAP_SET_BOOT_CPU_ID () {34;}' unless defined(&KVM_CAP_SET_BOOT_CPU_ID);
    if(defined(&__KVM_HAVE_PIT_STATE2)) {
	eval 'sub KVM_CAP_PIT_STATE2 () {35;}' unless defined(&KVM_CAP_PIT_STATE2);
    }
    eval 'sub KVM_CAP_IOEVENTFD () {36;}' unless defined(&KVM_CAP_IOEVENTFD);
    eval 'sub KVM_CAP_SET_IDENTITY_MAP_ADDR () {37;}' unless defined(&KVM_CAP_SET_IDENTITY_MAP_ADDR);
    if(defined(&__KVM_HAVE_XEN_HVM)) {
	eval 'sub KVM_CAP_XEN_HVM () {38;}' unless defined(&KVM_CAP_XEN_HVM);
    }
    eval 'sub KVM_CAP_ADJUST_CLOCK () {39;}' unless defined(&KVM_CAP_ADJUST_CLOCK);
    eval 'sub KVM_CAP_INTERNAL_ERROR_DATA () {40;}' unless defined(&KVM_CAP_INTERNAL_ERROR_DATA);
    if(defined(&__KVM_HAVE_VCPU_EVENTS)) {
	eval 'sub KVM_CAP_VCPU_EVENTS () {41;}' unless defined(&KVM_CAP_VCPU_EVENTS);
    }
    eval 'sub KVM_CAP_S390_PSW () {42;}' unless defined(&KVM_CAP_S390_PSW);
    eval 'sub KVM_CAP_PPC_SEGSTATE () {43;}' unless defined(&KVM_CAP_PPC_SEGSTATE);
    eval 'sub KVM_CAP_HYPERV () {44;}' unless defined(&KVM_CAP_HYPERV);
    eval 'sub KVM_CAP_HYPERV_VAPIC () {45;}' unless defined(&KVM_CAP_HYPERV_VAPIC);
    eval 'sub KVM_CAP_HYPERV_SPIN () {46;}' unless defined(&KVM_CAP_HYPERV_SPIN);
    eval 'sub KVM_CAP_PCI_SEGMENT () {47;}' unless defined(&KVM_CAP_PCI_SEGMENT);
    eval 'sub KVM_CAP_PPC_PAIRED_SINGLES () {48;}' unless defined(&KVM_CAP_PPC_PAIRED_SINGLES);
    eval 'sub KVM_CAP_INTR_SHADOW () {49;}' unless defined(&KVM_CAP_INTR_SHADOW);
    if(defined(&__KVM_HAVE_DEBUGREGS)) {
	eval 'sub KVM_CAP_DEBUGREGS () {50;}' unless defined(&KVM_CAP_DEBUGREGS);
    }
    eval 'sub KVM_CAP_X86_ROBUST_SINGLESTEP () {51;}' unless defined(&KVM_CAP_X86_ROBUST_SINGLESTEP);
    eval 'sub KVM_CAP_PPC_OSI () {52;}' unless defined(&KVM_CAP_PPC_OSI);
    eval 'sub KVM_CAP_PPC_UNSET_IRQ () {53;}' unless defined(&KVM_CAP_PPC_UNSET_IRQ);
    eval 'sub KVM_CAP_ENABLE_CAP () {54;}' unless defined(&KVM_CAP_ENABLE_CAP);
    if(defined(&__KVM_HAVE_XSAVE)) {
	eval 'sub KVM_CAP_XSAVE () {55;}' unless defined(&KVM_CAP_XSAVE);
    }
    if(defined(&__KVM_HAVE_XCRS)) {
	eval 'sub KVM_CAP_XCRS () {56;}' unless defined(&KVM_CAP_XCRS);
    }
    eval 'sub KVM_CAP_PPC_GET_PVINFO () {57;}' unless defined(&KVM_CAP_PPC_GET_PVINFO);
    eval 'sub KVM_CAP_PPC_IRQ_LEVEL () {58;}' unless defined(&KVM_CAP_PPC_IRQ_LEVEL);
    eval 'sub KVM_CAP_ASYNC_PF () {59;}' unless defined(&KVM_CAP_ASYNC_PF);
    eval 'sub KVM_CAP_TSC_CONTROL () {60;}' unless defined(&KVM_CAP_TSC_CONTROL);
    eval 'sub KVM_CAP_GET_TSC_KHZ () {61;}' unless defined(&KVM_CAP_GET_TSC_KHZ);
    eval 'sub KVM_CAP_PPC_BOOKE_SREGS () {62;}' unless defined(&KVM_CAP_PPC_BOOKE_SREGS);
    eval 'sub KVM_CAP_SPAPR_TCE () {63;}' unless defined(&KVM_CAP_SPAPR_TCE);
    eval 'sub KVM_CAP_PPC_SMT () {64;}' unless defined(&KVM_CAP_PPC_SMT);
    eval 'sub KVM_CAP_PPC_RMA () {65;}' unless defined(&KVM_CAP_PPC_RMA);
    eval 'sub KVM_CAP_MAX_VCPUS () {66;}' unless defined(&KVM_CAP_MAX_VCPUS);
    eval 'sub KVM_CAP_PPC_HIOR () {67;}' unless defined(&KVM_CAP_PPC_HIOR);
    eval 'sub KVM_CAP_PPC_PAPR () {68;}' unless defined(&KVM_CAP_PPC_PAPR);
    eval 'sub KVM_CAP_SW_TLB () {69;}' unless defined(&KVM_CAP_SW_TLB);
    eval 'sub KVM_CAP_ONE_REG () {70;}' unless defined(&KVM_CAP_ONE_REG);
    eval 'sub KVM_CAP_S390_GMAP () {71;}' unless defined(&KVM_CAP_S390_GMAP);
    eval 'sub KVM_CAP_TSC_DEADLINE_TIMER () {72;}' unless defined(&KVM_CAP_TSC_DEADLINE_TIMER);
    eval 'sub KVM_CAP_S390_UCONTROL () {73;}' unless defined(&KVM_CAP_S390_UCONTROL);
    eval 'sub KVM_CAP_SYNC_REGS () {74;}' unless defined(&KVM_CAP_SYNC_REGS);
    eval 'sub KVM_CAP_PCI_2_3 () {75;}' unless defined(&KVM_CAP_PCI_2_3);
    eval 'sub KVM_CAP_KVMCLOCK_CTRL () {76;}' unless defined(&KVM_CAP_KVMCLOCK_CTRL);
    eval 'sub KVM_CAP_SIGNAL_MSI () {77;}' unless defined(&KVM_CAP_SIGNAL_MSI);
    eval 'sub KVM_CAP_PPC_GET_SMMU_INFO () {78;}' unless defined(&KVM_CAP_PPC_GET_SMMU_INFO);
    eval 'sub KVM_CAP_S390_COW () {79;}' unless defined(&KVM_CAP_S390_COW);
    eval 'sub KVM_CAP_PPC_ALLOC_HTAB () {80;}' unless defined(&KVM_CAP_PPC_ALLOC_HTAB);
    if(defined(&__KVM_HAVE_READONLY_MEM)) {
	eval 'sub KVM_CAP_READONLY_MEM () {81;}' unless defined(&KVM_CAP_READONLY_MEM);
    }
    eval 'sub KVM_CAP_IRQFD_RESAMPLE () {82;}' unless defined(&KVM_CAP_IRQFD_RESAMPLE);
    eval 'sub KVM_CAP_PPC_BOOKE_WATCHDOG () {83;}' unless defined(&KVM_CAP_PPC_BOOKE_WATCHDOG);
    eval 'sub KVM_CAP_PPC_HTAB_FD () {84;}' unless defined(&KVM_CAP_PPC_HTAB_FD);
    eval 'sub KVM_CAP_S390_CSS_SUPPORT () {85;}' unless defined(&KVM_CAP_S390_CSS_SUPPORT);
    eval 'sub KVM_CAP_PPC_EPR () {86;}' unless defined(&KVM_CAP_PPC_EPR);
    eval 'sub KVM_CAP_ARM_PSCI () {87;}' unless defined(&KVM_CAP_ARM_PSCI);
    eval 'sub KVM_CAP_ARM_SET_DEVICE_ADDR () {88;}' unless defined(&KVM_CAP_ARM_SET_DEVICE_ADDR);
    eval 'sub KVM_CAP_DEVICE_CTRL () {89;}' unless defined(&KVM_CAP_DEVICE_CTRL);
    eval 'sub KVM_CAP_IRQ_MPIC () {90;}' unless defined(&KVM_CAP_IRQ_MPIC);
    eval 'sub KVM_CAP_PPC_RTAS () {91;}' unless defined(&KVM_CAP_PPC_RTAS);
    eval 'sub KVM_CAP_IRQ_XICS () {92;}' unless defined(&KVM_CAP_IRQ_XICS);
    eval 'sub KVM_CAP_ARM_EL1_32BIT () {93;}' unless defined(&KVM_CAP_ARM_EL1_32BIT);
    eval 'sub KVM_CAP_SPAPR_MULTITCE () {94;}' unless defined(&KVM_CAP_SPAPR_MULTITCE);
    if(defined(&KVM_CAP_IRQ_ROUTING)) {
	eval 'sub KVM_IRQ_ROUTING_IRQCHIP () {1;}' unless defined(&KVM_IRQ_ROUTING_IRQCHIP);
	eval 'sub KVM_IRQ_ROUTING_MSI () {2;}' unless defined(&KVM_IRQ_ROUTING_MSI);
    }
    if(defined(&KVM_CAP_MCE)) {
    }
    if(defined(&KVM_CAP_XEN_HVM)) {
    }
    eval 'sub KVM_IRQFD_FLAG_DEASSIGN () {(1<< 0);}' unless defined(&KVM_IRQFD_FLAG_DEASSIGN);
    eval 'sub KVM_IRQFD_FLAG_RESAMPLE () {(1<< 1);}' unless defined(&KVM_IRQFD_FLAG_RESAMPLE);
    eval 'sub KVM_MMU_FSL_BOOKE_NOHV () {0;}' unless defined(&KVM_MMU_FSL_BOOKE_NOHV);
    eval 'sub KVM_MMU_FSL_BOOKE_HV () {1;}' unless defined(&KVM_MMU_FSL_BOOKE_HV);
    eval 'sub KVM_REG_ARCH_MASK () {0xff00000000000000;}' unless defined(&KVM_REG_ARCH_MASK);
    eval 'sub KVM_REG_GENERIC () {0x;}' unless defined(&KVM_REG_GENERIC);
    eval 'sub KVM_REG_PPC () {0x1000000000000000;}' unless defined(&KVM_REG_PPC);
    eval 'sub KVM_REG_X86 () {0x2000000000000000;}' unless defined(&KVM_REG_X86);
    eval 'sub KVM_REG_IA64 () {0x3000000000000000;}' unless defined(&KVM_REG_IA64);
    eval 'sub KVM_REG_ARM () {0x4000000000000000;}' unless defined(&KVM_REG_ARM);
    eval 'sub KVM_REG_S390 () {0x5000000000000000;}' unless defined(&KVM_REG_S390);
    eval 'sub KVM_REG_ARM64 () {0x6000000000000000;}' unless defined(&KVM_REG_ARM64);
    eval 'sub KVM_REG_MIPS () {0x7000000000000000;}' unless defined(&KVM_REG_MIPS);
    eval 'sub KVM_REG_SIZE_SHIFT () {52;}' unless defined(&KVM_REG_SIZE_SHIFT);
    eval 'sub KVM_REG_SIZE_MASK () {0xf0000000000000;}' unless defined(&KVM_REG_SIZE_MASK);
    eval 'sub KVM_REG_SIZE_U8 () {0x;}' unless defined(&KVM_REG_SIZE_U8);
    eval 'sub KVM_REG_SIZE_U16 () {0x10000000000000;}' unless defined(&KVM_REG_SIZE_U16);
    eval 'sub KVM_REG_SIZE_U32 () {0x20000000000000;}' unless defined(&KVM_REG_SIZE_U32);
    eval 'sub KVM_REG_SIZE_U64 () {0x30000000000000;}' unless defined(&KVM_REG_SIZE_U64);
    eval 'sub KVM_REG_SIZE_U128 () {0x40000000000000;}' unless defined(&KVM_REG_SIZE_U128);
    eval 'sub KVM_REG_SIZE_U256 () {0x50000000000000;}' unless defined(&KVM_REG_SIZE_U256);
    eval 'sub KVM_REG_SIZE_U512 () {0x60000000000000;}' unless defined(&KVM_REG_SIZE_U512);
    eval 'sub KVM_REG_SIZE_U1024 () {0x70000000000000;}' unless defined(&KVM_REG_SIZE_U1024);
    eval 'sub KVM_CREATE_DEVICE_TEST () {1;}' unless defined(&KVM_CREATE_DEVICE_TEST);
    eval 'sub KVM_DEV_TYPE_FSL_MPIC_20 () {1;}' unless defined(&KVM_DEV_TYPE_FSL_MPIC_20);
    eval 'sub KVM_DEV_TYPE_FSL_MPIC_42 () {2;}' unless defined(&KVM_DEV_TYPE_FSL_MPIC_42);
    eval 'sub KVM_DEV_TYPE_XICS () {3;}' unless defined(&KVM_DEV_TYPE_XICS);
    eval 'sub KVM_SET_MEMORY_REGION () { &_IOW( &KVMIO, 0x40, \'struct kvm_memory_region\');}' unless defined(&KVM_SET_MEMORY_REGION);
    eval 'sub KVM_CREATE_VCPU () { &_IO( &KVMIO, 0x41);}' unless defined(&KVM_CREATE_VCPU);
    eval 'sub KVM_GET_DIRTY_LOG () { &_IOW( &KVMIO, 0x42, \'struct kvm_dirty_log\');}' unless defined(&KVM_GET_DIRTY_LOG);
    eval 'sub KVM_SET_MEMORY_ALIAS () { &_IOW( &KVMIO, 0x43, \'struct kvm_memory_alias\');}' unless defined(&KVM_SET_MEMORY_ALIAS);
    eval 'sub KVM_SET_NR_MMU_PAGES () { &_IO( &KVMIO, 0x44);}' unless defined(&KVM_SET_NR_MMU_PAGES);
    eval 'sub KVM_GET_NR_MMU_PAGES () { &_IO( &KVMIO, 0x45);}' unless defined(&KVM_GET_NR_MMU_PAGES);
    eval 'sub KVM_SET_USER_MEMORY_REGION () { &_IOW( &KVMIO, 0x46, \'struct kvm_userspace_memory_region\');}' unless defined(&KVM_SET_USER_MEMORY_REGION);
    eval 'sub KVM_SET_TSS_ADDR () { &_IO( &KVMIO, 0x47);}' unless defined(&KVM_SET_TSS_ADDR);
    eval 'sub KVM_SET_IDENTITY_MAP_ADDR () { &_IOW( &KVMIO, 0x48,  &__u64);}' unless defined(&KVM_SET_IDENTITY_MAP_ADDR);
    eval 'sub KVM_S390_UCAS_MAP () { &_IOW( &KVMIO, 0x50, \'struct kvm_s390_ucas_mapping\');}' unless defined(&KVM_S390_UCAS_MAP);
    eval 'sub KVM_S390_UCAS_UNMAP () { &_IOW( &KVMIO, 0x51, \'struct kvm_s390_ucas_mapping\');}' unless defined(&KVM_S390_UCAS_UNMAP);
    eval 'sub KVM_S390_VCPU_FAULT () { &_IOW( &KVMIO, 0x52, \'unsigned long\');}' unless defined(&KVM_S390_VCPU_FAULT);
    eval 'sub KVM_CREATE_IRQCHIP () { &_IO( &KVMIO, 0x60);}' unless defined(&KVM_CREATE_IRQCHIP);
    eval 'sub KVM_IRQ_LINE () { &_IOW( &KVMIO, 0x61, \'struct kvm_irq_level\');}' unless defined(&KVM_IRQ_LINE);
    eval 'sub KVM_GET_IRQCHIP () { &_IOWR( &KVMIO, 0x62, \'struct kvm_irqchip\');}' unless defined(&KVM_GET_IRQCHIP);
    eval 'sub KVM_SET_IRQCHIP () { &_IOR( &KVMIO, 0x63, \'struct kvm_irqchip\');}' unless defined(&KVM_SET_IRQCHIP);
    eval 'sub KVM_CREATE_PIT () { &_IO( &KVMIO, 0x64);}' unless defined(&KVM_CREATE_PIT);
    eval 'sub KVM_GET_PIT () { &_IOWR( &KVMIO, 0x65, \'struct kvm_pit_state\');}' unless defined(&KVM_GET_PIT);
    eval 'sub KVM_SET_PIT () { &_IOR( &KVMIO, 0x66, \'struct kvm_pit_state\');}' unless defined(&KVM_SET_PIT);
    eval 'sub KVM_IRQ_LINE_STATUS () { &_IOWR( &KVMIO, 0x67, \'struct kvm_irq_level\');}' unless defined(&KVM_IRQ_LINE_STATUS);
    eval 'sub KVM_REGISTER_COALESCED_MMIO () { &_IOW( &KVMIO, 0x67, \'struct kvm_coalesced_mmio_zone\');}' unless defined(&KVM_REGISTER_COALESCED_MMIO);
    eval 'sub KVM_UNREGISTER_COALESCED_MMIO () { &_IOW( &KVMIO, 0x68, \'struct kvm_coalesced_mmio_zone\');}' unless defined(&KVM_UNREGISTER_COALESCED_MMIO);
    eval 'sub KVM_ASSIGN_PCI_DEVICE () { &_IOR( &KVMIO, 0x69, \'struct kvm_assigned_pci_dev\');}' unless defined(&KVM_ASSIGN_PCI_DEVICE);
    eval 'sub KVM_SET_GSI_ROUTING () { &_IOW( &KVMIO, 0x6a, \'struct kvm_irq_routing\');}' unless defined(&KVM_SET_GSI_ROUTING);
    eval 'sub KVM_ASSIGN_IRQ () { &__KVM_DEPRECATED_VM_R_0x70;}' unless defined(&KVM_ASSIGN_IRQ);
    eval 'sub KVM_ASSIGN_DEV_IRQ () { &_IOW( &KVMIO, 0x70, \'struct kvm_assigned_irq\');}' unless defined(&KVM_ASSIGN_DEV_IRQ);
    eval 'sub KVM_REINJECT_CONTROL () { &_IO( &KVMIO, 0x71);}' unless defined(&KVM_REINJECT_CONTROL);
    eval 'sub KVM_DEASSIGN_PCI_DEVICE () { &_IOW( &KVMIO, 0x72, \'struct kvm_assigned_pci_dev\');}' unless defined(&KVM_DEASSIGN_PCI_DEVICE);
    eval 'sub KVM_ASSIGN_SET_MSIX_NR () { &_IOW( &KVMIO, 0x73, \'struct kvm_assigned_msix_nr\');}' unless defined(&KVM_ASSIGN_SET_MSIX_NR);
    eval 'sub KVM_ASSIGN_SET_MSIX_ENTRY () { &_IOW( &KVMIO, 0x74, \'struct kvm_assigned_msix_entry\');}' unless defined(&KVM_ASSIGN_SET_MSIX_ENTRY);
    eval 'sub KVM_DEASSIGN_DEV_IRQ () { &_IOW( &KVMIO, 0x75, \'struct kvm_assigned_irq\');}' unless defined(&KVM_DEASSIGN_DEV_IRQ);
    eval 'sub KVM_IRQFD () { &_IOW( &KVMIO, 0x76, \'struct kvm_irqfd\');}' unless defined(&KVM_IRQFD);
    eval 'sub KVM_CREATE_PIT2 () { &_IOW( &KVMIO, 0x77, \'struct kvm_pit_config\');}' unless defined(&KVM_CREATE_PIT2);
    eval 'sub KVM_SET_BOOT_CPU_ID () { &_IO( &KVMIO, 0x78);}' unless defined(&KVM_SET_BOOT_CPU_ID);
    eval 'sub KVM_IOEVENTFD () { &_IOW( &KVMIO, 0x79, \'struct kvm_ioeventfd\');}' unless defined(&KVM_IOEVENTFD);
    eval 'sub KVM_XEN_HVM_CONFIG () { &_IOW( &KVMIO, 0x7a, \'struct kvm_xen_hvm_config\');}' unless defined(&KVM_XEN_HVM_CONFIG);
    eval 'sub KVM_SET_CLOCK () { &_IOW( &KVMIO, 0x7b, \'struct kvm_clock_data\');}' unless defined(&KVM_SET_CLOCK);
    eval 'sub KVM_GET_CLOCK () { &_IOR( &KVMIO, 0x7c, \'struct kvm_clock_data\');}' unless defined(&KVM_GET_CLOCK);
    eval 'sub KVM_GET_PIT2 () { &_IOR( &KVMIO, 0x9f, \'struct kvm_pit_state2\');}' unless defined(&KVM_GET_PIT2);
    eval 'sub KVM_SET_PIT2 () { &_IOW( &KVMIO, 0xa0, \'struct kvm_pit_state2\');}' unless defined(&KVM_SET_PIT2);
    eval 'sub KVM_PPC_GET_PVINFO () { &_IOW( &KVMIO, 0xa1, \'struct kvm_ppc_pvinfo\');}' unless defined(&KVM_PPC_GET_PVINFO);
    eval 'sub KVM_SET_TSC_KHZ () { &_IO( &KVMIO, 0xa2);}' unless defined(&KVM_SET_TSC_KHZ);
    eval 'sub KVM_GET_TSC_KHZ () { &_IO( &KVMIO, 0xa3);}' unless defined(&KVM_GET_TSC_KHZ);
    eval 'sub KVM_ASSIGN_SET_INTX_MASK () { &_IOW( &KVMIO, 0xa4, \'struct kvm_assigned_pci_dev\');}' unless defined(&KVM_ASSIGN_SET_INTX_MASK);
    eval 'sub KVM_SIGNAL_MSI () { &_IOW( &KVMIO, 0xa5, \'struct kvm_msi\');}' unless defined(&KVM_SIGNAL_MSI);
    eval 'sub KVM_PPC_GET_SMMU_INFO () { &_IOR( &KVMIO, 0xa6, \'struct kvm_ppc_smmu_info\');}' unless defined(&KVM_PPC_GET_SMMU_INFO);
    eval 'sub KVM_PPC_ALLOCATE_HTAB () { &_IOWR( &KVMIO, 0xa7,  &__u32);}' unless defined(&KVM_PPC_ALLOCATE_HTAB);
    eval 'sub KVM_CREATE_SPAPR_TCE () { &_IOW( &KVMIO, 0xa8, \'struct kvm_create_spapr_tce\');}' unless defined(&KVM_CREATE_SPAPR_TCE);
    eval 'sub KVM_ALLOCATE_RMA () { &_IOR( &KVMIO, 0xa9, \'struct kvm_allocate_rma\');}' unless defined(&KVM_ALLOCATE_RMA);
    eval 'sub KVM_PPC_GET_HTAB_FD () { &_IOW( &KVMIO, 0xaa, \'struct kvm_get_htab_fd\');}' unless defined(&KVM_PPC_GET_HTAB_FD);
    eval 'sub KVM_ARM_SET_DEVICE_ADDR () { &_IOW( &KVMIO, 0xab, \'struct kvm_arm_device_addr\');}' unless defined(&KVM_ARM_SET_DEVICE_ADDR);
    eval 'sub KVM_PPC_RTAS_DEFINE_TOKEN () { &_IOW( &KVMIO, 0xac, \'struct kvm_rtas_token_args\');}' unless defined(&KVM_PPC_RTAS_DEFINE_TOKEN);
    eval 'sub KVM_CREATE_DEVICE () { &_IOWR( &KVMIO, 0xe0, \'struct kvm_create_device\');}' unless defined(&KVM_CREATE_DEVICE);
    eval 'sub KVM_SET_DEVICE_ATTR () { &_IOW( &KVMIO, 0xe1, \'struct kvm_device_attr\');}' unless defined(&KVM_SET_DEVICE_ATTR);
    eval 'sub KVM_GET_DEVICE_ATTR () { &_IOW( &KVMIO, 0xe2, \'struct kvm_device_attr\');}' unless defined(&KVM_GET_DEVICE_ATTR);
    eval 'sub KVM_HAS_DEVICE_ATTR () { &_IOW( &KVMIO, 0xe3, \'struct kvm_device_attr\');}' unless defined(&KVM_HAS_DEVICE_ATTR);
    eval 'sub KVM_RUN () { &_IO( &KVMIO, 0x80);}' unless defined(&KVM_RUN);
    eval 'sub KVM_GET_REGS () { &_IOR( &KVMIO, 0x81, \'struct kvm_regs\');}' unless defined(&KVM_GET_REGS);
    eval 'sub KVM_SET_REGS () { &_IOW( &KVMIO, 0x82, \'struct kvm_regs\');}' unless defined(&KVM_SET_REGS);
    eval 'sub KVM_GET_SREGS () { &_IOR( &KVMIO, 0x83, \'struct kvm_sregs\');}' unless defined(&KVM_GET_SREGS);
    eval 'sub KVM_SET_SREGS () { &_IOW( &KVMIO, 0x84, \'struct kvm_sregs\');}' unless defined(&KVM_SET_SREGS);
    eval 'sub KVM_TRANSLATE () { &_IOWR( &KVMIO, 0x85, \'struct kvm_translation\');}' unless defined(&KVM_TRANSLATE);
    eval 'sub KVM_INTERRUPT () { &_IOW( &KVMIO, 0x86, \'struct kvm_interrupt\');}' unless defined(&KVM_INTERRUPT);
    eval 'sub KVM_DEBUG_GUEST () { &__KVM_DEPRECATED_VCPU_W_0x87;}' unless defined(&KVM_DEBUG_GUEST);
    eval 'sub KVM_GET_MSRS () { &_IOWR( &KVMIO, 0x88, \'struct kvm_msrs\');}' unless defined(&KVM_GET_MSRS);
    eval 'sub KVM_SET_MSRS () { &_IOW( &KVMIO, 0x89, \'struct kvm_msrs\');}' unless defined(&KVM_SET_MSRS);
    eval 'sub KVM_SET_CPUID () { &_IOW( &KVMIO, 0x8a, \'struct kvm_cpuid\');}' unless defined(&KVM_SET_CPUID);
    eval 'sub KVM_SET_SIGNAL_MASK () { &_IOW( &KVMIO, 0x8b, \'struct kvm_signal_mask\');}' unless defined(&KVM_SET_SIGNAL_MASK);
    eval 'sub KVM_GET_FPU () { &_IOR( &KVMIO, 0x8c, \'struct kvm_fpu\');}' unless defined(&KVM_GET_FPU);
    eval 'sub KVM_SET_FPU () { &_IOW( &KVMIO, 0x8d, \'struct kvm_fpu\');}' unless defined(&KVM_SET_FPU);
    eval 'sub KVM_GET_LAPIC () { &_IOR( &KVMIO, 0x8e, \'struct kvm_lapic_state\');}' unless defined(&KVM_GET_LAPIC);
    eval 'sub KVM_SET_LAPIC () { &_IOW( &KVMIO, 0x8f, \'struct kvm_lapic_state\');}' unless defined(&KVM_SET_LAPIC);
    eval 'sub KVM_SET_CPUID2 () { &_IOW( &KVMIO, 0x90, \'struct kvm_cpuid2\');}' unless defined(&KVM_SET_CPUID2);
    eval 'sub KVM_GET_CPUID2 () { &_IOWR( &KVMIO, 0x91, \'struct kvm_cpuid2\');}' unless defined(&KVM_GET_CPUID2);
    eval 'sub KVM_TPR_ACCESS_REPORTING () { &_IOWR( &KVMIO, 0x92, \'struct kvm_tpr_access_ctl\');}' unless defined(&KVM_TPR_ACCESS_REPORTING);
    eval 'sub KVM_SET_VAPIC_ADDR () { &_IOW( &KVMIO, 0x93, \'struct kvm_vapic_addr\');}' unless defined(&KVM_SET_VAPIC_ADDR);
    eval 'sub KVM_S390_INTERRUPT () { &_IOW( &KVMIO, 0x94, \'struct kvm_s390_interrupt\');}' unless defined(&KVM_S390_INTERRUPT);
    eval 'sub KVM_S390_STORE_STATUS_NOADDR () {(-1);}' unless defined(&KVM_S390_STORE_STATUS_NOADDR);
    eval 'sub KVM_S390_STORE_STATUS_PREFIXED () {(-2);}' unless defined(&KVM_S390_STORE_STATUS_PREFIXED);
    eval 'sub KVM_S390_STORE_STATUS () { &_IOW( &KVMIO, 0x95, \'unsigned long\');}' unless defined(&KVM_S390_STORE_STATUS);
    eval 'sub KVM_S390_SET_INITIAL_PSW () { &_IOW( &KVMIO, 0x96, \'struct kvm_s390_psw\');}' unless defined(&KVM_S390_SET_INITIAL_PSW);
    eval 'sub KVM_S390_INITIAL_RESET () { &_IO( &KVMIO, 0x97);}' unless defined(&KVM_S390_INITIAL_RESET);
    eval 'sub KVM_GET_MP_STATE () { &_IOR( &KVMIO, 0x98, \'struct kvm_mp_state\');}' unless defined(&KVM_GET_MP_STATE);
    eval 'sub KVM_SET_MP_STATE () { &_IOW( &KVMIO, 0x99, \'struct kvm_mp_state\');}' unless defined(&KVM_SET_MP_STATE);
    eval 'sub KVM_NMI () { &_IO( &KVMIO, 0x9a);}' unless defined(&KVM_NMI);
    eval 'sub KVM_SET_GUEST_DEBUG () { &_IOW( &KVMIO, 0x9b, \'struct kvm_guest_debug\');}' unless defined(&KVM_SET_GUEST_DEBUG);
    eval 'sub KVM_X86_SETUP_MCE () { &_IOW( &KVMIO, 0x9c,  &__u64);}' unless defined(&KVM_X86_SETUP_MCE);
    eval 'sub KVM_X86_GET_MCE_CAP_SUPPORTED () { &_IOR( &KVMIO, 0x9d,  &__u64);}' unless defined(&KVM_X86_GET_MCE_CAP_SUPPORTED);
    eval 'sub KVM_X86_SET_MCE () { &_IOW( &KVMIO, 0x9e, \'struct kvm_x86_mce\');}' unless defined(&KVM_X86_SET_MCE);
    eval 'sub KVM_IA64_VCPU_GET_STACK () { &_IOR( &KVMIO, 0x9a,  &void *);}' unless defined(&KVM_IA64_VCPU_GET_STACK);
    eval 'sub KVM_IA64_VCPU_SET_STACK () { &_IOW( &KVMIO, 0x9b,  &void *);}' unless defined(&KVM_IA64_VCPU_SET_STACK);
    eval 'sub KVM_GET_VCPU_EVENTS () { &_IOR( &KVMIO, 0x9f, \'struct kvm_vcpu_events\');}' unless defined(&KVM_GET_VCPU_EVENTS);
    eval 'sub KVM_SET_VCPU_EVENTS () { &_IOW( &KVMIO, 0xa0, \'struct kvm_vcpu_events\');}' unless defined(&KVM_SET_VCPU_EVENTS);
    eval 'sub KVM_GET_DEBUGREGS () { &_IOR( &KVMIO, 0xa1, \'struct kvm_debugregs\');}' unless defined(&KVM_GET_DEBUGREGS);
    eval 'sub KVM_SET_DEBUGREGS () { &_IOW( &KVMIO, 0xa2, \'struct kvm_debugregs\');}' unless defined(&KVM_SET_DEBUGREGS);
    eval 'sub KVM_ENABLE_CAP () { &_IOW( &KVMIO, 0xa3, \'struct kvm_enable_cap\');}' unless defined(&KVM_ENABLE_CAP);
    eval 'sub KVM_GET_XSAVE () { &_IOR( &KVMIO, 0xa4, \'struct kvm_xsave\');}' unless defined(&KVM_GET_XSAVE);
    eval 'sub KVM_SET_XSAVE () { &_IOW( &KVMIO, 0xa5, \'struct kvm_xsave\');}' unless defined(&KVM_SET_XSAVE);
    eval 'sub KVM_GET_XCRS () { &_IOR( &KVMIO, 0xa6, \'struct kvm_xcrs\');}' unless defined(&KVM_GET_XCRS);
    eval 'sub KVM_SET_XCRS () { &_IOW( &KVMIO, 0xa7, \'struct kvm_xcrs\');}' unless defined(&KVM_SET_XCRS);
    eval 'sub KVM_DIRTY_TLB () { &_IOW( &KVMIO, 0xaa, \'struct kvm_dirty_tlb\');}' unless defined(&KVM_DIRTY_TLB);
    eval 'sub KVM_GET_ONE_REG () { &_IOW( &KVMIO, 0xab, \'struct kvm_one_reg\');}' unless defined(&KVM_GET_ONE_REG);
    eval 'sub KVM_SET_ONE_REG () { &_IOW( &KVMIO, 0xac, \'struct kvm_one_reg\');}' unless defined(&KVM_SET_ONE_REG);
    eval 'sub KVM_KVMCLOCK_CTRL () { &_IO( &KVMIO, 0xad);}' unless defined(&KVM_KVMCLOCK_CTRL);
    eval 'sub KVM_ARM_VCPU_INIT () { &_IOW( &KVMIO, 0xae, \'struct kvm_vcpu_init\');}' unless defined(&KVM_ARM_VCPU_INIT);
    eval 'sub KVM_GET_REG_LIST () { &_IOWR( &KVMIO, 0xb0, \'struct kvm_reg_list\');}' unless defined(&KVM_GET_REG_LIST);
    eval 'sub KVM_DEV_ASSIGN_ENABLE_IOMMU () {(1<< 0);}' unless defined(&KVM_DEV_ASSIGN_ENABLE_IOMMU);
    eval 'sub KVM_DEV_ASSIGN_PCI_2_3 () {(1<< 1);}' unless defined(&KVM_DEV_ASSIGN_PCI_2_3);
    eval 'sub KVM_DEV_ASSIGN_MASK_INTX () {(1<< 2);}' unless defined(&KVM_DEV_ASSIGN_MASK_INTX);
    eval 'sub KVM_DEV_IRQ_HOST_INTX () {(1<< 0);}' unless defined(&KVM_DEV_IRQ_HOST_INTX);
    eval 'sub KVM_DEV_IRQ_HOST_MSI () {(1<< 1);}' unless defined(&KVM_DEV_IRQ_HOST_MSI);
    eval 'sub KVM_DEV_IRQ_HOST_MSIX () {(1<< 2);}' unless defined(&KVM_DEV_IRQ_HOST_MSIX);
    eval 'sub KVM_DEV_IRQ_GUEST_INTX () {(1<< 8);}' unless defined(&KVM_DEV_IRQ_GUEST_INTX);
    eval 'sub KVM_DEV_IRQ_GUEST_MSI () {(1<< 9);}' unless defined(&KVM_DEV_IRQ_GUEST_MSI);
    eval 'sub KVM_DEV_IRQ_GUEST_MSIX () {(1<< 10);}' unless defined(&KVM_DEV_IRQ_GUEST_MSIX);
    eval 'sub KVM_DEV_IRQ_HOST_MASK () {0xff;}' unless defined(&KVM_DEV_IRQ_HOST_MASK);
    eval 'sub KVM_DEV_IRQ_GUEST_MASK () {0xff00;}' unless defined(&KVM_DEV_IRQ_GUEST_MASK);
    eval 'sub KVM_MAX_MSIX_PER_DEV () {256;}' unless defined(&KVM_MAX_MSIX_PER_DEV);
}
1;
