/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.ui.UIFactory;
import com.sun.deploy.util.DeploySysAction;
import com.sun.deploy.util.DeploySysRun;
import com.sun.deploy.util.Trace;
import com.sun.jnlp.ApiDialog;
import com.sun.jnlp.CheckServicePermission;
import com.sun.jnlp.FileContentsImpl;
import com.sun.jnlp.FileOpenServiceImpl;
import com.sun.jnlp.JNLPFileFilter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.jnlp.FileContents;
import javax.jnlp.FileSaveService;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileSystemView;

public final class FileSaveServiceImpl
implements FileSaveService {
    static FileSaveServiceImpl _sharedInstance = null;
    private ApiDialog _apiDialog = new ApiDialog();
    private String _lastPath;

    private FileSaveServiceImpl() {
    }

    public static synchronized FileSaveService getInstance() {
        if (_sharedInstance == null) {
            _sharedInstance = new FileSaveServiceImpl();
        }
        return _sharedInstance;
    }

    String getLastPath() {
        return this._lastPath;
    }

    void setLastPath(String string) {
        this._lastPath = string;
    }

    public FileContents saveAsFileDialog(String string, String[] stringArray, FileContents fileContents) throws IOException {
        return this.saveFileDialog(string, stringArray, fileContents.getInputStream(), fileContents.getName());
    }

    public FileContents saveFileDialog(final String string, final String[] stringArray, final InputStream inputStream, String string2) throws IOException {
        if (!this.askUser()) {
            return null;
        }
        Object object = DeploySysRun.executePrivileged((DeploySysAction)new DeploySysAction(){

            public Object execute() {
                int n;
                JFileChooser jFileChooser = null;
                FileSystemView fileSystemView = FileOpenServiceImpl.getFileSystemView();
                jFileChooser = string != null ? new JFileChooser(string, fileSystemView) : new JFileChooser(FileSaveServiceImpl.this.getLastPath(), fileSystemView);
                jFileChooser.setFileSelectionMode(0);
                jFileChooser.setDialogType(1);
                jFileChooser.setMultiSelectionEnabled(false);
                if (stringArray != null) {
                    jFileChooser.addChoosableFileFilter(new JNLPFileFilter(stringArray));
                }
                if ((n = jFileChooser.showSaveDialog(null)) == 1) {
                    return null;
                }
                File file = jFileChooser.getSelectedFile();
                if (file != null) {
                    if (!FileSaveServiceImpl.fileChk(file)) {
                        return null;
                    }
                    try {
                        byte[] byArray = new byte[8192];
                        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
                        int n2 = bufferedInputStream.read(byArray);
                        while (n2 != -1) {
                            bufferedOutputStream.write(byArray, 0, n2);
                            n2 = bufferedInputStream.read(byArray);
                        }
                        bufferedOutputStream.close();
                        FileSaveServiceImpl.this.setLastPath(file.getPath());
                        return new FileContentsImpl(file, FileSaveServiceImpl.computeMaxLength(file.length()));
                    }
                    catch (IOException iOException) {
                        Trace.ignored((Throwable)iOException);
                        return iOException;
                    }
                }
                return null;
            }
        }, null);
        if (object instanceof IOException) {
            throw (IOException)object;
        }
        return (FileContents)object;
    }

    synchronized boolean askUser() {
        if (CheckServicePermission.hasFileAccessPermissions()) {
            return true;
        }
        return this._apiDialog.askUser(ResourceManager.getString((String)"api.file.save.title"), ResourceManager.getString((String)"api.file.save.message"), ResourceManager.getString((String)"api.file.save.always"));
    }

    static long computeMaxLength(long l) {
        return l * 3L;
    }

    static boolean fileChk(File file) {
        if (file.exists()) {
            String string;
            String string2 = ResourceManager.getString((String)"api.file.save.fileExist", (String)file.getPath());
            int n = UIFactory.showConfirmDialog(null, null, (String)string2, (String)(string = ResourceManager.getMessage((String)"api.file.save.fileExistTitle")));
            return n == 0;
        }
        return true;
    }
}

