/*
 * Decompiled with CFR 0.152.
 */
package apple.awt;

import apple.awt.OSXSurfaceData;
import apple.awt.RuntimeOptions;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import sun.awt.image.BufImgSurfaceData;
import sun.awt.image.ImageRepresentation;
import sun.awt.image.ToolkitImage;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.loops.CompositeType;
import sun.java2d.loops.GraphicsPrimitive;
import sun.java2d.pipe.DrawImagePipe;
import sun.java2d.pipe.PixelDrawPipe;
import sun.java2d.pipe.PixelFillPipe;
import sun.java2d.pipe.ShapeDrawPipe;

public class CRenderer
implements PixelDrawPipe,
PixelFillPipe,
ShapeDrawPipe,
DrawImagePipe {
    static final boolean sRenderLine;
    static final boolean sRenderDrawRect;
    static final boolean sRenderFillRect;
    static final boolean sRenderDrawRoundRect;
    static final boolean sRenderFillRoundRect;
    static final boolean sRenderDrawOval;
    static final boolean sRenderFillOval;
    static final boolean sRenderDrawArc;
    static final boolean sRenderFillArc;
    static final boolean sRenderDrawPolygon;
    static final boolean sRenderFillPolygon;
    static final boolean sRenderDrawShape;
    static final boolean sRenderFillShape;
    static final boolean sRenderImage;
    static final boolean sOptimizeShapes;
    Line2D lineToShape;
    Rectangle2D rectToShape;
    RoundRectangle2D roundrectToShape;
    Ellipse2D ovalToShape;
    Arc2D arcToShape;

    static native void init();

    native void doLine(SurfaceData var1, float var2, float var3, float var4, float var5);

    @Override
    public void drawLine(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        this.drawLine(sunGraphics2D, (float)n, (float)n2, (float)n3, (float)n4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawLine(SunGraphics2D sunGraphics2D, float f, float f2, float f3, float f4) {
        if (!sRenderLine) {
            return;
        }
        OSXSurfaceData oSXSurfaceData = (OSXSurfaceData)sunGraphics2D.getSurfaceData();
        if (sunGraphics2D.strokeState != 3 && OSXSurfaceData.IsSimpleColor(sunGraphics2D.paint)) {
            oSXSurfaceData.doLine(this, sunGraphics2D, f, f2, f3, f4);
        } else {
            Object object;
            if (this.lineToShape == null) {
                object = this;
                synchronized (object) {
                    if (this.lineToShape == null) {
                        this.lineToShape = new Line2D.Float();
                    }
                }
            }
            object = this.lineToShape;
            synchronized (object) {
                this.lineToShape.setLine(f, f2, f3, f4);
                this.drawfillShape(sunGraphics2D, sunGraphics2D.stroke.createStrokedShape(this.lineToShape), true, true);
            }
        }
    }

    native void doRect(SurfaceData var1, float var2, float var3, float var4, float var5, boolean var6);

    @Override
    public void drawRect(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        this.drawRect(sunGraphics2D, (float)n, (float)n2, (float)n3, (float)n4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawRect(SunGraphics2D sunGraphics2D, float f, float f2, float f3, float f4) {
        if (!sRenderDrawRect) {
            return;
        }
        if (f3 >= 0.0f && f4 >= 0.0f) {
            OSXSurfaceData oSXSurfaceData = (OSXSurfaceData)sunGraphics2D.getSurfaceData();
            if (sunGraphics2D.strokeState != 3 && OSXSurfaceData.IsSimpleColor(sunGraphics2D.paint)) {
                oSXSurfaceData.doRect(this, sunGraphics2D, f, f2, f3, f4, false);
            } else {
                Object object;
                if (this.rectToShape == null) {
                    object = this;
                    synchronized (object) {
                        if (this.rectToShape == null) {
                            this.rectToShape = new Rectangle2D.Float();
                        }
                    }
                }
                object = this.rectToShape;
                synchronized (object) {
                    this.rectToShape.setRect(f, f2, f3, f4);
                    this.drawfillShape(sunGraphics2D, sunGraphics2D.stroke.createStrokedShape(this.rectToShape), true, true);
                }
            }
        }
    }

    @Override
    public void fillRect(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        this.fillRect(sunGraphics2D, (float)n, (float)n2, (float)n3, (float)n4);
    }

    public void fillRect(SunGraphics2D sunGraphics2D, float f, float f2, float f3, float f4) {
        if (!sRenderFillRect) {
            return;
        }
        if (f3 >= 0.0f && f4 >= 0.0f) {
            OSXSurfaceData oSXSurfaceData = (OSXSurfaceData)sunGraphics2D.getSurfaceData();
            oSXSurfaceData.doRect(this, sunGraphics2D, f, f2, f3, f4, true);
        }
    }

    native void doRoundRect(SurfaceData var1, float var2, float var3, float var4, float var5, float var6, float var7, boolean var8);

    @Override
    public void drawRoundRect(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        this.drawRoundRect(sunGraphics2D, (float)n, (float)n2, (float)n3, (float)n4, (float)n5, (float)n6);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawRoundRect(SunGraphics2D sunGraphics2D, float f, float f2, float f3, float f4, float f5, float f6) {
        if (!sRenderDrawRoundRect) {
            return;
        }
        if (f3 >= 0.0f && f4 >= 0.0f) {
            OSXSurfaceData oSXSurfaceData = (OSXSurfaceData)sunGraphics2D.getSurfaceData();
            if (sunGraphics2D.strokeState != 3 && OSXSurfaceData.IsSimpleColor(sunGraphics2D.paint)) {
                oSXSurfaceData.doRoundRect(this, sunGraphics2D, f, f2, f3, f4, f5, f6, false);
            } else {
                Object object;
                if (this.roundrectToShape == null) {
                    object = this;
                    synchronized (object) {
                        if (this.roundrectToShape == null) {
                            this.roundrectToShape = new RoundRectangle2D.Float();
                        }
                    }
                }
                object = this.roundrectToShape;
                synchronized (object) {
                    this.roundrectToShape.setRoundRect(f, f2, f3, f4, f5, f6);
                    this.drawfillShape(sunGraphics2D, sunGraphics2D.stroke.createStrokedShape(this.roundrectToShape), true, true);
                }
            }
        }
    }

    @Override
    public void fillRoundRect(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        this.fillRoundRect(sunGraphics2D, (float)n, (float)n2, (float)n3, (float)n4, (float)n5, (float)n6);
    }

    public void fillRoundRect(SunGraphics2D sunGraphics2D, float f, float f2, float f3, float f4, float f5, float f6) {
        if (!sRenderFillRoundRect) {
            return;
        }
        if (f3 >= 0.0f && f4 >= 0.0f) {
            OSXSurfaceData oSXSurfaceData = (OSXSurfaceData)sunGraphics2D.getSurfaceData();
            oSXSurfaceData.doRoundRect(this, sunGraphics2D, f, f2, f3, f4, f5, f6, true);
        }
    }

    native void doOval(SurfaceData var1, float var2, float var3, float var4, float var5, boolean var6);

    @Override
    public void drawOval(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        this.drawOval(sunGraphics2D, (float)n, (float)n2, (float)n3, (float)n4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawOval(SunGraphics2D sunGraphics2D, float f, float f2, float f3, float f4) {
        if (!sRenderDrawOval) {
            return;
        }
        if (f3 >= 0.0f && f4 >= 0.0f) {
            OSXSurfaceData oSXSurfaceData = (OSXSurfaceData)sunGraphics2D.getSurfaceData();
            if (sunGraphics2D.strokeState != 3 && OSXSurfaceData.IsSimpleColor(sunGraphics2D.paint)) {
                oSXSurfaceData.doOval(this, sunGraphics2D, f, f2, f3, f4, false);
            } else {
                Object object;
                if (this.ovalToShape == null) {
                    object = this;
                    synchronized (object) {
                        if (this.ovalToShape == null) {
                            this.ovalToShape = new Ellipse2D.Float();
                        }
                    }
                }
                object = this.ovalToShape;
                synchronized (object) {
                    this.ovalToShape.setFrame(f, f2, f3, f4);
                    this.drawfillShape(sunGraphics2D, sunGraphics2D.stroke.createStrokedShape(this.ovalToShape), true, true);
                }
            }
        }
    }

    @Override
    public void fillOval(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        this.fillOval(sunGraphics2D, (float)n, (float)n2, (float)n3, (float)n4);
    }

    public void fillOval(SunGraphics2D sunGraphics2D, float f, float f2, float f3, float f4) {
        if (!sRenderFillOval) {
            return;
        }
        if (f3 >= 0.0f && f4 >= 0.0f) {
            OSXSurfaceData oSXSurfaceData = (OSXSurfaceData)sunGraphics2D.getSurfaceData();
            oSXSurfaceData.doOval(this, sunGraphics2D, f, f2, f3, f4, true);
        }
    }

    native void doArc(SurfaceData var1, float var2, float var3, float var4, float var5, float var6, float var7, int var8, boolean var9);

    @Override
    public void drawArc(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        this.drawArc(sunGraphics2D, n, n2, n3, n4, n5, n6, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawArc(SunGraphics2D sunGraphics2D, float f, float f2, float f3, float f4, float f5, float f6, int n) {
        if (!sRenderDrawArc) {
            return;
        }
        if (f3 >= 0.0f && f4 >= 0.0f) {
            OSXSurfaceData oSXSurfaceData = (OSXSurfaceData)sunGraphics2D.getSurfaceData();
            if (sunGraphics2D.strokeState != 3 && OSXSurfaceData.IsSimpleColor(sunGraphics2D.paint)) {
                oSXSurfaceData.doArc(this, sunGraphics2D, f, f2, f3, f4, f5, f6, n, false);
            } else {
                Object object;
                if (this.arcToShape == null) {
                    object = this;
                    synchronized (object) {
                        if (this.arcToShape == null) {
                            this.arcToShape = new Arc2D.Float();
                        }
                    }
                }
                object = this.arcToShape;
                synchronized (object) {
                    this.arcToShape.setArc(f, f2, f3, f4, f5, f6, n);
                    this.drawfillShape(sunGraphics2D, sunGraphics2D.stroke.createStrokedShape(this.arcToShape), true, true);
                }
            }
        }
    }

    @Override
    public void fillArc(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        this.fillArc(sunGraphics2D, n, n2, n3, n4, n5, n6, 2);
    }

    public void fillArc(SunGraphics2D sunGraphics2D, float f, float f2, float f3, float f4, float f5, float f6, int n) {
        if (!sRenderFillArc) {
            return;
        }
        if (f3 >= 0.0f && f4 >= 0.0f) {
            OSXSurfaceData oSXSurfaceData = (OSXSurfaceData)sunGraphics2D.getSurfaceData();
            oSXSurfaceData.doArc(this, sunGraphics2D, f, f2, f3, f4, f5, f6, n, true);
        }
    }

    native void doPoly(SurfaceData var1, int[] var2, int[] var3, int var4, boolean var5, boolean var6);

    @Override
    public void drawPolyline(SunGraphics2D sunGraphics2D, int[] nArray, int[] nArray2, int n) {
        if (!sRenderDrawPolygon) {
            return;
        }
        OSXSurfaceData oSXSurfaceData = (OSXSurfaceData)sunGraphics2D.getSurfaceData();
        if (sunGraphics2D.strokeState != 3 && OSXSurfaceData.IsSimpleColor(sunGraphics2D.paint)) {
            oSXSurfaceData.doPolygon(this, sunGraphics2D, nArray, nArray2, n, false, false);
        } else {
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(nArray[0], nArray2[0]);
            for (int i = 1; i < n; ++i) {
                generalPath.lineTo(nArray[i], nArray2[i]);
            }
            this.drawfillShape(sunGraphics2D, sunGraphics2D.stroke.createStrokedShape(generalPath), true, true);
        }
    }

    @Override
    public void drawPolygon(SunGraphics2D sunGraphics2D, int[] nArray, int[] nArray2, int n) {
        if (!sRenderDrawPolygon) {
            return;
        }
        OSXSurfaceData oSXSurfaceData = (OSXSurfaceData)sunGraphics2D.getSurfaceData();
        if (sunGraphics2D.strokeState != 3 && OSXSurfaceData.IsSimpleColor(sunGraphics2D.paint)) {
            oSXSurfaceData.doPolygon(this, sunGraphics2D, nArray, nArray2, n, true, false);
        } else {
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(nArray[0], nArray2[0]);
            for (int i = 1; i < n; ++i) {
                generalPath.lineTo(nArray[i], nArray2[i]);
            }
            generalPath.lineTo(nArray[0], nArray2[0]);
            this.drawfillShape(sunGraphics2D, sunGraphics2D.stroke.createStrokedShape(generalPath), true, true);
        }
    }

    @Override
    public void fillPolygon(SunGraphics2D sunGraphics2D, int[] nArray, int[] nArray2, int n) {
        if (!sRenderFillPolygon) {
            return;
        }
        OSXSurfaceData oSXSurfaceData = (OSXSurfaceData)sunGraphics2D.getSurfaceData();
        oSXSurfaceData.doPolygon(this, sunGraphics2D, nArray, nArray2, n, true, true);
    }

    native void doShape(SurfaceData var1, int var2, FloatBuffer var3, IntBuffer var4, int var5, boolean var6, boolean var7);

    void drawfillShape(SunGraphics2D sunGraphics2D, Shape shape, boolean bl, boolean bl2) {
        if (shape == null) {
            throw new NullPointerException();
        }
        if (!sRenderFillShape) {
            return;
        }
        OSXSurfaceData oSXSurfaceData = (OSXSurfaceData)sunGraphics2D.getSurfaceData();
        if (sOptimizeShapes && OSXSurfaceData.IsSimpleColor(sunGraphics2D.paint)) {
            if (shape instanceof Rectangle2D) {
                Rectangle2D rectangle2D = (Rectangle2D)shape;
                float f = (float)rectangle2D.getX();
                float f2 = (float)rectangle2D.getY();
                float f3 = (float)rectangle2D.getWidth();
                float f4 = (float)rectangle2D.getHeight();
                if (bl) {
                    this.fillRect(sunGraphics2D, f, f2, f3, f4);
                } else {
                    this.drawRect(sunGraphics2D, f, f2, f3, f4);
                }
            } else if (shape instanceof Ellipse2D) {
                Ellipse2D ellipse2D = (Ellipse2D)shape;
                float f = (float)ellipse2D.getX();
                float f5 = (float)ellipse2D.getY();
                float f6 = (float)ellipse2D.getWidth();
                float f7 = (float)ellipse2D.getHeight();
                if (bl) {
                    this.fillOval(sunGraphics2D, f, f5, f6, f7);
                } else {
                    this.drawOval(sunGraphics2D, f, f5, f6, f7);
                }
            } else if (shape instanceof Arc2D) {
                Arc2D arc2D = (Arc2D)shape;
                float f = (float)arc2D.getX();
                float f8 = (float)arc2D.getY();
                float f9 = (float)arc2D.getWidth();
                float f10 = (float)arc2D.getHeight();
                float f11 = (float)arc2D.getAngleStart();
                float f12 = (float)arc2D.getAngleExtent();
                if (bl) {
                    this.fillArc(sunGraphics2D, f, f8, f9, f10, f11, f12, arc2D.getArcType());
                } else {
                    this.drawArc(sunGraphics2D, f, f8, f9, f10, f11, f12, arc2D.getArcType());
                }
            } else if (shape instanceof RoundRectangle2D) {
                RoundRectangle2D roundRectangle2D = (RoundRectangle2D)shape;
                float f = (float)roundRectangle2D.getX();
                float f13 = (float)roundRectangle2D.getY();
                float f14 = (float)roundRectangle2D.getWidth();
                float f15 = (float)roundRectangle2D.getHeight();
                float f16 = (float)roundRectangle2D.getArcWidth();
                float f17 = (float)roundRectangle2D.getArcHeight();
                if (bl) {
                    this.fillRoundRect(sunGraphics2D, f, f13, f14, f15, f16, f17);
                } else {
                    this.drawRoundRect(sunGraphics2D, f, f13, f14, f15, f16, f17);
                }
            } else if (shape instanceof Line2D) {
                Line2D line2D = (Line2D)shape;
                float f = (float)line2D.getX1();
                float f18 = (float)line2D.getY1();
                float f19 = (float)line2D.getX2();
                float f20 = (float)line2D.getY2();
                this.drawLine(sunGraphics2D, f, f18, f19, f20);
            } else if (shape instanceof Point2D) {
                Point2D point2D = (Point2D)((Object)shape);
                float f = (float)point2D.getX();
                float f21 = (float)point2D.getY();
                this.drawLine(sunGraphics2D, f, f21, f, f21);
            } else {
                GeneralPath generalPath = shape instanceof GeneralPath ? (GeneralPath)shape : new GeneralPath(shape);
                PathIterator pathIterator = generalPath.getPathIterator(null);
                if (!pathIterator.isDone()) {
                    oSXSurfaceData.drawfillShape(this, sunGraphics2D, generalPath, bl, bl2);
                }
            }
        } else {
            GeneralPath generalPath = shape instanceof GeneralPath ? (GeneralPath)shape : new GeneralPath(shape);
            PathIterator pathIterator = generalPath.getPathIterator(null);
            if (!pathIterator.isDone()) {
                oSXSurfaceData.drawfillShape(this, sunGraphics2D, generalPath, bl, bl2);
            }
        }
    }

    @Override
    public void draw(SunGraphics2D sunGraphics2D, Shape shape) {
        if (!sRenderDrawShape) {
            return;
        }
        OSXSurfaceData oSXSurfaceData = (OSXSurfaceData)sunGraphics2D.getSurfaceData();
        if (sunGraphics2D.strokeState != 3 && OSXSurfaceData.IsSimpleColor(sunGraphics2D.paint)) {
            this.drawfillShape(sunGraphics2D, shape, false, true);
        } else {
            this.drawfillShape(sunGraphics2D, sunGraphics2D.stroke.createStrokedShape(shape), true, true);
        }
    }

    @Override
    public void fill(SunGraphics2D sunGraphics2D, Shape shape) {
        this.drawfillShape(sunGraphics2D, shape, true, false);
    }

    native boolean doCopyAreaInWindow(SurfaceData var1, int var2, int var3, int var4, int var5, int var6, int var7);

    native boolean doCopyAreaFromWindow(SurfaceData var1, SurfaceData var2, int var3, int var4, int var5, int var6);

    native boolean xorSurfacePixels(SurfaceData var1, SurfaceData var2, int var3, int var4, int var5, int var6, int var7);

    native boolean doBeginCocoaDrawing(SurfaceData var1);

    native void doFinishCocoaDrawing(SurfaceData var1);

    native void doImage(SurfaceData var1, SurfaceData var2, boolean var3, boolean var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14);

    native void doNSImage(SurfaceData var1, long var2, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11);

    public boolean scaleImage(SunGraphics2D sunGraphics2D, Image image, int n, int n2, int n3, int n4, Color color) {
        if (!sRenderImage) {
            return true;
        }
        OSXSurfaceData oSXSurfaceData = (OSXSurfaceData)sunGraphics2D.getSurfaceData();
        int n5 = 0;
        int n6 = 0;
        int n7 = image.getWidth(null);
        int n8 = image.getHeight(null);
        return this.scaleImage(sunGraphics2D, image, n, n2, n + n3, n2 + n4, n5, n6, n5 + n7, n6 + n8, color);
    }

    public boolean scaleImage(SunGraphics2D sunGraphics2D, Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color) {
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        if (!sRenderImage) {
            return true;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (n7 > n5) {
            n16 = n7 - n5;
            n15 = n5;
        } else {
            bl = true;
            n16 = n5 - n7;
            n15 = n7;
        }
        if (n8 > n6) {
            n14 = n8 - n6;
            n13 = n6;
        } else {
            bl2 = true;
            n14 = n6 - n8;
            n13 = n8;
        }
        if (n3 > n) {
            n12 = n3 - n;
            n11 = n;
        } else {
            n12 = n - n3;
            bl3 = true;
            n11 = n3;
        }
        if (n4 > n2) {
            n10 = n4 - n2;
            n9 = n2;
        } else {
            n10 = n2 - n4;
            bl4 = true;
            n9 = n4;
        }
        if (n16 <= 0 || n14 <= 0) {
            return true;
        }
        boolean bl5 = bl2 != bl4;
        boolean bl6 = bl != bl3;
        return this.blitImage(sunGraphics2D, image, bl6, bl5, n15, n13, n16, n14, n11, n9, n12, n10, color);
    }

    protected boolean blitImage(SunGraphics2D sunGraphics2D, Image image, boolean bl, boolean bl2, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color) {
        OSXSurfaceData oSXSurfaceData = (OSXSurfaceData)sunGraphics2D.getSurfaceData();
        SurfaceData surfaceData = SurfaceData.getSourceSurfaceData((Image)image, (SurfaceData)oSXSurfaceData, (CompositeType)sunGraphics2D.imageComp, (Color)color, (boolean)false);
        oSXSurfaceData.blitImage(this, sunGraphics2D, surfaceData, bl, bl2, n, n2, n3, n4, n5, n6, n7, n8, color);
        return true;
    }

    protected boolean copyImage(SunGraphics2D sunGraphics2D, Image image, int n, int n2, Color color) {
        if (image == null) {
            return true;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = image.getWidth(null);
        int n6 = image.getHeight(null);
        return this.blitImage(sunGraphics2D, image, false, false, n3, n4, n5, n6, n, n2, n5, n6, color);
    }

    protected boolean copyImage(SunGraphics2D sunGraphics2D, Image image, int n, int n2, int n3, int n4, int n5, int n6, Color color) {
        return this.blitImage(sunGraphics2D, image, false, false, n3, n4, n5, n6, n, n2, n5, n6, color);
    }

    protected void transformImage(SunGraphics2D sunGraphics2D, Image image, int n, int n2, BufferedImageOp bufferedImageOp, AffineTransform affineTransform, Color color) {
        if (image != null) {
            Object object;
            int n3 = image.getWidth(null);
            int n4 = image.getHeight(null);
            if (bufferedImageOp != null && image instanceof BufferedImage) {
                if (((BufferedImage)image).getType() == 0) {
                    object = null;
                    object = new BufferedImage(n3, n4, 3);
                    Graphics2D graphics2D = ((BufferedImage)object).createGraphics();
                    graphics2D.drawImage(image, 0, 0, null);
                    graphics2D.dispose();
                    image = bufferedImageOp.filter((BufferedImage)object, null);
                } else {
                    BufImgSurfaceData.createData((BufferedImage)image).finishLazyDrawing();
                    image = bufferedImageOp.filter((BufferedImage)image, null);
                }
                n3 = image.getWidth(null);
                n4 = image.getHeight(null);
            }
            if (affineTransform != null) {
                object = sunGraphics2D.getTransform();
                sunGraphics2D.transform(affineTransform);
                this.scaleImage(sunGraphics2D, image, n, n2, n + n3, n2 + n4, 0, 0, n3, n4, color);
                sunGraphics2D.setTransform((AffineTransform)object);
            } else {
                this.scaleImage(sunGraphics2D, image, n, n2, n + n3, n2 + n4, 0, 0, n3, n4, color);
            }
        } else {
            throw new NullPointerException();
        }
    }

    protected boolean imageReady(ToolkitImage toolkitImage, ImageObserver imageObserver) {
        if (toolkitImage.hasError()) {
            if (imageObserver != null) {
                imageObserver.imageUpdate(toolkitImage, 192, -1, -1, -1, -1);
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean copyImage(SunGraphics2D sunGraphics2D, Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        if (!sRenderImage) {
            return true;
        }
        if (image == null) {
            throw new NullPointerException();
        }
        if (!(image instanceof ToolkitImage)) {
            return this.copyImage(sunGraphics2D, image, n, n2, color);
        }
        ToolkitImage toolkitImage = (ToolkitImage)image;
        if (!this.imageReady(toolkitImage, imageObserver)) {
            return false;
        }
        ImageRepresentation imageRepresentation = toolkitImage.getImageRep();
        return imageRepresentation.drawToBufImage(sunGraphics2D, toolkitImage, n, n2, color, imageObserver);
    }

    @Override
    public boolean copyImage(SunGraphics2D sunGraphics2D, Image image, int n, int n2, int n3, int n4, int n5, int n6, Color color, ImageObserver imageObserver) {
        if (!sRenderImage) {
            return true;
        }
        if (image == null) {
            throw new NullPointerException();
        }
        if (!(image instanceof ToolkitImage)) {
            return this.copyImage(sunGraphics2D, image, n, n2, n3, n4, n5, n6, color);
        }
        ToolkitImage toolkitImage = (ToolkitImage)image;
        if (!this.imageReady(toolkitImage, imageObserver)) {
            return false;
        }
        ImageRepresentation imageRepresentation = toolkitImage.getImageRep();
        return imageRepresentation.drawToBufImage(sunGraphics2D, toolkitImage, n, n2, n + n5, n2 + n6, n3, n4, n3 + n5, n4 + n6, null, imageObserver);
    }

    @Override
    public boolean scaleImage(SunGraphics2D sunGraphics2D, Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        if (!sRenderImage) {
            return true;
        }
        if (image == null) {
            throw new NullPointerException();
        }
        if (!(image instanceof ToolkitImage)) {
            return this.scaleImage(sunGraphics2D, image, n, n2, n3, n4, color);
        }
        ToolkitImage toolkitImage = (ToolkitImage)image;
        if (!this.imageReady(toolkitImage, imageObserver)) {
            return false;
        }
        ImageRepresentation imageRepresentation = toolkitImage.getImageRep();
        return imageRepresentation.drawToBufImage(sunGraphics2D, toolkitImage, n, n2, n3, n4, color, imageObserver);
    }

    @Override
    public boolean scaleImage(SunGraphics2D sunGraphics2D, Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        if (!sRenderImage) {
            return true;
        }
        if (image == null) {
            throw new NullPointerException();
        }
        if (!(image instanceof ToolkitImage)) {
            return this.scaleImage(sunGraphics2D, image, n, n2, n3, n4, n5, n6, n7, n8, color);
        }
        ToolkitImage toolkitImage = (ToolkitImage)image;
        if (!this.imageReady(toolkitImage, imageObserver)) {
            return false;
        }
        ImageRepresentation imageRepresentation = toolkitImage.getImageRep();
        return imageRepresentation.drawToBufImage(sunGraphics2D, toolkitImage, n, n2, n3, n4, n5, n6, n7, n8, color, imageObserver);
    }

    @Override
    public boolean transformImage(SunGraphics2D sunGraphics2D, Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        if (!sRenderImage) {
            return true;
        }
        if (image == null) {
            throw new NullPointerException();
        }
        if (!(image instanceof ToolkitImage)) {
            this.transformImage(sunGraphics2D, image, 0, 0, null, affineTransform, null);
            return true;
        }
        ToolkitImage toolkitImage = (ToolkitImage)image;
        if (!this.imageReady(toolkitImage, imageObserver)) {
            return false;
        }
        ImageRepresentation imageRepresentation = toolkitImage.getImageRep();
        return imageRepresentation.drawToBufImage(sunGraphics2D, toolkitImage, affineTransform, imageObserver);
    }

    @Override
    public void transformImage(SunGraphics2D sunGraphics2D, BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n, int n2) {
        if (!sRenderImage) {
            return;
        }
        if (bufferedImage == null) {
            throw new NullPointerException();
        }
        this.transformImage(sunGraphics2D, bufferedImage, n, n2, bufferedImageOp, null, null);
    }

    public CRenderer traceWrap() {
        return new Tracer();
    }

    static {
        RuntimeOptions runtimeOptions = RuntimeOptions.getCurrentOptions();
        sRenderLine = runtimeOptions.RenderLine;
        sRenderDrawRect = runtimeOptions.RenderDrawRect;
        sRenderFillRect = runtimeOptions.RenderFillRect;
        sRenderDrawRoundRect = runtimeOptions.RenderDrawRoundRect;
        sRenderFillRoundRect = runtimeOptions.RenderFillRoundRect;
        sRenderDrawOval = runtimeOptions.RenderDrawOval;
        sRenderFillOval = runtimeOptions.RenderFillOval;
        sRenderDrawArc = runtimeOptions.RenderDrawArc;
        sRenderFillArc = runtimeOptions.RenderFillArc;
        sRenderDrawPolygon = runtimeOptions.RenderDrawPolygon;
        sRenderFillPolygon = runtimeOptions.RenderFillPolygon;
        sRenderDrawShape = runtimeOptions.RenderDrawShape;
        sRenderFillShape = runtimeOptions.RenderFillShape;
        sRenderImage = runtimeOptions.RenderImage;
        sOptimizeShapes = runtimeOptions.OptimizeShapes;
        CRenderer.init();
    }

    public static class Tracer
    extends CRenderer {
        @Override
        void doLine(SurfaceData surfaceData, float f, float f2, float f3, float f4) {
            GraphicsPrimitive.tracePrimitive("QuartzLine");
            super.doLine(surfaceData, f, f2, f3, f4);
        }

        @Override
        void doRect(SurfaceData surfaceData, float f, float f2, float f3, float f4, boolean bl) {
            GraphicsPrimitive.tracePrimitive("QuartzRect");
            super.doRect(surfaceData, f, f2, f3, f4, bl);
        }

        @Override
        void doRoundRect(SurfaceData surfaceData, float f, float f2, float f3, float f4, float f5, float f6, boolean bl) {
            GraphicsPrimitive.tracePrimitive("QuartzRoundRect");
            super.doRoundRect(surfaceData, f, f2, f3, f4, f5, f6, bl);
        }

        @Override
        void doOval(SurfaceData surfaceData, float f, float f2, float f3, float f4, boolean bl) {
            GraphicsPrimitive.tracePrimitive("QuartzOval");
            super.doOval(surfaceData, f, f2, f3, f4, bl);
        }

        @Override
        void doArc(SurfaceData surfaceData, float f, float f2, float f3, float f4, float f5, float f6, int n, boolean bl) {
            GraphicsPrimitive.tracePrimitive("QuartzArc");
            super.doArc(surfaceData, f, f2, f3, f4, f5, f6, n, bl);
        }

        @Override
        void doPoly(SurfaceData surfaceData, int[] nArray, int[] nArray2, int n, boolean bl, boolean bl2) {
            GraphicsPrimitive.tracePrimitive("QuartzDoPoly");
            super.doPoly(surfaceData, nArray, nArray2, n, bl, bl2);
        }

        @Override
        void doShape(SurfaceData surfaceData, int n, FloatBuffer floatBuffer, IntBuffer intBuffer, int n2, boolean bl, boolean bl2) {
            GraphicsPrimitive.tracePrimitive("QuartzFillOrDrawShape");
            super.doShape(surfaceData, n, floatBuffer, intBuffer, n2, bl, bl2);
        }

        @Override
        boolean doCopyAreaInWindow(SurfaceData surfaceData, int n, int n2, int n3, int n4, int n5, int n6) {
            GraphicsPrimitive.tracePrimitive("QuartzCopyAreaInWindow");
            return super.doCopyAreaInWindow(surfaceData, n, n2, n3, n4, n5, n6);
        }

        @Override
        boolean doCopyAreaFromWindow(SurfaceData surfaceData, SurfaceData surfaceData2, int n, int n2, int n3, int n4) {
            GraphicsPrimitive.tracePrimitive("QuartzCopyAreaFromWindow");
            return super.doCopyAreaFromWindow(surfaceData, surfaceData2, n, n2, n3, n4);
        }

        @Override
        void doImage(SurfaceData surfaceData, SurfaceData surfaceData2, boolean bl, boolean bl2, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
            GraphicsPrimitive.tracePrimitive("QuartzDrawImage");
            super.doImage(surfaceData, surfaceData2, bl, bl2, n, n2, n3, n4, n5, n6, n7, n8, n9, n10);
        }

        @Override
        void doNSImage(SurfaceData surfaceData, long l, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
            GraphicsPrimitive.tracePrimitive("QuartzDrawNSImage");
            super.doNSImage(surfaceData, l, n, n2, n3, n4, n5, n6, n7, n8);
        }
    }
}

