/*
 * Decompiled with CFR 0.152.
 */
package apple.awt;

import apple.awt.CColorPaint;
import apple.awt.CComponent;
import apple.awt.CGlobalCursorManager;
import apple.awt.CGraphicsConfig;
import apple.awt.CPeerSurfaceData;
import apple.awt.CPrinterSurfaceData;
import apple.awt.CToolkit;
import apple.awt.CWindow;
import apple.awt.OSXSurfaceData;
import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.BufferCapabilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.InvocationEvent;
import java.awt.event.PaintEvent;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.Raster;
import java.awt.image.VolatileImage;
import java.awt.peer.ComponentPeer;
import java.lang.reflect.InvocationTargetException;
import sun.awt.PaintEventDispatcher;
import sun.awt.RepaintArea;
import sun.awt.image.SunVolatileImage;
import sun.java2d.InvalidPipeException;
import sun.java2d.SunGraphics2D;
import sun.java2d.SunGraphicsEnvironment;
import sun.java2d.SurfaceData;
import sun.java2d.loops.SurfaceType;
import sun.java2d.opengl.CGLGraphicsConfig;
import sun.java2d.opengl.CGLSurfaceData;
import sun.java2d.opengl.OGLSurfaceData;
import sun.java2d.pipe.DrawImagePipe;
import sun.java2d.pipe.PixelDrawPipe;
import sun.java2d.pipe.PixelFillPipe;
import sun.java2d.pipe.Region;
import sun.java2d.pipe.ShapeDrawPipe;
import sun.java2d.pipe.TextPipe;

public abstract class ComponentModel
extends CComponent {
    static Font sDefaultFont = null;
    static Color sDefaultFColor;
    static Color sDefaultBColor;
    protected SurfaceData fSurfaceData;
    protected RepaintArea paintArea;
    protected CGraphicsConfig fGraphicsConfiguration;
    boolean isLayouting = false;
    boolean paintPending = false;
    int oldWidth = -1;
    int oldHeight = -1;
    private int numBackBuffers = 0;
    private VolatileImage backBuffer = null;
    protected long fModelPtr;
    long fNSView;
    Color fLastFColor = null;
    Color fLastBColor = null;
    final Runnable doCocoaPaint = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            SurfaceData surfaceData = ComponentModel.this.getSurfaceData();
            if (surfaceData != null) {
                if (surfaceData instanceof CPeerSurfaceData) {
                    CPeerSurfaceData cPeerSurfaceData = (CPeerSurfaceData)surfaceData;
                    cPeerSurfaceData.canDrawDuringLiveResize(true);
                    cPeerSurfaceData.disableFlushing();
                    try {
                        ((Component)ComponentModel.this.fTarget).paint(ComponentModel.this.getGraphics());
                    }
                    finally {
                        cPeerSurfaceData.enableFlushing();
                        cPeerSurfaceData.canDrawDuringLiveResize(false);
                    }
                } else if (surfaceData instanceof OGLSurfaceData) {
                    ((Component)ComponentModel.this.fTarget).paint(ComponentModel.this.getGraphics());
                }
            }
        }
    };
    long fPrintingContext;
    final Runnable doCocoaPrinting = new Runnable(){

        @Override
        public void run() {
            ((Component)ComponentModel.this.fTarget).update(ComponentModel.this.getCocoaPrintingGraphics(ComponentModel.this.fPrintingContext));
        }
    };

    public ComponentModel(Component component) {
        this.fTarget = component;
        this.fGraphicsConfiguration = (CGraphicsConfig)((Component)this.fTarget).getGraphicsConfiguration();
        this.paintArea = new RepaintArea();
    }

    protected void initPeer() {
        this.fModelPtr = this.initPeer(ComponentModel.findParentModel((Component)this.fTarget));
    }

    protected abstract long initPeer(long var1);

    @Override
    protected void disposeImpl() {
        CToolkit.targetDisposedPeer(this.fTarget, this);
        long l = this.fModelPtr;
        this.fModelPtr = 0L;
        this.fNSView = 0L;
        this._disposeImpl(l);
    }

    private native void _disposeImpl(long var1);

    static long findParentModel(Component component) {
        for (component = component.getParent(); component != null; component = component.getParent()) {
            ComponentPeer componentPeer = component.getPeer();
            if (!(componentPeer instanceof ComponentModel)) continue;
            return ((ComponentModel)componentPeer).fModelPtr;
        }
        return 0L;
    }

    long getModelPtr() {
        return this.fModelPtr;
    }

    private long getModelBelow() {
        Container container = ((Component)this.fTarget).getParent();
        if (container != null) {
            Component component;
            ComponentPeer componentPeer = null;
            for (int i = container.getComponentCount() - 1; i >= 0 && this.fTarget != (component = container.getComponent(i)); --i) {
                if (component.isLightweight() || component.getPeer() == null) continue;
                componentPeer = component.getPeer();
            }
            if (componentPeer != null && componentPeer instanceof ComponentModel) {
                return ((ComponentModel)componentPeer).fModelPtr;
            }
        }
        return 0L;
    }

    @Override
    public final GraphicsConfiguration getGraphicsConfiguration() {
        return this.fGraphicsConfiguration;
    }

    @Override
    public final VolatileImage createVolatileImage(int n, int n2) {
        return new SunVolatileImage((Component)this.fTarget, n, n2);
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            Dimension dimension = ((Component)this.fTarget).getSize();
            this.oldHeight = dimension.height;
            this.oldWidth = dimension.width;
        }
        this._setVisible(this.fModelPtr, bl);
    }

    protected native void _setVisible(long var1, boolean var3);

    @Override
    public void setEnabled(boolean bl) {
        this._setEnabled(this.fModelPtr, bl);
    }

    private native void _setEnabled(long var1, boolean var3);

    @Override
    public void setBounds(int n, int n2, int n3, int n4, int n5) {
        this.paintPending = n3 != this.oldWidth || n4 != this.oldHeight;
        this._setBounds(this.fModelPtr, n, n2, n3, n4);
        if (n3 != this.oldWidth || n4 != this.oldHeight) {
            this.oldWidth = n3;
            this.oldHeight = n4;
        }
    }

    private native void _setBounds(long var1, int var3, int var4, int var5, int var6);

    @Override
    public void updateCursorImmediately() {
        CGlobalCursorManager.getCursorManager().updateCursorImmediately();
    }

    @Override
    public Point getLocationOnScreen() {
        CWindow cWindow = this.getCWindowContainer();
        Point point = cWindow.getLocationOnScreen();
        Component component = (Component)this.fTarget;
        while (component.getPeer() != cWindow) {
            Rectangle rectangle = component.getBounds();
            point.x += rectangle.x;
            point.y += rectangle.y;
            component = component.getParent();
        }
        return point;
    }

    @Override
    public void setForeground(Color color) {
        boolean bl = false;
        if (this.fLastFColor == null && color != null) {
            bl = true;
        } else if (color instanceof CColorPaint || color instanceof SystemColor) {
            if (this.fLastFColor != color) {
                bl = true;
            }
        } else if (color != null) {
            if (this.fLastFColor.getRGB() != color.getRGB()) {
                bl = true;
            }
        } else if (this.fLastFColor != color) {
            bl = true;
        }
        if (bl) {
            this.fLastFColor = color;
            this._setForeground(this.fModelPtr, color);
        }
    }

    @Override
    public void setBackground(Color color) {
        boolean bl = false;
        if (this.fLastBColor == null && color != null) {
            bl = true;
        } else if (color instanceof CColorPaint || color instanceof SystemColor) {
            if (this.fLastBColor != color) {
                bl = true;
            }
        } else if (color != null) {
            if (this.fLastBColor.getRGB() != color.getRGB()) {
                bl = true;
            }
        } else if (this.fLastBColor != color) {
            bl = true;
        }
        if (bl) {
            this.fLastBColor = color;
            this._setBackground(this.fModelPtr, color);
        }
    }

    private native void _setForeground(long var1, Color var3);

    private native void _setBackground(long var1, Color var3);

    @Override
    public void setFont(Font font) {
        this._setFont(this.fModelPtr, font);
    }

    private native void _setFont(long var1, Font var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleEvent(AWTEvent aWTEvent) {
        int n = aWTEvent.getID();
        switch (n) {
            case 800: {
                this.paintPending = false;
            }
            case 801: {
                if (this.isLayouting || this.paintPending) break;
                try {
                    this.getCWindowContainer().disableFlushing();
                    this.paintArea.paint(this.fTarget, this.shouldClearRectBeforePaint());
                    break;
                }
                finally {
                    this.finishLazyDrawing();
                    this.getCWindowContainer().enableFlushing();
                }
            }
            default: {
                this._handleEvent(this.fModelPtr, aWTEvent);
            }
        }
    }

    private native void _handleEvent(long var1, AWTEvent var3);

    public boolean isPaintPending() {
        return this.paintPending && this.isLayouting;
    }

    public void beginLayout() {
        this.isLayouting = true;
    }

    public void endLayout() {
        if (!(this.paintArea.isEmpty() || this.paintPending || ((Component)this.fTarget).getIgnoreRepaint())) {
            this.postEvent(new PaintEvent((Component)this.fTarget, 800, new Rectangle()));
        }
        this.isLayouting = false;
    }

    @Override
    public final void coalescePaintEvent(PaintEvent paintEvent) {
        Rectangle rectangle = paintEvent.getUpdateRect();
        this.paintArea.add(rectangle, paintEvent.getID());
    }

    void handlePaint(boolean bl, int n, int n2, int n3, int n4) {
        if (!((Component)this.fTarget).getIgnoreRepaint()) {
            this.paintPending = true;
            if (bl) {
                try {
                    CToolkit.invokeAndWait(this.doCocoaPaint, (Component)this.fTarget);
                    this.paintPending = false;
                }
                catch (InterruptedException interruptedException) {
                }
                catch (InvocationTargetException invocationTargetException) {}
            } else {
                this.postEvent(new PaintEvent((Component)this.fTarget, 800, new Rectangle(n, n2, n3, n4)));
            }
        }
    }

    void handlePrinting(long l, int n, int n2, int n3, int n4) {
        this.fPrintingContext = l;
        try {
            CToolkit.invokeAndWait(this.doCocoaPrinting, (Component)this.fTarget);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    public void finishLazyDrawing() {
        if (this.fSurfaceData != null) {
            this.fSurfaceData.finishLazyDrawing();
        }
    }

    protected Rectangle getSurfaceBounds() {
        Rectangle rectangle = this.getBounds();
        return new Rectangle(0, 0, rectangle.width, rectangle.height);
    }

    public long getViewPtr() {
        if (this.fNSView <= 0L) {
            this.fNSView = this._getViewPtr(this.fModelPtr);
        }
        return this.fNSView;
    }

    private native long _getViewPtr(long var1);

    public synchronized Graphics getGraphicsForSurface(SurfaceData surfaceData) {
        Font font = ((Component)this.fTarget).getFont();
        Color color = ((Component)this.fTarget).getForeground();
        Color color2 = ((Component)this.fTarget).getBackground();
        SunGraphics2D sunGraphics2D = new SunGraphics2D(surfaceData, color != null ? color : sDefaultFColor, color2 != null ? color2 : sDefaultBColor, font != null ? font : sDefaultFont);
        return sunGraphics2D;
    }

    SurfaceData createSurfaceData() {
        CGraphicsConfig cGraphicsConfig = (CGraphicsConfig)this.getGraphicsConfiguration();
        return cGraphicsConfig.createSurfaceData(this, 1);
    }

    public long getData() {
        return this.getCWindowContainer().getData();
    }

    @Override
    public synchronized Graphics getGraphics() {
        return this.getGraphicsForSurface(this.getSurfaceData());
    }

    public synchronized SurfaceData getSurfaceData() {
        this.replaceSurfaceData();
        return this.fSurfaceData;
    }

    public synchronized Graphics getCocoaPrintingGraphics(long l) {
        return this.getGraphicsForSurface(this.getCocoaPrintingSurface(l));
    }

    public synchronized SurfaceData getCocoaPrintingSurface(long l) {
        return new CPrinterSurfaceData(this.getGraphicsConfiguration(), l);
    }

    public void replaceSurfaceData() {
        if (this.fSurfaceData == null) {
            this.fSurfaceData = this.getData() > 0L ? this.createSurfaceData() : new TemporarySurfaceData(this);
        } else if (!(this.fSurfaceData instanceof TemporarySurfaceData)) {
            Rectangle rectangle = ((Component)this.fTarget).getBounds();
            Rectangle rectangle2 = this.fSurfaceData.getBounds();
            if (rectangle.width != rectangle2.width || rectangle.height != rectangle2.height) {
                CGraphicsConfig cGraphicsConfig = (CGraphicsConfig)this.getGraphicsConfiguration();
                if (cGraphicsConfig instanceof CGLGraphicsConfig) {
                    CGLSurfaceData cGLSurfaceData = (CGLSurfaceData)this.fSurfaceData;
                    cGLSurfaceData.setBounds();
                } else {
                    OSXSurfaceData oSXSurfaceData = (OSXSurfaceData)this.fSurfaceData;
                    oSXSurfaceData.setBounds();
                }
            }
        } else if (this.getData() > 0L) {
            this.fSurfaceData = this.createSurfaceData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceSurfaceData(int n) {
        Object object = ((Component)this.fTarget).getTreeLock();
        synchronized (object) {
            ComponentModel componentModel = this;
            synchronized (componentModel) {
                if (this.getViewPtr() == 0L) {
                    return;
                }
                this.numBackBuffers = n;
                if (this.backBuffer != null) {
                    this.backBuffer.flush();
                    this.backBuffer = null;
                }
                if (this.numBackBuffers > 0) {
                    CGraphicsConfig cGraphicsConfig = (CGraphicsConfig)this.getGraphicsConfiguration();
                    this.backBuffer = cGraphicsConfig.createBackBuffer(this);
                }
            }
        }
    }

    public void replaceSurfaceDataLater() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (!ComponentModel.this.isDisposed()) {
                    try {
                        ComponentModel.this.replaceSurfaceData();
                    }
                    catch (InvalidPipeException invalidPipeException) {
                        // empty catch block
                    }
                }
            }
        };
        if (!PaintEventDispatcher.getPaintEventDispatcher().queueSurfaceDataReplacing((Component)this.fTarget, runnable)) {
            this.postEvent(new InvocationEvent((Object)Toolkit.getDefaultToolkit(), runnable));
        }
    }

    @Override
    public void createBuffers(int n, BufferCapabilities bufferCapabilities) throws AWTException {
        CGraphicsConfig cGraphicsConfig = (CGraphicsConfig)this.getGraphicsConfiguration();
        cGraphicsConfig.assertOperationSupported((Component)this.fTarget, n, bufferCapabilities);
        try {
            this.replaceSurfaceData(n - 1);
        }
        catch (InvalidPipeException invalidPipeException) {
            throw new AWTException(invalidPipeException.getMessage());
        }
    }

    @Override
    public synchronized void destroyBuffers() {
        this.disposeBackBuffer();
        this.numBackBuffers = 0;
    }

    private synchronized void disposeBackBuffer() {
        if (this.backBuffer == null) {
            return;
        }
        this.backBuffer = null;
    }

    @Override
    public synchronized void flip(int n, int n2, int n3, int n4, BufferCapabilities.FlipContents flipContents) {
        if (this.backBuffer == null) {
            throw new IllegalStateException("Buffers have not been created");
        }
        CGraphicsConfig cGraphicsConfig = (CGraphicsConfig)this.getGraphicsConfiguration();
        cGraphicsConfig.flip(this, (Component)this.fTarget, this.backBuffer, flipContents);
    }

    @Override
    public synchronized Image getBackBuffer() {
        if (this.backBuffer == null) {
            throw new IllegalStateException("Buffers have not been created");
        }
        return this.backBuffer;
    }

    @Override
    public void displayChanged() {
        try {
            this.replaceSurfaceData();
        }
        catch (InvalidPipeException invalidPipeException) {
            // empty catch block
        }
    }

    @Override
    public void paletteChanged() {
    }

    @Override
    public void applyShape(Region region) {
    }

    static {
        SunGraphicsEnvironment sunGraphicsEnvironment = (SunGraphicsEnvironment)GraphicsEnvironment.getLocalGraphicsEnvironment();
        String string = sunGraphicsEnvironment.getDefaultFontFaceName();
        sDefaultFont = new Font(string, 0, 13);
        sDefaultFColor = Color.black;
        sDefaultBColor = Color.white;
    }

    class TemporarySurfaceData
    extends SurfaceData {
        private ComponentModel model;

        private TemporarySurfaceData(ComponentModel componentModel2) {
            super(SurfaceType.Any, ColorModel.getRGBdefault());
            this.model = componentModel2;
        }

        @Override
        public void invalidate() {
        }

        @Override
        public SurfaceData getReplacement() {
            return this.model.getData() > 0L ? ComponentModel.this.createSurfaceData() : this;
        }

        @Override
        public void validatePipe(SunGraphics2D sunGraphics2D) {
            TempPipe tempPipe = new TempPipe(this.model);
            sunGraphics2D.drawpipe = tempPipe;
            sunGraphics2D.fillpipe = tempPipe;
            sunGraphics2D.shapepipe = tempPipe;
            sunGraphics2D.textpipe = tempPipe;
            sunGraphics2D.imagepipe = tempPipe;
        }

        @Override
        public GraphicsConfiguration getDeviceConfiguration() {
            return null;
        }

        @Override
        public Raster getRaster(int n, int n2, int n3, int n4) {
            throw new InternalError("obsolete interface used");
        }

        @Override
        public boolean useTightBBoxes() {
            return false;
        }

        @Override
        public int pixelFor(int n) {
            return n;
        }

        @Override
        public int rgbFor(int n) {
            return n;
        }

        @Override
        public Rectangle getBounds() {
            return new Rectangle();
        }

        @Override
        protected void checkCustomComposite() {
        }

        @Override
        public boolean copyArea(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
            return true;
        }

        @Override
        public Object getDestination() {
            return null;
        }
    }

    class TempPipe
    implements PixelDrawPipe,
    PixelFillPipe,
    ShapeDrawPipe,
    TextPipe,
    DrawImagePipe {
        private ComponentModel model;

        public TempPipe(ComponentModel componentModel2) {
            this.model = componentModel2;
        }

        void validate() {
            if (this.model.getViewPtr() > 0L) {
                throw new InvalidPipeException();
            }
        }

        @Override
        public void drawLine(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
            this.validate();
        }

        @Override
        public void drawRect(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
            this.validate();
        }

        @Override
        public void fillRect(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
            this.validate();
        }

        @Override
        public void drawRoundRect(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
            this.validate();
        }

        @Override
        public void fillRoundRect(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
            this.validate();
        }

        @Override
        public void drawOval(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
            this.validate();
        }

        @Override
        public void fillOval(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
            this.validate();
        }

        @Override
        public void drawArc(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
            this.validate();
        }

        @Override
        public void fillArc(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
            this.validate();
        }

        @Override
        public void drawPolyline(SunGraphics2D sunGraphics2D, int[] nArray, int[] nArray2, int n) {
            this.validate();
        }

        @Override
        public void drawPolygon(SunGraphics2D sunGraphics2D, int[] nArray, int[] nArray2, int n) {
            this.validate();
        }

        @Override
        public void fillPolygon(SunGraphics2D sunGraphics2D, int[] nArray, int[] nArray2, int n) {
            this.validate();
        }

        @Override
        public void draw(SunGraphics2D sunGraphics2D, Shape shape) {
            this.validate();
        }

        @Override
        public void fill(SunGraphics2D sunGraphics2D, Shape shape) {
            this.validate();
        }

        @Override
        public void drawString(SunGraphics2D sunGraphics2D, String string, double d, double d2) {
            this.validate();
        }

        @Override
        public void drawGlyphVector(SunGraphics2D sunGraphics2D, GlyphVector glyphVector, float f, float f2) {
            this.validate();
        }

        @Override
        public void drawChars(SunGraphics2D sunGraphics2D, char[] cArray, int n, int n2, int n3, int n4) {
            this.validate();
        }

        @Override
        public boolean copyImage(SunGraphics2D sunGraphics2D, Image image, int n, int n2, Color color, ImageObserver imageObserver) {
            this.validate();
            return false;
        }

        @Override
        public boolean copyImage(SunGraphics2D sunGraphics2D, Image image, int n, int n2, int n3, int n4, int n5, int n6, Color color, ImageObserver imageObserver) {
            this.validate();
            return false;
        }

        @Override
        public boolean scaleImage(SunGraphics2D sunGraphics2D, Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
            this.validate();
            return false;
        }

        @Override
        public boolean scaleImage(SunGraphics2D sunGraphics2D, Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
            this.validate();
            return false;
        }

        @Override
        public boolean transformImage(SunGraphics2D sunGraphics2D, Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
            this.validate();
            return false;
        }

        @Override
        public void transformImage(SunGraphics2D sunGraphics2D, BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n, int n2) {
            this.validate();
        }
    }
}

