/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import apple.laf.JRSUIConstants;
import apple.laf.JRSUIState;
import com.apple.laf.AquaBorder;
import com.apple.laf.AquaFocusHandler;
import com.apple.laf.AquaUtilControlSize;
import com.apple.laf.AquaUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.UIResource;

public abstract class AquaButtonBorder
extends AquaBorder
implements Border,
UIResource {
    public static final AquaUtils.LazySingleton<Dynamic> fDynamic = new AquaUtils.LazySingletonFromDefaultConstructor<Dynamic>(Dynamic.class);
    private static final AquaUtils.LazySingleton<Toggle> fToggle = new AquaUtils.LazySingletonFromDefaultConstructor<Toggle>(Toggle.class);
    public static final AquaUtils.LazySingleton<Toolbar> fToolBar = new AquaUtils.LazySingletonFromDefaultConstructor<Toolbar>(Toolbar.class);
    public static final AquaUtils.LazySingleton<Named> fBevel = new AquaUtils.LazySingleton<Named>(){

        @Override
        protected Named getInstance() {
            return new Named(JRSUIConstants.Widget.BUTTON_BEVEL, new AquaUtilControlSize.SizeDescriptor(new AquaUtilControlSize.SizeVariant().alterMargins(2, 4, 2, 4)));
        }
    };

    public static AquaButtonBorder getDynamicButtonBorder() {
        return fDynamic.get();
    }

    public static AquaButtonBorder getToggleButtonBorder() {
        return fToggle.get();
    }

    public static Border getToolBarButtonBorder() {
        return fToolBar.get();
    }

    public static AquaButtonBorder getBevelButtonBorder() {
        return fBevel.get();
    }

    public AquaButtonBorder(AquaUtilControlSize.SizeDescriptor sizeDescriptor) {
        super(sizeDescriptor);
    }

    public AquaButtonBorder(AquaButtonBorder aquaButtonBorder) {
        super(aquaButtonBorder);
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
    }

    public void paintButton(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        AbstractButton abstractButton = (AbstractButton)component;
        ButtonModel buttonModel = abstractButton.getModel();
        JRSUIConstants.State state = this.getButtonState(abstractButton, buttonModel);
        ((JRSUIState)this.painter.state).set(state);
        ((JRSUIState)this.painter.state).set(state != JRSUIConstants.State.DISABLED && state != JRSUIConstants.State.INACTIVE && abstractButton.isFocusPainted() && this.isFocused(abstractButton) ? JRSUIConstants.Focused.YES : JRSUIConstants.Focused.NO);
        Insets insets = this.sizeVariant.insets;
        this.doButtonPaint(abstractButton, buttonModel, graphics, n += insets.left, n2 += insets.top, n3 -= insets.left + insets.right, n4 -= insets.top + insets.bottom);
    }

    protected void doButtonPaint(AbstractButton abstractButton, ButtonModel buttonModel, Graphics graphics, int n, int n2, int n3, int n4) {
        this.painter.paint(graphics, abstractButton, n, n2, n3, n4);
    }

    protected JRSUIConstants.State getButtonState(AbstractButton abstractButton, ButtonModel buttonModel) {
        if (!abstractButton.isEnabled()) {
            return JRSUIConstants.State.DISABLED;
        }
        if (!AquaFocusHandler.isActive(abstractButton)) {
            return JRSUIConstants.State.INACTIVE;
        }
        if (buttonModel.isArmed() && buttonModel.isPressed()) {
            return JRSUIConstants.State.PRESSED;
        }
        if (buttonModel.isSelected() && this.isSelectionPressing()) {
            return JRSUIConstants.State.PRESSED;
        }
        if (abstractButton instanceof JButton && ((JButton)abstractButton).isDefaultButton()) {
            return JRSUIConstants.State.PULSED;
        }
        return JRSUIConstants.State.ACTIVE;
    }

    protected boolean isSelectionPressing() {
        return true;
    }

    public boolean hasSmallerInsets(JComponent jComponent) {
        Insets insets = this.sizeVariant.margins;
        Insets insets2 = jComponent.getInsets();
        if (insets.equals(insets2)) {
            return false;
        }
        return insets2.top < insets.top || insets2.left < insets.left || insets2.right < insets.right || insets2.bottom < insets.bottom;
    }

    @Override
    public Insets getBorderInsets(Component component) {
        if (component == null || !(component instanceof AbstractButton)) {
            return new Insets(0, 0, 0, 0);
        }
        Insets insets = ((AbstractButton)component).getMargin();
        insets = insets == null ? new InsetsUIResource(0, 0, 0, 0) : (Insets)insets.clone();
        insets.top += this.sizeVariant.margins.top;
        insets.bottom += this.sizeVariant.margins.bottom;
        insets.left += this.sizeVariant.margins.left;
        insets.right += this.sizeVariant.margins.right;
        return insets;
    }

    public Insets getContentInsets(AbstractButton abstractButton, int n, int n2) {
        return null;
    }

    public void alterPreferredSize(Dimension dimension) {
        if (this.sizeVariant.h > 0 && this.sizeVariant.h > dimension.height) {
            dimension.height = this.sizeVariant.h;
        }
        if (this.sizeVariant.w > 0 && this.sizeVariant.w > dimension.width) {
            dimension.width = this.sizeVariant.w;
        }
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    public static class Toolbar
    extends AquaButtonBorder {
        public Toolbar() {
            super(new AquaUtilControlSize.SizeDescriptor(new AquaUtilControlSize.SizeVariant().alterMargins(5, 5, 5, 5)));
            ((JRSUIState)this.painter.state).set(JRSUIConstants.Widget.TOOLBAR_ITEM_WELL);
        }

        public Toolbar(Toolbar toolbar) {
            super(toolbar);
        }

        @Override
        protected void doButtonPaint(AbstractButton abstractButton, ButtonModel buttonModel, Graphics graphics, int n, int n2, int n3, int n4) {
            if (!buttonModel.isSelected()) {
                return;
            }
            super.doButtonPaint(abstractButton, buttonModel, graphics, n, n2, n3, n4);
        }
    }

    public static class Named
    extends AquaButtonBorder {
        public Named(JRSUIConstants.Widget widget, AquaUtilControlSize.SizeDescriptor sizeDescriptor) {
            super(sizeDescriptor);
            ((JRSUIState)this.painter.state).set(widget);
        }

        public Named(Named named) {
            super(named);
        }

        @Override
        protected void doButtonPaint(AbstractButton abstractButton, ButtonModel buttonModel, Graphics graphics, int n, int n2, int n3, int n4) {
            ((JRSUIState)this.painter.state).set(buttonModel.isSelected() ? JRSUIConstants.BooleanValue.YES : JRSUIConstants.BooleanValue.NO);
            super.doButtonPaint(abstractButton, buttonModel, graphics, n, n2, n3, n4);
        }
    }

    public static class Toggle
    extends AquaButtonBorder {
        public Toggle() {
            super(new AquaUtilControlSize.SizeDescriptor(new AquaUtilControlSize.SizeVariant().alterMargins(6, 6, 6, 6)));
        }

        public Toggle(Toggle toggle) {
            super(toggle);
        }

        @Override
        protected void doButtonPaint(AbstractButton abstractButton, ButtonModel buttonModel, Graphics graphics, int n, int n2, int n3, int n4) {
            if (n4 < 23 || n3 < 16) {
                ((JRSUIState)this.painter.state).set(JRSUIConstants.Widget.BUTTON_BEVEL);
                super.doButtonPaint(abstractButton, buttonModel, graphics, n, n2, n3, n4);
                return;
            }
            ((JRSUIState)this.painter.state).set(JRSUIConstants.Widget.BUTTON_BEVEL_ROUND);
            super.doButtonPaint(abstractButton, buttonModel, graphics, n, n2 + 1, n3, n4 - 1);
        }
    }

    public static class Dynamic
    extends AquaButtonBorder {
        final Insets ALTERNATE_PUSH_INSETS = new Insets(3, 12, 5, 12);
        final Insets ALTERNATE_BEVEL_INSETS = new Insets(0, 5, 0, 5);
        final Insets ALTERNATE_SQUARE_INSETS = new Insets(0, 2, 0, 2);

        public Dynamic() {
            super(new AquaUtilControlSize.SizeDescriptor(new AquaUtilControlSize.SizeVariant(75, 29).alterMargins(3, 20, 5, 20)){

                @Override
                public AquaUtilControlSize.SizeVariant deriveSmall(AquaUtilControlSize.SizeVariant sizeVariant) {
                    return super.deriveSmall(sizeVariant.alterMinSize(0, -2).alterMargins(0, -3, 0, -3).alterInsets(-3, -3, -4, -3));
                }

                @Override
                public AquaUtilControlSize.SizeVariant deriveMini(AquaUtilControlSize.SizeVariant sizeVariant) {
                    return super.deriveMini(sizeVariant.alterMinSize(0, -2).alterMargins(0, -3, 0, -3).alterInsets(-3, -3, -1, -3));
                }
            });
        }

        public Dynamic(Dynamic dynamic) {
            super(dynamic);
        }

        @Override
        protected JRSUIConstants.State getButtonState(AbstractButton abstractButton, ButtonModel buttonModel) {
            JRSUIConstants.State state = super.getButtonState(abstractButton, buttonModel);
            ((JRSUIState)this.painter.state).set(state == JRSUIConstants.State.PULSED ? JRSUIConstants.Animating.YES : JRSUIConstants.Animating.NO);
            return state;
        }

        @Override
        public Insets getContentInsets(AbstractButton abstractButton, int n, int n2) {
            JRSUIConstants.Size size = AquaUtilControlSize.getUserSizeFrom(abstractButton);
            JRSUIConstants.Widget widget = this.getStyleForSize(abstractButton, size, n, n2);
            if (widget == JRSUIConstants.Widget.BUTTON_PUSH) {
                return this.ALTERNATE_PUSH_INSETS;
            }
            if (widget == JRSUIConstants.Widget.BUTTON_BEVEL_ROUND) {
                return this.ALTERNATE_BEVEL_INSETS;
            }
            if (widget == JRSUIConstants.Widget.BUTTON_BEVEL) {
                return this.ALTERNATE_SQUARE_INSETS;
            }
            return null;
        }

        @Override
        protected void doButtonPaint(AbstractButton abstractButton, ButtonModel buttonModel, Graphics graphics, int n, int n2, int n3, int n4) {
            JRSUIConstants.Size size = AquaUtilControlSize.getUserSizeFrom(abstractButton);
            ((JRSUIState)this.painter.state).set(size);
            JRSUIConstants.Widget widget = this.getStyleForSize(abstractButton, size, n3, n4);
            ((JRSUIState)this.painter.state).set(widget);
            if (widget == JRSUIConstants.Widget.BUTTON_PUSH && n2 % 2 == 0) {
                if (size == JRSUIConstants.Size.REGULAR) {
                    ++n2;
                    --n4;
                }
                if (size == JRSUIConstants.Size.MINI) {
                    --n4;
                    n += 4;
                    n3 -= 8;
                }
            }
            super.doButtonPaint(abstractButton, buttonModel, graphics, n, n2, n3, n4);
        }

        protected JRSUIConstants.Widget getStyleForSize(AbstractButton abstractButton, JRSUIConstants.Size size, int n, int n2) {
            if (size != null && size != JRSUIConstants.Size.REGULAR) {
                return JRSUIConstants.Widget.BUTTON_PUSH;
            }
            if (n2 < 23 || n < 16) {
                return JRSUIConstants.Widget.BUTTON_BEVEL;
            }
            if (n2 <= 32 && n < 40) {
                return JRSUIConstants.Widget.BUTTON_BEVEL;
            }
            if (n2 > 32 || abstractButton.getIcon() != null || this.hasSmallerInsets(abstractButton)) {
                return JRSUIConstants.Widget.BUTTON_BEVEL_ROUND;
            }
            return JRSUIConstants.Widget.BUTTON_PUSH;
        }
    }

    static class SizeConstants {
        protected static final int fNormalButtonHeight = 29;
        protected static final int fNormalMinButtonWidth = 40;
        protected static final int fSquareButtonHeightThreshold = 23;
        protected static final int fSquareButtonWidthThreshold = 16;

        SizeConstants() {
        }
    }
}

