/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import apple.laf.JRSUIConstants;
import com.apple.laf.AquaTabbedPaneUI;
import com.apple.laf.AquaUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.text.View;

public class AquaTabbedPaneContrastUI
extends AquaTabbedPaneUI {
    public static ComponentUI createUI(JComponent jComponent) {
        return new AquaTabbedPaneContrastUI();
    }

    @Override
    protected void paintTitle(Graphics2D graphics2D, Font font, FontMetrics fontMetrics, Rectangle rectangle, int n, String string) {
        View view = this.getTextViewForTab(n);
        if (view != null) {
            view.paint(graphics2D, rectangle);
            return;
        }
        if (string == null) {
            return;
        }
        Color color = this.tabPane.getForegroundAt(n);
        if (color instanceof UIResource) {
            graphics2D.setColor(AquaTabbedPaneContrastUI.getNonSelectedTabTitleColor());
            if (this.tabPane.getSelectedIndex() == n) {
                boolean bl = this.isPressedAt(n);
                boolean bl2 = this.tabPane.isEnabled() && this.tabPane.isEnabledAt(n);
                Color color2 = AquaTabbedPaneContrastUI.getSelectedTabTitleColor(bl2, bl);
                Color color3 = AquaTabbedPaneContrastUI.getSelectedTabTitleShadowColor(bl2);
                AquaUtils.paintDropShadowText(graphics2D, font, fontMetrics, rectangle.x, rectangle.y, 0, 1, color2, color3, string);
                return;
            }
        } else {
            graphics2D.setColor(color);
        }
        graphics2D.setFont(font);
        graphics2D.drawString(string, rectangle.x, rectangle.y + fontMetrics.getAscent());
    }

    protected static Color getSelectedTabTitleColor(boolean bl, boolean bl2) {
        if (bl && bl2) {
            return UIManager.getColor("TabbedPane.selectedTabTitlePressedColor");
        }
        if (!bl) {
            return UIManager.getColor("TabbedPane.selectedTabTitleDisabledColor");
        }
        return UIManager.getColor("TabbedPane.selectedTabTitleNormalColor");
    }

    protected static Color getSelectedTabTitleShadowColor(boolean bl) {
        return bl ? UIManager.getColor("TabbedPane.selectedTabTitleShadowNormalColor") : UIManager.getColor("TabbedPane.selectedTabTitleShadowDisabledColor");
    }

    protected static Color getNonSelectedTabTitleColor() {
        return UIManager.getColor("TabbedPane.nonSelectedTabTitleNormalColor");
    }

    protected boolean isPressedAt(int n) {
        return this.pressedTab == n;
    }

    @Override
    protected boolean shouldRepaintSelectedTabOnMouseDown() {
        return true;
    }

    @Override
    protected boolean shouldPressTabsOnMouseDrag() {
        return true;
    }

    @Override
    protected JRSUIConstants.State getState(int n, boolean bl, boolean bl2) {
        boolean bl3 = this.isPressedAt(n);
        boolean bl4 = this.tabPane.isEnabled();
        if (!bl && bl4 && !bl3) {
            return JRSUIConstants.State.INACTIVE;
        }
        if (!bl4) {
            return JRSUIConstants.State.DISABLED;
        }
        if (bl3) {
            return JRSUIConstants.State.PRESSED;
        }
        return JRSUIConstants.State.ACTIVE;
    }

    @Override
    protected JRSUIConstants.SegmentTrailingSeparator getSegmentTrailingSeparator(int n, int n2) {
        if (this.isTabBeforeTab(n, n2) || this.isTabBeforeTab(n, this.pressedTab) && n != n2) {
            return JRSUIConstants.SegmentTrailingSeparator.NO;
        }
        return JRSUIConstants.SegmentTrailingSeparator.YES;
    }

    @Override
    protected JRSUIConstants.SegmentLeadingSeparator getSegmentLeadingSeparator(int n, int n2) {
        if (n == n2 || this.isPressedAt(n) && !this.isTabBeforeTab(n2, n)) {
            return JRSUIConstants.SegmentLeadingSeparator.YES;
        }
        return JRSUIConstants.SegmentLeadingSeparator.NO;
    }
}

