/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import apple.awt.CMenuItem;
import com.apple.laf.AquaIcon;
import com.apple.laf.ScreenMenuItemUI;
import com.apple.laf.ScreenMenuPropertyHandler;
import com.apple.laf.ScreenMenuPropertyListener;
import java.awt.Image;
import java.awt.MenuContainer;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.peer.MenuComponentPeer;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.plaf.ButtonUI;

class ScreenMenuItem
extends MenuItem
implements ActionListener,
ComponentListener,
ScreenMenuPropertyHandler {
    ScreenMenuPropertyListener fListener;
    JMenuItem fMenuItem;

    ScreenMenuItem(JMenuItem jMenuItem) {
        super(jMenuItem.getText());
        this.fMenuItem = jMenuItem;
        this.setEnabled(this.fMenuItem.isEnabled());
        ButtonUI buttonUI = this.fMenuItem.getUI();
        if (buttonUI instanceof ScreenMenuItemUI) {
            ((ScreenMenuItemUI)((Object)buttonUI)).updateListenersForScreenMenuItem();
        }
    }

    @Override
    public void addNotify() {
        ButtonUI buttonUI;
        String string;
        Icon icon;
        super.addNotify();
        this.fMenuItem.addComponentListener(this);
        this.fListener = new ScreenMenuPropertyListener(this);
        this.fMenuItem.addPropertyChangeListener(this.fListener);
        this.addActionListener(this);
        this.setEnabled(this.fMenuItem.isEnabled());
        this.setAccelerator(this.fMenuItem.getAccelerator());
        String string2 = this.fMenuItem.getText();
        if (string2 != null) {
            this.setLabel(string2);
        }
        if ((icon = this.fMenuItem.getIcon()) != null) {
            this.setIcon(icon);
        }
        if ((string = this.fMenuItem.getToolTipText()) != null) {
            this.setToolTipText(string);
        }
        if (this.fMenuItem instanceof JRadioButtonMenuItem && (buttonUI = this.fMenuItem.getUI()) instanceof ScreenMenuItemUI) {
            ((ScreenMenuItemUI)((Object)buttonUI)).updateListenersForScreenMenuItem();
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.removeActionListener(this);
        this.fMenuItem.removePropertyChangeListener(this.fListener);
        this.fListener = null;
        this.fMenuItem.removeComponentListener(this);
    }

    @Override
    public void setAccelerator(KeyStroke keyStroke) {
        if (keyStroke == null) {
            this.setShortcut(null);
            return;
        }
        MenuComponentPeer menuComponentPeer = this.getPeer();
        if (menuComponentPeer instanceof CMenuItem) {
            CMenuItem cMenuItem = (CMenuItem)menuComponentPeer;
            cMenuItem.setLabel(this.fMenuItem.getText(), keyStroke.getKeyChar(), keyStroke.getKeyCode(), keyStroke.getModifiers());
        } else {
            this.setShortcut(new MenuShortcut(keyStroke.getKeyCode(), (keyStroke.getModifiers() & 1) != 0));
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.fMenuItem.doClick(0);
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
        this.setVisible(true);
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
        this.setVisible(false);
    }

    public void setVisible(boolean bl) {
        MenuContainer menuContainer = this.getParent();
        if (menuContainer != null) {
            ((ScreenMenuPropertyHandler)((Object)menuContainer)).setChildVisible(this.fMenuItem, bl);
        }
    }

    @Override
    public void setToolTipText(String string) {
        MenuComponentPeer menuComponentPeer = this.getPeer();
        if (!(menuComponentPeer instanceof CMenuItem)) {
            return;
        }
        CMenuItem cMenuItem = (CMenuItem)menuComponentPeer;
        cMenuItem.setToolTipText(string);
    }

    @Override
    public void setIcon(Icon icon) {
        MenuComponentPeer menuComponentPeer = this.getPeer();
        if (!(menuComponentPeer instanceof CMenuItem)) {
            return;
        }
        CMenuItem cMenuItem = (CMenuItem)menuComponentPeer;
        Image image = null;
        if (icon != null && icon.getIconWidth() > 0 && icon.getIconHeight() > 0) {
            image = AquaIcon.getImageForIcon(icon);
        }
        cMenuItem.setImage(image);
    }

    @Override
    public void setChildVisible(JMenuItem jMenuItem, boolean bl) {
    }

    @Override
    public void setIndeterminate(boolean bl) {
    }
}

