package esmska.gui;

import esmska.data.Config;
import esmska.data.CountryPrefix;
import esmska.data.event.AbstractDocumentListener;
import esmska.utils.L10N;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.GroupLayout.Alignment;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle.ComponentPlacement;
import javax.swing.event.DocumentEvent;
import org.apache.commons.lang.StringUtils;
import org.openide.awt.Mnemonics;

/** Panel containing settings of country prefix
 *
 * @author ripper
 */
public class CountryPrefixPanel extends javax.swing.JPanel {
    private static final ResourceBundle l10n = L10N.l10nBundle;
    private static final Config config = Config.getInstance();

    /** when to take updates seriously */
    private boolean fullyInicialized;

    /** Creates new form CountryPrefixPanel */
    public CountryPrefixPanel() {
        initComponents();

        //end of init
        fullyInicialized = true;

        //set current country prefix
        setCountryPrefix(config.getCountryPrefix());
    }

    /** Set country prefix to display */
    public void setCountryPrefix(String prefix) {
        countryPrefixTextField.setText(prefix);
    }

    /** Get selected country prefix if it's valid or empty string; null otherwise */
    public String getCountryPrefix() {
        String prefix = countryPrefixTextField.getText();
        if (CountryPrefix.isValidCountryPrefix(prefix)) {
            return prefix;
        } else if (StringUtils.isEmpty(prefix)) {
            return "";
        } else {
            return null;
        }
    }

    /** Update country code according to country  */
    private void updateCountryCode() {
        String countryPrefix = countryPrefixTextField.getText();
        String countryCode = CountryPrefix.getCountryCode(countryPrefix);

        boolean temp = fullyInicialized;
        fullyInicialized = false;
        if (StringUtils.isEmpty(countryCode)) {
            countryCodeComboBox.setSelectedIndex(0);
        } else {
            countryCodeComboBox.setSelectedItem(countryCode);
        }
        fullyInicialized = temp;
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        countryCodeComboBox = new JComboBox();
        countryPrefixTextField = new JTextField();
        jLabel4 = new JLabel();
        countryCodeLabel = new JLabel();
        jLabel2 = new JLabel();

        countryCodeComboBox.setToolTipText(l10n.getString("CountryPrefixPanel.countryCodeComboBox.toolTipText")); // NOI18N
        ArrayList<String> codes = CountryPrefix.getCountryCodes();
        codes.add(0, l10n.getString("CountryPrefixPanel.unknown_state"));
        countryCodeComboBox.setModel(new DefaultComboBoxModel(codes.toArray()));
        countryCodeComboBox.setSelectedIndex(0);
        countryCodeComboBox.addItemListener(new ItemListener() {
            public void itemStateChanged(ItemEvent evt) {
                countryCodeComboBoxItemStateChanged(evt);
            }
        });

        countryPrefixTextField.setColumns(5);
        countryPrefixTextField.setToolTipText(l10n.getString("CountryPrefixPanel.countryPrefixTextField.toolTipText")); // NOI18N
        countryPrefixTextField.getDocument().addDocumentListener(new AbstractDocumentListener() {
            @Override
            public void onUpdate(DocumentEvent e) {
                if (!fullyInicialized) {
                    return;
                }
                updateCountryCode();
            }
        });

        Mnemonics.setLocalizedText(jLabel4, ")"); // NOI18N

        countryCodeLabel.setLabelFor(countryCodeComboBox);
        Mnemonics.setLocalizedText(countryCodeLabel, l10n.getString("CountryPrefixPanel.countryCodeLabel.text")); // NOI18N
        countryCodeLabel.setToolTipText(countryCodeComboBox.getToolTipText());

        Mnemonics.setLocalizedText(jLabel2, l10n.getString("CountryPrefixPanel.jLabel2.text")); // NOI18N
        jLabel2.setToolTipText(countryPrefixTextField.getToolTipText());

        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGap(0, 0, 0)
                .addComponent(jLabel2)
                .addPreferredGap(ComponentPlacement.RELATED)
                .addComponent(countryPrefixTextField, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(ComponentPlacement.RELATED)
                .addComponent(countryCodeLabel)
                .addPreferredGap(ComponentPlacement.RELATED)
                .addComponent(countryCodeComboBox, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(ComponentPlacement.RELATED)
                .addComponent(jLabel4))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(Alignment.LEADING)
            .addGroup(layout.createParallelGroup(Alignment.BASELINE)
                .addComponent(jLabel2)
                .addComponent(countryPrefixTextField, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                .addComponent(countryCodeLabel)
                .addComponent(countryCodeComboBox, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                .addComponent(jLabel4))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void countryCodeComboBoxItemStateChanged(ItemEvent evt) {//GEN-FIRST:event_countryCodeComboBoxItemStateChanged
        if (!fullyInicialized || evt.getStateChange() != ItemEvent.SELECTED) {
            return;
        }
        String code = (String) countryCodeComboBox.getSelectedItem();
        String prefix = CountryPrefix.getCountryPrefix(code);

        boolean temp = fullyInicialized;
        fullyInicialized = false;
        countryPrefixTextField.setText(prefix);
        fullyInicialized = temp;
}//GEN-LAST:event_countryCodeComboBoxItemStateChanged


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private JComboBox countryCodeComboBox;
    private JLabel countryCodeLabel;
    private JTextField countryPrefixTextField;
    private JLabel jLabel2;
    private JLabel jLabel4;
    // End of variables declaration//GEN-END:variables

}
