// Code generated by capnpc-go. DO NOT EDIT.

package proto

import (
	capnp "capnproto.org/go/capnp/v3"
	text "capnproto.org/go/capnp/v3/encoding/text"
	schemas "capnproto.org/go/capnp/v3/schemas"
	server "capnproto.org/go/capnp/v3/server"
	context "context"
)

type Conmon struct{ Client *capnp.Client }

// Conmon_TypeID is the unique identifier for the type Conmon.
const Conmon_TypeID = 0xb737e899dd6633f1

func (c Conmon) Version(ctx context.Context, params func(Conmon_version_Params) error) (Conmon_version_Results_Future, capnp.ReleaseFunc) {
	s := capnp.Send{
		Method: capnp.Method{
			InterfaceID:   0xb737e899dd6633f1,
			MethodID:      0,
			InterfaceName: "conmon-rs/common/proto/conmon.capnp:Conmon",
			MethodName:    "version",
		},
	}
	if params != nil {
		s.ArgsSize = capnp.ObjectSize{DataSize: 0, PointerCount: 0}
		s.PlaceArgs = func(s capnp.Struct) error { return params(Conmon_version_Params{Struct: s}) }
	}
	ans, release := c.Client.SendCall(ctx, s)
	return Conmon_version_Results_Future{Future: ans.Future()}, release
}
func (c Conmon) CreateContainer(ctx context.Context, params func(Conmon_createContainer_Params) error) (Conmon_createContainer_Results_Future, capnp.ReleaseFunc) {
	s := capnp.Send{
		Method: capnp.Method{
			InterfaceID:   0xb737e899dd6633f1,
			MethodID:      1,
			InterfaceName: "conmon-rs/common/proto/conmon.capnp:Conmon",
			MethodName:    "createContainer",
		},
	}
	if params != nil {
		s.ArgsSize = capnp.ObjectSize{DataSize: 0, PointerCount: 1}
		s.PlaceArgs = func(s capnp.Struct) error { return params(Conmon_createContainer_Params{Struct: s}) }
	}
	ans, release := c.Client.SendCall(ctx, s)
	return Conmon_createContainer_Results_Future{Future: ans.Future()}, release
}
func (c Conmon) ExecSyncContainer(ctx context.Context, params func(Conmon_execSyncContainer_Params) error) (Conmon_execSyncContainer_Results_Future, capnp.ReleaseFunc) {
	s := capnp.Send{
		Method: capnp.Method{
			InterfaceID:   0xb737e899dd6633f1,
			MethodID:      2,
			InterfaceName: "conmon-rs/common/proto/conmon.capnp:Conmon",
			MethodName:    "execSyncContainer",
		},
	}
	if params != nil {
		s.ArgsSize = capnp.ObjectSize{DataSize: 0, PointerCount: 1}
		s.PlaceArgs = func(s capnp.Struct) error { return params(Conmon_execSyncContainer_Params{Struct: s}) }
	}
	ans, release := c.Client.SendCall(ctx, s)
	return Conmon_execSyncContainer_Results_Future{Future: ans.Future()}, release
}
func (c Conmon) AttachContainer(ctx context.Context, params func(Conmon_attachContainer_Params) error) (Conmon_attachContainer_Results_Future, capnp.ReleaseFunc) {
	s := capnp.Send{
		Method: capnp.Method{
			InterfaceID:   0xb737e899dd6633f1,
			MethodID:      3,
			InterfaceName: "conmon-rs/common/proto/conmon.capnp:Conmon",
			MethodName:    "attachContainer",
		},
	}
	if params != nil {
		s.ArgsSize = capnp.ObjectSize{DataSize: 0, PointerCount: 1}
		s.PlaceArgs = func(s capnp.Struct) error { return params(Conmon_attachContainer_Params{Struct: s}) }
	}
	ans, release := c.Client.SendCall(ctx, s)
	return Conmon_attachContainer_Results_Future{Future: ans.Future()}, release
}
func (c Conmon) ReopenLogContainer(ctx context.Context, params func(Conmon_reopenLogContainer_Params) error) (Conmon_reopenLogContainer_Results_Future, capnp.ReleaseFunc) {
	s := capnp.Send{
		Method: capnp.Method{
			InterfaceID:   0xb737e899dd6633f1,
			MethodID:      4,
			InterfaceName: "conmon-rs/common/proto/conmon.capnp:Conmon",
			MethodName:    "reopenLogContainer",
		},
	}
	if params != nil {
		s.ArgsSize = capnp.ObjectSize{DataSize: 0, PointerCount: 1}
		s.PlaceArgs = func(s capnp.Struct) error { return params(Conmon_reopenLogContainer_Params{Struct: s}) }
	}
	ans, release := c.Client.SendCall(ctx, s)
	return Conmon_reopenLogContainer_Results_Future{Future: ans.Future()}, release
}
func (c Conmon) SetWindowSizeContainer(ctx context.Context, params func(Conmon_setWindowSizeContainer_Params) error) (Conmon_setWindowSizeContainer_Results_Future, capnp.ReleaseFunc) {
	s := capnp.Send{
		Method: capnp.Method{
			InterfaceID:   0xb737e899dd6633f1,
			MethodID:      5,
			InterfaceName: "conmon-rs/common/proto/conmon.capnp:Conmon",
			MethodName:    "setWindowSizeContainer",
		},
	}
	if params != nil {
		s.ArgsSize = capnp.ObjectSize{DataSize: 0, PointerCount: 1}
		s.PlaceArgs = func(s capnp.Struct) error { return params(Conmon_setWindowSizeContainer_Params{Struct: s}) }
	}
	ans, release := c.Client.SendCall(ctx, s)
	return Conmon_setWindowSizeContainer_Results_Future{Future: ans.Future()}, release
}

func (c Conmon) AddRef() Conmon {
	return Conmon{
		Client: c.Client.AddRef(),
	}
}

func (c Conmon) Release() {
	c.Client.Release()
}

// A Conmon_Server is a Conmon with a local implementation.
type Conmon_Server interface {
	Version(context.Context, Conmon_version) error

	CreateContainer(context.Context, Conmon_createContainer) error

	ExecSyncContainer(context.Context, Conmon_execSyncContainer) error

	AttachContainer(context.Context, Conmon_attachContainer) error

	ReopenLogContainer(context.Context, Conmon_reopenLogContainer) error

	SetWindowSizeContainer(context.Context, Conmon_setWindowSizeContainer) error
}

// Conmon_NewServer creates a new Server from an implementation of Conmon_Server.
func Conmon_NewServer(s Conmon_Server, policy *server.Policy) *server.Server {
	c, _ := s.(server.Shutdowner)
	return server.New(Conmon_Methods(nil, s), s, c, policy)
}

// Conmon_ServerToClient creates a new Client from an implementation of Conmon_Server.
// The caller is responsible for calling Release on the returned Client.
func Conmon_ServerToClient(s Conmon_Server, policy *server.Policy) Conmon {
	return Conmon{Client: capnp.NewClient(Conmon_NewServer(s, policy))}
}

// Conmon_Methods appends Methods to a slice that invoke the methods on s.
// This can be used to create a more complicated Server.
func Conmon_Methods(methods []server.Method, s Conmon_Server) []server.Method {
	if cap(methods) == 0 {
		methods = make([]server.Method, 0, 6)
	}

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0xb737e899dd6633f1,
			MethodID:      0,
			InterfaceName: "conmon-rs/common/proto/conmon.capnp:Conmon",
			MethodName:    "version",
		},
		Impl: func(ctx context.Context, call *server.Call) error {
			return s.Version(ctx, Conmon_version{call})
		},
	})

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0xb737e899dd6633f1,
			MethodID:      1,
			InterfaceName: "conmon-rs/common/proto/conmon.capnp:Conmon",
			MethodName:    "createContainer",
		},
		Impl: func(ctx context.Context, call *server.Call) error {
			return s.CreateContainer(ctx, Conmon_createContainer{call})
		},
	})

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0xb737e899dd6633f1,
			MethodID:      2,
			InterfaceName: "conmon-rs/common/proto/conmon.capnp:Conmon",
			MethodName:    "execSyncContainer",
		},
		Impl: func(ctx context.Context, call *server.Call) error {
			return s.ExecSyncContainer(ctx, Conmon_execSyncContainer{call})
		},
	})

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0xb737e899dd6633f1,
			MethodID:      3,
			InterfaceName: "conmon-rs/common/proto/conmon.capnp:Conmon",
			MethodName:    "attachContainer",
		},
		Impl: func(ctx context.Context, call *server.Call) error {
			return s.AttachContainer(ctx, Conmon_attachContainer{call})
		},
	})

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0xb737e899dd6633f1,
			MethodID:      4,
			InterfaceName: "conmon-rs/common/proto/conmon.capnp:Conmon",
			MethodName:    "reopenLogContainer",
		},
		Impl: func(ctx context.Context, call *server.Call) error {
			return s.ReopenLogContainer(ctx, Conmon_reopenLogContainer{call})
		},
	})

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0xb737e899dd6633f1,
			MethodID:      5,
			InterfaceName: "conmon-rs/common/proto/conmon.capnp:Conmon",
			MethodName:    "setWindowSizeContainer",
		},
		Impl: func(ctx context.Context, call *server.Call) error {
			return s.SetWindowSizeContainer(ctx, Conmon_setWindowSizeContainer{call})
		},
	})

	return methods
}

// Conmon_version holds the state for a server call to Conmon.version.
// See server.Call for documentation.
type Conmon_version struct {
	*server.Call
}

// Args returns the call's arguments.
func (c Conmon_version) Args() Conmon_version_Params {
	return Conmon_version_Params{Struct: c.Call.Args()}
}

// AllocResults allocates the results struct.
func (c Conmon_version) AllocResults() (Conmon_version_Results, error) {
	r, err := c.Call.AllocResults(capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_version_Results{Struct: r}, err
}

// Conmon_createContainer holds the state for a server call to Conmon.createContainer.
// See server.Call for documentation.
type Conmon_createContainer struct {
	*server.Call
}

// Args returns the call's arguments.
func (c Conmon_createContainer) Args() Conmon_createContainer_Params {
	return Conmon_createContainer_Params{Struct: c.Call.Args()}
}

// AllocResults allocates the results struct.
func (c Conmon_createContainer) AllocResults() (Conmon_createContainer_Results, error) {
	r, err := c.Call.AllocResults(capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_createContainer_Results{Struct: r}, err
}

// Conmon_execSyncContainer holds the state for a server call to Conmon.execSyncContainer.
// See server.Call for documentation.
type Conmon_execSyncContainer struct {
	*server.Call
}

// Args returns the call's arguments.
func (c Conmon_execSyncContainer) Args() Conmon_execSyncContainer_Params {
	return Conmon_execSyncContainer_Params{Struct: c.Call.Args()}
}

// AllocResults allocates the results struct.
func (c Conmon_execSyncContainer) AllocResults() (Conmon_execSyncContainer_Results, error) {
	r, err := c.Call.AllocResults(capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_execSyncContainer_Results{Struct: r}, err
}

// Conmon_attachContainer holds the state for a server call to Conmon.attachContainer.
// See server.Call for documentation.
type Conmon_attachContainer struct {
	*server.Call
}

// Args returns the call's arguments.
func (c Conmon_attachContainer) Args() Conmon_attachContainer_Params {
	return Conmon_attachContainer_Params{Struct: c.Call.Args()}
}

// AllocResults allocates the results struct.
func (c Conmon_attachContainer) AllocResults() (Conmon_attachContainer_Results, error) {
	r, err := c.Call.AllocResults(capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_attachContainer_Results{Struct: r}, err
}

// Conmon_reopenLogContainer holds the state for a server call to Conmon.reopenLogContainer.
// See server.Call for documentation.
type Conmon_reopenLogContainer struct {
	*server.Call
}

// Args returns the call's arguments.
func (c Conmon_reopenLogContainer) Args() Conmon_reopenLogContainer_Params {
	return Conmon_reopenLogContainer_Params{Struct: c.Call.Args()}
}

// AllocResults allocates the results struct.
func (c Conmon_reopenLogContainer) AllocResults() (Conmon_reopenLogContainer_Results, error) {
	r, err := c.Call.AllocResults(capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_reopenLogContainer_Results{Struct: r}, err
}

// Conmon_setWindowSizeContainer holds the state for a server call to Conmon.setWindowSizeContainer.
// See server.Call for documentation.
type Conmon_setWindowSizeContainer struct {
	*server.Call
}

// Args returns the call's arguments.
func (c Conmon_setWindowSizeContainer) Args() Conmon_setWindowSizeContainer_Params {
	return Conmon_setWindowSizeContainer_Params{Struct: c.Call.Args()}
}

// AllocResults allocates the results struct.
func (c Conmon_setWindowSizeContainer) AllocResults() (Conmon_setWindowSizeContainer_Results, error) {
	r, err := c.Call.AllocResults(capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_setWindowSizeContainer_Results{Struct: r}, err
}

type Conmon_VersionResponse struct{ capnp.Struct }

// Conmon_VersionResponse_TypeID is the unique identifier for the type Conmon_VersionResponse.
const Conmon_VersionResponse_TypeID = 0xf34be5cbac1feed1

func NewConmon_VersionResponse(s *capnp.Segment) (Conmon_VersionResponse, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 5})
	return Conmon_VersionResponse{st}, err
}

func NewRootConmon_VersionResponse(s *capnp.Segment) (Conmon_VersionResponse, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 5})
	return Conmon_VersionResponse{st}, err
}

func ReadRootConmon_VersionResponse(msg *capnp.Message) (Conmon_VersionResponse, error) {
	root, err := msg.Root()
	return Conmon_VersionResponse{root.Struct()}, err
}

func (s Conmon_VersionResponse) String() string {
	str, _ := text.Marshal(0xf34be5cbac1feed1, s.Struct)
	return str
}

func (s Conmon_VersionResponse) Version() (string, error) {
	p, err := s.Struct.Ptr(0)
	return p.Text(), err
}

func (s Conmon_VersionResponse) HasVersion() bool {
	return s.Struct.HasPtr(0)
}

func (s Conmon_VersionResponse) VersionBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return p.TextBytes(), err
}

func (s Conmon_VersionResponse) SetVersion(v string) error {
	return s.Struct.SetText(0, v)
}

func (s Conmon_VersionResponse) Tag() (string, error) {
	p, err := s.Struct.Ptr(1)
	return p.Text(), err
}

func (s Conmon_VersionResponse) HasTag() bool {
	return s.Struct.HasPtr(1)
}

func (s Conmon_VersionResponse) TagBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(1)
	return p.TextBytes(), err
}

func (s Conmon_VersionResponse) SetTag(v string) error {
	return s.Struct.SetText(1, v)
}

func (s Conmon_VersionResponse) Commit() (string, error) {
	p, err := s.Struct.Ptr(2)
	return p.Text(), err
}

func (s Conmon_VersionResponse) HasCommit() bool {
	return s.Struct.HasPtr(2)
}

func (s Conmon_VersionResponse) CommitBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(2)
	return p.TextBytes(), err
}

func (s Conmon_VersionResponse) SetCommit(v string) error {
	return s.Struct.SetText(2, v)
}

func (s Conmon_VersionResponse) BuildDate() (string, error) {
	p, err := s.Struct.Ptr(3)
	return p.Text(), err
}

func (s Conmon_VersionResponse) HasBuildDate() bool {
	return s.Struct.HasPtr(3)
}

func (s Conmon_VersionResponse) BuildDateBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(3)
	return p.TextBytes(), err
}

func (s Conmon_VersionResponse) SetBuildDate(v string) error {
	return s.Struct.SetText(3, v)
}

func (s Conmon_VersionResponse) RustVersion() (string, error) {
	p, err := s.Struct.Ptr(4)
	return p.Text(), err
}

func (s Conmon_VersionResponse) HasRustVersion() bool {
	return s.Struct.HasPtr(4)
}

func (s Conmon_VersionResponse) RustVersionBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(4)
	return p.TextBytes(), err
}

func (s Conmon_VersionResponse) SetRustVersion(v string) error {
	return s.Struct.SetText(4, v)
}

func (s Conmon_VersionResponse) ProcessId() uint32 {
	return s.Struct.Uint32(0)
}

func (s Conmon_VersionResponse) SetProcessId(v uint32) {
	s.Struct.SetUint32(0, v)
}

// Conmon_VersionResponse_List is a list of Conmon_VersionResponse.
type Conmon_VersionResponse_List = capnp.StructList[Conmon_VersionResponse]

// NewConmon_VersionResponse creates a new list of Conmon_VersionResponse.
func NewConmon_VersionResponse_List(s *capnp.Segment, sz int32) (Conmon_VersionResponse_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 5}, sz)
	return capnp.StructList[Conmon_VersionResponse]{l}, err
}

// Conmon_VersionResponse_Future is a wrapper for a Conmon_VersionResponse promised by a client call.
type Conmon_VersionResponse_Future struct{ *capnp.Future }

func (p Conmon_VersionResponse_Future) Struct() (Conmon_VersionResponse, error) {
	s, err := p.Future.Struct()
	return Conmon_VersionResponse{s}, err
}

type Conmon_CreateContainerRequest struct{ capnp.Struct }

// Conmon_CreateContainerRequest_TypeID is the unique identifier for the type Conmon_CreateContainerRequest.
const Conmon_CreateContainerRequest_TypeID = 0xba77e3fa3aa9b6ca

func NewConmon_CreateContainerRequest(s *capnp.Segment) (Conmon_CreateContainerRequest, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 5})
	return Conmon_CreateContainerRequest{st}, err
}

func NewRootConmon_CreateContainerRequest(s *capnp.Segment) (Conmon_CreateContainerRequest, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 5})
	return Conmon_CreateContainerRequest{st}, err
}

func ReadRootConmon_CreateContainerRequest(msg *capnp.Message) (Conmon_CreateContainerRequest, error) {
	root, err := msg.Root()
	return Conmon_CreateContainerRequest{root.Struct()}, err
}

func (s Conmon_CreateContainerRequest) String() string {
	str, _ := text.Marshal(0xba77e3fa3aa9b6ca, s.Struct)
	return str
}

func (s Conmon_CreateContainerRequest) Id() (string, error) {
	p, err := s.Struct.Ptr(0)
	return p.Text(), err
}

func (s Conmon_CreateContainerRequest) HasId() bool {
	return s.Struct.HasPtr(0)
}

func (s Conmon_CreateContainerRequest) IdBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return p.TextBytes(), err
}

func (s Conmon_CreateContainerRequest) SetId(v string) error {
	return s.Struct.SetText(0, v)
}

func (s Conmon_CreateContainerRequest) BundlePath() (string, error) {
	p, err := s.Struct.Ptr(1)
	return p.Text(), err
}

func (s Conmon_CreateContainerRequest) HasBundlePath() bool {
	return s.Struct.HasPtr(1)
}

func (s Conmon_CreateContainerRequest) BundlePathBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(1)
	return p.TextBytes(), err
}

func (s Conmon_CreateContainerRequest) SetBundlePath(v string) error {
	return s.Struct.SetText(1, v)
}

func (s Conmon_CreateContainerRequest) Terminal() bool {
	return s.Struct.Bit(0)
}

func (s Conmon_CreateContainerRequest) SetTerminal(v bool) {
	s.Struct.SetBit(0, v)
}

func (s Conmon_CreateContainerRequest) ExitPaths() (capnp.TextList, error) {
	p, err := s.Struct.Ptr(2)
	return capnp.TextList{List: p.List()}, err
}

func (s Conmon_CreateContainerRequest) HasExitPaths() bool {
	return s.Struct.HasPtr(2)
}

func (s Conmon_CreateContainerRequest) SetExitPaths(v capnp.TextList) error {
	return s.Struct.SetPtr(2, v.List.ToPtr())
}

// NewExitPaths sets the exitPaths field to a newly
// allocated capnp.TextList, preferring placement in s's segment.
func (s Conmon_CreateContainerRequest) NewExitPaths(n int32) (capnp.TextList, error) {
	l, err := capnp.NewTextList(s.Struct.Segment(), n)
	if err != nil {
		return capnp.TextList{}, err
	}
	err = s.Struct.SetPtr(2, l.List.ToPtr())
	return l, err
}

func (s Conmon_CreateContainerRequest) OomExitPaths() (capnp.TextList, error) {
	p, err := s.Struct.Ptr(3)
	return capnp.TextList{List: p.List()}, err
}

func (s Conmon_CreateContainerRequest) HasOomExitPaths() bool {
	return s.Struct.HasPtr(3)
}

func (s Conmon_CreateContainerRequest) SetOomExitPaths(v capnp.TextList) error {
	return s.Struct.SetPtr(3, v.List.ToPtr())
}

// NewOomExitPaths sets the oomExitPaths field to a newly
// allocated capnp.TextList, preferring placement in s's segment.
func (s Conmon_CreateContainerRequest) NewOomExitPaths(n int32) (capnp.TextList, error) {
	l, err := capnp.NewTextList(s.Struct.Segment(), n)
	if err != nil {
		return capnp.TextList{}, err
	}
	err = s.Struct.SetPtr(3, l.List.ToPtr())
	return l, err
}

func (s Conmon_CreateContainerRequest) LogDrivers() (Conmon_LogDriver_List, error) {
	p, err := s.Struct.Ptr(4)
	return Conmon_LogDriver_List{List: p.List()}, err
}

func (s Conmon_CreateContainerRequest) HasLogDrivers() bool {
	return s.Struct.HasPtr(4)
}

func (s Conmon_CreateContainerRequest) SetLogDrivers(v Conmon_LogDriver_List) error {
	return s.Struct.SetPtr(4, v.List.ToPtr())
}

// NewLogDrivers sets the logDrivers field to a newly
// allocated Conmon_LogDriver_List, preferring placement in s's segment.
func (s Conmon_CreateContainerRequest) NewLogDrivers(n int32) (Conmon_LogDriver_List, error) {
	l, err := NewConmon_LogDriver_List(s.Struct.Segment(), n)
	if err != nil {
		return Conmon_LogDriver_List{}, err
	}
	err = s.Struct.SetPtr(4, l.List.ToPtr())
	return l, err
}

// Conmon_CreateContainerRequest_List is a list of Conmon_CreateContainerRequest.
type Conmon_CreateContainerRequest_List = capnp.StructList[Conmon_CreateContainerRequest]

// NewConmon_CreateContainerRequest creates a new list of Conmon_CreateContainerRequest.
func NewConmon_CreateContainerRequest_List(s *capnp.Segment, sz int32) (Conmon_CreateContainerRequest_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 5}, sz)
	return capnp.StructList[Conmon_CreateContainerRequest]{l}, err
}

// Conmon_CreateContainerRequest_Future is a wrapper for a Conmon_CreateContainerRequest promised by a client call.
type Conmon_CreateContainerRequest_Future struct{ *capnp.Future }

func (p Conmon_CreateContainerRequest_Future) Struct() (Conmon_CreateContainerRequest, error) {
	s, err := p.Future.Struct()
	return Conmon_CreateContainerRequest{s}, err
}

type Conmon_LogDriver struct{ capnp.Struct }

// Conmon_LogDriver_TypeID is the unique identifier for the type Conmon_LogDriver.
const Conmon_LogDriver_TypeID = 0xae78ee8eb6b3a134

func NewConmon_LogDriver(s *capnp.Segment) (Conmon_LogDriver, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return Conmon_LogDriver{st}, err
}

func NewRootConmon_LogDriver(s *capnp.Segment) (Conmon_LogDriver, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return Conmon_LogDriver{st}, err
}

func ReadRootConmon_LogDriver(msg *capnp.Message) (Conmon_LogDriver, error) {
	root, err := msg.Root()
	return Conmon_LogDriver{root.Struct()}, err
}

func (s Conmon_LogDriver) String() string {
	str, _ := text.Marshal(0xae78ee8eb6b3a134, s.Struct)
	return str
}

func (s Conmon_LogDriver) Type() Conmon_LogDriver_Type {
	return Conmon_LogDriver_Type(s.Struct.Uint16(0))
}

func (s Conmon_LogDriver) SetType(v Conmon_LogDriver_Type) {
	s.Struct.SetUint16(0, uint16(v))
}

func (s Conmon_LogDriver) Path() (string, error) {
	p, err := s.Struct.Ptr(0)
	return p.Text(), err
}

func (s Conmon_LogDriver) HasPath() bool {
	return s.Struct.HasPtr(0)
}

func (s Conmon_LogDriver) PathBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return p.TextBytes(), err
}

func (s Conmon_LogDriver) SetPath(v string) error {
	return s.Struct.SetText(0, v)
}

// Conmon_LogDriver_List is a list of Conmon_LogDriver.
type Conmon_LogDriver_List = capnp.StructList[Conmon_LogDriver]

// NewConmon_LogDriver creates a new list of Conmon_LogDriver.
func NewConmon_LogDriver_List(s *capnp.Segment, sz int32) (Conmon_LogDriver_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1}, sz)
	return capnp.StructList[Conmon_LogDriver]{l}, err
}

// Conmon_LogDriver_Future is a wrapper for a Conmon_LogDriver promised by a client call.
type Conmon_LogDriver_Future struct{ *capnp.Future }

func (p Conmon_LogDriver_Future) Struct() (Conmon_LogDriver, error) {
	s, err := p.Future.Struct()
	return Conmon_LogDriver{s}, err
}

type Conmon_LogDriver_Type uint16

// Conmon_LogDriver_Type_TypeID is the unique identifier for the type Conmon_LogDriver_Type.
const Conmon_LogDriver_Type_TypeID = 0xf026e3d750335bc1

// Values of Conmon_LogDriver_Type.
const (
	Conmon_LogDriver_Type_containerRuntimeInterface Conmon_LogDriver_Type = 0
)

// String returns the enum's constant name.
func (c Conmon_LogDriver_Type) String() string {
	switch c {
	case Conmon_LogDriver_Type_containerRuntimeInterface:
		return "containerRuntimeInterface"

	default:
		return ""
	}
}

// Conmon_LogDriver_TypeFromString returns the enum value with a name,
// or the zero value if there's no such value.
func Conmon_LogDriver_TypeFromString(c string) Conmon_LogDriver_Type {
	switch c {
	case "containerRuntimeInterface":
		return Conmon_LogDriver_Type_containerRuntimeInterface

	default:
		return 0
	}
}

type Conmon_LogDriver_Type_List = capnp.EnumList[Conmon_LogDriver_Type]

func NewConmon_LogDriver_Type_List(s *capnp.Segment, sz int32) (Conmon_LogDriver_Type_List, error) {
	return capnp.NewEnumList[Conmon_LogDriver_Type](s, sz)
}

type Conmon_CreateContainerResponse struct{ capnp.Struct }

// Conmon_CreateContainerResponse_TypeID is the unique identifier for the type Conmon_CreateContainerResponse.
const Conmon_CreateContainerResponse_TypeID = 0xde3a625e70772b9a

func NewConmon_CreateContainerResponse(s *capnp.Segment) (Conmon_CreateContainerResponse, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 0})
	return Conmon_CreateContainerResponse{st}, err
}

func NewRootConmon_CreateContainerResponse(s *capnp.Segment) (Conmon_CreateContainerResponse, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 0})
	return Conmon_CreateContainerResponse{st}, err
}

func ReadRootConmon_CreateContainerResponse(msg *capnp.Message) (Conmon_CreateContainerResponse, error) {
	root, err := msg.Root()
	return Conmon_CreateContainerResponse{root.Struct()}, err
}

func (s Conmon_CreateContainerResponse) String() string {
	str, _ := text.Marshal(0xde3a625e70772b9a, s.Struct)
	return str
}

func (s Conmon_CreateContainerResponse) ContainerPid() uint32 {
	return s.Struct.Uint32(0)
}

func (s Conmon_CreateContainerResponse) SetContainerPid(v uint32) {
	s.Struct.SetUint32(0, v)
}

// Conmon_CreateContainerResponse_List is a list of Conmon_CreateContainerResponse.
type Conmon_CreateContainerResponse_List = capnp.StructList[Conmon_CreateContainerResponse]

// NewConmon_CreateContainerResponse creates a new list of Conmon_CreateContainerResponse.
func NewConmon_CreateContainerResponse_List(s *capnp.Segment, sz int32) (Conmon_CreateContainerResponse_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 0}, sz)
	return capnp.StructList[Conmon_CreateContainerResponse]{l}, err
}

// Conmon_CreateContainerResponse_Future is a wrapper for a Conmon_CreateContainerResponse promised by a client call.
type Conmon_CreateContainerResponse_Future struct{ *capnp.Future }

func (p Conmon_CreateContainerResponse_Future) Struct() (Conmon_CreateContainerResponse, error) {
	s, err := p.Future.Struct()
	return Conmon_CreateContainerResponse{s}, err
}

type Conmon_ExecSyncContainerRequest struct{ capnp.Struct }

// Conmon_ExecSyncContainerRequest_TypeID is the unique identifier for the type Conmon_ExecSyncContainerRequest.
const Conmon_ExecSyncContainerRequest_TypeID = 0xf41122f890a371a6

func NewConmon_ExecSyncContainerRequest(s *capnp.Segment) (Conmon_ExecSyncContainerRequest, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 16, PointerCount: 2})
	return Conmon_ExecSyncContainerRequest{st}, err
}

func NewRootConmon_ExecSyncContainerRequest(s *capnp.Segment) (Conmon_ExecSyncContainerRequest, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 16, PointerCount: 2})
	return Conmon_ExecSyncContainerRequest{st}, err
}

func ReadRootConmon_ExecSyncContainerRequest(msg *capnp.Message) (Conmon_ExecSyncContainerRequest, error) {
	root, err := msg.Root()
	return Conmon_ExecSyncContainerRequest{root.Struct()}, err
}

func (s Conmon_ExecSyncContainerRequest) String() string {
	str, _ := text.Marshal(0xf41122f890a371a6, s.Struct)
	return str
}

func (s Conmon_ExecSyncContainerRequest) Id() (string, error) {
	p, err := s.Struct.Ptr(0)
	return p.Text(), err
}

func (s Conmon_ExecSyncContainerRequest) HasId() bool {
	return s.Struct.HasPtr(0)
}

func (s Conmon_ExecSyncContainerRequest) IdBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return p.TextBytes(), err
}

func (s Conmon_ExecSyncContainerRequest) SetId(v string) error {
	return s.Struct.SetText(0, v)
}

func (s Conmon_ExecSyncContainerRequest) TimeoutSec() uint64 {
	return s.Struct.Uint64(0)
}

func (s Conmon_ExecSyncContainerRequest) SetTimeoutSec(v uint64) {
	s.Struct.SetUint64(0, v)
}

func (s Conmon_ExecSyncContainerRequest) Command() (capnp.TextList, error) {
	p, err := s.Struct.Ptr(1)
	return capnp.TextList{List: p.List()}, err
}

func (s Conmon_ExecSyncContainerRequest) HasCommand() bool {
	return s.Struct.HasPtr(1)
}

func (s Conmon_ExecSyncContainerRequest) SetCommand(v capnp.TextList) error {
	return s.Struct.SetPtr(1, v.List.ToPtr())
}

// NewCommand sets the command field to a newly
// allocated capnp.TextList, preferring placement in s's segment.
func (s Conmon_ExecSyncContainerRequest) NewCommand(n int32) (capnp.TextList, error) {
	l, err := capnp.NewTextList(s.Struct.Segment(), n)
	if err != nil {
		return capnp.TextList{}, err
	}
	err = s.Struct.SetPtr(1, l.List.ToPtr())
	return l, err
}

func (s Conmon_ExecSyncContainerRequest) Terminal() bool {
	return s.Struct.Bit(64)
}

func (s Conmon_ExecSyncContainerRequest) SetTerminal(v bool) {
	s.Struct.SetBit(64, v)
}

// Conmon_ExecSyncContainerRequest_List is a list of Conmon_ExecSyncContainerRequest.
type Conmon_ExecSyncContainerRequest_List = capnp.StructList[Conmon_ExecSyncContainerRequest]

// NewConmon_ExecSyncContainerRequest creates a new list of Conmon_ExecSyncContainerRequest.
func NewConmon_ExecSyncContainerRequest_List(s *capnp.Segment, sz int32) (Conmon_ExecSyncContainerRequest_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 16, PointerCount: 2}, sz)
	return capnp.StructList[Conmon_ExecSyncContainerRequest]{l}, err
}

// Conmon_ExecSyncContainerRequest_Future is a wrapper for a Conmon_ExecSyncContainerRequest promised by a client call.
type Conmon_ExecSyncContainerRequest_Future struct{ *capnp.Future }

func (p Conmon_ExecSyncContainerRequest_Future) Struct() (Conmon_ExecSyncContainerRequest, error) {
	s, err := p.Future.Struct()
	return Conmon_ExecSyncContainerRequest{s}, err
}

type Conmon_ExecSyncContainerResponse struct{ capnp.Struct }

// Conmon_ExecSyncContainerResponse_TypeID is the unique identifier for the type Conmon_ExecSyncContainerResponse.
const Conmon_ExecSyncContainerResponse_TypeID = 0xd9d61d1d803c85fc

func NewConmon_ExecSyncContainerResponse(s *capnp.Segment) (Conmon_ExecSyncContainerResponse, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 2})
	return Conmon_ExecSyncContainerResponse{st}, err
}

func NewRootConmon_ExecSyncContainerResponse(s *capnp.Segment) (Conmon_ExecSyncContainerResponse, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 2})
	return Conmon_ExecSyncContainerResponse{st}, err
}

func ReadRootConmon_ExecSyncContainerResponse(msg *capnp.Message) (Conmon_ExecSyncContainerResponse, error) {
	root, err := msg.Root()
	return Conmon_ExecSyncContainerResponse{root.Struct()}, err
}

func (s Conmon_ExecSyncContainerResponse) String() string {
	str, _ := text.Marshal(0xd9d61d1d803c85fc, s.Struct)
	return str
}

func (s Conmon_ExecSyncContainerResponse) ExitCode() int32 {
	return int32(s.Struct.Uint32(0))
}

func (s Conmon_ExecSyncContainerResponse) SetExitCode(v int32) {
	s.Struct.SetUint32(0, uint32(v))
}

func (s Conmon_ExecSyncContainerResponse) Stdout() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return []byte(p.Data()), err
}

func (s Conmon_ExecSyncContainerResponse) HasStdout() bool {
	return s.Struct.HasPtr(0)
}

func (s Conmon_ExecSyncContainerResponse) SetStdout(v []byte) error {
	return s.Struct.SetData(0, v)
}

func (s Conmon_ExecSyncContainerResponse) Stderr() ([]byte, error) {
	p, err := s.Struct.Ptr(1)
	return []byte(p.Data()), err
}

func (s Conmon_ExecSyncContainerResponse) HasStderr() bool {
	return s.Struct.HasPtr(1)
}

func (s Conmon_ExecSyncContainerResponse) SetStderr(v []byte) error {
	return s.Struct.SetData(1, v)
}

func (s Conmon_ExecSyncContainerResponse) TimedOut() bool {
	return s.Struct.Bit(32)
}

func (s Conmon_ExecSyncContainerResponse) SetTimedOut(v bool) {
	s.Struct.SetBit(32, v)
}

// Conmon_ExecSyncContainerResponse_List is a list of Conmon_ExecSyncContainerResponse.
type Conmon_ExecSyncContainerResponse_List = capnp.StructList[Conmon_ExecSyncContainerResponse]

// NewConmon_ExecSyncContainerResponse creates a new list of Conmon_ExecSyncContainerResponse.
func NewConmon_ExecSyncContainerResponse_List(s *capnp.Segment, sz int32) (Conmon_ExecSyncContainerResponse_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 2}, sz)
	return capnp.StructList[Conmon_ExecSyncContainerResponse]{l}, err
}

// Conmon_ExecSyncContainerResponse_Future is a wrapper for a Conmon_ExecSyncContainerResponse promised by a client call.
type Conmon_ExecSyncContainerResponse_Future struct{ *capnp.Future }

func (p Conmon_ExecSyncContainerResponse_Future) Struct() (Conmon_ExecSyncContainerResponse, error) {
	s, err := p.Future.Struct()
	return Conmon_ExecSyncContainerResponse{s}, err
}

type Conmon_AttachRequest struct{ capnp.Struct }

// Conmon_AttachRequest_TypeID is the unique identifier for the type Conmon_AttachRequest.
const Conmon_AttachRequest_TypeID = 0xdf703ca0befc3afc

func NewConmon_AttachRequest(s *capnp.Segment) (Conmon_AttachRequest, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 3})
	return Conmon_AttachRequest{st}, err
}

func NewRootConmon_AttachRequest(s *capnp.Segment) (Conmon_AttachRequest, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 3})
	return Conmon_AttachRequest{st}, err
}

func ReadRootConmon_AttachRequest(msg *capnp.Message) (Conmon_AttachRequest, error) {
	root, err := msg.Root()
	return Conmon_AttachRequest{root.Struct()}, err
}

func (s Conmon_AttachRequest) String() string {
	str, _ := text.Marshal(0xdf703ca0befc3afc, s.Struct)
	return str
}

func (s Conmon_AttachRequest) Id() (string, error) {
	p, err := s.Struct.Ptr(0)
	return p.Text(), err
}

func (s Conmon_AttachRequest) HasId() bool {
	return s.Struct.HasPtr(0)
}

func (s Conmon_AttachRequest) IdBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return p.TextBytes(), err
}

func (s Conmon_AttachRequest) SetId(v string) error {
	return s.Struct.SetText(0, v)
}

func (s Conmon_AttachRequest) SocketPath() (string, error) {
	p, err := s.Struct.Ptr(1)
	return p.Text(), err
}

func (s Conmon_AttachRequest) HasSocketPath() bool {
	return s.Struct.HasPtr(1)
}

func (s Conmon_AttachRequest) SocketPathBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(1)
	return p.TextBytes(), err
}

func (s Conmon_AttachRequest) SetSocketPath(v string) error {
	return s.Struct.SetText(1, v)
}

func (s Conmon_AttachRequest) ExecSessionId() (string, error) {
	p, err := s.Struct.Ptr(2)
	return p.Text(), err
}

func (s Conmon_AttachRequest) HasExecSessionId() bool {
	return s.Struct.HasPtr(2)
}

func (s Conmon_AttachRequest) ExecSessionIdBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(2)
	return p.TextBytes(), err
}

func (s Conmon_AttachRequest) SetExecSessionId(v string) error {
	return s.Struct.SetText(2, v)
}

// Conmon_AttachRequest_List is a list of Conmon_AttachRequest.
type Conmon_AttachRequest_List = capnp.StructList[Conmon_AttachRequest]

// NewConmon_AttachRequest creates a new list of Conmon_AttachRequest.
func NewConmon_AttachRequest_List(s *capnp.Segment, sz int32) (Conmon_AttachRequest_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 3}, sz)
	return capnp.StructList[Conmon_AttachRequest]{l}, err
}

// Conmon_AttachRequest_Future is a wrapper for a Conmon_AttachRequest promised by a client call.
type Conmon_AttachRequest_Future struct{ *capnp.Future }

func (p Conmon_AttachRequest_Future) Struct() (Conmon_AttachRequest, error) {
	s, err := p.Future.Struct()
	return Conmon_AttachRequest{s}, err
}

type Conmon_AttachResponse struct{ capnp.Struct }

// Conmon_AttachResponse_TypeID is the unique identifier for the type Conmon_AttachResponse.
const Conmon_AttachResponse_TypeID = 0xace5517aafc86077

func NewConmon_AttachResponse(s *capnp.Segment) (Conmon_AttachResponse, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return Conmon_AttachResponse{st}, err
}

func NewRootConmon_AttachResponse(s *capnp.Segment) (Conmon_AttachResponse, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return Conmon_AttachResponse{st}, err
}

func ReadRootConmon_AttachResponse(msg *capnp.Message) (Conmon_AttachResponse, error) {
	root, err := msg.Root()
	return Conmon_AttachResponse{root.Struct()}, err
}

func (s Conmon_AttachResponse) String() string {
	str, _ := text.Marshal(0xace5517aafc86077, s.Struct)
	return str
}

// Conmon_AttachResponse_List is a list of Conmon_AttachResponse.
type Conmon_AttachResponse_List = capnp.StructList[Conmon_AttachResponse]

// NewConmon_AttachResponse creates a new list of Conmon_AttachResponse.
func NewConmon_AttachResponse_List(s *capnp.Segment, sz int32) (Conmon_AttachResponse_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0}, sz)
	return capnp.StructList[Conmon_AttachResponse]{l}, err
}

// Conmon_AttachResponse_Future is a wrapper for a Conmon_AttachResponse promised by a client call.
type Conmon_AttachResponse_Future struct{ *capnp.Future }

func (p Conmon_AttachResponse_Future) Struct() (Conmon_AttachResponse, error) {
	s, err := p.Future.Struct()
	return Conmon_AttachResponse{s}, err
}

type Conmon_ReopenLogRequest struct{ capnp.Struct }

// Conmon_ReopenLogRequest_TypeID is the unique identifier for the type Conmon_ReopenLogRequest.
const Conmon_ReopenLogRequest_TypeID = 0xd0476e0f34d1411a

func NewConmon_ReopenLogRequest(s *capnp.Segment) (Conmon_ReopenLogRequest, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_ReopenLogRequest{st}, err
}

func NewRootConmon_ReopenLogRequest(s *capnp.Segment) (Conmon_ReopenLogRequest, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_ReopenLogRequest{st}, err
}

func ReadRootConmon_ReopenLogRequest(msg *capnp.Message) (Conmon_ReopenLogRequest, error) {
	root, err := msg.Root()
	return Conmon_ReopenLogRequest{root.Struct()}, err
}

func (s Conmon_ReopenLogRequest) String() string {
	str, _ := text.Marshal(0xd0476e0f34d1411a, s.Struct)
	return str
}

func (s Conmon_ReopenLogRequest) Id() (string, error) {
	p, err := s.Struct.Ptr(0)
	return p.Text(), err
}

func (s Conmon_ReopenLogRequest) HasId() bool {
	return s.Struct.HasPtr(0)
}

func (s Conmon_ReopenLogRequest) IdBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return p.TextBytes(), err
}

func (s Conmon_ReopenLogRequest) SetId(v string) error {
	return s.Struct.SetText(0, v)
}

// Conmon_ReopenLogRequest_List is a list of Conmon_ReopenLogRequest.
type Conmon_ReopenLogRequest_List = capnp.StructList[Conmon_ReopenLogRequest]

// NewConmon_ReopenLogRequest creates a new list of Conmon_ReopenLogRequest.
func NewConmon_ReopenLogRequest_List(s *capnp.Segment, sz int32) (Conmon_ReopenLogRequest_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return capnp.StructList[Conmon_ReopenLogRequest]{l}, err
}

// Conmon_ReopenLogRequest_Future is a wrapper for a Conmon_ReopenLogRequest promised by a client call.
type Conmon_ReopenLogRequest_Future struct{ *capnp.Future }

func (p Conmon_ReopenLogRequest_Future) Struct() (Conmon_ReopenLogRequest, error) {
	s, err := p.Future.Struct()
	return Conmon_ReopenLogRequest{s}, err
}

type Conmon_ReopenLogResponse struct{ capnp.Struct }

// Conmon_ReopenLogResponse_TypeID is the unique identifier for the type Conmon_ReopenLogResponse.
const Conmon_ReopenLogResponse_TypeID = 0xa20f49456be85b99

func NewConmon_ReopenLogResponse(s *capnp.Segment) (Conmon_ReopenLogResponse, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return Conmon_ReopenLogResponse{st}, err
}

func NewRootConmon_ReopenLogResponse(s *capnp.Segment) (Conmon_ReopenLogResponse, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return Conmon_ReopenLogResponse{st}, err
}

func ReadRootConmon_ReopenLogResponse(msg *capnp.Message) (Conmon_ReopenLogResponse, error) {
	root, err := msg.Root()
	return Conmon_ReopenLogResponse{root.Struct()}, err
}

func (s Conmon_ReopenLogResponse) String() string {
	str, _ := text.Marshal(0xa20f49456be85b99, s.Struct)
	return str
}

// Conmon_ReopenLogResponse_List is a list of Conmon_ReopenLogResponse.
type Conmon_ReopenLogResponse_List = capnp.StructList[Conmon_ReopenLogResponse]

// NewConmon_ReopenLogResponse creates a new list of Conmon_ReopenLogResponse.
func NewConmon_ReopenLogResponse_List(s *capnp.Segment, sz int32) (Conmon_ReopenLogResponse_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0}, sz)
	return capnp.StructList[Conmon_ReopenLogResponse]{l}, err
}

// Conmon_ReopenLogResponse_Future is a wrapper for a Conmon_ReopenLogResponse promised by a client call.
type Conmon_ReopenLogResponse_Future struct{ *capnp.Future }

func (p Conmon_ReopenLogResponse_Future) Struct() (Conmon_ReopenLogResponse, error) {
	s, err := p.Future.Struct()
	return Conmon_ReopenLogResponse{s}, err
}

type Conmon_SetWindowSizeRequest struct{ capnp.Struct }

// Conmon_SetWindowSizeRequest_TypeID is the unique identifier for the type Conmon_SetWindowSizeRequest.
const Conmon_SetWindowSizeRequest_TypeID = 0xb5418b8ea8ead17b

func NewConmon_SetWindowSizeRequest(s *capnp.Segment) (Conmon_SetWindowSizeRequest, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return Conmon_SetWindowSizeRequest{st}, err
}

func NewRootConmon_SetWindowSizeRequest(s *capnp.Segment) (Conmon_SetWindowSizeRequest, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return Conmon_SetWindowSizeRequest{st}, err
}

func ReadRootConmon_SetWindowSizeRequest(msg *capnp.Message) (Conmon_SetWindowSizeRequest, error) {
	root, err := msg.Root()
	return Conmon_SetWindowSizeRequest{root.Struct()}, err
}

func (s Conmon_SetWindowSizeRequest) String() string {
	str, _ := text.Marshal(0xb5418b8ea8ead17b, s.Struct)
	return str
}

func (s Conmon_SetWindowSizeRequest) Id() (string, error) {
	p, err := s.Struct.Ptr(0)
	return p.Text(), err
}

func (s Conmon_SetWindowSizeRequest) HasId() bool {
	return s.Struct.HasPtr(0)
}

func (s Conmon_SetWindowSizeRequest) IdBytes() ([]byte, error) {
	p, err := s.Struct.Ptr(0)
	return p.TextBytes(), err
}

func (s Conmon_SetWindowSizeRequest) SetId(v string) error {
	return s.Struct.SetText(0, v)
}

func (s Conmon_SetWindowSizeRequest) Width() uint16 {
	return s.Struct.Uint16(0)
}

func (s Conmon_SetWindowSizeRequest) SetWidth(v uint16) {
	s.Struct.SetUint16(0, v)
}

func (s Conmon_SetWindowSizeRequest) Height() uint16 {
	return s.Struct.Uint16(2)
}

func (s Conmon_SetWindowSizeRequest) SetHeight(v uint16) {
	s.Struct.SetUint16(2, v)
}

// Conmon_SetWindowSizeRequest_List is a list of Conmon_SetWindowSizeRequest.
type Conmon_SetWindowSizeRequest_List = capnp.StructList[Conmon_SetWindowSizeRequest]

// NewConmon_SetWindowSizeRequest creates a new list of Conmon_SetWindowSizeRequest.
func NewConmon_SetWindowSizeRequest_List(s *capnp.Segment, sz int32) (Conmon_SetWindowSizeRequest_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1}, sz)
	return capnp.StructList[Conmon_SetWindowSizeRequest]{l}, err
}

// Conmon_SetWindowSizeRequest_Future is a wrapper for a Conmon_SetWindowSizeRequest promised by a client call.
type Conmon_SetWindowSizeRequest_Future struct{ *capnp.Future }

func (p Conmon_SetWindowSizeRequest_Future) Struct() (Conmon_SetWindowSizeRequest, error) {
	s, err := p.Future.Struct()
	return Conmon_SetWindowSizeRequest{s}, err
}

type Conmon_SetWindowSizeResponse struct{ capnp.Struct }

// Conmon_SetWindowSizeResponse_TypeID is the unique identifier for the type Conmon_SetWindowSizeResponse.
const Conmon_SetWindowSizeResponse_TypeID = 0xf9b3cd8033aba1f8

func NewConmon_SetWindowSizeResponse(s *capnp.Segment) (Conmon_SetWindowSizeResponse, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return Conmon_SetWindowSizeResponse{st}, err
}

func NewRootConmon_SetWindowSizeResponse(s *capnp.Segment) (Conmon_SetWindowSizeResponse, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return Conmon_SetWindowSizeResponse{st}, err
}

func ReadRootConmon_SetWindowSizeResponse(msg *capnp.Message) (Conmon_SetWindowSizeResponse, error) {
	root, err := msg.Root()
	return Conmon_SetWindowSizeResponse{root.Struct()}, err
}

func (s Conmon_SetWindowSizeResponse) String() string {
	str, _ := text.Marshal(0xf9b3cd8033aba1f8, s.Struct)
	return str
}

// Conmon_SetWindowSizeResponse_List is a list of Conmon_SetWindowSizeResponse.
type Conmon_SetWindowSizeResponse_List = capnp.StructList[Conmon_SetWindowSizeResponse]

// NewConmon_SetWindowSizeResponse creates a new list of Conmon_SetWindowSizeResponse.
func NewConmon_SetWindowSizeResponse_List(s *capnp.Segment, sz int32) (Conmon_SetWindowSizeResponse_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0}, sz)
	return capnp.StructList[Conmon_SetWindowSizeResponse]{l}, err
}

// Conmon_SetWindowSizeResponse_Future is a wrapper for a Conmon_SetWindowSizeResponse promised by a client call.
type Conmon_SetWindowSizeResponse_Future struct{ *capnp.Future }

func (p Conmon_SetWindowSizeResponse_Future) Struct() (Conmon_SetWindowSizeResponse, error) {
	s, err := p.Future.Struct()
	return Conmon_SetWindowSizeResponse{s}, err
}

type Conmon_version_Params struct{ capnp.Struct }

// Conmon_version_Params_TypeID is the unique identifier for the type Conmon_version_Params.
const Conmon_version_Params_TypeID = 0xcc2f70676afee4e7

func NewConmon_version_Params(s *capnp.Segment) (Conmon_version_Params, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return Conmon_version_Params{st}, err
}

func NewRootConmon_version_Params(s *capnp.Segment) (Conmon_version_Params, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return Conmon_version_Params{st}, err
}

func ReadRootConmon_version_Params(msg *capnp.Message) (Conmon_version_Params, error) {
	root, err := msg.Root()
	return Conmon_version_Params{root.Struct()}, err
}

func (s Conmon_version_Params) String() string {
	str, _ := text.Marshal(0xcc2f70676afee4e7, s.Struct)
	return str
}

// Conmon_version_Params_List is a list of Conmon_version_Params.
type Conmon_version_Params_List = capnp.StructList[Conmon_version_Params]

// NewConmon_version_Params creates a new list of Conmon_version_Params.
func NewConmon_version_Params_List(s *capnp.Segment, sz int32) (Conmon_version_Params_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0}, sz)
	return capnp.StructList[Conmon_version_Params]{l}, err
}

// Conmon_version_Params_Future is a wrapper for a Conmon_version_Params promised by a client call.
type Conmon_version_Params_Future struct{ *capnp.Future }

func (p Conmon_version_Params_Future) Struct() (Conmon_version_Params, error) {
	s, err := p.Future.Struct()
	return Conmon_version_Params{s}, err
}

type Conmon_version_Results struct{ capnp.Struct }

// Conmon_version_Results_TypeID is the unique identifier for the type Conmon_version_Results.
const Conmon_version_Results_TypeID = 0xe313695ea9477b30

func NewConmon_version_Results(s *capnp.Segment) (Conmon_version_Results, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_version_Results{st}, err
}

func NewRootConmon_version_Results(s *capnp.Segment) (Conmon_version_Results, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_version_Results{st}, err
}

func ReadRootConmon_version_Results(msg *capnp.Message) (Conmon_version_Results, error) {
	root, err := msg.Root()
	return Conmon_version_Results{root.Struct()}, err
}

func (s Conmon_version_Results) String() string {
	str, _ := text.Marshal(0xe313695ea9477b30, s.Struct)
	return str
}

func (s Conmon_version_Results) Response() (Conmon_VersionResponse, error) {
	p, err := s.Struct.Ptr(0)
	return Conmon_VersionResponse{Struct: p.Struct()}, err
}

func (s Conmon_version_Results) HasResponse() bool {
	return s.Struct.HasPtr(0)
}

func (s Conmon_version_Results) SetResponse(v Conmon_VersionResponse) error {
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewResponse sets the response field to a newly
// allocated Conmon_VersionResponse struct, preferring placement in s's segment.
func (s Conmon_version_Results) NewResponse() (Conmon_VersionResponse, error) {
	ss, err := NewConmon_VersionResponse(s.Struct.Segment())
	if err != nil {
		return Conmon_VersionResponse{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

// Conmon_version_Results_List is a list of Conmon_version_Results.
type Conmon_version_Results_List = capnp.StructList[Conmon_version_Results]

// NewConmon_version_Results creates a new list of Conmon_version_Results.
func NewConmon_version_Results_List(s *capnp.Segment, sz int32) (Conmon_version_Results_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return capnp.StructList[Conmon_version_Results]{l}, err
}

// Conmon_version_Results_Future is a wrapper for a Conmon_version_Results promised by a client call.
type Conmon_version_Results_Future struct{ *capnp.Future }

func (p Conmon_version_Results_Future) Struct() (Conmon_version_Results, error) {
	s, err := p.Future.Struct()
	return Conmon_version_Results{s}, err
}

func (p Conmon_version_Results_Future) Response() Conmon_VersionResponse_Future {
	return Conmon_VersionResponse_Future{Future: p.Future.Field(0, nil)}
}

type Conmon_createContainer_Params struct{ capnp.Struct }

// Conmon_createContainer_Params_TypeID is the unique identifier for the type Conmon_createContainer_Params.
const Conmon_createContainer_Params_TypeID = 0xf44732c48f949ab8

func NewConmon_createContainer_Params(s *capnp.Segment) (Conmon_createContainer_Params, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_createContainer_Params{st}, err
}

func NewRootConmon_createContainer_Params(s *capnp.Segment) (Conmon_createContainer_Params, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_createContainer_Params{st}, err
}

func ReadRootConmon_createContainer_Params(msg *capnp.Message) (Conmon_createContainer_Params, error) {
	root, err := msg.Root()
	return Conmon_createContainer_Params{root.Struct()}, err
}

func (s Conmon_createContainer_Params) String() string {
	str, _ := text.Marshal(0xf44732c48f949ab8, s.Struct)
	return str
}

func (s Conmon_createContainer_Params) Request() (Conmon_CreateContainerRequest, error) {
	p, err := s.Struct.Ptr(0)
	return Conmon_CreateContainerRequest{Struct: p.Struct()}, err
}

func (s Conmon_createContainer_Params) HasRequest() bool {
	return s.Struct.HasPtr(0)
}

func (s Conmon_createContainer_Params) SetRequest(v Conmon_CreateContainerRequest) error {
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewRequest sets the request field to a newly
// allocated Conmon_CreateContainerRequest struct, preferring placement in s's segment.
func (s Conmon_createContainer_Params) NewRequest() (Conmon_CreateContainerRequest, error) {
	ss, err := NewConmon_CreateContainerRequest(s.Struct.Segment())
	if err != nil {
		return Conmon_CreateContainerRequest{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

// Conmon_createContainer_Params_List is a list of Conmon_createContainer_Params.
type Conmon_createContainer_Params_List = capnp.StructList[Conmon_createContainer_Params]

// NewConmon_createContainer_Params creates a new list of Conmon_createContainer_Params.
func NewConmon_createContainer_Params_List(s *capnp.Segment, sz int32) (Conmon_createContainer_Params_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return capnp.StructList[Conmon_createContainer_Params]{l}, err
}

// Conmon_createContainer_Params_Future is a wrapper for a Conmon_createContainer_Params promised by a client call.
type Conmon_createContainer_Params_Future struct{ *capnp.Future }

func (p Conmon_createContainer_Params_Future) Struct() (Conmon_createContainer_Params, error) {
	s, err := p.Future.Struct()
	return Conmon_createContainer_Params{s}, err
}

func (p Conmon_createContainer_Params_Future) Request() Conmon_CreateContainerRequest_Future {
	return Conmon_CreateContainerRequest_Future{Future: p.Future.Field(0, nil)}
}

type Conmon_createContainer_Results struct{ capnp.Struct }

// Conmon_createContainer_Results_TypeID is the unique identifier for the type Conmon_createContainer_Results.
const Conmon_createContainer_Results_TypeID = 0xceba3c1a97be15f8

func NewConmon_createContainer_Results(s *capnp.Segment) (Conmon_createContainer_Results, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_createContainer_Results{st}, err
}

func NewRootConmon_createContainer_Results(s *capnp.Segment) (Conmon_createContainer_Results, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_createContainer_Results{st}, err
}

func ReadRootConmon_createContainer_Results(msg *capnp.Message) (Conmon_createContainer_Results, error) {
	root, err := msg.Root()
	return Conmon_createContainer_Results{root.Struct()}, err
}

func (s Conmon_createContainer_Results) String() string {
	str, _ := text.Marshal(0xceba3c1a97be15f8, s.Struct)
	return str
}

func (s Conmon_createContainer_Results) Response() (Conmon_CreateContainerResponse, error) {
	p, err := s.Struct.Ptr(0)
	return Conmon_CreateContainerResponse{Struct: p.Struct()}, err
}

func (s Conmon_createContainer_Results) HasResponse() bool {
	return s.Struct.HasPtr(0)
}

func (s Conmon_createContainer_Results) SetResponse(v Conmon_CreateContainerResponse) error {
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewResponse sets the response field to a newly
// allocated Conmon_CreateContainerResponse struct, preferring placement in s's segment.
func (s Conmon_createContainer_Results) NewResponse() (Conmon_CreateContainerResponse, error) {
	ss, err := NewConmon_CreateContainerResponse(s.Struct.Segment())
	if err != nil {
		return Conmon_CreateContainerResponse{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

// Conmon_createContainer_Results_List is a list of Conmon_createContainer_Results.
type Conmon_createContainer_Results_List = capnp.StructList[Conmon_createContainer_Results]

// NewConmon_createContainer_Results creates a new list of Conmon_createContainer_Results.
func NewConmon_createContainer_Results_List(s *capnp.Segment, sz int32) (Conmon_createContainer_Results_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return capnp.StructList[Conmon_createContainer_Results]{l}, err
}

// Conmon_createContainer_Results_Future is a wrapper for a Conmon_createContainer_Results promised by a client call.
type Conmon_createContainer_Results_Future struct{ *capnp.Future }

func (p Conmon_createContainer_Results_Future) Struct() (Conmon_createContainer_Results, error) {
	s, err := p.Future.Struct()
	return Conmon_createContainer_Results{s}, err
}

func (p Conmon_createContainer_Results_Future) Response() Conmon_CreateContainerResponse_Future {
	return Conmon_CreateContainerResponse_Future{Future: p.Future.Field(0, nil)}
}

type Conmon_execSyncContainer_Params struct{ capnp.Struct }

// Conmon_execSyncContainer_Params_TypeID is the unique identifier for the type Conmon_execSyncContainer_Params.
const Conmon_execSyncContainer_Params_TypeID = 0x83479da67279e173

func NewConmon_execSyncContainer_Params(s *capnp.Segment) (Conmon_execSyncContainer_Params, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_execSyncContainer_Params{st}, err
}

func NewRootConmon_execSyncContainer_Params(s *capnp.Segment) (Conmon_execSyncContainer_Params, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_execSyncContainer_Params{st}, err
}

func ReadRootConmon_execSyncContainer_Params(msg *capnp.Message) (Conmon_execSyncContainer_Params, error) {
	root, err := msg.Root()
	return Conmon_execSyncContainer_Params{root.Struct()}, err
}

func (s Conmon_execSyncContainer_Params) String() string {
	str, _ := text.Marshal(0x83479da67279e173, s.Struct)
	return str
}

func (s Conmon_execSyncContainer_Params) Request() (Conmon_ExecSyncContainerRequest, error) {
	p, err := s.Struct.Ptr(0)
	return Conmon_ExecSyncContainerRequest{Struct: p.Struct()}, err
}

func (s Conmon_execSyncContainer_Params) HasRequest() bool {
	return s.Struct.HasPtr(0)
}

func (s Conmon_execSyncContainer_Params) SetRequest(v Conmon_ExecSyncContainerRequest) error {
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewRequest sets the request field to a newly
// allocated Conmon_ExecSyncContainerRequest struct, preferring placement in s's segment.
func (s Conmon_execSyncContainer_Params) NewRequest() (Conmon_ExecSyncContainerRequest, error) {
	ss, err := NewConmon_ExecSyncContainerRequest(s.Struct.Segment())
	if err != nil {
		return Conmon_ExecSyncContainerRequest{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

// Conmon_execSyncContainer_Params_List is a list of Conmon_execSyncContainer_Params.
type Conmon_execSyncContainer_Params_List = capnp.StructList[Conmon_execSyncContainer_Params]

// NewConmon_execSyncContainer_Params creates a new list of Conmon_execSyncContainer_Params.
func NewConmon_execSyncContainer_Params_List(s *capnp.Segment, sz int32) (Conmon_execSyncContainer_Params_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return capnp.StructList[Conmon_execSyncContainer_Params]{l}, err
}

// Conmon_execSyncContainer_Params_Future is a wrapper for a Conmon_execSyncContainer_Params promised by a client call.
type Conmon_execSyncContainer_Params_Future struct{ *capnp.Future }

func (p Conmon_execSyncContainer_Params_Future) Struct() (Conmon_execSyncContainer_Params, error) {
	s, err := p.Future.Struct()
	return Conmon_execSyncContainer_Params{s}, err
}

func (p Conmon_execSyncContainer_Params_Future) Request() Conmon_ExecSyncContainerRequest_Future {
	return Conmon_ExecSyncContainerRequest_Future{Future: p.Future.Field(0, nil)}
}

type Conmon_execSyncContainer_Results struct{ capnp.Struct }

// Conmon_execSyncContainer_Results_TypeID is the unique identifier for the type Conmon_execSyncContainer_Results.
const Conmon_execSyncContainer_Results_TypeID = 0xf8e86a5c0baa01bc

func NewConmon_execSyncContainer_Results(s *capnp.Segment) (Conmon_execSyncContainer_Results, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_execSyncContainer_Results{st}, err
}

func NewRootConmon_execSyncContainer_Results(s *capnp.Segment) (Conmon_execSyncContainer_Results, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_execSyncContainer_Results{st}, err
}

func ReadRootConmon_execSyncContainer_Results(msg *capnp.Message) (Conmon_execSyncContainer_Results, error) {
	root, err := msg.Root()
	return Conmon_execSyncContainer_Results{root.Struct()}, err
}

func (s Conmon_execSyncContainer_Results) String() string {
	str, _ := text.Marshal(0xf8e86a5c0baa01bc, s.Struct)
	return str
}

func (s Conmon_execSyncContainer_Results) Response() (Conmon_ExecSyncContainerResponse, error) {
	p, err := s.Struct.Ptr(0)
	return Conmon_ExecSyncContainerResponse{Struct: p.Struct()}, err
}

func (s Conmon_execSyncContainer_Results) HasResponse() bool {
	return s.Struct.HasPtr(0)
}

func (s Conmon_execSyncContainer_Results) SetResponse(v Conmon_ExecSyncContainerResponse) error {
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewResponse sets the response field to a newly
// allocated Conmon_ExecSyncContainerResponse struct, preferring placement in s's segment.
func (s Conmon_execSyncContainer_Results) NewResponse() (Conmon_ExecSyncContainerResponse, error) {
	ss, err := NewConmon_ExecSyncContainerResponse(s.Struct.Segment())
	if err != nil {
		return Conmon_ExecSyncContainerResponse{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

// Conmon_execSyncContainer_Results_List is a list of Conmon_execSyncContainer_Results.
type Conmon_execSyncContainer_Results_List = capnp.StructList[Conmon_execSyncContainer_Results]

// NewConmon_execSyncContainer_Results creates a new list of Conmon_execSyncContainer_Results.
func NewConmon_execSyncContainer_Results_List(s *capnp.Segment, sz int32) (Conmon_execSyncContainer_Results_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return capnp.StructList[Conmon_execSyncContainer_Results]{l}, err
}

// Conmon_execSyncContainer_Results_Future is a wrapper for a Conmon_execSyncContainer_Results promised by a client call.
type Conmon_execSyncContainer_Results_Future struct{ *capnp.Future }

func (p Conmon_execSyncContainer_Results_Future) Struct() (Conmon_execSyncContainer_Results, error) {
	s, err := p.Future.Struct()
	return Conmon_execSyncContainer_Results{s}, err
}

func (p Conmon_execSyncContainer_Results_Future) Response() Conmon_ExecSyncContainerResponse_Future {
	return Conmon_ExecSyncContainerResponse_Future{Future: p.Future.Field(0, nil)}
}

type Conmon_attachContainer_Params struct{ capnp.Struct }

// Conmon_attachContainer_Params_TypeID is the unique identifier for the type Conmon_attachContainer_Params.
const Conmon_attachContainer_Params_TypeID = 0xaa2f3c8ad1c3af24

func NewConmon_attachContainer_Params(s *capnp.Segment) (Conmon_attachContainer_Params, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_attachContainer_Params{st}, err
}

func NewRootConmon_attachContainer_Params(s *capnp.Segment) (Conmon_attachContainer_Params, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_attachContainer_Params{st}, err
}

func ReadRootConmon_attachContainer_Params(msg *capnp.Message) (Conmon_attachContainer_Params, error) {
	root, err := msg.Root()
	return Conmon_attachContainer_Params{root.Struct()}, err
}

func (s Conmon_attachContainer_Params) String() string {
	str, _ := text.Marshal(0xaa2f3c8ad1c3af24, s.Struct)
	return str
}

func (s Conmon_attachContainer_Params) Request() (Conmon_AttachRequest, error) {
	p, err := s.Struct.Ptr(0)
	return Conmon_AttachRequest{Struct: p.Struct()}, err
}

func (s Conmon_attachContainer_Params) HasRequest() bool {
	return s.Struct.HasPtr(0)
}

func (s Conmon_attachContainer_Params) SetRequest(v Conmon_AttachRequest) error {
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewRequest sets the request field to a newly
// allocated Conmon_AttachRequest struct, preferring placement in s's segment.
func (s Conmon_attachContainer_Params) NewRequest() (Conmon_AttachRequest, error) {
	ss, err := NewConmon_AttachRequest(s.Struct.Segment())
	if err != nil {
		return Conmon_AttachRequest{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

// Conmon_attachContainer_Params_List is a list of Conmon_attachContainer_Params.
type Conmon_attachContainer_Params_List = capnp.StructList[Conmon_attachContainer_Params]

// NewConmon_attachContainer_Params creates a new list of Conmon_attachContainer_Params.
func NewConmon_attachContainer_Params_List(s *capnp.Segment, sz int32) (Conmon_attachContainer_Params_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return capnp.StructList[Conmon_attachContainer_Params]{l}, err
}

// Conmon_attachContainer_Params_Future is a wrapper for a Conmon_attachContainer_Params promised by a client call.
type Conmon_attachContainer_Params_Future struct{ *capnp.Future }

func (p Conmon_attachContainer_Params_Future) Struct() (Conmon_attachContainer_Params, error) {
	s, err := p.Future.Struct()
	return Conmon_attachContainer_Params{s}, err
}

func (p Conmon_attachContainer_Params_Future) Request() Conmon_AttachRequest_Future {
	return Conmon_AttachRequest_Future{Future: p.Future.Field(0, nil)}
}

type Conmon_attachContainer_Results struct{ capnp.Struct }

// Conmon_attachContainer_Results_TypeID is the unique identifier for the type Conmon_attachContainer_Results.
const Conmon_attachContainer_Results_TypeID = 0xc5e65eec3dcf5b10

func NewConmon_attachContainer_Results(s *capnp.Segment) (Conmon_attachContainer_Results, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_attachContainer_Results{st}, err
}

func NewRootConmon_attachContainer_Results(s *capnp.Segment) (Conmon_attachContainer_Results, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_attachContainer_Results{st}, err
}

func ReadRootConmon_attachContainer_Results(msg *capnp.Message) (Conmon_attachContainer_Results, error) {
	root, err := msg.Root()
	return Conmon_attachContainer_Results{root.Struct()}, err
}

func (s Conmon_attachContainer_Results) String() string {
	str, _ := text.Marshal(0xc5e65eec3dcf5b10, s.Struct)
	return str
}

func (s Conmon_attachContainer_Results) Response() (Conmon_AttachResponse, error) {
	p, err := s.Struct.Ptr(0)
	return Conmon_AttachResponse{Struct: p.Struct()}, err
}

func (s Conmon_attachContainer_Results) HasResponse() bool {
	return s.Struct.HasPtr(0)
}

func (s Conmon_attachContainer_Results) SetResponse(v Conmon_AttachResponse) error {
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewResponse sets the response field to a newly
// allocated Conmon_AttachResponse struct, preferring placement in s's segment.
func (s Conmon_attachContainer_Results) NewResponse() (Conmon_AttachResponse, error) {
	ss, err := NewConmon_AttachResponse(s.Struct.Segment())
	if err != nil {
		return Conmon_AttachResponse{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

// Conmon_attachContainer_Results_List is a list of Conmon_attachContainer_Results.
type Conmon_attachContainer_Results_List = capnp.StructList[Conmon_attachContainer_Results]

// NewConmon_attachContainer_Results creates a new list of Conmon_attachContainer_Results.
func NewConmon_attachContainer_Results_List(s *capnp.Segment, sz int32) (Conmon_attachContainer_Results_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return capnp.StructList[Conmon_attachContainer_Results]{l}, err
}

// Conmon_attachContainer_Results_Future is a wrapper for a Conmon_attachContainer_Results promised by a client call.
type Conmon_attachContainer_Results_Future struct{ *capnp.Future }

func (p Conmon_attachContainer_Results_Future) Struct() (Conmon_attachContainer_Results, error) {
	s, err := p.Future.Struct()
	return Conmon_attachContainer_Results{s}, err
}

func (p Conmon_attachContainer_Results_Future) Response() Conmon_AttachResponse_Future {
	return Conmon_AttachResponse_Future{Future: p.Future.Field(0, nil)}
}

type Conmon_reopenLogContainer_Params struct{ capnp.Struct }

// Conmon_reopenLogContainer_Params_TypeID is the unique identifier for the type Conmon_reopenLogContainer_Params.
const Conmon_reopenLogContainer_Params_TypeID = 0xe5ea916eb0c31336

func NewConmon_reopenLogContainer_Params(s *capnp.Segment) (Conmon_reopenLogContainer_Params, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_reopenLogContainer_Params{st}, err
}

func NewRootConmon_reopenLogContainer_Params(s *capnp.Segment) (Conmon_reopenLogContainer_Params, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_reopenLogContainer_Params{st}, err
}

func ReadRootConmon_reopenLogContainer_Params(msg *capnp.Message) (Conmon_reopenLogContainer_Params, error) {
	root, err := msg.Root()
	return Conmon_reopenLogContainer_Params{root.Struct()}, err
}

func (s Conmon_reopenLogContainer_Params) String() string {
	str, _ := text.Marshal(0xe5ea916eb0c31336, s.Struct)
	return str
}

func (s Conmon_reopenLogContainer_Params) Request() (Conmon_ReopenLogRequest, error) {
	p, err := s.Struct.Ptr(0)
	return Conmon_ReopenLogRequest{Struct: p.Struct()}, err
}

func (s Conmon_reopenLogContainer_Params) HasRequest() bool {
	return s.Struct.HasPtr(0)
}

func (s Conmon_reopenLogContainer_Params) SetRequest(v Conmon_ReopenLogRequest) error {
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewRequest sets the request field to a newly
// allocated Conmon_ReopenLogRequest struct, preferring placement in s's segment.
func (s Conmon_reopenLogContainer_Params) NewRequest() (Conmon_ReopenLogRequest, error) {
	ss, err := NewConmon_ReopenLogRequest(s.Struct.Segment())
	if err != nil {
		return Conmon_ReopenLogRequest{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

// Conmon_reopenLogContainer_Params_List is a list of Conmon_reopenLogContainer_Params.
type Conmon_reopenLogContainer_Params_List = capnp.StructList[Conmon_reopenLogContainer_Params]

// NewConmon_reopenLogContainer_Params creates a new list of Conmon_reopenLogContainer_Params.
func NewConmon_reopenLogContainer_Params_List(s *capnp.Segment, sz int32) (Conmon_reopenLogContainer_Params_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return capnp.StructList[Conmon_reopenLogContainer_Params]{l}, err
}

// Conmon_reopenLogContainer_Params_Future is a wrapper for a Conmon_reopenLogContainer_Params promised by a client call.
type Conmon_reopenLogContainer_Params_Future struct{ *capnp.Future }

func (p Conmon_reopenLogContainer_Params_Future) Struct() (Conmon_reopenLogContainer_Params, error) {
	s, err := p.Future.Struct()
	return Conmon_reopenLogContainer_Params{s}, err
}

func (p Conmon_reopenLogContainer_Params_Future) Request() Conmon_ReopenLogRequest_Future {
	return Conmon_ReopenLogRequest_Future{Future: p.Future.Field(0, nil)}
}

type Conmon_reopenLogContainer_Results struct{ capnp.Struct }

// Conmon_reopenLogContainer_Results_TypeID is the unique identifier for the type Conmon_reopenLogContainer_Results.
const Conmon_reopenLogContainer_Results_TypeID = 0xa0ef8355b64ee985

func NewConmon_reopenLogContainer_Results(s *capnp.Segment) (Conmon_reopenLogContainer_Results, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_reopenLogContainer_Results{st}, err
}

func NewRootConmon_reopenLogContainer_Results(s *capnp.Segment) (Conmon_reopenLogContainer_Results, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_reopenLogContainer_Results{st}, err
}

func ReadRootConmon_reopenLogContainer_Results(msg *capnp.Message) (Conmon_reopenLogContainer_Results, error) {
	root, err := msg.Root()
	return Conmon_reopenLogContainer_Results{root.Struct()}, err
}

func (s Conmon_reopenLogContainer_Results) String() string {
	str, _ := text.Marshal(0xa0ef8355b64ee985, s.Struct)
	return str
}

func (s Conmon_reopenLogContainer_Results) Response() (Conmon_ReopenLogResponse, error) {
	p, err := s.Struct.Ptr(0)
	return Conmon_ReopenLogResponse{Struct: p.Struct()}, err
}

func (s Conmon_reopenLogContainer_Results) HasResponse() bool {
	return s.Struct.HasPtr(0)
}

func (s Conmon_reopenLogContainer_Results) SetResponse(v Conmon_ReopenLogResponse) error {
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewResponse sets the response field to a newly
// allocated Conmon_ReopenLogResponse struct, preferring placement in s's segment.
func (s Conmon_reopenLogContainer_Results) NewResponse() (Conmon_ReopenLogResponse, error) {
	ss, err := NewConmon_ReopenLogResponse(s.Struct.Segment())
	if err != nil {
		return Conmon_ReopenLogResponse{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

// Conmon_reopenLogContainer_Results_List is a list of Conmon_reopenLogContainer_Results.
type Conmon_reopenLogContainer_Results_List = capnp.StructList[Conmon_reopenLogContainer_Results]

// NewConmon_reopenLogContainer_Results creates a new list of Conmon_reopenLogContainer_Results.
func NewConmon_reopenLogContainer_Results_List(s *capnp.Segment, sz int32) (Conmon_reopenLogContainer_Results_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return capnp.StructList[Conmon_reopenLogContainer_Results]{l}, err
}

// Conmon_reopenLogContainer_Results_Future is a wrapper for a Conmon_reopenLogContainer_Results promised by a client call.
type Conmon_reopenLogContainer_Results_Future struct{ *capnp.Future }

func (p Conmon_reopenLogContainer_Results_Future) Struct() (Conmon_reopenLogContainer_Results, error) {
	s, err := p.Future.Struct()
	return Conmon_reopenLogContainer_Results{s}, err
}

func (p Conmon_reopenLogContainer_Results_Future) Response() Conmon_ReopenLogResponse_Future {
	return Conmon_ReopenLogResponse_Future{Future: p.Future.Field(0, nil)}
}

type Conmon_setWindowSizeContainer_Params struct{ capnp.Struct }

// Conmon_setWindowSizeContainer_Params_TypeID is the unique identifier for the type Conmon_setWindowSizeContainer_Params.
const Conmon_setWindowSizeContainer_Params_TypeID = 0xc76ccd4502bb61e7

func NewConmon_setWindowSizeContainer_Params(s *capnp.Segment) (Conmon_setWindowSizeContainer_Params, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_setWindowSizeContainer_Params{st}, err
}

func NewRootConmon_setWindowSizeContainer_Params(s *capnp.Segment) (Conmon_setWindowSizeContainer_Params, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_setWindowSizeContainer_Params{st}, err
}

func ReadRootConmon_setWindowSizeContainer_Params(msg *capnp.Message) (Conmon_setWindowSizeContainer_Params, error) {
	root, err := msg.Root()
	return Conmon_setWindowSizeContainer_Params{root.Struct()}, err
}

func (s Conmon_setWindowSizeContainer_Params) String() string {
	str, _ := text.Marshal(0xc76ccd4502bb61e7, s.Struct)
	return str
}

func (s Conmon_setWindowSizeContainer_Params) Request() (Conmon_SetWindowSizeRequest, error) {
	p, err := s.Struct.Ptr(0)
	return Conmon_SetWindowSizeRequest{Struct: p.Struct()}, err
}

func (s Conmon_setWindowSizeContainer_Params) HasRequest() bool {
	return s.Struct.HasPtr(0)
}

func (s Conmon_setWindowSizeContainer_Params) SetRequest(v Conmon_SetWindowSizeRequest) error {
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewRequest sets the request field to a newly
// allocated Conmon_SetWindowSizeRequest struct, preferring placement in s's segment.
func (s Conmon_setWindowSizeContainer_Params) NewRequest() (Conmon_SetWindowSizeRequest, error) {
	ss, err := NewConmon_SetWindowSizeRequest(s.Struct.Segment())
	if err != nil {
		return Conmon_SetWindowSizeRequest{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

// Conmon_setWindowSizeContainer_Params_List is a list of Conmon_setWindowSizeContainer_Params.
type Conmon_setWindowSizeContainer_Params_List = capnp.StructList[Conmon_setWindowSizeContainer_Params]

// NewConmon_setWindowSizeContainer_Params creates a new list of Conmon_setWindowSizeContainer_Params.
func NewConmon_setWindowSizeContainer_Params_List(s *capnp.Segment, sz int32) (Conmon_setWindowSizeContainer_Params_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return capnp.StructList[Conmon_setWindowSizeContainer_Params]{l}, err
}

// Conmon_setWindowSizeContainer_Params_Future is a wrapper for a Conmon_setWindowSizeContainer_Params promised by a client call.
type Conmon_setWindowSizeContainer_Params_Future struct{ *capnp.Future }

func (p Conmon_setWindowSizeContainer_Params_Future) Struct() (Conmon_setWindowSizeContainer_Params, error) {
	s, err := p.Future.Struct()
	return Conmon_setWindowSizeContainer_Params{s}, err
}

func (p Conmon_setWindowSizeContainer_Params_Future) Request() Conmon_SetWindowSizeRequest_Future {
	return Conmon_SetWindowSizeRequest_Future{Future: p.Future.Field(0, nil)}
}

type Conmon_setWindowSizeContainer_Results struct{ capnp.Struct }

// Conmon_setWindowSizeContainer_Results_TypeID is the unique identifier for the type Conmon_setWindowSizeContainer_Results.
const Conmon_setWindowSizeContainer_Results_TypeID = 0xe00e522611477055

func NewConmon_setWindowSizeContainer_Results(s *capnp.Segment) (Conmon_setWindowSizeContainer_Results, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_setWindowSizeContainer_Results{st}, err
}

func NewRootConmon_setWindowSizeContainer_Results(s *capnp.Segment) (Conmon_setWindowSizeContainer_Results, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_setWindowSizeContainer_Results{st}, err
}

func ReadRootConmon_setWindowSizeContainer_Results(msg *capnp.Message) (Conmon_setWindowSizeContainer_Results, error) {
	root, err := msg.Root()
	return Conmon_setWindowSizeContainer_Results{root.Struct()}, err
}

func (s Conmon_setWindowSizeContainer_Results) String() string {
	str, _ := text.Marshal(0xe00e522611477055, s.Struct)
	return str
}

func (s Conmon_setWindowSizeContainer_Results) Response() (Conmon_SetWindowSizeResponse, error) {
	p, err := s.Struct.Ptr(0)
	return Conmon_SetWindowSizeResponse{Struct: p.Struct()}, err
}

func (s Conmon_setWindowSizeContainer_Results) HasResponse() bool {
	return s.Struct.HasPtr(0)
}

func (s Conmon_setWindowSizeContainer_Results) SetResponse(v Conmon_SetWindowSizeResponse) error {
	return s.Struct.SetPtr(0, v.Struct.ToPtr())
}

// NewResponse sets the response field to a newly
// allocated Conmon_SetWindowSizeResponse struct, preferring placement in s's segment.
func (s Conmon_setWindowSizeContainer_Results) NewResponse() (Conmon_SetWindowSizeResponse, error) {
	ss, err := NewConmon_SetWindowSizeResponse(s.Struct.Segment())
	if err != nil {
		return Conmon_SetWindowSizeResponse{}, err
	}
	err = s.Struct.SetPtr(0, ss.Struct.ToPtr())
	return ss, err
}

// Conmon_setWindowSizeContainer_Results_List is a list of Conmon_setWindowSizeContainer_Results.
type Conmon_setWindowSizeContainer_Results_List = capnp.StructList[Conmon_setWindowSizeContainer_Results]

// NewConmon_setWindowSizeContainer_Results creates a new list of Conmon_setWindowSizeContainer_Results.
func NewConmon_setWindowSizeContainer_Results_List(s *capnp.Segment, sz int32) (Conmon_setWindowSizeContainer_Results_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return capnp.StructList[Conmon_setWindowSizeContainer_Results]{l}, err
}

// Conmon_setWindowSizeContainer_Results_Future is a wrapper for a Conmon_setWindowSizeContainer_Results promised by a client call.
type Conmon_setWindowSizeContainer_Results_Future struct{ *capnp.Future }

func (p Conmon_setWindowSizeContainer_Results_Future) Struct() (Conmon_setWindowSizeContainer_Results, error) {
	s, err := p.Future.Struct()
	return Conmon_setWindowSizeContainer_Results{s}, err
}

func (p Conmon_setWindowSizeContainer_Results_Future) Response() Conmon_SetWindowSizeResponse_Future {
	return Conmon_SetWindowSizeResponse_Future{Future: p.Future.Field(0, nil)}
}

const schema_ffaaf7385bc4adad = "x\xda\xacW}l\x1cG\x15\x7fo\xe6\xd6\xe7\xda>" +
	"\xdfM\xd7\x88b)2\x8aBE\x12\xb5\x0eq\xca\x87" +
	"\x15d\xe7\xc32.\x09\xdc\\\x12\xa2\xe6K\xdd\xdcM" +
	"\xedM}\xbb\xe7\xdd\xbd8N\x89\x92\xb6XH\x85\x16" +
	"Z\x15\x81#\"%\xd0T\x8d\x89IKI\xa8\x02T" +
	"@\x13\xb5\x04\x02\xd8\x12\xa0V\x14\x1aBh\x1a\xd1\x02" +
	"\xa2\x08\x07U,\x9a\xdd\xdb\x8f\xbb\x18\xd5\x1f\xfcw\xb7" +
	"\xfb\xdb7o\xde\xbc\xdf\xef\xf7fE\xbf\xd2\x9d\xf8P" +
	"jk\x03\x10\xbeO\xa9s\xedK#\xd6\x93Gz\x1f" +
	"\x04\xb6\x1c\x01\x14L\x02t0e1\x01T\x97*]" +
	"\x80\xee\xe8\x1b\x9f:\xb3\xe5\xc1\xbf\x1e\x8d\x03\xfa\x94\x95" +
	"\x12\xa0y\x80\xb1\xedW\xef\xed\xe9K\x7fC\x02\xdc\xbf" +
	"w\xdc\xf3\xea\xd8\xd5\x8f|\x0f\x12\x127\xaa\\C\xf5" +
	"\x98\x92\x04\xea.9\xf5\xc2\xe4C\xab\xdb\xc7\xe3a\x0e" +
	"(7\xcb0_\xf1\xc2\x0c\xdf\xfd\xd2\xa9\xfd\xfc\xca\xc9" +
	"\x19\xc2\x9cV\xa6P\x9d\xf4\xc2\xac:\xf6\xec\x99G\xde" +
	"\xda\xf7m\xe0\xcb1\x06\xf3\xe3M(\xe3\xa8\x9eW\xde" +
	"\x0b\xa0^T\x86\x01\xdd\xfb&\xaf=\xf5\xc8\x17\xd6\x9c" +
	"\x9e\x11\xbd\xb4\x8e\x10\xb5\xa7.\x09\xa0\xae\xa9;\x05\xb1" +
	"\xf7l\x09u'&\xcem\xff\xe8\xbf\xc6]\x00\xecx" +
	"\xb9n\x1b\xaao\xd6\xbd\x08\xd01\x99\xfc<\xaa\x97\xea" +
	"\x93\x00\xee\x853':\xff}y\xf8lmpE\x06" +
	"\xffi\xfd\xcdD}C\xe2:\xae\xd4oE@7\xb3" +
	"\xfd\x97\x1f\xff\xcb\xae?\x9f\x8f\x17\xa0\xdc\xd0*\x0b\xf0" +
	"p\x83,\xc0\xeb\xda\xf7I\xcf\xc5\xc1\x17\xe3\x80g\x1a" +
	"\xee\x94\x80\x8b>\xe0O\xff\xd9\xd3_j\xff\xb9\x0f\xf0" +
	"*\xf3f\xc3\x14B\xc2\x9d~\xcf\xf3_m]}\xf6" +
	"\x17\xf1O/\xf9\xb1\xaf{\x9f\xb6\xae\x99\\\x956z" +
	"\x7fU]\\\x1f\xb8\xa8\xf1\x8f\xa8~\xacQ\xd6\xe1\x8e" +
	"F\x09~gt\xf5\xa1E\x8b~\xf3r\xed\xc6\x88D" +
	"oi\\F\xd4\xb2\x87\x1ej|\x1d\xd0=\xbc|\xb8" +
	"\xb4kw\xe7\xefk\xd0^z\x1b\x9bZ\x89Zl\x92" +
	"`\xbd\xc9\x0b\xdd\xf9\xce\xf3GW\x97\xfeP\x93\x07\x95" +
	"\xe0\x87\x9b.\xa0z\xc2\x03\x1fo\x92\xe7\xb1\xa5\xd4\xcb" +
	"n\xcd5\xbf\x16\xdfUO*\xe7u^JF[q" +
	"_\xef\x89]\xbaz9\x0e\x18M\xbd\x82\x80\xea\x98\x07" +
	"\xf8\xb0\xfa\xc2\xd3\xc6\xa3\xd7\xae\xc4\x01?L-\x93\x11" +
	"~\xed\x01~\xbc\xbd#\xfb\xdb\xcb\xb7\xfe\x0d\xd8\x1d$" +
	"\xea-\xc0\x8e\x7f\xa6\xa6Pe\xcd2\x99Ts\x1b\xa0" +
	";\xf9V\xdb\xc9\x9f]\xf9\xe4?f<\xedT\xf3+" +
	"\xa8.\x95\xe8\x8e\x0f4{\xa7\xfd\xe4\xd07\xbf<\xbd" +
	"\x98\xbd-\xe1\xa4\xb6\x86\x07\xd2\x8b\x89z$-\x83\x8f" +
	"\xa5e\x0d\x9f;\xfc\xf8\x97\xce\xad\xec}\xbbj#\x19" +
	"\x8f\x1cG22\xcf\x1f\xe0x\xe3\x8e=W\xa7\xab6" +
	"\x92\xf17\xe2\x01\xa6\x8f}\xab\xe3\xd0\xc5g\xaf\xcf\xc0" +
	"\x9e\xeb\x99\x06\xa2\xbe\x8f%\xa1\xdd\xcd\x9bF\xd14n" +
	"\xb3\x92v{\xde,\x16M\xa3\xbdd\x99\x8e\xd9\xee?" +
	"\xbf=\xaf\x95\x8cR\xe7:\xff\x8f\xd8'\xf2\x9bF\x8c" +
	"\xfc:\xd3p4\xdd\x10\xd6\x92\xacf%\xb5\xa2\xcd\x13" +
	"4\x01\x90@\x00\x96Z\x0b\xc0\xeb)\xf2\x16\x82\x07-" +
	"1T\x16\xb6\x83\x99h\xf3\x80\x98\x01\x9c\xd3\xb2\x960" +
	"K\xc2\xd8`\xf6G\xeb\xe6D\x9b]\x1et\xaa\x16\xbe" +
	"\x13\x807Q\xe4\xb7\x10t-a\x97L\xc3\x16\x00\x80" +
	"\x99H\x8ej\x16\xaf\x9b\xc5\xe2\xb9`\xf1\x9c\xb0Ki" +
	"\x193\x8bsK_s\x1c-?PU3\xad\x88\xb3" +
	"\xa8Y\xc8\x8cy\xa4\xbd\xc6[4\xe7\x97\x01\xabrV" +
	"f\xf1\xf9\x06\xb3\x7f\xbd\x95\xd6\xf7\x0a\x8b'0\xce\x09" +
	"\\\x96\xde<R\x12\xbc>L~\xe92\x00\xbe\x84\"" +
	"_A\x10\xb1\x05\xe5\xb3\xdb\xe4\xb3\x0fR\xe4\xab\x08\xa6" +
	"\x9d\x91\x92\xc0t\x14\x03\x10\xd3\x80\xe9\x92\xe6\x0c`\x13" +
	"\x10l\x9ac;l\x12\xceV\xdd(\x98\xc3\x9b\xf4\xfd" +
	"\"\xe7W\x0b\xb2\x88\xbc)\xcc\xa9\xa7\x15\x80wS\xe4" +
	"\x1b\xa2\x9c\xfaV\x02\xf0\xf5\x14y\x96 #\xd8\x82\x04" +
	"\x80m\xec\x04\xe0\x9f\xa0\xc87\x13\xa4z!\xc8\xa7m" +
	"X/8\x03\x98\x04\x82I\xc0\xae\x01\xa1\xf7\x0f8\xc1" +
	"\xdf0\xd9\xc4\xbb%KM\x83\xaf\xc0\x98P\xb0\xbb\x1e" +
	"\x88<\x82\xddu6\xd2\x17\xb63\x17\xc9&\xdb\xf9\x93" +
	"\x880L\xbb\x10\xc9/\xd3\xa7b\x829d\xc5,r" +
	"h\x7fL\xd2\x87\x1e\x8ayp\xf9\xb1\xc8\xf5\xd8\xc8x" +
	"L\x18\x0e|\xc7\xfd\x8c\xb0l\xdd4r4`\xcc:" +
	"Kh\x8e\x08\xdb5\xd7\xe5W\xd8\xf5ZB\xdf+\x00" +
	"-7\xc0(\x01(\xf8\xb8\xa7V!\x82\xf3\x017x" +
	"Eb\xef*\xdd\xe9\x06\xdd\x0am\xfeZ\xe1\xff.?" +
	"\xae\x1b\xb0\x10\xfb\xa3\x80\xf1gA\xa0\xa070h\x8e" +
	"\xb4\x17\xaf\xf6\xb1\xdd\xe6\x85\xe5\xb7P\x05 4Q\x0c" +
	"\xcc\x83=\xb3\x16\x08;\x9e\xc4H\x861\xf0S6\xf6" +
	"\x00\x10\xf6h\x12I8'a \xc5l\xf41 \xec" +
	"\xfe$F\xb3\x0d\x06\x1e\xcf\xca\xf2\xbbb\x12\x13\xa1\x05" +
	"a0G1\xed0\x10\xb63\x89J\xe8\xf8\x188\x1d" +
	"\xe3g\x81\xb0\x8d\xc9\x83{\xfd\x83\xeaF7_\xa9>" +
	"V\xea\x08\xdd\xe8\x06\xd2\x8cAu\xd1\xeaF7\x90\x9e" +
	"8\xd2\x0a\xcbV\x81R!\xa1vU\x89\xd6\x99F\x97" +
	"\xffI7\xceU\xefj\x1b\xc8;0t$Co\x09" +
	"\x19:&\x19\xfa8E~\x94 \x0b(zd\x1b\x00" +
	"\xff:E\xfe\x14A$>C\x8fKY\x7f\x82\"\x7f" +
	"\x9a \xa3\xa4\x05)\x00\x9b\xc8\x01\xf0\x93\x14\xf9K\x04" +
	"Y\x82\xb6`\x02\x80\x9d\xdf\x03\xc0\xcfQ\xe4\xaf\x11d" +
	"J\xa2\x05\x15\x00\xf6\xaa\x0c\xf9;\x8a|\xba\x8a\xe0\xee" +
	"\xee\xb2Q\x18\x14Y\x0dhL\x85\x1ca\x15uC\x1b" +
	"\x94\xae\x81@P\xba\xb6\xd8\xa7;Y\xcd\x19\x00\xb4\xb1" +
	"\x190K\xd1\x837\x03\xba\xa6Y\xec\x91o!\xad9" +
	"\x037\xbc\x1d\x0c\xf8B\xad\xf0]&>Px\xa8\x85" +
	"\x18IN\xd8\xe5A:[\x13\x0c\x95\xa2\xc6M\xeag" +
	"\xb1\xb2\x1d\x97\xdc\x1a'\xb3\x01\xde\xdd\xcaB\xfd\x99\x87" +
	"\x95U\x1a?\xf0\xcd9\x95,_\xdd\x8bs,Y(" +
	"\xc8\x0b\x9b\x1b\x86\xcaIa{\xfd\x1f[\xb55\xaaS" +
	"\xbc/\xe7\xb2\xb9\x19\xc46\x1aQx&\\K\x93;" +
	"\xbc\x9b\"\x1f\x8c\xdcP\x97\xc6W\xa0\xc8K17," +
	"\xca\x87\x03\x14\xb9#\xb9\xf6~\x9fkC\xf2\xeb\x12E" +
	"\xfeY\xe2\xb3a\x9dY\xf0\xea\x93\x00\x82\x09\xc0.\xdb" +
	")\x98e\x07S@0\xe5\xff\x15\x96\x15\xfcu\x1d\xbd" +
	"(\x0a\x9f.;qN-HM\xe4\x01Q\x7f\x8b\xb1" +
	"r\xee\x89\x1db\xbe\x02\x86\xb4\x95\xd5\x0bX\x0f\x04\xeb" +
	"\xe79>U\xbc\xe6\x7fO\x17\xa1v\xf5m\x8b&\x09" +
	"F*\xe2\xc5-\x00\x9e\xa5\xc8wT\x9f\xb2m\xe6\xef" +
	"\x15N\x8d\xfax\x12.l\x1b\xdat\xd3\xe8\xbb\xb1%" +
	"\x16@T\xaf\xed\x1d\x9ce\xdb\x87\xf3\xc1\x02\xc8:7" +
	"\xa2\x85\x03\xd2\xff\xe7v\x90\xd5\xd2\xd6\xacn%\xe1\xc0" +
	"4\x8f\x9d\x06\xf3\x90u\xfb\xe6\x91\x12\xfa\xfd\xe8\x1d\xba" +
	"2\x05\x10\xf6 \xb1reCr\xa0\xcfp\x84u\x8f" +
	"\x96G1\xa7U\x82\xf1,\xde\xf61\x17];\x93\x8b" +
	".\x06\xe0_\xa3\xc8\x9f\x88u\xe2\xb1\xce\xc8Z\x19\xa5" +
	">\xb5\x8f\xe7b\xde\x9aH\xf86:\xb1\xbb\xe2\xad\xcf" +
	"\x11D\xc5w\xd1\xd3\x12\xf8]\x8a\xfcG\x04\x83A$" +
	"\xe8\xcf\xa4\xa3\xf5\x07\xbf\xbb\xe4~t'\xe6\xb2\xfa`" +
	"a\xbd\xe6\x00\x8a\xf0\x99U\xb6\x1d\xb9+H\xc6\x82\xb8" +
	"%\xcb\xcc\x0b\xdb\xee\x03\xbc\x91\xb0\xf3\xd4\xc2Hvc" +
	"R(\xa9\xbb\x83\"\x1f\x88\xa4Pl\x9bI\x0a\xd7V" +
	"\xa4\xf0s\xb2^\xdd~\xbd\xee\x97\x1d|\x88\"\xffb" +
	"5\x9d\xe5\xf9\x9aeg\x13P\x91\xc7\x9b\x80\xe0M\x80" +
	"\x07e\xca\x9aQ\xa8\x1d\x0bf\x9a1\x16\xe2h\xb3\xbe" +
	"M\x86\xf7\x8eyp\xec\xc6\x8b\x7fN\xd8\xe9\xd9_\xc0" +
	"\xc3\xfb\xcb<\xd6\xae\xb9\xee\x05a\xb3\x88\xff\x0d\x00\x00" +
	"\xff\xff\x1a==\xe6"

func init() {
	schemas.Register(schema_ffaaf7385bc4adad,
		0x83479da67279e173,
		0xa0ef8355b64ee985,
		0xa20f49456be85b99,
		0xaa2f3c8ad1c3af24,
		0xace5517aafc86077,
		0xae78ee8eb6b3a134,
		0xb5418b8ea8ead17b,
		0xb737e899dd6633f1,
		0xba77e3fa3aa9b6ca,
		0xc5e65eec3dcf5b10,
		0xc76ccd4502bb61e7,
		0xcc2f70676afee4e7,
		0xceba3c1a97be15f8,
		0xd0476e0f34d1411a,
		0xd9d61d1d803c85fc,
		0xde3a625e70772b9a,
		0xdf703ca0befc3afc,
		0xe00e522611477055,
		0xe313695ea9477b30,
		0xe5ea916eb0c31336,
		0xf026e3d750335bc1,
		0xf34be5cbac1feed1,
		0xf41122f890a371a6,
		0xf44732c48f949ab8,
		0xf8e86a5c0baa01bc,
		0xf9b3cd8033aba1f8)
}
