// Code generated by capnpc-go. DO NOT EDIT.

package rpc

import (
	capnp "capnproto.org/go/capnp/v3"
	text "capnproto.org/go/capnp/v3/encoding/text"
	schemas "capnproto.org/go/capnp/v3/schemas"
	strconv "strconv"
)

type Message capnp.Struct
type Message_Which uint16

const (
	Message_Which_unimplemented  Message_Which = 0
	Message_Which_abort          Message_Which = 1
	Message_Which_bootstrap      Message_Which = 8
	Message_Which_call           Message_Which = 2
	Message_Which_return         Message_Which = 3
	Message_Which_finish         Message_Which = 4
	Message_Which_resolve        Message_Which = 5
	Message_Which_release        Message_Which = 6
	Message_Which_disembargo     Message_Which = 13
	Message_Which_obsoleteSave   Message_Which = 7
	Message_Which_obsoleteDelete Message_Which = 9
	Message_Which_provide        Message_Which = 10
	Message_Which_accept         Message_Which = 11
	Message_Which_join           Message_Which = 12
)

func (w Message_Which) String() string {
	const s = "unimplementedabortbootstrapcallreturnfinishresolvereleasedisembargoobsoleteSaveobsoleteDeleteprovideacceptjoin"
	switch w {
	case Message_Which_unimplemented:
		return s[0:13]
	case Message_Which_abort:
		return s[13:18]
	case Message_Which_bootstrap:
		return s[18:27]
	case Message_Which_call:
		return s[27:31]
	case Message_Which_return:
		return s[31:37]
	case Message_Which_finish:
		return s[37:43]
	case Message_Which_resolve:
		return s[43:50]
	case Message_Which_release:
		return s[50:57]
	case Message_Which_disembargo:
		return s[57:67]
	case Message_Which_obsoleteSave:
		return s[67:79]
	case Message_Which_obsoleteDelete:
		return s[79:93]
	case Message_Which_provide:
		return s[93:100]
	case Message_Which_accept:
		return s[100:106]
	case Message_Which_join:
		return s[106:110]

	}
	return "Message_Which(" + strconv.FormatUint(uint64(w), 10) + ")"
}

// Message_TypeID is the unique identifier for the type Message.
const Message_TypeID = 0x91b79f1f808db032

func NewMessage(s *capnp.Segment) (Message, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return Message(st), err
}

func NewRootMessage(s *capnp.Segment) (Message, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return Message(st), err
}

func ReadRootMessage(msg *capnp.Message) (Message, error) {
	root, err := msg.Root()
	return Message(root.Struct()), err
}

func (s Message) String() string {
	str, _ := text.Marshal(0x91b79f1f808db032, capnp.Struct(s))
	return str
}

func (s Message) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Message) DecodeFromPtr(p capnp.Ptr) Message {
	return Message(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Message) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}

func (s Message) Which() Message_Which {
	return Message_Which(capnp.Struct(s).Uint16(0))
}
func (s Message) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Message) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Message) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Message) Unimplemented() (Message, error) {
	if capnp.Struct(s).Uint16(0) != 0 {
		panic("Which() != unimplemented")
	}
	p, err := capnp.Struct(s).Ptr(0)
	return Message(p.Struct()), err
}

func (s Message) HasUnimplemented() bool {
	if capnp.Struct(s).Uint16(0) != 0 {
		return false
	}
	return capnp.Struct(s).HasPtr(0)
}

func (s Message) SetUnimplemented(v Message) error {
	capnp.Struct(s).SetUint16(0, 0)
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewUnimplemented sets the unimplemented field to a newly
// allocated Message struct, preferring placement in s's segment.
func (s Message) NewUnimplemented() (Message, error) {
	capnp.Struct(s).SetUint16(0, 0)
	ss, err := NewMessage(capnp.Struct(s).Segment())
	if err != nil {
		return Message{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

func (s Message) Abort() (Exception, error) {
	if capnp.Struct(s).Uint16(0) != 1 {
		panic("Which() != abort")
	}
	p, err := capnp.Struct(s).Ptr(0)
	return Exception(p.Struct()), err
}

func (s Message) HasAbort() bool {
	if capnp.Struct(s).Uint16(0) != 1 {
		return false
	}
	return capnp.Struct(s).HasPtr(0)
}

func (s Message) SetAbort(v Exception) error {
	capnp.Struct(s).SetUint16(0, 1)
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewAbort sets the abort field to a newly
// allocated Exception struct, preferring placement in s's segment.
func (s Message) NewAbort() (Exception, error) {
	capnp.Struct(s).SetUint16(0, 1)
	ss, err := NewException(capnp.Struct(s).Segment())
	if err != nil {
		return Exception{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

func (s Message) Bootstrap() (Bootstrap, error) {
	if capnp.Struct(s).Uint16(0) != 8 {
		panic("Which() != bootstrap")
	}
	p, err := capnp.Struct(s).Ptr(0)
	return Bootstrap(p.Struct()), err
}

func (s Message) HasBootstrap() bool {
	if capnp.Struct(s).Uint16(0) != 8 {
		return false
	}
	return capnp.Struct(s).HasPtr(0)
}

func (s Message) SetBootstrap(v Bootstrap) error {
	capnp.Struct(s).SetUint16(0, 8)
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewBootstrap sets the bootstrap field to a newly
// allocated Bootstrap struct, preferring placement in s's segment.
func (s Message) NewBootstrap() (Bootstrap, error) {
	capnp.Struct(s).SetUint16(0, 8)
	ss, err := NewBootstrap(capnp.Struct(s).Segment())
	if err != nil {
		return Bootstrap{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

func (s Message) Call() (Call, error) {
	if capnp.Struct(s).Uint16(0) != 2 {
		panic("Which() != call")
	}
	p, err := capnp.Struct(s).Ptr(0)
	return Call(p.Struct()), err
}

func (s Message) HasCall() bool {
	if capnp.Struct(s).Uint16(0) != 2 {
		return false
	}
	return capnp.Struct(s).HasPtr(0)
}

func (s Message) SetCall(v Call) error {
	capnp.Struct(s).SetUint16(0, 2)
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewCall sets the call field to a newly
// allocated Call struct, preferring placement in s's segment.
func (s Message) NewCall() (Call, error) {
	capnp.Struct(s).SetUint16(0, 2)
	ss, err := NewCall(capnp.Struct(s).Segment())
	if err != nil {
		return Call{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

func (s Message) Return() (Return, error) {
	if capnp.Struct(s).Uint16(0) != 3 {
		panic("Which() != return")
	}
	p, err := capnp.Struct(s).Ptr(0)
	return Return(p.Struct()), err
}

func (s Message) HasReturn() bool {
	if capnp.Struct(s).Uint16(0) != 3 {
		return false
	}
	return capnp.Struct(s).HasPtr(0)
}

func (s Message) SetReturn(v Return) error {
	capnp.Struct(s).SetUint16(0, 3)
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewReturn sets the return field to a newly
// allocated Return struct, preferring placement in s's segment.
func (s Message) NewReturn() (Return, error) {
	capnp.Struct(s).SetUint16(0, 3)
	ss, err := NewReturn(capnp.Struct(s).Segment())
	if err != nil {
		return Return{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

func (s Message) Finish() (Finish, error) {
	if capnp.Struct(s).Uint16(0) != 4 {
		panic("Which() != finish")
	}
	p, err := capnp.Struct(s).Ptr(0)
	return Finish(p.Struct()), err
}

func (s Message) HasFinish() bool {
	if capnp.Struct(s).Uint16(0) != 4 {
		return false
	}
	return capnp.Struct(s).HasPtr(0)
}

func (s Message) SetFinish(v Finish) error {
	capnp.Struct(s).SetUint16(0, 4)
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewFinish sets the finish field to a newly
// allocated Finish struct, preferring placement in s's segment.
func (s Message) NewFinish() (Finish, error) {
	capnp.Struct(s).SetUint16(0, 4)
	ss, err := NewFinish(capnp.Struct(s).Segment())
	if err != nil {
		return Finish{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

func (s Message) Resolve() (Resolve, error) {
	if capnp.Struct(s).Uint16(0) != 5 {
		panic("Which() != resolve")
	}
	p, err := capnp.Struct(s).Ptr(0)
	return Resolve(p.Struct()), err
}

func (s Message) HasResolve() bool {
	if capnp.Struct(s).Uint16(0) != 5 {
		return false
	}
	return capnp.Struct(s).HasPtr(0)
}

func (s Message) SetResolve(v Resolve) error {
	capnp.Struct(s).SetUint16(0, 5)
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewResolve sets the resolve field to a newly
// allocated Resolve struct, preferring placement in s's segment.
func (s Message) NewResolve() (Resolve, error) {
	capnp.Struct(s).SetUint16(0, 5)
	ss, err := NewResolve(capnp.Struct(s).Segment())
	if err != nil {
		return Resolve{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

func (s Message) Release() (Release, error) {
	if capnp.Struct(s).Uint16(0) != 6 {
		panic("Which() != release")
	}
	p, err := capnp.Struct(s).Ptr(0)
	return Release(p.Struct()), err
}

func (s Message) HasRelease() bool {
	if capnp.Struct(s).Uint16(0) != 6 {
		return false
	}
	return capnp.Struct(s).HasPtr(0)
}

func (s Message) SetRelease(v Release) error {
	capnp.Struct(s).SetUint16(0, 6)
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewRelease sets the release field to a newly
// allocated Release struct, preferring placement in s's segment.
func (s Message) NewRelease() (Release, error) {
	capnp.Struct(s).SetUint16(0, 6)
	ss, err := NewRelease(capnp.Struct(s).Segment())
	if err != nil {
		return Release{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

func (s Message) Disembargo() (Disembargo, error) {
	if capnp.Struct(s).Uint16(0) != 13 {
		panic("Which() != disembargo")
	}
	p, err := capnp.Struct(s).Ptr(0)
	return Disembargo(p.Struct()), err
}

func (s Message) HasDisembargo() bool {
	if capnp.Struct(s).Uint16(0) != 13 {
		return false
	}
	return capnp.Struct(s).HasPtr(0)
}

func (s Message) SetDisembargo(v Disembargo) error {
	capnp.Struct(s).SetUint16(0, 13)
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewDisembargo sets the disembargo field to a newly
// allocated Disembargo struct, preferring placement in s's segment.
func (s Message) NewDisembargo() (Disembargo, error) {
	capnp.Struct(s).SetUint16(0, 13)
	ss, err := NewDisembargo(capnp.Struct(s).Segment())
	if err != nil {
		return Disembargo{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

func (s Message) ObsoleteSave() (capnp.Ptr, error) {
	if capnp.Struct(s).Uint16(0) != 7 {
		panic("Which() != obsoleteSave")
	}
	return capnp.Struct(s).Ptr(0)
}

func (s Message) HasObsoleteSave() bool {
	if capnp.Struct(s).Uint16(0) != 7 {
		return false
	}
	return capnp.Struct(s).HasPtr(0)
}

func (s Message) SetObsoleteSave(v capnp.Ptr) error {
	capnp.Struct(s).SetUint16(0, 7)
	return capnp.Struct(s).SetPtr(0, v)
}

func (s Message) ObsoleteDelete() (capnp.Ptr, error) {
	if capnp.Struct(s).Uint16(0) != 9 {
		panic("Which() != obsoleteDelete")
	}
	return capnp.Struct(s).Ptr(0)
}

func (s Message) HasObsoleteDelete() bool {
	if capnp.Struct(s).Uint16(0) != 9 {
		return false
	}
	return capnp.Struct(s).HasPtr(0)
}

func (s Message) SetObsoleteDelete(v capnp.Ptr) error {
	capnp.Struct(s).SetUint16(0, 9)
	return capnp.Struct(s).SetPtr(0, v)
}

func (s Message) Provide() (Provide, error) {
	if capnp.Struct(s).Uint16(0) != 10 {
		panic("Which() != provide")
	}
	p, err := capnp.Struct(s).Ptr(0)
	return Provide(p.Struct()), err
}

func (s Message) HasProvide() bool {
	if capnp.Struct(s).Uint16(0) != 10 {
		return false
	}
	return capnp.Struct(s).HasPtr(0)
}

func (s Message) SetProvide(v Provide) error {
	capnp.Struct(s).SetUint16(0, 10)
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewProvide sets the provide field to a newly
// allocated Provide struct, preferring placement in s's segment.
func (s Message) NewProvide() (Provide, error) {
	capnp.Struct(s).SetUint16(0, 10)
	ss, err := NewProvide(capnp.Struct(s).Segment())
	if err != nil {
		return Provide{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

func (s Message) Accept() (Accept, error) {
	if capnp.Struct(s).Uint16(0) != 11 {
		panic("Which() != accept")
	}
	p, err := capnp.Struct(s).Ptr(0)
	return Accept(p.Struct()), err
}

func (s Message) HasAccept() bool {
	if capnp.Struct(s).Uint16(0) != 11 {
		return false
	}
	return capnp.Struct(s).HasPtr(0)
}

func (s Message) SetAccept(v Accept) error {
	capnp.Struct(s).SetUint16(0, 11)
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewAccept sets the accept field to a newly
// allocated Accept struct, preferring placement in s's segment.
func (s Message) NewAccept() (Accept, error) {
	capnp.Struct(s).SetUint16(0, 11)
	ss, err := NewAccept(capnp.Struct(s).Segment())
	if err != nil {
		return Accept{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

func (s Message) Join() (Join, error) {
	if capnp.Struct(s).Uint16(0) != 12 {
		panic("Which() != join")
	}
	p, err := capnp.Struct(s).Ptr(0)
	return Join(p.Struct()), err
}

func (s Message) HasJoin() bool {
	if capnp.Struct(s).Uint16(0) != 12 {
		return false
	}
	return capnp.Struct(s).HasPtr(0)
}

func (s Message) SetJoin(v Join) error {
	capnp.Struct(s).SetUint16(0, 12)
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewJoin sets the join field to a newly
// allocated Join struct, preferring placement in s's segment.
func (s Message) NewJoin() (Join, error) {
	capnp.Struct(s).SetUint16(0, 12)
	ss, err := NewJoin(capnp.Struct(s).Segment())
	if err != nil {
		return Join{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

// Message_List is a list of Message.
type Message_List = capnp.StructList[Message]

// NewMessage creates a new list of Message.
func NewMessage_List(s *capnp.Segment, sz int32) (Message_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1}, sz)
	return capnp.StructList[Message](l), err
}

// Message_Future is a wrapper for a Message promised by a client call.
type Message_Future struct{ *capnp.Future }

func (p Message_Future) Struct() (Message, error) {
	s, err := p.Future.Struct()
	return Message(s), err
}

func (p Message_Future) Unimplemented() Message_Future {
	return Message_Future{Future: p.Future.Field(0, nil)}
}

func (p Message_Future) Abort() Exception_Future {
	return Exception_Future{Future: p.Future.Field(0, nil)}
}

func (p Message_Future) Bootstrap() Bootstrap_Future {
	return Bootstrap_Future{Future: p.Future.Field(0, nil)}
}

func (p Message_Future) Call() Call_Future {
	return Call_Future{Future: p.Future.Field(0, nil)}
}

func (p Message_Future) Return() Return_Future {
	return Return_Future{Future: p.Future.Field(0, nil)}
}

func (p Message_Future) Finish() Finish_Future {
	return Finish_Future{Future: p.Future.Field(0, nil)}
}

func (p Message_Future) Resolve() Resolve_Future {
	return Resolve_Future{Future: p.Future.Field(0, nil)}
}

func (p Message_Future) Release() Release_Future {
	return Release_Future{Future: p.Future.Field(0, nil)}
}

func (p Message_Future) Disembargo() Disembargo_Future {
	return Disembargo_Future{Future: p.Future.Field(0, nil)}
}

func (p Message_Future) ObsoleteSave() *capnp.Future {
	return p.Future.Field(0, nil)
}

func (p Message_Future) ObsoleteDelete() *capnp.Future {
	return p.Future.Field(0, nil)
}

func (p Message_Future) Provide() Provide_Future {
	return Provide_Future{Future: p.Future.Field(0, nil)}
}

func (p Message_Future) Accept() Accept_Future {
	return Accept_Future{Future: p.Future.Field(0, nil)}
}

func (p Message_Future) Join() Join_Future {
	return Join_Future{Future: p.Future.Field(0, nil)}
}

type Bootstrap capnp.Struct

// Bootstrap_TypeID is the unique identifier for the type Bootstrap.
const Bootstrap_TypeID = 0xe94ccf8031176ec4

func NewBootstrap(s *capnp.Segment) (Bootstrap, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return Bootstrap(st), err
}

func NewRootBootstrap(s *capnp.Segment) (Bootstrap, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return Bootstrap(st), err
}

func ReadRootBootstrap(msg *capnp.Message) (Bootstrap, error) {
	root, err := msg.Root()
	return Bootstrap(root.Struct()), err
}

func (s Bootstrap) String() string {
	str, _ := text.Marshal(0xe94ccf8031176ec4, capnp.Struct(s))
	return str
}

func (s Bootstrap) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Bootstrap) DecodeFromPtr(p capnp.Ptr) Bootstrap {
	return Bootstrap(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Bootstrap) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Bootstrap) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Bootstrap) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Bootstrap) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Bootstrap) QuestionId() uint32 {
	return capnp.Struct(s).Uint32(0)
}

func (s Bootstrap) SetQuestionId(v uint32) {
	capnp.Struct(s).SetUint32(0, v)
}

func (s Bootstrap) DeprecatedObjectId() (capnp.Ptr, error) {
	return capnp.Struct(s).Ptr(0)
}

func (s Bootstrap) HasDeprecatedObjectId() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Bootstrap) SetDeprecatedObjectId(v capnp.Ptr) error {
	return capnp.Struct(s).SetPtr(0, v)
}

// Bootstrap_List is a list of Bootstrap.
type Bootstrap_List = capnp.StructList[Bootstrap]

// NewBootstrap creates a new list of Bootstrap.
func NewBootstrap_List(s *capnp.Segment, sz int32) (Bootstrap_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1}, sz)
	return capnp.StructList[Bootstrap](l), err
}

// Bootstrap_Future is a wrapper for a Bootstrap promised by a client call.
type Bootstrap_Future struct{ *capnp.Future }

func (p Bootstrap_Future) Struct() (Bootstrap, error) {
	s, err := p.Future.Struct()
	return Bootstrap(s), err
}

func (p Bootstrap_Future) DeprecatedObjectId() *capnp.Future {
	return p.Future.Field(0, nil)
}

type Call capnp.Struct
type Call_sendResultsTo Call
type Call_sendResultsTo_Which uint16

const (
	Call_sendResultsTo_Which_caller     Call_sendResultsTo_Which = 0
	Call_sendResultsTo_Which_yourself   Call_sendResultsTo_Which = 1
	Call_sendResultsTo_Which_thirdParty Call_sendResultsTo_Which = 2
)

func (w Call_sendResultsTo_Which) String() string {
	const s = "calleryourselfthirdParty"
	switch w {
	case Call_sendResultsTo_Which_caller:
		return s[0:6]
	case Call_sendResultsTo_Which_yourself:
		return s[6:14]
	case Call_sendResultsTo_Which_thirdParty:
		return s[14:24]

	}
	return "Call_sendResultsTo_Which(" + strconv.FormatUint(uint64(w), 10) + ")"
}

// Call_TypeID is the unique identifier for the type Call.
const Call_TypeID = 0x836a53ce789d4cd4

func NewCall(s *capnp.Segment) (Call, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 24, PointerCount: 3})
	return Call(st), err
}

func NewRootCall(s *capnp.Segment) (Call, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 24, PointerCount: 3})
	return Call(st), err
}

func ReadRootCall(msg *capnp.Message) (Call, error) {
	root, err := msg.Root()
	return Call(root.Struct()), err
}

func (s Call) String() string {
	str, _ := text.Marshal(0x836a53ce789d4cd4, capnp.Struct(s))
	return str
}

func (s Call) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Call) DecodeFromPtr(p capnp.Ptr) Call {
	return Call(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Call) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Call) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Call) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Call) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Call) QuestionId() uint32 {
	return capnp.Struct(s).Uint32(0)
}

func (s Call) SetQuestionId(v uint32) {
	capnp.Struct(s).SetUint32(0, v)
}

func (s Call) Target() (MessageTarget, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return MessageTarget(p.Struct()), err
}

func (s Call) HasTarget() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Call) SetTarget(v MessageTarget) error {
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewTarget sets the target field to a newly
// allocated MessageTarget struct, preferring placement in s's segment.
func (s Call) NewTarget() (MessageTarget, error) {
	ss, err := NewMessageTarget(capnp.Struct(s).Segment())
	if err != nil {
		return MessageTarget{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

func (s Call) InterfaceId() uint64 {
	return capnp.Struct(s).Uint64(8)
}

func (s Call) SetInterfaceId(v uint64) {
	capnp.Struct(s).SetUint64(8, v)
}

func (s Call) MethodId() uint16 {
	return capnp.Struct(s).Uint16(4)
}

func (s Call) SetMethodId(v uint16) {
	capnp.Struct(s).SetUint16(4, v)
}

func (s Call) AllowThirdPartyTailCall() bool {
	return capnp.Struct(s).Bit(128)
}

func (s Call) SetAllowThirdPartyTailCall(v bool) {
	capnp.Struct(s).SetBit(128, v)
}

func (s Call) Params() (Payload, error) {
	p, err := capnp.Struct(s).Ptr(1)
	return Payload(p.Struct()), err
}

func (s Call) HasParams() bool {
	return capnp.Struct(s).HasPtr(1)
}

func (s Call) SetParams(v Payload) error {
	return capnp.Struct(s).SetPtr(1, capnp.Struct(v).ToPtr())
}

// NewParams sets the params field to a newly
// allocated Payload struct, preferring placement in s's segment.
func (s Call) NewParams() (Payload, error) {
	ss, err := NewPayload(capnp.Struct(s).Segment())
	if err != nil {
		return Payload{}, err
	}
	err = capnp.Struct(s).SetPtr(1, capnp.Struct(ss).ToPtr())
	return ss, err
}

func (s Call) SendResultsTo() Call_sendResultsTo { return Call_sendResultsTo(s) }

func (s Call_sendResultsTo) Which() Call_sendResultsTo_Which {
	return Call_sendResultsTo_Which(capnp.Struct(s).Uint16(6))
}
func (s Call_sendResultsTo) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Call_sendResultsTo) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Call_sendResultsTo) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Call_sendResultsTo) SetCaller() {
	capnp.Struct(s).SetUint16(6, 0)

}

func (s Call_sendResultsTo) SetYourself() {
	capnp.Struct(s).SetUint16(6, 1)

}

func (s Call_sendResultsTo) ThirdParty() (capnp.Ptr, error) {
	if capnp.Struct(s).Uint16(6) != 2 {
		panic("Which() != thirdParty")
	}
	return capnp.Struct(s).Ptr(2)
}

func (s Call_sendResultsTo) HasThirdParty() bool {
	if capnp.Struct(s).Uint16(6) != 2 {
		return false
	}
	return capnp.Struct(s).HasPtr(2)
}

func (s Call_sendResultsTo) SetThirdParty(v capnp.Ptr) error {
	capnp.Struct(s).SetUint16(6, 2)
	return capnp.Struct(s).SetPtr(2, v)
}

// Call_List is a list of Call.
type Call_List = capnp.StructList[Call]

// NewCall creates a new list of Call.
func NewCall_List(s *capnp.Segment, sz int32) (Call_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 24, PointerCount: 3}, sz)
	return capnp.StructList[Call](l), err
}

// Call_Future is a wrapper for a Call promised by a client call.
type Call_Future struct{ *capnp.Future }

func (p Call_Future) Struct() (Call, error) {
	s, err := p.Future.Struct()
	return Call(s), err
}

func (p Call_Future) Target() MessageTarget_Future {
	return MessageTarget_Future{Future: p.Future.Field(0, nil)}
}

func (p Call_Future) Params() Payload_Future {
	return Payload_Future{Future: p.Future.Field(1, nil)}
}

func (p Call_Future) SendResultsTo() Call_sendResultsTo_Future {
	return Call_sendResultsTo_Future{p.Future}
}

// Call_sendResultsTo_Future is a wrapper for a Call_sendResultsTo promised by a client call.
type Call_sendResultsTo_Future struct{ *capnp.Future }

func (p Call_sendResultsTo_Future) Struct() (Call_sendResultsTo, error) {
	s, err := p.Future.Struct()
	return Call_sendResultsTo(s), err
}

func (p Call_sendResultsTo_Future) ThirdParty() *capnp.Future {
	return p.Future.Field(2, nil)
}

type Return capnp.Struct
type Return_Which uint16

const (
	Return_Which_results               Return_Which = 0
	Return_Which_exception             Return_Which = 1
	Return_Which_canceled              Return_Which = 2
	Return_Which_resultsSentElsewhere  Return_Which = 3
	Return_Which_takeFromOtherQuestion Return_Which = 4
	Return_Which_acceptFromThirdParty  Return_Which = 5
)

func (w Return_Which) String() string {
	const s = "resultsexceptioncanceledresultsSentElsewheretakeFromOtherQuestionacceptFromThirdParty"
	switch w {
	case Return_Which_results:
		return s[0:7]
	case Return_Which_exception:
		return s[7:16]
	case Return_Which_canceled:
		return s[16:24]
	case Return_Which_resultsSentElsewhere:
		return s[24:44]
	case Return_Which_takeFromOtherQuestion:
		return s[44:65]
	case Return_Which_acceptFromThirdParty:
		return s[65:85]

	}
	return "Return_Which(" + strconv.FormatUint(uint64(w), 10) + ")"
}

// Return_TypeID is the unique identifier for the type Return.
const Return_TypeID = 0x9e19b28d3db3573a

func NewReturn(s *capnp.Segment) (Return, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 16, PointerCount: 1})
	return Return(st), err
}

func NewRootReturn(s *capnp.Segment) (Return, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 16, PointerCount: 1})
	return Return(st), err
}

func ReadRootReturn(msg *capnp.Message) (Return, error) {
	root, err := msg.Root()
	return Return(root.Struct()), err
}

func (s Return) String() string {
	str, _ := text.Marshal(0x9e19b28d3db3573a, capnp.Struct(s))
	return str
}

func (s Return) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Return) DecodeFromPtr(p capnp.Ptr) Return {
	return Return(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Return) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}

func (s Return) Which() Return_Which {
	return Return_Which(capnp.Struct(s).Uint16(6))
}
func (s Return) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Return) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Return) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Return) AnswerId() uint32 {
	return capnp.Struct(s).Uint32(0)
}

func (s Return) SetAnswerId(v uint32) {
	capnp.Struct(s).SetUint32(0, v)
}

func (s Return) ReleaseParamCaps() bool {
	return !capnp.Struct(s).Bit(32)
}

func (s Return) SetReleaseParamCaps(v bool) {
	capnp.Struct(s).SetBit(32, !v)
}

func (s Return) Results() (Payload, error) {
	if capnp.Struct(s).Uint16(6) != 0 {
		panic("Which() != results")
	}
	p, err := capnp.Struct(s).Ptr(0)
	return Payload(p.Struct()), err
}

func (s Return) HasResults() bool {
	if capnp.Struct(s).Uint16(6) != 0 {
		return false
	}
	return capnp.Struct(s).HasPtr(0)
}

func (s Return) SetResults(v Payload) error {
	capnp.Struct(s).SetUint16(6, 0)
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewResults sets the results field to a newly
// allocated Payload struct, preferring placement in s's segment.
func (s Return) NewResults() (Payload, error) {
	capnp.Struct(s).SetUint16(6, 0)
	ss, err := NewPayload(capnp.Struct(s).Segment())
	if err != nil {
		return Payload{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

func (s Return) Exception() (Exception, error) {
	if capnp.Struct(s).Uint16(6) != 1 {
		panic("Which() != exception")
	}
	p, err := capnp.Struct(s).Ptr(0)
	return Exception(p.Struct()), err
}

func (s Return) HasException() bool {
	if capnp.Struct(s).Uint16(6) != 1 {
		return false
	}
	return capnp.Struct(s).HasPtr(0)
}

func (s Return) SetException(v Exception) error {
	capnp.Struct(s).SetUint16(6, 1)
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewException sets the exception field to a newly
// allocated Exception struct, preferring placement in s's segment.
func (s Return) NewException() (Exception, error) {
	capnp.Struct(s).SetUint16(6, 1)
	ss, err := NewException(capnp.Struct(s).Segment())
	if err != nil {
		return Exception{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

func (s Return) SetCanceled() {
	capnp.Struct(s).SetUint16(6, 2)

}

func (s Return) SetResultsSentElsewhere() {
	capnp.Struct(s).SetUint16(6, 3)

}

func (s Return) TakeFromOtherQuestion() uint32 {
	if capnp.Struct(s).Uint16(6) != 4 {
		panic("Which() != takeFromOtherQuestion")
	}
	return capnp.Struct(s).Uint32(8)
}

func (s Return) SetTakeFromOtherQuestion(v uint32) {
	capnp.Struct(s).SetUint16(6, 4)
	capnp.Struct(s).SetUint32(8, v)
}

func (s Return) AcceptFromThirdParty() (capnp.Ptr, error) {
	if capnp.Struct(s).Uint16(6) != 5 {
		panic("Which() != acceptFromThirdParty")
	}
	return capnp.Struct(s).Ptr(0)
}

func (s Return) HasAcceptFromThirdParty() bool {
	if capnp.Struct(s).Uint16(6) != 5 {
		return false
	}
	return capnp.Struct(s).HasPtr(0)
}

func (s Return) SetAcceptFromThirdParty(v capnp.Ptr) error {
	capnp.Struct(s).SetUint16(6, 5)
	return capnp.Struct(s).SetPtr(0, v)
}

// Return_List is a list of Return.
type Return_List = capnp.StructList[Return]

// NewReturn creates a new list of Return.
func NewReturn_List(s *capnp.Segment, sz int32) (Return_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 16, PointerCount: 1}, sz)
	return capnp.StructList[Return](l), err
}

// Return_Future is a wrapper for a Return promised by a client call.
type Return_Future struct{ *capnp.Future }

func (p Return_Future) Struct() (Return, error) {
	s, err := p.Future.Struct()
	return Return(s), err
}

func (p Return_Future) Results() Payload_Future {
	return Payload_Future{Future: p.Future.Field(0, nil)}
}

func (p Return_Future) Exception() Exception_Future {
	return Exception_Future{Future: p.Future.Field(0, nil)}
}

func (p Return_Future) AcceptFromThirdParty() *capnp.Future {
	return p.Future.Field(0, nil)
}

type Finish capnp.Struct

// Finish_TypeID is the unique identifier for the type Finish.
const Finish_TypeID = 0xd37d2eb2c2f80e63

func NewFinish(s *capnp.Segment) (Finish, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 0})
	return Finish(st), err
}

func NewRootFinish(s *capnp.Segment) (Finish, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 0})
	return Finish(st), err
}

func ReadRootFinish(msg *capnp.Message) (Finish, error) {
	root, err := msg.Root()
	return Finish(root.Struct()), err
}

func (s Finish) String() string {
	str, _ := text.Marshal(0xd37d2eb2c2f80e63, capnp.Struct(s))
	return str
}

func (s Finish) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Finish) DecodeFromPtr(p capnp.Ptr) Finish {
	return Finish(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Finish) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Finish) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Finish) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Finish) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Finish) QuestionId() uint32 {
	return capnp.Struct(s).Uint32(0)
}

func (s Finish) SetQuestionId(v uint32) {
	capnp.Struct(s).SetUint32(0, v)
}

func (s Finish) ReleaseResultCaps() bool {
	return !capnp.Struct(s).Bit(32)
}

func (s Finish) SetReleaseResultCaps(v bool) {
	capnp.Struct(s).SetBit(32, !v)
}

// Finish_List is a list of Finish.
type Finish_List = capnp.StructList[Finish]

// NewFinish creates a new list of Finish.
func NewFinish_List(s *capnp.Segment, sz int32) (Finish_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 0}, sz)
	return capnp.StructList[Finish](l), err
}

// Finish_Future is a wrapper for a Finish promised by a client call.
type Finish_Future struct{ *capnp.Future }

func (p Finish_Future) Struct() (Finish, error) {
	s, err := p.Future.Struct()
	return Finish(s), err
}

type Resolve capnp.Struct
type Resolve_Which uint16

const (
	Resolve_Which_cap       Resolve_Which = 0
	Resolve_Which_exception Resolve_Which = 1
)

func (w Resolve_Which) String() string {
	const s = "capexception"
	switch w {
	case Resolve_Which_cap:
		return s[0:3]
	case Resolve_Which_exception:
		return s[3:12]

	}
	return "Resolve_Which(" + strconv.FormatUint(uint64(w), 10) + ")"
}

// Resolve_TypeID is the unique identifier for the type Resolve.
const Resolve_TypeID = 0xbbc29655fa89086e

func NewResolve(s *capnp.Segment) (Resolve, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return Resolve(st), err
}

func NewRootResolve(s *capnp.Segment) (Resolve, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return Resolve(st), err
}

func ReadRootResolve(msg *capnp.Message) (Resolve, error) {
	root, err := msg.Root()
	return Resolve(root.Struct()), err
}

func (s Resolve) String() string {
	str, _ := text.Marshal(0xbbc29655fa89086e, capnp.Struct(s))
	return str
}

func (s Resolve) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Resolve) DecodeFromPtr(p capnp.Ptr) Resolve {
	return Resolve(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Resolve) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}

func (s Resolve) Which() Resolve_Which {
	return Resolve_Which(capnp.Struct(s).Uint16(4))
}
func (s Resolve) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Resolve) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Resolve) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Resolve) PromiseId() uint32 {
	return capnp.Struct(s).Uint32(0)
}

func (s Resolve) SetPromiseId(v uint32) {
	capnp.Struct(s).SetUint32(0, v)
}

func (s Resolve) Cap() (CapDescriptor, error) {
	if capnp.Struct(s).Uint16(4) != 0 {
		panic("Which() != cap")
	}
	p, err := capnp.Struct(s).Ptr(0)
	return CapDescriptor(p.Struct()), err
}

func (s Resolve) HasCap() bool {
	if capnp.Struct(s).Uint16(4) != 0 {
		return false
	}
	return capnp.Struct(s).HasPtr(0)
}

func (s Resolve) SetCap(v CapDescriptor) error {
	capnp.Struct(s).SetUint16(4, 0)
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewCap sets the cap field to a newly
// allocated CapDescriptor struct, preferring placement in s's segment.
func (s Resolve) NewCap() (CapDescriptor, error) {
	capnp.Struct(s).SetUint16(4, 0)
	ss, err := NewCapDescriptor(capnp.Struct(s).Segment())
	if err != nil {
		return CapDescriptor{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

func (s Resolve) Exception() (Exception, error) {
	if capnp.Struct(s).Uint16(4) != 1 {
		panic("Which() != exception")
	}
	p, err := capnp.Struct(s).Ptr(0)
	return Exception(p.Struct()), err
}

func (s Resolve) HasException() bool {
	if capnp.Struct(s).Uint16(4) != 1 {
		return false
	}
	return capnp.Struct(s).HasPtr(0)
}

func (s Resolve) SetException(v Exception) error {
	capnp.Struct(s).SetUint16(4, 1)
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewException sets the exception field to a newly
// allocated Exception struct, preferring placement in s's segment.
func (s Resolve) NewException() (Exception, error) {
	capnp.Struct(s).SetUint16(4, 1)
	ss, err := NewException(capnp.Struct(s).Segment())
	if err != nil {
		return Exception{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

// Resolve_List is a list of Resolve.
type Resolve_List = capnp.StructList[Resolve]

// NewResolve creates a new list of Resolve.
func NewResolve_List(s *capnp.Segment, sz int32) (Resolve_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1}, sz)
	return capnp.StructList[Resolve](l), err
}

// Resolve_Future is a wrapper for a Resolve promised by a client call.
type Resolve_Future struct{ *capnp.Future }

func (p Resolve_Future) Struct() (Resolve, error) {
	s, err := p.Future.Struct()
	return Resolve(s), err
}

func (p Resolve_Future) Cap() CapDescriptor_Future {
	return CapDescriptor_Future{Future: p.Future.Field(0, nil)}
}

func (p Resolve_Future) Exception() Exception_Future {
	return Exception_Future{Future: p.Future.Field(0, nil)}
}

type Release capnp.Struct

// Release_TypeID is the unique identifier for the type Release.
const Release_TypeID = 0xad1a6c0d7dd07497

func NewRelease(s *capnp.Segment) (Release, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 0})
	return Release(st), err
}

func NewRootRelease(s *capnp.Segment) (Release, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 0})
	return Release(st), err
}

func ReadRootRelease(msg *capnp.Message) (Release, error) {
	root, err := msg.Root()
	return Release(root.Struct()), err
}

func (s Release) String() string {
	str, _ := text.Marshal(0xad1a6c0d7dd07497, capnp.Struct(s))
	return str
}

func (s Release) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Release) DecodeFromPtr(p capnp.Ptr) Release {
	return Release(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Release) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Release) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Release) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Release) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Release) Id() uint32 {
	return capnp.Struct(s).Uint32(0)
}

func (s Release) SetId(v uint32) {
	capnp.Struct(s).SetUint32(0, v)
}

func (s Release) ReferenceCount() uint32 {
	return capnp.Struct(s).Uint32(4)
}

func (s Release) SetReferenceCount(v uint32) {
	capnp.Struct(s).SetUint32(4, v)
}

// Release_List is a list of Release.
type Release_List = capnp.StructList[Release]

// NewRelease creates a new list of Release.
func NewRelease_List(s *capnp.Segment, sz int32) (Release_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 0}, sz)
	return capnp.StructList[Release](l), err
}

// Release_Future is a wrapper for a Release promised by a client call.
type Release_Future struct{ *capnp.Future }

func (p Release_Future) Struct() (Release, error) {
	s, err := p.Future.Struct()
	return Release(s), err
}

type Disembargo capnp.Struct
type Disembargo_context Disembargo
type Disembargo_context_Which uint16

const (
	Disembargo_context_Which_senderLoopback   Disembargo_context_Which = 0
	Disembargo_context_Which_receiverLoopback Disembargo_context_Which = 1
	Disembargo_context_Which_accept           Disembargo_context_Which = 2
	Disembargo_context_Which_provide          Disembargo_context_Which = 3
)

func (w Disembargo_context_Which) String() string {
	const s = "senderLoopbackreceiverLoopbackacceptprovide"
	switch w {
	case Disembargo_context_Which_senderLoopback:
		return s[0:14]
	case Disembargo_context_Which_receiverLoopback:
		return s[14:30]
	case Disembargo_context_Which_accept:
		return s[30:36]
	case Disembargo_context_Which_provide:
		return s[36:43]

	}
	return "Disembargo_context_Which(" + strconv.FormatUint(uint64(w), 10) + ")"
}

// Disembargo_TypeID is the unique identifier for the type Disembargo.
const Disembargo_TypeID = 0xf964368b0fbd3711

func NewDisembargo(s *capnp.Segment) (Disembargo, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return Disembargo(st), err
}

func NewRootDisembargo(s *capnp.Segment) (Disembargo, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return Disembargo(st), err
}

func ReadRootDisembargo(msg *capnp.Message) (Disembargo, error) {
	root, err := msg.Root()
	return Disembargo(root.Struct()), err
}

func (s Disembargo) String() string {
	str, _ := text.Marshal(0xf964368b0fbd3711, capnp.Struct(s))
	return str
}

func (s Disembargo) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Disembargo) DecodeFromPtr(p capnp.Ptr) Disembargo {
	return Disembargo(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Disembargo) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Disembargo) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Disembargo) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Disembargo) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Disembargo) Target() (MessageTarget, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return MessageTarget(p.Struct()), err
}

func (s Disembargo) HasTarget() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Disembargo) SetTarget(v MessageTarget) error {
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewTarget sets the target field to a newly
// allocated MessageTarget struct, preferring placement in s's segment.
func (s Disembargo) NewTarget() (MessageTarget, error) {
	ss, err := NewMessageTarget(capnp.Struct(s).Segment())
	if err != nil {
		return MessageTarget{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

func (s Disembargo) Context() Disembargo_context { return Disembargo_context(s) }

func (s Disembargo_context) Which() Disembargo_context_Which {
	return Disembargo_context_Which(capnp.Struct(s).Uint16(4))
}
func (s Disembargo_context) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Disembargo_context) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Disembargo_context) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Disembargo_context) SenderLoopback() uint32 {
	if capnp.Struct(s).Uint16(4) != 0 {
		panic("Which() != senderLoopback")
	}
	return capnp.Struct(s).Uint32(0)
}

func (s Disembargo_context) SetSenderLoopback(v uint32) {
	capnp.Struct(s).SetUint16(4, 0)
	capnp.Struct(s).SetUint32(0, v)
}

func (s Disembargo_context) ReceiverLoopback() uint32 {
	if capnp.Struct(s).Uint16(4) != 1 {
		panic("Which() != receiverLoopback")
	}
	return capnp.Struct(s).Uint32(0)
}

func (s Disembargo_context) SetReceiverLoopback(v uint32) {
	capnp.Struct(s).SetUint16(4, 1)
	capnp.Struct(s).SetUint32(0, v)
}

func (s Disembargo_context) SetAccept() {
	capnp.Struct(s).SetUint16(4, 2)

}

func (s Disembargo_context) Provide() uint32 {
	if capnp.Struct(s).Uint16(4) != 3 {
		panic("Which() != provide")
	}
	return capnp.Struct(s).Uint32(0)
}

func (s Disembargo_context) SetProvide(v uint32) {
	capnp.Struct(s).SetUint16(4, 3)
	capnp.Struct(s).SetUint32(0, v)
}

// Disembargo_List is a list of Disembargo.
type Disembargo_List = capnp.StructList[Disembargo]

// NewDisembargo creates a new list of Disembargo.
func NewDisembargo_List(s *capnp.Segment, sz int32) (Disembargo_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1}, sz)
	return capnp.StructList[Disembargo](l), err
}

// Disembargo_Future is a wrapper for a Disembargo promised by a client call.
type Disembargo_Future struct{ *capnp.Future }

func (p Disembargo_Future) Struct() (Disembargo, error) {
	s, err := p.Future.Struct()
	return Disembargo(s), err
}

func (p Disembargo_Future) Target() MessageTarget_Future {
	return MessageTarget_Future{Future: p.Future.Field(0, nil)}
}

func (p Disembargo_Future) Context() Disembargo_context_Future {
	return Disembargo_context_Future{p.Future}
}

// Disembargo_context_Future is a wrapper for a Disembargo_context promised by a client call.
type Disembargo_context_Future struct{ *capnp.Future }

func (p Disembargo_context_Future) Struct() (Disembargo_context, error) {
	s, err := p.Future.Struct()
	return Disembargo_context(s), err
}

type Provide capnp.Struct

// Provide_TypeID is the unique identifier for the type Provide.
const Provide_TypeID = 0x9c6a046bfbc1ac5a

func NewProvide(s *capnp.Segment) (Provide, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 2})
	return Provide(st), err
}

func NewRootProvide(s *capnp.Segment) (Provide, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 2})
	return Provide(st), err
}

func ReadRootProvide(msg *capnp.Message) (Provide, error) {
	root, err := msg.Root()
	return Provide(root.Struct()), err
}

func (s Provide) String() string {
	str, _ := text.Marshal(0x9c6a046bfbc1ac5a, capnp.Struct(s))
	return str
}

func (s Provide) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Provide) DecodeFromPtr(p capnp.Ptr) Provide {
	return Provide(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Provide) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Provide) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Provide) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Provide) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Provide) QuestionId() uint32 {
	return capnp.Struct(s).Uint32(0)
}

func (s Provide) SetQuestionId(v uint32) {
	capnp.Struct(s).SetUint32(0, v)
}

func (s Provide) Target() (MessageTarget, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return MessageTarget(p.Struct()), err
}

func (s Provide) HasTarget() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Provide) SetTarget(v MessageTarget) error {
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewTarget sets the target field to a newly
// allocated MessageTarget struct, preferring placement in s's segment.
func (s Provide) NewTarget() (MessageTarget, error) {
	ss, err := NewMessageTarget(capnp.Struct(s).Segment())
	if err != nil {
		return MessageTarget{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

func (s Provide) Recipient() (capnp.Ptr, error) {
	return capnp.Struct(s).Ptr(1)
}

func (s Provide) HasRecipient() bool {
	return capnp.Struct(s).HasPtr(1)
}

func (s Provide) SetRecipient(v capnp.Ptr) error {
	return capnp.Struct(s).SetPtr(1, v)
}

// Provide_List is a list of Provide.
type Provide_List = capnp.StructList[Provide]

// NewProvide creates a new list of Provide.
func NewProvide_List(s *capnp.Segment, sz int32) (Provide_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 2}, sz)
	return capnp.StructList[Provide](l), err
}

// Provide_Future is a wrapper for a Provide promised by a client call.
type Provide_Future struct{ *capnp.Future }

func (p Provide_Future) Struct() (Provide, error) {
	s, err := p.Future.Struct()
	return Provide(s), err
}

func (p Provide_Future) Target() MessageTarget_Future {
	return MessageTarget_Future{Future: p.Future.Field(0, nil)}
}

func (p Provide_Future) Recipient() *capnp.Future {
	return p.Future.Field(1, nil)
}

type Accept capnp.Struct

// Accept_TypeID is the unique identifier for the type Accept.
const Accept_TypeID = 0xd4c9b56290554016

func NewAccept(s *capnp.Segment) (Accept, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return Accept(st), err
}

func NewRootAccept(s *capnp.Segment) (Accept, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return Accept(st), err
}

func ReadRootAccept(msg *capnp.Message) (Accept, error) {
	root, err := msg.Root()
	return Accept(root.Struct()), err
}

func (s Accept) String() string {
	str, _ := text.Marshal(0xd4c9b56290554016, capnp.Struct(s))
	return str
}

func (s Accept) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Accept) DecodeFromPtr(p capnp.Ptr) Accept {
	return Accept(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Accept) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Accept) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Accept) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Accept) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Accept) QuestionId() uint32 {
	return capnp.Struct(s).Uint32(0)
}

func (s Accept) SetQuestionId(v uint32) {
	capnp.Struct(s).SetUint32(0, v)
}

func (s Accept) Provision() (capnp.Ptr, error) {
	return capnp.Struct(s).Ptr(0)
}

func (s Accept) HasProvision() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Accept) SetProvision(v capnp.Ptr) error {
	return capnp.Struct(s).SetPtr(0, v)
}

func (s Accept) Embargo() bool {
	return capnp.Struct(s).Bit(32)
}

func (s Accept) SetEmbargo(v bool) {
	capnp.Struct(s).SetBit(32, v)
}

// Accept_List is a list of Accept.
type Accept_List = capnp.StructList[Accept]

// NewAccept creates a new list of Accept.
func NewAccept_List(s *capnp.Segment, sz int32) (Accept_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1}, sz)
	return capnp.StructList[Accept](l), err
}

// Accept_Future is a wrapper for a Accept promised by a client call.
type Accept_Future struct{ *capnp.Future }

func (p Accept_Future) Struct() (Accept, error) {
	s, err := p.Future.Struct()
	return Accept(s), err
}

func (p Accept_Future) Provision() *capnp.Future {
	return p.Future.Field(0, nil)
}

type Join capnp.Struct

// Join_TypeID is the unique identifier for the type Join.
const Join_TypeID = 0xfbe1980490e001af

func NewJoin(s *capnp.Segment) (Join, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 2})
	return Join(st), err
}

func NewRootJoin(s *capnp.Segment) (Join, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 2})
	return Join(st), err
}

func ReadRootJoin(msg *capnp.Message) (Join, error) {
	root, err := msg.Root()
	return Join(root.Struct()), err
}

func (s Join) String() string {
	str, _ := text.Marshal(0xfbe1980490e001af, capnp.Struct(s))
	return str
}

func (s Join) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Join) DecodeFromPtr(p capnp.Ptr) Join {
	return Join(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Join) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Join) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Join) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Join) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Join) QuestionId() uint32 {
	return capnp.Struct(s).Uint32(0)
}

func (s Join) SetQuestionId(v uint32) {
	capnp.Struct(s).SetUint32(0, v)
}

func (s Join) Target() (MessageTarget, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return MessageTarget(p.Struct()), err
}

func (s Join) HasTarget() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Join) SetTarget(v MessageTarget) error {
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewTarget sets the target field to a newly
// allocated MessageTarget struct, preferring placement in s's segment.
func (s Join) NewTarget() (MessageTarget, error) {
	ss, err := NewMessageTarget(capnp.Struct(s).Segment())
	if err != nil {
		return MessageTarget{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

func (s Join) KeyPart() (capnp.Ptr, error) {
	return capnp.Struct(s).Ptr(1)
}

func (s Join) HasKeyPart() bool {
	return capnp.Struct(s).HasPtr(1)
}

func (s Join) SetKeyPart(v capnp.Ptr) error {
	return capnp.Struct(s).SetPtr(1, v)
}

// Join_List is a list of Join.
type Join_List = capnp.StructList[Join]

// NewJoin creates a new list of Join.
func NewJoin_List(s *capnp.Segment, sz int32) (Join_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 2}, sz)
	return capnp.StructList[Join](l), err
}

// Join_Future is a wrapper for a Join promised by a client call.
type Join_Future struct{ *capnp.Future }

func (p Join_Future) Struct() (Join, error) {
	s, err := p.Future.Struct()
	return Join(s), err
}

func (p Join_Future) Target() MessageTarget_Future {
	return MessageTarget_Future{Future: p.Future.Field(0, nil)}
}

func (p Join_Future) KeyPart() *capnp.Future {
	return p.Future.Field(1, nil)
}

type MessageTarget capnp.Struct
type MessageTarget_Which uint16

const (
	MessageTarget_Which_importedCap    MessageTarget_Which = 0
	MessageTarget_Which_promisedAnswer MessageTarget_Which = 1
)

func (w MessageTarget_Which) String() string {
	const s = "importedCappromisedAnswer"
	switch w {
	case MessageTarget_Which_importedCap:
		return s[0:11]
	case MessageTarget_Which_promisedAnswer:
		return s[11:25]

	}
	return "MessageTarget_Which(" + strconv.FormatUint(uint64(w), 10) + ")"
}

// MessageTarget_TypeID is the unique identifier for the type MessageTarget.
const MessageTarget_TypeID = 0x95bc14545813fbc1

func NewMessageTarget(s *capnp.Segment) (MessageTarget, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return MessageTarget(st), err
}

func NewRootMessageTarget(s *capnp.Segment) (MessageTarget, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return MessageTarget(st), err
}

func ReadRootMessageTarget(msg *capnp.Message) (MessageTarget, error) {
	root, err := msg.Root()
	return MessageTarget(root.Struct()), err
}

func (s MessageTarget) String() string {
	str, _ := text.Marshal(0x95bc14545813fbc1, capnp.Struct(s))
	return str
}

func (s MessageTarget) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (MessageTarget) DecodeFromPtr(p capnp.Ptr) MessageTarget {
	return MessageTarget(capnp.Struct{}.DecodeFromPtr(p))
}

func (s MessageTarget) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}

func (s MessageTarget) Which() MessageTarget_Which {
	return MessageTarget_Which(capnp.Struct(s).Uint16(4))
}
func (s MessageTarget) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s MessageTarget) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s MessageTarget) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s MessageTarget) ImportedCap() uint32 {
	if capnp.Struct(s).Uint16(4) != 0 {
		panic("Which() != importedCap")
	}
	return capnp.Struct(s).Uint32(0)
}

func (s MessageTarget) SetImportedCap(v uint32) {
	capnp.Struct(s).SetUint16(4, 0)
	capnp.Struct(s).SetUint32(0, v)
}

func (s MessageTarget) PromisedAnswer() (PromisedAnswer, error) {
	if capnp.Struct(s).Uint16(4) != 1 {
		panic("Which() != promisedAnswer")
	}
	p, err := capnp.Struct(s).Ptr(0)
	return PromisedAnswer(p.Struct()), err
}

func (s MessageTarget) HasPromisedAnswer() bool {
	if capnp.Struct(s).Uint16(4) != 1 {
		return false
	}
	return capnp.Struct(s).HasPtr(0)
}

func (s MessageTarget) SetPromisedAnswer(v PromisedAnswer) error {
	capnp.Struct(s).SetUint16(4, 1)
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewPromisedAnswer sets the promisedAnswer field to a newly
// allocated PromisedAnswer struct, preferring placement in s's segment.
func (s MessageTarget) NewPromisedAnswer() (PromisedAnswer, error) {
	capnp.Struct(s).SetUint16(4, 1)
	ss, err := NewPromisedAnswer(capnp.Struct(s).Segment())
	if err != nil {
		return PromisedAnswer{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

// MessageTarget_List is a list of MessageTarget.
type MessageTarget_List = capnp.StructList[MessageTarget]

// NewMessageTarget creates a new list of MessageTarget.
func NewMessageTarget_List(s *capnp.Segment, sz int32) (MessageTarget_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1}, sz)
	return capnp.StructList[MessageTarget](l), err
}

// MessageTarget_Future is a wrapper for a MessageTarget promised by a client call.
type MessageTarget_Future struct{ *capnp.Future }

func (p MessageTarget_Future) Struct() (MessageTarget, error) {
	s, err := p.Future.Struct()
	return MessageTarget(s), err
}

func (p MessageTarget_Future) PromisedAnswer() PromisedAnswer_Future {
	return PromisedAnswer_Future{Future: p.Future.Field(0, nil)}
}

type Payload capnp.Struct

// Payload_TypeID is the unique identifier for the type Payload.
const Payload_TypeID = 0x9a0e61223d96743b

func NewPayload(s *capnp.Segment) (Payload, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2})
	return Payload(st), err
}

func NewRootPayload(s *capnp.Segment) (Payload, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2})
	return Payload(st), err
}

func ReadRootPayload(msg *capnp.Message) (Payload, error) {
	root, err := msg.Root()
	return Payload(root.Struct()), err
}

func (s Payload) String() string {
	str, _ := text.Marshal(0x9a0e61223d96743b, capnp.Struct(s))
	return str
}

func (s Payload) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Payload) DecodeFromPtr(p capnp.Ptr) Payload {
	return Payload(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Payload) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Payload) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Payload) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Payload) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Payload) Content() (capnp.Ptr, error) {
	return capnp.Struct(s).Ptr(0)
}

func (s Payload) HasContent() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Payload) SetContent(v capnp.Ptr) error {
	return capnp.Struct(s).SetPtr(0, v)
}

func (s Payload) CapTable() (CapDescriptor_List, error) {
	p, err := capnp.Struct(s).Ptr(1)
	return CapDescriptor_List(p.List()), err
}

func (s Payload) HasCapTable() bool {
	return capnp.Struct(s).HasPtr(1)
}

func (s Payload) SetCapTable(v CapDescriptor_List) error {
	return capnp.Struct(s).SetPtr(1, v.ToPtr())
}

// NewCapTable sets the capTable field to a newly
// allocated CapDescriptor_List, preferring placement in s's segment.
func (s Payload) NewCapTable(n int32) (CapDescriptor_List, error) {
	l, err := NewCapDescriptor_List(capnp.Struct(s).Segment(), n)
	if err != nil {
		return CapDescriptor_List{}, err
	}
	err = capnp.Struct(s).SetPtr(1, l.ToPtr())
	return l, err
}

// Payload_List is a list of Payload.
type Payload_List = capnp.StructList[Payload]

// NewPayload creates a new list of Payload.
func NewPayload_List(s *capnp.Segment, sz int32) (Payload_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2}, sz)
	return capnp.StructList[Payload](l), err
}

// Payload_Future is a wrapper for a Payload promised by a client call.
type Payload_Future struct{ *capnp.Future }

func (p Payload_Future) Struct() (Payload, error) {
	s, err := p.Future.Struct()
	return Payload(s), err
}

func (p Payload_Future) Content() *capnp.Future {
	return p.Future.Field(0, nil)
}

type CapDescriptor capnp.Struct
type CapDescriptor_Which uint16

const (
	CapDescriptor_Which_none             CapDescriptor_Which = 0
	CapDescriptor_Which_senderHosted     CapDescriptor_Which = 1
	CapDescriptor_Which_senderPromise    CapDescriptor_Which = 2
	CapDescriptor_Which_receiverHosted   CapDescriptor_Which = 3
	CapDescriptor_Which_receiverAnswer   CapDescriptor_Which = 4
	CapDescriptor_Which_thirdPartyHosted CapDescriptor_Which = 5
)

func (w CapDescriptor_Which) String() string {
	const s = "nonesenderHostedsenderPromisereceiverHostedreceiverAnswerthirdPartyHosted"
	switch w {
	case CapDescriptor_Which_none:
		return s[0:4]
	case CapDescriptor_Which_senderHosted:
		return s[4:16]
	case CapDescriptor_Which_senderPromise:
		return s[16:29]
	case CapDescriptor_Which_receiverHosted:
		return s[29:43]
	case CapDescriptor_Which_receiverAnswer:
		return s[43:57]
	case CapDescriptor_Which_thirdPartyHosted:
		return s[57:73]

	}
	return "CapDescriptor_Which(" + strconv.FormatUint(uint64(w), 10) + ")"
}

// CapDescriptor_TypeID is the unique identifier for the type CapDescriptor.
const CapDescriptor_TypeID = 0x8523ddc40b86b8b0

func NewCapDescriptor(s *capnp.Segment) (CapDescriptor, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return CapDescriptor(st), err
}

func NewRootCapDescriptor(s *capnp.Segment) (CapDescriptor, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return CapDescriptor(st), err
}

func ReadRootCapDescriptor(msg *capnp.Message) (CapDescriptor, error) {
	root, err := msg.Root()
	return CapDescriptor(root.Struct()), err
}

func (s CapDescriptor) String() string {
	str, _ := text.Marshal(0x8523ddc40b86b8b0, capnp.Struct(s))
	return str
}

func (s CapDescriptor) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (CapDescriptor) DecodeFromPtr(p capnp.Ptr) CapDescriptor {
	return CapDescriptor(capnp.Struct{}.DecodeFromPtr(p))
}

func (s CapDescriptor) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}

func (s CapDescriptor) Which() CapDescriptor_Which {
	return CapDescriptor_Which(capnp.Struct(s).Uint16(0))
}
func (s CapDescriptor) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s CapDescriptor) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s CapDescriptor) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s CapDescriptor) SetNone() {
	capnp.Struct(s).SetUint16(0, 0)

}

func (s CapDescriptor) SenderHosted() uint32 {
	if capnp.Struct(s).Uint16(0) != 1 {
		panic("Which() != senderHosted")
	}
	return capnp.Struct(s).Uint32(4)
}

func (s CapDescriptor) SetSenderHosted(v uint32) {
	capnp.Struct(s).SetUint16(0, 1)
	capnp.Struct(s).SetUint32(4, v)
}

func (s CapDescriptor) SenderPromise() uint32 {
	if capnp.Struct(s).Uint16(0) != 2 {
		panic("Which() != senderPromise")
	}
	return capnp.Struct(s).Uint32(4)
}

func (s CapDescriptor) SetSenderPromise(v uint32) {
	capnp.Struct(s).SetUint16(0, 2)
	capnp.Struct(s).SetUint32(4, v)
}

func (s CapDescriptor) ReceiverHosted() uint32 {
	if capnp.Struct(s).Uint16(0) != 3 {
		panic("Which() != receiverHosted")
	}
	return capnp.Struct(s).Uint32(4)
}

func (s CapDescriptor) SetReceiverHosted(v uint32) {
	capnp.Struct(s).SetUint16(0, 3)
	capnp.Struct(s).SetUint32(4, v)
}

func (s CapDescriptor) ReceiverAnswer() (PromisedAnswer, error) {
	if capnp.Struct(s).Uint16(0) != 4 {
		panic("Which() != receiverAnswer")
	}
	p, err := capnp.Struct(s).Ptr(0)
	return PromisedAnswer(p.Struct()), err
}

func (s CapDescriptor) HasReceiverAnswer() bool {
	if capnp.Struct(s).Uint16(0) != 4 {
		return false
	}
	return capnp.Struct(s).HasPtr(0)
}

func (s CapDescriptor) SetReceiverAnswer(v PromisedAnswer) error {
	capnp.Struct(s).SetUint16(0, 4)
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewReceiverAnswer sets the receiverAnswer field to a newly
// allocated PromisedAnswer struct, preferring placement in s's segment.
func (s CapDescriptor) NewReceiverAnswer() (PromisedAnswer, error) {
	capnp.Struct(s).SetUint16(0, 4)
	ss, err := NewPromisedAnswer(capnp.Struct(s).Segment())
	if err != nil {
		return PromisedAnswer{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

func (s CapDescriptor) ThirdPartyHosted() (ThirdPartyCapDescriptor, error) {
	if capnp.Struct(s).Uint16(0) != 5 {
		panic("Which() != thirdPartyHosted")
	}
	p, err := capnp.Struct(s).Ptr(0)
	return ThirdPartyCapDescriptor(p.Struct()), err
}

func (s CapDescriptor) HasThirdPartyHosted() bool {
	if capnp.Struct(s).Uint16(0) != 5 {
		return false
	}
	return capnp.Struct(s).HasPtr(0)
}

func (s CapDescriptor) SetThirdPartyHosted(v ThirdPartyCapDescriptor) error {
	capnp.Struct(s).SetUint16(0, 5)
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewThirdPartyHosted sets the thirdPartyHosted field to a newly
// allocated ThirdPartyCapDescriptor struct, preferring placement in s's segment.
func (s CapDescriptor) NewThirdPartyHosted() (ThirdPartyCapDescriptor, error) {
	capnp.Struct(s).SetUint16(0, 5)
	ss, err := NewThirdPartyCapDescriptor(capnp.Struct(s).Segment())
	if err != nil {
		return ThirdPartyCapDescriptor{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

func (s CapDescriptor) AttachedFd() uint8 {
	return capnp.Struct(s).Uint8(2) ^ 255
}

func (s CapDescriptor) SetAttachedFd(v uint8) {
	capnp.Struct(s).SetUint8(2, v^255)
}

// CapDescriptor_List is a list of CapDescriptor.
type CapDescriptor_List = capnp.StructList[CapDescriptor]

// NewCapDescriptor creates a new list of CapDescriptor.
func NewCapDescriptor_List(s *capnp.Segment, sz int32) (CapDescriptor_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1}, sz)
	return capnp.StructList[CapDescriptor](l), err
}

// CapDescriptor_Future is a wrapper for a CapDescriptor promised by a client call.
type CapDescriptor_Future struct{ *capnp.Future }

func (p CapDescriptor_Future) Struct() (CapDescriptor, error) {
	s, err := p.Future.Struct()
	return CapDescriptor(s), err
}

func (p CapDescriptor_Future) ReceiverAnswer() PromisedAnswer_Future {
	return PromisedAnswer_Future{Future: p.Future.Field(0, nil)}
}

func (p CapDescriptor_Future) ThirdPartyHosted() ThirdPartyCapDescriptor_Future {
	return ThirdPartyCapDescriptor_Future{Future: p.Future.Field(0, nil)}
}

type PromisedAnswer capnp.Struct

// PromisedAnswer_TypeID is the unique identifier for the type PromisedAnswer.
const PromisedAnswer_TypeID = 0xd800b1d6cd6f1ca0

func NewPromisedAnswer(s *capnp.Segment) (PromisedAnswer, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return PromisedAnswer(st), err
}

func NewRootPromisedAnswer(s *capnp.Segment) (PromisedAnswer, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return PromisedAnswer(st), err
}

func ReadRootPromisedAnswer(msg *capnp.Message) (PromisedAnswer, error) {
	root, err := msg.Root()
	return PromisedAnswer(root.Struct()), err
}

func (s PromisedAnswer) String() string {
	str, _ := text.Marshal(0xd800b1d6cd6f1ca0, capnp.Struct(s))
	return str
}

func (s PromisedAnswer) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (PromisedAnswer) DecodeFromPtr(p capnp.Ptr) PromisedAnswer {
	return PromisedAnswer(capnp.Struct{}.DecodeFromPtr(p))
}

func (s PromisedAnswer) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s PromisedAnswer) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s PromisedAnswer) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s PromisedAnswer) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s PromisedAnswer) QuestionId() uint32 {
	return capnp.Struct(s).Uint32(0)
}

func (s PromisedAnswer) SetQuestionId(v uint32) {
	capnp.Struct(s).SetUint32(0, v)
}

func (s PromisedAnswer) Transform() (PromisedAnswer_Op_List, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return PromisedAnswer_Op_List(p.List()), err
}

func (s PromisedAnswer) HasTransform() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s PromisedAnswer) SetTransform(v PromisedAnswer_Op_List) error {
	return capnp.Struct(s).SetPtr(0, v.ToPtr())
}

// NewTransform sets the transform field to a newly
// allocated PromisedAnswer_Op_List, preferring placement in s's segment.
func (s PromisedAnswer) NewTransform(n int32) (PromisedAnswer_Op_List, error) {
	l, err := NewPromisedAnswer_Op_List(capnp.Struct(s).Segment(), n)
	if err != nil {
		return PromisedAnswer_Op_List{}, err
	}
	err = capnp.Struct(s).SetPtr(0, l.ToPtr())
	return l, err
}

// PromisedAnswer_List is a list of PromisedAnswer.
type PromisedAnswer_List = capnp.StructList[PromisedAnswer]

// NewPromisedAnswer creates a new list of PromisedAnswer.
func NewPromisedAnswer_List(s *capnp.Segment, sz int32) (PromisedAnswer_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1}, sz)
	return capnp.StructList[PromisedAnswer](l), err
}

// PromisedAnswer_Future is a wrapper for a PromisedAnswer promised by a client call.
type PromisedAnswer_Future struct{ *capnp.Future }

func (p PromisedAnswer_Future) Struct() (PromisedAnswer, error) {
	s, err := p.Future.Struct()
	return PromisedAnswer(s), err
}

type PromisedAnswer_Op capnp.Struct
type PromisedAnswer_Op_Which uint16

const (
	PromisedAnswer_Op_Which_noop            PromisedAnswer_Op_Which = 0
	PromisedAnswer_Op_Which_getPointerField PromisedAnswer_Op_Which = 1
)

func (w PromisedAnswer_Op_Which) String() string {
	const s = "noopgetPointerField"
	switch w {
	case PromisedAnswer_Op_Which_noop:
		return s[0:4]
	case PromisedAnswer_Op_Which_getPointerField:
		return s[4:19]

	}
	return "PromisedAnswer_Op_Which(" + strconv.FormatUint(uint64(w), 10) + ")"
}

// PromisedAnswer_Op_TypeID is the unique identifier for the type PromisedAnswer_Op.
const PromisedAnswer_Op_TypeID = 0xf316944415569081

func NewPromisedAnswer_Op(s *capnp.Segment) (PromisedAnswer_Op, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 0})
	return PromisedAnswer_Op(st), err
}

func NewRootPromisedAnswer_Op(s *capnp.Segment) (PromisedAnswer_Op, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 0})
	return PromisedAnswer_Op(st), err
}

func ReadRootPromisedAnswer_Op(msg *capnp.Message) (PromisedAnswer_Op, error) {
	root, err := msg.Root()
	return PromisedAnswer_Op(root.Struct()), err
}

func (s PromisedAnswer_Op) String() string {
	str, _ := text.Marshal(0xf316944415569081, capnp.Struct(s))
	return str
}

func (s PromisedAnswer_Op) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (PromisedAnswer_Op) DecodeFromPtr(p capnp.Ptr) PromisedAnswer_Op {
	return PromisedAnswer_Op(capnp.Struct{}.DecodeFromPtr(p))
}

func (s PromisedAnswer_Op) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}

func (s PromisedAnswer_Op) Which() PromisedAnswer_Op_Which {
	return PromisedAnswer_Op_Which(capnp.Struct(s).Uint16(0))
}
func (s PromisedAnswer_Op) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s PromisedAnswer_Op) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s PromisedAnswer_Op) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s PromisedAnswer_Op) SetNoop() {
	capnp.Struct(s).SetUint16(0, 0)

}

func (s PromisedAnswer_Op) GetPointerField() uint16 {
	if capnp.Struct(s).Uint16(0) != 1 {
		panic("Which() != getPointerField")
	}
	return capnp.Struct(s).Uint16(2)
}

func (s PromisedAnswer_Op) SetGetPointerField(v uint16) {
	capnp.Struct(s).SetUint16(0, 1)
	capnp.Struct(s).SetUint16(2, v)
}

// PromisedAnswer_Op_List is a list of PromisedAnswer_Op.
type PromisedAnswer_Op_List = capnp.StructList[PromisedAnswer_Op]

// NewPromisedAnswer_Op creates a new list of PromisedAnswer_Op.
func NewPromisedAnswer_Op_List(s *capnp.Segment, sz int32) (PromisedAnswer_Op_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 0}, sz)
	return capnp.StructList[PromisedAnswer_Op](l), err
}

// PromisedAnswer_Op_Future is a wrapper for a PromisedAnswer_Op promised by a client call.
type PromisedAnswer_Op_Future struct{ *capnp.Future }

func (p PromisedAnswer_Op_Future) Struct() (PromisedAnswer_Op, error) {
	s, err := p.Future.Struct()
	return PromisedAnswer_Op(s), err
}

type ThirdPartyCapDescriptor capnp.Struct

// ThirdPartyCapDescriptor_TypeID is the unique identifier for the type ThirdPartyCapDescriptor.
const ThirdPartyCapDescriptor_TypeID = 0xd37007fde1f0027d

func NewThirdPartyCapDescriptor(s *capnp.Segment) (ThirdPartyCapDescriptor, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return ThirdPartyCapDescriptor(st), err
}

func NewRootThirdPartyCapDescriptor(s *capnp.Segment) (ThirdPartyCapDescriptor, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return ThirdPartyCapDescriptor(st), err
}

func ReadRootThirdPartyCapDescriptor(msg *capnp.Message) (ThirdPartyCapDescriptor, error) {
	root, err := msg.Root()
	return ThirdPartyCapDescriptor(root.Struct()), err
}

func (s ThirdPartyCapDescriptor) String() string {
	str, _ := text.Marshal(0xd37007fde1f0027d, capnp.Struct(s))
	return str
}

func (s ThirdPartyCapDescriptor) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (ThirdPartyCapDescriptor) DecodeFromPtr(p capnp.Ptr) ThirdPartyCapDescriptor {
	return ThirdPartyCapDescriptor(capnp.Struct{}.DecodeFromPtr(p))
}

func (s ThirdPartyCapDescriptor) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s ThirdPartyCapDescriptor) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s ThirdPartyCapDescriptor) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s ThirdPartyCapDescriptor) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s ThirdPartyCapDescriptor) Id() (capnp.Ptr, error) {
	return capnp.Struct(s).Ptr(0)
}

func (s ThirdPartyCapDescriptor) HasId() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s ThirdPartyCapDescriptor) SetId(v capnp.Ptr) error {
	return capnp.Struct(s).SetPtr(0, v)
}

func (s ThirdPartyCapDescriptor) VineId() uint32 {
	return capnp.Struct(s).Uint32(0)
}

func (s ThirdPartyCapDescriptor) SetVineId(v uint32) {
	capnp.Struct(s).SetUint32(0, v)
}

// ThirdPartyCapDescriptor_List is a list of ThirdPartyCapDescriptor.
type ThirdPartyCapDescriptor_List = capnp.StructList[ThirdPartyCapDescriptor]

// NewThirdPartyCapDescriptor creates a new list of ThirdPartyCapDescriptor.
func NewThirdPartyCapDescriptor_List(s *capnp.Segment, sz int32) (ThirdPartyCapDescriptor_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1}, sz)
	return capnp.StructList[ThirdPartyCapDescriptor](l), err
}

// ThirdPartyCapDescriptor_Future is a wrapper for a ThirdPartyCapDescriptor promised by a client call.
type ThirdPartyCapDescriptor_Future struct{ *capnp.Future }

func (p ThirdPartyCapDescriptor_Future) Struct() (ThirdPartyCapDescriptor, error) {
	s, err := p.Future.Struct()
	return ThirdPartyCapDescriptor(s), err
}

func (p ThirdPartyCapDescriptor_Future) Id() *capnp.Future {
	return p.Future.Field(0, nil)
}

type Exception capnp.Struct

// Exception_TypeID is the unique identifier for the type Exception.
const Exception_TypeID = 0xd625b7063acf691a

func NewException(s *capnp.Segment) (Exception, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 2})
	return Exception(st), err
}

func NewRootException(s *capnp.Segment) (Exception, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 2})
	return Exception(st), err
}

func ReadRootException(msg *capnp.Message) (Exception, error) {
	root, err := msg.Root()
	return Exception(root.Struct()), err
}

func (s Exception) String() string {
	str, _ := text.Marshal(0xd625b7063acf691a, capnp.Struct(s))
	return str
}

func (s Exception) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Exception) DecodeFromPtr(p capnp.Ptr) Exception {
	return Exception(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Exception) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Exception) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Exception) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Exception) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Exception) Reason() (string, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return p.Text(), err
}

func (s Exception) HasReason() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Exception) ReasonBytes() ([]byte, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return p.TextBytes(), err
}

func (s Exception) SetReason(v string) error {
	return capnp.Struct(s).SetText(0, v)
}

func (s Exception) Type() Exception_Type {
	return Exception_Type(capnp.Struct(s).Uint16(4))
}

func (s Exception) SetType(v Exception_Type) {
	capnp.Struct(s).SetUint16(4, uint16(v))
}

func (s Exception) ObsoleteIsCallersFault() bool {
	return capnp.Struct(s).Bit(0)
}

func (s Exception) SetObsoleteIsCallersFault(v bool) {
	capnp.Struct(s).SetBit(0, v)
}

func (s Exception) ObsoleteDurability() uint16 {
	return capnp.Struct(s).Uint16(2)
}

func (s Exception) SetObsoleteDurability(v uint16) {
	capnp.Struct(s).SetUint16(2, v)
}

func (s Exception) Trace() (string, error) {
	p, err := capnp.Struct(s).Ptr(1)
	return p.Text(), err
}

func (s Exception) HasTrace() bool {
	return capnp.Struct(s).HasPtr(1)
}

func (s Exception) TraceBytes() ([]byte, error) {
	p, err := capnp.Struct(s).Ptr(1)
	return p.TextBytes(), err
}

func (s Exception) SetTrace(v string) error {
	return capnp.Struct(s).SetText(1, v)
}

// Exception_List is a list of Exception.
type Exception_List = capnp.StructList[Exception]

// NewException creates a new list of Exception.
func NewException_List(s *capnp.Segment, sz int32) (Exception_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 2}, sz)
	return capnp.StructList[Exception](l), err
}

// Exception_Future is a wrapper for a Exception promised by a client call.
type Exception_Future struct{ *capnp.Future }

func (p Exception_Future) Struct() (Exception, error) {
	s, err := p.Future.Struct()
	return Exception(s), err
}

type Exception_Type uint16

// Exception_Type_TypeID is the unique identifier for the type Exception_Type.
const Exception_Type_TypeID = 0xb28c96e23f4cbd58

// Values of Exception_Type.
const (
	Exception_Type_failed        Exception_Type = 0
	Exception_Type_overloaded    Exception_Type = 1
	Exception_Type_disconnected  Exception_Type = 2
	Exception_Type_unimplemented Exception_Type = 3
)

// String returns the enum's constant name.
func (c Exception_Type) String() string {
	switch c {
	case Exception_Type_failed:
		return "failed"
	case Exception_Type_overloaded:
		return "overloaded"
	case Exception_Type_disconnected:
		return "disconnected"
	case Exception_Type_unimplemented:
		return "unimplemented"

	default:
		return ""
	}
}

// Exception_TypeFromString returns the enum value with a name,
// or the zero value if there's no such value.
func Exception_TypeFromString(c string) Exception_Type {
	switch c {
	case "failed":
		return Exception_Type_failed
	case "overloaded":
		return Exception_Type_overloaded
	case "disconnected":
		return Exception_Type_disconnected
	case "unimplemented":
		return Exception_Type_unimplemented

	default:
		return 0
	}
}

type Exception_Type_List = capnp.EnumList[Exception_Type]

func NewException_Type_List(s *capnp.Segment, sz int32) (Exception_Type_List, error) {
	return capnp.NewEnumList[Exception_Type](s, sz)
}

const schema_b312981b2552a250 = "x\xda\x9cX\x7f\x8c\x15\xd5\xf5?\xe7\xde\xb7\xef-\xec" +
	"\x8f\xf7\x86\x99\x95\xc0\xd7\xcd\xa2\xdf\x9a\x14R\x88\xa8i" +
	"\xcd\xb6\xe6!,\x84%K\xd8\xbboi\x0dm\xd2\xce" +
	"\xce\xbb\xec\xce2;3\xce\xcc\xc2.\x91\x00-4J" +
	"\xddt%j\xd1hk\x8d\x7f\xb4\xd6FD\x8c\xdaB" +
	"*\x84\xa6jl\xd5(F\x1bI\xc5\xd4T\x9b\xfea" +
	"\xab\xb5*?\xa693\xf3f\x1e\xbboC\xec_\xfb" +
	"2\x9f3s\xcf\xfd\x9cs>\x9f{\xf7\xda\x9d\xf9U" +
	"\xb9\x95m\x9b\xe6\x01\x13VS>|\xbd\xef\xc1\x89?" +
	"UF\x7f\x00b>\xf2\xb0\xff\xe1\x81k\xfe\xef\xd0\x82" +
	"'\xa1\x89\x17\x00\xd4\xa9\xdcN\xf5\xae\\\x01\xe0\xfa\xa9" +
	"\xdc\x8f\x110<\xfc\xcc\x0f[N\x9d\xf9\xff\xfd\x14\x8d" +
	"Y\xf4Z,\xe4\x01T%\x7fR]\x94\xa7\xf0\x8e|" +
	"\x14~\xdd\xe1\xa9=]?{\xfa\xae\xd9\xe1\xed\x00\xea" +
	"\xb3\x85\x83\xea\x89\x02\x85\x1f/,\xe4\x80\xe1\x89s\xea" +
	"-\x83\xda\xb1{f\x873d\xea\x85\xf9'\xd5\xa6\x16" +
	"J\x0b[v\x00\x86_\x0f\xee\xbd\xe9j\xbd\xfd~P" +
	"\xe6\xd7\x0571\x8a\x90-\x07\xd5\xb1(\xd6\x8cb\xb7" +
	"<v\xe2\xdc\xb6\xdc\xe8\x033\xbe\x1c\x07\xbf\xd5rP" +
	"=\x1b\x05\x9fiy\x1c0\xec\xfe\xd6\x937M\x1dY" +
	"\xf4S\x0af\x97n\x12\xb9\xba\xab\xf5\x80\xba\xbf\x95\xb2" +
	"\xde\xdb\xfa\x07\xda\xe4O\x82Wv\xb5Y\x8b\x7f=\xe3" +
	"\xdbD\x9bzk\xfbAu\xb2\x9d~\x8d\xb7S\x1e\xb7" +
	"\x1c\xef+\xbf{\xef\x9dG@\xd1X\xb8\xd8|\xb9;" +
	"\xff\xf45o\x00\xa0z\xba\xfdE\xf5l\x14x\xa6}" +
	"\x180\xb4\x9b\xef\xf8|\xf3\xbd'\x7f\xdb\x98\x8a\xb6\xe2" +
	"A\xb5\xa3H\xd1J\x912\xde\xc5><{\xa1\xe0\xbe" +
	"6s{Hi>Q\\\x80\xea\x89(\xfax\x91\x92" +
	"0\xda?=yd\xc5\xae\xd7\x1a%\xbc\xa8t@\xbd" +
	"\xaaD\xbf:K\x14{\xc5\xaa\xcd\xd3CO\xbd\xf0z" +
	"\xa3/\xab\xfbK\x07\xd4\xa9(\xf8\x8e\x12\xa5\xb1\xf1\xcc" +
	"\xb7\xe5_\x8e\x0e\x9d\x06\xd1\x81\x18*_;^\xfc\xd1" +
	"W\xab\x9f\xc1f,`\x0e\x99\xbaT\xf9;\xa0\xba\\" +
	"\xf9\x1b`\xb6\xf7F\x05i[\xf0\xb0\xda\xb1`!\xc0" +
	"\xf5\x9d\x0b\xba\x10\xf0w\x0f]\xe9\xfc\xf1\x8d'\xdel" +
	"\x94\xc3M\xea\x8bj\xaf\xba\x10@\x15*%|\xdfw" +
	"\x7f\xb5\xf8\x93\xc3\xef\xff\x19D\x11y\xd6\xdd\x9by\x01" +
	"9r\xf5\xf7*\xe5\xf0\x82J\xe9\x9e\xb2\x17\xae\xdc\xf3" +
	"r\xdf\x07\x0d\xf7fj\x0f\xab\xb7j\xf4kL\xa3\xef" +
	"\xee\x9d\xfefG\xcf\xddW|\x04b\x11\xa6\x09\xf5\x14" +
	"\x18\x80zZ{W=\x1b\x85\x9e\x89B\xd3\x8d7\xcc" +
	"\xb7\xe3Qum\x07\xfd\xba\xb9\x83\x82\x1f\xc7w\xa6s" +
	"\x87\xce\x9ekH\xc4\xde\x8e\x9d\xea\xfe\x8e\xf8\xd7\xe3\xb0" +
	"&\xf4\\c\x85\xa1\xbb6\x94\xdd\xee5\xbae\xf5#" +
	"\x8a+y\x0e \x87\x00\xcaS[\x00\xc4Q\x8e\xe29" +
	"\x86\x88\x1a\xd2\xb3\xe3\xdd\x00\xe2\x19\x8e\xe2\x14C\x85\xa1" +
	"\x86\x0c@91\x04 \x9e\xe3(^b\xa8p\xa6!" +
	"\x07P^\xd8\x00 \x9e\xe7(^g\xa84\xa1\x869" +
	"\x00\xe5Uz\xfd%\x8e\xe2M\x86\x98\xc7:z\x95\xd3" +
	"\x1e0%\xb7G\xc3fD\xe5\xc4I\x00q\x8a\xa3x" +
	"\x85ax\xeb\xb8\xf4\x03\xd3\xb1\x81\xf7V\xb1\x19\x186" +
	"\x03\x96\x03\xdd\x1b\x96\x01\x96\xb2!\x07\xc4\x12`h\xda" +
	"\x81\xf4\xb6\xea\x06\x14do\x15\xe7\x01\xc3y\x80\xe1\x98" +
	"\x0cF\x9cjo\x15\x00\xb0\x00\x0c\x0b\x80eW\xf7\xf4" +
	"1\x1fK\xd9\xe4'\x9f\xf0\xa5]\x1d\x90\xfe8tY" +
	"\x81?\xe8\x84\xbae9;\x06GL\xe6U\xfbu/" +
	"\x98\x1c\xd4M\x8b\xe8\x02D`H3[#\x92\x11\x8f" +
	"n\x8f\xf4\x0d\xcft\x03\xc7\x83\x84\xd1\xd60\x8c)]" +
	"\x06 \x0es\x14\xc7\x18v\xe2\xc50a\xf5\xd9\xd1\x8c" +
	"\xd5Nv!\xac\xf1\xeae\xbcv\xf2\xf3\xf48bv" +
	"g\xc6l[\xee\\\x98PKO_\xe1(\xdef\xd8" +
	"\xd6\xf4y\xa8a\x13\x80\xf2\xd6\x01\x00\xf16G\xf1>" +
	"C%\xcf4\"]y\x8f\x0a\xfbW\x8e\xe2C\x86E" +
	"\xdb\xb1%\xe4\xa3=Ko\xbd\x03E?\x90)\xcd\xc9" +
	"\xe3~\x0f\xba\x9c1\xd3\x97\xe9sO\x1a\xd2\xdc.=" +
	"(\xafw.y!\x03n\xb6\xfd\x1d\xd2\xc3R\xad\xb9" +
	"\x13r\x83\x113\xa2\x11\x83\xc9\xf8U\x00,e\x8a\x93" +
	"D\xe9A\xa0\x1b#\xb2\x0a|]\x15\xf3\xc0\x9a\xf2a" +
	"\x1d\xcd\xe8vo\x94\xbe\xaf\x0f\xa3$\x82oL\x09V" +
	"'\xd1\x03\xa8L \xc7\xca>d\xd8\x86\x17\xc3\x88b" +
	"u/^\x07P\xb9\x8d\x80\xdb\x09\xe0\x17\xc2\x88du" +
	"?.\x03\xa8\xec!\xe0N\x02r\xe7\xc3\x88f\xf5\x0e" +
	"\xec\x06\xa8\xec#`\x9a\x80\xa6\x84iu*\x02n'" +
	"\xe0n\x02\xf2\x09\xd9\xea]\xb8\x1a\xa0r'\x01\x87\x08" +
	"(|\x16jHFvO\x04L\x13\xf0\x00\x01\xf3>" +
	"\x0d\xb5hz\xef\xc3Q\x80\xca!\x02\x1e!\x80\xfd'" +
	"\xd4\xb0\x19@\xfd9\x0e\x00T\x1e\"\xe01\x02\xe6\x7f" +
	"\x12j8\x0f@\xfd%\xee\x04\xa8\xfc\x82\x80\xa3\x04\xb4" +
	"\xfc;\xd4p>\x80\xfaD\xb4\xc6c\x04<C@\xeb" +
	"\xc7\xa1\x86-\x00\xeaSQ\xba\x87\x098F@\xdbG" +
	"\xa1\x86\xad\xe4\x97\xd1\xce\x8f\x12\xf0\x1c\x01\xcd\xff\x0a5" +
	"l#Y\xc7-\x00\x95c\x04<\x8f\x0c\xc3q\xdb\x1c" +
	"s-9\x06]\xd2\xa6Z\x972#\x8e\xcb\xd5\xa5\x0f" +
	"9\x1e\x0dc\x9d\x05\xd1\xf3\xa2\xa1[\x16\x962\xd9\x8c" +
	"\x1f\x97=\x19\x8c{6\x962kL\x80\xad\xa6m\xfa" +
	"#X\xca<%\x06v{\xd2w\xac\xed\x12K\x99\x93" +
	"\xa5\x88%u\x9f\x90\xd48\x93\x1er\x86|\xc7\x92\x81" +
	"\x84bE\xdf.q\x010\\\x00\x18\x0e9N\xe0\x07" +
	"\x9e\x0e\xe8b)\x13\xed\x99/\x95{$\xfd\xad\xbd\xb6" +
	"\xdb\xf5\x9c\xedf\x95\xd6I\xcd?IZ7\x0c\xe9\xd2" +
	"\xeeSsKv?\xea\x98\xb4\xc9T\x92\x93%\xaa\xa6" +
	"/\xc7\x86t\x0f\xf8\xb0\x83\xa5L\xde\x13\xb8NK\xe2" +
	"&\x97\x83\x91\xd6EZ\xd2\x9ci\xc9RR\xdd/s" +
	"\x147\xd4\xf5\xb9\xb2\x92d\xe0Z\x8e\xe2\x1b\x0cCs" +
	"\xccu<\x1a\xb1\xc2\x1a\xddMG\xd4\xf5\xa2Y\xae\xce" +
	"9\xa2uc\xd6\xafOZ\x8e\x8e\xd5d\xed\xc4\x19\x96" +
	"\xae\x06\x10_\xe2(\xaee\xa8\xd4\xaca9\x09\xfeW" +
	"8\x8a\xf5\x0cw\x1b\x8e\x1dH;HI7twP" +
	"\x1f\xb2$\xe9o;`?G,e\xa7?@zx" +
	"\xc9\xba\x11\xdb\xf1x\xb7\xa6\xeb\xae%\xe1\xea\xe1(\xfa" +
	"3G\xdaH\x96\xb2\x9e\xa3\x18\xacs$1\x00 \xfa" +
	"9\x8a\xef|a\xff\xf0\xa4a\xba\xa6\xb4\x01\xb3\xec\xeb" +
	"\x12\x1b\x88Z\x17\xa2b,I\x13{uC&\xbe\x0a" +
	".\xd1\x10\x11/\xd1\xde6\x16\xc6z\xa3\xbcG\xdc\xbd" +
	"\xc3Q\xfc\x83T\xe8b,6\xca\x07\x94\xf0\xfb\x1c\xc5" +
	"\xc7$A\x17\x12M\xff'}\xf6C\x8e\xe2<\xe9\xcf" +
	"\xf9D\xd3?{\x14@\x9c\xe7XiF\x86\x9d\xf9s" +
	"!\x8bU\xa6\x09\x8f\x00T\x9ail\xb5H~>O" +
	"TF\xc1G\x01*\x1a\x01Kh\x9e\xf5\xa8\xec\xb1\x19" +
	"f\xba\x1d\x8dQ?\x92)\xae\xd1]\x1f\"wk\"" +
	"{\xa3\xe9\x1b\xb7\x82FV)'\xa8\xf7M\x07\xd0\x9e" +
	"=\xfe\xa1\xa1\xdb\x86\xb4H\xe2\x0ba\xf2\x8d\x0aJ;" +
	"Xk\xf9rGqDz\xe4<\x81\xbeM\xae\xf3\x9c" +
	"1\xdc\x14\x8cHO\x8c\xcb\xae\xa8Zif\xf1x\xad" +
	"\xf3\xd0\x19\x1b\x8c\xbc\xa3H\x1e\xdc\xb86\xb4\x87\xb8i" +
	"\xea\x9auq\xa3f\xdd\x994\xeb\x8d\x0c\xb9Yo_" +
	"[\xa5'm\x03\xcar\x8d3n\x07\x19\x90M\xe5\xda" +
	"d\xcf\xf6\x8a\xc1IW\xc6\xadP\x8aj\xbb\xb4\x9bv" +
	"\xae\\\xb5\x05\x00\x99\xd29\x0a\x80\\Y\xe4\x01\x94\xb7" +
	"\xea\xa6%\xab\xa1\xb3]z\x96\xa3W\x81\xcb*\xe9\x80" +
	"\xe1\xd8\xb6\x84\xa2\x11\xc8\xeaL\x95\xbdtc\xa4~\xb3" +
	"\xa6a \x9b\x866\x0c\x13\x01\xd8xu6\x0fm\xec" +
	"b\xd8` \x12\x01\xe8\x05L7^0tw\xc6D" +
	"^\xbe\xbc\xb5\x0c\xb9\xdb=\x98\xb8z0Y\x7f\xfeA" +
	"o\xeeR\xa4\x95\xe8\xced\x8c*\x91\xd4\xb5\xbc\xdd\xb4" +
	"eou\x16\xff\xe8v\xaf\x8bL\x02`\xc6\xb7\xb7d" +
	"\xdfIGp\xe5A\x00q\x03G\xb1j\x0e\x1d\xa8\xf5" +
	"\xfd\x00F\xedI2\xe9\xa7}_\xbf\xe8\xcdQ\x17\xc6" +
	"\x8b^F\x90\x88\xea>\x8e\xe2\x16\x12\xa4%1\xff\x9b" +
	"W_F\x90\xc2\xc8_\xfc\x98\xea\x9a\xe7D61\xec" +
	"4:f\xf6$&2\xec\xac0\x1c\xbb\x18\xc8\x89@" +
	"\x94\"s\x88\xb3\xd0\xa9\xc1\xbf\xc7QX5w\xa04" +
	"L\x92$\x8b\xa3\x98\xa0\xe6\xb8\x90\x88\xcf8\x95\xc0\xe5" +
	"(n#I:\x9f\x88\xcf$\xa5\x1cp\x14{X\xed" +
	"\x1c\xd8\xe7@\xd9q\x87tc\xdb\xac\xf3\x1e\xf691" +
	"\x92iJb\x8c\x90O\xbd\xb3A1\xe3a*\x98\x8e" +
	"-rX\x7f\xa1\xc5eE\x1a/\xa1\xa5d\xef\xa24" +
	"'8\x8a}\x0c\x91\xc5\xdb\xdc\xfb\x1b\x00\xb1\x8f\xa3\x98" +
	"\xa6\xabG\xa2\xfeS\xf7\x03\x88i\x8e\xe2\x01j\x85\xe4" +
	">r\x1f\x1d\xbd\xef\xe6(\x1eb\xa8\xe4\x92\xfb\xc8\x83" +
	"\xd7\x01\x88C\x1c\xc5#\x8cN%\xba\xef\xd8\xd8\x0a\x0c" +
	"[\xebN\x02\xd8\xeb\xd3a_ze\x7f\x9d>n\x05" +
	"i5\xd2\x80\x9eqO\x1f2-\x93\x07\x93\xb5\xcbE" +
	"1\x98t%\x16\xb3\xfd\x00b\x11\xb0+\xf0tC\xa6" +
	"K\xd4\xd5\xb3?1\xe5\xd8\x92\x01\"6\xd2K\xa2\x82" +
	"\x8b\xf9&w\x8en\xaf5\xde\xca\x81\xc4\xfa\xfb\xe6\xea" +
	"\xb1\xc0\xd3m\x7f\xab\xe3\x01\x8ee.\x9c.2\xc3\x85" +
	"Y|'\\Q\xbb\x0dYE\xba\x0cQ\xf3GMF" +
	"N\xb4\x96*\xb2*^1n\xb2<\x80\xd2\xbb!S" +
	" \xba\xcd\xb0\xc8\x85\x14\xb1%\x1b\x81\xb2\x111\x0a\xf9" +
	"p\xd2\x19\xf7|im%\x8b\xa8]\x0d\x807\xd6\xf7" +
	"\xd5\xd1\xc9\xad\xe0\xe9\xee\xdc\xa3\x9f\x92q\xff\xe5&\xbf" +
	"*]O\x1az\x80\xb2\xbaihT\x1a\x01\x813W" +
	"\x9dU\x99\xc2\x8aM\xee\xcc\x83\xd8\xb2L\xd5\xea.u" +
	"\xcb\xbf\x9fYL\xd1v\x1c\x17\xf2\xe1\xb0\x0c\xfa\x1d\xd3" +
	"\x0ePz\xebLiU\xd3\xcbh\xfd6\xe3\xd1.\xd2" +
	"l\xcf\xd8gw\xbd|b\xdd?H\x94\xe5\xab\x81\xcd" +
	"y\xa6\x89Oc\x13\xc1%\xf7\xfd\x0d\x8ei\xff\xaf\xa7" +
	"\xab\xd5\x99\xc2}\xb1\xd3\xd5\xeemr\x92\\\xa2\xc6\xf3" +
	"\x7f\x03\x00\x00\xff\xff\x13\x1e\x1c\xb7"

func init() {
	schemas.Register(schema_b312981b2552a250,
		0x836a53ce789d4cd4,
		0x8523ddc40b86b8b0,
		0x91b79f1f808db032,
		0x95bc14545813fbc1,
		0x9a0e61223d96743b,
		0x9c6a046bfbc1ac5a,
		0x9e19b28d3db3573a,
		0xad1a6c0d7dd07497,
		0xb28c96e23f4cbd58,
		0xbbc29655fa89086e,
		0xd37007fde1f0027d,
		0xd37d2eb2c2f80e63,
		0xd4c9b56290554016,
		0xd562b4df655bdd4d,
		0xd625b7063acf691a,
		0xd800b1d6cd6f1ca0,
		0xdae8b0f61aab5f99,
		0xe94ccf8031176ec4,
		0xf316944415569081,
		0xf964368b0fbd3711,
		0xfbe1980490e001af)
}
