// Code generated by go-swagger; DO NOT EDIT.

//
// Copyright 2021 The Sigstore Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package entries

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewGetLogEntryByIndexParams creates a new GetLogEntryByIndexParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetLogEntryByIndexParams() *GetLogEntryByIndexParams {
	return &GetLogEntryByIndexParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetLogEntryByIndexParamsWithTimeout creates a new GetLogEntryByIndexParams object
// with the ability to set a timeout on a request.
func NewGetLogEntryByIndexParamsWithTimeout(timeout time.Duration) *GetLogEntryByIndexParams {
	return &GetLogEntryByIndexParams{
		timeout: timeout,
	}
}

// NewGetLogEntryByIndexParamsWithContext creates a new GetLogEntryByIndexParams object
// with the ability to set a context for a request.
func NewGetLogEntryByIndexParamsWithContext(ctx context.Context) *GetLogEntryByIndexParams {
	return &GetLogEntryByIndexParams{
		Context: ctx,
	}
}

// NewGetLogEntryByIndexParamsWithHTTPClient creates a new GetLogEntryByIndexParams object
// with the ability to set a custom HTTPClient for a request.
func NewGetLogEntryByIndexParamsWithHTTPClient(client *http.Client) *GetLogEntryByIndexParams {
	return &GetLogEntryByIndexParams{
		HTTPClient: client,
	}
}

/* GetLogEntryByIndexParams contains all the parameters to send to the API endpoint
   for the get log entry by index operation.

   Typically these are written to a http.Request.
*/
type GetLogEntryByIndexParams struct {

	/* LogIndex.

	   specifies the index of the entry in the transparency log to be retrieved
	*/
	LogIndex int64

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get log entry by index params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetLogEntryByIndexParams) WithDefaults() *GetLogEntryByIndexParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get log entry by index params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetLogEntryByIndexParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the get log entry by index params
func (o *GetLogEntryByIndexParams) WithTimeout(timeout time.Duration) *GetLogEntryByIndexParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get log entry by index params
func (o *GetLogEntryByIndexParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get log entry by index params
func (o *GetLogEntryByIndexParams) WithContext(ctx context.Context) *GetLogEntryByIndexParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get log entry by index params
func (o *GetLogEntryByIndexParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get log entry by index params
func (o *GetLogEntryByIndexParams) WithHTTPClient(client *http.Client) *GetLogEntryByIndexParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get log entry by index params
func (o *GetLogEntryByIndexParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithLogIndex adds the logIndex to the get log entry by index params
func (o *GetLogEntryByIndexParams) WithLogIndex(logIndex int64) *GetLogEntryByIndexParams {
	o.SetLogIndex(logIndex)
	return o
}

// SetLogIndex adds the logIndex to the get log entry by index params
func (o *GetLogEntryByIndexParams) SetLogIndex(logIndex int64) {
	o.LogIndex = logIndex
}

// WriteToRequest writes these params to a swagger request
func (o *GetLogEntryByIndexParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// query param logIndex
	qrLogIndex := o.LogIndex
	qLogIndex := swag.FormatInt64(qrLogIndex)
	if qLogIndex != "" {

		if err := r.SetQueryParam("logIndex", qLogIndex); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
