// Code generated by capnpc-go. DO NOT EDIT.

package proto

import (
	capnp "capnproto.org/go/capnp/v3"
	text "capnproto.org/go/capnp/v3/encoding/text"
	fc "capnproto.org/go/capnp/v3/flowcontrol"
	schemas "capnproto.org/go/capnp/v3/schemas"
	server "capnproto.org/go/capnp/v3/server"
	context "context"
	fmt "fmt"
)

type Conmon capnp.Client

// Conmon_TypeID is the unique identifier for the type Conmon.
const Conmon_TypeID = 0xb737e899dd6633f1

func (c Conmon) Version(ctx context.Context, params func(Conmon_version_Params) error) (Conmon_version_Results_Future, capnp.ReleaseFunc) {
	s := capnp.Send{
		Method: capnp.Method{
			InterfaceID:   0xb737e899dd6633f1,
			MethodID:      0,
			InterfaceName: "conmon-rs/common/proto/conmon.capnp:Conmon",
			MethodName:    "version",
		},
	}
	if params != nil {
		s.ArgsSize = capnp.ObjectSize{DataSize: 0, PointerCount: 1}
		s.PlaceArgs = func(s capnp.Struct) error { return params(Conmon_version_Params(s)) }
	}
	ans, release := capnp.Client(c).SendCall(ctx, s)
	return Conmon_version_Results_Future{Future: ans.Future()}, release
}
func (c Conmon) CreateContainer(ctx context.Context, params func(Conmon_createContainer_Params) error) (Conmon_createContainer_Results_Future, capnp.ReleaseFunc) {
	s := capnp.Send{
		Method: capnp.Method{
			InterfaceID:   0xb737e899dd6633f1,
			MethodID:      1,
			InterfaceName: "conmon-rs/common/proto/conmon.capnp:Conmon",
			MethodName:    "createContainer",
		},
	}
	if params != nil {
		s.ArgsSize = capnp.ObjectSize{DataSize: 0, PointerCount: 1}
		s.PlaceArgs = func(s capnp.Struct) error { return params(Conmon_createContainer_Params(s)) }
	}
	ans, release := capnp.Client(c).SendCall(ctx, s)
	return Conmon_createContainer_Results_Future{Future: ans.Future()}, release
}
func (c Conmon) ExecSyncContainer(ctx context.Context, params func(Conmon_execSyncContainer_Params) error) (Conmon_execSyncContainer_Results_Future, capnp.ReleaseFunc) {
	s := capnp.Send{
		Method: capnp.Method{
			InterfaceID:   0xb737e899dd6633f1,
			MethodID:      2,
			InterfaceName: "conmon-rs/common/proto/conmon.capnp:Conmon",
			MethodName:    "execSyncContainer",
		},
	}
	if params != nil {
		s.ArgsSize = capnp.ObjectSize{DataSize: 0, PointerCount: 1}
		s.PlaceArgs = func(s capnp.Struct) error { return params(Conmon_execSyncContainer_Params(s)) }
	}
	ans, release := capnp.Client(c).SendCall(ctx, s)
	return Conmon_execSyncContainer_Results_Future{Future: ans.Future()}, release
}
func (c Conmon) AttachContainer(ctx context.Context, params func(Conmon_attachContainer_Params) error) (Conmon_attachContainer_Results_Future, capnp.ReleaseFunc) {
	s := capnp.Send{
		Method: capnp.Method{
			InterfaceID:   0xb737e899dd6633f1,
			MethodID:      3,
			InterfaceName: "conmon-rs/common/proto/conmon.capnp:Conmon",
			MethodName:    "attachContainer",
		},
	}
	if params != nil {
		s.ArgsSize = capnp.ObjectSize{DataSize: 0, PointerCount: 1}
		s.PlaceArgs = func(s capnp.Struct) error { return params(Conmon_attachContainer_Params(s)) }
	}
	ans, release := capnp.Client(c).SendCall(ctx, s)
	return Conmon_attachContainer_Results_Future{Future: ans.Future()}, release
}
func (c Conmon) ReopenLogContainer(ctx context.Context, params func(Conmon_reopenLogContainer_Params) error) (Conmon_reopenLogContainer_Results_Future, capnp.ReleaseFunc) {
	s := capnp.Send{
		Method: capnp.Method{
			InterfaceID:   0xb737e899dd6633f1,
			MethodID:      4,
			InterfaceName: "conmon-rs/common/proto/conmon.capnp:Conmon",
			MethodName:    "reopenLogContainer",
		},
	}
	if params != nil {
		s.ArgsSize = capnp.ObjectSize{DataSize: 0, PointerCount: 1}
		s.PlaceArgs = func(s capnp.Struct) error { return params(Conmon_reopenLogContainer_Params(s)) }
	}
	ans, release := capnp.Client(c).SendCall(ctx, s)
	return Conmon_reopenLogContainer_Results_Future{Future: ans.Future()}, release
}
func (c Conmon) SetWindowSizeContainer(ctx context.Context, params func(Conmon_setWindowSizeContainer_Params) error) (Conmon_setWindowSizeContainer_Results_Future, capnp.ReleaseFunc) {
	s := capnp.Send{
		Method: capnp.Method{
			InterfaceID:   0xb737e899dd6633f1,
			MethodID:      5,
			InterfaceName: "conmon-rs/common/proto/conmon.capnp:Conmon",
			MethodName:    "setWindowSizeContainer",
		},
	}
	if params != nil {
		s.ArgsSize = capnp.ObjectSize{DataSize: 0, PointerCount: 1}
		s.PlaceArgs = func(s capnp.Struct) error { return params(Conmon_setWindowSizeContainer_Params(s)) }
	}
	ans, release := capnp.Client(c).SendCall(ctx, s)
	return Conmon_setWindowSizeContainer_Results_Future{Future: ans.Future()}, release
}
func (c Conmon) CreateNamespaces(ctx context.Context, params func(Conmon_createNamespaces_Params) error) (Conmon_createNamespaces_Results_Future, capnp.ReleaseFunc) {
	s := capnp.Send{
		Method: capnp.Method{
			InterfaceID:   0xb737e899dd6633f1,
			MethodID:      6,
			InterfaceName: "conmon-rs/common/proto/conmon.capnp:Conmon",
			MethodName:    "createNamespaces",
		},
	}
	if params != nil {
		s.ArgsSize = capnp.ObjectSize{DataSize: 0, PointerCount: 1}
		s.PlaceArgs = func(s capnp.Struct) error { return params(Conmon_createNamespaces_Params(s)) }
	}
	ans, release := capnp.Client(c).SendCall(ctx, s)
	return Conmon_createNamespaces_Results_Future{Future: ans.Future()}, release
}

// String returns a string that identifies this capability for debugging
// purposes.  Its format should not be depended on: in particular, it
// should not be used to compare clients.  Use IsSame to compare clients
// for equality.
func (c Conmon) String() string {
	return fmt.Sprintf("%T(%v)", c, capnp.Client(c))
}

// AddRef creates a new Client that refers to the same capability as c.
// If c is nil or has resolved to null, then AddRef returns nil.
func (c Conmon) AddRef() Conmon {
	return Conmon(capnp.Client(c).AddRef())
}

// Release releases a capability reference.  If this is the last
// reference to the capability, then the underlying resources associated
// with the capability will be released.
//
// Release will panic if c has already been released, but not if c is
// nil or resolved to null.
func (c Conmon) Release() {
	capnp.Client(c).Release()
}

// Resolve blocks until the capability is fully resolved or the Context
// expires.
func (c Conmon) Resolve(ctx context.Context) error {
	return capnp.Client(c).Resolve(ctx)
}

func (c Conmon) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Client(c).EncodeAsPtr(seg)
}

func (Conmon) DecodeFromPtr(p capnp.Ptr) Conmon {
	return Conmon(capnp.Client{}.DecodeFromPtr(p))
}

// IsValid reports whether c is a valid reference to a capability.
// A reference is invalid if it is nil, has resolved to null, or has
// been released.
func (c Conmon) IsValid() bool {
	return capnp.Client(c).IsValid()
}

// IsSame reports whether c and other refer to a capability created by the
// same call to NewClient.  This can return false negatives if c or other
// are not fully resolved: use Resolve if this is an issue.  If either
// c or other are released, then IsSame panics.
func (c Conmon) IsSame(other Conmon) bool {
	return capnp.Client(c).IsSame(capnp.Client(other))
}

// Update the flowcontrol.FlowLimiter used to manage flow control for
// this client. This affects all future calls, but not calls already
// waiting to send. Passing nil sets the value to flowcontrol.NopLimiter,
// which is also the default.
func (c Conmon) SetFlowLimiter(lim fc.FlowLimiter) {
	capnp.Client(c).SetFlowLimiter(lim)
}

// Get the current flowcontrol.FlowLimiter used to manage flow control
// for this client.
func (c Conmon) GetFlowLimiter() fc.FlowLimiter {
	return capnp.Client(c).GetFlowLimiter()
} // A Conmon_Server is a Conmon with a local implementation.
type Conmon_Server interface {
	Version(context.Context, Conmon_version) error

	CreateContainer(context.Context, Conmon_createContainer) error

	ExecSyncContainer(context.Context, Conmon_execSyncContainer) error

	AttachContainer(context.Context, Conmon_attachContainer) error

	ReopenLogContainer(context.Context, Conmon_reopenLogContainer) error

	SetWindowSizeContainer(context.Context, Conmon_setWindowSizeContainer) error

	CreateNamespaces(context.Context, Conmon_createNamespaces) error
}

// Conmon_NewServer creates a new Server from an implementation of Conmon_Server.
func Conmon_NewServer(s Conmon_Server) *server.Server {
	c, _ := s.(server.Shutdowner)
	return server.New(Conmon_Methods(nil, s), s, c)
}

// Conmon_ServerToClient creates a new Client from an implementation of Conmon_Server.
// The caller is responsible for calling Release on the returned Client.
func Conmon_ServerToClient(s Conmon_Server) Conmon {
	return Conmon(capnp.NewClient(Conmon_NewServer(s)))
}

// Conmon_Methods appends Methods to a slice that invoke the methods on s.
// This can be used to create a more complicated Server.
func Conmon_Methods(methods []server.Method, s Conmon_Server) []server.Method {
	if cap(methods) == 0 {
		methods = make([]server.Method, 0, 7)
	}

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0xb737e899dd6633f1,
			MethodID:      0,
			InterfaceName: "conmon-rs/common/proto/conmon.capnp:Conmon",
			MethodName:    "version",
		},
		Impl: func(ctx context.Context, call *server.Call) error {
			return s.Version(ctx, Conmon_version{call})
		},
	})

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0xb737e899dd6633f1,
			MethodID:      1,
			InterfaceName: "conmon-rs/common/proto/conmon.capnp:Conmon",
			MethodName:    "createContainer",
		},
		Impl: func(ctx context.Context, call *server.Call) error {
			return s.CreateContainer(ctx, Conmon_createContainer{call})
		},
	})

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0xb737e899dd6633f1,
			MethodID:      2,
			InterfaceName: "conmon-rs/common/proto/conmon.capnp:Conmon",
			MethodName:    "execSyncContainer",
		},
		Impl: func(ctx context.Context, call *server.Call) error {
			return s.ExecSyncContainer(ctx, Conmon_execSyncContainer{call})
		},
	})

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0xb737e899dd6633f1,
			MethodID:      3,
			InterfaceName: "conmon-rs/common/proto/conmon.capnp:Conmon",
			MethodName:    "attachContainer",
		},
		Impl: func(ctx context.Context, call *server.Call) error {
			return s.AttachContainer(ctx, Conmon_attachContainer{call})
		},
	})

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0xb737e899dd6633f1,
			MethodID:      4,
			InterfaceName: "conmon-rs/common/proto/conmon.capnp:Conmon",
			MethodName:    "reopenLogContainer",
		},
		Impl: func(ctx context.Context, call *server.Call) error {
			return s.ReopenLogContainer(ctx, Conmon_reopenLogContainer{call})
		},
	})

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0xb737e899dd6633f1,
			MethodID:      5,
			InterfaceName: "conmon-rs/common/proto/conmon.capnp:Conmon",
			MethodName:    "setWindowSizeContainer",
		},
		Impl: func(ctx context.Context, call *server.Call) error {
			return s.SetWindowSizeContainer(ctx, Conmon_setWindowSizeContainer{call})
		},
	})

	methods = append(methods, server.Method{
		Method: capnp.Method{
			InterfaceID:   0xb737e899dd6633f1,
			MethodID:      6,
			InterfaceName: "conmon-rs/common/proto/conmon.capnp:Conmon",
			MethodName:    "createNamespaces",
		},
		Impl: func(ctx context.Context, call *server.Call) error {
			return s.CreateNamespaces(ctx, Conmon_createNamespaces{call})
		},
	})

	return methods
}

// Conmon_version holds the state for a server call to Conmon.version.
// See server.Call for documentation.
type Conmon_version struct {
	*server.Call
}

// Args returns the call's arguments.
func (c Conmon_version) Args() Conmon_version_Params {
	return Conmon_version_Params(c.Call.Args())
}

// AllocResults allocates the results struct.
func (c Conmon_version) AllocResults() (Conmon_version_Results, error) {
	r, err := c.Call.AllocResults(capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_version_Results(r), err
}

// Conmon_createContainer holds the state for a server call to Conmon.createContainer.
// See server.Call for documentation.
type Conmon_createContainer struct {
	*server.Call
}

// Args returns the call's arguments.
func (c Conmon_createContainer) Args() Conmon_createContainer_Params {
	return Conmon_createContainer_Params(c.Call.Args())
}

// AllocResults allocates the results struct.
func (c Conmon_createContainer) AllocResults() (Conmon_createContainer_Results, error) {
	r, err := c.Call.AllocResults(capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_createContainer_Results(r), err
}

// Conmon_execSyncContainer holds the state for a server call to Conmon.execSyncContainer.
// See server.Call for documentation.
type Conmon_execSyncContainer struct {
	*server.Call
}

// Args returns the call's arguments.
func (c Conmon_execSyncContainer) Args() Conmon_execSyncContainer_Params {
	return Conmon_execSyncContainer_Params(c.Call.Args())
}

// AllocResults allocates the results struct.
func (c Conmon_execSyncContainer) AllocResults() (Conmon_execSyncContainer_Results, error) {
	r, err := c.Call.AllocResults(capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_execSyncContainer_Results(r), err
}

// Conmon_attachContainer holds the state for a server call to Conmon.attachContainer.
// See server.Call for documentation.
type Conmon_attachContainer struct {
	*server.Call
}

// Args returns the call's arguments.
func (c Conmon_attachContainer) Args() Conmon_attachContainer_Params {
	return Conmon_attachContainer_Params(c.Call.Args())
}

// AllocResults allocates the results struct.
func (c Conmon_attachContainer) AllocResults() (Conmon_attachContainer_Results, error) {
	r, err := c.Call.AllocResults(capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_attachContainer_Results(r), err
}

// Conmon_reopenLogContainer holds the state for a server call to Conmon.reopenLogContainer.
// See server.Call for documentation.
type Conmon_reopenLogContainer struct {
	*server.Call
}

// Args returns the call's arguments.
func (c Conmon_reopenLogContainer) Args() Conmon_reopenLogContainer_Params {
	return Conmon_reopenLogContainer_Params(c.Call.Args())
}

// AllocResults allocates the results struct.
func (c Conmon_reopenLogContainer) AllocResults() (Conmon_reopenLogContainer_Results, error) {
	r, err := c.Call.AllocResults(capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_reopenLogContainer_Results(r), err
}

// Conmon_setWindowSizeContainer holds the state for a server call to Conmon.setWindowSizeContainer.
// See server.Call for documentation.
type Conmon_setWindowSizeContainer struct {
	*server.Call
}

// Args returns the call's arguments.
func (c Conmon_setWindowSizeContainer) Args() Conmon_setWindowSizeContainer_Params {
	return Conmon_setWindowSizeContainer_Params(c.Call.Args())
}

// AllocResults allocates the results struct.
func (c Conmon_setWindowSizeContainer) AllocResults() (Conmon_setWindowSizeContainer_Results, error) {
	r, err := c.Call.AllocResults(capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_setWindowSizeContainer_Results(r), err
}

// Conmon_createNamespaces holds the state for a server call to Conmon.createNamespaces.
// See server.Call for documentation.
type Conmon_createNamespaces struct {
	*server.Call
}

// Args returns the call's arguments.
func (c Conmon_createNamespaces) Args() Conmon_createNamespaces_Params {
	return Conmon_createNamespaces_Params(c.Call.Args())
}

// AllocResults allocates the results struct.
func (c Conmon_createNamespaces) AllocResults() (Conmon_createNamespaces_Results, error) {
	r, err := c.Call.AllocResults(capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_createNamespaces_Results(r), err
}

// Conmon_List is a list of Conmon.
type Conmon_List = capnp.CapList[Conmon]

// NewConmon creates a new list of Conmon.
func NewConmon_List(s *capnp.Segment, sz int32) (Conmon_List, error) {
	l, err := capnp.NewPointerList(s, sz)
	return capnp.CapList[Conmon](l), err
}

type Conmon_VersionRequest capnp.Struct

// Conmon_VersionRequest_TypeID is the unique identifier for the type Conmon_VersionRequest.
const Conmon_VersionRequest_TypeID = 0xad2a33d6b9304413

func NewConmon_VersionRequest(s *capnp.Segment) (Conmon_VersionRequest, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return Conmon_VersionRequest(st), err
}

func NewRootConmon_VersionRequest(s *capnp.Segment) (Conmon_VersionRequest, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return Conmon_VersionRequest(st), err
}

func ReadRootConmon_VersionRequest(msg *capnp.Message) (Conmon_VersionRequest, error) {
	root, err := msg.Root()
	return Conmon_VersionRequest(root.Struct()), err
}

func (s Conmon_VersionRequest) String() string {
	str, _ := text.Marshal(0xad2a33d6b9304413, capnp.Struct(s))
	return str
}

func (s Conmon_VersionRequest) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Conmon_VersionRequest) DecodeFromPtr(p capnp.Ptr) Conmon_VersionRequest {
	return Conmon_VersionRequest(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Conmon_VersionRequest) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Conmon_VersionRequest) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Conmon_VersionRequest) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Conmon_VersionRequest) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Conmon_VersionRequest) Verbose() bool {
	return capnp.Struct(s).Bit(0)
}

func (s Conmon_VersionRequest) SetVerbose(v bool) {
	capnp.Struct(s).SetBit(0, v)
}

func (s Conmon_VersionRequest) Metadata() ([]byte, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return []byte(p.Data()), err
}

func (s Conmon_VersionRequest) HasMetadata() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Conmon_VersionRequest) SetMetadata(v []byte) error {
	return capnp.Struct(s).SetData(0, v)
}

// Conmon_VersionRequest_List is a list of Conmon_VersionRequest.
type Conmon_VersionRequest_List = capnp.StructList[Conmon_VersionRequest]

// NewConmon_VersionRequest creates a new list of Conmon_VersionRequest.
func NewConmon_VersionRequest_List(s *capnp.Segment, sz int32) (Conmon_VersionRequest_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1}, sz)
	return capnp.StructList[Conmon_VersionRequest](l), err
}

// Conmon_VersionRequest_Future is a wrapper for a Conmon_VersionRequest promised by a client call.
type Conmon_VersionRequest_Future struct{ *capnp.Future }

func (f Conmon_VersionRequest_Future) Struct() (Conmon_VersionRequest, error) {
	p, err := f.Future.Ptr()
	return Conmon_VersionRequest(p.Struct()), err
}

type Conmon_VersionResponse capnp.Struct

// Conmon_VersionResponse_TypeID is the unique identifier for the type Conmon_VersionResponse.
const Conmon_VersionResponse_TypeID = 0xf34be5cbac1feed1

func NewConmon_VersionResponse(s *capnp.Segment) (Conmon_VersionResponse, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 9})
	return Conmon_VersionResponse(st), err
}

func NewRootConmon_VersionResponse(s *capnp.Segment) (Conmon_VersionResponse, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 9})
	return Conmon_VersionResponse(st), err
}

func ReadRootConmon_VersionResponse(msg *capnp.Message) (Conmon_VersionResponse, error) {
	root, err := msg.Root()
	return Conmon_VersionResponse(root.Struct()), err
}

func (s Conmon_VersionResponse) String() string {
	str, _ := text.Marshal(0xf34be5cbac1feed1, capnp.Struct(s))
	return str
}

func (s Conmon_VersionResponse) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Conmon_VersionResponse) DecodeFromPtr(p capnp.Ptr) Conmon_VersionResponse {
	return Conmon_VersionResponse(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Conmon_VersionResponse) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Conmon_VersionResponse) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Conmon_VersionResponse) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Conmon_VersionResponse) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Conmon_VersionResponse) ProcessId() uint32 {
	return capnp.Struct(s).Uint32(0)
}

func (s Conmon_VersionResponse) SetProcessId(v uint32) {
	capnp.Struct(s).SetUint32(0, v)
}

func (s Conmon_VersionResponse) Version() (string, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return p.Text(), err
}

func (s Conmon_VersionResponse) HasVersion() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Conmon_VersionResponse) VersionBytes() ([]byte, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return p.TextBytes(), err
}

func (s Conmon_VersionResponse) SetVersion(v string) error {
	return capnp.Struct(s).SetText(0, v)
}

func (s Conmon_VersionResponse) Tag() (string, error) {
	p, err := capnp.Struct(s).Ptr(1)
	return p.Text(), err
}

func (s Conmon_VersionResponse) HasTag() bool {
	return capnp.Struct(s).HasPtr(1)
}

func (s Conmon_VersionResponse) TagBytes() ([]byte, error) {
	p, err := capnp.Struct(s).Ptr(1)
	return p.TextBytes(), err
}

func (s Conmon_VersionResponse) SetTag(v string) error {
	return capnp.Struct(s).SetText(1, v)
}

func (s Conmon_VersionResponse) Commit() (string, error) {
	p, err := capnp.Struct(s).Ptr(2)
	return p.Text(), err
}

func (s Conmon_VersionResponse) HasCommit() bool {
	return capnp.Struct(s).HasPtr(2)
}

func (s Conmon_VersionResponse) CommitBytes() ([]byte, error) {
	p, err := capnp.Struct(s).Ptr(2)
	return p.TextBytes(), err
}

func (s Conmon_VersionResponse) SetCommit(v string) error {
	return capnp.Struct(s).SetText(2, v)
}

func (s Conmon_VersionResponse) BuildDate() (string, error) {
	p, err := capnp.Struct(s).Ptr(3)
	return p.Text(), err
}

func (s Conmon_VersionResponse) HasBuildDate() bool {
	return capnp.Struct(s).HasPtr(3)
}

func (s Conmon_VersionResponse) BuildDateBytes() ([]byte, error) {
	p, err := capnp.Struct(s).Ptr(3)
	return p.TextBytes(), err
}

func (s Conmon_VersionResponse) SetBuildDate(v string) error {
	return capnp.Struct(s).SetText(3, v)
}

func (s Conmon_VersionResponse) Target() (string, error) {
	p, err := capnp.Struct(s).Ptr(4)
	return p.Text(), err
}

func (s Conmon_VersionResponse) HasTarget() bool {
	return capnp.Struct(s).HasPtr(4)
}

func (s Conmon_VersionResponse) TargetBytes() ([]byte, error) {
	p, err := capnp.Struct(s).Ptr(4)
	return p.TextBytes(), err
}

func (s Conmon_VersionResponse) SetTarget(v string) error {
	return capnp.Struct(s).SetText(4, v)
}

func (s Conmon_VersionResponse) RustVersion() (string, error) {
	p, err := capnp.Struct(s).Ptr(5)
	return p.Text(), err
}

func (s Conmon_VersionResponse) HasRustVersion() bool {
	return capnp.Struct(s).HasPtr(5)
}

func (s Conmon_VersionResponse) RustVersionBytes() ([]byte, error) {
	p, err := capnp.Struct(s).Ptr(5)
	return p.TextBytes(), err
}

func (s Conmon_VersionResponse) SetRustVersion(v string) error {
	return capnp.Struct(s).SetText(5, v)
}

func (s Conmon_VersionResponse) CargoVersion() (string, error) {
	p, err := capnp.Struct(s).Ptr(6)
	return p.Text(), err
}

func (s Conmon_VersionResponse) HasCargoVersion() bool {
	return capnp.Struct(s).HasPtr(6)
}

func (s Conmon_VersionResponse) CargoVersionBytes() ([]byte, error) {
	p, err := capnp.Struct(s).Ptr(6)
	return p.TextBytes(), err
}

func (s Conmon_VersionResponse) SetCargoVersion(v string) error {
	return capnp.Struct(s).SetText(6, v)
}

func (s Conmon_VersionResponse) CargoTree() (string, error) {
	p, err := capnp.Struct(s).Ptr(7)
	return p.Text(), err
}

func (s Conmon_VersionResponse) HasCargoTree() bool {
	return capnp.Struct(s).HasPtr(7)
}

func (s Conmon_VersionResponse) CargoTreeBytes() ([]byte, error) {
	p, err := capnp.Struct(s).Ptr(7)
	return p.TextBytes(), err
}

func (s Conmon_VersionResponse) SetCargoTree(v string) error {
	return capnp.Struct(s).SetText(7, v)
}

func (s Conmon_VersionResponse) Metadata() ([]byte, error) {
	p, err := capnp.Struct(s).Ptr(8)
	return []byte(p.Data()), err
}

func (s Conmon_VersionResponse) HasMetadata() bool {
	return capnp.Struct(s).HasPtr(8)
}

func (s Conmon_VersionResponse) SetMetadata(v []byte) error {
	return capnp.Struct(s).SetData(8, v)
}

// Conmon_VersionResponse_List is a list of Conmon_VersionResponse.
type Conmon_VersionResponse_List = capnp.StructList[Conmon_VersionResponse]

// NewConmon_VersionResponse creates a new list of Conmon_VersionResponse.
func NewConmon_VersionResponse_List(s *capnp.Segment, sz int32) (Conmon_VersionResponse_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 9}, sz)
	return capnp.StructList[Conmon_VersionResponse](l), err
}

// Conmon_VersionResponse_Future is a wrapper for a Conmon_VersionResponse promised by a client call.
type Conmon_VersionResponse_Future struct{ *capnp.Future }

func (f Conmon_VersionResponse_Future) Struct() (Conmon_VersionResponse, error) {
	p, err := f.Future.Ptr()
	return Conmon_VersionResponse(p.Struct()), err
}

type Conmon_CreateContainerRequest capnp.Struct

// Conmon_CreateContainerRequest_TypeID is the unique identifier for the type Conmon_CreateContainerRequest.
const Conmon_CreateContainerRequest_TypeID = 0xba77e3fa3aa9b6ca

func NewConmon_CreateContainerRequest(s *capnp.Segment) (Conmon_CreateContainerRequest, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 9})
	return Conmon_CreateContainerRequest(st), err
}

func NewRootConmon_CreateContainerRequest(s *capnp.Segment) (Conmon_CreateContainerRequest, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 9})
	return Conmon_CreateContainerRequest(st), err
}

func ReadRootConmon_CreateContainerRequest(msg *capnp.Message) (Conmon_CreateContainerRequest, error) {
	root, err := msg.Root()
	return Conmon_CreateContainerRequest(root.Struct()), err
}

func (s Conmon_CreateContainerRequest) String() string {
	str, _ := text.Marshal(0xba77e3fa3aa9b6ca, capnp.Struct(s))
	return str
}

func (s Conmon_CreateContainerRequest) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Conmon_CreateContainerRequest) DecodeFromPtr(p capnp.Ptr) Conmon_CreateContainerRequest {
	return Conmon_CreateContainerRequest(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Conmon_CreateContainerRequest) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Conmon_CreateContainerRequest) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Conmon_CreateContainerRequest) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Conmon_CreateContainerRequest) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Conmon_CreateContainerRequest) Id() (string, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return p.Text(), err
}

func (s Conmon_CreateContainerRequest) HasId() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Conmon_CreateContainerRequest) IdBytes() ([]byte, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return p.TextBytes(), err
}

func (s Conmon_CreateContainerRequest) SetId(v string) error {
	return capnp.Struct(s).SetText(0, v)
}

func (s Conmon_CreateContainerRequest) BundlePath() (string, error) {
	p, err := capnp.Struct(s).Ptr(1)
	return p.Text(), err
}

func (s Conmon_CreateContainerRequest) HasBundlePath() bool {
	return capnp.Struct(s).HasPtr(1)
}

func (s Conmon_CreateContainerRequest) BundlePathBytes() ([]byte, error) {
	p, err := capnp.Struct(s).Ptr(1)
	return p.TextBytes(), err
}

func (s Conmon_CreateContainerRequest) SetBundlePath(v string) error {
	return capnp.Struct(s).SetText(1, v)
}

func (s Conmon_CreateContainerRequest) Terminal() bool {
	return capnp.Struct(s).Bit(0)
}

func (s Conmon_CreateContainerRequest) SetTerminal(v bool) {
	capnp.Struct(s).SetBit(0, v)
}

func (s Conmon_CreateContainerRequest) Stdin() bool {
	return capnp.Struct(s).Bit(1)
}

func (s Conmon_CreateContainerRequest) SetStdin(v bool) {
	capnp.Struct(s).SetBit(1, v)
}

func (s Conmon_CreateContainerRequest) ExitPaths() (capnp.TextList, error) {
	p, err := capnp.Struct(s).Ptr(2)
	return capnp.TextList(p.List()), err
}

func (s Conmon_CreateContainerRequest) HasExitPaths() bool {
	return capnp.Struct(s).HasPtr(2)
}

func (s Conmon_CreateContainerRequest) SetExitPaths(v capnp.TextList) error {
	return capnp.Struct(s).SetPtr(2, v.ToPtr())
}

// NewExitPaths sets the exitPaths field to a newly
// allocated capnp.TextList, preferring placement in s's segment.
func (s Conmon_CreateContainerRequest) NewExitPaths(n int32) (capnp.TextList, error) {
	l, err := capnp.NewTextList(capnp.Struct(s).Segment(), n)
	if err != nil {
		return capnp.TextList{}, err
	}
	err = capnp.Struct(s).SetPtr(2, l.ToPtr())
	return l, err
}
func (s Conmon_CreateContainerRequest) OomExitPaths() (capnp.TextList, error) {
	p, err := capnp.Struct(s).Ptr(3)
	return capnp.TextList(p.List()), err
}

func (s Conmon_CreateContainerRequest) HasOomExitPaths() bool {
	return capnp.Struct(s).HasPtr(3)
}

func (s Conmon_CreateContainerRequest) SetOomExitPaths(v capnp.TextList) error {
	return capnp.Struct(s).SetPtr(3, v.ToPtr())
}

// NewOomExitPaths sets the oomExitPaths field to a newly
// allocated capnp.TextList, preferring placement in s's segment.
func (s Conmon_CreateContainerRequest) NewOomExitPaths(n int32) (capnp.TextList, error) {
	l, err := capnp.NewTextList(capnp.Struct(s).Segment(), n)
	if err != nil {
		return capnp.TextList{}, err
	}
	err = capnp.Struct(s).SetPtr(3, l.ToPtr())
	return l, err
}
func (s Conmon_CreateContainerRequest) LogDrivers() (Conmon_LogDriver_List, error) {
	p, err := capnp.Struct(s).Ptr(4)
	return Conmon_LogDriver_List(p.List()), err
}

func (s Conmon_CreateContainerRequest) HasLogDrivers() bool {
	return capnp.Struct(s).HasPtr(4)
}

func (s Conmon_CreateContainerRequest) SetLogDrivers(v Conmon_LogDriver_List) error {
	return capnp.Struct(s).SetPtr(4, v.ToPtr())
}

// NewLogDrivers sets the logDrivers field to a newly
// allocated Conmon_LogDriver_List, preferring placement in s's segment.
func (s Conmon_CreateContainerRequest) NewLogDrivers(n int32) (Conmon_LogDriver_List, error) {
	l, err := NewConmon_LogDriver_List(capnp.Struct(s).Segment(), n)
	if err != nil {
		return Conmon_LogDriver_List{}, err
	}
	err = capnp.Struct(s).SetPtr(4, l.ToPtr())
	return l, err
}
func (s Conmon_CreateContainerRequest) CleanupCmd() (capnp.TextList, error) {
	p, err := capnp.Struct(s).Ptr(5)
	return capnp.TextList(p.List()), err
}

func (s Conmon_CreateContainerRequest) HasCleanupCmd() bool {
	return capnp.Struct(s).HasPtr(5)
}

func (s Conmon_CreateContainerRequest) SetCleanupCmd(v capnp.TextList) error {
	return capnp.Struct(s).SetPtr(5, v.ToPtr())
}

// NewCleanupCmd sets the cleanupCmd field to a newly
// allocated capnp.TextList, preferring placement in s's segment.
func (s Conmon_CreateContainerRequest) NewCleanupCmd(n int32) (capnp.TextList, error) {
	l, err := capnp.NewTextList(capnp.Struct(s).Segment(), n)
	if err != nil {
		return capnp.TextList{}, err
	}
	err = capnp.Struct(s).SetPtr(5, l.ToPtr())
	return l, err
}
func (s Conmon_CreateContainerRequest) GlobalArgs() (capnp.TextList, error) {
	p, err := capnp.Struct(s).Ptr(6)
	return capnp.TextList(p.List()), err
}

func (s Conmon_CreateContainerRequest) HasGlobalArgs() bool {
	return capnp.Struct(s).HasPtr(6)
}

func (s Conmon_CreateContainerRequest) SetGlobalArgs(v capnp.TextList) error {
	return capnp.Struct(s).SetPtr(6, v.ToPtr())
}

// NewGlobalArgs sets the globalArgs field to a newly
// allocated capnp.TextList, preferring placement in s's segment.
func (s Conmon_CreateContainerRequest) NewGlobalArgs(n int32) (capnp.TextList, error) {
	l, err := capnp.NewTextList(capnp.Struct(s).Segment(), n)
	if err != nil {
		return capnp.TextList{}, err
	}
	err = capnp.Struct(s).SetPtr(6, l.ToPtr())
	return l, err
}
func (s Conmon_CreateContainerRequest) CommandArgs() (capnp.TextList, error) {
	p, err := capnp.Struct(s).Ptr(7)
	return capnp.TextList(p.List()), err
}

func (s Conmon_CreateContainerRequest) HasCommandArgs() bool {
	return capnp.Struct(s).HasPtr(7)
}

func (s Conmon_CreateContainerRequest) SetCommandArgs(v capnp.TextList) error {
	return capnp.Struct(s).SetPtr(7, v.ToPtr())
}

// NewCommandArgs sets the commandArgs field to a newly
// allocated capnp.TextList, preferring placement in s's segment.
func (s Conmon_CreateContainerRequest) NewCommandArgs(n int32) (capnp.TextList, error) {
	l, err := capnp.NewTextList(capnp.Struct(s).Segment(), n)
	if err != nil {
		return capnp.TextList{}, err
	}
	err = capnp.Struct(s).SetPtr(7, l.ToPtr())
	return l, err
}
func (s Conmon_CreateContainerRequest) Metadata() ([]byte, error) {
	p, err := capnp.Struct(s).Ptr(8)
	return []byte(p.Data()), err
}

func (s Conmon_CreateContainerRequest) HasMetadata() bool {
	return capnp.Struct(s).HasPtr(8)
}

func (s Conmon_CreateContainerRequest) SetMetadata(v []byte) error {
	return capnp.Struct(s).SetData(8, v)
}

// Conmon_CreateContainerRequest_List is a list of Conmon_CreateContainerRequest.
type Conmon_CreateContainerRequest_List = capnp.StructList[Conmon_CreateContainerRequest]

// NewConmon_CreateContainerRequest creates a new list of Conmon_CreateContainerRequest.
func NewConmon_CreateContainerRequest_List(s *capnp.Segment, sz int32) (Conmon_CreateContainerRequest_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 9}, sz)
	return capnp.StructList[Conmon_CreateContainerRequest](l), err
}

// Conmon_CreateContainerRequest_Future is a wrapper for a Conmon_CreateContainerRequest promised by a client call.
type Conmon_CreateContainerRequest_Future struct{ *capnp.Future }

func (f Conmon_CreateContainerRequest_Future) Struct() (Conmon_CreateContainerRequest, error) {
	p, err := f.Future.Ptr()
	return Conmon_CreateContainerRequest(p.Struct()), err
}

type Conmon_LogDriver capnp.Struct

// Conmon_LogDriver_TypeID is the unique identifier for the type Conmon_LogDriver.
const Conmon_LogDriver_TypeID = 0xae78ee8eb6b3a134

func NewConmon_LogDriver(s *capnp.Segment) (Conmon_LogDriver, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 16, PointerCount: 1})
	return Conmon_LogDriver(st), err
}

func NewRootConmon_LogDriver(s *capnp.Segment) (Conmon_LogDriver, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 16, PointerCount: 1})
	return Conmon_LogDriver(st), err
}

func ReadRootConmon_LogDriver(msg *capnp.Message) (Conmon_LogDriver, error) {
	root, err := msg.Root()
	return Conmon_LogDriver(root.Struct()), err
}

func (s Conmon_LogDriver) String() string {
	str, _ := text.Marshal(0xae78ee8eb6b3a134, capnp.Struct(s))
	return str
}

func (s Conmon_LogDriver) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Conmon_LogDriver) DecodeFromPtr(p capnp.Ptr) Conmon_LogDriver {
	return Conmon_LogDriver(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Conmon_LogDriver) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Conmon_LogDriver) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Conmon_LogDriver) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Conmon_LogDriver) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Conmon_LogDriver) Type() Conmon_LogDriver_Type {
	return Conmon_LogDriver_Type(capnp.Struct(s).Uint16(0))
}

func (s Conmon_LogDriver) SetType(v Conmon_LogDriver_Type) {
	capnp.Struct(s).SetUint16(0, uint16(v))
}

func (s Conmon_LogDriver) Path() (string, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return p.Text(), err
}

func (s Conmon_LogDriver) HasPath() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Conmon_LogDriver) PathBytes() ([]byte, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return p.TextBytes(), err
}

func (s Conmon_LogDriver) SetPath(v string) error {
	return capnp.Struct(s).SetText(0, v)
}

func (s Conmon_LogDriver) MaxSize() uint64 {
	return capnp.Struct(s).Uint64(8)
}

func (s Conmon_LogDriver) SetMaxSize(v uint64) {
	capnp.Struct(s).SetUint64(8, v)
}

// Conmon_LogDriver_List is a list of Conmon_LogDriver.
type Conmon_LogDriver_List = capnp.StructList[Conmon_LogDriver]

// NewConmon_LogDriver creates a new list of Conmon_LogDriver.
func NewConmon_LogDriver_List(s *capnp.Segment, sz int32) (Conmon_LogDriver_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 16, PointerCount: 1}, sz)
	return capnp.StructList[Conmon_LogDriver](l), err
}

// Conmon_LogDriver_Future is a wrapper for a Conmon_LogDriver promised by a client call.
type Conmon_LogDriver_Future struct{ *capnp.Future }

func (f Conmon_LogDriver_Future) Struct() (Conmon_LogDriver, error) {
	p, err := f.Future.Ptr()
	return Conmon_LogDriver(p.Struct()), err
}

type Conmon_LogDriver_Type uint16

// Conmon_LogDriver_Type_TypeID is the unique identifier for the type Conmon_LogDriver_Type.
const Conmon_LogDriver_Type_TypeID = 0xf026e3d750335bc1

// Values of Conmon_LogDriver_Type.
const (
	Conmon_LogDriver_Type_containerRuntimeInterface Conmon_LogDriver_Type = 0
)

// String returns the enum's constant name.
func (c Conmon_LogDriver_Type) String() string {
	switch c {
	case Conmon_LogDriver_Type_containerRuntimeInterface:
		return "containerRuntimeInterface"

	default:
		return ""
	}
}

// Conmon_LogDriver_TypeFromString returns the enum value with a name,
// or the zero value if there's no such value.
func Conmon_LogDriver_TypeFromString(c string) Conmon_LogDriver_Type {
	switch c {
	case "containerRuntimeInterface":
		return Conmon_LogDriver_Type_containerRuntimeInterface

	default:
		return 0
	}
}

type Conmon_LogDriver_Type_List = capnp.EnumList[Conmon_LogDriver_Type]

func NewConmon_LogDriver_Type_List(s *capnp.Segment, sz int32) (Conmon_LogDriver_Type_List, error) {
	return capnp.NewEnumList[Conmon_LogDriver_Type](s, sz)
}

type Conmon_CreateContainerResponse capnp.Struct

// Conmon_CreateContainerResponse_TypeID is the unique identifier for the type Conmon_CreateContainerResponse.
const Conmon_CreateContainerResponse_TypeID = 0xde3a625e70772b9a

func NewConmon_CreateContainerResponse(s *capnp.Segment) (Conmon_CreateContainerResponse, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 0})
	return Conmon_CreateContainerResponse(st), err
}

func NewRootConmon_CreateContainerResponse(s *capnp.Segment) (Conmon_CreateContainerResponse, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 0})
	return Conmon_CreateContainerResponse(st), err
}

func ReadRootConmon_CreateContainerResponse(msg *capnp.Message) (Conmon_CreateContainerResponse, error) {
	root, err := msg.Root()
	return Conmon_CreateContainerResponse(root.Struct()), err
}

func (s Conmon_CreateContainerResponse) String() string {
	str, _ := text.Marshal(0xde3a625e70772b9a, capnp.Struct(s))
	return str
}

func (s Conmon_CreateContainerResponse) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Conmon_CreateContainerResponse) DecodeFromPtr(p capnp.Ptr) Conmon_CreateContainerResponse {
	return Conmon_CreateContainerResponse(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Conmon_CreateContainerResponse) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Conmon_CreateContainerResponse) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Conmon_CreateContainerResponse) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Conmon_CreateContainerResponse) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Conmon_CreateContainerResponse) ContainerPid() uint32 {
	return capnp.Struct(s).Uint32(0)
}

func (s Conmon_CreateContainerResponse) SetContainerPid(v uint32) {
	capnp.Struct(s).SetUint32(0, v)
}

// Conmon_CreateContainerResponse_List is a list of Conmon_CreateContainerResponse.
type Conmon_CreateContainerResponse_List = capnp.StructList[Conmon_CreateContainerResponse]

// NewConmon_CreateContainerResponse creates a new list of Conmon_CreateContainerResponse.
func NewConmon_CreateContainerResponse_List(s *capnp.Segment, sz int32) (Conmon_CreateContainerResponse_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 0}, sz)
	return capnp.StructList[Conmon_CreateContainerResponse](l), err
}

// Conmon_CreateContainerResponse_Future is a wrapper for a Conmon_CreateContainerResponse promised by a client call.
type Conmon_CreateContainerResponse_Future struct{ *capnp.Future }

func (f Conmon_CreateContainerResponse_Future) Struct() (Conmon_CreateContainerResponse, error) {
	p, err := f.Future.Ptr()
	return Conmon_CreateContainerResponse(p.Struct()), err
}

type Conmon_ExecSyncContainerRequest capnp.Struct

// Conmon_ExecSyncContainerRequest_TypeID is the unique identifier for the type Conmon_ExecSyncContainerRequest.
const Conmon_ExecSyncContainerRequest_TypeID = 0xf41122f890a371a6

func NewConmon_ExecSyncContainerRequest(s *capnp.Segment) (Conmon_ExecSyncContainerRequest, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 16, PointerCount: 3})
	return Conmon_ExecSyncContainerRequest(st), err
}

func NewRootConmon_ExecSyncContainerRequest(s *capnp.Segment) (Conmon_ExecSyncContainerRequest, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 16, PointerCount: 3})
	return Conmon_ExecSyncContainerRequest(st), err
}

func ReadRootConmon_ExecSyncContainerRequest(msg *capnp.Message) (Conmon_ExecSyncContainerRequest, error) {
	root, err := msg.Root()
	return Conmon_ExecSyncContainerRequest(root.Struct()), err
}

func (s Conmon_ExecSyncContainerRequest) String() string {
	str, _ := text.Marshal(0xf41122f890a371a6, capnp.Struct(s))
	return str
}

func (s Conmon_ExecSyncContainerRequest) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Conmon_ExecSyncContainerRequest) DecodeFromPtr(p capnp.Ptr) Conmon_ExecSyncContainerRequest {
	return Conmon_ExecSyncContainerRequest(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Conmon_ExecSyncContainerRequest) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Conmon_ExecSyncContainerRequest) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Conmon_ExecSyncContainerRequest) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Conmon_ExecSyncContainerRequest) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Conmon_ExecSyncContainerRequest) Id() (string, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return p.Text(), err
}

func (s Conmon_ExecSyncContainerRequest) HasId() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Conmon_ExecSyncContainerRequest) IdBytes() ([]byte, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return p.TextBytes(), err
}

func (s Conmon_ExecSyncContainerRequest) SetId(v string) error {
	return capnp.Struct(s).SetText(0, v)
}

func (s Conmon_ExecSyncContainerRequest) TimeoutSec() uint64 {
	return capnp.Struct(s).Uint64(0)
}

func (s Conmon_ExecSyncContainerRequest) SetTimeoutSec(v uint64) {
	capnp.Struct(s).SetUint64(0, v)
}

func (s Conmon_ExecSyncContainerRequest) Command() (capnp.TextList, error) {
	p, err := capnp.Struct(s).Ptr(1)
	return capnp.TextList(p.List()), err
}

func (s Conmon_ExecSyncContainerRequest) HasCommand() bool {
	return capnp.Struct(s).HasPtr(1)
}

func (s Conmon_ExecSyncContainerRequest) SetCommand(v capnp.TextList) error {
	return capnp.Struct(s).SetPtr(1, v.ToPtr())
}

// NewCommand sets the command field to a newly
// allocated capnp.TextList, preferring placement in s's segment.
func (s Conmon_ExecSyncContainerRequest) NewCommand(n int32) (capnp.TextList, error) {
	l, err := capnp.NewTextList(capnp.Struct(s).Segment(), n)
	if err != nil {
		return capnp.TextList{}, err
	}
	err = capnp.Struct(s).SetPtr(1, l.ToPtr())
	return l, err
}
func (s Conmon_ExecSyncContainerRequest) Terminal() bool {
	return capnp.Struct(s).Bit(64)
}

func (s Conmon_ExecSyncContainerRequest) SetTerminal(v bool) {
	capnp.Struct(s).SetBit(64, v)
}

func (s Conmon_ExecSyncContainerRequest) Metadata() ([]byte, error) {
	p, err := capnp.Struct(s).Ptr(2)
	return []byte(p.Data()), err
}

func (s Conmon_ExecSyncContainerRequest) HasMetadata() bool {
	return capnp.Struct(s).HasPtr(2)
}

func (s Conmon_ExecSyncContainerRequest) SetMetadata(v []byte) error {
	return capnp.Struct(s).SetData(2, v)
}

// Conmon_ExecSyncContainerRequest_List is a list of Conmon_ExecSyncContainerRequest.
type Conmon_ExecSyncContainerRequest_List = capnp.StructList[Conmon_ExecSyncContainerRequest]

// NewConmon_ExecSyncContainerRequest creates a new list of Conmon_ExecSyncContainerRequest.
func NewConmon_ExecSyncContainerRequest_List(s *capnp.Segment, sz int32) (Conmon_ExecSyncContainerRequest_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 16, PointerCount: 3}, sz)
	return capnp.StructList[Conmon_ExecSyncContainerRequest](l), err
}

// Conmon_ExecSyncContainerRequest_Future is a wrapper for a Conmon_ExecSyncContainerRequest promised by a client call.
type Conmon_ExecSyncContainerRequest_Future struct{ *capnp.Future }

func (f Conmon_ExecSyncContainerRequest_Future) Struct() (Conmon_ExecSyncContainerRequest, error) {
	p, err := f.Future.Ptr()
	return Conmon_ExecSyncContainerRequest(p.Struct()), err
}

type Conmon_ExecSyncContainerResponse capnp.Struct

// Conmon_ExecSyncContainerResponse_TypeID is the unique identifier for the type Conmon_ExecSyncContainerResponse.
const Conmon_ExecSyncContainerResponse_TypeID = 0xd9d61d1d803c85fc

func NewConmon_ExecSyncContainerResponse(s *capnp.Segment) (Conmon_ExecSyncContainerResponse, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 2})
	return Conmon_ExecSyncContainerResponse(st), err
}

func NewRootConmon_ExecSyncContainerResponse(s *capnp.Segment) (Conmon_ExecSyncContainerResponse, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 2})
	return Conmon_ExecSyncContainerResponse(st), err
}

func ReadRootConmon_ExecSyncContainerResponse(msg *capnp.Message) (Conmon_ExecSyncContainerResponse, error) {
	root, err := msg.Root()
	return Conmon_ExecSyncContainerResponse(root.Struct()), err
}

func (s Conmon_ExecSyncContainerResponse) String() string {
	str, _ := text.Marshal(0xd9d61d1d803c85fc, capnp.Struct(s))
	return str
}

func (s Conmon_ExecSyncContainerResponse) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Conmon_ExecSyncContainerResponse) DecodeFromPtr(p capnp.Ptr) Conmon_ExecSyncContainerResponse {
	return Conmon_ExecSyncContainerResponse(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Conmon_ExecSyncContainerResponse) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Conmon_ExecSyncContainerResponse) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Conmon_ExecSyncContainerResponse) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Conmon_ExecSyncContainerResponse) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Conmon_ExecSyncContainerResponse) ExitCode() int32 {
	return int32(capnp.Struct(s).Uint32(0))
}

func (s Conmon_ExecSyncContainerResponse) SetExitCode(v int32) {
	capnp.Struct(s).SetUint32(0, uint32(v))
}

func (s Conmon_ExecSyncContainerResponse) Stdout() ([]byte, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return []byte(p.Data()), err
}

func (s Conmon_ExecSyncContainerResponse) HasStdout() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Conmon_ExecSyncContainerResponse) SetStdout(v []byte) error {
	return capnp.Struct(s).SetData(0, v)
}

func (s Conmon_ExecSyncContainerResponse) Stderr() ([]byte, error) {
	p, err := capnp.Struct(s).Ptr(1)
	return []byte(p.Data()), err
}

func (s Conmon_ExecSyncContainerResponse) HasStderr() bool {
	return capnp.Struct(s).HasPtr(1)
}

func (s Conmon_ExecSyncContainerResponse) SetStderr(v []byte) error {
	return capnp.Struct(s).SetData(1, v)
}

func (s Conmon_ExecSyncContainerResponse) TimedOut() bool {
	return capnp.Struct(s).Bit(32)
}

func (s Conmon_ExecSyncContainerResponse) SetTimedOut(v bool) {
	capnp.Struct(s).SetBit(32, v)
}

// Conmon_ExecSyncContainerResponse_List is a list of Conmon_ExecSyncContainerResponse.
type Conmon_ExecSyncContainerResponse_List = capnp.StructList[Conmon_ExecSyncContainerResponse]

// NewConmon_ExecSyncContainerResponse creates a new list of Conmon_ExecSyncContainerResponse.
func NewConmon_ExecSyncContainerResponse_List(s *capnp.Segment, sz int32) (Conmon_ExecSyncContainerResponse_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 2}, sz)
	return capnp.StructList[Conmon_ExecSyncContainerResponse](l), err
}

// Conmon_ExecSyncContainerResponse_Future is a wrapper for a Conmon_ExecSyncContainerResponse promised by a client call.
type Conmon_ExecSyncContainerResponse_Future struct{ *capnp.Future }

func (f Conmon_ExecSyncContainerResponse_Future) Struct() (Conmon_ExecSyncContainerResponse, error) {
	p, err := f.Future.Ptr()
	return Conmon_ExecSyncContainerResponse(p.Struct()), err
}

type Conmon_AttachRequest capnp.Struct

// Conmon_AttachRequest_TypeID is the unique identifier for the type Conmon_AttachRequest.
const Conmon_AttachRequest_TypeID = 0xdf703ca0befc3afc

func NewConmon_AttachRequest(s *capnp.Segment) (Conmon_AttachRequest, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 4})
	return Conmon_AttachRequest(st), err
}

func NewRootConmon_AttachRequest(s *capnp.Segment) (Conmon_AttachRequest, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 4})
	return Conmon_AttachRequest(st), err
}

func ReadRootConmon_AttachRequest(msg *capnp.Message) (Conmon_AttachRequest, error) {
	root, err := msg.Root()
	return Conmon_AttachRequest(root.Struct()), err
}

func (s Conmon_AttachRequest) String() string {
	str, _ := text.Marshal(0xdf703ca0befc3afc, capnp.Struct(s))
	return str
}

func (s Conmon_AttachRequest) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Conmon_AttachRequest) DecodeFromPtr(p capnp.Ptr) Conmon_AttachRequest {
	return Conmon_AttachRequest(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Conmon_AttachRequest) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Conmon_AttachRequest) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Conmon_AttachRequest) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Conmon_AttachRequest) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Conmon_AttachRequest) Id() (string, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return p.Text(), err
}

func (s Conmon_AttachRequest) HasId() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Conmon_AttachRequest) IdBytes() ([]byte, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return p.TextBytes(), err
}

func (s Conmon_AttachRequest) SetId(v string) error {
	return capnp.Struct(s).SetText(0, v)
}

func (s Conmon_AttachRequest) SocketPath() (string, error) {
	p, err := capnp.Struct(s).Ptr(1)
	return p.Text(), err
}

func (s Conmon_AttachRequest) HasSocketPath() bool {
	return capnp.Struct(s).HasPtr(1)
}

func (s Conmon_AttachRequest) SocketPathBytes() ([]byte, error) {
	p, err := capnp.Struct(s).Ptr(1)
	return p.TextBytes(), err
}

func (s Conmon_AttachRequest) SetSocketPath(v string) error {
	return capnp.Struct(s).SetText(1, v)
}

func (s Conmon_AttachRequest) ExecSessionId() (string, error) {
	p, err := capnp.Struct(s).Ptr(2)
	return p.Text(), err
}

func (s Conmon_AttachRequest) HasExecSessionId() bool {
	return capnp.Struct(s).HasPtr(2)
}

func (s Conmon_AttachRequest) ExecSessionIdBytes() ([]byte, error) {
	p, err := capnp.Struct(s).Ptr(2)
	return p.TextBytes(), err
}

func (s Conmon_AttachRequest) SetExecSessionId(v string) error {
	return capnp.Struct(s).SetText(2, v)
}

func (s Conmon_AttachRequest) StopAfterStdinEof() bool {
	return capnp.Struct(s).Bit(0)
}

func (s Conmon_AttachRequest) SetStopAfterStdinEof(v bool) {
	capnp.Struct(s).SetBit(0, v)
}

func (s Conmon_AttachRequest) Metadata() ([]byte, error) {
	p, err := capnp.Struct(s).Ptr(3)
	return []byte(p.Data()), err
}

func (s Conmon_AttachRequest) HasMetadata() bool {
	return capnp.Struct(s).HasPtr(3)
}

func (s Conmon_AttachRequest) SetMetadata(v []byte) error {
	return capnp.Struct(s).SetData(3, v)
}

// Conmon_AttachRequest_List is a list of Conmon_AttachRequest.
type Conmon_AttachRequest_List = capnp.StructList[Conmon_AttachRequest]

// NewConmon_AttachRequest creates a new list of Conmon_AttachRequest.
func NewConmon_AttachRequest_List(s *capnp.Segment, sz int32) (Conmon_AttachRequest_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 4}, sz)
	return capnp.StructList[Conmon_AttachRequest](l), err
}

// Conmon_AttachRequest_Future is a wrapper for a Conmon_AttachRequest promised by a client call.
type Conmon_AttachRequest_Future struct{ *capnp.Future }

func (f Conmon_AttachRequest_Future) Struct() (Conmon_AttachRequest, error) {
	p, err := f.Future.Ptr()
	return Conmon_AttachRequest(p.Struct()), err
}

type Conmon_AttachResponse capnp.Struct

// Conmon_AttachResponse_TypeID is the unique identifier for the type Conmon_AttachResponse.
const Conmon_AttachResponse_TypeID = 0xace5517aafc86077

func NewConmon_AttachResponse(s *capnp.Segment) (Conmon_AttachResponse, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return Conmon_AttachResponse(st), err
}

func NewRootConmon_AttachResponse(s *capnp.Segment) (Conmon_AttachResponse, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return Conmon_AttachResponse(st), err
}

func ReadRootConmon_AttachResponse(msg *capnp.Message) (Conmon_AttachResponse, error) {
	root, err := msg.Root()
	return Conmon_AttachResponse(root.Struct()), err
}

func (s Conmon_AttachResponse) String() string {
	str, _ := text.Marshal(0xace5517aafc86077, capnp.Struct(s))
	return str
}

func (s Conmon_AttachResponse) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Conmon_AttachResponse) DecodeFromPtr(p capnp.Ptr) Conmon_AttachResponse {
	return Conmon_AttachResponse(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Conmon_AttachResponse) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Conmon_AttachResponse) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Conmon_AttachResponse) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Conmon_AttachResponse) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}

// Conmon_AttachResponse_List is a list of Conmon_AttachResponse.
type Conmon_AttachResponse_List = capnp.StructList[Conmon_AttachResponse]

// NewConmon_AttachResponse creates a new list of Conmon_AttachResponse.
func NewConmon_AttachResponse_List(s *capnp.Segment, sz int32) (Conmon_AttachResponse_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0}, sz)
	return capnp.StructList[Conmon_AttachResponse](l), err
}

// Conmon_AttachResponse_Future is a wrapper for a Conmon_AttachResponse promised by a client call.
type Conmon_AttachResponse_Future struct{ *capnp.Future }

func (f Conmon_AttachResponse_Future) Struct() (Conmon_AttachResponse, error) {
	p, err := f.Future.Ptr()
	return Conmon_AttachResponse(p.Struct()), err
}

type Conmon_ReopenLogRequest capnp.Struct

// Conmon_ReopenLogRequest_TypeID is the unique identifier for the type Conmon_ReopenLogRequest.
const Conmon_ReopenLogRequest_TypeID = 0xd0476e0f34d1411a

func NewConmon_ReopenLogRequest(s *capnp.Segment) (Conmon_ReopenLogRequest, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2})
	return Conmon_ReopenLogRequest(st), err
}

func NewRootConmon_ReopenLogRequest(s *capnp.Segment) (Conmon_ReopenLogRequest, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2})
	return Conmon_ReopenLogRequest(st), err
}

func ReadRootConmon_ReopenLogRequest(msg *capnp.Message) (Conmon_ReopenLogRequest, error) {
	root, err := msg.Root()
	return Conmon_ReopenLogRequest(root.Struct()), err
}

func (s Conmon_ReopenLogRequest) String() string {
	str, _ := text.Marshal(0xd0476e0f34d1411a, capnp.Struct(s))
	return str
}

func (s Conmon_ReopenLogRequest) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Conmon_ReopenLogRequest) DecodeFromPtr(p capnp.Ptr) Conmon_ReopenLogRequest {
	return Conmon_ReopenLogRequest(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Conmon_ReopenLogRequest) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Conmon_ReopenLogRequest) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Conmon_ReopenLogRequest) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Conmon_ReopenLogRequest) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Conmon_ReopenLogRequest) Id() (string, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return p.Text(), err
}

func (s Conmon_ReopenLogRequest) HasId() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Conmon_ReopenLogRequest) IdBytes() ([]byte, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return p.TextBytes(), err
}

func (s Conmon_ReopenLogRequest) SetId(v string) error {
	return capnp.Struct(s).SetText(0, v)
}

func (s Conmon_ReopenLogRequest) Metadata() ([]byte, error) {
	p, err := capnp.Struct(s).Ptr(1)
	return []byte(p.Data()), err
}

func (s Conmon_ReopenLogRequest) HasMetadata() bool {
	return capnp.Struct(s).HasPtr(1)
}

func (s Conmon_ReopenLogRequest) SetMetadata(v []byte) error {
	return capnp.Struct(s).SetData(1, v)
}

// Conmon_ReopenLogRequest_List is a list of Conmon_ReopenLogRequest.
type Conmon_ReopenLogRequest_List = capnp.StructList[Conmon_ReopenLogRequest]

// NewConmon_ReopenLogRequest creates a new list of Conmon_ReopenLogRequest.
func NewConmon_ReopenLogRequest_List(s *capnp.Segment, sz int32) (Conmon_ReopenLogRequest_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2}, sz)
	return capnp.StructList[Conmon_ReopenLogRequest](l), err
}

// Conmon_ReopenLogRequest_Future is a wrapper for a Conmon_ReopenLogRequest promised by a client call.
type Conmon_ReopenLogRequest_Future struct{ *capnp.Future }

func (f Conmon_ReopenLogRequest_Future) Struct() (Conmon_ReopenLogRequest, error) {
	p, err := f.Future.Ptr()
	return Conmon_ReopenLogRequest(p.Struct()), err
}

type Conmon_ReopenLogResponse capnp.Struct

// Conmon_ReopenLogResponse_TypeID is the unique identifier for the type Conmon_ReopenLogResponse.
const Conmon_ReopenLogResponse_TypeID = 0xa20f49456be85b99

func NewConmon_ReopenLogResponse(s *capnp.Segment) (Conmon_ReopenLogResponse, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return Conmon_ReopenLogResponse(st), err
}

func NewRootConmon_ReopenLogResponse(s *capnp.Segment) (Conmon_ReopenLogResponse, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return Conmon_ReopenLogResponse(st), err
}

func ReadRootConmon_ReopenLogResponse(msg *capnp.Message) (Conmon_ReopenLogResponse, error) {
	root, err := msg.Root()
	return Conmon_ReopenLogResponse(root.Struct()), err
}

func (s Conmon_ReopenLogResponse) String() string {
	str, _ := text.Marshal(0xa20f49456be85b99, capnp.Struct(s))
	return str
}

func (s Conmon_ReopenLogResponse) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Conmon_ReopenLogResponse) DecodeFromPtr(p capnp.Ptr) Conmon_ReopenLogResponse {
	return Conmon_ReopenLogResponse(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Conmon_ReopenLogResponse) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Conmon_ReopenLogResponse) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Conmon_ReopenLogResponse) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Conmon_ReopenLogResponse) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}

// Conmon_ReopenLogResponse_List is a list of Conmon_ReopenLogResponse.
type Conmon_ReopenLogResponse_List = capnp.StructList[Conmon_ReopenLogResponse]

// NewConmon_ReopenLogResponse creates a new list of Conmon_ReopenLogResponse.
func NewConmon_ReopenLogResponse_List(s *capnp.Segment, sz int32) (Conmon_ReopenLogResponse_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0}, sz)
	return capnp.StructList[Conmon_ReopenLogResponse](l), err
}

// Conmon_ReopenLogResponse_Future is a wrapper for a Conmon_ReopenLogResponse promised by a client call.
type Conmon_ReopenLogResponse_Future struct{ *capnp.Future }

func (f Conmon_ReopenLogResponse_Future) Struct() (Conmon_ReopenLogResponse, error) {
	p, err := f.Future.Ptr()
	return Conmon_ReopenLogResponse(p.Struct()), err
}

type Conmon_SetWindowSizeRequest capnp.Struct

// Conmon_SetWindowSizeRequest_TypeID is the unique identifier for the type Conmon_SetWindowSizeRequest.
const Conmon_SetWindowSizeRequest_TypeID = 0xb5418b8ea8ead17b

func NewConmon_SetWindowSizeRequest(s *capnp.Segment) (Conmon_SetWindowSizeRequest, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 2})
	return Conmon_SetWindowSizeRequest(st), err
}

func NewRootConmon_SetWindowSizeRequest(s *capnp.Segment) (Conmon_SetWindowSizeRequest, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 2})
	return Conmon_SetWindowSizeRequest(st), err
}

func ReadRootConmon_SetWindowSizeRequest(msg *capnp.Message) (Conmon_SetWindowSizeRequest, error) {
	root, err := msg.Root()
	return Conmon_SetWindowSizeRequest(root.Struct()), err
}

func (s Conmon_SetWindowSizeRequest) String() string {
	str, _ := text.Marshal(0xb5418b8ea8ead17b, capnp.Struct(s))
	return str
}

func (s Conmon_SetWindowSizeRequest) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Conmon_SetWindowSizeRequest) DecodeFromPtr(p capnp.Ptr) Conmon_SetWindowSizeRequest {
	return Conmon_SetWindowSizeRequest(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Conmon_SetWindowSizeRequest) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Conmon_SetWindowSizeRequest) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Conmon_SetWindowSizeRequest) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Conmon_SetWindowSizeRequest) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Conmon_SetWindowSizeRequest) Id() (string, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return p.Text(), err
}

func (s Conmon_SetWindowSizeRequest) HasId() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Conmon_SetWindowSizeRequest) IdBytes() ([]byte, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return p.TextBytes(), err
}

func (s Conmon_SetWindowSizeRequest) SetId(v string) error {
	return capnp.Struct(s).SetText(0, v)
}

func (s Conmon_SetWindowSizeRequest) Width() uint16 {
	return capnp.Struct(s).Uint16(0)
}

func (s Conmon_SetWindowSizeRequest) SetWidth(v uint16) {
	capnp.Struct(s).SetUint16(0, v)
}

func (s Conmon_SetWindowSizeRequest) Height() uint16 {
	return capnp.Struct(s).Uint16(2)
}

func (s Conmon_SetWindowSizeRequest) SetHeight(v uint16) {
	capnp.Struct(s).SetUint16(2, v)
}

func (s Conmon_SetWindowSizeRequest) Metadata() ([]byte, error) {
	p, err := capnp.Struct(s).Ptr(1)
	return []byte(p.Data()), err
}

func (s Conmon_SetWindowSizeRequest) HasMetadata() bool {
	return capnp.Struct(s).HasPtr(1)
}

func (s Conmon_SetWindowSizeRequest) SetMetadata(v []byte) error {
	return capnp.Struct(s).SetData(1, v)
}

// Conmon_SetWindowSizeRequest_List is a list of Conmon_SetWindowSizeRequest.
type Conmon_SetWindowSizeRequest_List = capnp.StructList[Conmon_SetWindowSizeRequest]

// NewConmon_SetWindowSizeRequest creates a new list of Conmon_SetWindowSizeRequest.
func NewConmon_SetWindowSizeRequest_List(s *capnp.Segment, sz int32) (Conmon_SetWindowSizeRequest_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 2}, sz)
	return capnp.StructList[Conmon_SetWindowSizeRequest](l), err
}

// Conmon_SetWindowSizeRequest_Future is a wrapper for a Conmon_SetWindowSizeRequest promised by a client call.
type Conmon_SetWindowSizeRequest_Future struct{ *capnp.Future }

func (f Conmon_SetWindowSizeRequest_Future) Struct() (Conmon_SetWindowSizeRequest, error) {
	p, err := f.Future.Ptr()
	return Conmon_SetWindowSizeRequest(p.Struct()), err
}

type Conmon_SetWindowSizeResponse capnp.Struct

// Conmon_SetWindowSizeResponse_TypeID is the unique identifier for the type Conmon_SetWindowSizeResponse.
const Conmon_SetWindowSizeResponse_TypeID = 0xf9b3cd8033aba1f8

func NewConmon_SetWindowSizeResponse(s *capnp.Segment) (Conmon_SetWindowSizeResponse, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return Conmon_SetWindowSizeResponse(st), err
}

func NewRootConmon_SetWindowSizeResponse(s *capnp.Segment) (Conmon_SetWindowSizeResponse, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0})
	return Conmon_SetWindowSizeResponse(st), err
}

func ReadRootConmon_SetWindowSizeResponse(msg *capnp.Message) (Conmon_SetWindowSizeResponse, error) {
	root, err := msg.Root()
	return Conmon_SetWindowSizeResponse(root.Struct()), err
}

func (s Conmon_SetWindowSizeResponse) String() string {
	str, _ := text.Marshal(0xf9b3cd8033aba1f8, capnp.Struct(s))
	return str
}

func (s Conmon_SetWindowSizeResponse) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Conmon_SetWindowSizeResponse) DecodeFromPtr(p capnp.Ptr) Conmon_SetWindowSizeResponse {
	return Conmon_SetWindowSizeResponse(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Conmon_SetWindowSizeResponse) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Conmon_SetWindowSizeResponse) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Conmon_SetWindowSizeResponse) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Conmon_SetWindowSizeResponse) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}

// Conmon_SetWindowSizeResponse_List is a list of Conmon_SetWindowSizeResponse.
type Conmon_SetWindowSizeResponse_List = capnp.StructList[Conmon_SetWindowSizeResponse]

// NewConmon_SetWindowSizeResponse creates a new list of Conmon_SetWindowSizeResponse.
func NewConmon_SetWindowSizeResponse_List(s *capnp.Segment, sz int32) (Conmon_SetWindowSizeResponse_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 0}, sz)
	return capnp.StructList[Conmon_SetWindowSizeResponse](l), err
}

// Conmon_SetWindowSizeResponse_Future is a wrapper for a Conmon_SetWindowSizeResponse promised by a client call.
type Conmon_SetWindowSizeResponse_Future struct{ *capnp.Future }

func (f Conmon_SetWindowSizeResponse_Future) Struct() (Conmon_SetWindowSizeResponse, error) {
	p, err := f.Future.Ptr()
	return Conmon_SetWindowSizeResponse(p.Struct()), err
}

type Conmon_CreateNamespacesRequest capnp.Struct

// Conmon_CreateNamespacesRequest_TypeID is the unique identifier for the type Conmon_CreateNamespacesRequest.
const Conmon_CreateNamespacesRequest_TypeID = 0x8b5b1693940f607e

func NewConmon_CreateNamespacesRequest(s *capnp.Segment) (Conmon_CreateNamespacesRequest, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 4})
	return Conmon_CreateNamespacesRequest(st), err
}

func NewRootConmon_CreateNamespacesRequest(s *capnp.Segment) (Conmon_CreateNamespacesRequest, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 4})
	return Conmon_CreateNamespacesRequest(st), err
}

func ReadRootConmon_CreateNamespacesRequest(msg *capnp.Message) (Conmon_CreateNamespacesRequest, error) {
	root, err := msg.Root()
	return Conmon_CreateNamespacesRequest(root.Struct()), err
}

func (s Conmon_CreateNamespacesRequest) String() string {
	str, _ := text.Marshal(0x8b5b1693940f607e, capnp.Struct(s))
	return str
}

func (s Conmon_CreateNamespacesRequest) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Conmon_CreateNamespacesRequest) DecodeFromPtr(p capnp.Ptr) Conmon_CreateNamespacesRequest {
	return Conmon_CreateNamespacesRequest(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Conmon_CreateNamespacesRequest) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Conmon_CreateNamespacesRequest) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Conmon_CreateNamespacesRequest) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Conmon_CreateNamespacesRequest) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Conmon_CreateNamespacesRequest) Metadata() ([]byte, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return []byte(p.Data()), err
}

func (s Conmon_CreateNamespacesRequest) HasMetadata() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Conmon_CreateNamespacesRequest) SetMetadata(v []byte) error {
	return capnp.Struct(s).SetData(0, v)
}

func (s Conmon_CreateNamespacesRequest) Namespaces() (Conmon_Namespace_List, error) {
	p, err := capnp.Struct(s).Ptr(1)
	return Conmon_Namespace_List(p.List()), err
}

func (s Conmon_CreateNamespacesRequest) HasNamespaces() bool {
	return capnp.Struct(s).HasPtr(1)
}

func (s Conmon_CreateNamespacesRequest) SetNamespaces(v Conmon_Namespace_List) error {
	return capnp.Struct(s).SetPtr(1, v.ToPtr())
}

// NewNamespaces sets the namespaces field to a newly
// allocated Conmon_Namespace_List, preferring placement in s's segment.
func (s Conmon_CreateNamespacesRequest) NewNamespaces(n int32) (Conmon_Namespace_List, error) {
	l, err := NewConmon_Namespace_List(capnp.Struct(s).Segment(), n)
	if err != nil {
		return Conmon_Namespace_List{}, err
	}
	err = capnp.Struct(s).SetPtr(1, l.ToPtr())
	return l, err
}
func (s Conmon_CreateNamespacesRequest) UidMappings() (capnp.TextList, error) {
	p, err := capnp.Struct(s).Ptr(2)
	return capnp.TextList(p.List()), err
}

func (s Conmon_CreateNamespacesRequest) HasUidMappings() bool {
	return capnp.Struct(s).HasPtr(2)
}

func (s Conmon_CreateNamespacesRequest) SetUidMappings(v capnp.TextList) error {
	return capnp.Struct(s).SetPtr(2, v.ToPtr())
}

// NewUidMappings sets the uidMappings field to a newly
// allocated capnp.TextList, preferring placement in s's segment.
func (s Conmon_CreateNamespacesRequest) NewUidMappings(n int32) (capnp.TextList, error) {
	l, err := capnp.NewTextList(capnp.Struct(s).Segment(), n)
	if err != nil {
		return capnp.TextList{}, err
	}
	err = capnp.Struct(s).SetPtr(2, l.ToPtr())
	return l, err
}
func (s Conmon_CreateNamespacesRequest) GidMappings() (capnp.TextList, error) {
	p, err := capnp.Struct(s).Ptr(3)
	return capnp.TextList(p.List()), err
}

func (s Conmon_CreateNamespacesRequest) HasGidMappings() bool {
	return capnp.Struct(s).HasPtr(3)
}

func (s Conmon_CreateNamespacesRequest) SetGidMappings(v capnp.TextList) error {
	return capnp.Struct(s).SetPtr(3, v.ToPtr())
}

// NewGidMappings sets the gidMappings field to a newly
// allocated capnp.TextList, preferring placement in s's segment.
func (s Conmon_CreateNamespacesRequest) NewGidMappings(n int32) (capnp.TextList, error) {
	l, err := capnp.NewTextList(capnp.Struct(s).Segment(), n)
	if err != nil {
		return capnp.TextList{}, err
	}
	err = capnp.Struct(s).SetPtr(3, l.ToPtr())
	return l, err
}

// Conmon_CreateNamespacesRequest_List is a list of Conmon_CreateNamespacesRequest.
type Conmon_CreateNamespacesRequest_List = capnp.StructList[Conmon_CreateNamespacesRequest]

// NewConmon_CreateNamespacesRequest creates a new list of Conmon_CreateNamespacesRequest.
func NewConmon_CreateNamespacesRequest_List(s *capnp.Segment, sz int32) (Conmon_CreateNamespacesRequest_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 4}, sz)
	return capnp.StructList[Conmon_CreateNamespacesRequest](l), err
}

// Conmon_CreateNamespacesRequest_Future is a wrapper for a Conmon_CreateNamespacesRequest promised by a client call.
type Conmon_CreateNamespacesRequest_Future struct{ *capnp.Future }

func (f Conmon_CreateNamespacesRequest_Future) Struct() (Conmon_CreateNamespacesRequest, error) {
	p, err := f.Future.Ptr()
	return Conmon_CreateNamespacesRequest(p.Struct()), err
}

type Conmon_Namespace uint16

// Conmon_Namespace_TypeID is the unique identifier for the type Conmon_Namespace.
const Conmon_Namespace_TypeID = 0xd61491b560a8f3a3

// Values of Conmon_Namespace.
const (
	Conmon_Namespace_ipc  Conmon_Namespace = 0
	Conmon_Namespace_net  Conmon_Namespace = 1
	Conmon_Namespace_pid  Conmon_Namespace = 2
	Conmon_Namespace_user Conmon_Namespace = 3
	Conmon_Namespace_uts  Conmon_Namespace = 4
)

// String returns the enum's constant name.
func (c Conmon_Namespace) String() string {
	switch c {
	case Conmon_Namespace_ipc:
		return "ipc"
	case Conmon_Namespace_net:
		return "net"
	case Conmon_Namespace_pid:
		return "pid"
	case Conmon_Namespace_user:
		return "user"
	case Conmon_Namespace_uts:
		return "uts"

	default:
		return ""
	}
}

// Conmon_NamespaceFromString returns the enum value with a name,
// or the zero value if there's no such value.
func Conmon_NamespaceFromString(c string) Conmon_Namespace {
	switch c {
	case "ipc":
		return Conmon_Namespace_ipc
	case "net":
		return Conmon_Namespace_net
	case "pid":
		return Conmon_Namespace_pid
	case "user":
		return Conmon_Namespace_user
	case "uts":
		return Conmon_Namespace_uts

	default:
		return 0
	}
}

type Conmon_Namespace_List = capnp.EnumList[Conmon_Namespace]

func NewConmon_Namespace_List(s *capnp.Segment, sz int32) (Conmon_Namespace_List, error) {
	return capnp.NewEnumList[Conmon_Namespace](s, sz)
}

type Conmon_CreateNamespacesResponse capnp.Struct

// Conmon_CreateNamespacesResponse_TypeID is the unique identifier for the type Conmon_CreateNamespacesResponse.
const Conmon_CreateNamespacesResponse_TypeID = 0x9887a60f577a1ecb

func NewConmon_CreateNamespacesResponse(s *capnp.Segment) (Conmon_CreateNamespacesResponse, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_CreateNamespacesResponse(st), err
}

func NewRootConmon_CreateNamespacesResponse(s *capnp.Segment) (Conmon_CreateNamespacesResponse, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_CreateNamespacesResponse(st), err
}

func ReadRootConmon_CreateNamespacesResponse(msg *capnp.Message) (Conmon_CreateNamespacesResponse, error) {
	root, err := msg.Root()
	return Conmon_CreateNamespacesResponse(root.Struct()), err
}

func (s Conmon_CreateNamespacesResponse) String() string {
	str, _ := text.Marshal(0x9887a60f577a1ecb, capnp.Struct(s))
	return str
}

func (s Conmon_CreateNamespacesResponse) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Conmon_CreateNamespacesResponse) DecodeFromPtr(p capnp.Ptr) Conmon_CreateNamespacesResponse {
	return Conmon_CreateNamespacesResponse(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Conmon_CreateNamespacesResponse) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Conmon_CreateNamespacesResponse) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Conmon_CreateNamespacesResponse) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Conmon_CreateNamespacesResponse) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Conmon_CreateNamespacesResponse) Namespaces() (Conmon_NamespaceResponse_List, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return Conmon_NamespaceResponse_List(p.List()), err
}

func (s Conmon_CreateNamespacesResponse) HasNamespaces() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Conmon_CreateNamespacesResponse) SetNamespaces(v Conmon_NamespaceResponse_List) error {
	return capnp.Struct(s).SetPtr(0, v.ToPtr())
}

// NewNamespaces sets the namespaces field to a newly
// allocated Conmon_NamespaceResponse_List, preferring placement in s's segment.
func (s Conmon_CreateNamespacesResponse) NewNamespaces(n int32) (Conmon_NamespaceResponse_List, error) {
	l, err := NewConmon_NamespaceResponse_List(capnp.Struct(s).Segment(), n)
	if err != nil {
		return Conmon_NamespaceResponse_List{}, err
	}
	err = capnp.Struct(s).SetPtr(0, l.ToPtr())
	return l, err
}

// Conmon_CreateNamespacesResponse_List is a list of Conmon_CreateNamespacesResponse.
type Conmon_CreateNamespacesResponse_List = capnp.StructList[Conmon_CreateNamespacesResponse]

// NewConmon_CreateNamespacesResponse creates a new list of Conmon_CreateNamespacesResponse.
func NewConmon_CreateNamespacesResponse_List(s *capnp.Segment, sz int32) (Conmon_CreateNamespacesResponse_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return capnp.StructList[Conmon_CreateNamespacesResponse](l), err
}

// Conmon_CreateNamespacesResponse_Future is a wrapper for a Conmon_CreateNamespacesResponse promised by a client call.
type Conmon_CreateNamespacesResponse_Future struct{ *capnp.Future }

func (f Conmon_CreateNamespacesResponse_Future) Struct() (Conmon_CreateNamespacesResponse, error) {
	p, err := f.Future.Ptr()
	return Conmon_CreateNamespacesResponse(p.Struct()), err
}

type Conmon_NamespaceResponse capnp.Struct

// Conmon_NamespaceResponse_TypeID is the unique identifier for the type Conmon_NamespaceResponse.
const Conmon_NamespaceResponse_TypeID = 0xa93853d6a4e3fa16

func NewConmon_NamespaceResponse(s *capnp.Segment) (Conmon_NamespaceResponse, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return Conmon_NamespaceResponse(st), err
}

func NewRootConmon_NamespaceResponse(s *capnp.Segment) (Conmon_NamespaceResponse, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return Conmon_NamespaceResponse(st), err
}

func ReadRootConmon_NamespaceResponse(msg *capnp.Message) (Conmon_NamespaceResponse, error) {
	root, err := msg.Root()
	return Conmon_NamespaceResponse(root.Struct()), err
}

func (s Conmon_NamespaceResponse) String() string {
	str, _ := text.Marshal(0xa93853d6a4e3fa16, capnp.Struct(s))
	return str
}

func (s Conmon_NamespaceResponse) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Conmon_NamespaceResponse) DecodeFromPtr(p capnp.Ptr) Conmon_NamespaceResponse {
	return Conmon_NamespaceResponse(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Conmon_NamespaceResponse) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Conmon_NamespaceResponse) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Conmon_NamespaceResponse) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Conmon_NamespaceResponse) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Conmon_NamespaceResponse) Type() Conmon_Namespace {
	return Conmon_Namespace(capnp.Struct(s).Uint16(0))
}

func (s Conmon_NamespaceResponse) SetType(v Conmon_Namespace) {
	capnp.Struct(s).SetUint16(0, uint16(v))
}

func (s Conmon_NamespaceResponse) Path() (string, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return p.Text(), err
}

func (s Conmon_NamespaceResponse) HasPath() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Conmon_NamespaceResponse) PathBytes() ([]byte, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return p.TextBytes(), err
}

func (s Conmon_NamespaceResponse) SetPath(v string) error {
	return capnp.Struct(s).SetText(0, v)
}

// Conmon_NamespaceResponse_List is a list of Conmon_NamespaceResponse.
type Conmon_NamespaceResponse_List = capnp.StructList[Conmon_NamespaceResponse]

// NewConmon_NamespaceResponse creates a new list of Conmon_NamespaceResponse.
func NewConmon_NamespaceResponse_List(s *capnp.Segment, sz int32) (Conmon_NamespaceResponse_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1}, sz)
	return capnp.StructList[Conmon_NamespaceResponse](l), err
}

// Conmon_NamespaceResponse_Future is a wrapper for a Conmon_NamespaceResponse promised by a client call.
type Conmon_NamespaceResponse_Future struct{ *capnp.Future }

func (f Conmon_NamespaceResponse_Future) Struct() (Conmon_NamespaceResponse, error) {
	p, err := f.Future.Ptr()
	return Conmon_NamespaceResponse(p.Struct()), err
}

type Conmon_version_Params capnp.Struct

// Conmon_version_Params_TypeID is the unique identifier for the type Conmon_version_Params.
const Conmon_version_Params_TypeID = 0xcc2f70676afee4e7

func NewConmon_version_Params(s *capnp.Segment) (Conmon_version_Params, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_version_Params(st), err
}

func NewRootConmon_version_Params(s *capnp.Segment) (Conmon_version_Params, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_version_Params(st), err
}

func ReadRootConmon_version_Params(msg *capnp.Message) (Conmon_version_Params, error) {
	root, err := msg.Root()
	return Conmon_version_Params(root.Struct()), err
}

func (s Conmon_version_Params) String() string {
	str, _ := text.Marshal(0xcc2f70676afee4e7, capnp.Struct(s))
	return str
}

func (s Conmon_version_Params) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Conmon_version_Params) DecodeFromPtr(p capnp.Ptr) Conmon_version_Params {
	return Conmon_version_Params(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Conmon_version_Params) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Conmon_version_Params) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Conmon_version_Params) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Conmon_version_Params) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Conmon_version_Params) Request() (Conmon_VersionRequest, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return Conmon_VersionRequest(p.Struct()), err
}

func (s Conmon_version_Params) HasRequest() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Conmon_version_Params) SetRequest(v Conmon_VersionRequest) error {
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewRequest sets the request field to a newly
// allocated Conmon_VersionRequest struct, preferring placement in s's segment.
func (s Conmon_version_Params) NewRequest() (Conmon_VersionRequest, error) {
	ss, err := NewConmon_VersionRequest(capnp.Struct(s).Segment())
	if err != nil {
		return Conmon_VersionRequest{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

// Conmon_version_Params_List is a list of Conmon_version_Params.
type Conmon_version_Params_List = capnp.StructList[Conmon_version_Params]

// NewConmon_version_Params creates a new list of Conmon_version_Params.
func NewConmon_version_Params_List(s *capnp.Segment, sz int32) (Conmon_version_Params_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return capnp.StructList[Conmon_version_Params](l), err
}

// Conmon_version_Params_Future is a wrapper for a Conmon_version_Params promised by a client call.
type Conmon_version_Params_Future struct{ *capnp.Future }

func (f Conmon_version_Params_Future) Struct() (Conmon_version_Params, error) {
	p, err := f.Future.Ptr()
	return Conmon_version_Params(p.Struct()), err
}
func (p Conmon_version_Params_Future) Request() Conmon_VersionRequest_Future {
	return Conmon_VersionRequest_Future{Future: p.Future.Field(0, nil)}
}

type Conmon_version_Results capnp.Struct

// Conmon_version_Results_TypeID is the unique identifier for the type Conmon_version_Results.
const Conmon_version_Results_TypeID = 0xe313695ea9477b30

func NewConmon_version_Results(s *capnp.Segment) (Conmon_version_Results, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_version_Results(st), err
}

func NewRootConmon_version_Results(s *capnp.Segment) (Conmon_version_Results, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_version_Results(st), err
}

func ReadRootConmon_version_Results(msg *capnp.Message) (Conmon_version_Results, error) {
	root, err := msg.Root()
	return Conmon_version_Results(root.Struct()), err
}

func (s Conmon_version_Results) String() string {
	str, _ := text.Marshal(0xe313695ea9477b30, capnp.Struct(s))
	return str
}

func (s Conmon_version_Results) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Conmon_version_Results) DecodeFromPtr(p capnp.Ptr) Conmon_version_Results {
	return Conmon_version_Results(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Conmon_version_Results) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Conmon_version_Results) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Conmon_version_Results) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Conmon_version_Results) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Conmon_version_Results) Response() (Conmon_VersionResponse, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return Conmon_VersionResponse(p.Struct()), err
}

func (s Conmon_version_Results) HasResponse() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Conmon_version_Results) SetResponse(v Conmon_VersionResponse) error {
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewResponse sets the response field to a newly
// allocated Conmon_VersionResponse struct, preferring placement in s's segment.
func (s Conmon_version_Results) NewResponse() (Conmon_VersionResponse, error) {
	ss, err := NewConmon_VersionResponse(capnp.Struct(s).Segment())
	if err != nil {
		return Conmon_VersionResponse{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

// Conmon_version_Results_List is a list of Conmon_version_Results.
type Conmon_version_Results_List = capnp.StructList[Conmon_version_Results]

// NewConmon_version_Results creates a new list of Conmon_version_Results.
func NewConmon_version_Results_List(s *capnp.Segment, sz int32) (Conmon_version_Results_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return capnp.StructList[Conmon_version_Results](l), err
}

// Conmon_version_Results_Future is a wrapper for a Conmon_version_Results promised by a client call.
type Conmon_version_Results_Future struct{ *capnp.Future }

func (f Conmon_version_Results_Future) Struct() (Conmon_version_Results, error) {
	p, err := f.Future.Ptr()
	return Conmon_version_Results(p.Struct()), err
}
func (p Conmon_version_Results_Future) Response() Conmon_VersionResponse_Future {
	return Conmon_VersionResponse_Future{Future: p.Future.Field(0, nil)}
}

type Conmon_createContainer_Params capnp.Struct

// Conmon_createContainer_Params_TypeID is the unique identifier for the type Conmon_createContainer_Params.
const Conmon_createContainer_Params_TypeID = 0xf44732c48f949ab8

func NewConmon_createContainer_Params(s *capnp.Segment) (Conmon_createContainer_Params, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_createContainer_Params(st), err
}

func NewRootConmon_createContainer_Params(s *capnp.Segment) (Conmon_createContainer_Params, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_createContainer_Params(st), err
}

func ReadRootConmon_createContainer_Params(msg *capnp.Message) (Conmon_createContainer_Params, error) {
	root, err := msg.Root()
	return Conmon_createContainer_Params(root.Struct()), err
}

func (s Conmon_createContainer_Params) String() string {
	str, _ := text.Marshal(0xf44732c48f949ab8, capnp.Struct(s))
	return str
}

func (s Conmon_createContainer_Params) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Conmon_createContainer_Params) DecodeFromPtr(p capnp.Ptr) Conmon_createContainer_Params {
	return Conmon_createContainer_Params(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Conmon_createContainer_Params) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Conmon_createContainer_Params) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Conmon_createContainer_Params) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Conmon_createContainer_Params) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Conmon_createContainer_Params) Request() (Conmon_CreateContainerRequest, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return Conmon_CreateContainerRequest(p.Struct()), err
}

func (s Conmon_createContainer_Params) HasRequest() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Conmon_createContainer_Params) SetRequest(v Conmon_CreateContainerRequest) error {
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewRequest sets the request field to a newly
// allocated Conmon_CreateContainerRequest struct, preferring placement in s's segment.
func (s Conmon_createContainer_Params) NewRequest() (Conmon_CreateContainerRequest, error) {
	ss, err := NewConmon_CreateContainerRequest(capnp.Struct(s).Segment())
	if err != nil {
		return Conmon_CreateContainerRequest{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

// Conmon_createContainer_Params_List is a list of Conmon_createContainer_Params.
type Conmon_createContainer_Params_List = capnp.StructList[Conmon_createContainer_Params]

// NewConmon_createContainer_Params creates a new list of Conmon_createContainer_Params.
func NewConmon_createContainer_Params_List(s *capnp.Segment, sz int32) (Conmon_createContainer_Params_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return capnp.StructList[Conmon_createContainer_Params](l), err
}

// Conmon_createContainer_Params_Future is a wrapper for a Conmon_createContainer_Params promised by a client call.
type Conmon_createContainer_Params_Future struct{ *capnp.Future }

func (f Conmon_createContainer_Params_Future) Struct() (Conmon_createContainer_Params, error) {
	p, err := f.Future.Ptr()
	return Conmon_createContainer_Params(p.Struct()), err
}
func (p Conmon_createContainer_Params_Future) Request() Conmon_CreateContainerRequest_Future {
	return Conmon_CreateContainerRequest_Future{Future: p.Future.Field(0, nil)}
}

type Conmon_createContainer_Results capnp.Struct

// Conmon_createContainer_Results_TypeID is the unique identifier for the type Conmon_createContainer_Results.
const Conmon_createContainer_Results_TypeID = 0xceba3c1a97be15f8

func NewConmon_createContainer_Results(s *capnp.Segment) (Conmon_createContainer_Results, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_createContainer_Results(st), err
}

func NewRootConmon_createContainer_Results(s *capnp.Segment) (Conmon_createContainer_Results, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_createContainer_Results(st), err
}

func ReadRootConmon_createContainer_Results(msg *capnp.Message) (Conmon_createContainer_Results, error) {
	root, err := msg.Root()
	return Conmon_createContainer_Results(root.Struct()), err
}

func (s Conmon_createContainer_Results) String() string {
	str, _ := text.Marshal(0xceba3c1a97be15f8, capnp.Struct(s))
	return str
}

func (s Conmon_createContainer_Results) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Conmon_createContainer_Results) DecodeFromPtr(p capnp.Ptr) Conmon_createContainer_Results {
	return Conmon_createContainer_Results(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Conmon_createContainer_Results) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Conmon_createContainer_Results) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Conmon_createContainer_Results) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Conmon_createContainer_Results) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Conmon_createContainer_Results) Response() (Conmon_CreateContainerResponse, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return Conmon_CreateContainerResponse(p.Struct()), err
}

func (s Conmon_createContainer_Results) HasResponse() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Conmon_createContainer_Results) SetResponse(v Conmon_CreateContainerResponse) error {
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewResponse sets the response field to a newly
// allocated Conmon_CreateContainerResponse struct, preferring placement in s's segment.
func (s Conmon_createContainer_Results) NewResponse() (Conmon_CreateContainerResponse, error) {
	ss, err := NewConmon_CreateContainerResponse(capnp.Struct(s).Segment())
	if err != nil {
		return Conmon_CreateContainerResponse{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

// Conmon_createContainer_Results_List is a list of Conmon_createContainer_Results.
type Conmon_createContainer_Results_List = capnp.StructList[Conmon_createContainer_Results]

// NewConmon_createContainer_Results creates a new list of Conmon_createContainer_Results.
func NewConmon_createContainer_Results_List(s *capnp.Segment, sz int32) (Conmon_createContainer_Results_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return capnp.StructList[Conmon_createContainer_Results](l), err
}

// Conmon_createContainer_Results_Future is a wrapper for a Conmon_createContainer_Results promised by a client call.
type Conmon_createContainer_Results_Future struct{ *capnp.Future }

func (f Conmon_createContainer_Results_Future) Struct() (Conmon_createContainer_Results, error) {
	p, err := f.Future.Ptr()
	return Conmon_createContainer_Results(p.Struct()), err
}
func (p Conmon_createContainer_Results_Future) Response() Conmon_CreateContainerResponse_Future {
	return Conmon_CreateContainerResponse_Future{Future: p.Future.Field(0, nil)}
}

type Conmon_execSyncContainer_Params capnp.Struct

// Conmon_execSyncContainer_Params_TypeID is the unique identifier for the type Conmon_execSyncContainer_Params.
const Conmon_execSyncContainer_Params_TypeID = 0x83479da67279e173

func NewConmon_execSyncContainer_Params(s *capnp.Segment) (Conmon_execSyncContainer_Params, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_execSyncContainer_Params(st), err
}

func NewRootConmon_execSyncContainer_Params(s *capnp.Segment) (Conmon_execSyncContainer_Params, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_execSyncContainer_Params(st), err
}

func ReadRootConmon_execSyncContainer_Params(msg *capnp.Message) (Conmon_execSyncContainer_Params, error) {
	root, err := msg.Root()
	return Conmon_execSyncContainer_Params(root.Struct()), err
}

func (s Conmon_execSyncContainer_Params) String() string {
	str, _ := text.Marshal(0x83479da67279e173, capnp.Struct(s))
	return str
}

func (s Conmon_execSyncContainer_Params) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Conmon_execSyncContainer_Params) DecodeFromPtr(p capnp.Ptr) Conmon_execSyncContainer_Params {
	return Conmon_execSyncContainer_Params(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Conmon_execSyncContainer_Params) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Conmon_execSyncContainer_Params) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Conmon_execSyncContainer_Params) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Conmon_execSyncContainer_Params) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Conmon_execSyncContainer_Params) Request() (Conmon_ExecSyncContainerRequest, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return Conmon_ExecSyncContainerRequest(p.Struct()), err
}

func (s Conmon_execSyncContainer_Params) HasRequest() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Conmon_execSyncContainer_Params) SetRequest(v Conmon_ExecSyncContainerRequest) error {
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewRequest sets the request field to a newly
// allocated Conmon_ExecSyncContainerRequest struct, preferring placement in s's segment.
func (s Conmon_execSyncContainer_Params) NewRequest() (Conmon_ExecSyncContainerRequest, error) {
	ss, err := NewConmon_ExecSyncContainerRequest(capnp.Struct(s).Segment())
	if err != nil {
		return Conmon_ExecSyncContainerRequest{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

// Conmon_execSyncContainer_Params_List is a list of Conmon_execSyncContainer_Params.
type Conmon_execSyncContainer_Params_List = capnp.StructList[Conmon_execSyncContainer_Params]

// NewConmon_execSyncContainer_Params creates a new list of Conmon_execSyncContainer_Params.
func NewConmon_execSyncContainer_Params_List(s *capnp.Segment, sz int32) (Conmon_execSyncContainer_Params_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return capnp.StructList[Conmon_execSyncContainer_Params](l), err
}

// Conmon_execSyncContainer_Params_Future is a wrapper for a Conmon_execSyncContainer_Params promised by a client call.
type Conmon_execSyncContainer_Params_Future struct{ *capnp.Future }

func (f Conmon_execSyncContainer_Params_Future) Struct() (Conmon_execSyncContainer_Params, error) {
	p, err := f.Future.Ptr()
	return Conmon_execSyncContainer_Params(p.Struct()), err
}
func (p Conmon_execSyncContainer_Params_Future) Request() Conmon_ExecSyncContainerRequest_Future {
	return Conmon_ExecSyncContainerRequest_Future{Future: p.Future.Field(0, nil)}
}

type Conmon_execSyncContainer_Results capnp.Struct

// Conmon_execSyncContainer_Results_TypeID is the unique identifier for the type Conmon_execSyncContainer_Results.
const Conmon_execSyncContainer_Results_TypeID = 0xf8e86a5c0baa01bc

func NewConmon_execSyncContainer_Results(s *capnp.Segment) (Conmon_execSyncContainer_Results, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_execSyncContainer_Results(st), err
}

func NewRootConmon_execSyncContainer_Results(s *capnp.Segment) (Conmon_execSyncContainer_Results, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_execSyncContainer_Results(st), err
}

func ReadRootConmon_execSyncContainer_Results(msg *capnp.Message) (Conmon_execSyncContainer_Results, error) {
	root, err := msg.Root()
	return Conmon_execSyncContainer_Results(root.Struct()), err
}

func (s Conmon_execSyncContainer_Results) String() string {
	str, _ := text.Marshal(0xf8e86a5c0baa01bc, capnp.Struct(s))
	return str
}

func (s Conmon_execSyncContainer_Results) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Conmon_execSyncContainer_Results) DecodeFromPtr(p capnp.Ptr) Conmon_execSyncContainer_Results {
	return Conmon_execSyncContainer_Results(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Conmon_execSyncContainer_Results) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Conmon_execSyncContainer_Results) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Conmon_execSyncContainer_Results) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Conmon_execSyncContainer_Results) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Conmon_execSyncContainer_Results) Response() (Conmon_ExecSyncContainerResponse, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return Conmon_ExecSyncContainerResponse(p.Struct()), err
}

func (s Conmon_execSyncContainer_Results) HasResponse() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Conmon_execSyncContainer_Results) SetResponse(v Conmon_ExecSyncContainerResponse) error {
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewResponse sets the response field to a newly
// allocated Conmon_ExecSyncContainerResponse struct, preferring placement in s's segment.
func (s Conmon_execSyncContainer_Results) NewResponse() (Conmon_ExecSyncContainerResponse, error) {
	ss, err := NewConmon_ExecSyncContainerResponse(capnp.Struct(s).Segment())
	if err != nil {
		return Conmon_ExecSyncContainerResponse{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

// Conmon_execSyncContainer_Results_List is a list of Conmon_execSyncContainer_Results.
type Conmon_execSyncContainer_Results_List = capnp.StructList[Conmon_execSyncContainer_Results]

// NewConmon_execSyncContainer_Results creates a new list of Conmon_execSyncContainer_Results.
func NewConmon_execSyncContainer_Results_List(s *capnp.Segment, sz int32) (Conmon_execSyncContainer_Results_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return capnp.StructList[Conmon_execSyncContainer_Results](l), err
}

// Conmon_execSyncContainer_Results_Future is a wrapper for a Conmon_execSyncContainer_Results promised by a client call.
type Conmon_execSyncContainer_Results_Future struct{ *capnp.Future }

func (f Conmon_execSyncContainer_Results_Future) Struct() (Conmon_execSyncContainer_Results, error) {
	p, err := f.Future.Ptr()
	return Conmon_execSyncContainer_Results(p.Struct()), err
}
func (p Conmon_execSyncContainer_Results_Future) Response() Conmon_ExecSyncContainerResponse_Future {
	return Conmon_ExecSyncContainerResponse_Future{Future: p.Future.Field(0, nil)}
}

type Conmon_attachContainer_Params capnp.Struct

// Conmon_attachContainer_Params_TypeID is the unique identifier for the type Conmon_attachContainer_Params.
const Conmon_attachContainer_Params_TypeID = 0xaa2f3c8ad1c3af24

func NewConmon_attachContainer_Params(s *capnp.Segment) (Conmon_attachContainer_Params, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_attachContainer_Params(st), err
}

func NewRootConmon_attachContainer_Params(s *capnp.Segment) (Conmon_attachContainer_Params, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_attachContainer_Params(st), err
}

func ReadRootConmon_attachContainer_Params(msg *capnp.Message) (Conmon_attachContainer_Params, error) {
	root, err := msg.Root()
	return Conmon_attachContainer_Params(root.Struct()), err
}

func (s Conmon_attachContainer_Params) String() string {
	str, _ := text.Marshal(0xaa2f3c8ad1c3af24, capnp.Struct(s))
	return str
}

func (s Conmon_attachContainer_Params) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Conmon_attachContainer_Params) DecodeFromPtr(p capnp.Ptr) Conmon_attachContainer_Params {
	return Conmon_attachContainer_Params(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Conmon_attachContainer_Params) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Conmon_attachContainer_Params) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Conmon_attachContainer_Params) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Conmon_attachContainer_Params) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Conmon_attachContainer_Params) Request() (Conmon_AttachRequest, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return Conmon_AttachRequest(p.Struct()), err
}

func (s Conmon_attachContainer_Params) HasRequest() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Conmon_attachContainer_Params) SetRequest(v Conmon_AttachRequest) error {
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewRequest sets the request field to a newly
// allocated Conmon_AttachRequest struct, preferring placement in s's segment.
func (s Conmon_attachContainer_Params) NewRequest() (Conmon_AttachRequest, error) {
	ss, err := NewConmon_AttachRequest(capnp.Struct(s).Segment())
	if err != nil {
		return Conmon_AttachRequest{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

// Conmon_attachContainer_Params_List is a list of Conmon_attachContainer_Params.
type Conmon_attachContainer_Params_List = capnp.StructList[Conmon_attachContainer_Params]

// NewConmon_attachContainer_Params creates a new list of Conmon_attachContainer_Params.
func NewConmon_attachContainer_Params_List(s *capnp.Segment, sz int32) (Conmon_attachContainer_Params_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return capnp.StructList[Conmon_attachContainer_Params](l), err
}

// Conmon_attachContainer_Params_Future is a wrapper for a Conmon_attachContainer_Params promised by a client call.
type Conmon_attachContainer_Params_Future struct{ *capnp.Future }

func (f Conmon_attachContainer_Params_Future) Struct() (Conmon_attachContainer_Params, error) {
	p, err := f.Future.Ptr()
	return Conmon_attachContainer_Params(p.Struct()), err
}
func (p Conmon_attachContainer_Params_Future) Request() Conmon_AttachRequest_Future {
	return Conmon_AttachRequest_Future{Future: p.Future.Field(0, nil)}
}

type Conmon_attachContainer_Results capnp.Struct

// Conmon_attachContainer_Results_TypeID is the unique identifier for the type Conmon_attachContainer_Results.
const Conmon_attachContainer_Results_TypeID = 0xc5e65eec3dcf5b10

func NewConmon_attachContainer_Results(s *capnp.Segment) (Conmon_attachContainer_Results, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_attachContainer_Results(st), err
}

func NewRootConmon_attachContainer_Results(s *capnp.Segment) (Conmon_attachContainer_Results, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_attachContainer_Results(st), err
}

func ReadRootConmon_attachContainer_Results(msg *capnp.Message) (Conmon_attachContainer_Results, error) {
	root, err := msg.Root()
	return Conmon_attachContainer_Results(root.Struct()), err
}

func (s Conmon_attachContainer_Results) String() string {
	str, _ := text.Marshal(0xc5e65eec3dcf5b10, capnp.Struct(s))
	return str
}

func (s Conmon_attachContainer_Results) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Conmon_attachContainer_Results) DecodeFromPtr(p capnp.Ptr) Conmon_attachContainer_Results {
	return Conmon_attachContainer_Results(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Conmon_attachContainer_Results) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Conmon_attachContainer_Results) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Conmon_attachContainer_Results) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Conmon_attachContainer_Results) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Conmon_attachContainer_Results) Response() (Conmon_AttachResponse, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return Conmon_AttachResponse(p.Struct()), err
}

func (s Conmon_attachContainer_Results) HasResponse() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Conmon_attachContainer_Results) SetResponse(v Conmon_AttachResponse) error {
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewResponse sets the response field to a newly
// allocated Conmon_AttachResponse struct, preferring placement in s's segment.
func (s Conmon_attachContainer_Results) NewResponse() (Conmon_AttachResponse, error) {
	ss, err := NewConmon_AttachResponse(capnp.Struct(s).Segment())
	if err != nil {
		return Conmon_AttachResponse{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

// Conmon_attachContainer_Results_List is a list of Conmon_attachContainer_Results.
type Conmon_attachContainer_Results_List = capnp.StructList[Conmon_attachContainer_Results]

// NewConmon_attachContainer_Results creates a new list of Conmon_attachContainer_Results.
func NewConmon_attachContainer_Results_List(s *capnp.Segment, sz int32) (Conmon_attachContainer_Results_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return capnp.StructList[Conmon_attachContainer_Results](l), err
}

// Conmon_attachContainer_Results_Future is a wrapper for a Conmon_attachContainer_Results promised by a client call.
type Conmon_attachContainer_Results_Future struct{ *capnp.Future }

func (f Conmon_attachContainer_Results_Future) Struct() (Conmon_attachContainer_Results, error) {
	p, err := f.Future.Ptr()
	return Conmon_attachContainer_Results(p.Struct()), err
}
func (p Conmon_attachContainer_Results_Future) Response() Conmon_AttachResponse_Future {
	return Conmon_AttachResponse_Future{Future: p.Future.Field(0, nil)}
}

type Conmon_reopenLogContainer_Params capnp.Struct

// Conmon_reopenLogContainer_Params_TypeID is the unique identifier for the type Conmon_reopenLogContainer_Params.
const Conmon_reopenLogContainer_Params_TypeID = 0xe5ea916eb0c31336

func NewConmon_reopenLogContainer_Params(s *capnp.Segment) (Conmon_reopenLogContainer_Params, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_reopenLogContainer_Params(st), err
}

func NewRootConmon_reopenLogContainer_Params(s *capnp.Segment) (Conmon_reopenLogContainer_Params, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_reopenLogContainer_Params(st), err
}

func ReadRootConmon_reopenLogContainer_Params(msg *capnp.Message) (Conmon_reopenLogContainer_Params, error) {
	root, err := msg.Root()
	return Conmon_reopenLogContainer_Params(root.Struct()), err
}

func (s Conmon_reopenLogContainer_Params) String() string {
	str, _ := text.Marshal(0xe5ea916eb0c31336, capnp.Struct(s))
	return str
}

func (s Conmon_reopenLogContainer_Params) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Conmon_reopenLogContainer_Params) DecodeFromPtr(p capnp.Ptr) Conmon_reopenLogContainer_Params {
	return Conmon_reopenLogContainer_Params(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Conmon_reopenLogContainer_Params) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Conmon_reopenLogContainer_Params) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Conmon_reopenLogContainer_Params) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Conmon_reopenLogContainer_Params) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Conmon_reopenLogContainer_Params) Request() (Conmon_ReopenLogRequest, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return Conmon_ReopenLogRequest(p.Struct()), err
}

func (s Conmon_reopenLogContainer_Params) HasRequest() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Conmon_reopenLogContainer_Params) SetRequest(v Conmon_ReopenLogRequest) error {
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewRequest sets the request field to a newly
// allocated Conmon_ReopenLogRequest struct, preferring placement in s's segment.
func (s Conmon_reopenLogContainer_Params) NewRequest() (Conmon_ReopenLogRequest, error) {
	ss, err := NewConmon_ReopenLogRequest(capnp.Struct(s).Segment())
	if err != nil {
		return Conmon_ReopenLogRequest{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

// Conmon_reopenLogContainer_Params_List is a list of Conmon_reopenLogContainer_Params.
type Conmon_reopenLogContainer_Params_List = capnp.StructList[Conmon_reopenLogContainer_Params]

// NewConmon_reopenLogContainer_Params creates a new list of Conmon_reopenLogContainer_Params.
func NewConmon_reopenLogContainer_Params_List(s *capnp.Segment, sz int32) (Conmon_reopenLogContainer_Params_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return capnp.StructList[Conmon_reopenLogContainer_Params](l), err
}

// Conmon_reopenLogContainer_Params_Future is a wrapper for a Conmon_reopenLogContainer_Params promised by a client call.
type Conmon_reopenLogContainer_Params_Future struct{ *capnp.Future }

func (f Conmon_reopenLogContainer_Params_Future) Struct() (Conmon_reopenLogContainer_Params, error) {
	p, err := f.Future.Ptr()
	return Conmon_reopenLogContainer_Params(p.Struct()), err
}
func (p Conmon_reopenLogContainer_Params_Future) Request() Conmon_ReopenLogRequest_Future {
	return Conmon_ReopenLogRequest_Future{Future: p.Future.Field(0, nil)}
}

type Conmon_reopenLogContainer_Results capnp.Struct

// Conmon_reopenLogContainer_Results_TypeID is the unique identifier for the type Conmon_reopenLogContainer_Results.
const Conmon_reopenLogContainer_Results_TypeID = 0xa0ef8355b64ee985

func NewConmon_reopenLogContainer_Results(s *capnp.Segment) (Conmon_reopenLogContainer_Results, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_reopenLogContainer_Results(st), err
}

func NewRootConmon_reopenLogContainer_Results(s *capnp.Segment) (Conmon_reopenLogContainer_Results, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_reopenLogContainer_Results(st), err
}

func ReadRootConmon_reopenLogContainer_Results(msg *capnp.Message) (Conmon_reopenLogContainer_Results, error) {
	root, err := msg.Root()
	return Conmon_reopenLogContainer_Results(root.Struct()), err
}

func (s Conmon_reopenLogContainer_Results) String() string {
	str, _ := text.Marshal(0xa0ef8355b64ee985, capnp.Struct(s))
	return str
}

func (s Conmon_reopenLogContainer_Results) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Conmon_reopenLogContainer_Results) DecodeFromPtr(p capnp.Ptr) Conmon_reopenLogContainer_Results {
	return Conmon_reopenLogContainer_Results(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Conmon_reopenLogContainer_Results) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Conmon_reopenLogContainer_Results) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Conmon_reopenLogContainer_Results) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Conmon_reopenLogContainer_Results) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Conmon_reopenLogContainer_Results) Response() (Conmon_ReopenLogResponse, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return Conmon_ReopenLogResponse(p.Struct()), err
}

func (s Conmon_reopenLogContainer_Results) HasResponse() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Conmon_reopenLogContainer_Results) SetResponse(v Conmon_ReopenLogResponse) error {
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewResponse sets the response field to a newly
// allocated Conmon_ReopenLogResponse struct, preferring placement in s's segment.
func (s Conmon_reopenLogContainer_Results) NewResponse() (Conmon_ReopenLogResponse, error) {
	ss, err := NewConmon_ReopenLogResponse(capnp.Struct(s).Segment())
	if err != nil {
		return Conmon_ReopenLogResponse{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

// Conmon_reopenLogContainer_Results_List is a list of Conmon_reopenLogContainer_Results.
type Conmon_reopenLogContainer_Results_List = capnp.StructList[Conmon_reopenLogContainer_Results]

// NewConmon_reopenLogContainer_Results creates a new list of Conmon_reopenLogContainer_Results.
func NewConmon_reopenLogContainer_Results_List(s *capnp.Segment, sz int32) (Conmon_reopenLogContainer_Results_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return capnp.StructList[Conmon_reopenLogContainer_Results](l), err
}

// Conmon_reopenLogContainer_Results_Future is a wrapper for a Conmon_reopenLogContainer_Results promised by a client call.
type Conmon_reopenLogContainer_Results_Future struct{ *capnp.Future }

func (f Conmon_reopenLogContainer_Results_Future) Struct() (Conmon_reopenLogContainer_Results, error) {
	p, err := f.Future.Ptr()
	return Conmon_reopenLogContainer_Results(p.Struct()), err
}
func (p Conmon_reopenLogContainer_Results_Future) Response() Conmon_ReopenLogResponse_Future {
	return Conmon_ReopenLogResponse_Future{Future: p.Future.Field(0, nil)}
}

type Conmon_setWindowSizeContainer_Params capnp.Struct

// Conmon_setWindowSizeContainer_Params_TypeID is the unique identifier for the type Conmon_setWindowSizeContainer_Params.
const Conmon_setWindowSizeContainer_Params_TypeID = 0xc76ccd4502bb61e7

func NewConmon_setWindowSizeContainer_Params(s *capnp.Segment) (Conmon_setWindowSizeContainer_Params, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_setWindowSizeContainer_Params(st), err
}

func NewRootConmon_setWindowSizeContainer_Params(s *capnp.Segment) (Conmon_setWindowSizeContainer_Params, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_setWindowSizeContainer_Params(st), err
}

func ReadRootConmon_setWindowSizeContainer_Params(msg *capnp.Message) (Conmon_setWindowSizeContainer_Params, error) {
	root, err := msg.Root()
	return Conmon_setWindowSizeContainer_Params(root.Struct()), err
}

func (s Conmon_setWindowSizeContainer_Params) String() string {
	str, _ := text.Marshal(0xc76ccd4502bb61e7, capnp.Struct(s))
	return str
}

func (s Conmon_setWindowSizeContainer_Params) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Conmon_setWindowSizeContainer_Params) DecodeFromPtr(p capnp.Ptr) Conmon_setWindowSizeContainer_Params {
	return Conmon_setWindowSizeContainer_Params(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Conmon_setWindowSizeContainer_Params) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Conmon_setWindowSizeContainer_Params) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Conmon_setWindowSizeContainer_Params) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Conmon_setWindowSizeContainer_Params) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Conmon_setWindowSizeContainer_Params) Request() (Conmon_SetWindowSizeRequest, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return Conmon_SetWindowSizeRequest(p.Struct()), err
}

func (s Conmon_setWindowSizeContainer_Params) HasRequest() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Conmon_setWindowSizeContainer_Params) SetRequest(v Conmon_SetWindowSizeRequest) error {
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewRequest sets the request field to a newly
// allocated Conmon_SetWindowSizeRequest struct, preferring placement in s's segment.
func (s Conmon_setWindowSizeContainer_Params) NewRequest() (Conmon_SetWindowSizeRequest, error) {
	ss, err := NewConmon_SetWindowSizeRequest(capnp.Struct(s).Segment())
	if err != nil {
		return Conmon_SetWindowSizeRequest{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

// Conmon_setWindowSizeContainer_Params_List is a list of Conmon_setWindowSizeContainer_Params.
type Conmon_setWindowSizeContainer_Params_List = capnp.StructList[Conmon_setWindowSizeContainer_Params]

// NewConmon_setWindowSizeContainer_Params creates a new list of Conmon_setWindowSizeContainer_Params.
func NewConmon_setWindowSizeContainer_Params_List(s *capnp.Segment, sz int32) (Conmon_setWindowSizeContainer_Params_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return capnp.StructList[Conmon_setWindowSizeContainer_Params](l), err
}

// Conmon_setWindowSizeContainer_Params_Future is a wrapper for a Conmon_setWindowSizeContainer_Params promised by a client call.
type Conmon_setWindowSizeContainer_Params_Future struct{ *capnp.Future }

func (f Conmon_setWindowSizeContainer_Params_Future) Struct() (Conmon_setWindowSizeContainer_Params, error) {
	p, err := f.Future.Ptr()
	return Conmon_setWindowSizeContainer_Params(p.Struct()), err
}
func (p Conmon_setWindowSizeContainer_Params_Future) Request() Conmon_SetWindowSizeRequest_Future {
	return Conmon_SetWindowSizeRequest_Future{Future: p.Future.Field(0, nil)}
}

type Conmon_setWindowSizeContainer_Results capnp.Struct

// Conmon_setWindowSizeContainer_Results_TypeID is the unique identifier for the type Conmon_setWindowSizeContainer_Results.
const Conmon_setWindowSizeContainer_Results_TypeID = 0xe00e522611477055

func NewConmon_setWindowSizeContainer_Results(s *capnp.Segment) (Conmon_setWindowSizeContainer_Results, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_setWindowSizeContainer_Results(st), err
}

func NewRootConmon_setWindowSizeContainer_Results(s *capnp.Segment) (Conmon_setWindowSizeContainer_Results, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_setWindowSizeContainer_Results(st), err
}

func ReadRootConmon_setWindowSizeContainer_Results(msg *capnp.Message) (Conmon_setWindowSizeContainer_Results, error) {
	root, err := msg.Root()
	return Conmon_setWindowSizeContainer_Results(root.Struct()), err
}

func (s Conmon_setWindowSizeContainer_Results) String() string {
	str, _ := text.Marshal(0xe00e522611477055, capnp.Struct(s))
	return str
}

func (s Conmon_setWindowSizeContainer_Results) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Conmon_setWindowSizeContainer_Results) DecodeFromPtr(p capnp.Ptr) Conmon_setWindowSizeContainer_Results {
	return Conmon_setWindowSizeContainer_Results(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Conmon_setWindowSizeContainer_Results) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Conmon_setWindowSizeContainer_Results) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Conmon_setWindowSizeContainer_Results) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Conmon_setWindowSizeContainer_Results) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Conmon_setWindowSizeContainer_Results) Response() (Conmon_SetWindowSizeResponse, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return Conmon_SetWindowSizeResponse(p.Struct()), err
}

func (s Conmon_setWindowSizeContainer_Results) HasResponse() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Conmon_setWindowSizeContainer_Results) SetResponse(v Conmon_SetWindowSizeResponse) error {
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewResponse sets the response field to a newly
// allocated Conmon_SetWindowSizeResponse struct, preferring placement in s's segment.
func (s Conmon_setWindowSizeContainer_Results) NewResponse() (Conmon_SetWindowSizeResponse, error) {
	ss, err := NewConmon_SetWindowSizeResponse(capnp.Struct(s).Segment())
	if err != nil {
		return Conmon_SetWindowSizeResponse{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

// Conmon_setWindowSizeContainer_Results_List is a list of Conmon_setWindowSizeContainer_Results.
type Conmon_setWindowSizeContainer_Results_List = capnp.StructList[Conmon_setWindowSizeContainer_Results]

// NewConmon_setWindowSizeContainer_Results creates a new list of Conmon_setWindowSizeContainer_Results.
func NewConmon_setWindowSizeContainer_Results_List(s *capnp.Segment, sz int32) (Conmon_setWindowSizeContainer_Results_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return capnp.StructList[Conmon_setWindowSizeContainer_Results](l), err
}

// Conmon_setWindowSizeContainer_Results_Future is a wrapper for a Conmon_setWindowSizeContainer_Results promised by a client call.
type Conmon_setWindowSizeContainer_Results_Future struct{ *capnp.Future }

func (f Conmon_setWindowSizeContainer_Results_Future) Struct() (Conmon_setWindowSizeContainer_Results, error) {
	p, err := f.Future.Ptr()
	return Conmon_setWindowSizeContainer_Results(p.Struct()), err
}
func (p Conmon_setWindowSizeContainer_Results_Future) Response() Conmon_SetWindowSizeResponse_Future {
	return Conmon_SetWindowSizeResponse_Future{Future: p.Future.Field(0, nil)}
}

type Conmon_createNamespaces_Params capnp.Struct

// Conmon_createNamespaces_Params_TypeID is the unique identifier for the type Conmon_createNamespaces_Params.
const Conmon_createNamespaces_Params_TypeID = 0x8b4c03a0662a38dc

func NewConmon_createNamespaces_Params(s *capnp.Segment) (Conmon_createNamespaces_Params, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_createNamespaces_Params(st), err
}

func NewRootConmon_createNamespaces_Params(s *capnp.Segment) (Conmon_createNamespaces_Params, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_createNamespaces_Params(st), err
}

func ReadRootConmon_createNamespaces_Params(msg *capnp.Message) (Conmon_createNamespaces_Params, error) {
	root, err := msg.Root()
	return Conmon_createNamespaces_Params(root.Struct()), err
}

func (s Conmon_createNamespaces_Params) String() string {
	str, _ := text.Marshal(0x8b4c03a0662a38dc, capnp.Struct(s))
	return str
}

func (s Conmon_createNamespaces_Params) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Conmon_createNamespaces_Params) DecodeFromPtr(p capnp.Ptr) Conmon_createNamespaces_Params {
	return Conmon_createNamespaces_Params(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Conmon_createNamespaces_Params) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Conmon_createNamespaces_Params) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Conmon_createNamespaces_Params) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Conmon_createNamespaces_Params) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Conmon_createNamespaces_Params) Request() (Conmon_CreateNamespacesRequest, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return Conmon_CreateNamespacesRequest(p.Struct()), err
}

func (s Conmon_createNamespaces_Params) HasRequest() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Conmon_createNamespaces_Params) SetRequest(v Conmon_CreateNamespacesRequest) error {
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewRequest sets the request field to a newly
// allocated Conmon_CreateNamespacesRequest struct, preferring placement in s's segment.
func (s Conmon_createNamespaces_Params) NewRequest() (Conmon_CreateNamespacesRequest, error) {
	ss, err := NewConmon_CreateNamespacesRequest(capnp.Struct(s).Segment())
	if err != nil {
		return Conmon_CreateNamespacesRequest{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

// Conmon_createNamespaces_Params_List is a list of Conmon_createNamespaces_Params.
type Conmon_createNamespaces_Params_List = capnp.StructList[Conmon_createNamespaces_Params]

// NewConmon_createNamespaces_Params creates a new list of Conmon_createNamespaces_Params.
func NewConmon_createNamespaces_Params_List(s *capnp.Segment, sz int32) (Conmon_createNamespaces_Params_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return capnp.StructList[Conmon_createNamespaces_Params](l), err
}

// Conmon_createNamespaces_Params_Future is a wrapper for a Conmon_createNamespaces_Params promised by a client call.
type Conmon_createNamespaces_Params_Future struct{ *capnp.Future }

func (f Conmon_createNamespaces_Params_Future) Struct() (Conmon_createNamespaces_Params, error) {
	p, err := f.Future.Ptr()
	return Conmon_createNamespaces_Params(p.Struct()), err
}
func (p Conmon_createNamespaces_Params_Future) Request() Conmon_CreateNamespacesRequest_Future {
	return Conmon_CreateNamespacesRequest_Future{Future: p.Future.Field(0, nil)}
}

type Conmon_createNamespaces_Results capnp.Struct

// Conmon_createNamespaces_Results_TypeID is the unique identifier for the type Conmon_createNamespaces_Results.
const Conmon_createNamespaces_Results_TypeID = 0x8aef91973dc8a4f5

func NewConmon_createNamespaces_Results(s *capnp.Segment) (Conmon_createNamespaces_Results, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_createNamespaces_Results(st), err
}

func NewRootConmon_createNamespaces_Results(s *capnp.Segment) (Conmon_createNamespaces_Results, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1})
	return Conmon_createNamespaces_Results(st), err
}

func ReadRootConmon_createNamespaces_Results(msg *capnp.Message) (Conmon_createNamespaces_Results, error) {
	root, err := msg.Root()
	return Conmon_createNamespaces_Results(root.Struct()), err
}

func (s Conmon_createNamespaces_Results) String() string {
	str, _ := text.Marshal(0x8aef91973dc8a4f5, capnp.Struct(s))
	return str
}

func (s Conmon_createNamespaces_Results) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Conmon_createNamespaces_Results) DecodeFromPtr(p capnp.Ptr) Conmon_createNamespaces_Results {
	return Conmon_createNamespaces_Results(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Conmon_createNamespaces_Results) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Conmon_createNamespaces_Results) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Conmon_createNamespaces_Results) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Conmon_createNamespaces_Results) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Conmon_createNamespaces_Results) Response() (Conmon_CreateNamespacesResponse, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return Conmon_CreateNamespacesResponse(p.Struct()), err
}

func (s Conmon_createNamespaces_Results) HasResponse() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Conmon_createNamespaces_Results) SetResponse(v Conmon_CreateNamespacesResponse) error {
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewResponse sets the response field to a newly
// allocated Conmon_CreateNamespacesResponse struct, preferring placement in s's segment.
func (s Conmon_createNamespaces_Results) NewResponse() (Conmon_CreateNamespacesResponse, error) {
	ss, err := NewConmon_CreateNamespacesResponse(capnp.Struct(s).Segment())
	if err != nil {
		return Conmon_CreateNamespacesResponse{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

// Conmon_createNamespaces_Results_List is a list of Conmon_createNamespaces_Results.
type Conmon_createNamespaces_Results_List = capnp.StructList[Conmon_createNamespaces_Results]

// NewConmon_createNamespaces_Results creates a new list of Conmon_createNamespaces_Results.
func NewConmon_createNamespaces_Results_List(s *capnp.Segment, sz int32) (Conmon_createNamespaces_Results_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 1}, sz)
	return capnp.StructList[Conmon_createNamespaces_Results](l), err
}

// Conmon_createNamespaces_Results_Future is a wrapper for a Conmon_createNamespaces_Results promised by a client call.
type Conmon_createNamespaces_Results_Future struct{ *capnp.Future }

func (f Conmon_createNamespaces_Results_Future) Struct() (Conmon_createNamespaces_Results, error) {
	p, err := f.Future.Ptr()
	return Conmon_createNamespaces_Results(p.Struct()), err
}
func (p Conmon_createNamespaces_Results_Future) Response() Conmon_CreateNamespacesResponse_Future {
	return Conmon_CreateNamespacesResponse_Future{Future: p.Future.Field(0, nil)}
}

const schema_ffaaf7385bc4adad = "x\xda\xacX\x7fp\x14\xe5\xf9\x7f\x9ew\xef\xb2w\x98" +
	"p\xd9\xecE!#\xdf\xf8\xcd\xa0\x83A\xe4G\xb0b" +
	"\x06&\x09\x90\xa1X\xb4\xd9\x1cj\x0b\xea\xb0\xdc-\xc9" +
	"an\xf7\xb2\xbb'\x04K\x11\x95\xa9`\xb5\x85\xc2h" +
	"\x1c\x99\x81*\x8ePS\xb5\x8aU\xda\xdaAeT\x94" +
	"\xd6\xf0\x07\xadN\x7fYJ\x15\xa7\xa3u\xb4St\xb4" +
	"\xdby\xde\xbd\xfd\x91\xcb\x8d^\x92\xfeuw\xcf~\xee" +
	"y\xde}\xde\xe7\xfd<\x9f\xe7\x9d\xf3\xa9\xd8\x1e\x99[" +
	"\xf3\xebj`\xca\xeeh\x95c\xbd3`>\xbaw\xd9" +
	"\x9d \xcdD\x80(\x8a\x00-\x9dUM\x0cP\xbe\xa9" +
	"\xaa\x0d\xd0\xf9\xd7#\xaf.\xba\x7f\xe7\x87;\xc2\x80\xcd" +
	".`\x0f\x07\xfcaA\xf3\xba}\xc2\x8a{\xc2\x80\xe7" +
	"\xab\x1a\x080\xcc\x01\xdf]\x93\xd8\xfd\xa3\xf3Ws\x80" +
	"\xf3Q\xcb\xba?\x0e\xbew\xe5\xcf!\x1a!\xe0GU" +
	"\x0dL\x96D\x11@\xae\x11\xdf\x05t^\xff\xbfM7" +
	"$\x1e\xfd\xde\x03%`\xee\xf5\xffcML\xee\x88\x11" +
	"xQ\x8c<o;{\xed\xb3\xd7\xdd\xf9\xe1\xbep\xe8" +
	"\xfe\xd8<\x0a\xbd\x9d\x03\x06W\xbfwK\xe7\xf2\xc4\x8f" +
	"Gz\xe3\x91\x87b\xef\xa3\xfcZL\x04\xc19\xff\xb3" +
	"\xd3\x8f\x9cJ-8\x08\xcaL\x1c\x15\xf4\x00\xe1\x8e\xf2" +
	"\xa0\xbf\x8am\x00t\xa6?\xf1\xd2\xf0\x8e\x85\xb3\x0f\x85" +
	"\x83N\x8d\xd7Q\xd0\xb9q\x0a\xbaa\xcd\xabOlR" +
	"\xce<^&\xa8\x12?\x89r.NA\xe5\xa5s\x9e" +
	"?\xd5\xd2<T6\xe8r\xc2iq\x0a\xaa\xc6)\xe8" +
	"\xfc\xfdO?{\xdf\x07\x1b\x7fJhV\x8a>\x1a?" +
	"\x84\xf2[\xf1\x0b\x00\xe4w\xe2O\x00:\xb7\x0d\xbf\xff" +
	"\xd8}\xf7t\x1c.\xf5\xcd\x08=0\x891y\xcf$" +
	"\xf2\xbds\x12\xa5\xdc\x7f.M\x17\x9c\xa1\xa1\x97W/" +
	"\xf8\xf7!\x07\x00[\xb2\xe7\xad\xc2\x96\xcd\xe7]\x80\x14" +
	"\xa3\xfa\x15\x94q\xb2\x08\xe0\x1c\x7f\xf6`\xebg\xa77" +
	"\x1c)\xf5N\xcbm9[S\xc7\xe48\xe1Z\xa2\x93" +
	"\x0d\x06\xe8\xd4\xae\xfe\xed\xa2\x7f\xdc\xfc\xf7c\xe1|\xa1" +
	"\xc4\xebc\xaaD\xf9zW\xfd\x05\xeb<\xd1\xf7J\x18" +
	"\xb0H\xba\x9a\x00\xdfv\x01\x7f\xfb\xcf\xfa\x9e\xfc\xec7" +
	"\xc2\x80\x01\xe9$\x02\xca\xf7r\xc0\xb9\xfa\x17\xeeoX" +
	"x\xe47a\xc0\x90\x1b\xe2\x18\x074t\x0c\xcfO\xe8" +
	"\xcb\xde,\xa9*\x9e\x8f\xb3\xd2_Q\x8e\xd6Q>\xb0" +
	"\x8er\xfd\xf0\xc7\x8f\xad9\xbc3y\x0a\xa4\x99\xa1T" +
	"\x03\xb6\xa8u\x87P\x1e\xe0\xc8B\xdd\x16@\xe7\xf3m" +
	"\x0bo\x9f6\xed\xd4[e\xf3|\xb0\xae\x99\xc9\xafq" +
	"\xf4\xb1:\xca\xf3\x8337\xe4o^\xdb\xfa\xa7\x124" +
	"/\x8c\xfdr\x03\x93\x8f\xca\xbc\xcadZ\xf1\xe7\xad\x9f" +
	"\xbf\xb0oa\xfe\xcf\xa5\xae9\xfa\x1d\xf98\xca_\x10" +
	"\xba\xe5S\xb9\x11\x01\x9d\xeb\xf2\xcb\xa4K\xba'\xff%" +
	"\x9c\x81i\xf5\xdd\x94\x81\xab\xea\xc9\xdf\x9c\xdb\x96\x1d\xbc" +
	"9+\x9f\x0e\x03n\xaa\x7f\x9br\xd8\xcf\x01_\x93_" +
	"zR\xdf\xf9\xfe\x990`O}3y\x18\xe2\x80\xa3" +
	"\xab[\xba~w\xfa\x92\x7f\x82t\x05\x0b\xea\x11\xb0\xe5" +
	"D\xfdI\x94\xcf\xd6\xd3\xda\xcf\xd47\x02:\xc3\x1f4" +
	">\xfe\xfa\x99o|\\\xb6@\xce\xd4\xbf\x8d2\x9eO" +
	"_\xbf\xa8\xbf\x92\x0a\xe4\xd1\xfe\x87\x7fx\xaeI\xfa\xa4" +
	"\xb4\xb6\x05~b\xa641\xb9\x7f\x0a}\xcdM\xe1\xaf" +
	"\xfa\xdc\x83\xbb\x7f\xf0\xf2\xbce\x9f\x84\x17:8\x95\x9f" +
	"\xbf\xa7\xa6\xd2B\x7f\x89\x87\xce\xbbq\xfd{\xe7\xc2\x80" +
	"\xe1\xa9\xfcM\xcer\xc0\xb9\xfd?i\xb9\xfd\xc4\xd3\x9f" +
	"\x969\xa05\x0d\x93\x98<\xabA\x84\xd9N\xda\xd0s" +
	"\x86>\xcb\x14\xad\xd9i#\x973\xf4\xd9y\xd3\xb0\x8d" +
	"\xd9\xae\xfd\xf2\xb4\x9a\xd7\xf3\xadK\xdc\x1f\xdaF-\x9d" +
	"\x1a\xd0\xd3K\x0c\xddV\xb3\xbafN\xefRMQ\xcd" +
	"YJD\x88\x00D\x10@\xaaY\x0c\xa0\xc4\x04T\x92" +
	"\x0c\xb7\x98Z\x7fA\xb3l\xac\x0d\xde\x1e\x10k\x01\xc7" +
	"\x146mj\xaa\xad]\xab\xe64+\xaf\xa65kz" +
	"\xb7f\x15\xc4>{D\xd8\xab\x01\x94j\x01\x95)\x0c" +
	"\x1dS\xb3\xf2\x86ni\x00\x80\xb5\x01\xd7\xfe/Bw" +
	"\xa9\xa6*T\xf2\xc2~;\x18G\xd4%%Q\xbb\xc9" +
	"\xab`\xd9]\x88J\xad\x1fX\xa5W^#\xa0\xd2\xc7" +
	"PBL\"\x19\xb3\xab\x00\x94^\x01\x95\xbb\x18J\x8c" +
	"%\x91\x01H[\xd7\x02(\xb7\x0b\xa8<\xc4P\x12\x84" +
	"$\x0a\x00\xd2 \x19\x1f\x10Py\x86\xa1\x93\xd3l5" +
	"\xa3\xda*e\xac\x06\x18\xd6\x00:z1>\x08\x9a\x85" +
	"\x93\x01\xbb\x04\xc4D@\x1b\x80dt\x0a\xd9\xcc5j" +
	">\x9f\x05Q\xef\xf1a\xd5\xc0\xf8\xc3\x9e/{8\xb1" +
	"\x8cXyC\xd4-\x8dR\x12\xda\x8bU\xc5*\x98\xc1" +
	"\xca\xaf\xbf6\xe8\x82\xc5\xf5\x8fe\x15\xa6f\xe45}" +
	"\x85\xd1\x13\x1c\x80n\xad\xd1*T\\\x8a~\xa3.)" +
	"\x8a\xaa\x0a\x82w{\xc1\xe9\xdd\x13\x86\xfb\xeec\xf2\xe0" +
	"\xa7/\xecA\x89\xf9\x0b\xbf\xb4\x19@\x99.\xa02\x87" +
	"\xa1WO\xb3\xc86C@e>\xc3\x84=\x90\xd7J" +
	"J \x01\x98\xc8\xabv/\xdf\xd5\xea1\xe6S\xb5m" +
	"5\xdd;\x82M\xd4\x1cVp\xb8\xfc\xb61\x8e<v" +
	"\xf0\xa0\xdd\xee\xbe\xe0\x98\x93x\xbdfZYC\xe7G" +
	"\xd2B\xbb$\x83\x8b\xcbd\x90\xca\xe12\x01\x95\x05\x0c" +
	"\xb7\xdc\xaa\x99k\x0dKC\x04\x86\xc4\xf2\xe5\xce\x9d\xb7" +
	"\x9ah\x05\xabYa\xf4,5\x13\xd9[5S\x89`" +
	"\xb8yasb\xe5@^S\xaa\xfd\xb5u\xd2N\xb6" +
	"\x0b\xa8\xac\x08\xd6\xb6\x9clK\x05T\xba\x88-\xd0e" +
	"\x8bk\xe8%\xbe.\xa0\xb22\xd8r\xdfq\x99-\xdf" +
	"\x92S7\xa6\xb2\x9b4\x8c\x03\xc3\xf8\x18K \xa5\xd9" +
	"7d\xf5\x8c\xb1\x81<\xb8I\xb5\xa1\x84\xe7\x1a\x00\x94" +
	"\x1b\x05Tz\x83\x85k\xf3B\xdc\xe7-<\xdb\x0a\xa0" +
	"d\x04T\xf2Ds\xe8\xd2\\\x8e\xd2\xdf'\xa0\xb2\x91" +
	"\xa1\x90\xcdx\x8bn\xdc\x90\xcd\xd8\xbd(\x02C\x11\xb0" +
	"\xadW\xcb\xf6\xf4\xda\xde\xcf/\xdd\x96\xc8W\xbd\x95`" +
	"\xe8\xcaR\xc4@\xfaJ[7\x05bA\xdazG " +
	"-\xa5\xadG\x02\x8d!m\xeb\x0e\xc4\x93\xb4\xed\xc5\xa0" +
	"gJ\xdb\x8f\x07\"L\xday2\xa8\x7fi\xd0\x0c\x09" +
	"\xf1\xc1M!\x098\xb8#4\x17\xec\xdd\x15\xa8ei" +
	"\xff\xa1\x9068\xf0\xb3\xd0\xe4r\xf0\xc5\x90,\x1c\xea" +
	"\x0e\x8d)C\xc7\x03\xe6\x94\x0e\xefr\xbcc\x00m\xee" +
	"\x9e\xf9\x06\xc1#<\x97\xb2\xfd\xc3\xdd\xed\x01y\xc9f" +
	"o\xd5\x00M\xc7\xc3D=\x90\xf7\xe7\xceR\xa5\xe1\x95" +
	"\x068\xde#\x16zV<\xcb\x8ew\xb6\xa1\xd1\x8d\xe5" +
	"\xffns\xfd:\x1e\x89bO\xe00l\xf3\x1cye" +
	"\x89^]&\xb8\xbfR\xb3\xd5\xe8\xba\xf5\xda\x930\xa2" +
	"c[6x\x94\x8b\x01\x86\x8d\xe8a\xbc58\x01\xcc" +
	"_\x82r\xa1\x10\x05\xf0\x87\x02\xf4\x94\xad4\xbc\x18\x98" +
	"tL\xc4@\"\xa27\x18H\xcf\xdf\x01LzJD" +
	"\xe6\x0f\xbc\xe8\xc9D\xe9\xc0.`\xd2~\x11\x05\x7f\xb4" +
	"Cof\x91\xf6\xd0\xff\xee\x151\xe2\xebc\xf4\x86N" +
	"i\xeb\x83\xc0\xa4\xcd\"F\xfd\x09\x06=\x19.\xf5\x1f" +
	"\x01&\xe5D\xac\xf2\xc7c\xf4\x06iI\xdd\x01L\xba" +
	"I$\xca\xa3\xc2hG']\xdcm,\xee\x1b\xb4\xa3" +
	"\xe3IJ\xf4v\x13\xcdvt\xbc\xc6\x10F\x9a\xfe6" +
	"\x15\xa1\x82FPk\xc4\x96,1\xf46\xf7/~\xbc" +
	"kU\xf42\x0e\xd0\x8ea\xbe\xaf\\y\x94\xd4\xa1\xcb" +
	"\xfb\x97y\x14%_\x8c\x0d\x00\xa9\x8bP\xc0\xd4e\x18" +
	"\xa81\xf9R\\\x05\x90\x9aA\xf6\xf9\xc8\x10]=&" +
	"\xcf\xc5\xab\x01Rs\xc8\xbc\x10\x03\xae\x92\xaf\xc2y\x00" +
	"\xa9\xf9do'{\x84%1\x02 /\xc2n\x80\xd4" +
	"B\xb2\x7f\x8b\xecQ!\x89Q\x00\xf9:\\\x0f\x90Z" +
	"I\xf6<\xd9\xab\"I\xac\x02\x90s<l\x1f\xd9\xef" +
	"&\xbb\x18M\xd2x o\xe3\xf6\xbb\xc8\xbe\x8f\xec\xb1" +
	"\xaa$\xc6\x00\xe4\xbd\xdc\xfe\x10\xd9\x9f#{\\Lb" +
	"\x1c@>\x8ck\x01R\xcf\x90\xfdM\xb2O\x8a%q" +
	"\x12\x80|\x82\xaf\xff\x0d\xb2\xff\x1eG\xd0\xaa\xb3\xb6\xa0" +
	"g\xfa\xb4.\x15\x84\x90&\xb053\x97\xd5\xd5>\xa2" +
	"\xd3b\xe7k\xb4\xecLV\xf7\xfb\xa0\xb61kw\xa9" +
	"v/\xe0(\x99h\x18\xb9Nz\x0a\x09\xd5\xee\x1d\xf5" +
	"\xb4\xcfc\x13\xc1\x0c\x89\xbc\xd0\xdc\xe6\x8a\xbc>M\xd5" +
	"\x0b\xf9% \xe42\xa34j\x9f\xb1V\xed\xeb0A" +
	"('Qs9U\xcft\x80h\x8e~\xf8eMb" +
	"<\xea\x87\xa6\x9a>\xa1R)\xe9\xb3~\x89\x04\x8aU" +
	"\x10\xd9\x0a7\xdd\x12\xf9e\x01|\xb5\xfe\xf2{\xc98" +
	"\xf4W\x91\x0f*\x17{~\x1f\x1d\xf7\xfc6\xde\x1c\xfb" +
	"\xddxbr\xbd\xbf jV\xa9Rl\x08\x94\xa2T" +
	"N*\x86\x0f\xd5DU\"o/\x09\xa2@Z\x84+" +
	"\x96\xaeh\xa2\xb7\x92f\xd1\x07\x93.\xa6\x0fA\x9a\xd6" +
	"\x0c\x80\x11\xa9\xbe\x09@\xcc\xe6\xd3\xa2\xae\xd9b>\x9b" +
	"I\x14,\xcd\x14\x0b\xb65\xa6\xdc\x97\xe9\xe1\xa1\xb1\xa3" +
	"\xfc\x1c\xeb\x8f\xb1a)\xe7\xe9\xbb\\kq\xb6\xb5\x89" +
	"3/r\xf5]?\xfd;/\xa0\xf2\x1d\xe6\xd2\xc8\x12" +
	"#\xc3\xb7/\x02\x0c#\x80m\x96\x9d1\x0a\xb6\x977" +
	"\xfa\xa9\x99\xa6\x9fF;\x9b\xd32\xdf,\xd8!j\x9a" +
	"X{\xa0\xfa\x11F\xcd\xa5\xebC5\x96.\x82!a" +
	"ve3\x18\x03\x86\xb1q\xce0E\x09\xc3w\xd5\x0f" +
	"\xb6\x99Jkc\xf1\x0a\xc0K\xe8\xd6U\xc5+\x80\xef" +
	"\x87\xee\x05\xb6\x9b\x00\xca\xdd\x02*\xbb\x19b\xf1Z`" +
	"\xe7.\x00e\xb7\x80\xca>j@\x02o@\xd2^J" +
	"\xf2C\x02*\x8f\x8d,L\xcbH\xdf\xa2\xd9%l\xcf" +
	"[\xbafY\xd0\x985\xf4\xe5!\xb0m\xe4;\xd6\xd9" +
	"\x1a\x9a)\xe2\xfeN\x03\xd7U4\x07M\x80\xd1\xf8q" +
	"\xb7\xb1\xc2\xe3\xee\x8b\xe2\x09\xb0\xda\xd8\x08\xc6\x9f\x0a\xc6" +
	"Ame.#\xba\xd4\x84Y\xd1m\x9c?%\x8c\xe3" +
	"M=\xfdn^\xber \x8fn\xa1\xf3j\x8a\x9e\x04" +
	"\xf0\x8b\x9b\x99\xdd\x05\x9d\x0e\xd7r\xdd\xd6\xccu\\\x01" +
	"\x8fk\xcc\x0e\x9d\xa7\x19\xbe\xde\x8asA\x14#\x01\x92" +
	"D\x9f5d\x09\x17\x03\xa4\xaa\xc9<\x05\x03\xe2\x90\xeb" +
	"\xb1\x09 UK\xf6\x0b\xb9\xdeb\xae\xde\x9a\x8a\xad\x00" +
	"\xa9$\xd9/\xc2\xa0\xdc\xe5i\xdc\xfd\x85d\x9f\xc1\xf5" +
	"V\xc4\xd5[\x17s| \xf3\xaa\xa2\xae\xde\xba\x94\xeb" +
	"$_\xe6Ib\x95\xab\xb7\xe6r}\x16\xe8\xbc\x98\xe8" +
	"\xea\xad\xab\xb8\xff\x05d_\xca\xf5V\xcc\xd5[\x1d\\" +
	"W\xb5\x93}\x052t\xf2\xa6\x91\xd6,k9\xa0O" +
	"\x13\x9e\x9c\xf6N\x95h\xab=\xde\xf76\xcaj\xd6\x0e" +
	"i\xb1l_f\xa9j\x03j>\xc4V\xcd\x1e-\x80" +
	"\x98\x05\xcb\xa6T\x83\x18\xf2\xe9\xa4U\xb3\xc7\xb8^3" +
	"!a\x8d2\xaf4\xb5\x90\xbf\x09\x8b\xa0\xb2\x83\x9e\xd7" +
	".\xcbsZyJ+\xf6\x88\xedT\xf0w\x15\xe9K" +
	"hw9-L_\x9e\xa8\x96\x0e\x90\xf1\x11\x01\x95'" +
	"Gr\x1a\x15\xadQ\xb0S hi\xefJcKQ" +
	"\x08\x96J\xc02\xc2v\xc2\x19)\x95,\x15\xeb$\xff" +
	"Va\x1cd2\xfaf\xbf[\xb3\x12\x95_l\xfa\xb7" +
	"\x13\xe3\x88]r\x05\xe4\xb9\xedB\xfco\x00\x00\x00\xff" +
	"\xff\x0d\x13v\xb5"

func init() {
	schemas.Register(schema_ffaaf7385bc4adad,
		0x83479da67279e173,
		0x8aef91973dc8a4f5,
		0x8b4c03a0662a38dc,
		0x8b5b1693940f607e,
		0x9887a60f577a1ecb,
		0xa0ef8355b64ee985,
		0xa20f49456be85b99,
		0xa93853d6a4e3fa16,
		0xaa2f3c8ad1c3af24,
		0xace5517aafc86077,
		0xad2a33d6b9304413,
		0xae78ee8eb6b3a134,
		0xb5418b8ea8ead17b,
		0xb737e899dd6633f1,
		0xba77e3fa3aa9b6ca,
		0xc5e65eec3dcf5b10,
		0xc76ccd4502bb61e7,
		0xcc2f70676afee4e7,
		0xceba3c1a97be15f8,
		0xd0476e0f34d1411a,
		0xd61491b560a8f3a3,
		0xd9d61d1d803c85fc,
		0xde3a625e70772b9a,
		0xdf703ca0befc3afc,
		0xe00e522611477055,
		0xe313695ea9477b30,
		0xe5ea916eb0c31336,
		0xf026e3d750335bc1,
		0xf34be5cbac1feed1,
		0xf41122f890a371a6,
		0xf44732c48f949ab8,
		0xf8e86a5c0baa01bc,
		0xf9b3cd8033aba1f8)
}
