#!/bin/bash

# v0.4 created by sc0ttman, August 2010
# GPL license /usr/share/doc/legal/gpl-2.0.txt
# zenity version by lagopus for antiX, December 2010
# modified to yad by Dave for antiX, September 2011
# modified back to zenity for Peppermint, Jan 2016
# fix update URL to mvps
# translated and forked by evilware666, December 2024

TEXTDOMAINDIR=/usr/share/locale
TEXTDOMAIN=block-advert.sh

export title="GuideOS Werbeblocker"

# the markers used to find the changes in /etc/hosts, which are made by this app
export markerstart='# BEGIN (below) - IPs added by GuideOS Werbe-Blocker #'
export markerend='# END (above) - IPs added by GuideOS Werbe-Blocker #'

info_text=$"Das <b>$title</b>-Tool fügt Blocklisten zu Ihrer /etc/hosts-Datei hinzu, sodass \n\
viele Werbeserver und Websites nicht mehr auf diesen PC zugreifen können.\n\n\
<b>Vorteile:</b> \n- Schutz Ihrer Privatsphäre\n- Einsparung von Bandbreite\n- Verbesserte Geschwindigkeit beim Surfen\n- Weniger störende Werbung\n\n\
<b>Wichtige Hinweise:</b> \nDas Blockieren von Servern kann zu folgenden Problemen führen:\n- Einige Webseiten werden möglicherweise nicht korrekt geladen.\n- Bestimmte Funktionen auf Webseiten könnten eingeschränkt sein.\n- Die Pflege der hosts-Datei erfordert regelmäßige Updates.\n\n\
<b>Bitte fahren Sie nur fort, wenn Sie sich der Risiken bewusst sind. Alle Änderungen können mit UNBLOCK rückgängig gemacht werden.</b>\n\nMöchten Sie fortfahren?"

# width of progress dialogs
WIDTH=360

# cleanup all leftover files
function cleanup
{
    # remove all temp files
    rm -f /tmp/adlist{1,2,3,4,5} /tmp/adlist-all /tmp/hosts-temp
}

# concatenate the downloaded files
# clean out everything but the list of IPs and servers
function build_adlist_all
{
    cat /tmp/adlist{1,2,3,4,5} | sed '/^#/d' | \
                               sed '/^$/d' | \
                               sed 's/[\t]/ /g' | \
                               sed 's/  / /g' | \
                               sed -n '/^[0-9]/p' | \
                               tr -d '\015' | \
                               sort -u -k 2 \
                               > /tmp/adlist-all
}

# append the list to the /etc/hosts
function append_adlist
{
    sed -e "/$markerstart/,/$markerend/d" /etc/hosts > /tmp/hosts-temp
    sed -i -e "/$markerstart/d" /tmp/hosts-temp
    sed -i -e "/$markerend/d" /tmp/hosts-temp
    
    size=$(stat -c%s /tmp/adlist-all 2>/dev/null)
    if [ -n "$size" ] && [ "$size" -gt "0" ]; then
        echo "$markerstart" >> /tmp/hosts-temp
        cat /tmp/adlist-all >> /tmp/hosts-temp
        echo "$markerend"   >> /tmp/hosts-temp
    else
        zenity --question --width "200" --title "$title" --text=$"Möchten Sie die ursprüngliche hosts-Datei wiederherstellen?" \
               --ok-label="Ja" --cancel-label="Nein"
        exit 1
    fi

    if [ -f /etc/hosts.ORIGINAL ]; then
        cp "/etc/hosts" "/etc/hosts.saved"
        mv "/tmp/hosts-temp" "/etc/hosts"
    else
        cp "/etc/hosts" "/etc/hosts.ORIGINAL"
        cp "/etc/hosts" "/etc/hosts.saved"
        mv "/tmp/hosts-temp" "/etc/hosts"
    fi
}

function success
{
    zenity --info --width 320 --title "$title" --text=$"Erfolg - Ihre Einstellungen wurden geändert.\n\n\
Ihre Hosts-Datei wurde aktualisiert.\n\
Starten Sie Ihren Browser neu, um die Änderungen zu sehen." --no-wrap \
           --ok-label="OK"
}

# usage: wget_dialog url file
function wget_dialog
{
    url=$1
    domain=$(echo "$url" | cut -d/ -f3)
    wget -c -4 -t 20 -T 10 --progress=dot -O $2 "$1" 2>&1 | \
        awk '{print $7}; system("")' | sed -u 's/%//' | \
        zenity --title "$title" --progress --width $WIDTH \
               --text=$"Lade Blockliste von $domain" \
               --percentage=0 \
               --auto-close
}

# download the ads lists
function download_adlist
{
    if [ "$mvps" = true ]; then
        wget_dialog http://winhelp2002.mvps.org/hosts.txt /tmp/adlist1
    fi
    sed -i 's/0.0.0.0/127.0.0.1/' /tmp/adlist1
    sed -i 's/ #.*$//' /tmp/adlist1

    if [ "$sysctl" = true ]; then
        wget_dialog http://sysctl.org/cameleon/hosts /tmp/adlist2
    fi

    if [ "$someonewhocares" = true ]; then
        wget_dialog http://someonewhocares.org/hosts/hosts /tmp/adlist3
    fi

    if [ "$yoyo" = true ]; then
        wget_dialog 'http://pgl.yoyo.org/as/serverlist.php?hostformat=hosts&showintro=0&mimetype=plaintext' /tmp/adlist4
    fi

    if [ "$adservers" = true ]; then
        wget_dialog http://hosts-file.net/ad_servers.asp /tmp/adlist5
    fi

    if [ "$unblock" = true ]; then
        zenity --warning --width "$WIDTH" --title "$title" \
               --text=$"Sie haben die Option UNBLOCK gewählt. Alle Änderungen werden rückgängig gemacht.\n\n\
Ihre ursprüngliche hosts-Datei wird wiederhergestellt, und Werbeblocker werden deaktiviert." \
               --ok-label="OK"
        mv -f "/etc/hosts.ORIGINAL" "/etc/hosts"
        rm -f "/etc/hosts.saved"
    fi

    touch /tmp/adlist{1,2,3,4,5}
}

zenity --question --title "$title" --width "$WIDTH" \
       --ok-label="Ja" --cancel-label="Nein" \
       --text "$info_text" --no-wrap
rsp=$?

if [ $rsp != 0 ]; then
    exit 0
fi

ans=$(zenity --list --title "$title" \
             --width "$WIDTH" --height 400 \
             --list --separator=":" \
             --text $"Wählen Sie den gewünschten Ad-Block-Service aus.\n\nKurze Beschreibung:\n- mvps.org: Blockiert bekannte Werbeserver\n- sysctl.org: Konzentriert sich auf Malware und Tracking\n- someonewhocares.org: Für allgemeine Werbeblocker\n- yoyo.org: Umfassender Schutz vor Werbung\n- adservers.org: Zielgerichtete Adserver-Blockierung\n- UNBLOCK: Hebt alle Blockierungen auf und stellt die Originaldatei wieder her." \
             --checklist --column "Wählen" --column "Service" \
             FALSE "mvps.org" \
             FALSE "sysctl.org" \
             FALSE "someonewhocares.org" \
             FALSE "yoyo.org" \
             FALSE "adservers.org" \
             FALSE "UNBLOCK" \
             --ok-label="OK" --cancel-label="Abbrechen")

arr=$(echo $ans | tr ":" "\n")

for x in $arr; do
    case $x in
    mvps.org) mvps=true ;;
    sysctl.org) sysctl=true ;;
    someonewhocares.org) someonewhocares=true ;;
    yoyo.org) yoyo=true ;;
    adservers.org) adservers=true ;;
    UNBLOCK) unblock=true ;;
    esac
done

cleanup
download_adlist
build_adlist_all
append_adlist
cleanup
