#pragma once

#define FASTFETCH_DATATEXT_JSON_HELP "{\"Informative\":[{\"short\":\"h\",\"long\":\"help\",\"desc\":\"Show this message, or help for a specific command\",\"arg\":{\"type\":\"command\",\"optional\":true}},{\"short\":\"v\",\"long\":\"version\",\"desc\":\"Show the full version of fastfetch\"},{\"long\":\"version-raw\",\"desc\":\"Show the raw version string (major.minor.patch)\"},{\"long\":\"list-config-paths\",\"desc\":\"List search paths of config files\"},{\"long\":\"list-data-paths\",\"desc\":\"List search paths of presets and logos\"},{\"long\":\"list-logos\",\"desc\":\"List available logos\"},{\"long\":\"list-modules\",\"desc\":\"List available modules\"},{\"long\":\"list-presets\",\"desc\":\"List presets fastfetch knows about\",\"remark\":\"Presets can be loaded with \\\"--config <preset-name>\\\"\"},{\"long\":\"list-features\",\"desc\":\"List the supported features fastfetch was compiled with\",\"remark\":\"Mainly for development\"},{\"long\":\"print-logos\",\"desc\":\"Print available logos\"},{\"long\":\"print-structure\",\"desc\":\"Print the default structure\"},{\"long\":\"format\",\"desc\":\"Set output format\",\"arg\":{\"type\":\"enum\",\"enum\":{\"default\":\"Default format\",\"json\":\"JSON format\"},\"default\":\"default\"}}],\"Config\":[{\"short\":\"c\",\"long\":\"config\",\"desc\":\"Specify the config file or preset to be loaded\",\"remark\":\"The file will be searched in the order of \\\"fastfetch --list-config-paths\\\". If \\\"none\\\", disable further config loading. See also https://github.com/fastfetch-cli/fastfetch/wiki/Configuration for more info\",\"arg\":{\"type\":\"config\"}},{\"long\":\"gen-config\",\"desc\":\"Generate a config file to specified path with options specified in the command line (if any)\",\"remark\":\"Defaults to \\\"~/.config/fastfetch/config.jsonc\\\". Will Print the generated config if <path> is \\\"-\\\"\",\"arg\":{\"type\":\"path\",\"optional\":true}},{\"long\":\"gen-config-force\",\"desc\":\"Generate a config file to specified path. Overwrite the existing one\",\"remark\":\"Defaults to \\\"~/.config/fastfetch/config.jsonc\\\"\",\"arg\":{\"type\":\"path\",\"optional\":true}}],\"General\":[{\"long\":\"thread\",\"desc\":\"Use separate threads to send HTTP requests\",\"arg\":{\"type\":\"bool\",\"optional\":true,\"default\":true}},{\"long\":\"escape-bedrock\",\"desc\":\"On Bedrock Linux, whether to escape the bedrock jail\",\"remark\":\"Linux only\",\"arg\":{\"type\":\"bool\",\"optional\":true,\"default\":true}},{\"long\":\"wmi-timeout\",\"desc\":\"Set the timeout (ms) for WMI queries\",\"remark\":\"Windows only\",\"arg\":{\"type\":\"num\",\"default\":5000}},{\"long\":\"processing-timeout\",\"desc\":\"Set the timeout (ms) when waiting for child processes\",\"arg\":{\"type\":\"num\",\"default\":5000}},{\"long\":\"ds-force-drm\",\"desc\":\"Set if only DRM should be used to detect displays\",\"remark\":[\"Use this option if you encountered problems with other detection method.\",\"Linux only\"],\"arg\":{\"type\":\"enum\",\"optional\":true,\"default\":\"false\",\"enum\":{\"true\":\"Try `libdrm` first, then `sysfs` if libdrm failed\",\"sysfs-only\":\"Use `/sys/class/drm` only\",\"false\":\"Try `wayland`, then `x11`, then `drm`\"}}},{\"long\":\"detect-version\",\"desc\":\"Whether to detect and display the version of terminal, shell and editor\",\"remark\":\"Mainly for benchmarking\",\"arg\":{\"type\":\"bool\",\"optional\":true,\"default\":true}}],\"Logo\":[{\"short\":\"l\",\"long\":\"logo\",\"desc\":\"Set the logo source. Use \\\"none\\\" to disable the logo\",\"remark\":\"Should be the name of a builtin logo, or a path to an image file. See also https://github.com/fastfetch-cli/fastfetch/wiki/Logo-options\",\"arg\":{\"type\":\"logo\"}},{\"long\":\"logo-type\",\"desc\":\"Set the type of the logo given in \\\"--logo\\\"\",\"remark\":\"See also https://github.com/fastfetch-cli/fastfetch/wiki/Logo-options\",\"arg\":{\"type\":\"enum\",\"enum\":{\"auto\":\"If something is given, first try builtin, then file. Otherwise detect logo\",\"builtin\":\"Builtin ascii art\",\"small\":\"Builtin ascii art, small version\",\"file\":\"Text file, printed with color code replacement\",\"file-raw\":\"Text file, printed as is\",\"data\":\"Text data, printed with color code replacement\",\"data-raw\":\"Text data, printed as is\",\"sixel\":\"Image file, printed as sixel codes\",\"kitty\":\"Image file, printed as kitty graphics protocol\",\"kitty-direct\":\"Image file, tell the terminal emulator to read image data from the specified file (Supported by kitty and wezterm)\",\"kitty-icat\":\"Image file, use `kitten icat` to display the image. Requires binary `kitten` to be installed\",\"iterm\":\"Image file, printed as iterm graphics protocol\",\"chafa\":\"Image file, printed as ascii art using libchafa\",\"raw\":\"Image file, printed as raw binary string\",\"none\":\"Disable logo printing\"}}},{\"long\":\"logo-width\",\"desc\":\"Set the width of the logo (in characters), if it is an image\",\"remark\":\"Required for iTerm image protocol\",\"arg\":{\"type\":\"num\"}},{\"long\":\"logo-height\",\"desc\":\"Set the height of the logo (in characters), if it is an image\",\"remark\":\"Required for iTerm image protocol\",\"arg\":{\"type\":\"num\"}},{\"long\":\"logo-preserve-aspect-ratio\",\"desc\":\"Set if the logo should fill the specified width and height as much as possible without stretching\",\"remark\":\"Supported by iTerm image protocol only\",\"arg\":{\"type\":\"bool\",\"optional\":true,\"default\":false}},{\"long\":\"logo-color-[1-9]\",\"desc\":\"Overwrite a color in the logo\",\"remark\":\"See `-h color` for the list of available colors\",\"arg\":{\"type\":\"color\"},\"pseudo\":true},{\"long\":\"logo-padding\",\"desc\":\"Set the padding on the left and the right of the logo\",\"arg\":{\"type\":\"num\"}},{\"long\":\"logo-padding-left\",\"desc\":\"Set the padding on the left of the logo\",\"arg\":{\"type\":\"num\"}},{\"long\":\"logo-padding-right\",\"desc\":\"Set the padding on the right of the logo\",\"arg\":{\"type\":\"num\"}},{\"long\":\"logo-padding-top\",\"desc\":\"Set the padding on the top of the logo\",\"arg\":{\"type\":\"num\"}},{\"long\":\"logo-print-remaining\",\"desc\":\"Whether to print the remaining logo, if it has more lines than modules to display\",\"arg\":{\"type\":\"bool\",\"optional\":true,\"default\":true}},{\"long\":\"logo-position\",\"desc\":\"Set the position of the logo should be displayed\",\"arg\":{\"type\":\"enum\",\"enum\":{\"left\":\"Left\",\"top\":\"Top\",\"right\":\"Right\"}}},{\"long\":\"logo-recache\",\"desc\":\"If true, regenerate image logo cache\",\"arg\":{\"type\":\"bool\",\"optional\":true,\"default\":false}},{\"long\":\"file\",\"desc\":\"Short for --logo-type file --logo <path>\",\"remark\":\"See \\\"--help logo-type\\\" for more info\",\"arg\":{\"type\":\"path\"}},{\"long\":\"file-raw\",\"desc\":\"Short for --logo-type file-raw --logo <path>\",\"remark\":\"See \\\"--help logo-type\\\" for more info\",\"arg\":{\"type\":\"path\"}},{\"long\":\"data\",\"desc\":\"Short for --logo-type data --logo <data>\",\"remark\":\"See \\\"--help logo-type\\\" for more info\",\"arg\":{\"type\":\"data\"}},{\"long\":\"data-raw\",\"desc\":\"Short for --logo-type data-raw --logo <data>\",\"remark\":\"See \\\"--help logo-type\\\" for more info\",\"arg\":{\"type\":\"data\"}},{\"long\":\"raw\",\"desc\":\"Short for --logo-type raw --logo <path>\",\"remark\":\"See \\\"--help logo-type\\\" for more info\",\"arg\":{\"type\":\"path\"}},{\"long\":\"sixel\",\"desc\":\"Short for --logo-type sixel --logo <path>\",\"remark\":\"See \\\"--help logo-type\\\" for more info\",\"arg\":{\"type\":\"path\"}},{\"long\":\"kitty\",\"desc\":\"Short for --logo-type kitty --logo <path>\",\"remark\":\"See \\\"--help logo-type\\\" for more info\",\"arg\":{\"type\":\"path\"}},{\"long\":\"kitty-direct\",\"desc\":\"Short for --logo-type kitty-direct --logo <path>\",\"remark\":\"See \\\"--help logo-type\\\" for more info\",\"arg\":{\"type\":\"path\"}},{\"long\":\"kitty-icat\",\"desc\":\"Short for --logo-type kitty-icat --logo <path>\",\"remark\":\"See \\\"--help logo-type\\\" for more info\",\"arg\":{\"type\":\"path\"}},{\"long\":\"iterm\",\"desc\":\"Short for --logo-type iterm --logo <path>\",\"remark\":\"See \\\"--help logo-type\\\" for more info\",\"arg\":{\"type\":\"path\"}},{\"long\":\"chafa\",\"desc\":\"Short for --logo-type chafa --logo <path>\",\"remark\":\"See \\\"--help logo-type\\\" for more info\",\"arg\":{\"type\":\"path\"}},{\"long\":\"chafa-fg-only\",\"desc\":\"Produce character-cell output using foreground colors only\",\"remark\":\"See chafa document for detail\",\"arg\":{\"type\":\"bool\",\"optional\":true,\"default\":false}},{\"long\":\"chafa-symbols\",\"desc\":\"Specify character symbols to employ in final output\",\"remark\":\"See chafa document for detail\",\"arg\":{\"type\":\"str\"}},{\"long\":\"chafa-canvas-mode\",\"desc\":\"Determine how colors are used in the output\",\"remark\":\"This value maps the int value of enum ChafaCanvasMode. See chafa document for detail\",\"arg\":{\"type\":\"enum\",\"enum\":{\"TRUECOLOR\":\"Truecolor\",\"INDEXED_256\":\"256 colors\",\"INDEXED_240\":\"256 colors, but avoid using the lower 16 whose values vary between terminal environments\",\"INDEXED_16\":\"16 colors using the aixterm ANSI extension\",\"FGBG_BGFG\":\"Default foreground and background colors, plus inversion\",\"FGBG\":\"Default foreground and background colors. No ANSI codes will be used\",\"INDEXED_8\":\"8 colors, compatible with original ANSI X3.64\",\"INDEXED_16_8\":\"16 FG colors (8 of which enabled with bold/bright) and 8 BG colors\"}}},{\"long\":\"chafa-color-space\",\"desc\":\"Set color space used for quantization\",\"remark\":\"This value maps the int value of enum ChafaColorSpace. See chafa document for detail\",\"arg\":{\"type\":\"enum\",\"enum\":{\"RGB\":\"RGB color space. Fast but imprecise\",\"DIN99D\":\"DIN99d color space. Slower, but good perceptual color precision\"}}},{\"long\":\"chafa-dither-mode\",\"desc\":\"Set output dither mode (No effect with 24-bit color)\",\"remark\":\"This value maps the int value of enum ChafaDitherMode. See chafa document for detail\",\"arg\":{\"type\":\"enum\",\"enum\":{\"NONE\":\"No dithering\",\"ORDERED\":\"Ordered dithering (Bayer or similar)\",\"DIFFUSION\":\"Error diffusion dithering (Floyd-Steinberg or similar)\"}}}],\"Display\":[{\"short\":\"s\",\"long\":\"structure\",\"desc\":\"Set the structure of the fetch\",\"remark\":\"Must be a colon separated list of keys. Use \\\"fastfetch --list-modules\\\" to see the ones available\",\"arg\":{\"type\":\"structure\",\"default\":\"\\\"fastfetch --print-structure\\\"\"}},{\"long\":\"stat\",\"desc\":\"Show time usage (in ms) for individual modules\",\"arg\":{\"type\":\"bool\",\"optional\":true,\"default\":false}},{\"long\":\"pipe\",\"desc\":\"Disable colors\",\"remark\":\"Auto detection based on isatty(1)\",\"arg\":{\"type\":\"bool\",\"optional\":true}},{\"long\":\"color-keys\",\"desc\":\"Set the color of the keys\",\"remark\":\"Doesn't affect module Title, Separator and Colors. See `-h color` for the list of available colors\",\"arg\":{\"type\":\"color\"}},{\"long\":\"color-title\",\"desc\":\"Set the color of the title\",\"remark\":\"See `-h color` for the list of available colors\",\"arg\":{\"type\":\"color\"}},{\"long\":\"color-output\",\"desc\":\"Set the color of module output\",\"remark\":\"See `-h color` for the list of available colors\",\"arg\":{\"type\":\"color\"}},{\"long\":\"color-separator\",\"desc\":\"Set the color of the key-value separator\",\"remark\":\"See `-h color` for the list of available colors\",\"arg\":{\"type\":\"color\"}},{\"long\":\"color\",\"desc\":\"Set the color of both the keys and title\",\"remark\":\"Shortcut of \\\"--color-keys <color>\\\" and \\\"--color-title <color>\\\"\",\"arg\":{\"type\":\"color\"}},{\"long\":\"key-width\",\"desc\":\"Align the width of keys to <num> characters\",\"arg\":{\"type\":\"num\"}},{\"long\":\"key-padding-left\",\"desc\":\"Set the left padding of keys to <num> characters\",\"arg\":{\"type\":\"num\"}},{\"long\":\"key-type\",\"desc\":\"Set whether to show icon before string keys\",\"arg\":{\"type\":\"enum\",\"enum\":{\"none\":\"Disable keys\",\"string\":\"Show string\",\"icon\":\"Show icon (requires newest nerd font)\",\"both\":\"Show both icon and string\"},\"default\":\"string\"}},{\"long\":\"bright-color\",\"desc\":\"Set if the keys, title and ASCII logo should be printed in bright color\",\"arg\":{\"type\":\"bool\",\"optional\":true,\"default\":true}},{\"long\":\"separator\",\"desc\":\"Set the separator between key and value\",\"arg\":{\"type\":\"str\",\"default\":\": \"}},{\"long\":\"show-errors\",\"desc\":\"Print occurring errors\",\"arg\":{\"type\":\"bool\",\"optional\":true,\"default\":false}},{\"long\":\"disable-linewrap\",\"desc\":\"Whether to disable line wrap during the run\",\"arg\":{\"type\":\"bool\",\"optional\":true,\"default\":true}},{\"long\":\"hide-cursor\",\"desc\":\"Whether to hide the cursor during the run\",\"arg\":{\"type\":\"bool\",\"optional\":true,\"default\":false}},{\"long\":\"percent-type\",\"desc\":\"Set the percentage output type\",\"remark\":[\"1 for percentage number\",\"2 for multi-color bar\",\"3 for both\",\"6 for bar only\",\"9 for colored number\",\"10 for monochrome bar\"],\"arg\":{\"type\":\"num\",\"default\":9}},{\"long\":\"percent-ndigits\",\"desc\":\"Set the number of digits to keep after the decimal point when formatting percentage numbers\",\"arg\":{\"type\":\"num\",\"default\":0}},{\"long\":\"percent-color-green\",\"desc\":\"Set color used in green state of percentage bars and numbers\",\"remark\":\"See `-h color` for the list of available colors\",\"arg\":{\"type\":\"color\",\"default\":\"green\"}},{\"long\":\"percent-color-yellow\",\"desc\":\"Set color used in yellow state of percentage bars and numbers\",\"remark\":\"See `-h color` for the list of available colors\",\"arg\":{\"type\":\"color\",\"default\":\"light_yellow\"}},{\"long\":\"percent-color-red\",\"desc\":\"Set color used in red state of percentage bars and numbers\",\"remark\":\"See `-h color` for the list of available colors\",\"arg\":{\"type\":\"color\",\"default\":\"light_red\"}},{\"long\":\"bar-char-elapsed\",\"desc\":\"Set the character to use in elapsed part of percentage bars\",\"arg\":{\"type\":\"str\",\"default\":\"\\u25a0\"}},{\"long\":\"bar-char-total\",\"desc\":\"Set the character to use in total part of percentage bars\",\"arg\":{\"type\":\"str\",\"default\":\"-\"}},{\"long\":\"bar-border-left\",\"desc\":\"Set the string to use at left border of percentage bars\",\"arg\":{\"type\":\"string\",\"default\":\"[ \"}},{\"long\":\"bar-border-right\",\"desc\":\"Set the string to use at right border of percentage bars\",\"arg\":{\"type\":\"string\",\"default\":\" ]\"}},{\"long\":\"bar-width\",\"desc\":\"Set the width of percentage bars, in number of characters\",\"arg\":{\"type\":\"num\",\"default\":10}},{\"long\":\"no-buffer\",\"desc\":\"Set if the stdout application buffer should be disabled\",\"arg\":{\"type\":\"bool\",\"optional\":true,\"default\":false}},{\"long\":\"size-ndigits\",\"desc\":\"Set the number of digits to keep after the decimal point when formatting sizes\",\"arg\":{\"type\":\"num\"}},{\"long\":\"size-binary-prefix\",\"desc\":\"Set the binary prefix to used when formatting sizes\",\"arg\":{\"type\":\"enum\",\"enum\":{\"IEC\":\"1024 Bytes = 1 KiB, 1024 KiB = 1 MiB, ...\",\"SI\":\"1000 Bytes = 1 KB, 1000 KB = 1 MB, ...\",\"JEDEC\":\"1024 Bytes = 1 kB, 1024 kB = 1 MB, ...\"},\"default\":\"IEC\"}},{\"long\":\"size-max-prefix\",\"desc\":\"Set the largest binary prefix to use when formatting sizes\",\"arg\":{\"type\":\"enum\",\"enum\":{\"B\":\"Bytes\",\"kB\":\"KiB\",\"MB\":\"MiB\",\"GB\":\"GiB\",\"TB\":\"TiB\",\"PB\":\"PiB\",\"EB\":\"EiB\",\"ZB\":\"ZiB\",\"YB\":\"YiB\"},\"default\":\"YB\"}},{\"long\":\"freq-ndigits\",\"desc\":\"Set the number of digits to keep after the decimal point when printing CPU / GPU frequency in GHz\",\"arg\":{\"type\":\"num\",\"default\":2}},{\"long\":\"temp-unit\",\"desc\":\"Set the unit of the temperature\",\"arg\":{\"type\":\"enum\",\"enum\":{\"C\":\"Celsius\",\"F\":\"Fahrenheit\",\"K\":\"Kelvin\"},\"default\":\"C\"}},{\"long\":\"temp-ndigits\",\"desc\":\"Set the number of digits to keep after the decimal point when printing temperature\",\"arg\":{\"type\":\"num\",\"default\":2}},{\"long\":\"temp-color-green\",\"desc\":\"Set color used in green state of temperature values\",\"remark\":\"See `-h color` for the list of available colors\",\"arg\":{\"type\":\"color\",\"default\":\"green\"}},{\"long\":\"temp-color-yellow\",\"desc\":\"Set color used in yellow state of temperature values\",\"remark\":\"See `-h color` for the list of available colors\",\"arg\":{\"type\":\"color\",\"default\":\"light_yellow\"}},{\"long\":\"temp-color-red\",\"desc\":\"Set color used in red state of temperature values\",\"remark\":\"See `-h color` for the list of available colors\",\"arg\":{\"type\":\"color\",\"default\":\"light_red\"}}],\"Module specific\":[{\"long\":\"title-fqdn\",\"desc\":\"Set if the title should use fully qualified domain name\",\"arg\":{\"type\":\"bool\",\"optional\":true,\"default\":false}},{\"long\":\"title-color-user\",\"desc\":\"Set color of the user name (left part)\",\"remark\":\"See `-h color` for the list of available colors\",\"arg\":{\"type\":\"color\",\"default\":\"Use color of \\\"--color-title\\\"\"}},{\"long\":\"title-color-at\",\"desc\":\"Set color of the @ symbol (middle part)\",\"remark\":\"See `-h color` for the list of available colors\",\"arg\":{\"type\":\"color\",\"default\":\"Use color of \\\"--color-title\\\"\"}},{\"long\":\"title-color-host\",\"desc\":\"Set color of the host name (right part)\",\"remark\":\"See `-h color` for the list of available colors\",\"arg\":{\"type\":\"color\",\"default\":\"default\"}},{\"long\":\"separator-string\",\"desc\":\"Set the string to be printed by the separator line\",\"arg\":{\"type\":\"str\",\"default\":\"-\"}},{\"long\":\"separator-output-color\",\"desc\":\"Set the color of the separator line\",\"arg\":{\"type\":\"color\",\"default\":\"default\"}},{\"long\":\"separator-length\",\"desc\":\"Set the length of the separator line\",\"remark\":\"Set to 0 to automatically calculate it with the title length\",\"arg\":{\"type\":\"num\",\"default\":\"0\"}},{\"long\":\"disk-folders\",\"desc\":\"A colon (semicolon on Windows) separated list of folder paths to be detected\",\"remark\":\"On Windows, a drive latter must be upper cased and end with \\\"\\\\\\\". \\\"/\\\" is used as an alias of the system drive. This option overrides other disk-show-* options\",\"arg\":{\"type\":\"path\",\"default\":\"Auto detection using mount-points\"}},{\"long\":\"disk-show-regular\",\"desc\":\"Set if regular volume should be printed\",\"arg\":{\"type\":\"bool\",\"optional\":true,\"default\":true}},{\"long\":\"disk-show-external\",\"desc\":\"Set if external volume should be printed\",\"arg\":{\"type\":\"bool\",\"optional\":true,\"default\":true}},{\"long\":\"disk-show-hidden\",\"desc\":\"Set if hidden volumes should be printed\",\"arg\":{\"type\":\"bool\",\"optional\":true,\"default\":false}},{\"long\":\"disk-show-subvolumes\",\"desc\":\"Set if subvolumes should be printed\",\"arg\":{\"type\":\"bool\",\"optional\":true,\"default\":false}},{\"long\":\"disk-show-readonly\",\"desc\":\"Set if read only volumes should be printed\",\"arg\":{\"type\":\"bool\",\"optional\":true,\"default\":true}},{\"long\":\"disk-show-unknown\",\"desc\":\"Set if unknown (unable to detect sizes) volumes should be printed\",\"arg\":{\"type\":\"bool\",\"optional\":true,\"default\":false}},{\"long\":\"disk-use-available\",\"desc\":\"Use f_bavail (lpFreeBytesAvailableToCaller for Windows) instead of f_bfree to calculate used bytes\",\"remark\":\"Maybe required for macOS to print correct results\",\"arg\":{\"type\":\"bool\",\"optional\":true,\"default\":false}},{\"long\":\"diskio-detect-total\",\"desc\":\"Detect total bytes instead of current rate\",\"arg\":{\"type\":\"bool\",\"default\":false}},{\"long\":\"diskio-name-prefix\",\"desc\":\"Show disks with given name prefix only\",\"arg\":{\"type\":\"str\"}},{\"long\":\"diskio-wait-time\",\"desc\":\"Set the wait time (in ms) when detecting disk usage\",\"arg\":{\"type\":\"num\",\"default\":1000}},{\"long\":\"physicaldisk-name-prefix\",\"desc\":\"Show disks with given name prefix only\",\"arg\":{\"type\":\"str\"}},{\"long\":\"physicaldisk-temp\",\"desc\":\"Detect and display SSD temperature if supported\",\"arg\":{\"type\":\"bool\",\"optional\":true,\"default\":false}},{\"long\":\"bluetooth-show-disconnected\",\"desc\":\"Set if disconnected bluetooth devices should be printed\",\"arg\":{\"type\":\"bool\",\"optional\":true,\"default\":false}},{\"long\":\"packages-disabled\",\"desc\":\"A colon separated list of package managers to be disabled when detecting\",\"remark\":[\"Some detection methods can be very slow.\",\"You may need to increase value of '--processing-timeout' to make it actually work.\",\"Use `--packages-disabled none` to enable all.\"],\"arg\":{\"type\":\"string\",\"default\":\"winget\"}},{\"long\":\"display-compact-type\",\"desc\":\"Set if all displays should be printed in one line\",\"arg\":{\"type\":\"enum\",\"enum\":{\"none\":\"Disable this compact mode\",\"original\":\"Print original resolutions\",\"scaled\":\"Print scaled resolutions\",\"original-with-refresh-rate\":\"Print original resolutions with refresh rate\",\"scaled-with-refresh-rate\":\"Print scaled resolutions with refresh rate\"},\"default\":\"none\"}},{\"long\":\"display-precise-refresh-rate\",\"desc\":\"Set if decimal refresh rates should not be rounded into integers when printing\",\"arg\":{\"type\":\"bool\",\"optional\":true,\"default\":false}},{\"long\":\"display-order\",\"desc\":\"Set the order should be used when printing displays\",\"arg\":{\"type\":\"enum\",\"enum\":{\"none\":\"Use the detected order\",\"asc\":\"Sort by display name ascendingly\",\"desc\":\"Sort by display name descendingly\"},\"default\":\"none\"}},{\"long\":\"brightness-ddcci-sleep\",\"desc\":\"Set the sleep times (in ms) when sending DDC/CI requests\",\"remark\":\"See <https://www.ddcutil.com/performance_options/#option-sleep-multiplier> for detail\",\"arg\":{\"type\":\"num\",\"default\":10}},{\"long\":\"brightness-compact\",\"desc\":\"Set if multiple results should be printed in one line\",\"arg\":{\"type\":\"bool\",\"default\":false}},{\"long\":\"sound-type\",\"desc\":\"Set what type of sound devices should be printed\",\"arg\":{\"type\":\"enum\",\"enum\":{\"main\":\"Print only main sound devices\",\"active\":\"Print only active sound devices\",\"all\":\"Print all sound devices\"},\"default\":\"main\"}},{\"long\":\"battery-use-setup-api\",\"desc\":\"Set if \\\"SetupAPI\\\" should be used on Windows to detect battery info\",\"remark\":[\"SetupAPI supports multi batteries, but slower.\",\"Windows only\"],\"arg\":{\"type\":\"bool\",\"optional\":true,\"default\":false}},{\"long\":\"cpu-temp\",\"desc\":\"Detect and display CPU temperature if supported\",\"arg\":{\"type\":\"bool\",\"optional\":true,\"default\":false}},{\"long\":\"cpu-show-pe-core-count\",\"desc\":\"Detect and display CPU frequency of different core types (eg. Pcore and Ecore) if supported\",\"arg\":{\"type\":\"bool\",\"optional\":true,\"default\":false}},{\"long\":\"cpucache-compact\",\"desc\":\"Show all CPU caches in one line\",\"arg\":{\"type\":\"bool\",\"optional\":true,\"default\":false}},{\"long\":\"cpuusage-separate\",\"desc\":\"Display CPU usage per CPU logical core, instead of an average result\",\"arg\":{\"type\":\"bool\",\"optional\":true,\"default\":false}},{\"long\":\"cpuusage-wait-time\",\"desc\":\"Set the wait time (in ms) when detecting CPU usage\",\"arg\":{\"type\":\"num\",\"default\":200}},{\"long\":\"de-slow-version-detection\",\"desc\":\"Set if DE version should be detected with slow operations\",\"remark\":[\"It's only used as a fallback method. Please file a bug report if you encounter any issues.\",\"Linux only\"],\"arg\":{\"type\":\"bool\",\"optional\":true,\"default\":false}},{\"long\":\"gpu-temp\",\"desc\":\"Detect and display GPU temperature if supported\",\"arg\":{\"type\":\"bool\",\"optional\":true,\"default\":false}},{\"long\":\"gpu-driver-specific\",\"desc\":\"Use driver specific method to detect more detailed GPU information (memory usage, core count, etc)\",\"remark\":[\"Correctly NVML (NVIDIA) and IGCL (Intel, Windows only) are supported.\",\"Both require the latest proprietary driver to be installed.\"],\"arg\":{\"type\":\"bool\",\"optional\":true,\"default\":false}},{\"long\":\"gpu-detection-method\",\"desc\":\"Force using a specified method to detect GPUs\",\"remark\":\"Will fall back to next methods if the specified method fails\",\"arg\":{\"type\":\"enum\",\"enum\":{\"auto\":\"Query platform specific graphic APIs. Requires proper GPU drivers installed. Not supported on FreeBSD\",\"pci\":\"Search PCI devices, which do not requires GPU driver installed. Not supported on Windows and macOS\",\"vulkan\":\"Use Vulkan API. Slow and requires proper vulkan driver installed. Used for Android\",\"opencl\":\"Use OpenCL API. Slow and requires proper OpenCL driver installed\",\"opengl\":\"Use OpenGL API. Slow and only detects one GPU\"},\"default\":\"auto\"}},{\"long\":\"gpu-hide-type\",\"desc\":\"Specify the type of GPUs should not be printed\",\"arg\":{\"type\":\"enum\",\"enum\":{\"integrated\":\"Hide integrated GPUs\",\"discrete\":\"Hide discrete GPUs\",\"none\":\"Do not hide any GPUs\"},\"default\":\"none\"}},{\"long\":\"battery-temp\",\"desc\":\"Detect and display Battery temperature if supported\",\"arg\":{\"type\":\"bool\",\"optional\":true,\"default\":false}},{\"long\":\"loadavg-ndigits\",\"desc\":\"Set the number of digits to keep after the decimal point when printing load average\",\"arg\":{\"type\":\"num\",\"default\":2}},{\"long\":\"loadavg-compact\",\"desc\":\"Show load average values in one line\",\"arg\":{\"type\":\"bool\",\"optional\":true,\"default\":true}},{\"long\":\"localip-show-ipv4\",\"desc\":\"Show IPv4 addresses in local ip module\",\"arg\":{\"type\":\"bool\",\"optional\":true,\"default\":true}},{\"long\":\"localip-show-ipv6\",\"desc\":\"Show IPv6 addresses in local ip module\",\"arg\":{\"type\":\"bool\",\"optional\":true,\"default\":false}},{\"long\":\"localip-show-mac\",\"desc\":\"Show mac addresses in local ip module\",\"arg\":{\"type\":\"bool\",\"optional\":true,\"default\":false}},{\"long\":\"localip-show-loop\",\"desc\":\"Show loop back addresses (127.0.0.1) in local ip module\",\"arg\":{\"type\":\"bool\",\"optional\":true,\"default\":false}},{\"long\":\"localip-show-mtu\",\"desc\":\"Show net interface's MTU (Maximum Transmission Unit) size in bytes\",\"arg\":{\"type\":\"bool\",\"optional\":true,\"default\":false}},{\"long\":\"localip-show-speed\",\"desc\":\"Show net interface's link speed with human-readable format (or an 1Mb units integer in JSON format)\",\"arg\":{\"type\":\"bool\",\"optional\":true,\"default\":false}},{\"long\":\"localip-show-prefix-len\",\"desc\":\"Show network prefix length (/N) in local ip module\",\"arg\":{\"type\":\"bool\",\"optional\":true,\"default\":true}},{\"long\":\"localip-name-prefix\",\"desc\":\"Show interfaces with given interface name prefix only\",\"arg\":{\"type\":\"str\"}},{\"long\":\"localip-default-route-only\",\"desc\":\"Show the interface that is used for default routing only\",\"remark\":\"Doesn't work on Android\",\"arg\":{\"type\":\"bool\",\"optional\":true,\"default\":true}},{\"long\":\"localip-show-all-ips\",\"desc\":\"Show all IPs bound to the same interface. By default only the first IP is shown\",\"arg\":{\"type\":\"bool\",\"optional\":true,\"default\":false}},{\"long\":\"localip-show-flags\",\"desc\":\"Show net interface flags in local ip module\",\"arg\":{\"type\":\"bool\",\"optional\":true,\"default\":false}},{\"long\":\"localip-compact\",\"desc\":\"Show all IPs in one line\",\"arg\":{\"type\":\"bool\",\"optional\":true,\"default\":false}},{\"long\":\"dns-show-type\",\"desc\":\"Specify the type of DNS servers should be detected\",\"arg\":{\"type\":\"enum\",\"enum\":{\"ipv4\":\"Show IPv4 addresses only\",\"ipv6\":\"Show IPv6 addresses only\",\"both\":\"Show both IPv4 and IPv6 addresses\"},\"default\":\"both\"}},{\"long\":\"netio-name-prefix\",\"desc\":\"Show interfaces with given name prefix only\",\"arg\":{\"type\":\"str\"}},{\"long\":\"netio-default-route-only\",\"desc\":\"Show the interfac that is used for default routing only\",\"remark\":\"Doesn't work on Android\",\"arg\":{\"type\":\"bool\",\"optional\":true,\"default\":true}},{\"long\":\"netio-detect-total\",\"desc\":\"Detect total bytes instead of current rate\",\"arg\":{\"type\":\"bool\",\"default\":false}},{\"long\":\"netio-wait-time\",\"desc\":\"Set the wait time (in ms) when detecting network usage\",\"arg\":{\"type\":\"num\",\"default\":1000}},{\"long\":\"publicip-timeout\",\"desc\":\"Time in milliseconds to wait for the public ip server to respond\",\"remark\":\"0 to disable timeout\",\"arg\":{\"type\":\"num\",\"default\":0}},{\"long\":\"publicip-url\",\"desc\":\"The URL of public IP detection server to be used\",\"arg\":{\"type\":\"str\"}},{\"long\":\"publicip-ipv6\",\"desc\":\"Whether to use IPv6 for public IP detection server\",\"arg\":{\"type\":\"bool\",\"default\":false}},{\"long\":\"weather-location\",\"desc\":\"Set the location to be used\",\"remark\":\"Must be URI encoded (e.g. a whitespace must be encoded as \\\"+\\\")\",\"arg\":{\"type\":\"str\"}},{\"long\":\"weather-timeout\",\"desc\":\"Time in milliseconds to wait for the weather server to respond\",\"remark\":\"0 to disable timeout\",\"arg\":{\"type\":\"num\",\"default\":0}},{\"long\":\"weather-output-format\",\"desc\":\"The output weather format to be used\",\"remark\":\"Must be URI encoded\",\"arg\":{\"type\":\"str\"}},{\"long\":\"wm-detect-plugin\",\"desc\":\"Set if window manager plugin should be detected on supported platforms\",\"arg\":{\"type\":\"bool\",\"optional\":true,\"default\":false}},{\"long\":\"users-compact\",\"desc\":\"Show all active users in one line\",\"arg\":{\"type\":\"bool\",\"optional\":true,\"default\":false}},{\"long\":\"users-myself-only\",\"desc\":\"Show only current user\",\"arg\":{\"type\":\"bool\",\"optional\":true,\"default\":false}},{\"long\":\"player-name\",\"desc\":\"The name of the player to use for module Media and Player\",\"remark\":\"Linux only\",\"arg\":{\"type\":\"str\"}},{\"long\":\"opengl-library\",\"desc\":\"Set the OpenGL context creation library to use\",\"arg\":{\"type\":\"enum\",\"enum\":{\"auto\":\"Auto detection\",\"egl\":\"EGL\",\"glx\":\"GLX\",\"osmesa\":\"OSMesa\"},\"default\":\"auto\"}},{\"long\":\"command-shell\",\"desc\":\"Set the shell program to execute the command text\",\"arg\":{\"type\":\"str\",\"default\":\"\\\"cmd\\\" for Windows; \\\"/bin/sh\\\" for *nix\"}},{\"long\":\"command-param\",\"desc\":\"Set the parameter used when starting the shell\",\"remark\":\"If set to empty string, it will be ignored\",\"arg\":{\"type\":\"str\",\"default\":\"\\\"/c\\\" for Windows; \\\"-c\\\" for *nix\"}},{\"long\":\"command-key\",\"desc\":\"Set the module key to display\",\"arg\":{\"type\":\"str\"}},{\"long\":\"command-text\",\"desc\":\"Set the command text to be executed\",\"arg\":{\"type\":\"str\"}},{\"long\":\"colors-symbol\",\"desc\":\"Set the symbol to be printed by Colors module\",\"arg\":{\"type\":\"enum\",\"enum\":{\"block\":\"\\u2588\\u2588\\u2588\",\"background\":\"(whitespaces with background)\",\"circle\":\"\\u25cf\",\"diamond\":\"\\u25c6\",\"triangle\":\"\\u25b2\",\"square\":\"\\u25a0\",\"star\":\"\\u2605\"},\"default\":\"background\"}},{\"long\":\"colors-padding-left\",\"desc\":\"Set the number of white spaces to print before the symbol\",\"arg\":{\"type\":\"num\",\"default\":0}},{\"long\":\"colors-block-width\",\"desc\":\"Set the block width in spaces\",\"arg\":{\"type\":\"num\",\"default\":3}},{\"long\":\"colors-block-range-start\",\"desc\":\"Set the start range of colors in the blocks to print\",\"remark\":[\"Display colors 0-15 in the blocks. (16 colors)\",\"Display colors 0-7 in the blocks. (8 colors)\",\"Only works for `--colors-symbol block`.\",\"Must be in range 0-15\",\"See also `--colors-range-end`\"],\"arg\":{\"type\":\"num\",\"default\":0}},{\"long\":\"colors-block-range-end\",\"desc\":\"Set the end range of colors in the blocks to print\",\"remark\":[\"Display colors 0-15 in the blocks. (16 colors)\",\"Display colors 0-7 in the blocks. (8 colors)\",\"Only works for `--colors-symbol block`.\",\"Must be in range 0-15\",\"See also `--colors-range-start`\"],\"arg\":{\"type\":\"num\",\"default\":15}}],\"General module\":[{\"long\":\"<module>-format\",\"desc\":[\"Set the format string to use for each specific module\",\"To see how a format string works, use \\\"fastfetch -h format\\\".\",\"To see help about a specific format string, use \\\"fastfetch -h <module>-format\\\"\"],\"arg\":{\"type\":\"format\"},\"pseudo\":true},{\"long\":\"<module>-key\",\"desc\":[\"Set the key to use for each specific module.\",\"For modules which print multiple lines, the string is parsed\",\"as a format string with the index as first character\"],\"arg\":{\"type\":\"key\"},\"pseudo\":true},{\"long\":\"<module>-key-color\",\"desc\":\"Override the global \\\"--color-keys\\\" option for each specific module\",\"arg\":{\"type\":\"color\"},\"pseudo\":true},{\"long\":\"<module>-key-icon\",\"desc\":\"Set the icon to be displayed by \\\"--key-type icon\\\"\",\"arg\":{\"type\":\"string\"},\"pseudo\":true},{\"long\":\"<module>-output-color\",\"desc\":\"Override the global \\\"--color-output\\\" option for each specific module\",\"arg\":{\"type\":\"color\"},\"pseudo\":true},{\"long\":\"<module>-key-width\",\"desc\":\"Override the global \\\"--key-width\\\" option for each specific module\",\"arg\":{\"type\":\"num\"},\"pseudo\":true},{\"long\":\"<module>-percent-green\",\"desc\":[\"Threshold of percentage colors\",\"Value less then percent-green will be shown in green\"],\"arg\":{\"type\":\"num\"},\"pseudo\":true},{\"long\":\"<module>-percent-yellow\",\"desc\":[\"Threshold of percentage colors\",\"Value greater than percent-green and less then yellow will be shown in yellow\",\"Value greater than percent-yellow will be shown in red\"],\"arg\":{\"type\":\"num\"},\"pseudo\":true},{\"long\":\"<module>-percent-type\",\"desc\":\"Set the percentage output type\",\"remark\":[\"0 for use global `--percent-type` value\",\"1 for percentage number\",\"2 for multi-color bar\",\"3 for both\",\"6 for bar only\",\"9 for colored number\",\"10 for monochrome bar\"],\"arg\":{\"type\":\"num\",\"default\":0},\"pseudo\":true},{\"long\":\"<module>-temp-green\",\"desc\":[\"Threshold of temperature colors\",\"Value less then temp-green will be shown in green\"],\"arg\":{\"type\":\"num\"},\"pseudo\":true},{\"long\":\"<module>-temp-yellow\",\"desc\":[\"Threshold of temperature colors\",\"Value greater than temp-green and less then yellow will be shown in yellow\",\"Value greater than temp-yellow will be shown in red\"],\"arg\":{\"type\":\"num\"},\"pseudo\":true}]}"
#define FASTFETCH_DATATEXT_STRUCTURE "Title:Separator:OS:Host:Kernel:Uptime:Packages:Shell:Display:DE:WM:WMTheme:Theme:Icons:Font:Cursor:Terminal:TerminalFont:CPU:GPU:Memory:Swap:Disk:LocalIp:Battery:PowerAdapter:Locale:Break:Colors"
#define FASTFETCH_DATATEXT_HELP_FOOTER "Parsing is not case sensitive. E.g. \"--lib-PCI\" is equal to \"--Lib-Pci\"\nIf a value starts with a ?, it is optional. An optional boolean value defaults to true if not specified.\nMore detailed help messages for each options can be printed with \"-h <option_without_dash_prefix>\"\nAll options can be made permanent with command \"fastfetch <options> --gen-config\""
#define FASTFETCH_DATATEXT_HELP_COLOR "Usage: fastfetch --color <color>\n\nShortcut of `fastfetch --color-keys <color> --color-title <color>`.\nIf no color is set, the main color of the logo will be used.\n\nFollowing information applies to all settings\n\n<color> must be a color encoding as ANSI escape sequences. It is inserted between \"ESC[\" and \"m\".\nInfos about them can be found here: https://en.wikipedia.org/wiki/ANSI_escape_code#SGR_(Select_Graphic_Rendition)_parameters.\nExamples:\n   35:              sets the color to magenta\n   38;5;38:         sets the color to 38th color of ANSI 256 colors\n   4;92:            sets the color to bright green with underline\n   5;104:           blinking text on a blue background\n\nANSI named colors are also supported:\n   magenta:         equivalent to `35`\n   underline_bright_green: equivalent to `4;92`\n\nAfter v2.15.0, some special keys can be used:\n   keys:            use the color set by `--color-keys`\n   title:           use the color set by `--color-title`\n   output:          use the color set by `--color-output`\n   separator:       use the color set by `--color-separator`"
#define FASTFETCH_DATATEXT_HELP_FORMAT "A format string is a string that contains placeholders for values.\nThese placeholders begin with a '{', containing the index of the value, and end with a '}'.\nFor example the format string \"Values: {1} ({2})\", with the values \"First\" and \"My second val\", will produce \"Values: First (My second val)\".\nThe format string can contain placeholders in any order and have multiple occurrences.\nTo include spaces when setting from the command line, surround the whole string with double quotes (\").\n\nIn 2.14.0 or newer, the value indices can be meaningful named tags.\nFor example: \"--title-format '{user-name-colored}{at-symbol-colored}{host-name-colored}'\" is equivalent to \"--title-format '{6}{7}{8}'\"\nSee \"fastfetch -h title-format\" for all supported tags.\n\nIn 2.17.0 or newer, a truncation length can be specified using syntax '<arg>:<trunc-length>`\nFor example: \"--title-format '{user-name:5}'\" will truncate user name into 5-length string.\nIf '<trunc-length>' is negative, an ellipsis … will be appended at the end when the original string is truncated.\nNote: The string length is counted in raw bytes. Multi-byte unicode characters and ANSI escape codes are not taken into account.\n\nIn 2.23.0 or newer, `<` or `>` can be specified instead of `:` to set a left or right padding.\nFor example: \"--title-format '{user-name<20}'\" will generate `<user-name>         `;\n\"--title-format '{user-name>20}'\" will generate `         <user-name>`\n\nIn 2.24.0 or newer, `{~startIndex,endIndex}` can be specified to slice a string. Negative index counts back from the end of the string.\nIf an index is omitted, 0 is used. For example, both `{~,0}` `{~0,}` and `{~,}` are same as `{~0,0}` and will always generate a empty string.\nIf `,endIndex` is omitted or greater than the length of the string, the length of string is used.\n\nIf the value index is missing, meaning the placeholder is \"{}\", an internal counter sets the value index.\nThis means that the format string \"Values: {1} ({2})\" is equivalent to \"Values: {} ({})\".\nNote that this counter only counts empty placeholders, so the format string \"{2} {} {}\" will contain the second value, then the first, and then the second again.\n\nTo make formatting easier, a double open curly brace (\"{{\") will be printed as a single open curly brace and not counted as the beginning of a placeholder.\nIf a value index is misformatted or wants a non-existing value, it will be printed as is, with the curly braces around it.\nIf the last placeholder isn't closed, it will be treated like it was at the end of the format string.\n\nTo only print something if a variable is set, use \"{?<index>} ... {?}\".\nFor example, to only print a second value if it is set, use \"{?2} Second value: {2}{?}\".\nIf a \"{?}\" is found without an opener, it is printed as is.\n\nTo only print something if a variable is not set, do the same as with if, just replace every '?' with a '/'.\nFor example to print a fallback for a second value if it is not set, use \"{?2}{2}{?}{/2}Second value fallback{/}\".\n\nTo stop formatting at any point in the format string, use \"{-}\".\n\nTo print something with color, start a placeholder with a '#' and then the linux terminal color encoding.\n\"\\033[\" at the start, and an 'm' at the end is automatically added, so don't do that.\nA \"{#}\" is equivalent to a \"{#0}\" and resets everything to normal.\nFor example to print something pink and underline, use \"{#4;35}...{#}\". \"{#underline_magenta}\" is also supported. See `fastfetch -h color` for detail.\nInformation about what the numbers mean can be found here: https://en.wikipedia.org/wiki/ANSI_escape_code#SGR_(Select_Graphic_Rendition)_parameters.\nWhich escape codes are supported and how they look is defined by your terminal.\n\nIf a format string evaluates to an empty value, the whole line in the output will be discarded.\nYou can therefore use --host-format \" \" to disable host output.\nNote that --host-format \"\" would evaluate as not set, and therefore use the built-in host format\n\nFormat string is also the way to go to set a fixed value - just use one without placeholders.\nFor example when running in headless mode, you could use \"--display-format Preferred\"."
#define FASTFETCH_DATATEXT_HELP_CONFIG 
