const Applet = imports.ui.applet;
const PopupMenu = imports.ui.popupMenu;
const Util = imports.misc.util;
const GLib = imports.gi.GLib;
const Lang = imports.lang;
const Gettext = imports.gettext;

Gettext.bindtextdomain("firewall-applet", "/usr/share/cinnamon/applets/firewall-applet@maik3531/locale");
function _(str) {
    return Gettext.dgettext("firewall-applet", str);
}

function FirewallApplet(orientation, panelHeight, instanceId) {
    this._init(orientation, panelHeight, instanceId);
}

FirewallApplet.prototype = {
    __proto__: Applet.IconApplet.prototype,

    _init: function(orientation, panelHeight, instanceId) {
        Applet.IconApplet.prototype._init.call(this, orientation, panelHeight, instanceId);

        // Setze Standard-Icon und Tooltip
        this.set_applet_icon_symbolic_name("security-low");
        this.set_applet_tooltip(_("Firewall is INACTIVE (Click to open menu)"));

        // Erstelle Popup-Menü
        this.menuManager = new PopupMenu.PopupMenuManager(this);
        this.menu = new Applet.AppletPopupMenu(this, orientation);
        this.menuManager.addMenu(this.menu);

        // Menüeintrag 1: Firewall konfigurieren (öffnet GUFW)
        let menuItem1 = new PopupMenu.PopupMenuItem(_("Configure Firewall"));
        menuItem1.connect('activate', () => {
            Util.spawn(["gufw"]);
        });
        this.menu.addMenuItem(menuItem1);

        // Menüeintrag 2: Dynamischer Eintrag: Toggle Firewall
        this.toggleItem = new PopupMenu.PopupMenuItem(_("Toggle Firewall"));
        this.toggleItem.connect('activate', () => {
            this._toggleFirewall();
        });
        this.menu.addMenuItem(this.toggleItem);

        // Status initial abfragen und periodisch aktualisieren
        this._updateStatus();
        this._timeout = GLib.timeout_add_seconds(GLib.PRIORITY_DEFAULT, 10, () => {
            this._updateStatus();
            return GLib.SOURCE_CONTINUE;
        });
    },

    on_applet_clicked: function(event) {
        this.menu.toggle();
    },

    _toggleFirewall: function() {
        Util.spawn_async(
            ["pkexec", "bash", "-c", "if /usr/sbin/ufw status | grep -qi 'Status: active'; then /usr/sbin/ufw disable; else /usr/sbin/ufw enable; fi"],
            () => {
                GLib.timeout_add_seconds(GLib.PRIORITY_DEFAULT, 1, () => {
                    this._updateStatus();
                    return GLib.SOURCE_REMOVE;
                });
            }
        );
    },

    _updateStatus: function() {
        Util.spawn_async(
            ["bash", "-c", "grep '^ENABLED=' /etc/ufw/ufw.conf"],
            (stdout) => {
                let line = stdout.trim();
                if (line.includes("yes")) {
                    this.set_applet_icon_symbolic_name("security-high");
                    this.set_applet_tooltip(_("Firewall is ACTIVE (Click to open menu)"));
                    if (this.toggleItem && this.toggleItem.label)
                        this.toggleItem.label.text = _("Deactivate Firewall");
                } else {
                    this.set_applet_icon_symbolic_name("security-low");
                    this.set_applet_tooltip(_("Firewall is INACTIVE (Click to open menu)"));
                    if (this.toggleItem && this.toggleItem.label)
                        this.toggleItem.label.text = _("Activate Firewall");
                }
            }
        );
    },

    on_applet_removed_from_panel: function() {
        if (this._timeout) {
            GLib.source_remove(this._timeout);
        }
    },

    get_applet_info: function() {
        return _("Firewall Toggle Applet v1.0");
    }
};

function main(metadata, orientation, panelHeight, instanceId) {
    return new FirewallApplet(orientation, panelHeight, instanceId);
}