#!/usr/bin/python3

from pystray import Icon, Menu, MenuItem
from PIL import Image
from os import popen
import cairosvg
import io
import os
import gettext
import locale

base_dir = os.path.dirname(os.path.abspath(__file__))
locale_dir = os.path.join(base_dir, "locale") 

if os.getenv('LANG', '').startswith('de'):
    try:
        de_translation = gettext.translation(
            'guideos-tray', 
            localedir=locale_dir,
            languages=['de']
        )
        de_translation.install()
    except FileNotFoundError as e:
        print(f"Error loading translations: {e}")
        gettext.NullTranslations().install()
else:
    gettext.NullTranslations().install()

home = os.path.expanduser("~")
script_dir = os.path.dirname(os.path.abspath(__file__))
application_path = os.path.dirname(script_dir)

def svg_to_png(svg_path):
    # SVG in PNG umwandeln
    png_data = cairosvg.svg2png(url=svg_path)
    return Image.open(io.BytesIO(png_data))


def on_click(icon, item):
    if item.text == _("Quit"):
        icon.stop()

def open_primo(icon, item):
    if item.text == _("Open Primo"):
        popen("primo-di-tutto")

def open_ticket(icon, item):
    if item.text == _("Report Bug"):
        popen("guideos-ticket-tool")

def open_updater(icon, item):
    if item.text == _("Update System"):
        popen("guideos-updater")

# Menü erstellen
menu = Menu(
    MenuItem(_("Open Primo"), open_primo),
    MenuItem(_("Update System"), open_updater),
    MenuItem(_("Report Bug"), open_ticket),
)

# Bild laden

svg_path = f"{application_path}/guideos-tray/arch-updates-symbolic.svg"
icon_image = svg_to_png(svg_path)

# Tray-Icon erstellen
icon = Icon("MeinIcon", icon_image, _("Quick selection"), menu=menu)

# Starten
icon.run()
