"fileformat" is free software.

This program is distributed in the hope that it will be useful,
but without any warranty; without even the implied warranty of
merchantability or fitness for a particular purpose.

---

## fileformat

fileformat is a tool for detecting and identifying file formats.

**Official repositories**:

- [https://codeberg.org/os-18/fileformat](https://codeberg.org/os-18/fileformat)
- [https://gitlab.com/os-18/fileformat](https://gitlab.com/os-18/fileformat)

---

## Ready-made packages

See:  
[Download Page of OS-18](https://codeberg.org/os-18/os-18-docs/src/branch/master/OS-18_Packages.md)  

The page contains installation instructions for several packages, including `fileformat`.

---

## Build from source

### Preparing

Before building, you need to install a compiler for D
(this project supports compilers
[dmd](https://dlang.org/download.html#dmd),
[gdc](https://gdcproject.org/) and
[ldc2](https://github.com/ldc-developers/ldc/))

This project can be built with either dynamic or static linking
against [the Amalthea library](https://gitlab.com/os-18/amalthea).
Therefore, if you want to build this project from source,
you must first build and install Amalthea,
then return to these instructions.

### Compilation and installation

To create the executable file:

```
$ make
```

You can also specify a compiler:

```
$ make DC=gdc
```

Installation (by default, main directory is `/usr/local/`):

```
# make install
```

After installation, the program is ready to use.

The Makefile defines the following variables:

* `DESTDIR` — specifies the root directory for installing (empty by default);
* `PREFIX` — specifies the base directory, such as `usr/local` or `usr`.

The installation directory is defined as `$(DESTDIR)/$(PREFIX)` in the Makefile.

You can install the program files in any directory.
For example, to install into `$HOME/.local`:

```bash
make install DESTDIR=$HOME PREFIX=.local
```

To uninstall:

```
# make uninstall
```

If installed to a non-default location,
use the same paths when uninstalling:

```bash
make uninstall DESTDIR=$HOME PREFIX=.local
```

---

## Usage

```
fileformat <file> ... [-m|--mime] [--formats <directory>]
    Show format name, description and type
    (Audio, Video, Archives, etc.) for each specified file.
    If '-m' or '--mime' is specified, the program also displays
    the MIME type and its description.
    The '--formats' option specifies a directory containing JSON files
    that describe custom file formats.
```

---

## Feedback

Questions, suggestions, comments, or bug reports:

**tech.vindex@gmail.com**

You can also use the repository issue tracker.

---
