#! /usr/bin/env python
# -*- coding: utf-8 -*-

import MyRedis2410 as redis
import os
import sys
import time
import select
import UserDict
from struct import *
from signal import SIGTERM
import socket
#import redis
#import ast
#import colorama
#from colorama import Fore, Back, Style

#Parser and logging import
import ConfigParser
import logging
import logging.handlers
from optparse import OptionParser, Option

logger = logging.getLogger("BonjourGRID")

class Parser(OptionParser):
  """
  Parse all arguments.
  """
  def __init__(self, usage=None, version=None):
    """
    Initialize all possible options.
    """
    OptionParser.__init__(self, usage=usage, version=version,
                          option_list=[
                            Option("-l", "--log_file",
                                   help="The path to the log file used by the script.",
                                   type=str),
                            Option('-i', "--pid_file",
                                   help="The path to the pid file used by the script.",
                                   default="",
                                   type=str),
                            Option("-t", "--install_directory",
                                   help="The path to use as bonjourGrid source directory.",
                                   default="",
                                   type=str),
                            Option("-d", "--directory",
                                   help="The path to use as Current work directory.",
                                   default="",
                                   type=str),
                            Option("-w", "--master_wrapper",
                                   help="The path to BOINC/Condor Masters wrapper script.",
                                   default="",
                                   type=str),
                            Option("-v", "--verbose",
                                   default=False,
                                   action="store_true",
                                   help="Verbose output."),
                            Option("-c", "--console",
                                   default=False,
                                   action="store_true",
                                   help="Console output."),
                            Option("-s", "--server",
                                   action="store", dest='server',
                                   help="Redis-Server hostname or IP address."),
                            Option("-p", "--port",
                                   default=6379,
                                   action="store", dest='port',
                                   type=int, help="Server port."),
                            Option("-n", "--num_workers",
                                   default=1,
                                   action="store", dest='num_workers', type=int,
                                   help="Number of workers to find for the project."),
                          ])

  def check_args(self):
    """
    Check arguments
    """
    (options, args) = self.parse_args()
    if not options.server:
      self.error("Wrong arguments: Provide Redis-Server hostname or IP. Try -h option to display help")
    if not options.master_wrapper:
      self.error("Wrong arguments: Missing Condor/BOINC wrapper file. Try -h option to display help")    
    return options

class PolitiqueSelectionWorker:
  def __init__(self,name):
    PolitiqueSelectionWorker.__dict__['Politique']=PolitiqueSelectionWorker.__dict__[name]

  def Politique(self,mydict,mhz,ram,systeme,proc_num):
    print

  def Politique1(self,mydict,mhz,ram,systeme,proc_num):
    if(float(mydict["MHZ"]) >= float(mhz)):
      #MyWorkersDict[mydict["IP"]]=None
      MyWorkersDict[mydict["HOST"]]=mydict["HOST"]
      LastWorker.clear() # je reinitialise le dict
      LastWorker[mydict["HOST"]]=mydict["HOST"]

  def Politique2(self,mydict,mhz,ram,systeme,proc_num):
    if(float(mydict["Ram"]) >= float(ram)):
      MyWorkersDict["HOST"]=mydict["HOST"]
      LastWorker=mydict
    #print mydict, float(mhz),ram,systeme,proc_num, float(mydict["MHZ"])

#------------------------------------------------------------------------------
def MyConvert(i):
  return pack('h', i)[0]
#------------------------------------------------------------------------------
def fileExists(fichier):
  try:
    file(fichier)
    return True
  except:
    return False
#---------------------------------------------------------------------------
def DeleteFile(fichier):
  if fileExists(fichier):
    os.system('rm -f '+fichier)
    logger.info("[BG:SYS] the file --" + fichier + "-- is deleted")
  else:
    logger.warning("[BG:SYS] the file --" + fichier + "-- does not exist")

#------------------------------------------------------------------------------
def SetMypidInFile(fichier):
  pfile = open(fichier,"w")
  mypid=os.getpid()
  strpid=str(mypid)
  pfile.write(strpid)
  pfile.close()
#------------------------------------------------------------------------------
def DeletePoints(name):
  list=name.split('.')
  type=''
  for i in range(len(list)):
    type=type+list[i]
  return type
  #return '_'+type+'._tcp'
#------------------------------------------------------------------------------
def ReadFile(name):
  fd = open(name,"rb")
  data = fd.read().strip()
  fd.close()
  return data
#-----------------------------------------------------------------------
def SetStatus(hostname, data, servicetype):
  #r = redis.Redis(host='196.203.126.4', port=6379, db=0)
  r = redis.Redis(connection_pool=pool)
  r.publish(servicetype,data)
#-----------------------------------------------------------------------
def  RequestWorker(servicetype,data,r):
  #r = redis.Redis(connection_pool=pool)
  r.publish(servicetype,data)
  #print "Service=", servicetype, "Data= ",data

#-----------------------------------------------------------------------
def SearchWorkers(servicetype,Nbre,data,hostname,master,r,rr,b):

  logger.info("Your master is looking for Idle machines")
  oldlengh=len(MyWorkersDict.keys())-2  
  while Nbre>0:
    for msg in rr.listen():
      worker = msg['data']
      #print msg
      break
    mydict={}
    try:
      txtrecord=msg['data']
      #print txtrecord,"*********",len(txtrecord),"\n"
      mydict = UserDict.UserDict(eval(txtrecord)) # I record the machines that are idle in mydict
      #print "mydict is ", mydict
    except:
      logger.error("PB in ResolveCallback, it is not a dictionary")
    POL.Politique1(mydict,500,500,"Unix",1)
    if oldlengh != len(MyWorkersDict.keys())-1 :
      logger.info(LastWorker.keys()[0] + " -- is just discovered as Idle machine")
      LastWorkerType=DeletePoints(LastWorker.keys()[0])
      RequestWorker(LastWorkerType,data,r)
      logger.info(LastWorker.keys()[0] + " -- is requested for working")
      pid=os.fork()
      if pid==0:        
        service=hostname+"-master"
        CheckWorkers(service,Nbre,b)
        exit(0)
#      else:
        #XXX: verifier la réponse du Worker ici!!
 #       pass
    oldlengh=len(MyWorkersDict.keys())-1
    Nbre=Nbre-1
  return Nbre
#--------------------------------------------------------------------------
def CheckWorkers(master,Nbre,b):

  logger.info("Checking if the requested Idle machine is reserved by your Master")
  oldlengh=len(MyWorkersDict.keys())-2
  logger.info("I'm waiting the confirmation of worker "+LastWorker.keys()[0])
  for msg in b.listen():
    worker = msg['data']
    #print msg,"conffffffffffffffffffffffffffffffffffffffff"
    break
  mydict={}
  try:
    txtrecord=msg['data']
    mydict = UserDict.UserDict(eval(txtrecord))
  except:
    logger.error("PB in ResolveCallback, it is not a dictionary")    
  
  if len(mydict.keys())!=0 :
    logger.info(LastWorker.keys()[0] + " -- has accepted to work for you")
    logger.info("New Worker :" + LastWorker.keys()[0])
    #break
  #else:
   #   while waitingtime!=0:
    #    waitingtime= waitingtime-1
     # sys.exit()
#--------------------------------------------------------------------------

def setArguments():
  usage = "usage: %s [options]" % sys.argv[0]
  parser = Parser(usage=usage).check_args()
  logger.setLevel(logging.INFO)
  if parser.console:
    console_handler = logging.StreamHandler()
    console_handler.setFormatter(logging.Formatter("%(name)s - %(levelname)s - %(message)s"))
    logger.addHandler(console_handler)
  if parser.log_file:
    if not os.path.isdir(os.path.dirname(parser.log_file)):
      # fallback to console only if directory for logs does not exists and
      # continue to run
      raise ValueError('Please create directory %r to store %r log file' % (
        os.path.dirname(parser.log_file), parser.log_file))
    else:
      file_handler = logging.FileHandler(parser.log_file)
      file_handler.setFormatter(logging.Formatter("%(asctime)s - %(name)s - %(levelname)s - %(message)s"))
      logger.addHandler(file_handler)
      logger.info('Configured logging to file %r' % parser.log_file)
  if parser.pid_file:
    if not os.path.isdir(os.path.dirname(parser.pid_file)):
      raise ValueError('Please create directory %r to store %r pid file' % (
        os.path.dirname(parser.pid_file), parser.pid_file))
    else:
      open(parser.pid_file, 'w').write(str(os.getpid()))
  if not os.path.exists(parser.master_wrapper):
    raise ValueError('File not found: Cannot open file "%s"' %
                     parser.master_wrapper)
  if parser.directory:
    if not os.path.isdir(parser.directory):
      raise ValueError('Please create directory %r to store local files' % (
        parser.directory))
    else:
      os.chdir(parser.directory)
  if not parser.install_directory:
      parser.install_directory = os.getcwd()
  return parser

if __name__ == '__main__':

  parser = setArguments()
  MyWorkersDict={}
  LastWorker={}

  logger.info("Automatic generation of the machine features.")
  hostname = socket.gethostname()
  os.system('sh %s' % os.path.join(parser.install_directory, 'machineinfo.sh'))
  NbreWorkers = parser.num_workers
  logger.info("Establishing connection to redis server at: %s" % parser.server)
  pool = redis.ConnectionPool(host=parser.server, port=parser.port, db=0)
  POL=PolitiqueSelectionWorker('Politique1')

  data=ReadFile(hostname)

  namecoord=DeletePoints(hostname)
  workers = []
  r= redis.Redis(connection_pool=pool)
  rr=r.pubsub()
  rr.subscribe('idle')
  b=r.pubsub()
  b.subscribe(namecoord+"-master")
  pid=os.fork()
  if pid==0:
    # Demarrage du coordinateur
    logger.info("(STATUS=MASTER) Your machine is a Master Now")
    logger.info("[BG:STAT] master : %s" % hostname)
    os.system("echo 'master' >> %r" % os.path.join(os.getcwd(), 'occupied'))
    if parser.master_wrapper:      
      os.system(parser.master_wrapper)
    sys.exit(0)
  else:
    logger.info("Parent waiting for child process %s..." % pid)
    try:
      os.waitpid(pid, 0)
    except:
      pass
    logger.info("Done, got to next operation:")
    logger.info("1- Search idle machines...")
    logger.info("2- Send confirmation for working to discovred idle machines...")
    logger.info("3- Check Confirmation")
    master = namecoord+'-master'
    NbreWorkers=SearchWorkers("idle",NbreWorkers, data, hostname,master,r,rr,b)
    if NbreWorkers==0 :
      logger.info("Lucky: All requested machines are workers for your Master")
    else:
      logger.info("Unlucky: %s machines was reserved by another Master" % NbreWorkers)
    logger.info("Waiting until application execution will be finished")
    time.sleep(5)
    os.system('touch finished')
    if fileExists('finished'):
      logger.info("Lucky: Application is finished. I will tell my workers to disconnect")
      type=hostname+"app-finished"
      SetStatus(hostname,data, type)
      sys.exit(0)
