/*
Copyright (c) 2014 Nexedi SA

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/
#include <stdint.h>

/* Soft limit to protect against misbehaviour,
 * but feel free to increase it if needed. */
#define CTL_MAX_SIZE 65536

#define CTL_VERSION 1

#define CTL_MSG_DUMP       1
#define CTL_MSG_SET_COST_MULTIPLIER   2

#define CTL_DUMP_INTERFACE  (1 << 0)
#define CTL_DUMP_NEIGHBOUR  (1 << 1)
#define CTL_DUMP_XROUTE     (1 << 2)
#define CTL_DUMP_ROUTE(x)   (x >> 3 & 3)
#define CTL_DUMP_ROUTE_NONE      0
#define CTL_DUMP_ROUTE_INSTALLED 1
#define CTL_DUMP_ROUTE_FEASIBLE  2
#define CTL_DUMP_ROUTE_ALL       3

#define CTL_ROUTE_INSTALLED (1 << 0)
#define CTL_ROUTE_FEASIBLE  (1 << 1)

struct ctl_buffer {
    char *data;
    size_t size;
    size_t end;
};

struct ctl_dump_neighbour {
    uint8_t address[16];
    uint32_t ifindex;
    uint16_t reach;
    uint16_t rxcost;
    uint16_t txcost;
    uint16_t rtt;
    uint16_t rttcost;
    int32_t channel;
    uint16_t if_up;
    uint16_t cost_multiplier;
} __attribute__((packed));


struct ctl_dump_route {
    uint8_t prefix[16];
    uint8_t plen;
    uint16_t metric;
    uint16_t smoothed_metric;
    uint16_t refmetric;
    uint8_t id[8];
    int32_t seqno;
    int32_t age;
    uint32_t ifindex;
    uint8_t neigh_address[16];
    uint8_t nexthop[16];
    uint8_t flags;
} __attribute__((packed));

struct ctl_dump_xroute {
    uint8_t prefix[16];
    uint8_t plen;
    uint16_t metric;
} __attribute__((packed));


struct ctl {
    struct ctl *next;
    int fd;
    struct ctl_buffer buffer_out;
    struct ctl_buffer buffer_in;
    size_t write;
    unsigned initialized:1;
};

extern const char *control_socket_path;
extern struct ctl *ctl_connection;

int init_control_socket();
void accept_ctl_connection(int fd);
void ctl_read(struct ctl *ctl);
void ctl_write(struct ctl *ctl);
